/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dx_sprite.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:30:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _DXCANVAS_SPRITE_HXX
#define _DXCANVAS_SPRITE_HXX

#ifndef _RTL_REF_HXX_
#include <rtl/ref.hxx>
#endif

#ifndef _COM_SUN_STAR_RENDERING_XCANVAS_HPP_
#include <com/sun/star/rendering/XCanvas.hpp>
#endif

#ifndef _BGFX_POINT_B2DPOINT_HXX
#include <basegfx/point/b2dpoint.hxx>
#endif
#ifndef _BGFX_VECTOR_B2DSIZE_HXX
#include <basegfx/vector/b2dsize.hxx>
#endif

namespace dxcanvas
{
	/* Definition of Sprite class */
    
    /** Helper interface to connect SpriteCanvas with various
        sprite implementations. 
    */

    class Sprite : public ::com::sun::star::uno::XInterface
    {
    public:
        typedef ::rtl::Reference< Sprite > ImplRef;

        virtual ~Sprite() {}

        virtual void redraw( const DeviceSharedPtr& 	rTarget ) const = 0;
        virtual void redraw( const DeviceSharedPtr& 	rTarget, 
                             const ::basegfx::B2DPoint& rOutputPosition ) const = 0;

        virtual ::basegfx::B2DPoint getPos() const = 0;
        virtual ::basegfx::B2DSize 	getSize() const = 0;
    };
}

#endif /* _DXCANVAS_SPRITE_HXX */
