/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ImpressObjectBar.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:59:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "ImpressObjectBar.hxx"

#ifndef _SFXAPP_HXX
#include <sfx2/app.hxx>
#endif

#include <sfx2/objface.hxx>

#pragma hdrstop

#include "res_bmp.hrc"
#include "glob.hrc"

#include "DrawDocShell.hxx"
#ifndef SD_VIEW_SHELL_HXX
#include "ViewShell.hxx"
#endif
#ifndef SD_DRAW_VIEW_HXX
#include "drawview.hxx"
#endif
#include "sdresid.hxx"


namespace sd {

/*************************************************************************
|*
|* Standardinterface deklarieren (Die Slotmap darf nicht leer sein, also
|* tragen wir etwas ein, was hier (hoffentlich) nie vorkommt).
|*
\************************************************************************/

#define ShellClass ImpressObjectBar

SFX_SLOTMAP(ImpressObjectBar)
{
			{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
};

SFX_IMPL_INTERFACE(ImpressObjectBar, SfxShell, SdResId(STR_STDOBJECTBARSHELL))
{
	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT, SdResId(RID_DRAW_OBJ_TOOLBOX) );
}

TYPEINIT1( ImpressObjectBar, SfxShell );


/*************************************************************************
|*
|* Standard-Konstruktor
|*
\************************************************************************/

ImpressObjectBar::ImpressObjectBar (
    ViewShell* pSdViewShell,
    ::sd::View* pSdView)
    : SfxShell(pSdViewShell->GetViewShell())
{
	DrawDocShell* pDocShell = pSdViewShell->GetDocSh();
	SetPool(&pDocShell->GetPool());
	SetUndoManager(pDocShell->GetUndoManager());
	SetRepeatTarget(pSdView);
	SetHelpId( SD_IF_SDDRAWSTDOBJECTBAR );
	SetName( String( RTL_CONSTASCII_USTRINGPARAM( "ImpressObjectBar" )));
}


/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

ImpressObjectBar::~ImpressObjectBar()
{
	SetRepeatTarget(NULL);
}

} // end of namespace sd


