/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: pntobj3d.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 18:19:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _E3D_PNTOBJ3D_HXX
#define _E3D_PNTOBJ3D_HXX

#ifndef _E3D_OBJ3D_HXX
#include "obj3d.hxx"
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif


/*************************************************************************
|*
|* Klasse fuer einzelne dreidimensionale Punkte
|*
\************************************************************************/

class SVX_DLLPUBLIC E3dPointObj : public E3dObject
{
 protected:
	Vector3D	aPosition;
	Vector3D	aTransPos;

	sal_Bool	bTransPosValid	: 1;

	virtual void SetTransformChanged();

 public:
	TYPEINFO();
	E3dPointObj(const Vector3D& rPos);
	E3dPointObj();

	virtual UINT16 GetObjIdentifier() const;

	virtual void SetPosition(const Vector3D& rNewPos);
	const Vector3D& GetPosition() const { return aPosition; }
	const Vector3D& GetTransPosition();

	//BFS01virtual void WriteData(SvStream& rOut) const;
	//BFS01virtual void ReadData(const SdrObjIOHeader& rHead, SvStream& rIn);

	virtual void operator=(const SdrObject&);
};



#endif			// _E3D_PNTOBJ3D_HXX
