/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: itempath.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:42:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <string.h>

#include <fastfsunx.hxx>

#define PDATA ((String*)pData)

static String sDoubleSlash( "//" ), sSlash( "/" );

static void Verminator( String& rString )
{
	
	int nPos = 0;
	while( ( nPos = rString.SearchAndReplace( sDoubleSlash, sSlash, nPos ) )
		   != STRING_NOTFOUND )
		;
	if( rString.Len() > 1 )
		rString.EraseTrailingChars( '/' );
}

ItemIDPath::ItemIDPath() :
		pData( 0 )
{
}

ItemIDPath::~ItemIDPath()
{
	if( PDATA )
		delete PDATA;
}

ItemIDPath::ItemIDPath( SpecialFolderID eFolder ) :
		pData( 0 )
{
	switch( eFolder )
	{
		case FOLDER_DRIVES:
			pData = new String( VIRTUAL_DESKTOP_URL "/"  VIRTUAL_WORKPLACE_URL);
			break;
		case FOLDER_ROOT:
		case FOLDER_DESKTOP:
			pData = new String( VIRTUAL_DESKTOP_URL );
			break;
		case FOLDER_BOOKMARKS:
			pData = new String( VIRTUAL_DESKTOP_URL "/" VIRTUAL_BOOKMARKS_URL );
			break;
		default:;
	}
}

ItemIDPath::ItemIDPath( void* pNewData, size_t nBytes )
{
	pData = new String( (char*)pNewData, nBytes );
	Verminator( *PDATA );
}

ItemIDPath::ItemIDPath( const ItemIDPath& rPath ) :
		pData( NULL )
{
	if( rPath.pData )
	{
		pData = new String( *((String*)rPath.pData ) );
		Verminator( *PDATA );
	}
}

ItemIDPath::ItemIDPath( const String& rDescription, BOOL bIsFileDesc )
{
	int nPos = rDescription.Search( "://" );
	if( nPos != STRING_NOTFOUND )
		nPos += 3;
	else
		nPos = 0;
	pData = new String( rDescription.GetStr() + nPos,
						rDescription.Len()-nPos );
// 	if( nPos && (*PDATA)[0] != '/' )
// 		*PDATA = String( '/'  ) + *PDATA;
	Verminator( *PDATA );
}

ItemIDPath& ItemIDPath::operator=( const ItemIDPath& rPath )
{
	if( pData )
		delete PDATA;
	if( rPath.pData )
		pData = new String( *((String*)rPath.pData) );
	else pData = 0;

	return *this;
}

ItemIDPath& ItemIDPath::operator=( const String& rPath )
{
	if( pData )
		delete PDATA;

	if( ! rPath.Len() )
	{
		pData = 0;
		return *this;
	}

	int nPos = rPath.Search( "://" );
	if( nPos != STRING_NOTFOUND )
		nPos += 3;
	else
		nPos = 0;
	pData = new String( rPath.GetStr() + nPos, rPath.Len() - nPos );
// 	if( nPos && (*PDATA)[0] != '/' )
// 		// if this is an absolute URL it has to start with root
// 		*PDATA = sSlash + *PDATA;
	Verminator( *PDATA );
	
	return *this;
}

ItemIDPath& ItemIDPath::operator+=( const ItemIDPath& rPath )
{
	if( ! rPath.pData )
		return *this;

	if( ! pData )
		pData = new String( *((String*)rPath.pData) );
	else
	{
		if( (*(String*)rPath.pData)[0] == '/' )
			// new path is absolute
			*PDATA = *((String*)rPath.pData);
		else
		{
			*PDATA += '/';
			*PDATA += *((String*)rPath.pData);
		}
	}
	Verminator( *PDATA );
	return *this;
}

ItemIDPath ItemIDPath::operator+( const ItemIDPath& rPath ) const
{
	ItemIDPath aSum( *this );
	aSum += rPath;
	return aSum;
}

// laut HRO soll == nur String gleichheit testen
int ItemIDPath::operator==( const ItemIDPath& rPath ) const
{
	if( ! pData && rPath.pData  ||  pData && ! rPath.pData )
		return 0;
	
	if( ! ( pData || rPath.pData ) )
		// sind beide gleich ungueltig :)
		return ~0;

	if( *PDATA == *((String*)rPath.pData) )
		return ~0;
	
	return 0;
}

int ItemIDPath::operator!=( const ItemIDPath& rPath ) const
{
	return ! operator==( rPath );
}

ItemIDPath ItemIDPath::operator[]( int nIndex ) const
{
	if( ! pData )
		return ItemIDPath();

	Verminator( *PDATA );
	if( nIndex == 0 && (*PDATA)[0] == '/'  )
		return ItemIDPath( sSlash );
	
	ItemIDPath aTmp;
	aTmp.pData = new String( PDATA->GetToken( nIndex, '/' ) );
	return aTmp;
}

int ItemIDPath::GetTokenCount() const
{
	if( ! pData )
		return 0;

	Verminator( *PDATA );
	int nTokens = PDATA->GetTokenCount( '/' );

	return nTokens;
}

ItemIDPath ItemIDPath::GetToken( int nIndex ) const
{
	return operator[](nIndex);
}

BOOL ItemIDPath::Split( ItemIDPath& rParent, ItemIDPath& rChild ) const
{
	if( ! pData )
		return FALSE;
	
	String* pNewChildData =
		new String( PDATA->GetToken( PDATA->GetTokenCount( '/' )-1, '/' ) );


	String* pNewParentData
		= new String( *PDATA );
	int nPos = PDATA->Len() - pNewChildData->Len() - 1;
	if( nPos > 0 )
		pNewParentData->Cut( nPos );
	else
		*pNewParentData = "/";

	if( rChild.pData )
		delete (String*)rChild.pData;
	if( rParent.pData )
		delete (String*)rParent.pData;
	rChild.pData = pNewChildData;
	rParent.pData = pNewParentData;

	return TRUE;
}

String ItemIDPath::GetFileDescription() const
{
	String aVirt, aEffUrl;
	SplitVirtualURL( *PDATA, aVirt, aEffUrl );

	String aRet;
	if( !aVirt.Len() )
	{
		if( aEffUrl[0] == '/' )
			aRet = "file://";
		aRet += aEffUrl;
	}
	return aRet;
}

String ItemIDPath::GetBinaryDescription() const
{
	String aRet;
	if( (*PDATA)[ 0 ] == '/' )
		aRet = "file://";
	aRet += *PDATA;
	return aRet;
}

String ItemIDPath::GetHostNotationPath() const
{
	String aVirt, aEffUrl;
	SplitVirtualURL( *PDATA, aVirt, aEffUrl );

	String aRet;
	if( !aVirt.Len() )
		aRet = aEffUrl;
	return aRet;
}

void ItemIDPath::SetData( void* pNewData, size_t nBytes )
{
	if( pData )
		delete PDATA;
	
	pData = new String( (char*)pNewData, nBytes );
	Verminator( *PDATA );
}

const void* ItemIDPath::GetDataPtr() const
{
	if( pData )
		return PDATA->GetStr();
	return NULL;
}

size_t ItemIDPath::GetDataSize() const
{
	if( pData )
		return PDATA->Len(); // inclusive \0
	return 0;
}

