/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: termino.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 15:02:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include <stdio.h>
#include <tools\stream.hxx>
#include <bootstrp\sstring.hxx>

BOOL Clear( String &rText )
{
	if (( rText.Search( String( "\\n", RTL_TEXTENCODING_ASCII_US )) != STRING_NOTFOUND ) ||
		( rText.Search( String( "\\t", RTL_TEXTENCODING_ASCII_US )) != STRING_NOTFOUND ) ||
		( rText.Len() < 3 ))
			return FALSE;

	USHORT nLen = 0;
	while ( nLen != rText.Len()) {
		nLen = rText.Len();

		rText.EraseTrailingChars( ' ' );
		rText.EraseTrailingChars( '!' );
		rText.EraseTrailingChars( '.' );
		rText.EraseTrailingChars( ':' );
		rText.EraseTrailingChars( ',' );
	}

	rText.EraseAllChars( '~' );

	return ( rText.Len() > 2 );
}

int _cdecl main( int argc, char *argv[] )
{
	ByteString sSource( argv[ 1 ] );
	SvFileStream aSource;
	aSource.SetStreamCharSet( RTL_TEXTENCODING_IBM_850 );
//  aSource.SetTargetCharSet( RTL_TEXTENCODING_MS_1252 );
	aSource.Open( String( sSource, RTL_TEXTENCODING_ASCII_US ), STREAM_STD_READ );

	SStringList aList;

	ULONG nStat = 0;
	String sLine;
	while ( aSource.ReadByteStringLine( sLine, RTL_TEXTENCODING_IBM_850 ) && nStat != 3 ) {
		switch ( nStat ) {
			case 0:
				if ( sLine.Search( String( "---------------", RTL_TEXTENCODING_ASCII_US )) != STRING_NOTFOUND )
					nStat = 1;
			break;
			case 1: {
				if ( sLine.Search( String( "!", RTL_TEXTENCODING_ASCII_US )) == STRING_NOTFOUND )
					nStat = 3;
				else {
					String sSecond;
					aSource.ReadByteStringLine( sSecond, RTL_TEXTENCODING_IBM_850 );

					if ( Clear( sLine ) && Clear( sSecond )) {
						String sFull( sLine );
						sFull += String( "($$)", RTL_TEXTENCODING_ASCII_US );
						sFull += sSecond;

						aList.PutString( new String( sFull ));
					}
				}
			}
		}
	}
	aSource.Close();

	String sLast;
	for ( ULONG i = 0; i < aList.Count(); i++ ) {
		if ( *aList.GetObject( i ) != sLast ) {
			ByteString sTmp( *aList.GetObject( i ), RTL_TEXTENCODING_MS_1252 );
			fprintf( stdout, "%s\n", sTmp.GetBuffer());
		}
		sLast = *aList.GetObject( i );
	}

	return 0;
}
