/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dynamic.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:36:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <precomp.h>
#include <udm/dynamic.hxx>


// NOT FULLY DEFINED SERVICES

namespace udm
{

Data::accessor_type
Dynamic::inq_Type() const
{
 	return Data::t_Dynamic;
}








//*********************       Dynamic_Null      *******************//

class Dynamic_Null : public Dynamic
{
  public:
    virtual             ~Dynamic_Null();
  private:
    // Interface Data
    virtual void        do_Dispose();
    virtual void        do_BinWrite(
                            csv::bostream &     o_out ) const;
    virtual description inq_TypeDescription() const;
    // Interface Dynamic:
    virtual Object      op_Ptr() const;
};

Dynamic_Null::~Dynamic_Null()
{
}

void                Dynamic_Null::do_Dispose() { }
void                Dynamic_Null::do_BinWrite( csv::bostream & ) const    {}
Data::description   Dynamic_Null::inq_TypeDescription() const { return "D{}"; }


Object
Dynamic_Null::op_Ptr() const
{
 	return Object();
}




template <>
Dynamic &
get_null<Dynamic>( csv::Type2Type<Dynamic> )
{
    static Dynamic * pNull_ = new Dynamic_Null;
    return *pNull_;
}




}   // namespace udm






