/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: color.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 11:55:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _TOOLS_COLOR_HXX
#include <tools/color.hxx>
#endif
#ifndef _TOOLS_RC_HXX
#include <tools/rc.hxx>
#endif
#ifndef _TOOLS_RCID_H
#include <tools/rcid.h>
#endif
#ifndef _TOOLS_RESID_HXX
#include <tools/resid.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <svapp.hxx>
#endif
#ifndef _SV_RC_H
#include <tools/rc.h>
#endif

//============================================================================
Color::Color( const ResId& rResId )
{
	rResId.SetRT( RSC_COLOR );
	ResMgr* pResMgr = rResId.GetResMgr();
	if ( !pResMgr )
		pResMgr = Resource::GetResManager();

	if ( pResMgr->GetResource( rResId ) )
	{
		// Header ueberspringen
		pResMgr->Increment( sizeof( RSHEADER_TYPE ) );

		// Daten laden
		USHORT nRed		= pResMgr->ReadShort();
		USHORT nGreen	= pResMgr->ReadShort();
		USHORT nBlue	= pResMgr->ReadShort();
		// one more historical ULONG
		pResMgr->ReadLong();

		// RGB-Farbe
		mnColor = RGB_COLORDATA( nRed>>8, nGreen>>8, nBlue>>8 );
	}
	else
    {
        mnColor = RGB_COLORDATA( 0, 0, 0 );
    }
}
