/*
 * ConnectDialog.java
 *
 * Created on 1. M?rz 2003, 15:17
 */
package com.sun.star.wizards.tutorial.creator.frame;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;

import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.wizards.tutorial.executer.util.Helper;

/**
 * A frame class for the StarOffice-connection and connection handling. StarOffice can be
 * started as server and with the present class it is possible to control it.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class ConnectFrame extends JFrame {
	private Framework m_parent;
	private JTextField m_hostTextField;
	private JTextField m_portTextField;
	private JTextPane m_textPane;
	private Helper m_helper;
	private String m_connectDialogTitel = "Connect";
	private String m_hostLabelTitel = "Host  : ";
	private String m_portLabelTitel = "Port  : ";
	private String m_defaultHost = "localhost";
	private String m_defaultPort = "8100";
	private String m_connectDescreption = "Please insert StarOffice Hostname and port.";
	private String m_connectButtonDescreption = "Connect";
	private String m_cancelButtonDescreption = "Cancel";

	/**
	 * Creates a new ConnectFrame object.
	 *
	 * @param frame frame
	 */
	public ConnectFrame(Framework frame) {
		m_parent = frame;
		init();
	}

	/**
	 * Creates a new ConnectFrame object.
	 *
	 * @param xMSF xMSF
	 *
	 * @throws java.lang.Exception DOCUMENT ME!
	 */
	public ConnectFrame(XMultiServiceFactory xMSF) throws java.lang.Exception {
		m_helper = new Helper(xMSF);
	}

	/**
	 * Initilization of the connection frame with the standard procedures.
	 */
	private void init() {
		JPanel contentPane = (JPanel) this.getContentPane();
		contentPane.setLayout(new BorderLayout());
		contentPane.setBorder(BorderFactory.createEmptyBorder(15, 15, 1, 15));
		setBounds(300, 300, 320, 170);
		setTitle(m_connectDialogTitel);

		JPanel headerPanel = new JPanel();
		GridBagLayout gbl = new GridBagLayout();
		GridBagConstraints gbc = new GridBagConstraints();
		headerPanel.setLayout(gbl);

		JLabel hostLabel = new JLabel(m_hostLabelTitel);
		JLabel portLabel = new JLabel(m_portLabelTitel);
		m_hostTextField = new JTextField(m_defaultHost);
		m_portTextField = new JTextField(m_defaultPort);

		gbc.anchor = GridBagConstraints.WEST;
		gbc.weightx = 0;
		gbl.setConstraints(hostLabel, gbc);
		headerPanel.add(hostLabel);
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = 3.0;
		gbl.setConstraints(m_hostTextField, gbc);
		headerPanel.add(m_hostTextField);

		gbc.weightx = 0;
		gbc.gridwidth = 1;
		gbl.setConstraints(portLabel, gbc);
		headerPanel.add(portLabel);
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.weightx = 1.0;
		gbl.setConstraints(m_portTextField, gbc);
		headerPanel.add(m_portTextField);

		m_textPane = new javax.swing.JTextPane();
		m_textPane.setBackground(new java.awt.Color(204, 204, 204));
		m_textPane.setText(m_connectDescreption);

		JButton send = new JButton(m_connectButtonDescreption);
		JButton cancel = new JButton(m_cancelButtonDescreption);
		send.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				connect();
			}
		});
		cancel.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				cancel();
			}
		});

		JPanel actionPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		actionPanel.add(send);
		actionPanel.add(cancel);

		contentPane.add(m_textPane, BorderLayout.NORTH);
		contentPane.add(headerPanel, BorderLayout.CENTER);
		contentPane.add(actionPanel, BorderLayout.SOUTH);
		setVisible(true);
	}

	/**
	 * The main purpose consists in the closing of the window.
	 *
	 * @param e object
	 */
	protected void processWindowEvent(WindowEvent e) {
		super.processWindowEvent(e);

		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			dispose();
			System.exit(0);
		}
	}

	/**
	 * Establishing a connection to staroffice.
	 */
	private void connect() {
		try {
			if (getHost().equals("") || getPort().equals("")) {
				throw new java.lang.Exception();
			}

			String connectString = "uno:socket,host=" + getHost() + ",port=" + getPort() + ";urp;StarOffice.ServiceManager";
			m_helper = new Helper(connectString);

			if (!m_helper.isConnected() || (getConnectedDocumentTyp() == null) || getConnectedDocumentTyp().equals("")) {
				throw new java.lang.Exception();
			} else {
				setVisible(false);
				m_parent.init();
				m_parent.showStepFrame(getBounds());
			}
		} catch (java.lang.Exception ex) {
			JOptionPane.showMessageDialog(null, "Cannot connect to StarOffice", "Connect Error", JOptionPane.ERROR_MESSAGE);

			return;
		}
	}

	/**
	 * Get ExtendedToolkit. Will be called after a successful connection with staroffice.
	 *
	 * @return XExtendedToolkit
	 */
	public XExtendedToolkit getXExtendedToolkit() {
		XExtendedToolkit xet = null;

		try {
			xet = m_helper.getXExtendedToolkit();
		} catch (com.sun.star.uno.Exception ex) {
		}

		return xet;
	}

	/**
	 * Get MultiServiceFactory. Will be called after a successful connection with
	 * staroffice.
	 *
	 * @return XMultiServiceFactory
	 */
	public XMultiServiceFactory getXMultiServiceFactory() {
		return m_helper.getxMSF();
	}

	/**
	 * Get document model..
	 *
	 * @return XModel
	 */
	public XModel getXModel() {
		XModel xm = null;

		try {
			xm = m_helper.getXModel();
		} catch (com.sun.star.uno.Exception ex) {
		}

		return xm;
	}

	/**
	 * Get connected document title.
	 *
	 * @return document title
	 */
	public String getConnectedDocumentTitle() {
		return m_helper.getCurrentDocumentTitle();
	}

	/**
	 * Get connected document type. Will be called after a successful connection with
	 * staroffice.
	 *
	 * @return document type
	 */
	public String getConnectedDocumentTyp() {
		String typ = "";

		try {
			typ = m_helper.getCurrentDocumentTyp();

			if ((typ != null) && !typ.equals("")) {
				typ = (typ.substring(typ.lastIndexOf(".") + 1)).trim();
			}
		} catch (com.sun.star.uno.Exception ex) {
		}

		return typ;
	}

	/**
	 * Checks whether connect was successful.
	 *
	 * @return true = connected, false = not connected
	 */
	public boolean isConnected() {
		return m_helper.isConnected();
	}

	/**
	 * Disposing and finishing.
	 */
	private void cancel() {
		dispose();
		System.exit(0);
	}

	/**
	 * Get host name.
	 *
	 * @return host name
	 */
	public String getHost() {
		return m_hostTextField.getText();
	}

	/**
	 * Get port name.
	 *
	 * @return port name
	 */
	public String getPort() {
		return m_portTextField.getText();
	}
}
