package com.sun.star.wizards.tutorial.executer.officeHelper;

import java.util.Hashtable;

import com.sun.star.wizards.tutorial.executer.util.FindInterfaces;
import com.sun.star.wizards.tutorial.executer.util.Helper;

/**
 * Providing functionality for text document handling.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class TextDocument extends Components {
	private Helper m_helper;
	private static TextDocument m_textDocument;

	static {
		new TextDocument();
	}

	/**
	 * Creates a new TextDocument object.
	 */
	public TextDocument() {
		m_textDocument = this;
	}

	/**
	 * Creates a new TextDocument object.
	 *
	 * @param helper
	 *
	 * @throws java.lang.Exception
	 * @throws Exception DOCUMENT ME!
	 */
	public TextDocument(Helper helper) throws java.lang.Exception {
		if (helper == null) {
			throw new Exception("ERROR : Helper is not initialized.");
		}

		m_helper = helper;
	}

	/**
	 * Get Helper
	 *
	 * @return Helper instance
	 */
	public Helper getHelper() {
		return m_helper;
	}

	/**
	 * Set Helper instance
	 *
	 * @param helper DOCUMENT ME!
	 */
	public void setHelper(Helper helper) {
		m_helper = helper;
	}

	/**
	 * Get implemented interfaces
	 *
	 * @return interfaces.
	 */
	public static Hashtable getInterfaces() {
		return (FindInterfaces.getInterfaces(m_textDocument.getClass()));
	}
}
