/*
 * FindInterfaces.java
 *
 * Created on 7. M?rz 2003, 17:29
 */
package com.sun.star.wizards.tutorial.executer.util;

import java.lang.reflect.Method;

import java.util.Hashtable;

/**
 * Search interfaces for specific classes.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class FindInterfaces {
	private static Class[] m_paramClazz = new Class[0];
	private static Object[] m_obj = new Object[0];
	private static String m_IntMethodName = "getMethods";

	/**
	 * Get the implemented interfaces for the argument class.
	 *
	 * @param c be only one of the following : DesktopDialog, DesktopMenum,
	 *        Presentation_Drawing, Spreedsheet, TextDocument.
	 *
	 * @return Get found interfaces
	 */
	public static Hashtable getInterfaces(Class c) {
		Hashtable methods = new Hashtable();
		getInterfaces(c, methods);

		return methods;
	}

	/**
	 * Find the interfaces for Class and insert them into a Hashtable. The search
	 *
	 * @param c be only one of the following : DesktopDialog, DesktopMenum,
	 *        Presentation_Drawing, Spreedsheet, TextDocument.
	 * @param methods found interfaces
	 */
	private static void getInterfaces(Class c, Hashtable methods) {
		try {
			if (c != null) {
				if (c.isInterface()) {
					Class[] c2 = c.getDeclaredClasses();

					for (int j = 0; j < c2.length; j++) {
						Class classIntance = c2[j];

						if (classIntance != null) {
							Method method = classIntance.getMethod(m_IntMethodName, m_paramClazz);

							if (method != null) {
								Object hash = method.invoke(classIntance, m_obj);
								methods.put(classIntance.getName(), hash);
							} else {
								classIntance = null;
							}
						}
					}
				}

				Class[] c1 = c.getInterfaces();

				for (int i = 0; i < c1.length; i++) {
					getInterfaces(c1[i], methods);
				}

				getInterfaces(c.getSuperclass(), methods);
			}
		} catch (Exception ex) {
			methods.clear();
		}
	}
}
