
/**
 * Title:        Help Content Provider<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Andreas Bille ( abi )<p>
 * Company:      Sun Microsystems. Inc<p>
 * @author Andreas Bille ( abi )
 * @version 1.0
 */
package com.sun.star.help;

import java.net.*;
import java.io.*;
import com.sun.star.ucb.*;

public class HelpURLConnection extends URLConnection {
	private final URL _helpURL;
	private final byte[] _doc;

	public HelpURLConnection(URL _starURL, byte[] doc) {
		super(_starURL);
		setDoInput(true);
		connected = true;
		_helpURL = _starURL;
		_doc = doc;
	}

	public void connect() throws IOException {
		System.out.println("trying to connect to help");
	}

	public InputStream getInputStream() {
		if (_doc != null)
			return new ByteArrayInputStream(_doc);

		HelpURLParameter aParameter = null;
		try {
			aParameter = new HelpURLParameter(_helpURL);
		} catch (IllegalIdentifierException e) {
		}

		return aParameter.getInputFromDisk();
	}
}
