#ifndef INCLUDE_MODULE_POWERSAVE_H
#define INCLUDE_MODULE_POWERSAVE_H
/* ----------------------------------------------------------------------------
 * module_powersave.h
 * prototypes and definitions for the module powermanagement.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <pbbtaglist.h>

/* power management policies */
#define POLICY_NONE_NAME	"nochange"
#define POLICY_POWERSAVE_NAME	"powersave"
#define POLICY_USER_NAME	"custom"
#define POLICY_PERFORMANCE_NAME	"performance"
enum {POLICY_NONE, POLICY_POWERSAVE, POLICY_USER, POLICY_PERFORMANCE, POLICY_LAST=POLICY_PERFORMANCE};

/* emergency action codes */
#define EMA_SLEEP_NAME		"sleep"
#define EMA_SIGNAL_NAME		"signal"
#define EMA_COMMAND_NAME	"command"
enum {EMA_SLEEP, EMA_SIGNAL, EMA_COMMAND, EMA_LAST=EMA_COMMAND};

#define DEFAULT_NETLOAD_DEV	"ppp0"

#define AC_TIME_DIM	     200      /* 600=1 minutes, in 10th of a second */
#define AC_TIME_SLEEP        300      /* 3000=5 minutes, in 10th of a second */
#define AC_TIME_HDOFF       3000      /* 3000=5 minutes, in 10th of a second */

#define BATTERY_TIME_DIM     200      /* 600=1 minutes, in 10th of a second */
#define BATTERY_TIME_SLEEP   300      /* 3000=5 minutes, in 10th of a second */
#define BATTERY_TIME_HDOFF  3000      /* 3000=5 minutes, in 10th of a second */

#define SLEEPCOUNTDOWN        60      /* (seconds + 1) * 10 */
#define BEEPINTERVAL          30      /* seconds */

/* Battery levels to check battery and signal warnings to the clients */
#define BAT_WARNLEVEL1	21	/* time remaining until shutdown*/
#define BAT_WARNLEVEL2	11	/* in minutes */
#define BAT_WARNLEVEL3	4
/* This value defined a hysteresis for the warnlevels. That means if for eg. the
    remaining time falls below BAT_WARNLEVEL2 the daemon switchs to
    warnlevel 2 and the time has to be raised above BAT_WARNLEVEL2 + this
    value to return to warnlevel 1. This reduces frequent battery warning popup
    windows around the BAT_WARNLEVELs due to power fluctuation.
    The hysteresis must not be greater than the lowest difference between two
    BAT_WARNLEVELs. */
#define BAT_HYSTERESIS	3

enum {MODE_AWAKE, MODE_DIM, MODE_DOZY, MODE_SLEEP};

struct modflags_power {
  unsigned int sleep_supported:1; 	/* REDUNDANT copy from module pmac */
  unsigned int sleeptriggered:1;
  unsigned int cpuload_enable:1;
  unsigned int netload_enable:1;
  unsigned int sleeplock_cpu:1;
  unsigned int sleeplock_net:1;
  unsigned int sigpwr_sent:1;
  unsigned int heartbeat_enable:1;
  unsigned int heartbeat:1;
  unsigned int coveropen:1;     /* tracked signal from TAG_COVERSTATUS */
  unsigned int sleepkeysleep:1;
  unsigned int usersetpolicy:1;
  unsigned int :0;
};

struct powerprofile_flags {
  unsigned int sleep:1;
  unsigned int coversleep:1;
  unsigned int :0;
};

struct powerprofile {
  struct powerprofile_flags flags;
  unsigned int policy;
  unsigned int Tsleep;
  unsigned int Tdim;
  unsigned int Thdoff;
};

/* public prototypes */
int power_init (struct tagitem *taglist);
int power_exit ();

/* private prototypes */
void power_keyboard (struct tagitem *taglist);
void power_mouse (struct tagitem *taglist);
void power_awake ();
void power_sync ();
void power_query (struct tagitem *taglist);
void power_configure (struct tagitem *taglist);
int power_handle_tags (int cfgure, struct tagitem *taglist);
void power_timer (struct tagitem *taglist);
void power_timer1000 (struct tagitem *taglist);
void power_check_battery (int time, int psource);
void power_trigger_sleep (int flag);
void power_setpolicy (int policy, int powersource);
int check_script (char *name, char *allowed);
int send_sigpwr (char mode);
int power_read_cpu (void);
int power_read_net (char *dev);
void power_beep();

#endif    /* INCLUDE_MODULE_POWERSAVE_H */
