/* ----------------------------------------------------------------------------
 * support.c
 * funtions usefull for everybody
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>
#include <pbb.h>

#include "support.h"
#include "gettext_macros.h"

int
copy_path (char *source, char *dest, int type, int flags)
{
	char *whitespace = NULL;
	int rc = 0;

	if (strlen (source) < STDBUFFERLEN) {
		if ((whitespace = strchr (source, ' ')) != NULL)
			*whitespace = 0;

		rc = check_devorfile (source, type);
		if ((rc == 0) && (flags & CPFLG_PBBONLY))
			rc = check_permissions (source, geteuid(), 022);
		if ((rc == E_NOEXIST) && (flags & CPFLG_MAYBEMISSED))
			rc = 0;
		if (type == TYPE_FILE && strlen(source) == 0)
			rc = 0;  /* empty _file_names are acceptable */

		switch (rc) {
		case E_NOEXIST:
			print_error(_("ERROR: %s doesn't exist.\n"), source);
			break;
		case E_NOFILE:
			print_error(_("ERROR: %s is not a file.\n"), source);
			break;
		case E_NOCHAR:
			print_error(_("ERROR: %s is not a character device.\n"), source);
			break;
		case E_NOBLK:
			print_error(_("ERROR: %s is not a block device.\n"), source);
			break;
		case E_USER:
			print_error(_("SECURITY: %s must be owned by the same owner as pbbuttonsd.\n"), source);
			break;
		case E_RIGHTS:
			print_error(_("SECURITY: %s must be writable only be the owner of pbbuttonsd.\n"), source);
			break;
		default:
			if (whitespace != NULL) *whitespace = ' ';
			strncpy(dest, source, STDBUFFERLEN);
			break;
		}
	} else {
		print_error(_("ERROR: Path of %s is to long.\n"), source);
		rc = E_BUFOVL;
	}

	if (whitespace != NULL) *whitespace = ' ';
	return rc;
}

int
call_script (char* template, ...)
{
	int rc;
	char script[MAXCMDLEN+1], *ftext, buffer[STDBUFFERLEN];
	va_list list;

	if (strlen(template) == 0)  /* do nothing, if template is empty */
		return 0;

	va_start(list, template);
	vsnprintf (script, MAXCMDLEN, template, list);
	script[MAXCMDLEN] = '\0';
	va_end (list);

	rc = launch_program(script);
	ftext = _("launched and exited normally");
	switch (rc) {
	case E_NOEXIST:
		ftext =_("doesn't exist");
		break;
	case E_RIGHTS:
	case E_USER:
		ftext =_("skipped because it's not secure");
		break;
	case E_CLDKILL:
		snprintf (buffer, STDBUFFERLEN, _("lauched but killed after %d seconds"), get_timeforcmd());
		ftext = buffer;
		break;
	case E_CLDEXIT:
		ftext =_("lauched but exitcode is not null");
		break;
	case E_CLDSIG:
		ftext =_("lauched but exited by signal");
		break;
	}
	print_error(_("INFO: Script '%s' %s\n"), script, ftext);
	return rc;
}
