#ifndef INCLUDE_TAGS_H
#define INCLUDE_TAGS_H
/* ---------------------------------------------------------------
 * tags.h
 * definitions of TAGS, functions and structures are defined in
 * pbbtaglist.h and pbbtaglist.c
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 *
 * ATTENTION: Don't use tags marked as "depreciated". They will
 *            be removed in future.
 *
 * optimized for tabwith=4
 * ---------------------------------------------------------------*/
 
#include "pbbtaglist.h"

#define PBBLIB					1 << 24
#define TAG_CLIENTNAME			PBBLIB | FLG_STRING | 1
#define TAG_CLIENTFLAGS			PBBLIB | 2
#define TAG_CLIENTPID			PBBLIB | 3
#define TAG_CLIENTPORT			PBBLIB | 4

/* Pri0 Tags */
#define MOD_SYSTEM				1 << 16
#define TAG_KEYCODE				MOD_SYSTEM | FLG_PRIVATE | 1
#define TAG_KEYREPEAT			MOD_SYSTEM | FLG_PRIVATE | 2
#define TAG_MODIFIER			MOD_SYSTEM | FLG_PRIVATE | 3
#define TAG_MOUSERELX			MOD_SYSTEM | FLG_PRIVATE | 5
#define TAG_MOUSERELY			MOD_SYSTEM | FLG_PRIVATE | 6
#define TAG_USERALLOWED			MOD_SYSTEM | FLG_PRIVATE | FLG_STRING | 8
#define TAG_SAVECONFIG			MOD_SYSTEM | 9
#define TAG_VERSION				MOD_SYSTEM | FLG_STRING | 10
#define TAG_AUTORESCAN			MOD_SYSTEM | 11
#define TAG_TIMEFORCMD			MOD_SYSTEM | 12
#define TAG_SYSINFO				MOD_SYSTEM | 13
#define TAG_CFGNAME				MOD_SYSTEM | FLG_PRIVATE | FLG_STRING | 14
#define TAG_REINIT				MOD_SYSTEM | 15

/* Pri1 tags */
#define MOD_LAPTOP				2 << 16
#define TAG_BACKLIGHTMAX		MOD_LAPTOP | FLG_PRIVATE | 1
#define TAG_BACKLIGHTLEVEL		MOD_LAPTOP | FLG_PRIVATE | 2
#define TAG_COVERSTATUS			MOD_LAPTOP | FLG_PRIVATE | 3
#define TAG_POWERCHANGED		MOD_LAPTOP | FLG_PRIVATE | 5
#define TAG_REQUESTSLEEP		MOD_LAPTOP | FLG_PRIVATE | 6
#define TAG_SLEEPSUPPORTED		MOD_LAPTOP | 7
#define TAG_PREPAREFORSLEEP		MOD_LAPTOP | FLG_PRIVATE | 8
#define TAG_WAKEUPFROMSLEEP		MOD_LAPTOP | FLG_PRIVATE | 9
#define TAG_TIMECHANGED			MOD_LAPTOP | FLG_PRIVATE | 10

#define MOD_PMAC				3 << 16
#define TAG_PMUDEVICE			MOD_PMAC | FLG_STRING | 1
#define TAG_ADBDEVICE			MOD_PMAC | FLG_STRING | 2
#define TAG_TPMODEUPKEY			MOD_PMAC | 3
#define TAG_TPMODEUPMOD			MOD_PMAC | 4
#define TAG_TPMODEDOWNKEY		MOD_PMAC | 5
#define TAG_TPMODEDOWNMOD		MOD_PMAC | 6
#define TAG_TPMODE				MOD_PMAC | 7
#define TAG_KBDMODE				MOD_PMAC | 8
#define TAG_REPLACEPMUD			MOD_PMAC | 9   /* depreciated */
#define TAG_IDENTITY			MOD_PMAC | FLG_STRING | 10
#define TAG_POWERSOURCE			MOD_PMAC | 11
#define TAG_TIMEREMAINING		MOD_PMAC | 12
#define TAG_AMBIENTLIGHT		MOD_PMAC | 13
#define TAG_KEYBLIGHTLEVEL		MOD_PMAC | FLG_PRIVATE | 14
#define TAG_KEYBLIGHTMAX		MOD_PMAC | FLG_PRIVATE | 15
#define TAG_BATLOG				MOD_PMAC | 16
#define TAG_BATCYCLE			MOD_PMAC | 17
#define TAG_BATTERYPRESENT		MOD_PMAC | 18
#define TAG_NOTAPTYPING			MOD_PMAC | 19

/* Pri2 Tags */
#define MOD_DISPLAY				4 << 16
#define TAG_LCDILLUMUPKEY		MOD_DISPLAY | 1
#define TAG_LCDILLUMUPMOD		MOD_DISPLAY | 2
#define TAG_LCDILLUMDOWNKEY		MOD_DISPLAY | 3
#define TAG_LCDILLUMDOWNMOD		MOD_DISPLAY | 4
#define TAG_KBDILLUMUPKEY		MOD_DISPLAY | 15
#define TAG_KBDILLUMUPMOD		MOD_DISPLAY | 16
#define TAG_KBDILLUMDOWNKEY		MOD_DISPLAY | 17
#define TAG_KBDILLUMDOWNMOD		MOD_DISPLAY | 18
#define TAG_KBDILLUMONKEY		MOD_DISPLAY | 19
#define TAG_KBDILLUMONMOD		MOD_DISPLAY | 20
#define TAG_LCDAUTOADJUST		MOD_DISPLAY | 12
#define TAG_BRIGHTNESS			TAG_LCDBRIGHTNESS   /* depreciated */
#define TAG_LCDBRIGHTNESS		MOD_DISPLAY | 5
#define TAG_LCDBRIGHTNESSMAX	MOD_DISPLAY | 7
#define TAG_LCDFADINGSPEED		MOD_DISPLAY | 10
#define TAG_LCDTHRESHOLD		MOD_DISPLAY | 24
#define TAG_LCDAUTOADJMINBAT	MOD_DISPLAY | 25
#define TAG_LCDAUTOADJMAXBAT	MOD_DISPLAY | 26
#define TAG_LCDAUTOADJMINAC		MOD_DISPLAY | 27
#define TAG_LCDAUTOADJMAXAC		MOD_DISPLAY | 28
#define TAG_KBDAUTOADJUST		MOD_DISPLAY | 13
#define TAG_KBDBRIGHTNESS		MOD_DISPLAY | 21
#define TAG_KBDONBRIGHTNESS		MOD_DISPLAY | 29
#define TAG_KBDBRIGHTNESSMAX	MOD_DISPLAY | 22
#define TAG_KBDFADINGSPEED		MOD_DISPLAY | 23
#define TAG_KBDTHRESHOLD		MOD_DISPLAY | 14
#define TAG_BRIGHTNESSOP		MOD_DISPLAY | FLG_PRIVATE | 6
#define TAG_FRAMEBUFFERDEVICE	MOD_DISPLAY | FLG_STRING | 8
#define TAG_BLANKFRAMEBUFFER	MOD_DISPLAY | 9
#define TAG_DIMFULLYDARK		MOD_DISPLAY | 11
#define TAG_CRTMIRROR			MOD_DISPLAY | 30
#define TAG_CRTMIRRORKEY		MOD_DISPLAY | 31
#define TAG_CRTMIRRORMOD		MOD_DISPLAY | 32

#define MOD_MIXER				5 << 16
#define TAG_MIXERDEVICE			MOD_MIXER | FLG_STRING | 1
#define TAG_VOLUMEUPKEY			MOD_MIXER | 2
#define TAG_VOLUMEUPMOD			MOD_MIXER | 3
#define TAG_VOLUMEDOWNKEY		MOD_MIXER | 4
#define TAG_VOLUMEDOWNMOD		MOD_MIXER | 5
#define TAG_MUTEKEY				MOD_MIXER | 6
#define TAG_MUTEMOD				MOD_MIXER | 7
#define TAG_MIXERINITDELAY		MOD_MIXER | 8
#define TAG_VOLUME				MOD_MIXER | 9
#define TAG_MUTE				MOD_MIXER | 10
#define TAG_MIXERCHANNELS		MOD_MIXER | FLG_STRING | 11
#define TAG_SOUNDSYSTEM			MOD_MIXER | 12
#define TAG_SOUNDSYSTEMCFG		MOD_MIXER | 13
#define TAG_MIXERCARD			MOD_MIXER | FLG_STRING | 14
#define TAG_MIXERELEMENTS		MOD_MIXER | FLG_STRING | 15

#define MOD_CDROM				6 << 16
#define TAG_CDROMDEVICE			MOD_CDROM | FLG_STRING | 1
#define TAG_EJECTCDKEY			MOD_CDROM | 2
#define TAG_EJECTCDMOD			MOD_CDROM | 3
#define TAG_EJECTCDKEYDELAY		MOD_CDROM | 4
#define TAG_EJECTCD				MOD_CDROM | 5

#define MOD_POWER				7 << 16
#define TAG_SCRIPTPMCS			MOD_POWER | FLG_STRING | 2
#define TAG_SLEEPKEY			MOD_POWER | 7
#define TAG_SLEEPMOD			MOD_POWER | 8
#define TAG_SLEEPKEYDELAY		MOD_POWER | 9
#define TAG_GOTOSLEEP			MOD_POWER | 10
#define TAG_BWLFIRST			MOD_POWER | 11
#define TAG_BWLSECOND			MOD_POWER | 12
#define TAG_BWLLAST				MOD_POWER | 13
#define TAG_CURRENTBWL			MOD_POWER | 14
#define TAG_SLEEPINSECONDS		MOD_POWER | 15
#define TAG_CPULOADSLEEPLOCK	MOD_POWER | 16
#define TAG_CPULOADMIN			MOD_POWER | 17
#define TAG_CPULOADPERIOD		MOD_POWER | 18
#define TAG_NETLOADSLEEPLOCK	MOD_POWER | 19
#define TAG_NETLOADMIN			MOD_POWER | 20
#define TAG_NETLOADPERIOD		MOD_POWER | 21
#define TAG_NETLOADDEV			MOD_POWER | FLG_STRING | 22
#define TAG_EMERGENCYACTION		MOD_POWER | 23
#define TAG_HEARTBEATBEEP		MOD_POWER | 24
#define TAG_POLICY				MOD_POWER | 26
#define TAG_GOTOHIBERNATE		MOD_POWER | 27
#define TAG_IBAMDATADIR			MOD_POWER | FLG_STRING | 28 
#define TAG_CHARGETIME			MOD_POWER | 29

#define TAG_ONAC_POLICY			MOD_POWER | 50
#define TAG_ONAC_TIMERACTION	MOD_POWER | 51
#define TAG_ONAC_COVERACTION	MOD_POWER | 52
#define TAG_ONAC_KEYACTION		MOD_POWER | 53
#define TAG_ONAC_TIMESUSPEND	MOD_POWER | 54
#define TAG_ONAC_TIMEDIM		MOD_POWER | 55

#define TAG_ONBATT_POLICY		MOD_POWER | 60
#define TAG_ONBATT_TIMERACTION	MOD_POWER | 61
#define TAG_ONBATT_COVERACTION	MOD_POWER | 62
#define TAG_ONBATT_KEYACTION	MOD_POWER | 63
#define TAG_ONBATT_TIMESUSPEND	MOD_POWER | 64
#define TAG_ONBATT_TIMEDIM		MOD_POWER | 65

#endif    /* INCLUDE_TAGS_H */

