/* Generated by re2c 0.9.12 on Wed Jan  4 15:16:35 2006 */
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */

/* $Id: parse_date.c,v 1.29.2.24 2006/01/04 21:31:29 derick Exp $ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 0; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { return TIMELIB_ERROR; } else { s->time.have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == -1) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	int           errors;

	struct timelib_time *time;
	timelib_tzdb        *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = -1;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = -1;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
	} else if (**ptr == '-') {
		dir = -1;
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	relunit = timelib_lookup_relunit(ptr);
	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;
	}
}

static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	timelib_tz_lookup_table  *tp, *first_found_elem;
	timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_ABBR;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/")) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;


{
	static unsigned char yybm[] = {
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	208,  64,  64,  64,  64,  64,  64,  64, 
	 64,  64,  64,  64, 192,  64, 192,   0, 
	  8,   8,   8,   8,   8,   8,   8,   8, 
	  8,   8,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,  32,  32,  32, 160,  32,  32,  32, 
	160,  32,  32,  32,  32,  32, 160,  32, 
	 32,  32, 160, 160, 160,  32,  32,  32, 
	 32,  32,  32,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	};

{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	goto yy0;

	YYDEBUG(1, *YYCURSOR);
	++YYCURSOR;
yy0:
	if((YYLIMIT - YYCURSOR) < 26) YYFILL(26);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x00:	case 0x0A:	goto yy48;
	case ' ':	goto yy45;
	case '(':	goto yy42;
	case '+':	case '-':	goto yy41;
	case ',':	case '.':	goto yy47;
	case '0':	goto yy13;
	case '1':	goto yy14;
	case '2':	goto yy15;
	case '3':	goto yy16;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy17;
	case '@':	goto yy11;
	case 'A':	goto yy25;
	case 'B':
	case 'C':	case 'G':
	case 'H':	case 'K':	case 'Q':
	case 'R':	case 'U':	case 'Z':	goto yy43;
	case 'D':	goto yy31;
	case 'E':	goto yy35;
	case 'F':	goto yy23;
	case 'I':	goto yy18;
	case 'J':	goto yy21;
	case 'L':	goto yy37;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy29;
	case 'P':	goto yy39;
	case 'S':	goto yy27;
	case 'T':	goto yy9;
	case 'V':	goto yy19;
	case 'W':	goto yy33;
	case 'X':	goto yy20;
	case 'Y':	goto yy2;
	case 'a':	goto yy26;
	case 'b':
	case 'c':	case 'g':
	case 'h':
	case 'i':	case 'k':	case 'q':
	case 'r':	case 'u':
	case 'v':	case 'x':	case 'z':	goto yy44;
	case 'd':	goto yy32;
	case 'e':	goto yy36;
	case 'f':	goto yy24;
	case 'j':	goto yy22;
	case 'l':	goto yy38;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy30;
	case 'p':	goto yy40;
	case 's':	goto yy28;
	case 't':	goto yy10;
	case 'w':	goto yy34;
	case 'y':	goto yy4;
	default:	goto yy50;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= 'E'){
		if(yych <= ')'){
			if(yych >= ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy133;
			goto yy1283;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy133;
			if(yych >= 'a')	goto yy136;
			goto yy3;
		} else {
			if(yych <= 'e')	goto yy1292;
			if(yych <= 'z')	goto yy136;
			goto yy3;
		}
	}
yy3:
	YYDEBUG(3, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
yy4:
	YYDEBUG(4, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy133;
			goto yy1283;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			goto yy133;
		} else {
			if(yych <= 'e')	goto yy1283;
			if(yych <= 'z')	goto yy133;
			goto yy3;
		}
	}
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'D'){
			if(yych == ')')	goto yy132;
			if(yych <= '@')	goto yy3;
			goto yy133;
		} else {
			if(yych <= 'H'){
				if(yych <= 'E')	goto yy1254;
				goto yy133;
			} else {
				if(yych <= 'I')	goto yy1255;
				if(yych <= 'N')	goto yy133;
				goto yy1253;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy133;
				goto yy3;
			} else {
				if(yych == 'e')	goto yy1270;
				goto yy136;
			}
		} else {
			if(yych <= 'n'){
				if(yych <= 'i')	goto yy1271;
				goto yy136;
			} else {
				if(yych <= 'o')	goto yy1269;
				if(yych <= 'z')	goto yy136;
				goto yy3;
			}
		}
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'D'){
			if(yych == ')')	goto yy132;
			if(yych <= '@')	goto yy3;
			goto yy133;
		} else {
			if(yych <= 'H'){
				if(yych <= 'E')	goto yy1254;
				goto yy133;
			} else {
				if(yych <= 'I')	goto yy1255;
				if(yych <= 'N')	goto yy133;
				goto yy1253;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy133;
				goto yy3;
			} else {
				if(yych == 'e')	goto yy1254;
				goto yy133;
			}
		} else {
			if(yych <= 'n'){
				if(yych <= 'i')	goto yy1255;
				goto yy133;
			} else {
				if(yych <= 'o')	goto yy1253;
				if(yych <= 'z')	goto yy133;
				goto yy3;
			}
		}
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'A'){
			if(yych == ')')	goto yy132;
			if(yych <= '@')	goto yy3;
			goto yy1225;
		} else {
			if(yych == 'I')	goto yy1226;
			if(yych <= 'N')	goto yy133;
			goto yy1227;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			if(yych <= 'a')	goto yy1239;
			goto yy136;
		} else {
			if(yych <= 'n'){
				if(yych <= 'i')	goto yy1240;
				goto yy136;
			} else {
				if(yych <= 'o')	goto yy1241;
				if(yych <= 'z')	goto yy136;
				goto yy3;
			}
		}
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'A'){
			if(yych == ')')	goto yy132;
			if(yych <= '@')	goto yy3;
			goto yy1225;
		} else {
			if(yych == 'I')	goto yy1226;
			if(yych <= 'N')	goto yy133;
			goto yy1227;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			if(yych <= 'a')	goto yy1225;
			goto yy133;
		} else {
			if(yych <= 'n'){
				if(yych <= 'i')	goto yy1226;
				goto yy133;
			} else {
				if(yych <= 'o')	goto yy1227;
				if(yych <= 'z')	goto yy133;
				goto yy3;
			}
		}
	}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'G'){
			if(yych <= '@'){
				if(yych == ')')	goto yy132;
				goto yy3;
			} else {
				if(yych == 'E')	goto yy1161;
				goto yy133;
			}
		} else {
			if(yych <= 'O'){
				if(yych <= 'H')	goto yy1162;
				if(yych <= 'N')	goto yy133;
				goto yy1163;
			} else {
				if(yych == 'U')	goto yy1164;
				if(yych <= 'V')	goto yy133;
				goto yy1165;
			}
		}
	} else {
		if(yych <= 'n'){
			if(yych <= 'd'){
				if(yych <= 'Z')	goto yy133;
				if(yych <= '`')	goto yy3;
				goto yy136;
			} else {
				if(yych <= 'e')	goto yy1194;
				if(yych == 'h')	goto yy1195;
				goto yy136;
			}
		} else {
			if(yych <= 'u'){
				if(yych <= 'o')	goto yy1196;
				if(yych <= 't')	goto yy136;
				goto yy1197;
			} else {
				if(yych == 'w')	goto yy1198;
				if(yych <= 'z')	goto yy136;
				goto yy3;
			}
		}
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'G'){
			if(yych <= '@'){
				if(yych == ')')	goto yy132;
				goto yy3;
			} else {
				if(yych == 'E')	goto yy1161;
				goto yy133;
			}
		} else {
			if(yych <= 'O'){
				if(yych <= 'H')	goto yy1162;
				if(yych <= 'N')	goto yy133;
				goto yy1163;
			} else {
				if(yych == 'U')	goto yy1164;
				if(yych <= 'V')	goto yy133;
				goto yy1165;
			}
		}
	} else {
		if(yych <= 'n'){
			if(yych <= 'd'){
				if(yych <= 'Z')	goto yy133;
				if(yych <= '`')	goto yy3;
				goto yy133;
			} else {
				if(yych <= 'e')	goto yy1161;
				if(yych == 'h')	goto yy1162;
				goto yy133;
			}
		} else {
			if(yych <= 'u'){
				if(yych <= 'o')	goto yy1163;
				if(yych <= 't')	goto yy133;
				goto yy1164;
			} else {
				if(yych == 'w')	goto yy1165;
				if(yych <= 'z')	goto yy133;
				goto yy3;
			}
		}
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '-')	goto yy1157;
	if(yych <= '0')	goto yy12;
	if(yych <= '9')	goto yy1158;
	goto yy12;
yy12:
	YYDEBUG(12, *YYCURSOR);

{
/*		printf("unexpected character: #%d, %c ", *s->tok, *s->tok); */
		s->errors++;
		goto std;
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':	case 'o':	case 'w':	case 'y':	goto yy1121;
	case '-':	goto yy615;
	case '.':	goto yy1123;
	case '/':	goto yy614;
	case '0':	goto yy1156;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1155;
	case ':':	goto yy1124;
	case 'n':	goto yy612;
	case 'r':	goto yy613;
	case 's':	goto yy606;
	case 't':	goto yy610;
	default:	goto yy12;
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':
	case 'P':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':	case 'o':
	case 'p':	case 'w':	case 'y':	goto yy604;
	case '-':	goto yy615;
	case '.':	goto yy618;
	case '/':	goto yy614;
	case '0':
	case '1':
	case '2':	goto yy1155;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1122;
	case ':':	goto yy627;
	case 'n':	goto yy612;
	case 'r':	goto yy613;
	case 's':	goto yy606;
	case 't':	goto yy610;
	default:	goto yy12;
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':
	case 'P':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':	case 'o':
	case 'p':	case 'w':	case 'y':	goto yy604;
	case '-':	goto yy615;
	case '.':	goto yy618;
	case '/':	goto yy614;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1122;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1119;
	case ':':	goto yy627;
	case 'n':	goto yy612;
	case 'r':	goto yy613;
	case 's':	goto yy606;
	case 't':	goto yy610;
	default:	goto yy12;
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':
	case 'P':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':	case 'o':
	case 'p':	case 'w':	case 'y':	goto yy604;
	case '-':	goto yy615;
	case '.':	goto yy618;
	case '/':	goto yy614;
	case '0':
	case '1':	goto yy1119;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy611;
	case ':':	goto yy627;
	case 'n':	goto yy612;
	case 'r':	goto yy613;
	case 's':	goto yy606;
	case 't':	goto yy610;
	default:	goto yy12;
	}
yy17:
	YYDEBUG(17, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':
	case 'P':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':	case 'o':
	case 'p':	case 'w':	case 'y':	goto yy604;
	case '-':	goto yy615;
	case '.':	goto yy618;
	case '/':	goto yy614;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy611;
	case ':':	goto yy627;
	case 'n':	goto yy612;
	case 'r':	goto yy613;
	case 's':	goto yy606;
	case 't':	goto yy610;
	default:	goto yy12;
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '/')	goto yy3;
			if(yych <= '9')	goto yy359;
			if(yych <= '@')	goto yy3;
			goto yy133;
		}
	} else {
		if(yych <= 'W'){
			if(yych <= 'I')	goto yy602;
			if(yych == 'V')	goto yy601;
			goto yy133;
		} else {
			if(yych <= 'Z'){
				if(yych <= 'X')	goto yy601;
				goto yy133;
			} else {
				if(yych <= '`')	goto yy3;
				if(yych <= 'z')	goto yy136;
				goto yy3;
			}
		}
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy359;
			goto yy360;
		} else {
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'I'){
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy133;
			goto yy599;
		} else {
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy136;
			goto yy3;
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy359;
			goto yy360;
		} else {
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'I'){
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy133;
			goto yy597;
		} else {
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy136;
			goto yy3;
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= '@'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= 'A')	goto yy580;
			if(yych <= 'T')	goto yy133;
			goto yy579;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			goto yy589;
		} else {
			if(yych == 'u')	goto yy588;
			if(yych <= 'z')	goto yy136;
			goto yy3;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= '@'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= 'A')	goto yy580;
			if(yych <= 'T')	goto yy133;
			goto yy579;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			goto yy580;
		} else {
			if(yych == 'u')	goto yy579;
			if(yych <= 'z')	goto yy133;
			goto yy3;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'E'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy132;
			} else {
				if(yych <= '@')	goto yy3;
				if(yych <= 'D')	goto yy133;
				goto yy541;
			}
		} else {
			if(yych <= 'N'){
				if(yych == 'I')	goto yy542;
				goto yy133;
			} else {
				if(yych <= 'O')	goto yy543;
				if(yych <= 'Q')	goto yy133;
				goto yy544;
			}
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'd'){
				if(yych <= 'Z')	goto yy133;
				if(yych <= '`')	goto yy3;
				goto yy136;
			} else {
				if(yych <= 'e')	goto yy560;
				if(yych <= 'h')	goto yy136;
				goto yy561;
			}
		} else {
			if(yych <= 'q'){
				if(yych == 'o')	goto yy562;
				goto yy136;
			} else {
				if(yych <= 'r')	goto yy563;
				if(yych <= 'z')	goto yy136;
				goto yy3;
			}
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'E'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy132;
			} else {
				if(yych <= '@')	goto yy3;
				if(yych <= 'D')	goto yy133;
				goto yy541;
			}
		} else {
			if(yych <= 'N'){
				if(yych == 'I')	goto yy542;
				goto yy133;
			} else {
				if(yych <= 'O')	goto yy543;
				if(yych <= 'Q')	goto yy133;
				goto yy544;
			}
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'd'){
				if(yych <= 'Z')	goto yy133;
				if(yych <= '`')	goto yy3;
				goto yy133;
			} else {
				if(yych <= 'e')	goto yy541;
				if(yych <= 'h')	goto yy133;
				goto yy542;
			}
		} else {
			if(yych <= 'q'){
				if(yych == 'o')	goto yy543;
				goto yy133;
			} else {
				if(yych <= 'r')	goto yy544;
				if(yych <= 'z')	goto yy133;
				goto yy3;
			}
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'F'){
			if(yych == ')')	goto yy132;
			if(yych <= '@')	goto yy3;
			goto yy133;
		} else {
			if(yych <= 'O'){
				if(yych <= 'G')	goto yy524;
				goto yy133;
			} else {
				if(yych <= 'P')	goto yy523;
				if(yych <= 'T')	goto yy133;
				goto yy522;
			}
		}
	} else {
		if(yych <= 'o'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy133;
				goto yy3;
			} else {
				if(yych == 'g')	goto yy534;
				goto yy136;
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'p')	goto yy533;
				goto yy136;
			} else {
				if(yych <= 'u')	goto yy532;
				if(yych <= 'z')	goto yy136;
				goto yy3;
			}
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'F'){
			if(yych == ')')	goto yy132;
			if(yych <= '@')	goto yy3;
			goto yy133;
		} else {
			if(yych <= 'O'){
				if(yych <= 'G')	goto yy524;
				goto yy133;
			} else {
				if(yych <= 'P')	goto yy523;
				if(yych <= 'T')	goto yy133;
				goto yy522;
			}
		}
	} else {
		if(yych <= 'o'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy133;
				goto yy3;
			} else {
				if(yych == 'g')	goto yy524;
				goto yy133;
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'p')	goto yy523;
				goto yy133;
			} else {
				if(yych <= 'u')	goto yy522;
				if(yych <= 'z')	goto yy133;
				goto yy3;
			}
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy132;
			} else {
				if(yych <= '@')	goto yy3;
				if(yych <= 'A')	goto yy469;
				goto yy133;
			}
		} else {
			if(yych <= 'H'){
				if(yych <= 'E')	goto yy468;
				goto yy133;
			} else {
				if(yych <= 'I')	goto yy470;
				if(yych <= 'T')	goto yy133;
				goto yy471;
			}
		}
	} else {
		if(yych <= 'e'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy133;
				goto yy3;
			} else {
				if(yych <= 'a')	goto yy496;
				if(yych <= 'd')	goto yy136;
				goto yy495;
			}
		} else {
			if(yych <= 't'){
				if(yych == 'i')	goto yy497;
				goto yy136;
			} else {
				if(yych <= 'u')	goto yy498;
				if(yych <= 'z')	goto yy136;
				goto yy3;
			}
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy132;
			} else {
				if(yych <= '@')	goto yy3;
				if(yych <= 'A')	goto yy469;
				goto yy133;
			}
		} else {
			if(yych <= 'H'){
				if(yych <= 'E')	goto yy468;
				goto yy133;
			} else {
				if(yych <= 'I')	goto yy470;
				if(yych <= 'T')	goto yy133;
				goto yy471;
			}
		}
	} else {
		if(yych <= 'e'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy133;
				goto yy3;
			} else {
				if(yych <= 'a')	goto yy469;
				if(yych <= 'd')	goto yy133;
				goto yy468;
			}
		} else {
			if(yych <= 't'){
				if(yych == 'i')	goto yy470;
				goto yy133;
			} else {
				if(yych <= 'u')	goto yy471;
				if(yych <= 'z')	goto yy133;
				goto yy3;
			}
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'C'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'B')	goto yy133;
			goto yy458;
		}
	} else {
		if(yych <= 'b'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			goto yy136;
		} else {
			if(yych <= 'c')	goto yy463;
			if(yych <= 'z')	goto yy136;
			goto yy3;
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'C'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'B')	goto yy133;
			goto yy458;
		}
	} else {
		if(yych <= 'b'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			goto yy133;
		} else {
			if(yych <= 'c')	goto yy458;
			if(yych <= 'z')	goto yy133;
			goto yy3;
		}
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy133;
			goto yy356;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			goto yy136;
		} else {
			if(yych <= 'e')	goto yy451;
			if(yych <= 'z')	goto yy136;
			goto yy3;
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy133;
			goto yy356;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			goto yy133;
		} else {
			if(yych <= 'e')	goto yy356;
			if(yych <= 'z')	goto yy133;
			goto yy3;
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy133;
			goto yy339;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			goto yy136;
		} else {
			if(yych <= 'e')	goto yy348;
			if(yych <= 'z')	goto yy136;
			goto yy3;
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy133;
			goto yy339;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			goto yy133;
		} else {
			if(yych <= 'e')	goto yy339;
			if(yych <= 'z')	goto yy133;
			goto yy3;
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych <= '@'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych == 'I')	goto yy321;
			if(yych <= 'K')	goto yy133;
			goto yy322;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			if(yych <= 'h')	goto yy136;
			goto yy330;
		} else {
			if(yych == 'l')	goto yy331;
			if(yych <= 'z')	goto yy136;
			goto yy3;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych <= '@'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych == 'I')	goto yy321;
			if(yych <= 'K')	goto yy133;
			goto yy322;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			if(yych <= 'h')	goto yy133;
			goto yy321;
		} else {
			if(yych == 'l')	goto yy322;
			if(yych <= 'z')	goto yy133;
			goto yy3;
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy132;
		if(yych <= '@')	goto yy3;
		goto yy315;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy133;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy318;
			if(yych <= 'z')	goto yy136;
			goto yy3;
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy132;
		if(yych <= '@')	goto yy3;
		goto yy315;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy133;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy315;
			if(yych <= 'z')	goto yy133;
			goto yy3;
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy133;
			goto yy153;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			goto yy136;
		} else {
			if(yych <= 'r')	goto yy235;
			if(yych <= 'z')	goto yy136;
			goto yy3;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy133;
			goto yy153;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy133;
			if(yych <= '`')	goto yy3;
			goto yy133;
		} else {
			if(yych <= 'r')	goto yy153;
			if(yych <= 'z')	goto yy133;
			goto yy3;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 16) {
		goto yy54;
	}
	if(yych <= '/')	goto yy12;
	if(yych <= '1')	goto yy146;
	if(yych <= '2')	goto yy147;
	if(yych <= '9')	goto yy148;
	goto yy12;
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@')	goto yy12;
	if(yych <= 'Z')	goto yy145;
	if(yych <= '`')	goto yy12;
	if(yych <= 'z')	goto yy145;
	goto yy12;
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy133;
		if(yych <= '`')	goto yy3;
		if(yych <= 'z')	goto yy136;
		goto yy3;
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy133;
		if(yych <= '`')	goto yy3;
		if(yych <= 'z')	goto yy133;
		goto yy3;
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 16) {
		goto yy54;
	}
	if(yych <= '/')	goto yy46;
	if(yych <= '9')	goto yy51;
	goto yy46;
yy46:
	YYDEBUG(46, *YYCURSOR);

{
		goto std;
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy46;
yy48:
	YYDEBUG(48, *YYCURSOR);
	++YYCURSOR;
	goto yy49;
yy49:
	YYDEBUG(49, *YYCURSOR);

{
		s->pos = cursor; s->line++;
		goto std;
	}
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy12;
yy51:
	YYDEBUG(51, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	goto yy52;
yy52:
	YYDEBUG(52, *YYCURSOR);
	if(yybm[0+yych] & 8) {
		goto yy51;
	}
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	goto yy56;
	case 'D':	case 'd':	goto yy61;
	case 'F':	case 'f':	goto yy63;
	case 'H':	case 'h':	goto yy60;
	case 'M':	case 'm':	goto yy59;
	case 'S':	case 's':	goto yy58;
	case 'T':	case 't':	goto yy65;
	case 'W':	case 'w':	goto yy62;
	case 'Y':	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy53:
	YYDEBUG(53, *YYCURSOR);
	YYCURSOR = YYMARKER;
	switch(yyaccept){
	case 26:	goto yy1291;
	case 24:	goto yy1260;
	case 25:	goto yy1268;
	case 23:	goto yy1184;
	case 22:	goto yy1181;
	case 11:	goto yy634;
	case 20:	goto yy1127;
	case 21:	goto yy1135;
	case 13:	goto yy784;
	case 18:	goto yy1024;
	case 12:	goto yy775;
	case 8:	goto yy420;
	case 17:	goto yy889;
	case 6:	goto yy363;
	case 10:	goto yy620;
	case 16:	goto yy922;
	case 19:	goto yy933;
	case 15:	goto yy915;
	case 14:	goto yy880;
	case 9:	goto yy526;
	case 5:	goto yy341;
	case 4:	goto yy172;
	case 1:	goto yy3;
	case 7:	goto yy385;
	case 3:	goto yy69;
	case 2:	goto yy46;
	case 0:	goto yy12;
	}
yy54:
	YYDEBUG(54, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy55;
yy55:
	YYDEBUG(55, *YYCURSOR);
	if(yybm[0+yych] & 16) {
		goto yy54;
	}
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy51;
	goto yy53;
yy56:
	YYDEBUG(56, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	goto yy57;
yy57:
	YYDEBUG(57, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	goto yy56;
	case 'D':	case 'd':	goto yy61;
	case 'F':	case 'f':	goto yy63;
	case 'H':	case 'h':	goto yy60;
	case 'M':	case 'm':	goto yy59;
	case 'S':	case 's':	goto yy58;
	case 'T':	case 't':	goto yy65;
	case 'W':	case 'w':	goto yy62;
	case 'Y':	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy58:
	YYDEBUG(58, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy119;
			goto yy53;
		} else {
			if(yych <= 'E')	goto yy120;
			if(yych <= 'T')	goto yy53;
			goto yy118;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'a')	goto yy119;
			goto yy53;
		} else {
			if(yych <= 'e')	goto yy120;
			if(yych == 'u')	goto yy118;
			goto yy53;
		}
	}
yy59:
	YYDEBUG(59, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych == 'I')	goto yy110;
		if(yych <= 'N')	goto yy53;
		goto yy109;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy53;
			goto yy110;
		} else {
			if(yych == 'o')	goto yy109;
			goto yy53;
		}
	}
yy60:
	YYDEBUG(60, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy107;
	if(yych == 'o')	goto yy107;
	goto yy53;
yy61:
	YYDEBUG(61, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy106;
	if(yych == 'a')	goto yy106;
	goto yy53;
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy98;
	if(yych == 'e')	goto yy98;
	goto yy53;
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'O')	goto yy83;
		if(yych <= 'Q')	goto yy53;
		goto yy82;
	} else {
		if(yych <= 'o'){
			if(yych <= 'n')	goto yy53;
			goto yy83;
		} else {
			if(yych == 'r')	goto yy82;
			goto yy53;
		}
	}
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy79;
	if(yych == 'e')	goto yy79;
	goto yy53;
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'H')	goto yy66;
		if(yych <= 'T')	goto yy53;
		goto yy67;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy53;
			goto yy66;
		} else {
			if(yych == 'u')	goto yy67;
			goto yy53;
		}
	}
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy74;
	if(yych == 'u')	goto yy74;
	goto yy53;
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy68;
	if(yych != 'e')	goto yy53;
	goto yy68;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'S')	goto yy70;
	if(yych == 's')	goto yy70;
	goto yy69;
yy69:
	YYDEBUG(69, *YYCURSOR);

{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 0, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy71;
	if(yych != 'd')	goto yy53;
	goto yy71;
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy72;
	if(yych != 'a')	goto yy53;
	goto yy72;
yy72:
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy73;
	if(yych != 'y')	goto yy53;
	goto yy73;
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy69;
yy74:
	YYDEBUG(74, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'R')	goto yy75;
	if(yych != 'r')	goto yy69;
	goto yy75;
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy76;
	if(yych != 's')	goto yy53;
	goto yy76;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy77;
	if(yych != 'd')	goto yy53;
	goto yy77;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy78;
	if(yych != 'a')	goto yy53;
	goto yy78;
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy73;
	if(yych == 'y')	goto yy73;
	goto yy53;
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy80;
	if(yych != 'a')	goto yy53;
	goto yy80;
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy81;
	if(yych != 'r')	goto yy53;
	goto yy81;
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy73;
	if(yych == 's')	goto yy73;
	goto yy69;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy95;
	if(yych == 'i')	goto yy95;
	goto yy53;
yy83:
	YYDEBUG(83, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy84;
	if(yych != 'r')	goto yy53;
	goto yy84;
yy84:
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy85;
	if(yych != 't')	goto yy53;
	goto yy85;
yy85:
	YYDEBUG(85, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'H')	goto yy87;
		if(yych <= 'M')	goto yy53;
		goto yy86;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy53;
			goto yy87;
		} else {
			if(yych != 'n')	goto yy53;
			goto yy86;
		}
	}
yy86:
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy92;
	if(yych == 'i')	goto yy92;
	goto yy53;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy88;
	if(yych != 'n')	goto yy53;
	goto yy88;
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy89;
	if(yych != 'i')	goto yy53;
	goto yy89;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy90;
	if(yych != 'g')	goto yy53;
	goto yy90;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy91;
	if(yych != 'h')	goto yy53;
	goto yy91;
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy81;
	if(yych == 't')	goto yy81;
	goto yy53;
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy93;
	if(yych != 'g')	goto yy53;
	goto yy93;
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy94;
	if(yych != 'h')	goto yy53;
	goto yy94;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy81;
	if(yych == 't')	goto yy81;
	goto yy53;
yy95:
	YYDEBUG(95, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'D')	goto yy96;
	if(yych != 'd')	goto yy69;
	goto yy96;
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy97;
	if(yych != 'a')	goto yy53;
	goto yy97;
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy73;
	if(yych == 'y')	goto yy73;
	goto yy53;
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= 'C')	goto yy53;
		if(yych <= 'D')	goto yy100;
		goto yy99;
	} else {
		if(yych <= 'c')	goto yy53;
		if(yych <= 'd')	goto yy100;
		if(yych >= 'f')	goto yy53;
		goto yy99;
	}
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'K')	goto yy81;
	if(yych == 'k')	goto yy81;
	goto yy53;
yy100:
	YYDEBUG(100, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'N')	goto yy101;
	if(yych != 'n')	goto yy69;
	goto yy101;
yy101:
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy102;
	if(yych != 'e')	goto yy53;
	goto yy102;
yy102:
	YYDEBUG(102, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy103;
	if(yych != 's')	goto yy53;
	goto yy103;
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy104;
	if(yych != 'd')	goto yy53;
	goto yy104;
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy105;
	if(yych != 'a')	goto yy53;
	goto yy105;
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy73;
	if(yych == 'y')	goto yy73;
	goto yy53;
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy81;
	if(yych == 'y')	goto yy81;
	goto yy53;
yy107:
	YYDEBUG(107, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy108;
	if(yych != 'u')	goto yy53;
	goto yy108;
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy81;
	if(yych == 'r')	goto yy81;
	goto yy53;
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy114;
	if(yych == 'n')	goto yy114;
	goto yy53;
yy110:
	YYDEBUG(110, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy111;
	if(yych != 'n')	goto yy53;
	goto yy111;
yy111:
	YYDEBUG(111, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych == 'S')	goto yy73;
		if(yych <= 'T')	goto yy69;
		goto yy112;
	} else {
		if(yych <= 's'){
			if(yych <= 'r')	goto yy69;
			goto yy73;
		} else {
			if(yych != 'u')	goto yy69;
			goto yy112;
		}
	}
yy112:
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy113;
	if(yych != 't')	goto yy53;
	goto yy113;
yy113:
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy81;
	if(yych == 'e')	goto yy81;
	goto yy53;
yy114:
	YYDEBUG(114, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych == 'D')	goto yy115;
		if(yych <= 'S')	goto yy69;
		goto yy116;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy69;
			goto yy115;
		} else {
			if(yych == 't')	goto yy116;
			goto yy69;
		}
	}
yy115:
	YYDEBUG(115, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy117;
	if(yych == 'a')	goto yy117;
	goto yy53;
yy116:
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy81;
	if(yych == 'h')	goto yy81;
	goto yy53;
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy73;
	if(yych == 'y')	goto yy73;
	goto yy53;
yy118:
	YYDEBUG(118, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy129;
	if(yych == 'n')	goto yy129;
	goto yy53;
yy119:
	YYDEBUG(119, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy124;
	if(yych == 't')	goto yy124;
	goto yy53;
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy121;
	if(yych != 'c')	goto yy53;
	goto yy121;
yy121:
	YYDEBUG(121, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == 'O')	goto yy122;
		if(yych <= 'R')	goto yy69;
		goto yy73;
	} else {
		if(yych <= 'o'){
			if(yych <= 'n')	goto yy69;
			goto yy122;
		} else {
			if(yych == 's')	goto yy73;
			goto yy69;
		}
	}
yy122:
	YYDEBUG(122, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy123;
	if(yych != 'n')	goto yy53;
	goto yy123;
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy81;
	if(yych == 'd')	goto yy81;
	goto yy53;
yy124:
	YYDEBUG(124, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'U')	goto yy125;
	if(yych != 'u')	goto yy69;
	goto yy125;
yy125:
	YYDEBUG(125, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy126;
	if(yych != 'r')	goto yy53;
	goto yy126;
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy127;
	if(yych != 'd')	goto yy53;
	goto yy127;
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy128;
	if(yych != 'a')	goto yy53;
	goto yy128;
yy128:
	YYDEBUG(128, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy73;
	if(yych == 'y')	goto yy73;
	goto yy53;
yy129:
	YYDEBUG(129, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'D')	goto yy130;
	if(yych != 'd')	goto yy69;
	goto yy130;
yy130:
	YYDEBUG(130, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy131;
	if(yych != 'a')	goto yy53;
	goto yy131;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy73;
	if(yych == 'y')	goto yy73;
	goto yy53;
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy3;
yy133:
	YYDEBUG(133, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy134;
		if(yych <= '`')	goto yy3;
		if(yych >= '{')	goto yy3;
		goto yy134;
	}
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy135;
		if(yych <= '`')	goto yy3;
		if(yych >= '{')	goto yy3;
		goto yy135;
	}
yy135:
	YYDEBUG(135, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == ')')	goto yy132;
	goto yy3;
yy136:
	YYDEBUG(136, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych == '/')	goto yy138;
			goto yy3;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '^')	goto yy3;
			goto yy138;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych >= '{')	goto yy3;
			goto yy137;
		}
	}
yy137:
	YYDEBUG(137, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych != '/')	goto yy3;
			goto yy138;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '^')	goto yy3;
			goto yy138;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy138:
	YYDEBUG(138, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '@')	goto yy53;
	if(yych >= '[')	goto yy53;
	goto yy139;
yy139:
	YYDEBUG(139, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 32) {
		goto yy140;
	}
	goto yy53;
yy140:
	YYDEBUG(140, *YYCURSOR);
	yyaccept = 1;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy141;
yy141:
	YYDEBUG(141, *YYCURSOR);
	if(yybm[0+yych] & 32) {
		goto yy140;
	}
	if(yych == '/')	goto yy138;
	if(yych == '_')	goto yy138;
	goto yy3;
yy142:
	YYDEBUG(142, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == ')')	goto yy132;
		if(yych <= '.')	goto yy3;
		goto yy138;
	} else {
		if(yych <= '_'){
			if(yych <= '^')	goto yy3;
			goto yy138;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych >= '{')	goto yy3;
			goto yy143;
		}
	}
yy143:
	YYDEBUG(143, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy144;
yy144:
	YYDEBUG(144, *YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy138;
		goto yy53;
	} else {
		if(yych <= '_')	goto yy138;
		if(yych <= '`')	goto yy53;
		if(yych <= 'z')	goto yy143;
		goto yy53;
	}
yy145:
	YYDEBUG(145, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy133;
		if(yych <= '`')	goto yy3;
		if(yych <= 'z')	goto yy133;
		goto yy3;
	}
yy146:
	YYDEBUG(146, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy148;
	case ':':	goto yy149;
	default:	goto yy3;
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy148;
	case '4':
	case '5':	goto yy150;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy151;
	case ':':	goto yy149;
	default:	goto yy3;
	}
yy148:
	YYDEBUG(148, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy150;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy151;
	case ':':	goto yy149;
	default:	goto yy3;
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy3;
	if(yych <= '5')	goto yy152;
	if(yych <= '9')	goto yy132;
	goto yy3;
yy150:
	YYDEBUG(150, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy151;
	default:	goto yy3;
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 8) {
		goto yy51;
	}
	if(yych <= 'X'){
		if(yych <= 'G'){
			if(yych <= 'C'){
				if(yych == ' ')	goto yy57;
				goto yy3;
			} else {
				if(yych == 'E')	goto yy3;
				if(yych <= 'F')	goto yy57;
				goto yy3;
			}
		} else {
			if(yych <= 'R'){
				if(yych <= 'H')	goto yy57;
				if(yych == 'M')	goto yy57;
				goto yy3;
			} else {
				if(yych <= 'T')	goto yy57;
				if(yych == 'W')	goto yy57;
				goto yy3;
			}
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'e'){
				if(yych <= 'Y')	goto yy57;
				if(yych == 'd')	goto yy57;
				goto yy3;
			} else {
				if(yych == 'g')	goto yy3;
				if(yych <= 'h')	goto yy57;
				goto yy3;
			}
		} else {
			if(yych <= 'v'){
				if(yych <= 'm')	goto yy57;
				if(yych <= 'r')	goto yy3;
				if(yych <= 't')	goto yy57;
				goto yy3;
			} else {
				if(yych == 'x')	goto yy3;
				if(yych <= 'y')	goto yy57;
				goto yy3;
			}
		}
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy3;
	if(yych <= '9')	goto yy132;
	goto yy3;
yy153:
	YYDEBUG(153, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy134;
			goto yy154;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'e')	goto yy154;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy154:
	YYDEBUG(154, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'U')	goto yy135;
			goto yy155;
		}
	} else {
		if(yych <= 'u'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 'v')	goto yy155;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'I')	goto yy156;
		if(yych != 'i')	goto yy3;
		goto yy156;
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy157;
	if(yych != 'o')	goto yy53;
	goto yy157;
yy157:
	YYDEBUG(157, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy158;
	if(yych != 'u')	goto yy53;
	goto yy158;
yy158:
	YYDEBUG(158, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy159;
	if(yych != 's')	goto yy53;
	goto yy159;
yy159:
	YYDEBUG(159, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	goto yy160;
yy160:
	YYDEBUG(160, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	goto yy159;
	case 'D':	case 'd':	goto yy164;
	case 'F':	case 'f':	goto yy166;
	case 'H':	case 'h':	goto yy163;
	case 'M':	case 'm':	goto yy162;
	case 'S':	case 's':	goto yy161;
	case 'T':	case 't':	goto yy168;
	case 'W':	case 'w':	goto yy165;
	case 'Y':	case 'y':	goto yy167;
	default:	goto yy53;
	}
yy161:
	YYDEBUG(161, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy222;
			goto yy53;
		} else {
			if(yych <= 'E')	goto yy223;
			if(yych <= 'T')	goto yy53;
			goto yy221;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'a')	goto yy222;
			goto yy53;
		} else {
			if(yych <= 'e')	goto yy223;
			if(yych == 'u')	goto yy221;
			goto yy53;
		}
	}
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych == 'I')	goto yy213;
		if(yych <= 'N')	goto yy53;
		goto yy212;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy53;
			goto yy213;
		} else {
			if(yych == 'o')	goto yy212;
			goto yy53;
		}
	}
yy163:
	YYDEBUG(163, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy210;
	if(yych == 'o')	goto yy210;
	goto yy53;
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy209;
	if(yych == 'a')	goto yy209;
	goto yy53;
yy165:
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy201;
	if(yych == 'e')	goto yy201;
	goto yy53;
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'O')	goto yy186;
		if(yych <= 'Q')	goto yy53;
		goto yy185;
	} else {
		if(yych <= 'o'){
			if(yych <= 'n')	goto yy53;
			goto yy186;
		} else {
			if(yych == 'r')	goto yy185;
			goto yy53;
		}
	}
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy182;
	if(yych == 'e')	goto yy182;
	goto yy53;
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'H')	goto yy169;
		if(yych <= 'T')	goto yy53;
		goto yy170;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy53;
			goto yy169;
		} else {
			if(yych == 'u')	goto yy170;
			goto yy53;
		}
	}
yy169:
	YYDEBUG(169, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy177;
	if(yych == 'u')	goto yy177;
	goto yy53;
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy171;
	if(yych != 'e')	goto yy53;
	goto yy171;
yy171:
	YYDEBUG(171, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'S')	goto yy173;
	if(yych == 's')	goto yy173;
	goto yy172;
yy172:
	YYDEBUG(172, *YYCURSOR);

{
		timelib_sll i;
		int         behavior;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy173:
	YYDEBUG(173, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy174;
	if(yych != 'd')	goto yy53;
	goto yy174;
yy174:
	YYDEBUG(174, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy175;
	if(yych != 'a')	goto yy53;
	goto yy175;
yy175:
	YYDEBUG(175, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy176;
	if(yych != 'y')	goto yy53;
	goto yy176;
yy176:
	YYDEBUG(176, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy172;
yy177:
	YYDEBUG(177, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'R')	goto yy178;
	if(yych != 'r')	goto yy172;
	goto yy178;
yy178:
	YYDEBUG(178, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy179;
	if(yych != 's')	goto yy53;
	goto yy179;
yy179:
	YYDEBUG(179, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy180;
	if(yych != 'd')	goto yy53;
	goto yy180;
yy180:
	YYDEBUG(180, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy181;
	if(yych != 'a')	goto yy53;
	goto yy181;
yy181:
	YYDEBUG(181, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy176;
	if(yych == 'y')	goto yy176;
	goto yy53;
yy182:
	YYDEBUG(182, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy183;
	if(yych != 'a')	goto yy53;
	goto yy183;
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy184;
	if(yych != 'r')	goto yy53;
	goto yy184;
yy184:
	YYDEBUG(184, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy176;
	if(yych == 's')	goto yy176;
	goto yy172;
yy185:
	YYDEBUG(185, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy198;
	if(yych == 'i')	goto yy198;
	goto yy53;
yy186:
	YYDEBUG(186, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy187;
	if(yych != 'r')	goto yy53;
	goto yy187;
yy187:
	YYDEBUG(187, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy188;
	if(yych != 't')	goto yy53;
	goto yy188;
yy188:
	YYDEBUG(188, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'H')	goto yy190;
		if(yych <= 'M')	goto yy53;
		goto yy189;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy53;
			goto yy190;
		} else {
			if(yych != 'n')	goto yy53;
			goto yy189;
		}
	}
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy195;
	if(yych == 'i')	goto yy195;
	goto yy53;
yy190:
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy191;
	if(yych != 'n')	goto yy53;
	goto yy191;
yy191:
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy192;
	if(yych != 'i')	goto yy53;
	goto yy192;
yy192:
	YYDEBUG(192, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy193;
	if(yych != 'g')	goto yy53;
	goto yy193;
yy193:
	YYDEBUG(193, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy194;
	if(yych != 'h')	goto yy53;
	goto yy194;
yy194:
	YYDEBUG(194, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy184;
	if(yych == 't')	goto yy184;
	goto yy53;
yy195:
	YYDEBUG(195, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy196;
	if(yych != 'g')	goto yy53;
	goto yy196;
yy196:
	YYDEBUG(196, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy197;
	if(yych != 'h')	goto yy53;
	goto yy197;
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy184;
	if(yych == 't')	goto yy184;
	goto yy53;
yy198:
	YYDEBUG(198, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'D')	goto yy199;
	if(yych != 'd')	goto yy172;
	goto yy199;
yy199:
	YYDEBUG(199, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy200;
	if(yych != 'a')	goto yy53;
	goto yy200;
yy200:
	YYDEBUG(200, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy176;
	if(yych == 'y')	goto yy176;
	goto yy53;
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= 'C')	goto yy53;
		if(yych <= 'D')	goto yy203;
		goto yy202;
	} else {
		if(yych <= 'c')	goto yy53;
		if(yych <= 'd')	goto yy203;
		if(yych >= 'f')	goto yy53;
		goto yy202;
	}
yy202:
	YYDEBUG(202, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'K')	goto yy184;
	if(yych == 'k')	goto yy184;
	goto yy53;
yy203:
	YYDEBUG(203, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'N')	goto yy204;
	if(yych != 'n')	goto yy172;
	goto yy204;
yy204:
	YYDEBUG(204, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy205;
	if(yych != 'e')	goto yy53;
	goto yy205;
yy205:
	YYDEBUG(205, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy206;
	if(yych != 's')	goto yy53;
	goto yy206;
yy206:
	YYDEBUG(206, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy207;
	if(yych != 'd')	goto yy53;
	goto yy207;
yy207:
	YYDEBUG(207, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy208;
	if(yych != 'a')	goto yy53;
	goto yy208;
yy208:
	YYDEBUG(208, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy176;
	if(yych == 'y')	goto yy176;
	goto yy53;
yy209:
	YYDEBUG(209, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy184;
	if(yych == 'y')	goto yy184;
	goto yy53;
yy210:
	YYDEBUG(210, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy211;
	if(yych != 'u')	goto yy53;
	goto yy211;
yy211:
	YYDEBUG(211, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy184;
	if(yych == 'r')	goto yy184;
	goto yy53;
yy212:
	YYDEBUG(212, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy217;
	if(yych == 'n')	goto yy217;
	goto yy53;
yy213:
	YYDEBUG(213, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy214;
	if(yych != 'n')	goto yy53;
	goto yy214;
yy214:
	YYDEBUG(214, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych == 'S')	goto yy176;
		if(yych <= 'T')	goto yy172;
		goto yy215;
	} else {
		if(yych <= 's'){
			if(yych <= 'r')	goto yy172;
			goto yy176;
		} else {
			if(yych != 'u')	goto yy172;
			goto yy215;
		}
	}
yy215:
	YYDEBUG(215, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy216;
	if(yych != 't')	goto yy53;
	goto yy216;
yy216:
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy184;
	if(yych == 'e')	goto yy184;
	goto yy53;
yy217:
	YYDEBUG(217, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych == 'D')	goto yy218;
		if(yych <= 'S')	goto yy172;
		goto yy219;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy172;
			goto yy218;
		} else {
			if(yych == 't')	goto yy219;
			goto yy172;
		}
	}
yy218:
	YYDEBUG(218, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy220;
	if(yych == 'a')	goto yy220;
	goto yy53;
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy184;
	if(yych == 'h')	goto yy184;
	goto yy53;
yy220:
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy176;
	if(yych == 'y')	goto yy176;
	goto yy53;
yy221:
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy232;
	if(yych == 'n')	goto yy232;
	goto yy53;
yy222:
	YYDEBUG(222, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy227;
	if(yych == 't')	goto yy227;
	goto yy53;
yy223:
	YYDEBUG(223, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy224;
	if(yych != 'c')	goto yy53;
	goto yy224;
yy224:
	YYDEBUG(224, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == 'O')	goto yy225;
		if(yych <= 'R')	goto yy172;
		goto yy176;
	} else {
		if(yych <= 'o'){
			if(yych <= 'n')	goto yy172;
			goto yy225;
		} else {
			if(yych == 's')	goto yy176;
			goto yy172;
		}
	}
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy226;
	if(yych != 'n')	goto yy53;
	goto yy226;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy184;
	if(yych == 'd')	goto yy184;
	goto yy53;
yy227:
	YYDEBUG(227, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'U')	goto yy228;
	if(yych != 'u')	goto yy172;
	goto yy228;
yy228:
	YYDEBUG(228, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy229;
	if(yych != 'r')	goto yy53;
	goto yy229;
yy229:
	YYDEBUG(229, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy230;
	if(yych != 'd')	goto yy53;
	goto yy230;
yy230:
	YYDEBUG(230, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy231;
	if(yych != 'a')	goto yy53;
	goto yy231;
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy176;
	if(yych == 'y')	goto yy176;
	goto yy53;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'D')	goto yy233;
	if(yych != 'd')	goto yy172;
	goto yy233;
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy234;
	if(yych != 'a')	goto yy53;
	goto yy234;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy176;
	if(yych == 'y')	goto yy176;
	goto yy53;
yy235:
	YYDEBUG(235, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy134;
			goto yy154;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy236;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy236:
	YYDEBUG(236, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'U')	goto yy135;
			goto yy155;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'v')	goto yy237;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy237:
	YYDEBUG(237, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'I'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'H')	goto yy3;
			goto yy156;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'i')	goto yy238;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy238:
	YYDEBUG(238, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy157;
	if(yych != 'o')	goto yy144;
	goto yy239;
yy239:
	YYDEBUG(239, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy158;
	if(yych != 'u')	goto yy144;
	goto yy240;
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy53;
			goto yy138;
		} else {
			if(yych == 'S')	goto yy159;
			goto yy53;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy53;
			goto yy143;
		} else {
			if(yych <= 's')	goto yy241;
			if(yych <= 'z')	goto yy143;
			goto yy53;
		}
	}
yy241:
	YYDEBUG(241, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'h'){
		if(yych <= '`'){
			if(yych <= '/'){
				if(yych <= '.')	goto yy160;
				goto yy138;
			} else {
				if(yych == '_')	goto yy138;
				goto yy160;
			}
		} else {
			if(yych <= 'e'){
				if(yych == 'd')	goto yy245;
				goto yy143;
			} else {
				if(yych <= 'f')	goto yy247;
				if(yych <= 'g')	goto yy143;
				goto yy244;
			}
		}
	} else {
		if(yych <= 't'){
			if(yych <= 'm'){
				if(yych <= 'l')	goto yy143;
				goto yy243;
			} else {
				if(yych <= 'r')	goto yy143;
				if(yych >= 't')	goto yy249;
				goto yy242;
			}
		} else {
			if(yych <= 'x'){
				if(yych == 'w')	goto yy246;
				goto yy143;
			} else {
				if(yych <= 'y')	goto yy248;
				if(yych <= 'z')	goto yy143;
				goto yy160;
			}
		}
	}
yy242:
	YYDEBUG(242, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy222;
			goto yy144;
		} else {
			if(yych <= 'E')	goto yy223;
			if(yych <= 'T')	goto yy144;
			goto yy221;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'a')	goto yy301;
			goto yy144;
		} else {
			if(yych <= 'e')	goto yy302;
			if(yych == 'u')	goto yy303;
			goto yy144;
		}
	}
yy243:
	YYDEBUG(243, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych == 'I')	goto yy213;
		if(yych <= 'N')	goto yy144;
		goto yy212;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy144;
			goto yy292;
		} else {
			if(yych == 'o')	goto yy293;
			goto yy144;
		}
	}
yy244:
	YYDEBUG(244, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy210;
	if(yych == 'o')	goto yy290;
	goto yy144;
yy245:
	YYDEBUG(245, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy209;
	if(yych == 'a')	goto yy289;
	goto yy144;
yy246:
	YYDEBUG(246, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy201;
	if(yych == 'e')	goto yy281;
	goto yy144;
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'O')	goto yy186;
		if(yych <= 'Q')	goto yy144;
		goto yy185;
	} else {
		if(yych <= 'o'){
			if(yych <= 'n')	goto yy144;
			goto yy265;
		} else {
			if(yych == 'r')	goto yy266;
			goto yy144;
		}
	}
yy248:
	YYDEBUG(248, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy182;
	if(yych == 'e')	goto yy262;
	goto yy144;
yy249:
	YYDEBUG(249, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'H')	goto yy169;
		if(yych <= 'T')	goto yy144;
		goto yy170;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy144;
			goto yy250;
		} else {
			if(yych == 'u')	goto yy251;
			goto yy144;
		}
	}
yy250:
	YYDEBUG(250, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy177;
	if(yych == 'u')	goto yy257;
	goto yy144;
yy251:
	YYDEBUG(251, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy171;
	if(yych != 'e')	goto yy144;
	goto yy252;
yy252:
	YYDEBUG(252, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy172;
			goto yy138;
		} else {
			if(yych == 'S')	goto yy173;
			goto yy172;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy172;
			goto yy143;
		} else {
			if(yych <= 's')	goto yy253;
			if(yych <= 'z')	goto yy143;
			goto yy172;
		}
	}
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy174;
	if(yych != 'd')	goto yy144;
	goto yy254;
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy175;
	if(yych != 'a')	goto yy144;
	goto yy255;
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy176;
	if(yych != 'y')	goto yy144;
	goto yy256;
yy256:
	YYDEBUG(256, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy138;
		goto yy172;
	} else {
		if(yych <= '_')	goto yy138;
		if(yych <= '`')	goto yy172;
		if(yych <= 'z')	goto yy143;
		goto yy172;
	}
yy257:
	YYDEBUG(257, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy172;
			goto yy138;
		} else {
			if(yych == 'R')	goto yy178;
			goto yy172;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy172;
			goto yy143;
		} else {
			if(yych <= 'r')	goto yy258;
			if(yych <= 'z')	goto yy143;
			goto yy172;
		}
	}
yy258:
	YYDEBUG(258, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy179;
	if(yych != 's')	goto yy144;
	goto yy259;
yy259:
	YYDEBUG(259, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy180;
	if(yych != 'd')	goto yy144;
	goto yy260;
yy260:
	YYDEBUG(260, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy181;
	if(yych != 'a')	goto yy144;
	goto yy261;
yy261:
	YYDEBUG(261, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy176;
	if(yych == 'y')	goto yy256;
	goto yy144;
yy262:
	YYDEBUG(262, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy183;
	if(yych != 'a')	goto yy144;
	goto yy263;
yy263:
	YYDEBUG(263, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy184;
	if(yych != 'r')	goto yy144;
	goto yy264;
yy264:
	YYDEBUG(264, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy172;
			goto yy138;
		} else {
			if(yych == 'S')	goto yy176;
			goto yy172;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy172;
			goto yy143;
		} else {
			if(yych <= 's')	goto yy256;
			if(yych <= 'z')	goto yy143;
			goto yy172;
		}
	}
yy265:
	YYDEBUG(265, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy187;
	if(yych == 'r')	goto yy270;
	goto yy144;
yy266:
	YYDEBUG(266, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy198;
	if(yych != 'i')	goto yy144;
	goto yy267;
yy267:
	YYDEBUG(267, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy172;
			goto yy138;
		} else {
			if(yych == 'D')	goto yy199;
			goto yy172;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy172;
			goto yy143;
		} else {
			if(yych <= 'd')	goto yy268;
			if(yych <= 'z')	goto yy143;
			goto yy172;
		}
	}
yy268:
	YYDEBUG(268, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy200;
	if(yych != 'a')	goto yy144;
	goto yy269;
yy269:
	YYDEBUG(269, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy176;
	if(yych == 'y')	goto yy256;
	goto yy144;
yy270:
	YYDEBUG(270, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy188;
	if(yych != 't')	goto yy144;
	goto yy271;
yy271:
	YYDEBUG(271, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'H')	goto yy190;
		if(yych <= 'M')	goto yy144;
		goto yy189;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy144;
			goto yy273;
		} else {
			if(yych != 'n')	goto yy144;
			goto yy272;
		}
	}
yy272:
	YYDEBUG(272, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy195;
	if(yych == 'i')	goto yy278;
	goto yy144;
yy273:
	YYDEBUG(273, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy191;
	if(yych != 'n')	goto yy144;
	goto yy274;
yy274:
	YYDEBUG(274, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy192;
	if(yych != 'i')	goto yy144;
	goto yy275;
yy275:
	YYDEBUG(275, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy193;
	if(yych != 'g')	goto yy144;
	goto yy276;
yy276:
	YYDEBUG(276, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy194;
	if(yych != 'h')	goto yy144;
	goto yy277;
yy277:
	YYDEBUG(277, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy184;
	if(yych == 't')	goto yy264;
	goto yy144;
yy278:
	YYDEBUG(278, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy196;
	if(yych != 'g')	goto yy144;
	goto yy279;
yy279:
	YYDEBUG(279, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy197;
	if(yych != 'h')	goto yy144;
	goto yy280;
yy280:
	YYDEBUG(280, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy184;
	if(yych == 't')	goto yy264;
	goto yy144;
yy281:
	YYDEBUG(281, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= 'C')	goto yy144;
		if(yych <= 'D')	goto yy203;
		goto yy202;
	} else {
		if(yych <= 'c')	goto yy144;
		if(yych <= 'd')	goto yy283;
		if(yych >= 'f')	goto yy144;
		goto yy282;
	}
yy282:
	YYDEBUG(282, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'K')	goto yy184;
	if(yych == 'k')	goto yy264;
	goto yy144;
yy283:
	YYDEBUG(283, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy172;
			goto yy138;
		} else {
			if(yych == 'N')	goto yy204;
			goto yy172;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy172;
			goto yy143;
		} else {
			if(yych <= 'n')	goto yy284;
			if(yych <= 'z')	goto yy143;
			goto yy172;
		}
	}
yy284:
	YYDEBUG(284, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy205;
	if(yych != 'e')	goto yy144;
	goto yy285;
yy285:
	YYDEBUG(285, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy206;
	if(yych != 's')	goto yy144;
	goto yy286;
yy286:
	YYDEBUG(286, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy207;
	if(yych != 'd')	goto yy144;
	goto yy287;
yy287:
	YYDEBUG(287, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy208;
	if(yych != 'a')	goto yy144;
	goto yy288;
yy288:
	YYDEBUG(288, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy176;
	if(yych == 'y')	goto yy256;
	goto yy144;
yy289:
	YYDEBUG(289, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy184;
	if(yych == 'y')	goto yy264;
	goto yy144;
yy290:
	YYDEBUG(290, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy211;
	if(yych != 'u')	goto yy144;
	goto yy291;
yy291:
	YYDEBUG(291, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy184;
	if(yych == 'r')	goto yy264;
	goto yy144;
yy292:
	YYDEBUG(292, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy214;
	if(yych == 'n')	goto yy298;
	goto yy144;
yy293:
	YYDEBUG(293, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy217;
	if(yych != 'n')	goto yy144;
	goto yy294;
yy294:
	YYDEBUG(294, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych <= 'C'){
			if(yych == '/')	goto yy138;
			goto yy172;
		} else {
			if(yych <= 'D')	goto yy218;
			if(yych == 'T')	goto yy219;
			goto yy172;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy172;
			if(yych <= 'c')	goto yy143;
			goto yy295;
		} else {
			if(yych == 't')	goto yy296;
			if(yych <= 'z')	goto yy143;
			goto yy172;
		}
	}
yy295:
	YYDEBUG(295, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy220;
	if(yych == 'a')	goto yy297;
	goto yy144;
yy296:
	YYDEBUG(296, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy184;
	if(yych == 'h')	goto yy264;
	goto yy144;
yy297:
	YYDEBUG(297, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy176;
	if(yych == 'y')	goto yy256;
	goto yy144;
yy298:
	YYDEBUG(298, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych <= 'R'){
			if(yych == '/')	goto yy138;
			goto yy172;
		} else {
			if(yych <= 'S')	goto yy176;
			if(yych == 'U')	goto yy215;
			goto yy172;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy172;
			if(yych <= 'r')	goto yy143;
			goto yy256;
		} else {
			if(yych == 'u')	goto yy299;
			if(yych <= 'z')	goto yy143;
			goto yy172;
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy216;
	if(yych != 't')	goto yy144;
	goto yy300;
yy300:
	YYDEBUG(300, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy184;
	if(yych == 'e')	goto yy264;
	goto yy144;
yy301:
	YYDEBUG(301, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy227;
	if(yych == 't')	goto yy310;
	goto yy144;
yy302:
	YYDEBUG(302, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy224;
	if(yych == 'c')	goto yy307;
	goto yy144;
yy303:
	YYDEBUG(303, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy232;
	if(yych != 'n')	goto yy144;
	goto yy304;
yy304:
	YYDEBUG(304, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy172;
			goto yy138;
		} else {
			if(yych == 'D')	goto yy233;
			goto yy172;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy172;
			goto yy143;
		} else {
			if(yych <= 'd')	goto yy305;
			if(yych <= 'z')	goto yy143;
			goto yy172;
		}
	}
yy305:
	YYDEBUG(305, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy234;
	if(yych != 'a')	goto yy144;
	goto yy306;
yy306:
	YYDEBUG(306, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy176;
	if(yych == 'y')	goto yy256;
	goto yy144;
yy307:
	YYDEBUG(307, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych <= 'N'){
			if(yych == '/')	goto yy138;
			goto yy172;
		} else {
			if(yych <= 'O')	goto yy225;
			if(yych == 'S')	goto yy176;
			goto yy172;
		}
	} else {
		if(yych <= 'o'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy172;
			if(yych <= 'n')	goto yy143;
			goto yy308;
		} else {
			if(yych == 's')	goto yy256;
			if(yych <= 'z')	goto yy143;
			goto yy172;
		}
	}
yy308:
	YYDEBUG(308, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy226;
	if(yych != 'n')	goto yy144;
	goto yy309;
yy309:
	YYDEBUG(309, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy184;
	if(yych == 'd')	goto yy264;
	goto yy144;
yy310:
	YYDEBUG(310, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy172;
			goto yy138;
		} else {
			if(yych == 'U')	goto yy228;
			goto yy172;
		}
	} else {
		if(yych <= 't'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy172;
			goto yy143;
		} else {
			if(yych <= 'u')	goto yy311;
			if(yych <= 'z')	goto yy143;
			goto yy172;
		}
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy229;
	if(yych != 'r')	goto yy144;
	goto yy312;
yy312:
	YYDEBUG(312, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy230;
	if(yych != 'd')	goto yy144;
	goto yy313;
yy313:
	YYDEBUG(313, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy231;
	if(yych != 'a')	goto yy144;
	goto yy314;
yy314:
	YYDEBUG(314, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy176;
	if(yych == 'y')	goto yy256;
	goto yy144;
yy315:
	YYDEBUG(315, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy134;
			goto yy316;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 's')	goto yy316;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy316:
	YYDEBUG(316, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy135;
			goto yy317;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 't')	goto yy317;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy317:
	YYDEBUG(317, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy160;
	case ')':	goto yy132;
	default:	goto yy3;
	}
yy318:
	YYDEBUG(318, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy134;
			goto yy316;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 's')	goto yy319;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy135;
			goto yy317;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 't')	goto yy320;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	goto yy160;
	case ')':	goto yy132;
	case '/':	case '_':	goto yy138;
	case 'a':
	case 'b':
	case 'c':	case 'e':	case 'g':	case 'i':
	case 'j':
	case 'k':
	case 'l':	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':	case 'u':
	case 'v':	case 'x':	case 'z':	goto yy143;
	case 'd':	goto yy245;
	case 'f':	goto yy247;
	case 'h':	goto yy244;
	case 'm':	goto yy243;
	case 's':	goto yy242;
	case 't':	goto yy249;
	case 'w':	goto yy246;
	case 'y':	goto yy248;
	default:	goto yy3;
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'G'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy134;
			goto yy328;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'g')	goto yy328;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy322:
	YYDEBUG(322, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy134;
			goto yy323;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'e')	goto yy323;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'U')	goto yy135;
			goto yy324;
		}
	} else {
		if(yych <= 'u'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 'v')	goto yy324;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'E')	goto yy325;
		if(yych != 'e')	goto yy3;
		goto yy325;
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy326;
	if(yych != 'n')	goto yy53;
	goto yy326;
yy326:
	YYDEBUG(326, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy327;
	if(yych != 't')	goto yy53;
	goto yy327;
yy327:
	YYDEBUG(327, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy159;
	if(yych == 'h')	goto yy159;
	goto yy53;
yy328:
	YYDEBUG(328, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy135;
			goto yy329;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 'h')	goto yy329;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'T')	goto yy159;
		if(yych == 't')	goto yy159;
		goto yy3;
	}
yy330:
	YYDEBUG(330, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy134;
			goto yy328;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'g')	goto yy337;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy331:
	YYDEBUG(331, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy134;
			goto yy323;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy332;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'U')	goto yy135;
			goto yy324;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'v')	goto yy333;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'D')	goto yy3;
			goto yy325;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy334;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy326;
	if(yych != 'n')	goto yy144;
	goto yy335;
yy335:
	YYDEBUG(335, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy327;
	if(yych != 't')	goto yy144;
	goto yy336;
yy336:
	YYDEBUG(336, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy53;
			goto yy138;
		} else {
			if(yych == 'H')	goto yy159;
			goto yy53;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy53;
			goto yy143;
		} else {
			if(yych <= 'h')	goto yy241;
			if(yych <= 'z')	goto yy143;
			goto yy53;
		}
	}
yy337:
	YYDEBUG(337, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy135;
			goto yy329;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy338;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy338:
	YYDEBUG(338, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'S')	goto yy3;
			goto yy159;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 't')	goto yy241;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy134;
			goto yy340;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'd')	goto yy340;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= 'N'){
		if(yych <= ')'){
			if(yych >= ')')	goto yy132;
			goto yy341;
		} else {
			if(yych <= '@')	goto yy341;
			if(yych <= 'M')	goto yy135;
			goto yy342;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy135;
			if(yych >= 'a')	goto yy135;
			goto yy341;
		} else {
			if(yych <= 'n')	goto yy342;
			if(yych <= 'z')	goto yy135;
			goto yy341;
		}
	}
yy341:
	YYDEBUG(341, *YYCURSOR);

{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		s->time->relative.weekday_behavior = 1;
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'E')	goto yy343;
		if(yych != 'e')	goto yy3;
		goto yy343;
	}
yy343:
	YYDEBUG(343, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy344;
	if(yych != 's')	goto yy53;
	goto yy344;
yy344:
	YYDEBUG(344, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy345;
	if(yych != 'd')	goto yy53;
	goto yy345;
yy345:
	YYDEBUG(345, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy346;
	if(yych != 'a')	goto yy53;
	goto yy346;
yy346:
	YYDEBUG(346, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy347;
	if(yych != 'y')	goto yy53;
	goto yy347;
yy347:
	YYDEBUG(347, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy341;
yy348:
	YYDEBUG(348, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy134;
			goto yy340;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy349;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy341;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy341;
			if(yych <= 'M')	goto yy135;
			goto yy342;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy341;
		} else {
			if(yych == 'n')	goto yy350;
			if(yych <= 'z')	goto yy142;
			goto yy341;
		}
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'D')	goto yy3;
			goto yy343;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy351;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy344;
	if(yych != 's')	goto yy144;
	goto yy352;
yy352:
	YYDEBUG(352, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy345;
	if(yych != 'd')	goto yy144;
	goto yy353;
yy353:
	YYDEBUG(353, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy346;
	if(yych != 'a')	goto yy144;
	goto yy354;
yy354:
	YYDEBUG(354, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy347;
	if(yych != 'y')	goto yy144;
	goto yy355;
yy355:
	YYDEBUG(355, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy138;
		goto yy341;
	} else {
		if(yych <= '_')	goto yy138;
		if(yych <= '`')	goto yy341;
		if(yych <= 'z')	goto yy143;
		goto yy341;
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'C'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'B')	goto yy134;
			goto yy357;
		}
	} else {
		if(yych <= 'b'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'c')	goto yy357;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy357:
	YYDEBUG(357, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '-')	goto yy361;
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych == 'E')	goto yy366;
			goto yy135;
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy3;
				goto yy135;
			} else {
				if(yych <= 'e')	goto yy366;
				if(yych <= 'z')	goto yy135;
				goto yy3;
			}
		}
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
	yych = *YYCURSOR;
	goto yy359;
yy359:
	YYDEBUG(359, *YYCURSOR);
	if(yybm[0+yych] & 64) {
		goto yy358;
	}
	if(yych <= '/')	goto yy53;
	if(yych <= '2')	goto yy362;
	if(yych <= '3')	goto yy364;
	if(yych <= '9')	goto yy365;
	goto yy53;
yy360:
	YYDEBUG(360, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 0x1F)	goto yy3;
	if(yych == '/')	goto yy3;
	if(yych <= '9')	goto yy359;
	goto yy3;
yy361:
	YYDEBUG(361, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy359;
	if(yych <= '0')	goto yy440;
	if(yych <= '2')	goto yy441;
	if(yych <= '3')	goto yy442;
	goto yy359;
yy362:
	YYDEBUG(362, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy378;
			goto yy422;
		} else {
			if(yych <= '2')	goto yy439;
			if(yych <= '9')	goto yy422;
			goto yy378;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy374;
			if(yych <= 'q')	goto yy378;
			goto yy375;
		} else {
			if(yych <= 's')	goto yy373;
			if(yych <= 't')	goto yy376;
			goto yy378;
		}
	}
yy363:
	YYDEBUG(363, *YYCURSOR);

{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy364:
	YYDEBUG(364, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy378;
			goto yy422;
		} else {
			if(yych <= '2')	goto yy371;
			if(yych <= '9')	goto yy372;
			goto yy378;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy374;
			if(yych <= 'q')	goto yy378;
			goto yy375;
		} else {
			if(yych <= 's')	goto yy373;
			if(yych <= 't')	goto yy376;
			goto yy378;
		}
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy378;
			goto yy370;
		} else {
			if(yych <= '2')	goto yy371;
			if(yych <= '9')	goto yy372;
			goto yy378;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy374;
			if(yych <= 'q')	goto yy378;
			goto yy375;
		} else {
			if(yych <= 's')	goto yy373;
			if(yych <= 't')	goto yy376;
			goto yy378;
		}
	}
yy366:
	YYDEBUG(366, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'M')	goto yy367;
		if(yych != 'm')	goto yy3;
		goto yy367;
	}
yy367:
	YYDEBUG(367, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy368;
	if(yych != 'b')	goto yy53;
	goto yy368;
yy368:
	YYDEBUG(368, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy369;
	if(yych != 'e')	goto yy53;
	goto yy369;
yy369:
	YYDEBUG(369, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy358;
	if(yych == 'r')	goto yy358;
	goto yy53;
yy370:
	YYDEBUG(370, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy383;
		goto yy363;
	} else {
		if(yych <= '9')	goto yy421;
		if(yych <= ':')	goto yy383;
		goto yy363;
	}
yy371:
	YYDEBUG(371, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy383;
		goto yy363;
	} else {
		if(yych <= '3')	goto yy421;
		if(yych <= '9')	goto yy418;
		if(yych <= ':')	goto yy383;
		goto yy363;
	}
yy372:
	YYDEBUG(372, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy383;
		goto yy363;
	} else {
		if(yych <= '9')	goto yy418;
		if(yych <= ':')	goto yy383;
		goto yy363;
	}
yy373:
	YYDEBUG(373, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy378;
yy374:
	YYDEBUG(374, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy378;
yy375:
	YYDEBUG(375, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy378;
yy376:
	YYDEBUG(376, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy378;
yy377:
	YYDEBUG(377, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 14) YYFILL(14);
	yych = *YYCURSOR;
	goto yy378;
yy378:
	YYDEBUG(378, *YYCURSOR);
	if(yybm[0+yych] & 128) {
		goto yy377;
	}
	if(yych <= '/')	goto yy363;
	if(yych <= '1')	goto yy379;
	if(yych <= '2')	goto yy380;
	if(yych <= '9')	goto yy381;
	goto yy363;
yy379:
	YYDEBUG(379, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy383;
		goto yy363;
	} else {
		if(yych <= '9')	goto yy417;
		if(yych <= ':')	goto yy383;
		goto yy363;
	}
yy380:
	YYDEBUG(380, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy383;
		goto yy363;
	} else {
		if(yych <= '3')	goto yy417;
		if(yych <= '9')	goto yy382;
		if(yych <= ':')	goto yy383;
		goto yy363;
	}
yy381:
	YYDEBUG(381, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy383;
		goto yy363;
	} else {
		if(yych <= '9')	goto yy382;
		if(yych <= ':')	goto yy383;
		goto yy363;
	}
yy382:
	YYDEBUG(382, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy363;
	if(yych <= '9')	goto yy415;
	goto yy363;
yy383:
	YYDEBUG(383, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy384;
	if(yych <= '9')	goto yy386;
	goto yy53;
yy384:
	YYDEBUG(384, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy387;
		goto yy385;
	} else {
		if(yych <= '9')	goto yy386;
		if(yych <= ':')	goto yy387;
		goto yy385;
	}
yy385:
	YYDEBUG(385, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy386:
	YYDEBUG(386, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy387;
	if(yych != ':')	goto yy385;
	goto yy387;
yy387:
	YYDEBUG(387, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy388;
	if(yych <= '6')	goto yy389;
	if(yych <= '9')	goto yy390;
	goto yy53;
yy388:
	YYDEBUG(388, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy385;
	if(yych <= '9')	goto yy391;
	goto yy385;
yy389:
	YYDEBUG(389, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '0')	goto yy391;
	goto yy385;
yy390:
	YYDEBUG(390, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy385;
yy391:
	YYDEBUG(391, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '+'){
		if(yych <= '\''){
			if(yych != ' ')	goto yy385;
			goto yy392;
		} else {
			if(yych <= '(')	goto yy395;
			if(yych <= '*')	goto yy385;
			goto yy394;
		}
	} else {
		if(yych <= '@'){
			if(yych == '-')	goto yy394;
			goto yy385;
		} else {
			if(yych <= 'Z')	goto yy396;
			if(yych <= '`')	goto yy385;
			if(yych <= 'z')	goto yy397;
			goto yy385;
		}
	}
yy392:
	YYDEBUG(392, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	goto yy393;
yy393:
	YYDEBUG(393, *YYCURSOR);
	if(yych <= '+'){
		if(yych <= '\''){
			if(yych == ' ')	goto yy392;
			goto yy53;
		} else {
			if(yych <= '(')	goto yy395;
			if(yych <= '*')	goto yy53;
			goto yy394;
		}
	} else {
		if(yych <= '@'){
			if(yych != '-')	goto yy53;
			goto yy394;
		} else {
			if(yych <= 'Z')	goto yy396;
			if(yych <= '`')	goto yy53;
			if(yych <= 'z')	goto yy397;
			goto yy53;
		}
	}
yy394:
	YYDEBUG(394, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '1')	goto yy410;
	if(yych <= '2')	goto yy411;
	if(yych <= '9')	goto yy412;
	goto yy53;
yy395:
	YYDEBUG(395, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@')	goto yy53;
	if(yych <= 'Z')	goto yy397;
	if(yych <= '`')	goto yy53;
	if(yych <= 'z')	goto yy397;
	goto yy53;
yy396:
	YYDEBUG(396, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy390;
		goto yy385;
	} else {
		if(yych <= 'Z')	goto yy398;
		if(yych <= '`')	goto yy385;
		if(yych <= 'z')	goto yy401;
		goto yy385;
	}
yy397:
	YYDEBUG(397, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy390;
		goto yy385;
	} else {
		if(yych <= 'Z')	goto yy398;
		if(yych <= '`')	goto yy385;
		if(yych >= '{')	goto yy385;
		goto yy398;
	}
yy398:
	YYDEBUG(398, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy390;
		goto yy385;
	} else {
		if(yych <= 'Z')	goto yy399;
		if(yych <= '`')	goto yy385;
		if(yych >= '{')	goto yy385;
		goto yy399;
	}
yy399:
	YYDEBUG(399, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy390;
		goto yy385;
	} else {
		if(yych <= 'Z')	goto yy400;
		if(yych <= '`')	goto yy385;
		if(yych >= '{')	goto yy385;
		goto yy400;
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == ')')	goto yy390;
	goto yy385;
yy401:
	YYDEBUG(401, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy385;
			goto yy390;
		} else {
			if(yych == '/')	goto yy403;
			goto yy385;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy399;
			if(yych <= '^')	goto yy385;
			goto yy403;
		} else {
			if(yych <= '`')	goto yy385;
			if(yych >= '{')	goto yy385;
			goto yy402;
		}
	}
yy402:
	YYDEBUG(402, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy385;
			goto yy390;
		} else {
			if(yych != '/')	goto yy385;
			goto yy403;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy400;
			if(yych <= '^')	goto yy385;
			goto yy403;
		} else {
			if(yych <= '`')	goto yy385;
			if(yych <= 'z')	goto yy407;
			goto yy385;
		}
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '@')	goto yy53;
	if(yych >= '[')	goto yy53;
	goto yy404;
yy404:
	YYDEBUG(404, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '`')	goto yy53;
	if(yych >= '{')	goto yy53;
	goto yy405;
yy405:
	YYDEBUG(405, *YYCURSOR);
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy406;
yy406:
	YYDEBUG(406, *YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy403;
		goto yy385;
	} else {
		if(yych <= '_')	goto yy403;
		if(yych <= '`')	goto yy385;
		if(yych <= 'z')	goto yy405;
		goto yy385;
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == ')')	goto yy390;
		if(yych <= '.')	goto yy385;
		goto yy403;
	} else {
		if(yych <= '_'){
			if(yych <= '^')	goto yy385;
			goto yy403;
		} else {
			if(yych <= '`')	goto yy385;
			if(yych >= '{')	goto yy385;
			goto yy408;
		}
	}
yy408:
	YYDEBUG(408, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy409;
yy409:
	YYDEBUG(409, *YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy403;
		goto yy53;
	} else {
		if(yych <= '_')	goto yy403;
		if(yych <= '`')	goto yy53;
		if(yych <= 'z')	goto yy408;
		goto yy53;
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy385;
	if(yych <= '9')	goto yy412;
	if(yych <= ':')	goto yy413;
	goto yy385;
yy411:
	YYDEBUG(411, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '5'){
		if(yych <= '/')	goto yy385;
		if(yych >= '4')	goto yy414;
		goto yy412;
	} else {
		if(yych <= '9')	goto yy390;
		if(yych <= ':')	goto yy413;
		goto yy385;
	}
yy412:
	YYDEBUG(412, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy385;
	if(yych <= '5')	goto yy414;
	if(yych <= '9')	goto yy390;
	if(yych >= ';')	goto yy385;
	goto yy413;
yy413:
	YYDEBUG(413, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy385;
	if(yych <= '5')	goto yy414;
	if(yych <= '9')	goto yy390;
	goto yy385;
yy414:
	YYDEBUG(414, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy385;
	if(yych <= '9')	goto yy390;
	goto yy385;
yy415:
	YYDEBUG(415, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy363;
	if(yych >= ':')	goto yy363;
	goto yy416;
yy416:
	YYDEBUG(416, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy363;
yy417:
	YYDEBUG(417, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy383;
		goto yy363;
	} else {
		if(yych <= '9')	goto yy415;
		if(yych <= ':')	goto yy383;
		goto yy363;
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy363;
	if(yych >= ':')	goto yy363;
	goto yy419;
yy419:
	YYDEBUG(419, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy420;
	if(yych <= '9')	goto yy416;
	goto yy420;
yy420:
	YYDEBUG(420, *YYCURSOR);

{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy421:
	YYDEBUG(421, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy383;
		goto yy363;
	} else {
		if(yych <= '9')	goto yy419;
		if(yych <= ':')	goto yy383;
		goto yy363;
	}
yy422:
	YYDEBUG(422, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ':'){
		if(yych <= '/'){
			if(yych != '.')	goto yy378;
			goto yy423;
		} else {
			if(yych <= '1')	goto yy424;
			if(yych <= '2')	goto yy425;
			if(yych <= '9')	goto yy426;
			goto yy383;
		}
	} else {
		if(yych <= 'q'){
			if(yych == 'n')	goto yy374;
			goto yy378;
		} else {
			if(yych <= 'r')	goto yy375;
			if(yych <= 's')	goto yy373;
			if(yych <= 't')	goto yy376;
			goto yy378;
		}
	}
yy423:
	YYDEBUG(423, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '2'){
		if(yych <= '/')	goto yy378;
		if(yych <= '1')	goto yy429;
		goto yy430;
	} else {
		if(yych <= '5')	goto yy431;
		if(yych <= '9')	goto yy432;
		goto yy378;
	}
yy424:
	YYDEBUG(424, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy383;
		goto yy363;
	} else {
		if(yych <= '9')	goto yy428;
		if(yych <= ':')	goto yy383;
		goto yy363;
	}
yy425:
	YYDEBUG(425, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy383;
		goto yy363;
	} else {
		if(yych <= '3')	goto yy428;
		if(yych <= '9')	goto yy427;
		if(yych <= ':')	goto yy383;
		goto yy363;
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy383;
		goto yy363;
	} else {
		if(yych <= '9')	goto yy427;
		if(yych <= ':')	goto yy383;
		goto yy363;
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy420;
	if(yych <= '9')	goto yy415;
	goto yy420;
yy428:
	YYDEBUG(428, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy383;
		goto yy420;
	} else {
		if(yych <= '9')	goto yy415;
		if(yych <= ':')	goto yy383;
		goto yy420;
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy433;
		goto yy363;
	} else {
		if(yych <= '9')	goto yy438;
		if(yych <= ':')	goto yy433;
		goto yy363;
	}
yy430:
	YYDEBUG(430, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy433;
		goto yy363;
	} else {
		if(yych <= '3')	goto yy438;
		if(yych <= '9')	goto yy437;
		if(yych <= ':')	goto yy433;
		goto yy363;
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy433;
		goto yy363;
	} else {
		if(yych <= '9')	goto yy437;
		if(yych <= ':')	goto yy433;
		goto yy363;
	}
yy432:
	YYDEBUG(432, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych != '.')	goto yy363;
		goto yy433;
	} else {
		if(yych <= '9')	goto yy382;
		if(yych >= ';')	goto yy363;
		goto yy433;
	}
yy433:
	YYDEBUG(433, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy434;
	if(yych <= '6')	goto yy435;
	if(yych <= '9')	goto yy386;
	goto yy53;
yy434:
	YYDEBUG(434, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy387;
		goto yy385;
	} else {
		if(yych <= '9')	goto yy436;
		if(yych <= ':')	goto yy387;
		goto yy385;
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy387;
		goto yy385;
	} else {
		if(yych <= '0')	goto yy391;
		if(yych == ':')	goto yy387;
		goto yy385;
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '-'){
		if(yych <= '('){
			if(yych == ' ')	goto yy392;
			if(yych <= '\'')	goto yy385;
			goto yy395;
		} else {
			if(yych == '+')	goto yy394;
			if(yych <= ',')	goto yy385;
			goto yy394;
		}
	} else {
		if(yych <= '@'){
			if(yych <= '.')	goto yy387;
			if(yych == ':')	goto yy387;
			goto yy385;
		} else {
			if(yych <= 'Z')	goto yy396;
			if(yych <= '`')	goto yy385;
			if(yych <= 'z')	goto yy397;
			goto yy385;
		}
	}
yy437:
	YYDEBUG(437, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy387;
		goto yy363;
	} else {
		if(yych <= '9')	goto yy415;
		if(yych <= ':')	goto yy387;
		goto yy363;
	}
yy438:
	YYDEBUG(438, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy433;
		goto yy363;
	} else {
		if(yych <= '9')	goto yy415;
		if(yych <= ':')	goto yy433;
		goto yy363;
	}
yy439:
	YYDEBUG(439, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ':'){
		if(yych <= '/'){
			if(yych == '.')	goto yy423;
			goto yy378;
		} else {
			if(yych <= '1')	goto yy424;
			if(yych <= '2')	goto yy425;
			if(yych <= '9')	goto yy426;
			goto yy383;
		}
	} else {
		if(yych <= 'q'){
			if(yych == 'n')	goto yy374;
			goto yy378;
		} else {
			if(yych <= 'r')	goto yy375;
			if(yych <= 's')	goto yy373;
			if(yych <= 't')	goto yy376;
			goto yy378;
		}
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy378;
			if(yych <= '0')	goto yy422;
			goto yy443;
		} else {
			if(yych <= '2')	goto yy450;
			if(yych <= '9')	goto yy443;
			goto yy378;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy374;
			if(yych <= 'q')	goto yy378;
			goto yy375;
		} else {
			if(yych <= 's')	goto yy373;
			if(yych <= 't')	goto yy376;
			goto yy378;
		}
	}
yy441:
	YYDEBUG(441, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy378;
			goto yy443;
		} else {
			if(yych <= '2')	goto yy450;
			if(yych <= '9')	goto yy443;
			goto yy378;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy374;
			if(yych <= 'q')	goto yy378;
			goto yy375;
		} else {
			if(yych <= 's')	goto yy373;
			if(yych <= 't')	goto yy376;
			goto yy378;
		}
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy378;
			goto yy443;
		} else {
			if(yych <= '2')	goto yy371;
			if(yych <= '9')	goto yy372;
			goto yy378;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy374;
			if(yych <= 'q')	goto yy378;
			goto yy375;
		} else {
			if(yych <= 's')	goto yy373;
			if(yych <= 't')	goto yy376;
			goto yy378;
		}
	}
yy443:
	YYDEBUG(443, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '.'){
			if(yych <= ',')	goto yy378;
			if(yych >= '.')	goto yy423;
			goto yy444;
		} else {
			if(yych <= '/')	goto yy378;
			if(yych <= '1')	goto yy424;
			if(yych <= '2')	goto yy425;
			goto yy426;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= ':')	goto yy383;
			if(yych == 'n')	goto yy374;
			goto yy378;
		} else {
			if(yych <= 'r')	goto yy375;
			if(yych <= 's')	goto yy373;
			if(yych <= 't')	goto yy376;
			goto yy378;
		}
	}
yy444:
	YYDEBUG(444, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy445;
yy445:
	YYDEBUG(445, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy446;
	if(yych <= '9')	goto yy447;
	goto yy446;
yy446:
	YYDEBUG(446, *YYCURSOR);

{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy447:
	YYDEBUG(447, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy446;
	if(yych >= ':')	goto yy446;
	goto yy448;
yy448:
	YYDEBUG(448, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy446;
	if(yych >= ':')	goto yy446;
	goto yy449;
yy449:
	YYDEBUG(449, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy446;
yy450:
	YYDEBUG(450, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= '.'){
			if(yych <= ',')	goto yy378;
			if(yych <= '-')	goto yy444;
			goto yy423;
		} else {
			if(yych <= '/')	goto yy378;
			if(yych <= '1')	goto yy424;
			if(yych <= '2')	goto yy425;
			goto yy426;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= ':')	goto yy383;
			if(yych == 'n')	goto yy374;
			goto yy378;
		} else {
			if(yych <= 'r')	goto yy375;
			if(yych <= 's')	goto yy373;
			if(yych <= 't')	goto yy376;
			goto yy378;
		}
	}
yy451:
	YYDEBUG(451, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'C'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'B')	goto yy134;
			goto yy357;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'c')	goto yy452;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy452:
	YYDEBUG(452, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy361;
				goto yy359;
			} else {
				if(yych <= '/')	goto yy138;
				if(yych <= '9')	goto yy359;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'E'){
				if(yych <= 'D')	goto yy135;
				goto yy366;
			} else {
				if(yych <= 'Z')	goto yy135;
				if(yych <= '^')	goto yy3;
				goto yy138;
			}
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy3;
				goto yy142;
			} else {
				if(yych <= 'e')	goto yy453;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy453:
	YYDEBUG(453, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'M'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'L')	goto yy3;
			goto yy367;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'm')	goto yy454;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy368;
	if(yych != 'b')	goto yy144;
	goto yy455;
yy455:
	YYDEBUG(455, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy369;
	if(yych != 'e')	goto yy144;
	goto yy456;
yy456:
	YYDEBUG(456, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy53;
			goto yy138;
		} else {
			if(yych == 'R')	goto yy358;
			goto yy53;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy53;
			goto yy143;
		} else {
			if(yych <= 'r')	goto yy457;
			if(yych <= 'z')	goto yy143;
			goto yy53;
		}
	}
yy457:
	YYDEBUG(457, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych == '/')	goto yy138;
		goto yy359;
	} else {
		if(yych <= '_')	goto yy138;
		if(yych <= '`')	goto yy359;
		if(yych <= 'z')	goto yy143;
		goto yy359;
	}
yy458:
	YYDEBUG(458, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy134;
			goto yy459;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 't')	goto yy459;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy459:
	YYDEBUG(459, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '-')	goto yy361;
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych != 'O')	goto yy135;
			goto yy460;
		} else {
			if(yych <= 'n'){
				if(yych <= '`')	goto yy3;
				goto yy135;
			} else {
				if(yych <= 'o')	goto yy460;
				if(yych <= 'z')	goto yy135;
				goto yy3;
			}
		}
	}
yy460:
	YYDEBUG(460, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'B')	goto yy461;
		if(yych != 'b')	goto yy3;
		goto yy461;
	}
yy461:
	YYDEBUG(461, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy462;
	if(yych != 'e')	goto yy53;
	goto yy462;
yy462:
	YYDEBUG(462, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy358;
	if(yych == 'r')	goto yy358;
	goto yy53;
yy463:
	YYDEBUG(463, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy134;
			goto yy459;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 't')	goto yy464;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy361;
				goto yy359;
			} else {
				if(yych <= '/')	goto yy138;
				if(yych <= '9')	goto yy359;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'O'){
				if(yych <= 'N')	goto yy135;
				goto yy460;
			} else {
				if(yych <= 'Z')	goto yy135;
				if(yych <= '^')	goto yy3;
				goto yy138;
			}
		} else {
			if(yych <= 'n'){
				if(yych <= '`')	goto yy3;
				goto yy142;
			} else {
				if(yych <= 'o')	goto yy465;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'B'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'A')	goto yy3;
			goto yy461;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'b')	goto yy466;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy462;
	if(yych != 'e')	goto yy144;
	goto yy467;
yy467:
	YYDEBUG(467, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy53;
			goto yy138;
		} else {
			if(yych == 'R')	goto yy358;
			goto yy53;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy53;
			goto yy143;
		} else {
			if(yych <= 'r')	goto yy457;
			if(yych <= 'z')	goto yy143;
			goto yy53;
		}
	}
yy468:
	YYDEBUG(468, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= 'B'){
			if(yych == ')')	goto yy132;
			if(yych <= '@')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'O'){
				if(yych <= 'C')	goto yy483;
				goto yy134;
			} else {
				if(yych <= 'P')	goto yy482;
				if(yych <= 'U')	goto yy134;
				goto yy484;
			}
		}
	} else {
		if(yych <= 'o'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy134;
				goto yy3;
			} else {
				if(yych == 'c')	goto yy483;
				goto yy134;
			}
		} else {
			if(yych <= 'u'){
				if(yych <= 'p')	goto yy482;
				goto yy134;
			} else {
				if(yych <= 'v')	goto yy484;
				if(yych <= 'z')	goto yy134;
				goto yy3;
			}
		}
	}
yy469:
	YYDEBUG(469, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy134;
			goto yy477;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 't')	goto yy477;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy470:
	YYDEBUG(470, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'W')	goto yy134;
			goto yy475;
		}
	} else {
		if(yych <= 'w'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'x')	goto yy475;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy471:
	YYDEBUG(471, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy134;
			goto yy472;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'n')	goto yy472;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy472:
	YYDEBUG(472, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy341;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy341;
			if(yych <= 'C')	goto yy135;
			goto yy473;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy341;
			goto yy135;
		} else {
			if(yych <= 'd')	goto yy473;
			if(yych <= 'z')	goto yy135;
			goto yy341;
		}
	}
yy473:
	YYDEBUG(473, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'A')	goto yy474;
		if(yych != 'a')	goto yy3;
		goto yy474;
	}
yy474:
	YYDEBUG(474, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy347;
	if(yych == 'y')	goto yy347;
	goto yy53;
yy475:
	YYDEBUG(475, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy135;
			goto yy476;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 't')	goto yy476;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy476:
	YYDEBUG(476, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'H')	goto yy159;
		if(yych == 'h')	goto yy159;
		goto yy3;
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy341;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy341;
			if(yych <= 'T')	goto yy135;
			goto yy478;
		}
	} else {
		if(yych <= 't'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy341;
			goto yy135;
		} else {
			if(yych <= 'u')	goto yy478;
			if(yych <= 'z')	goto yy135;
			goto yy341;
		}
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Q'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'R')	goto yy479;
		if(yych != 'r')	goto yy3;
		goto yy479;
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy480;
	if(yych != 'd')	goto yy53;
	goto yy480;
yy480:
	YYDEBUG(480, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy481;
	if(yych != 'a')	goto yy53;
	goto yy481;
yy481:
	YYDEBUG(481, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy347;
	if(yych == 'y')	goto yy347;
	goto yy53;
yy482:
	YYDEBUG(482, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '-')	goto yy361;
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych == 'T')	goto yy490;
			goto yy135;
		} else {
			if(yych <= 's'){
				if(yych <= '`')	goto yy3;
				goto yy135;
			} else {
				if(yych <= 't')	goto yy490;
				if(yych <= 'z')	goto yy135;
				goto yy3;
			}
		}
	}
yy483:
	YYDEBUG(483, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy135;
			goto yy488;
		}
	} else {
		if(yych <= 'n'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 'o')	goto yy488;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy484:
	YYDEBUG(484, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy135;
			goto yy485;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 'e')	goto yy485;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'M'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'N')	goto yy486;
		if(yych != 'n')	goto yy3;
		goto yy486;
	}
yy486:
	YYDEBUG(486, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy487;
	if(yych != 't')	goto yy53;
	goto yy487;
yy487:
	YYDEBUG(487, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy159;
	if(yych == 'h')	goto yy159;
	goto yy53;
yy488:
	YYDEBUG(488, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'M'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'N')	goto yy489;
		if(yych != 'n')	goto yy3;
		goto yy489;
	}
yy489:
	YYDEBUG(489, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy159;
	if(yych == 'd')	goto yy159;
	goto yy53;
yy490:
	YYDEBUG(490, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy359;
			goto yy360;
		} else {
			if(yych == '-')	goto yy361;
			goto yy359;
		}
	} else {
		if(yych <= 'D'){
			if(yych <= '/')	goto yy3;
			if(yych <= '9')	goto yy359;
			goto yy3;
		} else {
			if(yych <= 'E')	goto yy491;
			if(yych != 'e')	goto yy3;
			goto yy491;
		}
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy492;
	if(yych != 'm')	goto yy53;
	goto yy492;
yy492:
	YYDEBUG(492, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy493;
	if(yych != 'b')	goto yy53;
	goto yy493;
yy493:
	YYDEBUG(493, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy494;
	if(yych != 'e')	goto yy53;
	goto yy494;
yy494:
	YYDEBUG(494, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy358;
	if(yych == 'r')	goto yy358;
	goto yy53;
yy495:
	YYDEBUG(495, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= '@'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy132;
			} else {
				if(yych == '/')	goto yy138;
				goto yy3;
			}
		} else {
			if(yych <= 'O'){
				if(yych == 'C')	goto yy483;
				goto yy134;
			} else {
				if(yych <= 'P')	goto yy482;
				if(yych <= 'U')	goto yy134;
				goto yy484;
			}
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_'){
				if(yych <= 'Z')	goto yy134;
				if(yych <= '^')	goto yy3;
				goto yy138;
			} else {
				if(yych <= '`')	goto yy3;
				if(yych <= 'b')	goto yy137;
				goto yy510;
			}
		} else {
			if(yych <= 'u'){
				if(yych == 'p')	goto yy509;
				goto yy137;
			} else {
				if(yych <= 'v')	goto yy511;
				if(yych <= 'z')	goto yy137;
				goto yy3;
			}
		}
	}
yy496:
	YYDEBUG(496, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy134;
			goto yy477;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 't')	goto yy504;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy497:
	YYDEBUG(497, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'X'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'W')	goto yy134;
			goto yy475;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'x')	goto yy502;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy134;
			goto yy472;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy499;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy499:
	YYDEBUG(499, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy341;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy341;
			if(yych <= 'C')	goto yy135;
			goto yy473;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy341;
		} else {
			if(yych == 'd')	goto yy500;
			if(yych <= 'z')	goto yy142;
			goto yy341;
		}
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			goto yy474;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy501;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy501:
	YYDEBUG(501, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy347;
	if(yych == 'y')	goto yy355;
	goto yy144;
yy502:
	YYDEBUG(502, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy135;
			goto yy476;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 't')	goto yy503;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy503:
	YYDEBUG(503, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'G')	goto yy3;
			goto yy159;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy241;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy341;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy341;
			if(yych <= 'T')	goto yy135;
			goto yy478;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy341;
		} else {
			if(yych == 'u')	goto yy505;
			if(yych <= 'z')	goto yy142;
			goto yy341;
		}
	}
yy505:
	YYDEBUG(505, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'Q')	goto yy3;
			goto yy479;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy506;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy480;
	if(yych != 'd')	goto yy144;
	goto yy507;
yy507:
	YYDEBUG(507, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy481;
	if(yych != 'a')	goto yy144;
	goto yy508;
yy508:
	YYDEBUG(508, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy347;
	if(yych == 'y')	goto yy355;
	goto yy144;
yy509:
	YYDEBUG(509, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy361;
				goto yy359;
			} else {
				if(yych <= '/')	goto yy138;
				if(yych <= '9')	goto yy359;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'T'){
				if(yych <= 'S')	goto yy135;
				goto yy490;
			} else {
				if(yych <= 'Z')	goto yy135;
				if(yych <= '^')	goto yy3;
				goto yy138;
			}
		} else {
			if(yych <= 's'){
				if(yych <= '`')	goto yy3;
				goto yy142;
			} else {
				if(yych <= 't')	goto yy517;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'O'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy135;
			goto yy488;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'o')	goto yy515;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy135;
			goto yy485;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy512;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy512:
	YYDEBUG(512, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'M')	goto yy3;
			goto yy486;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy513;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy513:
	YYDEBUG(513, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy487;
	if(yych != 't')	goto yy144;
	goto yy514;
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy53;
			goto yy138;
		} else {
			if(yych == 'H')	goto yy159;
			goto yy53;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy53;
			goto yy143;
		} else {
			if(yych <= 'h')	goto yy241;
			if(yych <= 'z')	goto yy143;
			goto yy53;
		}
	}
yy515:
	YYDEBUG(515, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'M')	goto yy3;
			goto yy489;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy516;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy516:
	YYDEBUG(516, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy53;
			goto yy138;
		} else {
			if(yych == 'D')	goto yy159;
			goto yy53;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy53;
			goto yy143;
		} else {
			if(yych <= 'd')	goto yy241;
			if(yych <= 'z')	goto yy143;
			goto yy53;
		}
	}
yy517:
	YYDEBUG(517, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '-')	goto yy361;
			if(yych == '/')	goto yy138;
			goto yy359;
		}
	} else {
		if(yych <= '_'){
			if(yych == 'E')	goto yy491;
			if(yych <= '^')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy3;
				goto yy143;
			} else {
				if(yych <= 'e')	goto yy518;
				if(yych <= 'z')	goto yy143;
				goto yy3;
			}
		}
	}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy492;
	if(yych != 'm')	goto yy144;
	goto yy519;
yy519:
	YYDEBUG(519, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy493;
	if(yych != 'b')	goto yy144;
	goto yy520;
yy520:
	YYDEBUG(520, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy494;
	if(yych != 'e')	goto yy144;
	goto yy521;
yy521:
	YYDEBUG(521, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy53;
			goto yy138;
		} else {
			if(yych == 'R')	goto yy358;
			goto yy53;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy53;
			goto yy143;
		} else {
			if(yych <= 'r')	goto yy457;
			if(yych <= 'z')	goto yy143;
			goto yy53;
		}
	}
yy522:
	YYDEBUG(522, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'G'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy134;
			goto yy529;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'g')	goto yy529;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy523:
	YYDEBUG(523, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy134;
			goto yy527;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'r')	goto yy527;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy524:
	YYDEBUG(524, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy134;
			goto yy525;
		}
	} else {
		if(yych <= 'n'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'o')	goto yy525;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy525:
	YYDEBUG(525, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '@'){
		if(yych == ')')	goto yy132;
		goto yy526;
	} else {
		if(yych <= 'Z')	goto yy135;
		if(yych <= '`')	goto yy526;
		if(yych <= 'z')	goto yy135;
		goto yy526;
	}
yy526:
	YYDEBUG(526, *YYCURSOR);

{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
yy527:
	YYDEBUG(527, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '-')	goto yy361;
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych != 'I')	goto yy135;
			goto yy528;
		} else {
			if(yych <= 'h'){
				if(yych <= '`')	goto yy3;
				goto yy135;
			} else {
				if(yych <= 'i')	goto yy528;
				if(yych <= 'z')	goto yy135;
				goto yy3;
			}
		}
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'K'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'L')	goto yy358;
		if(yych == 'l')	goto yy358;
		goto yy3;
	}
yy529:
	YYDEBUG(529, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '-')	goto yy361;
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych != 'U')	goto yy135;
			goto yy530;
		} else {
			if(yych <= 't'){
				if(yych <= '`')	goto yy3;
				goto yy135;
			} else {
				if(yych <= 'u')	goto yy530;
				if(yych <= 'z')	goto yy135;
				goto yy3;
			}
		}
	}
yy530:
	YYDEBUG(530, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'S')	goto yy531;
		if(yych != 's')	goto yy3;
		goto yy531;
	}
yy531:
	YYDEBUG(531, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy358;
	if(yych == 't')	goto yy358;
	goto yy53;
yy532:
	YYDEBUG(532, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy134;
			goto yy529;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'g')	goto yy538;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy533:
	YYDEBUG(533, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy134;
			goto yy527;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy536;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy534:
	YYDEBUG(534, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'O'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy134;
			goto yy525;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'o')	goto yy535;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy535:
	YYDEBUG(535, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy526;
			goto yy132;
		} else {
			if(yych == '/')	goto yy138;
			goto yy526;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '^')	goto yy526;
			goto yy138;
		} else {
			if(yych <= '`')	goto yy526;
			if(yych <= 'z')	goto yy142;
			goto yy526;
		}
	}
yy536:
	YYDEBUG(536, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy361;
				goto yy359;
			} else {
				if(yych <= '/')	goto yy138;
				if(yych <= '9')	goto yy359;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'I'){
				if(yych <= 'H')	goto yy135;
				goto yy528;
			} else {
				if(yych <= 'Z')	goto yy135;
				if(yych <= '^')	goto yy3;
				goto yy138;
			}
		} else {
			if(yych <= 'h'){
				if(yych <= '`')	goto yy3;
				goto yy142;
			} else {
				if(yych <= 'i')	goto yy537;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy537:
	YYDEBUG(537, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'K')	goto yy3;
			goto yy358;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'l')	goto yy457;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy538:
	YYDEBUG(538, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy361;
				goto yy359;
			} else {
				if(yych <= '/')	goto yy138;
				if(yych <= '9')	goto yy359;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'U'){
				if(yych <= 'T')	goto yy135;
				goto yy530;
			} else {
				if(yych <= 'Z')	goto yy135;
				if(yych <= '^')	goto yy3;
				goto yy138;
			}
		} else {
			if(yych <= 't'){
				if(yych <= '`')	goto yy3;
				goto yy142;
			} else {
				if(yych <= 'u')	goto yy539;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy539:
	YYDEBUG(539, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'R')	goto yy3;
			goto yy531;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 's')	goto yy540;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy540:
	YYDEBUG(540, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy53;
			goto yy138;
		} else {
			if(yych == 'T')	goto yy358;
			goto yy53;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy53;
			goto yy143;
		} else {
			if(yych <= 't')	goto yy457;
			if(yych <= 'z')	goto yy143;
			goto yy53;
		}
	}
yy541:
	YYDEBUG(541, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'B'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'A')	goto yy134;
			goto yy555;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'b')	goto yy555;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy542:
	YYDEBUG(542, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= '@'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych == 'F')	goto yy552;
			if(yych <= 'Q')	goto yy134;
			goto yy551;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			if(yych <= 'e')	goto yy134;
			goto yy552;
		} else {
			if(yych == 'r')	goto yy551;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy543:
	YYDEBUG(543, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'T')	goto yy134;
			goto yy548;
		}
	} else {
		if(yych <= 't'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'u')	goto yy548;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy544:
	YYDEBUG(544, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'I'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy134;
			goto yy545;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'i')	goto yy545;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy545:
	YYDEBUG(545, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy341;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy341;
			if(yych <= 'C')	goto yy135;
			goto yy546;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy341;
			goto yy135;
		} else {
			if(yych <= 'd')	goto yy546;
			if(yych <= 'z')	goto yy135;
			goto yy341;
		}
	}
yy546:
	YYDEBUG(546, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'A')	goto yy547;
		if(yych != 'a')	goto yy3;
		goto yy547;
	}
yy547:
	YYDEBUG(547, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy347;
	if(yych == 'y')	goto yy347;
	goto yy53;
yy548:
	YYDEBUG(548, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy135;
			goto yy549;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 'r')	goto yy549;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy549:
	YYDEBUG(549, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'T')	goto yy550;
		if(yych != 't')	goto yy3;
		goto yy550;
	}
yy550:
	YYDEBUG(550, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy159;
	if(yych == 'h')	goto yy159;
	goto yy53;
yy551:
	YYDEBUG(551, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy135;
			goto yy554;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 's')	goto yy554;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy552:
	YYDEBUG(552, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy135;
			goto yy553;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 't')	goto yy553;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy553:
	YYDEBUG(553, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'H')	goto yy159;
		if(yych == 'h')	goto yy159;
		goto yy3;
	}
yy554:
	YYDEBUG(554, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'T')	goto yy159;
		if(yych == 't')	goto yy159;
		goto yy3;
	}
yy555:
	YYDEBUG(555, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '-')	goto yy361;
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych != 'R')	goto yy135;
			goto yy556;
		} else {
			if(yych <= 'q'){
				if(yych <= '`')	goto yy3;
				goto yy135;
			} else {
				if(yych <= 'r')	goto yy556;
				if(yych <= 'z')	goto yy135;
				goto yy3;
			}
		}
	}
yy556:
	YYDEBUG(556, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'U')	goto yy557;
		if(yych != 'u')	goto yy3;
		goto yy557;
	}
yy557:
	YYDEBUG(557, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy558;
	if(yych != 'a')	goto yy53;
	goto yy558;
yy558:
	YYDEBUG(558, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy559;
	if(yych != 'r')	goto yy53;
	goto yy559;
yy559:
	YYDEBUG(559, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy358;
	if(yych == 'y')	goto yy358;
	goto yy53;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'B'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'A')	goto yy134;
			goto yy555;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'b')	goto yy574;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy561:
	YYDEBUG(561, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '/'){
			if(yych == ')')	goto yy132;
			if(yych <= '.')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'E'){
				if(yych <= '@')	goto yy3;
				goto yy134;
			} else {
				if(yych <= 'F')	goto yy552;
				if(yych <= 'Q')	goto yy134;
				goto yy551;
			}
		}
	} else {
		if(yych <= 'e'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy134;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy138;
				if(yych <= '`')	goto yy3;
				goto yy137;
			}
		} else {
			if(yych <= 'q'){
				if(yych <= 'f')	goto yy571;
				goto yy137;
			} else {
				if(yych <= 'r')	goto yy570;
				if(yych <= 'z')	goto yy137;
				goto yy3;
			}
		}
	}
yy562:
	YYDEBUG(562, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'T')	goto yy134;
			goto yy548;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'u')	goto yy567;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy563:
	YYDEBUG(563, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'I'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy134;
			goto yy545;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'i')	goto yy564;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy564:
	YYDEBUG(564, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy341;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy341;
			if(yych <= 'C')	goto yy135;
			goto yy546;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy341;
		} else {
			if(yych == 'd')	goto yy565;
			if(yych <= 'z')	goto yy142;
			goto yy341;
		}
	}
yy565:
	YYDEBUG(565, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			goto yy547;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy566;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy566:
	YYDEBUG(566, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy347;
	if(yych == 'y')	goto yy355;
	goto yy144;
yy567:
	YYDEBUG(567, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy135;
			goto yy549;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy568;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy568:
	YYDEBUG(568, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'S')	goto yy3;
			goto yy550;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 't')	goto yy569;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy569:
	YYDEBUG(569, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy53;
			goto yy138;
		} else {
			if(yych == 'H')	goto yy159;
			goto yy53;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy53;
			goto yy143;
		} else {
			if(yych <= 'h')	goto yy241;
			if(yych <= 'z')	goto yy143;
			goto yy53;
		}
	}
yy570:
	YYDEBUG(570, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy135;
			goto yy554;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 's')	goto yy573;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy571:
	YYDEBUG(571, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy135;
			goto yy553;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 't')	goto yy572;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy572:
	YYDEBUG(572, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'G')	goto yy3;
			goto yy159;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy241;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy573:
	YYDEBUG(573, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'S')	goto yy3;
			goto yy159;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 't')	goto yy241;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy361;
				goto yy359;
			} else {
				if(yych <= '/')	goto yy138;
				if(yych <= '9')	goto yy359;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'R'){
				if(yych <= 'Q')	goto yy135;
				goto yy556;
			} else {
				if(yych <= 'Z')	goto yy135;
				if(yych <= '^')	goto yy3;
				goto yy138;
			}
		} else {
			if(yych <= 'q'){
				if(yych <= '`')	goto yy3;
				goto yy142;
			} else {
				if(yych <= 'r')	goto yy575;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy575:
	YYDEBUG(575, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'T')	goto yy3;
			goto yy557;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'u')	goto yy576;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy576:
	YYDEBUG(576, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy558;
	if(yych != 'a')	goto yy144;
	goto yy577;
yy577:
	YYDEBUG(577, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy559;
	if(yych != 'r')	goto yy144;
	goto yy578;
yy578:
	YYDEBUG(578, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy53;
			goto yy138;
		} else {
			if(yych == 'Y')	goto yy358;
			goto yy53;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy53;
			goto yy143;
		} else {
			if(yych <= 'y')	goto yy457;
			if(yych <= 'z')	goto yy143;
			goto yy53;
		}
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= '@'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych == 'L')	goto yy586;
			if(yych <= 'M')	goto yy134;
			goto yy585;
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			if(yych <= 'k')	goto yy134;
			goto yy586;
		} else {
			if(yych == 'n')	goto yy585;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy134;
			goto yy581;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'n')	goto yy581;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy581:
	YYDEBUG(581, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '-')	goto yy361;
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych != 'U')	goto yy135;
			goto yy582;
		} else {
			if(yych <= 't'){
				if(yych <= '`')	goto yy3;
				goto yy135;
			} else {
				if(yych <= 'u')	goto yy582;
				if(yych <= 'z')	goto yy135;
				goto yy3;
			}
		}
	}
yy582:
	YYDEBUG(582, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'A')	goto yy583;
		if(yych != 'a')	goto yy3;
		goto yy583;
	}
yy583:
	YYDEBUG(583, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy584;
	if(yych != 'r')	goto yy53;
	goto yy584;
yy584:
	YYDEBUG(584, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy358;
	if(yych == 'y')	goto yy358;
	goto yy53;
yy585:
	YYDEBUG(585, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '-')	goto yy361;
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych == 'E')	goto yy587;
			goto yy135;
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy3;
				goto yy135;
			} else {
				if(yych <= 'e')	goto yy587;
				if(yych <= 'z')	goto yy135;
				goto yy3;
			}
		}
	}
yy586:
	YYDEBUG(586, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '-')	goto yy361;
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych != 'Y')	goto yy135;
			goto yy587;
		} else {
			if(yych <= 'x'){
				if(yych <= '`')	goto yy3;
				goto yy135;
			} else {
				if(yych <= 'y')	goto yy587;
				if(yych <= 'z')	goto yy135;
				goto yy3;
			}
		}
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ')'){
		if(yych <= 0x1F)	goto yy3;
		if(yych <= '(')	goto yy359;
		goto yy360;
	} else {
		if(yych == '/')	goto yy3;
		if(yych <= '9')	goto yy359;
		goto yy3;
	}
yy588:
	YYDEBUG(588, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '/'){
			if(yych == ')')	goto yy132;
			if(yych <= '.')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'K'){
				if(yych <= '@')	goto yy3;
				goto yy134;
			} else {
				if(yych <= 'L')	goto yy586;
				if(yych <= 'M')	goto yy134;
				goto yy585;
			}
		}
	} else {
		if(yych <= 'k'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy134;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy138;
				if(yych <= '`')	goto yy3;
				goto yy137;
			}
		} else {
			if(yych <= 'm'){
				if(yych <= 'l')	goto yy595;
				goto yy137;
			} else {
				if(yych <= 'n')	goto yy594;
				if(yych <= 'z')	goto yy137;
				goto yy3;
			}
		}
	}
yy589:
	YYDEBUG(589, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy134;
			goto yy581;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy590;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy590:
	YYDEBUG(590, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy361;
				goto yy359;
			} else {
				if(yych <= '/')	goto yy138;
				if(yych <= '9')	goto yy359;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'U'){
				if(yych <= 'T')	goto yy135;
				goto yy582;
			} else {
				if(yych <= 'Z')	goto yy135;
				if(yych <= '^')	goto yy3;
				goto yy138;
			}
		} else {
			if(yych <= 't'){
				if(yych <= '`')	goto yy3;
				goto yy142;
			} else {
				if(yych <= 'u')	goto yy591;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy591:
	YYDEBUG(591, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			goto yy583;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy592;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy584;
	if(yych != 'r')	goto yy144;
	goto yy593;
yy593:
	YYDEBUG(593, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy53;
			goto yy138;
		} else {
			if(yych == 'Y')	goto yy358;
			goto yy53;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy53;
			goto yy143;
		} else {
			if(yych <= 'y')	goto yy457;
			if(yych <= 'z')	goto yy143;
			goto yy53;
		}
	}
yy594:
	YYDEBUG(594, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy361;
				goto yy359;
			} else {
				if(yych <= '/')	goto yy138;
				if(yych <= '9')	goto yy359;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'E'){
				if(yych <= 'D')	goto yy135;
				goto yy587;
			} else {
				if(yych <= 'Z')	goto yy135;
				if(yych <= '^')	goto yy3;
				goto yy138;
			}
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy3;
				goto yy142;
			} else {
				if(yych <= 'e')	goto yy596;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy595:
	YYDEBUG(595, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy361;
				goto yy359;
			} else {
				if(yych <= '/')	goto yy138;
				if(yych <= '9')	goto yy359;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Y'){
				if(yych <= 'X')	goto yy135;
				goto yy587;
			} else {
				if(yych <= 'Z')	goto yy135;
				if(yych <= '^')	goto yy3;
				goto yy138;
			}
		} else {
			if(yych <= 'x'){
				if(yych <= '`')	goto yy3;
				goto yy142;
			} else {
				if(yych <= 'y')	goto yy596;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy596:
	YYDEBUG(596, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x1F)	goto yy3;
			goto yy359;
		} else {
			if(yych <= ')')	goto yy360;
			if(yych <= '.')	goto yy359;
			goto yy138;
		}
	} else {
		if(yych <= '_'){
			if(yych <= '9')	goto yy359;
			if(yych <= '^')	goto yy3;
			goto yy138;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy597:
	YYDEBUG(597, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy359;
			goto yy360;
		} else {
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'I'){
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy134;
			goto yy598;
		} else {
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy598:
	YYDEBUG(598, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x1F)	goto yy3;
			goto yy359;
		} else {
			if(yych <= ')')	goto yy360;
			if(yych <= '.')	goto yy359;
			goto yy3;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '9')	goto yy359;
			if(yych <= '@')	goto yy3;
			goto yy135;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy599:
	YYDEBUG(599, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy359;
			goto yy360;
		} else {
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'I'){
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy134;
			goto yy600;
		} else {
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy600:
	YYDEBUG(600, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy359;
			goto yy360;
		} else {
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'I'){
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy135;
			goto yy587;
		} else {
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy601:
	YYDEBUG(601, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x1F)	goto yy3;
			goto yy359;
		} else {
			if(yych <= ')')	goto yy360;
			if(yych <= '.')	goto yy359;
			goto yy3;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '9')	goto yy359;
			if(yych <= '@')	goto yy3;
			goto yy134;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy602:
	YYDEBUG(602, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy359;
			goto yy360;
		} else {
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'I'){
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy134;
			goto yy598;
		} else {
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy603:
	YYDEBUG(603, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
	goto yy604;
yy604:
	YYDEBUG(604, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	goto yy603;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy616;
	case 'A':	case 'a':	goto yy624;
	case 'D':	case 'd':	goto yy608;
	case 'F':	case 'f':	goto yy609;
	case 'H':	case 'h':	goto yy60;
	case 'I':	goto yy619;
	case 'J':	case 'j':	goto yy623;
	case 'M':	case 'm':	goto yy607;
	case 'N':	case 'n':	goto yy626;
	case 'O':	case 'o':	goto yy625;
	case 'P':	case 'p':	goto yy628;
	case 'S':	case 's':	goto yy605;
	case 'T':	case 't':	goto yy65;
	case 'V':	goto yy621;
	case 'W':	case 'w':	goto yy62;
	case 'X':	goto yy622;
	case 'Y':	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy605:
	YYDEBUG(605, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy119;
			goto yy53;
		} else {
			if(yych <= 'E')	goto yy1118;
			if(yych <= 'T')	goto yy53;
			goto yy118;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'a')	goto yy119;
			goto yy53;
		} else {
			if(yych <= 'e')	goto yy1118;
			if(yych == 'u')	goto yy118;
			goto yy53;
		}
	}
yy606:
	YYDEBUG(606, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '`'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy119;
			goto yy53;
		} else {
			if(yych <= 'E')	goto yy1118;
			if(yych == 'U')	goto yy118;
			goto yy53;
		}
	} else {
		if(yych <= 'e'){
			if(yych <= 'a')	goto yy119;
			if(yych <= 'd')	goto yy53;
			goto yy1118;
		} else {
			if(yych <= 's')	goto yy53;
			if(yych <= 't')	goto yy843;
			if(yych <= 'u')	goto yy118;
			goto yy53;
		}
	}
yy607:
	YYDEBUG(607, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'H'){
			if(yych == 'A')	goto yy715;
			goto yy53;
		} else {
			if(yych <= 'I')	goto yy110;
			if(yych <= 'N')	goto yy53;
			goto yy109;
		}
	} else {
		if(yych <= 'h'){
			if(yych == 'a')	goto yy715;
			goto yy53;
		} else {
			if(yych <= 'i')	goto yy110;
			if(yych == 'o')	goto yy109;
			goto yy53;
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych == 'A')	goto yy106;
		if(yych <= 'D')	goto yy53;
		goto yy702;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy106;
		} else {
			if(yych == 'e')	goto yy702;
			goto yy53;
		}
	}
yy609:
	YYDEBUG(609, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'N'){
			if(yych == 'E')	goto yy718;
			goto yy53;
		} else {
			if(yych <= 'O')	goto yy83;
			if(yych <= 'Q')	goto yy53;
			goto yy82;
		}
	} else {
		if(yych <= 'n'){
			if(yych == 'e')	goto yy718;
			goto yy53;
		} else {
			if(yych <= 'o')	goto yy83;
			if(yych == 'r')	goto yy82;
			goto yy53;
		}
	}
yy610:
	YYDEBUG(610, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'H')	goto yy66;
		if(yych <= 'T')	goto yy53;
		goto yy67;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy53;
			goto yy1117;
		} else {
			if(yych == 'u')	goto yy67;
			goto yy53;
		}
	}
yy611:
	YYDEBUG(611, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy852;
	if(yych <= '/')	goto yy57;
	if(yych <= '9')	goto yy851;
	goto yy57;
yy612:
	YYDEBUG(612, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'c'){
		if(yych == 'O')	goto yy655;
		goto yy53;
	} else {
		if(yych <= 'd')	goto yy843;
		if(yych == 'o')	goto yy655;
		goto yy53;
	}
yy613:
	YYDEBUG(613, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy843;
	goto yy53;
yy614:
	YYDEBUG(614, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '0':
	case '1':
	case '2':	goto yy783;
	case '3':	goto yy785;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy786;
	case 'A':	case 'a':	goto yy790;
	case 'D':	case 'd':	goto yy794;
	case 'F':	case 'f':	goto yy788;
	case 'J':	case 'j':	goto yy787;
	case 'M':	case 'm':	goto yy789;
	case 'N':	case 'n':	goto yy793;
	case 'O':	case 'o':	goto yy792;
	case 'S':	case 's':	goto yy791;
	default:	goto yy53;
	}
yy615:
	YYDEBUG(615, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '0':	goto yy734;
	case '1':	goto yy735;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy736;
	case 'A':	case 'a':	goto yy740;
	case 'D':	case 'd':	goto yy744;
	case 'F':	case 'f':	goto yy738;
	case 'J':	case 'j':	goto yy737;
	case 'M':	case 'm':	goto yy739;
	case 'N':	case 'n':	goto yy743;
	case 'O':	case 'o':	goto yy742;
	case 'S':	case 's':	goto yy741;
	default:	goto yy617;
	}
yy616:
	YYDEBUG(616, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
	goto yy617;
yy617:
	YYDEBUG(617, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy616;
	case 'A':	case 'a':	goto yy699;
	case 'D':	case 'd':	goto yy701;
	case 'F':	case 'f':	goto yy697;
	case 'I':	goto yy619;
	case 'J':	case 'j':	goto yy623;
	case 'M':	case 'm':	goto yy698;
	case 'N':	case 'n':	goto yy626;
	case 'O':	case 'o':	goto yy625;
	case 'S':	case 's':	goto yy700;
	case 'V':	goto yy621;
	case 'X':	goto yy622;
	default:	goto yy53;
	}
yy618:
	YYDEBUG(618, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '1'){
		if(yych <= '/')	goto yy617;
		if(yych <= '0')	goto yy693;
		goto yy694;
	} else {
		if(yych <= '5')	goto yy695;
		if(yych <= '9')	goto yy696;
		goto yy617;
	}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych >= ' ')	goto yy657;
			goto yy620;
		} else {
			if(yych <= '/')	goto yy620;
			if(yych <= '9')	goto yy659;
			goto yy620;
		}
	} else {
		if(yych <= 'V'){
			if(yych <= 'I')	goto yy692;
			if(yych >= 'V')	goto yy665;
			goto yy620;
		} else {
			if(yych == 'X')	goto yy665;
			goto yy620;
		}
	}
yy620:
	YYDEBUG(620, *YYCURSOR);

{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy621:
	YYDEBUG(621, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		goto yy620;
	} else {
		if(yych <= '9')	goto yy659;
		if(yych == 'I')	goto yy690;
		goto yy620;
	}
yy622:
	YYDEBUG(622, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		goto yy620;
	} else {
		if(yych <= '9')	goto yy659;
		if(yych == 'I')	goto yy689;
		goto yy620;
	}
yy623:
	YYDEBUG(623, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy682;
		if(yych <= 'T')	goto yy53;
		goto yy681;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy682;
		} else {
			if(yych == 'u')	goto yy681;
			goto yy53;
		}
	}
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= 'L'){
			if(yych == '.')	goto yy629;
			goto yy53;
		} else {
			if(yych <= 'M')	goto yy630;
			if(yych == 'P')	goto yy675;
			goto yy53;
		}
	} else {
		if(yych <= 'o'){
			if(yych <= 'U')	goto yy674;
			if(yych == 'm')	goto yy630;
			goto yy53;
		} else {
			if(yych <= 'p')	goto yy675;
			if(yych == 'u')	goto yy674;
			goto yy53;
		}
	}
yy625:
	YYDEBUG(625, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy669;
	if(yych == 'c')	goto yy669;
	goto yy53;
yy626:
	YYDEBUG(626, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy655;
	if(yych == 'o')	goto yy655;
	goto yy53;
yy627:
	YYDEBUG(627, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy633;
	if(yych <= '9')	goto yy635;
	goto yy53;
yy628:
	YYDEBUG(628, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych != '.')	goto yy53;
		goto yy629;
	} else {
		if(yych <= 'M')	goto yy630;
		if(yych == 'm')	goto yy630;
		goto yy53;
	}
yy629:
	YYDEBUG(629, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy630;
	if(yych != 'm')	goto yy53;
	goto yy630;
yy630:
	YYDEBUG(630, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) == '.')	goto yy632;
	goto yy631;
yy631:
	YYDEBUG(631, *YYCURSOR);

{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
yy632:
	YYDEBUG(632, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy631;
yy633:
	YYDEBUG(633, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy636;
		goto yy634;
	} else {
		if(yych <= '9')	goto yy649;
		if(yych <= ':')	goto yy636;
		goto yy634;
	}
yy634:
	YYDEBUG(634, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy635:
	YYDEBUG(635, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy636;
	if(yych != ':')	goto yy634;
	goto yy636;
yy636:
	YYDEBUG(636, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy637;
	if(yych <= '6')	goto yy638;
	if(yych <= '9')	goto yy639;
	goto yy53;
yy637:
	YYDEBUG(637, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy640;
	if(yych <= '/')	goto yy634;
	if(yych <= '9')	goto yy643;
	goto yy634;
yy638:
	YYDEBUG(638, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy640;
	if(yych == '0')	goto yy643;
	goto yy634;
yy639:
	YYDEBUG(639, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych != '.')	goto yy634;
	goto yy640;
yy640:
	YYDEBUG(640, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy641;
yy641:
	YYDEBUG(641, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy642;
yy642:
	YYDEBUG(642, *YYCURSOR);
	if(yych <= '/')	goto yy634;
	if(yych <= '9')	goto yy641;
	goto yy634;
yy643:
	YYDEBUG(643, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '-'){
			if(yych != ' ')	goto yy634;
			goto yy644;
		} else {
			if(yych <= '.')	goto yy640;
			if(yych <= '@')	goto yy634;
			goto yy646;
		}
	} else {
		if(yych <= '`'){
			if(yych == 'P')	goto yy646;
			goto yy634;
		} else {
			if(yych <= 'a')	goto yy646;
			if(yych == 'p')	goto yy646;
			goto yy634;
		}
	}
yy644:
	YYDEBUG(644, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	goto yy645;
yy645:
	YYDEBUG(645, *YYCURSOR);
	if(yych <= 'O'){
		if(yych <= ' '){
			if(yych <= 0x1F)	goto yy53;
			goto yy644;
		} else {
			if(yych != 'A')	goto yy53;
			goto yy646;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'P')	goto yy646;
			if(yych <= '`')	goto yy53;
			goto yy646;
		} else {
			if(yych != 'p')	goto yy53;
			goto yy646;
		}
	}
yy646:
	YYDEBUG(646, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych != '.')	goto yy53;
		goto yy647;
	} else {
		if(yych <= 'M')	goto yy648;
		if(yych == 'm')	goto yy648;
		goto yy53;
	}
yy647:
	YYDEBUG(647, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy648;
	if(yych != 'm')	goto yy53;
	goto yy648;
yy648:
	YYDEBUG(648, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '.')	goto yy632;
	goto yy631;
yy649:
	YYDEBUG(649, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= '-'){
			if(yych != ' ')	goto yy634;
			goto yy650;
		} else {
			if(yych <= '.')	goto yy636;
			if(yych == ':')	goto yy636;
			goto yy634;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'A')	goto yy652;
			if(yych == 'P')	goto yy652;
			goto yy634;
		} else {
			if(yych <= 'a')	goto yy652;
			if(yych == 'p')	goto yy652;
			goto yy634;
		}
	}
yy650:
	YYDEBUG(650, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	goto yy651;
yy651:
	YYDEBUG(651, *YYCURSOR);
	if(yych <= 'O'){
		if(yych <= ' '){
			if(yych <= 0x1F)	goto yy53;
			goto yy650;
		} else {
			if(yych != 'A')	goto yy53;
			goto yy652;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'P')	goto yy652;
			if(yych <= '`')	goto yy53;
			goto yy652;
		} else {
			if(yych != 'p')	goto yy53;
			goto yy652;
		}
	}
yy652:
	YYDEBUG(652, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych != '.')	goto yy53;
		goto yy653;
	} else {
		if(yych <= 'M')	goto yy654;
		if(yych == 'm')	goto yy654;
		goto yy53;
	}
yy653:
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy654;
	if(yych != 'm')	goto yy53;
	goto yy654;
yy654:
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '.')	goto yy632;
	goto yy631;
yy655:
	YYDEBUG(655, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy656;
	if(yych != 'v')	goto yy53;
	goto yy656;
yy656:
	YYDEBUG(656, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		if(yych <= '/')	goto yy620;
		goto yy659;
	} else {
		if(yych <= 'E'){
			if(yych <= 'D')	goto yy620;
			goto yy661;
		} else {
			if(yych == 'e')	goto yy661;
			goto yy620;
		}
	}
yy657:
	YYDEBUG(657, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	goto yy658;
yy658:
	YYDEBUG(658, *YYCURSOR);
	if(yych <= 0x1F)	goto yy53;
	if(yych <= '.')	goto yy657;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy659;
yy659:
	YYDEBUG(659, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy660;
	if(yych <= '9')	goto yy666;
	goto yy660;
yy660:
	YYDEBUG(660, *YYCURSOR);

{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
yy661:
	YYDEBUG(661, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy662;
	if(yych != 'm')	goto yy53;
	goto yy662;
yy662:
	YYDEBUG(662, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy663;
	if(yych != 'b')	goto yy53;
	goto yy663;
yy663:
	YYDEBUG(663, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy664;
	if(yych != 'e')	goto yy53;
	goto yy664;
yy664:
	YYDEBUG(664, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy665;
	if(yych != 'r')	goto yy53;
	goto yy665;
yy665:
	YYDEBUG(665, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 0x1F)	goto yy620;
	if(yych <= '.')	goto yy657;
	if(yych <= '/')	goto yy620;
	if(yych <= '9')	goto yy659;
	goto yy620;
yy666:
	YYDEBUG(666, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy660;
	if(yych >= ':')	goto yy660;
	goto yy667;
yy667:
	YYDEBUG(667, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy660;
	if(yych >= ':')	goto yy660;
	goto yy668;
yy668:
	YYDEBUG(668, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy660;
yy669:
	YYDEBUG(669, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy670;
	if(yych != 't')	goto yy53;
	goto yy670;
yy670:
	YYDEBUG(670, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		if(yych <= '/')	goto yy620;
		goto yy659;
	} else {
		if(yych <= 'O'){
			if(yych <= 'N')	goto yy620;
			goto yy671;
		} else {
			if(yych != 'o')	goto yy620;
			goto yy671;
		}
	}
yy671:
	YYDEBUG(671, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy672;
	if(yych != 'b')	goto yy53;
	goto yy672;
yy672:
	YYDEBUG(672, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy673;
	if(yych != 'e')	goto yy53;
	goto yy673;
yy673:
	YYDEBUG(673, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy665;
	if(yych == 'r')	goto yy665;
	goto yy53;
yy674:
	YYDEBUG(674, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy678;
	if(yych == 'g')	goto yy678;
	goto yy53;
yy675:
	YYDEBUG(675, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy676;
	if(yych != 'r')	goto yy53;
	goto yy676;
yy676:
	YYDEBUG(676, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		if(yych <= '/')	goto yy620;
		goto yy659;
	} else {
		if(yych <= 'I'){
			if(yych <= 'H')	goto yy620;
			goto yy677;
		} else {
			if(yych != 'i')	goto yy620;
			goto yy677;
		}
	}
yy677:
	YYDEBUG(677, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy665;
	if(yych == 'l')	goto yy665;
	goto yy53;
yy678:
	YYDEBUG(678, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		if(yych <= '/')	goto yy620;
		goto yy659;
	} else {
		if(yych <= 'U'){
			if(yych <= 'T')	goto yy620;
			goto yy679;
		} else {
			if(yych != 'u')	goto yy620;
			goto yy679;
		}
	}
yy679:
	YYDEBUG(679, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy680;
	if(yych != 's')	goto yy53;
	goto yy680;
yy680:
	YYDEBUG(680, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy665;
	if(yych == 't')	goto yy665;
	goto yy53;
yy681:
	YYDEBUG(681, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy688;
		if(yych <= 'M')	goto yy53;
		goto yy687;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy53;
			goto yy688;
		} else {
			if(yych == 'n')	goto yy687;
			goto yy53;
		}
	}
yy682:
	YYDEBUG(682, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy683;
	if(yych != 'n')	goto yy53;
	goto yy683;
yy683:
	YYDEBUG(683, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		if(yych <= '/')	goto yy620;
		goto yy659;
	} else {
		if(yych <= 'U'){
			if(yych <= 'T')	goto yy620;
			goto yy684;
		} else {
			if(yych != 'u')	goto yy620;
			goto yy684;
		}
	}
yy684:
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy685;
	if(yych != 'a')	goto yy53;
	goto yy685;
yy685:
	YYDEBUG(685, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy686;
	if(yych != 'r')	goto yy53;
	goto yy686;
yy686:
	YYDEBUG(686, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy665;
	if(yych == 'y')	goto yy665;
	goto yy53;
yy687:
	YYDEBUG(687, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		if(yych <= '/')	goto yy620;
		goto yy659;
	} else {
		if(yych <= 'E'){
			if(yych <= 'D')	goto yy620;
			goto yy665;
		} else {
			if(yych == 'e')	goto yy665;
			goto yy620;
		}
	}
yy688:
	YYDEBUG(688, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		if(yych <= '/')	goto yy620;
		goto yy659;
	} else {
		if(yych <= 'Y'){
			if(yych <= 'X')	goto yy620;
			goto yy665;
		} else {
			if(yych == 'y')	goto yy665;
			goto yy620;
		}
	}
yy689:
	YYDEBUG(689, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		goto yy620;
	} else {
		if(yych <= '9')	goto yy659;
		if(yych == 'I')	goto yy665;
		goto yy620;
	}
yy690:
	YYDEBUG(690, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		goto yy620;
	} else {
		if(yych <= '9')	goto yy659;
		if(yych != 'I')	goto yy620;
		goto yy691;
	}
yy691:
	YYDEBUG(691, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		goto yy620;
	} else {
		if(yych <= '9')	goto yy659;
		if(yych == 'I')	goto yy665;
		goto yy620;
	}
yy692:
	YYDEBUG(692, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		goto yy620;
	} else {
		if(yych <= '9')	goto yy659;
		if(yych == 'I')	goto yy665;
		goto yy620;
	}
yy693:
	YYDEBUG(693, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy724;
		goto yy634;
	} else {
		if(yych <= '9')	goto yy733;
		if(yych <= ':')	goto yy636;
		goto yy634;
	}
yy694:
	YYDEBUG(694, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy724;
		goto yy634;
	} else {
		if(yych <= '2')	goto yy733;
		if(yych <= '9')	goto yy649;
		if(yych <= ':')	goto yy636;
		goto yy634;
	}
yy695:
	YYDEBUG(695, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy724;
		goto yy634;
	} else {
		if(yych <= '9')	goto yy649;
		if(yych <= ':')	goto yy636;
		goto yy634;
	}
yy696:
	YYDEBUG(696, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy724;
	if(yych == ':')	goto yy636;
	goto yy634;
yy697:
	YYDEBUG(697, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy718;
	if(yych == 'e')	goto yy718;
	goto yy53;
yy698:
	YYDEBUG(698, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy715;
	if(yych == 'a')	goto yy715;
	goto yy53;
yy699:
	YYDEBUG(699, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy675;
		if(yych <= 'T')	goto yy53;
		goto yy674;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy53;
			goto yy675;
		} else {
			if(yych == 'u')	goto yy674;
			goto yy53;
		}
	}
yy700:
	YYDEBUG(700, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy708;
	if(yych == 'e')	goto yy708;
	goto yy53;
yy701:
	YYDEBUG(701, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy702;
	if(yych != 'e')	goto yy53;
	goto yy702;
yy702:
	YYDEBUG(702, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy703;
	if(yych != 'c')	goto yy53;
	goto yy703;
yy703:
	YYDEBUG(703, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		if(yych <= '/')	goto yy620;
		goto yy659;
	} else {
		if(yych <= 'E'){
			if(yych <= 'D')	goto yy620;
			goto yy704;
		} else {
			if(yych != 'e')	goto yy620;
			goto yy704;
		}
	}
yy704:
	YYDEBUG(704, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy705;
	if(yych != 'm')	goto yy53;
	goto yy705;
yy705:
	YYDEBUG(705, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy706;
	if(yych != 'b')	goto yy53;
	goto yy706;
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy707;
	if(yych != 'e')	goto yy53;
	goto yy707;
yy707:
	YYDEBUG(707, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy665;
	if(yych == 'r')	goto yy665;
	goto yy53;
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy709;
	if(yych != 'p')	goto yy53;
	goto yy709;
yy709:
	YYDEBUG(709, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		if(yych <= '/')	goto yy620;
		goto yy659;
	} else {
		if(yych <= 'T'){
			if(yych <= 'S')	goto yy620;
			goto yy710;
		} else {
			if(yych != 't')	goto yy620;
			goto yy710;
		}
	}
yy710:
	YYDEBUG(710, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		if(yych <= '/')	goto yy620;
		goto yy659;
	} else {
		if(yych <= 'E'){
			if(yych <= 'D')	goto yy620;
			goto yy711;
		} else {
			if(yych != 'e')	goto yy620;
			goto yy711;
		}
	}
yy711:
	YYDEBUG(711, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy712;
	if(yych != 'm')	goto yy53;
	goto yy712;
yy712:
	YYDEBUG(712, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy713;
	if(yych != 'b')	goto yy53;
	goto yy713;
yy713:
	YYDEBUG(713, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy714;
	if(yych != 'e')	goto yy53;
	goto yy714;
yy714:
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy665;
	if(yych == 'r')	goto yy665;
	goto yy53;
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy716;
		if(yych <= 'X')	goto yy53;
		goto yy665;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy53;
			goto yy716;
		} else {
			if(yych == 'y')	goto yy665;
			goto yy53;
		}
	}
yy716:
	YYDEBUG(716, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		if(yych <= '/')	goto yy620;
		goto yy659;
	} else {
		if(yych <= 'C'){
			if(yych <= 'B')	goto yy620;
			goto yy717;
		} else {
			if(yych != 'c')	goto yy620;
			goto yy717;
		}
	}
yy717:
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy665;
	if(yych == 'h')	goto yy665;
	goto yy53;
yy718:
	YYDEBUG(718, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy719;
	if(yych != 'b')	goto yy53;
	goto yy719;
yy719:
	YYDEBUG(719, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= '.')	goto yy657;
		if(yych <= '/')	goto yy620;
		goto yy659;
	} else {
		if(yych <= 'R'){
			if(yych <= 'Q')	goto yy620;
			goto yy720;
		} else {
			if(yych != 'r')	goto yy620;
			goto yy720;
		}
	}
yy720:
	YYDEBUG(720, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy721;
	if(yych != 'u')	goto yy53;
	goto yy721;
yy721:
	YYDEBUG(721, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy722;
	if(yych != 'a')	goto yy53;
	goto yy722;
yy722:
	YYDEBUG(722, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy723;
	if(yych != 'r')	goto yy53;
	goto yy723;
yy723:
	YYDEBUG(723, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy665;
	if(yych == 'y')	goto yy665;
	goto yy53;
yy724:
	YYDEBUG(724, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy725;
	if(yych <= '6')	goto yy726;
	if(yych <= '9')	goto yy727;
	goto yy53;
yy725:
	YYDEBUG(725, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy640;
	if(yych <= '/')	goto yy634;
	if(yych <= '9')	goto yy732;
	goto yy634;
yy726:
	YYDEBUG(726, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy640;
		goto yy634;
	} else {
		if(yych <= '0')	goto yy732;
		if(yych <= '9')	goto yy728;
		goto yy634;
	}
yy727:
	YYDEBUG(727, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy640;
	if(yych <= '/')	goto yy634;
	if(yych >= ':')	goto yy634;
	goto yy728;
yy728:
	YYDEBUG(728, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy729;
	if(yych <= '9')	goto yy730;
	goto yy729;
yy729:
	YYDEBUG(729, *YYCURSOR);

{
		DEBUG_OUTPUT("pointed date");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy730:
	YYDEBUG(730, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy729;
	if(yych >= ':')	goto yy729;
	goto yy731;
yy731:
	YYDEBUG(731, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy729;
yy732:
	YYDEBUG(732, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= '-'){
			if(yych == ' ')	goto yy644;
			goto yy634;
		} else {
			if(yych <= '.')	goto yy640;
			if(yych <= '/')	goto yy634;
			if(yych <= '9')	goto yy730;
			goto yy634;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'A')	goto yy646;
			if(yych == 'P')	goto yy646;
			goto yy634;
		} else {
			if(yych <= 'a')	goto yy646;
			if(yych == 'p')	goto yy646;
			goto yy634;
		}
	}
yy733:
	YYDEBUG(733, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= '-'){
			if(yych == ' ')	goto yy650;
			goto yy634;
		} else {
			if(yych <= '.')	goto yy724;
			if(yych == ':')	goto yy636;
			goto yy634;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'A')	goto yy652;
			if(yych == 'P')	goto yy652;
			goto yy634;
		} else {
			if(yych <= 'a')	goto yy652;
			if(yych == 'p')	goto yy652;
			goto yy634;
		}
	}
yy734:
	YYDEBUG(734, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy773;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy736;
	goto yy53;
yy735:
	YYDEBUG(735, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy773;
	if(yych <= '/')	goto yy53;
	if(yych >= '3')	goto yy53;
	goto yy736;
yy736:
	YYDEBUG(736, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy773;
	goto yy53;
yy737:
	YYDEBUG(737, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy769;
		if(yych <= 'T')	goto yy53;
		goto yy768;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy769;
		} else {
			if(yych == 'u')	goto yy768;
			goto yy53;
		}
	}
yy738:
	YYDEBUG(738, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy766;
	if(yych == 'e')	goto yy766;
	goto yy53;
yy739:
	YYDEBUG(739, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy763;
	if(yych == 'a')	goto yy763;
	goto yy53;
yy740:
	YYDEBUG(740, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy760;
		if(yych <= 'T')	goto yy53;
		goto yy759;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy53;
			goto yy760;
		} else {
			if(yych == 'u')	goto yy759;
			goto yy53;
		}
	}
yy741:
	YYDEBUG(741, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy756;
	if(yych == 'e')	goto yy756;
	goto yy53;
yy742:
	YYDEBUG(742, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy754;
	if(yych == 'c')	goto yy754;
	goto yy53;
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy752;
	if(yych == 'o')	goto yy752;
	goto yy53;
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy745;
	if(yych != 'e')	goto yy53;
	goto yy745;
yy745:
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy746;
	if(yych != 'c')	goto yy53;
	goto yy746;
yy746:
	YYDEBUG(746, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy620;
			goto yy657;
		} else {
			if(yych <= '-')	goto yy747;
			if(yych <= '.')	goto yy657;
			goto yy620;
		}
	} else {
		if(yych <= 'E'){
			if(yych <= '9')	goto yy659;
			if(yych <= 'D')	goto yy620;
			goto yy704;
		} else {
			if(yych == 'e')	goto yy704;
			goto yy620;
		}
	}
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy658;
	if(yych <= '0')	goto yy748;
	if(yych <= '2')	goto yy749;
	if(yych <= '3')	goto yy750;
	goto yy658;
yy748:
	YYDEBUG(748, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy660;
	if(yych <= '0')	goto yy666;
	if(yych <= '9')	goto yy751;
	goto yy660;
yy749:
	YYDEBUG(749, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy660;
	if(yych <= '9')	goto yy751;
	goto yy660;
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy660;
	if(yych <= '1')	goto yy751;
	if(yych <= '9')	goto yy666;
	goto yy660;
yy751:
	YYDEBUG(751, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy660;
	if(yych <= '9')	goto yy667;
	goto yy660;
yy752:
	YYDEBUG(752, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy753;
	if(yych != 'v')	goto yy53;
	goto yy753;
yy753:
	YYDEBUG(753, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy620;
			goto yy657;
		} else {
			if(yych <= '-')	goto yy747;
			if(yych <= '.')	goto yy657;
			goto yy620;
		}
	} else {
		if(yych <= 'E'){
			if(yych <= '9')	goto yy659;
			if(yych <= 'D')	goto yy620;
			goto yy661;
		} else {
			if(yych == 'e')	goto yy661;
			goto yy620;
		}
	}
yy754:
	YYDEBUG(754, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy755;
	if(yych != 't')	goto yy53;
	goto yy755;
yy755:
	YYDEBUG(755, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy620;
			goto yy657;
		} else {
			if(yych <= '-')	goto yy747;
			if(yych <= '.')	goto yy657;
			goto yy620;
		}
	} else {
		if(yych <= 'O'){
			if(yych <= '9')	goto yy659;
			if(yych <= 'N')	goto yy620;
			goto yy671;
		} else {
			if(yych == 'o')	goto yy671;
			goto yy620;
		}
	}
yy756:
	YYDEBUG(756, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy757;
	if(yych != 'p')	goto yy53;
	goto yy757;
yy757:
	YYDEBUG(757, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy620;
			goto yy657;
		} else {
			if(yych <= '-')	goto yy747;
			if(yych <= '.')	goto yy657;
			goto yy620;
		}
	} else {
		if(yych <= 'T'){
			if(yych <= '9')	goto yy659;
			if(yych <= 'S')	goto yy620;
			goto yy758;
		} else {
			if(yych != 't')	goto yy620;
			goto yy758;
		}
	}
yy758:
	YYDEBUG(758, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy620;
			goto yy657;
		} else {
			if(yych <= '-')	goto yy747;
			if(yych <= '.')	goto yy657;
			goto yy620;
		}
	} else {
		if(yych <= 'E'){
			if(yych <= '9')	goto yy659;
			if(yych <= 'D')	goto yy620;
			goto yy711;
		} else {
			if(yych == 'e')	goto yy711;
			goto yy620;
		}
	}
yy759:
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy762;
	if(yych == 'g')	goto yy762;
	goto yy53;
yy760:
	YYDEBUG(760, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy761;
	if(yych != 'r')	goto yy53;
	goto yy761;
yy761:
	YYDEBUG(761, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy620;
			goto yy657;
		} else {
			if(yych <= '-')	goto yy747;
			if(yych <= '.')	goto yy657;
			goto yy620;
		}
	} else {
		if(yych <= 'I'){
			if(yych <= '9')	goto yy659;
			if(yych <= 'H')	goto yy620;
			goto yy677;
		} else {
			if(yych == 'i')	goto yy677;
			goto yy620;
		}
	}
yy762:
	YYDEBUG(762, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy620;
			goto yy657;
		} else {
			if(yych <= '-')	goto yy747;
			if(yych <= '.')	goto yy657;
			goto yy620;
		}
	} else {
		if(yych <= 'U'){
			if(yych <= '9')	goto yy659;
			if(yych <= 'T')	goto yy620;
			goto yy679;
		} else {
			if(yych == 'u')	goto yy679;
			goto yy620;
		}
	}
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy764;
		if(yych <= 'X')	goto yy53;
		goto yy765;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy53;
			goto yy764;
		} else {
			if(yych == 'y')	goto yy765;
			goto yy53;
		}
	}
yy764:
	YYDEBUG(764, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy620;
			goto yy657;
		} else {
			if(yych <= '-')	goto yy747;
			if(yych <= '.')	goto yy657;
			goto yy620;
		}
	} else {
		if(yych <= 'C'){
			if(yych <= '9')	goto yy659;
			if(yych <= 'B')	goto yy620;
			goto yy717;
		} else {
			if(yych == 'c')	goto yy717;
			goto yy620;
		}
	}
yy765:
	YYDEBUG(765, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '-'){
		if(yych <= 0x1F)	goto yy620;
		if(yych <= ',')	goto yy657;
		goto yy747;
	} else {
		if(yych <= '.')	goto yy657;
		if(yych <= '/')	goto yy620;
		if(yych <= '9')	goto yy659;
		goto yy620;
	}
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy767;
	if(yych != 'b')	goto yy53;
	goto yy767;
yy767:
	YYDEBUG(767, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy620;
			goto yy657;
		} else {
			if(yych <= '-')	goto yy747;
			if(yych <= '.')	goto yy657;
			goto yy620;
		}
	} else {
		if(yych <= 'R'){
			if(yych <= '9')	goto yy659;
			if(yych <= 'Q')	goto yy620;
			goto yy720;
		} else {
			if(yych == 'r')	goto yy720;
			goto yy620;
		}
	}
yy768:
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy772;
		if(yych <= 'M')	goto yy53;
		goto yy771;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy53;
			goto yy772;
		} else {
			if(yych == 'n')	goto yy771;
			goto yy53;
		}
	}
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy770;
	if(yych != 'n')	goto yy53;
	goto yy770;
yy770:
	YYDEBUG(770, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy620;
			goto yy657;
		} else {
			if(yych <= '-')	goto yy747;
			if(yych <= '.')	goto yy657;
			goto yy620;
		}
	} else {
		if(yych <= 'U'){
			if(yych <= '9')	goto yy659;
			if(yych <= 'T')	goto yy620;
			goto yy684;
		} else {
			if(yych == 'u')	goto yy684;
			goto yy620;
		}
	}
yy771:
	YYDEBUG(771, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy620;
			goto yy657;
		} else {
			if(yych <= '-')	goto yy747;
			if(yych <= '.')	goto yy657;
			goto yy620;
		}
	} else {
		if(yych <= 'E'){
			if(yych <= '9')	goto yy659;
			if(yych <= 'D')	goto yy620;
			goto yy665;
		} else {
			if(yych == 'e')	goto yy665;
			goto yy620;
		}
	}
yy772:
	YYDEBUG(772, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy620;
			goto yy657;
		} else {
			if(yych <= '-')	goto yy747;
			if(yych <= '.')	goto yy657;
			goto yy620;
		}
	} else {
		if(yych <= 'Y'){
			if(yych <= '9')	goto yy659;
			if(yych <= 'X')	goto yy620;
			goto yy665;
		} else {
			if(yych == 'y')	goto yy665;
			goto yy620;
		}
	}
yy773:
	YYDEBUG(773, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '2')	goto yy774;
	if(yych <= '3')	goto yy776;
	if(yych <= '9')	goto yy777;
	goto yy53;
yy774:
	YYDEBUG(774, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy775;
		if(yych <= '9')	goto yy777;
		if(yych >= 'n')	goto yy779;
		goto yy775;
	} else {
		if(yych <= 'r'){
			if(yych >= 'r')	goto yy780;
			goto yy775;
		} else {
			if(yych <= 's')	goto yy778;
			if(yych <= 't')	goto yy781;
			goto yy775;
		}
	}
yy775:
	YYDEBUG(775, *YYCURSOR);

{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy776:
	YYDEBUG(776, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy775;
		if(yych <= '1')	goto yy777;
		if(yych <= 'm')	goto yy775;
		goto yy779;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy775;
			goto yy780;
		} else {
			if(yych <= 's')	goto yy778;
			if(yych <= 't')	goto yy781;
			goto yy775;
		}
	}
yy777:
	YYDEBUG(777, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'q'){
		if(yych == 'n')	goto yy779;
		goto yy775;
	} else {
		if(yych <= 'r')	goto yy780;
		if(yych <= 's')	goto yy778;
		if(yych <= 't')	goto yy781;
		goto yy775;
	}
yy778:
	YYDEBUG(778, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 't')	goto yy782;
	goto yy53;
yy779:
	YYDEBUG(779, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy782;
	goto yy53;
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy782;
	goto yy53;
yy781:
	YYDEBUG(781, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'h')	goto yy53;
	goto yy782;
yy782:
	YYDEBUG(782, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy775;
yy783:
	YYDEBUG(783, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/'){
			if(yych >= '/')	goto yy837;
			goto yy784;
		} else {
			if(yych <= '9')	goto yy786;
			if(yych >= 'n')	goto yy834;
			goto yy784;
		}
	} else {
		if(yych <= 'r'){
			if(yych >= 'r')	goto yy835;
			goto yy784;
		} else {
			if(yych <= 's')	goto yy833;
			if(yych <= 't')	goto yy836;
			goto yy784;
		}
	}
yy784:
	YYDEBUG(784, *YYCURSOR);

{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
yy785:
	YYDEBUG(785, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy784;
			goto yy837;
		} else {
			if(yych <= '1')	goto yy786;
			if(yych <= 'm')	goto yy784;
			goto yy834;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy784;
			goto yy835;
		} else {
			if(yych <= 's')	goto yy833;
			if(yych <= 't')	goto yy836;
			goto yy784;
		}
	}
yy786:
	YYDEBUG(786, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych == '/')	goto yy837;
		if(yych <= 'm')	goto yy784;
		goto yy834;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy784;
			goto yy835;
		} else {
			if(yych <= 's')	goto yy833;
			if(yych <= 't')	goto yy836;
			goto yy784;
		}
	}
yy787:
	YYDEBUG(787, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy832;
		if(yych <= 'T')	goto yy53;
		goto yy831;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy832;
		} else {
			if(yych == 'u')	goto yy831;
			goto yy53;
		}
	}
yy788:
	YYDEBUG(788, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy830;
	if(yych == 'e')	goto yy830;
	goto yy53;
yy789:
	YYDEBUG(789, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy829;
	if(yych == 'a')	goto yy829;
	goto yy53;
yy790:
	YYDEBUG(790, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy828;
		if(yych <= 'T')	goto yy53;
		goto yy827;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy53;
			goto yy828;
		} else {
			if(yych == 'u')	goto yy827;
			goto yy53;
		}
	}
yy791:
	YYDEBUG(791, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy825;
	if(yych == 'e')	goto yy825;
	goto yy53;
yy792:
	YYDEBUG(792, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy824;
	if(yych == 'c')	goto yy824;
	goto yy53;
yy793:
	YYDEBUG(793, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy823;
	if(yych == 'o')	goto yy823;
	goto yy53;
yy794:
	YYDEBUG(794, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy795;
	if(yych != 'e')	goto yy53;
	goto yy795;
yy795:
	YYDEBUG(795, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy796;
	if(yych != 'c')	goto yy53;
	goto yy796;
yy796:
	YYDEBUG(796, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '/')	goto yy53;
	goto yy797;
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy798;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy799;
yy799:
	YYDEBUG(799, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy800;
yy800:
	YYDEBUG(800, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy801;
yy801:
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy802;
yy802:
	YYDEBUG(802, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '1')	goto yy803;
	if(yych <= '2')	goto yy804;
	goto yy53;
yy803:
	YYDEBUG(803, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy805;
	goto yy53;
yy804:
	YYDEBUG(804, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '4')	goto yy53;
	goto yy805;
yy805:
	YYDEBUG(805, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy806;
yy806:
	YYDEBUG(806, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '6')	goto yy53;
	goto yy807;
yy807:
	YYDEBUG(807, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy808;
yy808:
	YYDEBUG(808, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy809;
yy809:
	YYDEBUG(809, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy810;
	if(yych <= '6')	goto yy811;
	goto yy53;
yy810:
	YYDEBUG(810, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy812;
	goto yy53;
yy811:
	YYDEBUG(811, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '0')	goto yy53;
	goto yy812;
yy812:
	YYDEBUG(812, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ' ')	goto yy53;
	goto yy813;
yy813:
	YYDEBUG(813, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	goto yy814;
yy814:
	YYDEBUG(814, *YYCURSOR);
	if(yych <= '*'){
		if(yych == ' ')	goto yy813;
		goto yy53;
	} else {
		if(yych == ',')	goto yy53;
		if(yych >= '.')	goto yy53;
		goto yy815;
	}
yy815:
	YYDEBUG(815, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '1')	goto yy816;
	if(yych <= '2')	goto yy818;
	if(yych <= '9')	goto yy819;
	goto yy53;
yy816:
	YYDEBUG(816, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy817;
	if(yych <= '9')	goto yy819;
	if(yych <= ':')	goto yy820;
	goto yy817;
yy817:
	YYDEBUG(817, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy818:
	YYDEBUG(818, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '5'){
		if(yych <= '/')	goto yy817;
		if(yych >= '4')	goto yy821;
		goto yy819;
	} else {
		if(yych <= '9')	goto yy822;
		if(yych <= ':')	goto yy820;
		goto yy817;
	}
yy819:
	YYDEBUG(819, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy817;
	if(yych <= '5')	goto yy821;
	if(yych <= '9')	goto yy822;
	if(yych >= ';')	goto yy817;
	goto yy820;
yy820:
	YYDEBUG(820, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy817;
	if(yych <= '5')	goto yy821;
	if(yych <= '9')	goto yy822;
	goto yy817;
yy821:
	YYDEBUG(821, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy817;
	if(yych >= ':')	goto yy817;
	goto yy822;
yy822:
	YYDEBUG(822, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy817;
yy823:
	YYDEBUG(823, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy796;
	if(yych == 'v')	goto yy796;
	goto yy53;
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy796;
	if(yych == 't')	goto yy796;
	goto yy53;
yy825:
	YYDEBUG(825, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy826;
	if(yych != 'p')	goto yy53;
	goto yy826;
yy826:
	YYDEBUG(826, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == '/')	goto yy797;
		goto yy53;
	} else {
		if(yych <= 'T')	goto yy796;
		if(yych == 't')	goto yy796;
		goto yy53;
	}
yy827:
	YYDEBUG(827, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy796;
	if(yych == 'g')	goto yy796;
	goto yy53;
yy828:
	YYDEBUG(828, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy796;
	if(yych == 'r')	goto yy796;
	goto yy53;
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy796;
		if(yych <= 'X')	goto yy53;
		goto yy796;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy53;
			goto yy796;
		} else {
			if(yych == 'y')	goto yy796;
			goto yy53;
		}
	}
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy796;
	if(yych == 'b')	goto yy796;
	goto yy53;
yy831:
	YYDEBUG(831, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy796;
		if(yych <= 'M')	goto yy53;
		goto yy796;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy53;
			goto yy796;
		} else {
			if(yych == 'n')	goto yy796;
			goto yy53;
		}
	}
yy832:
	YYDEBUG(832, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy796;
	if(yych == 'n')	goto yy796;
	goto yy53;
yy833:
	YYDEBUG(833, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 't')	goto yy842;
	goto yy53;
yy834:
	YYDEBUG(834, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy842;
	goto yy53;
yy835:
	YYDEBUG(835, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy842;
	goto yy53;
yy836:
	YYDEBUG(836, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'h')	goto yy842;
	goto yy53;
yy837:
	YYDEBUG(837, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy838;
yy838:
	YYDEBUG(838, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy784;
	if(yych >= ':')	goto yy784;
	goto yy839;
yy839:
	YYDEBUG(839, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy784;
	if(yych >= ':')	goto yy784;
	goto yy840;
yy840:
	YYDEBUG(840, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy784;
	if(yych >= ':')	goto yy784;
	goto yy841;
yy841:
	YYDEBUG(841, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy784;
yy842:
	YYDEBUG(842, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '/')	goto yy837;
	goto yy784;
yy843:
	YYDEBUG(843, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '-')	goto yy617;
	if(yych <= '.')	goto yy845;
	if(yych >= '0')	goto yy617;
	goto yy844;
yy844:
	YYDEBUG(844, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case 'A':	case 'a':	goto yy790;
	case 'D':	case 'd':	goto yy794;
	case 'F':	case 'f':	goto yy788;
	case 'J':	case 'j':	goto yy787;
	case 'M':	case 'm':	goto yy789;
	case 'N':	case 'n':	goto yy793;
	case 'O':	case 'o':	goto yy792;
	case 'S':	case 's':	goto yy791;
	default:	goto yy53;
	}
yy845:
	YYDEBUG(845, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy617;
	if(yych <= '0')	goto yy846;
	if(yych <= '1')	goto yy847;
	if(yych <= '9')	goto yy848;
	goto yy617;
yy846:
	YYDEBUG(846, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '.')	goto yy849;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy848;
	goto yy53;
yy847:
	YYDEBUG(847, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '.')	goto yy849;
	if(yych <= '/')	goto yy53;
	if(yych >= '3')	goto yy53;
	goto yy848;
yy848:
	YYDEBUG(848, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '.')	goto yy53;
	goto yy849;
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy850;
yy850:
	YYDEBUG(850, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy729;
	if(yych <= '9')	goto yy728;
	goto yy729;
yy851:
	YYDEBUG(851, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy852;
	if(yych <= '/')	goto yy57;
	if(yych <= '9')	goto yy879;
	goto yy57;
yy852:
	YYDEBUG(852, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '0':	goto yy734;
	case '1':	goto yy735;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy736;
	case 'A':	case 'a':	goto yy856;
	case 'D':	case 'd':	goto yy860;
	case 'F':	case 'f':	goto yy854;
	case 'J':	case 'j':	goto yy853;
	case 'M':	case 'm':	goto yy855;
	case 'N':	case 'n':	goto yy859;
	case 'O':	case 'o':	goto yy858;
	case 'S':	case 's':	goto yy857;
	default:	goto yy53;
	}
yy853:
	YYDEBUG(853, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy878;
		if(yych <= 'T')	goto yy53;
		goto yy877;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy878;
		} else {
			if(yych == 'u')	goto yy877;
			goto yy53;
		}
	}
yy854:
	YYDEBUG(854, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy876;
	if(yych == 'e')	goto yy876;
	goto yy53;
yy855:
	YYDEBUG(855, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy875;
	if(yych == 'a')	goto yy875;
	goto yy53;
yy856:
	YYDEBUG(856, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy874;
		if(yych <= 'T')	goto yy53;
		goto yy873;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy53;
			goto yy874;
		} else {
			if(yych == 'u')	goto yy873;
			goto yy53;
		}
	}
yy857:
	YYDEBUG(857, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy871;
	if(yych == 'e')	goto yy871;
	goto yy53;
yy858:
	YYDEBUG(858, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy870;
	if(yych == 'c')	goto yy870;
	goto yy53;
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy869;
	if(yych == 'o')	goto yy869;
	goto yy53;
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy861;
	if(yych != 'e')	goto yy53;
	goto yy861;
yy861:
	YYDEBUG(861, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy862;
	if(yych != 'c')	goto yy53;
	goto yy862;
yy862:
	YYDEBUG(862, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '-')	goto yy53;
	goto yy863;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '0')	goto yy864;
	if(yych <= '2')	goto yy865;
	if(yych <= '3')	goto yy866;
	goto yy53;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy53;
	if(yych <= '9')	goto yy867;
	goto yy53;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy867;
	goto yy53;
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '2')	goto yy53;
	goto yy867;
yy867:
	YYDEBUG(867, *YYCURSOR);
	++YYCURSOR;
	goto yy868;
yy868:
	YYDEBUG(868, *YYCURSOR);

{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy869:
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy862;
	if(yych == 'v')	goto yy862;
	goto yy53;
yy870:
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy862;
	if(yych == 't')	goto yy862;
	goto yy53;
yy871:
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy872;
	if(yych != 'p')	goto yy53;
	goto yy872;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == '-')	goto yy863;
		goto yy53;
	} else {
		if(yych <= 'T')	goto yy862;
		if(yych == 't')	goto yy862;
		goto yy53;
	}
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy862;
	if(yych == 'g')	goto yy862;
	goto yy53;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy862;
	if(yych == 'r')	goto yy862;
	goto yy53;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy862;
		if(yych <= 'X')	goto yy53;
		goto yy862;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy53;
			goto yy862;
		} else {
			if(yych == 'y')	goto yy862;
			goto yy53;
		}
	}
yy876:
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy862;
	if(yych == 'b')	goto yy862;
	goto yy53;
yy877:
	YYDEBUG(877, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy862;
		if(yych <= 'M')	goto yy53;
		goto yy862;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy53;
			goto yy862;
		} else {
			if(yych == 'n')	goto yy862;
			goto yy53;
		}
	}
yy878:
	YYDEBUG(878, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy862;
	if(yych == 'n')	goto yy862;
	goto yy53;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':	case 'S':
	case 'T':	case 'V':	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':
	case 'n':
	case 'o':	case 's':
	case 't':	case 'w':	case 'y':	goto yy884;
	case '-':	goto yy881;
	case '.':	goto yy887;
	case '/':	goto yy882;
	case '0':	goto yy900;
	case '1':	goto yy901;
	case '2':	goto yy902;
	case '3':	goto yy903;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	case 'W':	goto yy904;
	default:	goto yy880;
	}
yy880:
	YYDEBUG(880, *YYCURSOR);

{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '0':	goto yy1046;
	case '1':	goto yy1047;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1048;
	case 'A':	case 'a':	goto yy1041;
	case 'D':	case 'd':	goto yy1045;
	case 'F':	case 'f':	goto yy1039;
	case 'J':	case 'j':	goto yy1038;
	case 'M':	case 'm':	goto yy1040;
	case 'N':	case 'n':	goto yy1044;
	case 'O':	case 'o':	goto yy1043;
	case 'S':	case 's':	goto yy1042;
	default:	goto yy886;
	}
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '0')	goto yy1019;
	if(yych <= '1')	goto yy1020;
	if(yych <= '9')	goto yy1021;
	goto yy53;
yy883:
	YYDEBUG(883, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	goto yy884;
yy884:
	YYDEBUG(884, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	goto yy883;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy885;
	case 'A':	case 'a':	goto yy895;
	case 'D':	case 'd':	goto yy899;
	case 'F':	case 'f':	goto yy893;
	case 'H':	case 'h':	goto yy60;
	case 'I':	goto yy888;
	case 'J':	case 'j':	goto yy892;
	case 'M':	case 'm':	goto yy894;
	case 'N':	case 'n':	goto yy898;
	case 'O':	case 'o':	goto yy897;
	case 'S':	case 's':	goto yy896;
	case 'T':	case 't':	goto yy65;
	case 'V':	goto yy890;
	case 'W':	case 'w':	goto yy62;
	case 'X':	goto yy891;
	case 'Y':	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy885:
	YYDEBUG(885, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	goto yy886;
yy886:
	YYDEBUG(886, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy885;
	case 'A':	case 'a':	goto yy895;
	case 'D':	case 'd':	goto yy1011;
	case 'F':	case 'f':	goto yy1008;
	case 'I':	goto yy888;
	case 'J':	case 'j':	goto yy892;
	case 'M':	case 'm':	goto yy1009;
	case 'N':	case 'n':	goto yy898;
	case 'O':	case 'o':	goto yy897;
	case 'S':	case 's':	goto yy1010;
	case 'V':	goto yy890;
	case 'X':	goto yy891;
	default:	goto yy53;
	}
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy886;
	if(yych <= '0')	goto yy1005;
	if(yych <= '2')	goto yy1006;
	if(yych <= '3')	goto yy1007;
	goto yy886;
yy888:
	YYDEBUG(888, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= 'U'){
		if(yych == 'I')	goto yy1004;
		goto yy889;
	} else {
		if(yych == 'W')	goto yy889;
		if(yych <= 'X')	goto yy958;
		goto yy889;
	}
yy889:
	YYDEBUG(889, *YYCURSOR);

{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy890:
	YYDEBUG(890, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1002;
	goto yy889;
yy891:
	YYDEBUG(891, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1001;
	goto yy889;
yy892:
	YYDEBUG(892, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy994;
		if(yych <= 'T')	goto yy53;
		goto yy993;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy994;
		} else {
			if(yych == 'u')	goto yy993;
			goto yy53;
		}
	}
yy893:
	YYDEBUG(893, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'N'){
			if(yych == 'E')	goto yy987;
			goto yy53;
		} else {
			if(yych <= 'O')	goto yy83;
			if(yych <= 'Q')	goto yy53;
			goto yy82;
		}
	} else {
		if(yych <= 'n'){
			if(yych == 'e')	goto yy987;
			goto yy53;
		} else {
			if(yych <= 'o')	goto yy83;
			if(yych == 'r')	goto yy82;
			goto yy53;
		}
	}
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'H'){
			if(yych == 'A')	goto yy984;
			goto yy53;
		} else {
			if(yych <= 'I')	goto yy110;
			if(yych <= 'N')	goto yy53;
			goto yy109;
		}
	} else {
		if(yych <= 'h'){
			if(yych == 'a')	goto yy984;
			goto yy53;
		} else {
			if(yych <= 'i')	goto yy110;
			if(yych == 'o')	goto yy109;
			goto yy53;
		}
	}
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy978;
		if(yych <= 'T')	goto yy53;
		goto yy977;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy53;
			goto yy978;
		} else {
			if(yych == 'u')	goto yy977;
			goto yy53;
		}
	}
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy119;
			goto yy53;
		} else {
			if(yych <= 'E')	goto yy970;
			if(yych <= 'T')	goto yy53;
			goto yy118;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'a')	goto yy119;
			goto yy53;
		} else {
			if(yych <= 'e')	goto yy970;
			if(yych == 'u')	goto yy118;
			goto yy53;
		}
	}
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy965;
	if(yych == 'c')	goto yy965;
	goto yy53;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy959;
	if(yych == 'o')	goto yy959;
	goto yy53;
yy899:
	YYDEBUG(899, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych == 'A')	goto yy106;
		if(yych <= 'D')	goto yy53;
		goto yy952;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy106;
		} else {
			if(yych == 'e')	goto yy952;
			goto yy53;
		}
	}
yy900:
	YYDEBUG(900, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '0')	goto yy950;
	if(yych <= '9')	goto yy951;
	goto yy57;
yy901:
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '2')	goto yy917;
	if(yych <= '9')	goto yy916;
	goto yy57;
yy902:
	YYDEBUG(902, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '9')	goto yy916;
	goto yy57;
yy903:
	YYDEBUG(903, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '5')	goto yy912;
	if(yych <= '6')	goto yy913;
	if(yych <= '9')	goto yy51;
	goto yy57;
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '5'){
		if(yych <= '/')	goto yy53;
		if(yych <= '0')	goto yy905;
		if(yych <= '4')	goto yy906;
		goto yy907;
	} else {
		if(yych <= 'E'){
			if(yych <= 'D')	goto yy53;
			goto yy98;
		} else {
			if(yych == 'e')	goto yy98;
			goto yy53;
		}
	}
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy53;
	if(yych <= '9')	goto yy908;
	goto yy53;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy908;
	goto yy53;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '4')	goto yy53;
	goto yy908;
yy908:
	YYDEBUG(908, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy909;
	if(yych <= '7')	goto yy910;
	goto yy909;
yy909:
	YYDEBUG(909, *YYCURSOR);

{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy910:
	YYDEBUG(910, *YYCURSOR);
	++YYCURSOR;
	goto yy911;
yy911:
	YYDEBUG(911, *YYCURSOR);

{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '9')	goto yy914;
	goto yy57;
yy913:
	YYDEBUG(913, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '6')	goto yy914;
	if(yych <= '9')	goto yy51;
	goto yy57;
yy914:
	YYDEBUG(914, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 8) {
		goto yy51;
	}
	if(yych <= 'X'){
		if(yych <= 'G'){
			if(yych <= 'C'){
				if(yych == ' ')	goto yy57;
				goto yy915;
			} else {
				if(yych == 'E')	goto yy915;
				if(yych <= 'F')	goto yy57;
				goto yy915;
			}
		} else {
			if(yych <= 'R'){
				if(yych <= 'H')	goto yy57;
				if(yych == 'M')	goto yy57;
				goto yy915;
			} else {
				if(yych <= 'T')	goto yy57;
				if(yych == 'W')	goto yy57;
				goto yy915;
			}
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'e'){
				if(yych <= 'Y')	goto yy57;
				if(yych == 'd')	goto yy57;
				goto yy915;
			} else {
				if(yych == 'g')	goto yy915;
				if(yych <= 'h')	goto yy57;
				goto yy915;
			}
		} else {
			if(yych <= 'v'){
				if(yych <= 'm')	goto yy57;
				if(yych <= 'r')	goto yy915;
				if(yych <= 't')	goto yy57;
				goto yy915;
			} else {
				if(yych == 'x')	goto yy915;
				if(yych <= 'y')	goto yy57;
				goto yy915;
			}
		}
	}
yy915:
	YYDEBUG(915, *YYCURSOR);

{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
yy916:
	YYDEBUG(916, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '9')	goto yy914;
	goto yy57;
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '2'){
		if(yych <= '/')	goto yy57;
		if(yych >= '1')	goto yy919;
		goto yy918;
	} else {
		if(yych <= '3')	goto yy920;
		if(yych <= '9')	goto yy914;
		goto yy57;
	}
yy918:
	YYDEBUG(918, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy57;
	case '0':	goto yy51;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy921;
	default:	goto yy915;
	}
yy919:
	YYDEBUG(919, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy921;
	default:	goto yy915;
	}
yy920:
	YYDEBUG(920, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy57;
	case '0':
	case '1':	goto yy921;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy51;
	default:	goto yy915;
	}
yy921:
	YYDEBUG(921, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 8) {
		goto yy51;
	}
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	goto yy56;
	case 'D':	case 'd':	goto yy61;
	case 'F':	case 'f':	goto yy63;
	case 'H':	case 'h':	goto yy60;
	case 'M':	case 'm':	goto yy59;
	case 'S':	case 's':	goto yy58;
	case 'T':	goto yy923;
	case 'W':	case 'w':	goto yy62;
	case 'Y':	case 'y':	goto yy64;
	case 't':	goto yy924;
	default:	goto yy922;
	}
yy922:
	YYDEBUG(922, *YYCURSOR);

{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
yy923:
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= '2'){
			if(yych <= '/')	goto yy53;
			if(yych <= '1')	goto yy940;
			goto yy941;
		} else {
			if(yych <= '9')	goto yy942;
			if(yych <= 'G')	goto yy53;
			goto yy66;
		}
	} else {
		if(yych <= 'g'){
			if(yych == 'U')	goto yy67;
			goto yy53;
		} else {
			if(yych <= 'h')	goto yy66;
			if(yych == 'u')	goto yy67;
			goto yy53;
		}
	}
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= '2'){
			if(yych <= '/')	goto yy53;
			if(yych >= '2')	goto yy926;
			goto yy925;
		} else {
			if(yych <= '9')	goto yy927;
			if(yych <= 'G')	goto yy53;
			goto yy66;
		}
	} else {
		if(yych <= 'g'){
			if(yych == 'U')	goto yy67;
			goto yy53;
		} else {
			if(yych <= 'h')	goto yy66;
			if(yych == 'u')	goto yy67;
			goto yy53;
		}
	}
yy925:
	YYDEBUG(925, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy934;
	if(yych <= '9')	goto yy927;
	goto yy53;
yy926:
	YYDEBUG(926, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '3')	goto yy934;
	if(yych <= '5')	goto yy928;
	goto yy53;
yy927:
	YYDEBUG(927, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '6')	goto yy53;
	goto yy928;
yy928:
	YYDEBUG(928, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy929;
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy930;
	if(yych <= '6')	goto yy931;
	goto yy53;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy932;
	goto yy53;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '0')	goto yy53;
	goto yy932;
yy932:
	YYDEBUG(932, *YYCURSOR);
	++YYCURSOR;
	goto yy933;
yy933:
	YYDEBUG(933, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				s->errors += tz_not_found;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
yy934:
	YYDEBUG(934, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy935;
	if(yych <= '9')	goto yy929;
	goto yy53;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy936;
	if(yych <= '6')	goto yy937;
	if(yych <= '9')	goto yy929;
	goto yy53;
yy936:
	YYDEBUG(936, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy938;
	if(yych <= '6')	goto yy939;
	if(yych <= '9')	goto yy932;
	goto yy53;
yy937:
	YYDEBUG(937, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '0')	goto yy938;
	if(yych <= '5')	goto yy930;
	if(yych <= '6')	goto yy931;
	goto yy53;
yy938:
	YYDEBUG(938, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy933;
	if(yych <= '9')	goto yy932;
	goto yy933;
yy939:
	YYDEBUG(939, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '0')	goto yy932;
	goto yy933;
yy940:
	YYDEBUG(940, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy949;
	if(yych <= '9')	goto yy942;
	if(yych <= ':')	goto yy943;
	goto yy53;
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '5'){
		if(yych <= '/')	goto yy53;
		if(yych <= '3')	goto yy949;
		goto yy928;
	} else {
		if(yych == ':')	goto yy943;
		goto yy53;
	}
yy942:
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy928;
	if(yych != ':')	goto yy53;
	goto yy943;
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= '6')	goto yy53;
	goto yy944;
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy945;
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy946;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy947;
	if(yych <= '6')	goto yy948;
	goto yy53;
yy947:
	YYDEBUG(947, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy932;
	goto yy53;
yy948:
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '0')	goto yy932;
	goto yy53;
yy949:
	YYDEBUG(949, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy935;
	if(yych <= '9')	goto yy929;
	if(yych <= ':')	goto yy943;
	goto yy53;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '0')	goto yy51;
	if(yych <= '9')	goto yy914;
	goto yy57;
yy951:
	YYDEBUG(951, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '2'){
		if(yych <= '/')	goto yy57;
		if(yych <= '0')	goto yy918;
		goto yy919;
	} else {
		if(yych <= '3')	goto yy920;
		if(yych <= '9')	goto yy914;
		goto yy57;
	}
yy952:
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy953;
	if(yych != 'c')	goto yy53;
	goto yy953;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'E')	goto yy954;
	if(yych != 'e')	goto yy889;
	goto yy954;
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy955;
	if(yych != 'm')	goto yy53;
	goto yy955;
yy955:
	YYDEBUG(955, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy956;
	if(yych != 'b')	goto yy53;
	goto yy956;
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy957;
	if(yych != 'e')	goto yy53;
	goto yy957;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy958;
	if(yych != 'r')	goto yy53;
	goto yy958;
yy958:
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy889;
yy959:
	YYDEBUG(959, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy960;
	if(yych != 'v')	goto yy53;
	goto yy960;
yy960:
	YYDEBUG(960, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'E')	goto yy961;
	if(yych != 'e')	goto yy889;
	goto yy961;
yy961:
	YYDEBUG(961, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy962;
	if(yych != 'm')	goto yy53;
	goto yy962;
yy962:
	YYDEBUG(962, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy963;
	if(yych != 'b')	goto yy53;
	goto yy963;
yy963:
	YYDEBUG(963, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy964;
	if(yych != 'e')	goto yy53;
	goto yy964;
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy958;
	if(yych == 'r')	goto yy958;
	goto yy53;
yy965:
	YYDEBUG(965, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy966;
	if(yych != 't')	goto yy53;
	goto yy966;
yy966:
	YYDEBUG(966, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'O')	goto yy967;
	if(yych != 'o')	goto yy889;
	goto yy967;
yy967:
	YYDEBUG(967, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy968;
	if(yych != 'b')	goto yy53;
	goto yy968;
yy968:
	YYDEBUG(968, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy969;
	if(yych != 'e')	goto yy53;
	goto yy969;
yy969:
	YYDEBUG(969, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy958;
	if(yych == 'r')	goto yy958;
	goto yy53;
yy970:
	YYDEBUG(970, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych == 'C')	goto yy121;
		if(yych <= 'O')	goto yy53;
		goto yy971;
	} else {
		if(yych <= 'c'){
			if(yych <= 'b')	goto yy53;
			goto yy121;
		} else {
			if(yych != 'p')	goto yy53;
			goto yy971;
		}
	}
yy971:
	YYDEBUG(971, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy972;
	if(yych != 't')	goto yy889;
	goto yy972;
yy972:
	YYDEBUG(972, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'E')	goto yy973;
	if(yych != 'e')	goto yy889;
	goto yy973;
yy973:
	YYDEBUG(973, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy974;
	if(yych != 'm')	goto yy53;
	goto yy974;
yy974:
	YYDEBUG(974, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy975;
	if(yych != 'b')	goto yy53;
	goto yy975;
yy975:
	YYDEBUG(975, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy976;
	if(yych != 'e')	goto yy53;
	goto yy976;
yy976:
	YYDEBUG(976, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy958;
	if(yych == 'r')	goto yy958;
	goto yy53;
yy977:
	YYDEBUG(977, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy981;
	if(yych == 'g')	goto yy981;
	goto yy53;
yy978:
	YYDEBUG(978, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy979;
	if(yych != 'r')	goto yy53;
	goto yy979;
yy979:
	YYDEBUG(979, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'I')	goto yy980;
	if(yych != 'i')	goto yy889;
	goto yy980;
yy980:
	YYDEBUG(980, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy958;
	if(yych == 'l')	goto yy958;
	goto yy53;
yy981:
	YYDEBUG(981, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'U')	goto yy982;
	if(yych != 'u')	goto yy889;
	goto yy982;
yy982:
	YYDEBUG(982, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy983;
	if(yych != 's')	goto yy53;
	goto yy983;
yy983:
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy958;
	if(yych == 't')	goto yy958;
	goto yy53;
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy985;
		if(yych <= 'X')	goto yy53;
		goto yy958;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy53;
			goto yy985;
		} else {
			if(yych == 'y')	goto yy958;
			goto yy53;
		}
	}
yy985:
	YYDEBUG(985, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'C')	goto yy986;
	if(yych != 'c')	goto yy889;
	goto yy986;
yy986:
	YYDEBUG(986, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy958;
	if(yych == 'h')	goto yy958;
	goto yy53;
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy988;
	if(yych != 'b')	goto yy53;
	goto yy988;
yy988:
	YYDEBUG(988, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'R')	goto yy989;
	if(yych != 'r')	goto yy889;
	goto yy989;
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy990;
	if(yych != 'u')	goto yy53;
	goto yy990;
yy990:
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy991;
	if(yych != 'a')	goto yy53;
	goto yy991;
yy991:
	YYDEBUG(991, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy992;
	if(yych != 'r')	goto yy53;
	goto yy992;
yy992:
	YYDEBUG(992, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy958;
	if(yych == 'y')	goto yy958;
	goto yy53;
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy1000;
		if(yych <= 'M')	goto yy53;
		goto yy999;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy53;
			goto yy1000;
		} else {
			if(yych == 'n')	goto yy999;
			goto yy53;
		}
	}
yy994:
	YYDEBUG(994, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy995;
	if(yych != 'n')	goto yy53;
	goto yy995;
yy995:
	YYDEBUG(995, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'U')	goto yy996;
	if(yych != 'u')	goto yy889;
	goto yy996;
yy996:
	YYDEBUG(996, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy997;
	if(yych != 'a')	goto yy53;
	goto yy997;
yy997:
	YYDEBUG(997, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy998;
	if(yych != 'r')	goto yy53;
	goto yy998;
yy998:
	YYDEBUG(998, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy958;
	if(yych == 'y')	goto yy958;
	goto yy53;
yy999:
	YYDEBUG(999, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy958;
	if(yych == 'e')	goto yy958;
	goto yy889;
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy958;
	if(yych == 'y')	goto yy958;
	goto yy889;
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy958;
	goto yy889;
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'I')	goto yy889;
	goto yy1003;
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy958;
	goto yy889;
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy958;
	goto yy889;
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '0')	goto yy1018;
	if(yych <= '9')	goto yy1017;
	goto yy53;
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1016;
	goto yy53;
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1014;
	if(yych <= '6')	goto yy1013;
	goto yy53;
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy987;
	if(yych == 'e')	goto yy987;
	goto yy53;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy984;
	if(yych == 'a')	goto yy984;
	goto yy53;
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1012;
	if(yych == 'e')	goto yy1012;
	goto yy53;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy952;
	if(yych == 'e')	goto yy952;
	goto yy53;
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy971;
	if(yych == 'p')	goto yy971;
	goto yy53;
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '6')	goto yy1015;
	goto yy53;
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy1015;
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy915;
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1015;
	goto yy53;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1015;
	goto yy53;
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy53;
	if(yych <= '9')	goto yy1015;
	goto yy53;
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '.')	goto yy53;
	if(yych <= '/')	goto yy1022;
	if(yych <= '0')	goto yy1021;
	if(yych <= '9')	goto yy1032;
	goto yy53;
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '.')	goto yy53;
	if(yych <= '/')	goto yy1022;
	if(yych <= '2')	goto yy1032;
	goto yy53;
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '/')	goto yy53;
	goto yy1022;
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '2')	goto yy1023;
	if(yych <= '3')	goto yy1025;
	if(yych <= '9')	goto yy1026;
	goto yy53;
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy1024;
		if(yych <= '9')	goto yy1026;
		if(yych >= 'n')	goto yy1028;
		goto yy1024;
	} else {
		if(yych <= 'r'){
			if(yych >= 'r')	goto yy1029;
			goto yy1024;
		} else {
			if(yych <= 's')	goto yy1027;
			if(yych <= 't')	goto yy1030;
			goto yy1024;
		}
	}
yy1024:
	YYDEBUG(1024, *YYCURSOR);

{
		DEBUG_OUTPUT("iso8601date | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy1024;
		if(yych <= '1')	goto yy1026;
		if(yych <= 'm')	goto yy1024;
		goto yy1028;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy1024;
			goto yy1029;
		} else {
			if(yych <= 's')	goto yy1027;
			if(yych <= 't')	goto yy1030;
			goto yy1024;
		}
	}
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'q'){
		if(yych == 'n')	goto yy1028;
		goto yy1024;
	} else {
		if(yych <= 'r')	goto yy1029;
		if(yych <= 's')	goto yy1027;
		if(yych <= 't')	goto yy1030;
		goto yy1024;
	}
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 't')	goto yy1031;
	goto yy53;
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy1031;
	goto yy53;
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy1031;
	goto yy53;
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'h')	goto yy53;
	goto yy1031;
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1024;
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '/')	goto yy53;
	goto yy1033;
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '2'){
		if(yych <= '/')	goto yy53;
		if(yych >= '1')	goto yy1035;
		goto yy1034;
	} else {
		if(yych <= '3')	goto yy1036;
		if(yych <= '9')	goto yy1026;
		goto yy53;
	}
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '0'){
			if(yych <= '/')	goto yy1024;
			goto yy1026;
		} else {
			if(yych <= '9')	goto yy1037;
			if(yych <= 'm')	goto yy1024;
			goto yy1028;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy1024;
			goto yy1029;
		} else {
			if(yych <= 's')	goto yy1027;
			if(yych <= 't')	goto yy1030;
			goto yy1024;
		}
	}
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy1024;
		if(yych <= '9')	goto yy1037;
		if(yych <= 'm')	goto yy1024;
		goto yy1028;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy1024;
			goto yy1029;
		} else {
			if(yych <= 's')	goto yy1027;
			if(yych <= 't')	goto yy1030;
			goto yy1024;
		}
	}
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych <= '/')	goto yy1024;
		if(yych <= '1')	goto yy1037;
		if(yych <= 'm')	goto yy1024;
		goto yy1028;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy1024;
			goto yy1029;
		} else {
			if(yych <= 's')	goto yy1027;
			if(yych <= 't')	goto yy1030;
			goto yy1024;
		}
	}
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych == '/')	goto yy1031;
		if(yych <= 'm')	goto yy1024;
		goto yy1028;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy1024;
			goto yy1029;
		} else {
			if(yych <= 's')	goto yy1027;
			if(yych <= 't')	goto yy1030;
			goto yy1024;
		}
	}
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy1113;
		if(yych <= 'T')	goto yy53;
		goto yy1112;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy53;
			goto yy1113;
		} else {
			if(yych == 'u')	goto yy1112;
			goto yy53;
		}
	}
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1110;
	if(yych == 'e')	goto yy1110;
	goto yy53;
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1107;
	if(yych == 'a')	goto yy1107;
	goto yy53;
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy1104;
		if(yych <= 'T')	goto yy53;
		goto yy1103;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy53;
			goto yy1104;
		} else {
			if(yych == 'u')	goto yy1103;
			goto yy53;
		}
	}
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1100;
	if(yych == 'e')	goto yy1100;
	goto yy53;
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1098;
	if(yych == 'c')	goto yy1098;
	goto yy53;
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy1096;
	if(yych == 'o')	goto yy1096;
	goto yy53;
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1094;
	if(yych == 'e')	goto yy1094;
	goto yy53;
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/'){
		if(yych == '-')	goto yy1049;
		goto yy53;
	} else {
		if(yych <= '0')	goto yy1048;
		if(yych <= '9')	goto yy1068;
		goto yy53;
	}
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy1049;
	if(yych <= '/')	goto yy53;
	if(yych <= '2')	goto yy1068;
	goto yy53;
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '-')	goto yy53;
	goto yy1049;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '2')	goto yy1050;
	if(yych <= '3')	goto yy1051;
	if(yych <= '9')	goto yy1052;
	goto yy53;
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '9'){
			if(yych <= '/')	goto yy775;
			goto yy1052;
		} else {
			if(yych == 'T')	goto yy1057;
			goto yy775;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy1054;
			if(yych <= 'q')	goto yy775;
			goto yy1055;
		} else {
			if(yych <= 's')	goto yy1053;
			if(yych <= 't')	goto yy1056;
			goto yy775;
		}
	}
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy775;
			goto yy1052;
		} else {
			if(yych == 'T')	goto yy1057;
			goto yy775;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy1054;
			if(yych <= 'q')	goto yy775;
			goto yy1055;
		} else {
			if(yych <= 's')	goto yy1053;
			if(yych <= 't')	goto yy1056;
			goto yy775;
		}
	}
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych == 'T')	goto yy1057;
		if(yych <= 'm')	goto yy775;
		goto yy1054;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy775;
			goto yy1055;
		} else {
			if(yych <= 's')	goto yy1053;
			if(yych <= 't')	goto yy1056;
			goto yy775;
		}
	}
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 't')	goto yy1067;
	goto yy53;
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy1067;
	goto yy53;
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'd')	goto yy1067;
	goto yy53;
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'h')	goto yy1067;
	goto yy53;
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '1')	goto yy1058;
	if(yych <= '2')	goto yy1059;
	if(yych <= '9')	goto yy1060;
	goto yy53;
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1060;
	if(yych <= ':')	goto yy1061;
	goto yy53;
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '3')	goto yy1060;
	if(yych == ':')	goto yy1061;
	goto yy53;
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy1061;
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1062;
	if(yych <= '9')	goto yy1063;
	goto yy53;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1063;
	if(yych <= ':')	goto yy1064;
	goto yy53;
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy1064;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1065;
	if(yych <= '6')	goto yy1066;
	if(yych <= '9')	goto yy932;
	goto yy53;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy933;
	if(yych <= '9')	goto yy932;
	goto yy933;
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '0')	goto yy932;
	goto yy933;
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'T')	goto yy1057;
	goto yy775;
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '-')	goto yy53;
	goto yy1069;
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '2'){
		if(yych <= '/')	goto yy53;
		if(yych >= '1')	goto yy1071;
		goto yy1070;
	} else {
		if(yych <= '3')	goto yy1072;
		if(yych <= '9')	goto yy1052;
		goto yy53;
	}
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '9'){
			if(yych <= '/')	goto yy775;
			if(yych <= '0')	goto yy1052;
			goto yy1073;
		} else {
			if(yych == 'T')	goto yy1057;
			goto yy775;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy1054;
			if(yych <= 'q')	goto yy775;
			goto yy1055;
		} else {
			if(yych <= 's')	goto yy1053;
			if(yych <= 't')	goto yy1056;
			goto yy775;
		}
	}
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '9'){
			if(yych <= '/')	goto yy775;
			goto yy1073;
		} else {
			if(yych == 'T')	goto yy1057;
			goto yy775;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy1054;
			if(yych <= 'q')	goto yy775;
			goto yy1055;
		} else {
			if(yych <= 's')	goto yy1053;
			if(yych <= 't')	goto yy1056;
			goto yy775;
		}
	}
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'm'){
		if(yych <= '1'){
			if(yych <= '/')	goto yy775;
			goto yy1073;
		} else {
			if(yych == 'T')	goto yy1057;
			goto yy775;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy1054;
			if(yych <= 'q')	goto yy775;
			goto yy1055;
		} else {
			if(yych <= 's')	goto yy1053;
			if(yych <= 't')	goto yy1056;
			goto yy775;
		}
	}
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'n'){
		if(yych == 'T')	goto yy1074;
		if(yych <= 'm')	goto yy1024;
		goto yy1054;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy1024;
			goto yy1055;
		} else {
			if(yych <= 's')	goto yy1053;
			if(yych <= 't')	goto yy1056;
			goto yy1024;
		}
	}
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '1')	goto yy1075;
	if(yych <= '2')	goto yy1076;
	if(yych <= '9')	goto yy1060;
	goto yy53;
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1077;
	if(yych <= ':')	goto yy1061;
	goto yy53;
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '3')	goto yy1077;
	if(yych == ':')	goto yy1061;
	goto yy53;
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy1078;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1079;
	if(yych <= '9')	goto yy1063;
	goto yy53;
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '9')	goto yy1080;
	if(yych <= ':')	goto yy1064;
	goto yy53;
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy53;
	goto yy1081;
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1082;
	if(yych <= '6')	goto yy1083;
	if(yych <= '9')	goto yy932;
	goto yy53;
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy933;
	if(yych <= '9')	goto yy1084;
	goto yy933;
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '0')	goto yy933;
	goto yy1084;
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych != '.')	goto yy933;
	goto yy1085;
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy1086;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yyaccept = 19;
	YYMARKER = ++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	goto yy1087;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	if(yych <= ','){
		if(yych != '+')	goto yy933;
		goto yy1088;
	} else {
		if(yych <= '-')	goto yy1088;
		if(yych <= '/')	goto yy933;
		if(yych <= '9')	goto yy1086;
		goto yy933;
	}
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '1')	goto yy1089;
	if(yych <= '2')	goto yy1090;
	if(yych <= '9')	goto yy1091;
	goto yy53;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy933;
	if(yych <= '9')	goto yy1091;
	if(yych <= ':')	goto yy1092;
	goto yy933;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '5'){
		if(yych <= '/')	goto yy933;
		if(yych >= '4')	goto yy1093;
		goto yy1091;
	} else {
		if(yych <= '9')	goto yy932;
		if(yych <= ':')	goto yy1092;
		goto yy933;
	}
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy933;
	if(yych <= '5')	goto yy1093;
	if(yych <= '9')	goto yy932;
	if(yych >= ';')	goto yy933;
	goto yy1092;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy933;
	if(yych <= '5')	goto yy1093;
	if(yych <= '9')	goto yy932;
	goto yy933;
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy933;
	if(yych <= '9')	goto yy932;
	goto yy933;
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1095;
	if(yych != 'c')	goto yy53;
	goto yy1095;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == '-')	goto yy863;
		goto yy889;
	} else {
		if(yych <= 'E')	goto yy954;
		if(yych == 'e')	goto yy954;
		goto yy889;
	}
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1097;
	if(yych != 'v')	goto yy53;
	goto yy1097;
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == '-')	goto yy863;
		goto yy889;
	} else {
		if(yych <= 'E')	goto yy961;
		if(yych == 'e')	goto yy961;
		goto yy889;
	}
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1099;
	if(yych != 't')	goto yy53;
	goto yy1099;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych == '-')	goto yy863;
		goto yy889;
	} else {
		if(yych <= 'O')	goto yy967;
		if(yych == 'o')	goto yy967;
		goto yy889;
	}
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1101;
	if(yych != 'p')	goto yy53;
	goto yy1101;
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == '-')	goto yy863;
		goto yy889;
	} else {
		if(yych <= 'T')	goto yy1102;
		if(yych != 't')	goto yy889;
		goto yy1102;
	}
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == '-')	goto yy863;
		goto yy889;
	} else {
		if(yych <= 'E')	goto yy973;
		if(yych == 'e')	goto yy973;
		goto yy889;
	}
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy1106;
	if(yych == 'g')	goto yy1106;
	goto yy53;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1105;
	if(yych != 'r')	goto yy53;
	goto yy1105;
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych == '-')	goto yy863;
		goto yy889;
	} else {
		if(yych <= 'I')	goto yy980;
		if(yych == 'i')	goto yy980;
		goto yy889;
	}
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych == '-')	goto yy863;
		goto yy889;
	} else {
		if(yych <= 'U')	goto yy982;
		if(yych == 'u')	goto yy982;
		goto yy889;
	}
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy1108;
		if(yych <= 'X')	goto yy53;
		goto yy1109;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy53;
			goto yy1108;
		} else {
			if(yych == 'y')	goto yy1109;
			goto yy53;
		}
	}
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'B'){
		if(yych == '-')	goto yy863;
		goto yy889;
	} else {
		if(yych <= 'C')	goto yy986;
		if(yych == 'c')	goto yy986;
		goto yy889;
	}
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '-')	goto yy863;
	goto yy889;
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1111;
	if(yych != 'b')	goto yy53;
	goto yy1111;
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Q'){
		if(yych == '-')	goto yy863;
		goto yy889;
	} else {
		if(yych <= 'R')	goto yy989;
		if(yych == 'r')	goto yy989;
		goto yy889;
	}
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy1116;
		if(yych <= 'M')	goto yy53;
		goto yy1115;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy53;
			goto yy1116;
		} else {
			if(yych == 'n')	goto yy1115;
			goto yy53;
		}
	}
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1114;
	if(yych != 'n')	goto yy53;
	goto yy1114;
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych == '-')	goto yy863;
		goto yy889;
	} else {
		if(yych <= 'U')	goto yy996;
		if(yych == 'u')	goto yy996;
		goto yy889;
	}
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == '-')	goto yy863;
		goto yy889;
	} else {
		if(yych <= 'E')	goto yy958;
		if(yych == 'e')	goto yy958;
		goto yy889;
	}
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'X'){
		if(yych == '-')	goto yy863;
		goto yy889;
	} else {
		if(yych <= 'Y')	goto yy958;
		if(yych == 'y')	goto yy958;
		goto yy889;
	}
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= '-')	goto yy617;
		if(yych <= '.')	goto yy845;
		if(yych <= '/')	goto yy844;
		goto yy617;
	} else {
		if(yych <= 'U')	goto yy74;
		if(yych == 'u')	goto yy74;
		goto yy617;
	}
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych == 'C')	goto yy121;
		if(yych <= 'O')	goto yy53;
		goto yy709;
	} else {
		if(yych <= 'c'){
			if(yych <= 'b')	goto yy53;
			goto yy121;
		} else {
			if(yych == 'p')	goto yy709;
			goto yy53;
		}
	}
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'm'){
		if(yych <= '.'){
			if(yych <= ',')	goto yy1121;
			if(yych <= '-')	goto yy615;
			goto yy845;
		} else {
			if(yych <= '/')	goto yy844;
			if(yych <= '9')	goto yy851;
			goto yy1121;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'n')	goto yy612;
			if(yych <= 'q')	goto yy1121;
			goto yy613;
		} else {
			if(yych <= 's')	goto yy606;
			if(yych <= 't')	goto yy610;
			goto yy1121;
		}
	}
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
	goto yy1121;
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	goto yy1120;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy616;
	case 'A':	case 'a':	goto yy699;
	case 'D':	case 'd':	goto yy608;
	case 'F':	case 'f':	goto yy609;
	case 'H':	case 'h':	goto yy60;
	case 'I':	goto yy619;
	case 'J':	case 'j':	goto yy623;
	case 'M':	case 'm':	goto yy607;
	case 'N':	case 'n':	goto yy626;
	case 'O':	case 'o':	goto yy625;
	case 'S':	case 's':	goto yy605;
	case 'T':	case 't':	goto yy65;
	case 'V':	goto yy621;
	case 'W':	case 'w':	goto yy62;
	case 'X':	goto yy622;
	case 'Y':	case 'y':	goto yy64;
	default:	goto yy53;
	}
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= ':'){
		if(yych <= '.'){
			if(yych <= ',')	goto yy1121;
			if(yych <= '-')	goto yy615;
			goto yy1123;
		} else {
			if(yych <= '/')	goto yy844;
			if(yych <= '5')	goto yy1125;
			if(yych <= '9')	goto yy851;
			goto yy1124;
		}
	} else {
		if(yych <= 'q'){
			if(yych == 'n')	goto yy612;
			goto yy1121;
		} else {
			if(yych <= 'r')	goto yy613;
			if(yych <= 's')	goto yy606;
			if(yych <= 't')	goto yy610;
			goto yy1121;
		}
	}
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '1'){
		if(yych <= '/')	goto yy617;
		if(yych <= '0')	goto yy1147;
		goto yy1148;
	} else {
		if(yych <= '5')	goto yy1149;
		if(yych <= '9')	goto yy1150;
		goto yy617;
	}
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1142;
	if(yych <= '9')	goto yy1143;
	goto yy53;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy852;
	if(yych <= '/')	goto yy57;
	if(yych >= ':')	goto yy57;
	goto yy1126;
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':	case 'S':
	case 'T':	case 'V':	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':
	case 'n':
	case 'o':	case 's':
	case 't':	case 'w':	case 'y':	goto yy884;
	case '-':	goto yy881;
	case '.':	goto yy887;
	case '/':	goto yy882;
	case '0':	goto yy1128;
	case '1':	goto yy1129;
	case '2':	goto yy1130;
	case '3':	goto yy1131;
	case '4':
	case '5':	goto yy1132;
	case '6':	goto yy1133;
	case '7':
	case '8':
	case '9':	goto yy51;
	case 'W':	goto yy904;
	default:	goto yy1127;
	}
yy1127:
	YYDEBUG(1127, *YYCURSOR);

{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '0')	goto yy1140;
	if(yych <= '9')	goto yy1141;
	goto yy57;
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '2')	goto yy1139;
	if(yych <= '9')	goto yy1138;
	goto yy57;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '9')	goto yy1138;
	goto yy57;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '5')	goto yy1136;
	if(yych <= '6')	goto yy1137;
	if(yych <= '9')	goto yy1134;
	goto yy57;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '9')	goto yy1134;
	goto yy57;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy57;
	if(yych <= '0')	goto yy1134;
	if(yych <= '9')	goto yy51;
	goto yy57;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 8) {
		goto yy51;
	}
	if(yych <= 'X'){
		if(yych <= 'G'){
			if(yych <= 'C'){
				if(yych == ' ')	goto yy57;
				goto yy1135;
			} else {
				if(yych == 'E')	goto yy1135;
				if(yych <= 'F')	goto yy57;
				goto yy1135;
			}
		} else {
			if(yych <= 'R'){
				if(yych <= 'H')	goto yy57;
				if(yych == 'M')	goto yy57;
				goto yy1135;
			} else {
				if(yych <= 'T')	goto yy57;
				if(yych == 'W')	goto yy57;
				goto yy1135;
			}
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'e'){
				if(yych <= 'Y')	goto yy57;
				if(yych == 'd')	goto yy57;
				goto yy1135;
			} else {
				if(yych == 'g')	goto yy1135;
				if(yych <= 'h')	goto yy57;
				goto yy1135;
			}
		} else {
			if(yych <= 'v'){
				if(yych <= 'm')	goto yy57;
				if(yych <= 'r')	goto yy1135;
				if(yych <= 't')	goto yy57;
				goto yy1135;
			} else {
				if(yych == 'x')	goto yy1135;
				if(yych <= 'y')	goto yy57;
				goto yy1135;
			}
		}
	}
yy1135:
	YYDEBUG(1135, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy914;
	default:	goto yy1135;
	}
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':	goto yy914;
	case '7':
	case '8':
	case '9':	goto yy51;
	default:	goto yy1135;
	}
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy57;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy914;
	default:	goto yy1135;
	}
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy57;
	case '0':	goto yy918;
	case '1':
	case '2':	goto yy919;
	case '3':	goto yy920;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy914;
	default:	goto yy1135;
	}
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy57;
	case '0':	goto yy51;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy914;
	default:	goto yy1135;
	}
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy57;
	case '0':	goto yy918;
	case '1':
	case '2':	goto yy919;
	case '3':	goto yy920;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy914;
	default:	goto yy1135;
	}
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy1144;
		goto yy634;
	} else {
		if(yych <= '9')	goto yy1143;
		if(yych <= ':')	goto yy1144;
		goto yy634;
	}
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy1144;
	if(yych != ':')	goto yy634;
	goto yy1144;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1145;
	if(yych <= '6')	goto yy1146;
	if(yych <= '9')	goto yy639;
	goto yy53;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy640;
	if(yych <= '/')	goto yy634;
	if(yych <= '9')	goto yy639;
	goto yy634;
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy640;
	if(yych == '0')	goto yy639;
	goto yy634;
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy1151;
		goto yy634;
	} else {
		if(yych <= '9')	goto yy1150;
		if(yych <= ':')	goto yy1144;
		goto yy634;
	}
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy1151;
		goto yy634;
	} else {
		if(yych <= '2')	goto yy1150;
		if(yych <= '9')	goto yy1143;
		if(yych <= ':')	goto yy1144;
		goto yy634;
	}
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy1151;
		goto yy634;
	} else {
		if(yych <= '9')	goto yy1143;
		if(yych <= ':')	goto yy1144;
		goto yy634;
	}
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy1151;
	if(yych == ':')	goto yy1144;
	goto yy634;
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy53;
	if(yych <= '5')	goto yy1152;
	if(yych <= '6')	goto yy1153;
	if(yych <= '9')	goto yy727;
	goto yy53;
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy640;
	if(yych <= '/')	goto yy634;
	if(yych <= '9')	goto yy1154;
	goto yy634;
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy640;
		goto yy634;
	} else {
		if(yych <= '0')	goto yy1154;
		if(yych <= '9')	goto yy728;
		goto yy634;
	}
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy640;
	if(yych <= '/')	goto yy634;
	if(yych <= '9')	goto yy730;
	goto yy634;
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= ':'){
		if(yych <= '.'){
			if(yych <= ',')	goto yy604;
			if(yych <= '-')	goto yy615;
			goto yy618;
		} else {
			if(yych <= '/')	goto yy614;
			if(yych <= '5')	goto yy1125;
			if(yych <= '9')	goto yy851;
			goto yy627;
		}
	} else {
		if(yych <= 'q'){
			if(yych == 'n')	goto yy612;
			goto yy604;
		} else {
			if(yych <= 'r')	goto yy613;
			if(yych <= 's')	goto yy606;
			if(yych <= 't')	goto yy610;
			goto yy604;
		}
	}
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= ':'){
		if(yych <= '.'){
			if(yych <= ',')	goto yy1121;
			if(yych <= '-')	goto yy615;
			goto yy1123;
		} else {
			if(yych <= '/')	goto yy614;
			if(yych <= '5')	goto yy1125;
			if(yych <= '9')	goto yy851;
			goto yy1124;
		}
	} else {
		if(yych <= 'q'){
			if(yych == 'n')	goto yy612;
			goto yy1121;
		} else {
			if(yych <= 'r')	goto yy613;
			if(yych <= 's')	goto yy606;
			if(yych <= 't')	goto yy610;
			goto yy1121;
		}
	}
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy53;
	if(yych >= ':')	goto yy53;
	goto yy1158;
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy1159;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	if(yych <= '/')	goto yy1160;
	if(yych <= '9')	goto yy1158;
	goto yy1160;
yy1160:
	YYDEBUG(1160, *YYCURSOR);

{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy134;
			goto yy1192;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'n')	goto yy1192;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= '@'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych == 'I')	goto yy1186;
			if(yych <= 'T')	goto yy134;
			goto yy1185;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			if(yych <= 'h')	goto yy134;
			goto yy1186;
		} else {
			if(yych == 'u')	goto yy1185;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'M'){
		if(yych <= '@'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych == 'D')	goto yy1174;
			if(yych <= 'L')	goto yy134;
			goto yy1175;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			if(yych <= 'c')	goto yy134;
			goto yy1174;
		} else {
			if(yych == 'm')	goto yy1175;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy134;
			goto yy1170;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'e')	goto yy1170;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy134;
			goto yy1166;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'e')	goto yy1166;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'K')	goto yy135;
			goto yy1167;
		}
	} else {
		if(yych <= 'k'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 'l')	goto yy1167;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'F')	goto yy1168;
		if(yych != 'f')	goto yy3;
		goto yy1168;
	}
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1169;
	if(yych != 't')	goto yy53;
	goto yy1169;
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy159;
	if(yych == 'h')	goto yy159;
	goto yy53;
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy341;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy341;
			if(yych <= 'R')	goto yy135;
			goto yy1171;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy341;
			goto yy135;
		} else {
			if(yych <= 's')	goto yy1171;
			if(yych <= 'z')	goto yy135;
			goto yy341;
		}
	}
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'C'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'D')	goto yy1172;
		if(yych != 'd')	goto yy3;
		goto yy1172;
	}
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1173;
	if(yych != 'a')	goto yy53;
	goto yy1173;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy347;
	if(yych == 'y')	goto yy347;
	goto yy53;
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy132;
		if(yych <= '@')	goto yy3;
		goto yy1182;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy1182;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy135;
			goto yy1176;
		}
	} else {
		if(yych <= 'n'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 'o')	goto yy1176;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Q'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'R')	goto yy1177;
		if(yych != 'r')	goto yy3;
		goto yy1177;
	}
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1178;
	if(yych != 'r')	goto yy53;
	goto yy1178;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy1179;
	if(yych != 'o')	goto yy53;
	goto yy1179;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy1180;
	if(yych != 'w')	goto yy53;
	goto yy1180;
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	++YYCURSOR;
	goto yy1181;
yy1181:
	YYDEBUG(1181, *YYCURSOR);

{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'Y')	goto yy1183;
		if(yych != 'y')	goto yy3;
		goto yy1183;
	}
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	++YYCURSOR;
	goto yy1184;
yy1184:
	YYDEBUG(1184, *YYCURSOR);

{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy341;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy341;
			if(yych <= 'Q')	goto yy135;
			goto yy1188;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy341;
			goto yy135;
		} else {
			if(yych <= 'r')	goto yy1188;
			if(yych <= 'z')	goto yy135;
			goto yy341;
		}
	}
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= '@'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= 'Q')	goto yy135;
			if(yych >= 'S')	goto yy317;
			goto yy1187;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 'r')	goto yy1187;
			if(yych <= 's')	goto yy317;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'C'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'D')	goto yy159;
		if(yych == 'd')	goto yy159;
		goto yy3;
	}
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'S')	goto yy1189;
		if(yych != 's')	goto yy3;
		goto yy1189;
	}
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1190;
	if(yych != 'd')	goto yy53;
	goto yy1190;
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1191;
	if(yych != 'a')	goto yy53;
	goto yy1191;
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy347;
	if(yych == 'y')	goto yy347;
	goto yy53;
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy135;
			goto yy1193;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 't')	goto yy1193;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'H')	goto yy159;
		if(yych == 'h')	goto yy159;
		goto yy3;
	}
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy134;
			goto yy1192;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy1223;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych <= '/'){
			if(yych == ')')	goto yy132;
			if(yych <= '.')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'H'){
				if(yych <= '@')	goto yy3;
				goto yy134;
			} else {
				if(yych <= 'I')	goto yy1186;
				if(yych <= 'T')	goto yy134;
				goto yy1185;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy134;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy138;
				if(yych <= '`')	goto yy3;
				goto yy137;
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'i')	goto yy1217;
				goto yy137;
			} else {
				if(yych <= 'u')	goto yy1216;
				if(yych <= 'z')	goto yy137;
				goto yy3;
			}
		}
	}
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'M'){
		if(yych <= '/'){
			if(yych == ')')	goto yy132;
			if(yych <= '.')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'C'){
				if(yych <= '@')	goto yy3;
				goto yy134;
			} else {
				if(yych <= 'D')	goto yy1174;
				if(yych <= 'L')	goto yy134;
				goto yy1175;
			}
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy134;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy138;
				if(yych <= '`')	goto yy3;
				goto yy137;
			}
		} else {
			if(yych <= 'l'){
				if(yych <= 'd')	goto yy1207;
				goto yy137;
			} else {
				if(yych <= 'm')	goto yy1208;
				if(yych <= 'z')	goto yy137;
				goto yy3;
			}
		}
	}
yy1197:
	YYDEBUG(1197, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy134;
			goto yy1170;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy1203;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy1198:
	YYDEBUG(1198, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy134;
			goto yy1166;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy1199;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'K')	goto yy135;
			goto yy1167;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'l')	goto yy1200;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'F'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'E')	goto yy3;
			goto yy1168;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'f')	goto yy1201;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1169;
	if(yych != 't')	goto yy144;
	goto yy1202;
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy53;
			goto yy138;
		} else {
			if(yych == 'H')	goto yy159;
			goto yy53;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy53;
			goto yy143;
		} else {
			if(yych <= 'h')	goto yy241;
			if(yych <= 'z')	goto yy143;
			goto yy53;
		}
	}
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy341;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy341;
			if(yych <= 'R')	goto yy135;
			goto yy1171;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy341;
		} else {
			if(yych == 's')	goto yy1204;
			if(yych <= 'z')	goto yy142;
			goto yy341;
		}
	}
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'C')	goto yy3;
			goto yy1172;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy1205;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1173;
	if(yych != 'a')	goto yy144;
	goto yy1206;
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy347;
	if(yych == 'y')	goto yy355;
	goto yy144;
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			goto yy1182;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '^')	goto yy3;
			goto yy138;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'a')	goto yy1214;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'O'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy135;
			goto yy1176;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'o')	goto yy1209;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'Q')	goto yy3;
			goto yy1177;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy1210;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1178;
	if(yych != 'r')	goto yy144;
	goto yy1211;
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy1179;
	if(yych != 'o')	goto yy144;
	goto yy1212;
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'W')	goto yy1180;
	if(yych != 'w')	goto yy144;
	goto yy1213;
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy138;
		goto yy1181;
	} else {
		if(yych <= '_')	goto yy138;
		if(yych <= '`')	goto yy1181;
		if(yych <= 'z')	goto yy143;
		goto yy1181;
	}
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Y'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'X')	goto yy3;
			goto yy1183;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'y')	goto yy1215;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy138;
		goto yy1184;
	} else {
		if(yych <= '_')	goto yy138;
		if(yych <= '`')	goto yy1184;
		if(yych <= 'z')	goto yy143;
		goto yy1184;
	}
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy341;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy341;
			if(yych <= 'Q')	goto yy135;
			goto yy1188;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy341;
		} else {
			if(yych == 'r')	goto yy1219;
			if(yych <= 'z')	goto yy142;
			goto yy341;
		}
	}
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '/'){
			if(yych == ')')	goto yy132;
			if(yych <= '.')	goto yy3;
			goto yy138;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy135;
			if(yych <= 'R')	goto yy1187;
			goto yy317;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych <= 'r'){
				if(yych <= 'q')	goto yy142;
				goto yy1218;
			} else {
				if(yych <= 's')	goto yy320;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'C')	goto yy3;
			goto yy159;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy241;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'R')	goto yy3;
			goto yy1189;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 's')	goto yy1220;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1190;
	if(yych != 'd')	goto yy144;
	goto yy1221;
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1191;
	if(yych != 'a')	goto yy144;
	goto yy1222;
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy347;
	if(yych == 'y')	goto yy355;
	goto yy144;
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy135;
			goto yy1193;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 't')	goto yy1224;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'G')	goto yy3;
			goto yy159;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy241;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych <= '@'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych == 'R')	goto yy1236;
			if(yych <= 'X')	goto yy134;
			goto yy1237;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			if(yych <= 'q')	goto yy134;
			goto yy1236;
		} else {
			if(yych == 'y')	goto yy1237;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy134;
			goto yy1231;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'd')	goto yy1231;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy134;
			goto yy1228;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'n')	goto yy1228;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy341;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy341;
			if(yych <= 'C')	goto yy135;
			goto yy1229;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy341;
			goto yy135;
		} else {
			if(yych <= 'd')	goto yy1229;
			if(yych <= 'z')	goto yy135;
			goto yy341;
		}
	}
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'A')	goto yy1230;
		if(yych != 'a')	goto yy3;
		goto yy1230;
	}
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy347;
	if(yych == 'y')	goto yy347;
	goto yy53;
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy135;
			goto yy1232;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 'n')	goto yy1232;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'I')	goto yy1233;
		if(yych != 'i')	goto yy3;
		goto yy1233;
	}
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy1234;
	if(yych != 'g')	goto yy53;
	goto yy1234;
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy1235;
	if(yych != 'h')	goto yy53;
	goto yy1235;
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1183;
	if(yych == 't')	goto yy1183;
	goto yy53;
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '-')	goto yy361;
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych == 'C')	goto yy1238;
			goto yy135;
		} else {
			if(yych <= 'b'){
				if(yych <= '`')	goto yy3;
				goto yy135;
			} else {
				if(yych <= 'c')	goto yy1238;
				if(yych <= 'z')	goto yy135;
				goto yy3;
			}
		}
	}
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy359;
			goto yy360;
		} else {
			if(yych == '-')	goto yy361;
			goto yy359;
		}
	} else {
		if(yych <= '@'){
			if(yych <= '/')	goto yy3;
			if(yych <= '9')	goto yy359;
			goto yy3;
		} else {
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'H')	goto yy358;
		if(yych == 'h')	goto yy358;
		goto yy3;
	}
yy1239:
	YYDEBUG(1239, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Y'){
		if(yych <= '/'){
			if(yych == ')')	goto yy132;
			if(yych <= '.')	goto yy3;
			goto yy138;
		} else {
			if(yych <= 'Q'){
				if(yych <= '@')	goto yy3;
				goto yy134;
			} else {
				if(yych <= 'R')	goto yy1236;
				if(yych <= 'X')	goto yy134;
				goto yy1237;
			}
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy134;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy138;
				if(yych <= '`')	goto yy3;
				goto yy137;
			}
		} else {
			if(yych <= 'x'){
				if(yych <= 'r')	goto yy1250;
				goto yy137;
			} else {
				if(yych <= 'y')	goto yy1251;
				if(yych <= 'z')	goto yy137;
				goto yy3;
			}
		}
	}
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy134;
			goto yy1231;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy1245;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy134;
			goto yy1228;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy1242;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy341;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy341;
			if(yych <= 'C')	goto yy135;
			goto yy1229;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy341;
		} else {
			if(yych == 'd')	goto yy1243;
			if(yych <= 'z')	goto yy142;
			goto yy341;
		}
	}
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			goto yy1230;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy1244;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy347;
	if(yych == 'y')	goto yy355;
	goto yy144;
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy135;
			goto yy1232;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy1246;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'I'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'H')	goto yy3;
			goto yy1233;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'i')	goto yy1247;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy1234;
	if(yych != 'g')	goto yy144;
	goto yy1248;
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy1235;
	if(yych != 'h')	goto yy144;
	goto yy1249;
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1183;
	if(yych == 't')	goto yy1215;
	goto yy144;
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy361;
				goto yy359;
			} else {
				if(yych <= '/')	goto yy138;
				if(yych <= '9')	goto yy359;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'C'){
				if(yych <= 'B')	goto yy135;
				goto yy1238;
			} else {
				if(yych <= 'Z')	goto yy135;
				if(yych <= '^')	goto yy3;
				goto yy138;
			}
		} else {
			if(yych <= 'b'){
				if(yych <= '`')	goto yy3;
				goto yy142;
			} else {
				if(yych <= 'c')	goto yy1252;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy359;
			goto yy360;
		} else {
			if(yych == '-')	goto yy361;
			if(yych <= '.')	goto yy359;
			goto yy138;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '9')	goto yy359;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Z')	goto yy135;
			goto yy3;
		} else {
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'G')	goto yy3;
			goto yy358;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy457;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'N'){
			if(yych == ')')	goto yy132;
			if(yych <= '@')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'O')	goto yy1261;
			if(yych <= 'U')	goto yy134;
			if(yych <= 'V')	goto yy1262;
			goto yy1259;
		}
	} else {
		if(yych <= 'o'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			if(yych <= 'n')	goto yy134;
			goto yy1261;
		} else {
			if(yych <= 'v'){
				if(yych <= 'u')	goto yy134;
				goto yy1262;
			} else {
				if(yych <= 'w')	goto yy1259;
				if(yych <= 'z')	goto yy134;
				goto yy3;
			}
		}
	}
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'W')	goto yy134;
			goto yy1258;
		}
	} else {
		if(yych <= 'w'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'x')	goto yy1258;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy134;
			goto yy1256;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 'n')	goto yy1256;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy135;
			goto yy1257;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 't')	goto yy1257;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'H')	goto yy159;
		if(yych == 'h')	goto yy159;
		goto yy3;
	}
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy135;
			goto yy317;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 't')	goto yy317;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '@'){
		if(yych == ')')	goto yy132;
		goto yy1260;
	} else {
		if(yych <= 'Z')	goto yy135;
		if(yych <= '`')	goto yy1260;
		if(yych <= 'z')	goto yy135;
		goto yy1260;
	}
yy1260:
	YYDEBUG(1260, *YYCURSOR);

{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy135;
			goto yy1267;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 'n')	goto yy1267;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '-')	goto yy361;
			if(yych == '/')	goto yy3;
			goto yy359;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych != 'E')	goto yy135;
			goto yy1263;
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy3;
				goto yy135;
			} else {
				if(yych <= 'e')	goto yy1263;
				if(yych <= 'z')	goto yy135;
				goto yy3;
			}
		}
	}
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'M')	goto yy1264;
		if(yych != 'm')	goto yy3;
		goto yy1264;
	}
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1265;
	if(yych != 'b')	goto yy53;
	goto yy1265;
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1266;
	if(yych != 'e')	goto yy53;
	goto yy1266;
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy358;
	if(yych == 'r')	goto yy358;
	goto yy53;
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) == ')')	goto yy132;
	goto yy1268;
yy1268:
	YYDEBUG(1268, *YYCURSOR);

{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1269:
	YYDEBUG(1269, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'W'){
		if(yych <= '@'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy132;
			} else {
				if(yych == '/')	goto yy138;
				goto yy3;
			}
		} else {
			if(yych <= 'O'){
				if(yych <= 'N')	goto yy134;
				goto yy1261;
			} else {
				if(yych <= 'U')	goto yy134;
				if(yych <= 'V')	goto yy1262;
				goto yy1259;
			}
		}
	} else {
		if(yych <= 'n'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy134;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy138;
				if(yych <= '`')	goto yy3;
				goto yy137;
			}
		} else {
			if(yych <= 'v'){
				if(yych <= 'o')	goto yy1276;
				if(yych <= 'u')	goto yy137;
				goto yy1277;
			} else {
				if(yych <= 'w')	goto yy1275;
				if(yych <= 'z')	goto yy137;
				goto yy3;
			}
		}
	}
yy1270:
	YYDEBUG(1270, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'X'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'W')	goto yy134;
			goto yy1258;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'x')	goto yy1274;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy1271:
	YYDEBUG(1271, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy134;
			goto yy1256;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy1272;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy135;
			goto yy1257;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 't')	goto yy1273;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'G')	goto yy3;
			goto yy159;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy241;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1274:
	YYDEBUG(1274, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy135;
			goto yy317;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 't')	goto yy320;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy1275:
	YYDEBUG(1275, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy1260;
			goto yy132;
		} else {
			if(yych == '/')	goto yy138;
			goto yy1260;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '^')	goto yy1260;
			goto yy138;
		} else {
			if(yych <= '`')	goto yy1260;
			if(yych <= 'z')	goto yy142;
			goto yy1260;
		}
	}
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy135;
			goto yy1267;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy1282;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy360;
			goto yy359;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy361;
				goto yy359;
			} else {
				if(yych <= '/')	goto yy138;
				if(yych <= '9')	goto yy359;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'E'){
				if(yych <= 'D')	goto yy135;
				goto yy1263;
			} else {
				if(yych <= 'Z')	goto yy135;
				if(yych <= '^')	goto yy3;
				goto yy138;
			}
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy3;
				goto yy142;
			} else {
				if(yych <= 'e')	goto yy1278;
				if(yych <= 'z')	goto yy142;
				goto yy3;
			}
		}
	}
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'M'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'L')	goto yy3;
			goto yy1264;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'm')	goto yy1279;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1265;
	if(yych != 'b')	goto yy144;
	goto yy1280;
yy1280:
	YYDEBUG(1280, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1266;
	if(yych != 'e')	goto yy144;
	goto yy1281;
yy1281:
	YYDEBUG(1281, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy53;
			goto yy138;
		} else {
			if(yych == 'R')	goto yy358;
			goto yy53;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy138;
			if(yych <= '`')	goto yy53;
			goto yy143;
		} else {
			if(yych <= 'r')	goto yy457;
			if(yych <= 'z')	goto yy143;
			goto yy53;
		}
	}
yy1282:
	YYDEBUG(1282, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == ')')	goto yy132;
		if(yych <= '.')	goto yy1268;
		goto yy138;
	} else {
		if(yych <= '_'){
			if(yych <= '^')	goto yy1268;
			goto yy138;
		} else {
			if(yych <= '`')	goto yy1268;
			if(yych <= 'z')	goto yy143;
			goto yy1268;
		}
	}
yy1283:
	YYDEBUG(1283, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy134;
			goto yy1284;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy134;
			if(yych <= '`')	goto yy3;
			goto yy134;
		} else {
			if(yych <= 's')	goto yy1284;
			if(yych <= 'z')	goto yy134;
			goto yy3;
		}
	}
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy132;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy135;
			goto yy1285;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy135;
			if(yych <= '`')	goto yy3;
			goto yy135;
		} else {
			if(yych <= 't')	goto yy1285;
			if(yych <= 'z')	goto yy135;
			goto yy3;
		}
	}
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == ')')	goto yy132;
		goto yy3;
	} else {
		if(yych <= 'E')	goto yy1286;
		if(yych != 'e')	goto yy3;
		goto yy1286;
	}
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1287;
	if(yych != 'r')	goto yy53;
	goto yy1287;
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1288;
	if(yych != 'd')	goto yy53;
	goto yy1288;
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1289;
	if(yych != 'a')	goto yy53;
	goto yy1289;
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy1290;
	if(yych != 'y')	goto yy53;
	goto yy1290;
yy1290:
	YYDEBUG(1290, *YYCURSOR);
	++YYCURSOR;
	goto yy1291;
yy1291:
	YYDEBUG(1291, *YYCURSOR);

{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1292:
	YYDEBUG(1292, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy134;
			goto yy1284;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy134;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 's')	goto yy1293;
			if(yych <= 'z')	goto yy137;
			goto yy3;
		}
	}
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy135;
			goto yy1285;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy135;
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 't')	goto yy1294;
			if(yych <= 'z')	goto yy142;
			goto yy3;
		}
	}
yy1294:
	YYDEBUG(1294, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy132;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy138;
			if(yych <= 'D')	goto yy3;
			goto yy1286;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy138;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy1295;
			if(yych <= 'z')	goto yy143;
			goto yy3;
		}
	}
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1287;
	if(yych != 'r')	goto yy144;
	goto yy1296;
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy1288;
	if(yych != 'd')	goto yy144;
	goto yy1297;
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1289;
	if(yych != 'a')	goto yy144;
	goto yy1298;
yy1298:
	YYDEBUG(1298, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy1290;
	if(yych != 'y')	goto yy144;
	goto yy1299;
yy1299:
	YYDEBUG(1299, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy138;
		goto yy1291;
	} else {
		if(yych <= '_')	goto yy138;
		if(yych <= '`')	goto yy1291;
		if(yych <= 'z')	goto yy143;
		goto yy1291;
	}
}
}

}

#define YYMAXFILL 26


timelib_time* timelib_strtotime(char *s, int len, int *errors, timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	while (isspace(*s) && s < e) {
		s++;
	}
	while (isspace(*e) && e > s) {
		e--;
	}
	if (e - s < 1) {
		*errors = 1;
		in.time = timelib_time_ctor();
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->z = in.time->dst = -1;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	memset(&in, 0, sizeof(in));
	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = -1;
	in.time->d = -1;
	in.time->m = -1;
	in.time->h = -1;
	in.time->i = -1;
	in.time->s = -1;
	in.time->f = -1;
	in.time->z = -1;
	in.time->dst = -1;
	in.errors = 0;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	*errors = in.errors;
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == -1) parsed->y = now->y != -1 ? now->y : 0;
	if (parsed->d == -1) parsed->d = now->d != -1 ? now->d : 0;
	if (parsed->m == -1) parsed->m = now->m != -1 ? now->m : 0;
	if (parsed->h == -1) parsed->h = now->h != -1 ? now->h : 0;
	if (parsed->i == -1) parsed->i = now->i != -1 ? now->i : 0;
	if (parsed->s == -1) parsed->s = now->s != -1 ? now->s : 0;
	if (parsed->f == -1) parsed->f = now->f != -1 ? now->f : 0;
	if (parsed->z == -1) parsed->z = now->z != -1 ? now->z : 0;
	if (parsed->dst == -1) parsed->dst = now->dst != -1 ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
