# -*- coding: utf-8 -*-
#
# Copyright (C) 2009 Richard A. Johnson <nixternal@ubuntu.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from PyQt4.QtCore import Qt, QObject, SIGNAL, QSizeF
from PyQt4.QtGui import QGraphicsLinearLayout
from PyKDE4.kdecore import KUrl, i18n
from PyKDE4.plasma import Plasma
from PyKDE4 import plasmascript

import commands

class KubuntuFeedback(plasmascript.Applet):
    def __init__(self, parent, args=None):
	plasmascript.Applet.__init__(self, parent)

    def init(self):
	self.setHasConfigurationInterface(False)

	self.theme = Plasma.Svg(self)
	self.theme.setImagePath("widgets/background")
	self.setBackgroundHints(Plasma.Applet.DefaultBackground)
	self.setAspectRatioMode(Plasma.IgnoreAspectRatio)

	# Lets find out what version we are running
	# if self.ver == Ubuntu x.xx then it is stable
	# if self.ver == Ubuntu foobar (development *) then it is dev release
	self.ver = commands.getoutput('/usr/bin/lsb_release -d').split(' ')[1]
	# FIXME: Change this once ready
	self.url = 'http://static.nixternal.com/feedback.php?ver=' + self.ver

	self.webView = Plasma.WebView(self.applet)
	self.webView.setUrl(KUrl(self.url))

	self.busy = Plasma.BusyWidget(self.applet)
	self.busy.setLabel(i18n("Loading..."))

	self.layout = QGraphicsLinearLayout(Qt.Vertical, self.applet)
	self.layout.addItem(self.busy)
	self.setLayout(self.layout)

	QObject.connect(self.webView, SIGNAL("loadFinished(bool)"),
		self.PageLoaded)

    def PageLoaded(self):
	self.busy.hide()
	self.layout.removeItem(self.busy)
	self.layout.addItem(self.webView)
	self.setLayout(self.layout)

def CreateApplet(parent):
    return KubuntuFeedback(parent)
