/*
 * include/asm-ppc64/lv1callarg.h
 *
 * Lv-1 call definitions
 *
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#define LV1_1_IN_ARG_DECL	unsigned long in_1
#define LV1_2_IN_ARG_DECL	LV1_1_IN_ARG_DECL, unsigned long in_2
#define LV1_3_IN_ARG_DECL	LV1_2_IN_ARG_DECL, unsigned long in_3
#define LV1_4_IN_ARG_DECL	LV1_3_IN_ARG_DECL, unsigned long in_4
#define LV1_5_IN_ARG_DECL	LV1_4_IN_ARG_DECL, unsigned long in_5
#define LV1_6_IN_ARG_DECL	LV1_5_IN_ARG_DECL, unsigned long in_6
#define LV1_7_IN_ARG_DECL	LV1_6_IN_ARG_DECL, unsigned long in_7
#define LV1_8_IN_ARG_DECL	LV1_7_IN_ARG_DECL, unsigned long in_8
#define LV1_1_OUT_ARG_DECL	unsigned long *out_1
#define LV1_2_OUT_ARG_DECL	LV1_1_OUT_ARG_DECL, unsigned long *out_2
#define LV1_3_OUT_ARG_DECL	LV1_2_OUT_ARG_DECL, unsigned long *out_3
#define LV1_4_OUT_ARG_DECL	LV1_3_OUT_ARG_DECL, unsigned long *out_4
#define LV1_5_OUT_ARG_DECL	LV1_4_OUT_ARG_DECL, unsigned long *out_5
#define LV1_6_OUT_ARG_DECL	LV1_5_OUT_ARG_DECL, unsigned long *out_6
#define LV1_7_OUT_ARG_DECL	LV1_6_OUT_ARG_DECL, unsigned long *out_7

#define LV1_0_IN_0_OUT_ARG_DECL	void
#define LV1_1_IN_0_OUT_ARG_DECL	LV1_1_IN_ARG_DECL
#define LV1_2_IN_0_OUT_ARG_DECL	LV1_2_IN_ARG_DECL
#define LV1_3_IN_0_OUT_ARG_DECL	LV1_3_IN_ARG_DECL
#define LV1_4_IN_0_OUT_ARG_DECL	LV1_4_IN_ARG_DECL
#define LV1_5_IN_0_OUT_ARG_DECL	LV1_5_IN_ARG_DECL
#define LV1_6_IN_0_OUT_ARG_DECL	LV1_6_IN_ARG_DECL
#define LV1_7_IN_0_OUT_ARG_DECL	LV1_7_IN_ARG_DECL

#define LV1_0_IN_1_OUT_ARG_DECL	                   LV1_1_OUT_ARG_DECL
#define LV1_1_IN_1_OUT_ARG_DECL	LV1_1_IN_ARG_DECL, LV1_1_OUT_ARG_DECL
#define LV1_2_IN_1_OUT_ARG_DECL	LV1_2_IN_ARG_DECL, LV1_1_OUT_ARG_DECL
#define LV1_3_IN_1_OUT_ARG_DECL	LV1_3_IN_ARG_DECL, LV1_1_OUT_ARG_DECL
#define LV1_4_IN_1_OUT_ARG_DECL	LV1_4_IN_ARG_DECL, LV1_1_OUT_ARG_DECL
#define LV1_5_IN_1_OUT_ARG_DECL	LV1_5_IN_ARG_DECL, LV1_1_OUT_ARG_DECL
#define LV1_6_IN_1_OUT_ARG_DECL	LV1_6_IN_ARG_DECL, LV1_1_OUT_ARG_DECL
#define LV1_7_IN_1_OUT_ARG_DECL	LV1_7_IN_ARG_DECL, LV1_1_OUT_ARG_DECL
#define LV1_8_IN_1_OUT_ARG_DECL	LV1_8_IN_ARG_DECL, LV1_1_OUT_ARG_DECL

#define LV1_0_IN_2_OUT_ARG_DECL	                   LV1_2_OUT_ARG_DECL
#define LV1_1_IN_2_OUT_ARG_DECL	LV1_1_IN_ARG_DECL, LV1_2_OUT_ARG_DECL
#define LV1_2_IN_2_OUT_ARG_DECL	LV1_2_IN_ARG_DECL, LV1_2_OUT_ARG_DECL
#define LV1_3_IN_2_OUT_ARG_DECL	LV1_3_IN_ARG_DECL, LV1_2_OUT_ARG_DECL
#define LV1_4_IN_2_OUT_ARG_DECL	LV1_4_IN_ARG_DECL, LV1_2_OUT_ARG_DECL
#define LV1_5_IN_2_OUT_ARG_DECL	LV1_5_IN_ARG_DECL, LV1_2_OUT_ARG_DECL
#define LV1_6_IN_2_OUT_ARG_DECL	LV1_6_IN_ARG_DECL, LV1_2_OUT_ARG_DECL
#define LV1_7_IN_2_OUT_ARG_DECL	LV1_7_IN_ARG_DECL, LV1_2_OUT_ARG_DECL

#define LV1_0_IN_3_OUT_ARG_DECL	                   LV1_3_OUT_ARG_DECL
#define LV1_1_IN_3_OUT_ARG_DECL	LV1_1_IN_ARG_DECL, LV1_3_OUT_ARG_DECL
#define LV1_2_IN_3_OUT_ARG_DECL	LV1_2_IN_ARG_DECL, LV1_3_OUT_ARG_DECL
#define LV1_3_IN_3_OUT_ARG_DECL	LV1_3_IN_ARG_DECL, LV1_3_OUT_ARG_DECL
#define LV1_4_IN_3_OUT_ARG_DECL	LV1_4_IN_ARG_DECL, LV1_3_OUT_ARG_DECL
#define LV1_5_IN_3_OUT_ARG_DECL	LV1_5_IN_ARG_DECL, LV1_3_OUT_ARG_DECL
#define LV1_6_IN_3_OUT_ARG_DECL	LV1_6_IN_ARG_DECL, LV1_3_OUT_ARG_DECL
#define LV1_7_IN_3_OUT_ARG_DECL	LV1_7_IN_ARG_DECL, LV1_3_OUT_ARG_DECL

#define LV1_0_IN_4_OUT_ARG_DECL	                   LV1_4_OUT_ARG_DECL
#define LV1_1_IN_4_OUT_ARG_DECL	LV1_1_IN_ARG_DECL, LV1_4_OUT_ARG_DECL
#define LV1_2_IN_4_OUT_ARG_DECL	LV1_2_IN_ARG_DECL, LV1_4_OUT_ARG_DECL
#define LV1_3_IN_4_OUT_ARG_DECL	LV1_3_IN_ARG_DECL, LV1_4_OUT_ARG_DECL
#define LV1_4_IN_4_OUT_ARG_DECL	LV1_4_IN_ARG_DECL, LV1_4_OUT_ARG_DECL
#define LV1_5_IN_4_OUT_ARG_DECL	LV1_5_IN_ARG_DECL, LV1_4_OUT_ARG_DECL
#define LV1_6_IN_4_OUT_ARG_DECL	LV1_6_IN_ARG_DECL, LV1_4_OUT_ARG_DECL
#define LV1_7_IN_4_OUT_ARG_DECL	LV1_7_IN_ARG_DECL, LV1_4_OUT_ARG_DECL

#define LV1_0_IN_5_OUT_ARG_DECL	                   LV1_5_OUT_ARG_DECL
#define LV1_1_IN_5_OUT_ARG_DECL	LV1_1_IN_ARG_DECL, LV1_5_OUT_ARG_DECL
#define LV1_2_IN_5_OUT_ARG_DECL	LV1_2_IN_ARG_DECL, LV1_5_OUT_ARG_DECL
#define LV1_3_IN_5_OUT_ARG_DECL	LV1_3_IN_ARG_DECL, LV1_5_OUT_ARG_DECL
#define LV1_4_IN_5_OUT_ARG_DECL	LV1_4_IN_ARG_DECL, LV1_5_OUT_ARG_DECL
#define LV1_5_IN_5_OUT_ARG_DECL	LV1_5_IN_ARG_DECL, LV1_5_OUT_ARG_DECL
#define LV1_6_IN_5_OUT_ARG_DECL	LV1_6_IN_ARG_DECL, LV1_5_OUT_ARG_DECL
#define LV1_7_IN_5_OUT_ARG_DECL	LV1_7_IN_ARG_DECL, LV1_5_OUT_ARG_DECL

#define LV1_0_IN_6_OUT_ARG_DECL	                   LV1_6_OUT_ARG_DECL
#define LV1_1_IN_6_OUT_ARG_DECL	LV1_1_IN_ARG_DECL, LV1_6_OUT_ARG_DECL
#define LV1_2_IN_6_OUT_ARG_DECL	LV1_2_IN_ARG_DECL, LV1_6_OUT_ARG_DECL
#define LV1_3_IN_6_OUT_ARG_DECL	LV1_3_IN_ARG_DECL, LV1_6_OUT_ARG_DECL
#define LV1_4_IN_6_OUT_ARG_DECL	LV1_4_IN_ARG_DECL, LV1_6_OUT_ARG_DECL
#define LV1_5_IN_6_OUT_ARG_DECL	LV1_5_IN_ARG_DECL, LV1_6_OUT_ARG_DECL
#define LV1_6_IN_6_OUT_ARG_DECL	LV1_6_IN_ARG_DECL, LV1_6_OUT_ARG_DECL
#define LV1_7_IN_6_OUT_ARG_DECL	LV1_7_IN_ARG_DECL, LV1_6_OUT_ARG_DECL

#define LV1_0_IN_7_OUT_ARG_DECL	                   LV1_7_OUT_ARG_DECL
#define LV1_1_IN_7_OUT_ARG_DECL	LV1_1_IN_ARG_DECL, LV1_7_OUT_ARG_DECL
#define LV1_2_IN_7_OUT_ARG_DECL	LV1_2_IN_ARG_DECL, LV1_7_OUT_ARG_DECL
#define LV1_3_IN_7_OUT_ARG_DECL	LV1_3_IN_ARG_DECL, LV1_7_OUT_ARG_DECL
#define LV1_4_IN_7_OUT_ARG_DECL	LV1_4_IN_ARG_DECL, LV1_7_OUT_ARG_DECL
#define LV1_5_IN_7_OUT_ARG_DECL	LV1_5_IN_ARG_DECL, LV1_7_OUT_ARG_DECL
#define LV1_6_IN_7_OUT_ARG_DECL	LV1_6_IN_ARG_DECL, LV1_7_OUT_ARG_DECL
#define LV1_7_IN_7_OUT_ARG_DECL	LV1_7_IN_ARG_DECL, LV1_7_OUT_ARG_DECL

#define LV1_1_IN_ARGS	in_1
#define LV1_2_IN_ARGS	LV1_1_IN_ARGS, in_2
#define LV1_3_IN_ARGS	LV1_2_IN_ARGS, in_3
#define LV1_4_IN_ARGS	LV1_3_IN_ARGS, in_4
#define LV1_5_IN_ARGS	LV1_4_IN_ARGS, in_5
#define LV1_6_IN_ARGS	LV1_5_IN_ARGS, in_6
#define LV1_7_IN_ARGS	LV1_6_IN_ARGS, in_7
#define LV1_8_IN_ARGS	LV1_7_IN_ARGS, in_8

#define LV1_1_OUT_ARGS	out_1
#define LV1_2_OUT_ARGS	LV1_1_OUT_ARGS, out_2
#define LV1_3_OUT_ARGS	LV1_2_OUT_ARGS, out_3
#define LV1_4_OUT_ARGS	LV1_3_OUT_ARGS, out_4
#define LV1_5_OUT_ARGS	LV1_4_OUT_ARGS, out_5
#define LV1_6_OUT_ARGS	LV1_5_OUT_ARGS, out_6
#define LV1_7_OUT_ARGS	LV1_6_OUT_ARGS, out_7

#define LV1_0_IN_0_OUT_ARGS
#define LV1_1_IN_0_OUT_ARGS	LV1_1_IN_ARGS
#define LV1_2_IN_0_OUT_ARGS	LV1_2_IN_ARGS
#define LV1_3_IN_0_OUT_ARGS	LV1_3_IN_ARGS
#define LV1_4_IN_0_OUT_ARGS	LV1_4_IN_ARGS
#define LV1_5_IN_0_OUT_ARGS	LV1_5_IN_ARGS
#define LV1_6_IN_0_OUT_ARGS	LV1_6_IN_ARGS
#define LV1_7_IN_0_OUT_ARGS	LV1_7_IN_ARGS

#define LV1_0_IN_1_OUT_ARGS	               LV1_1_OUT_ARGS
#define LV1_1_IN_1_OUT_ARGS	LV1_1_IN_ARGS, LV1_1_OUT_ARGS
#define LV1_2_IN_1_OUT_ARGS	LV1_2_IN_ARGS, LV1_1_OUT_ARGS
#define LV1_3_IN_1_OUT_ARGS	LV1_3_IN_ARGS, LV1_1_OUT_ARGS
#define LV1_4_IN_1_OUT_ARGS	LV1_4_IN_ARGS, LV1_1_OUT_ARGS
#define LV1_5_IN_1_OUT_ARGS	LV1_5_IN_ARGS, LV1_1_OUT_ARGS
#define LV1_6_IN_1_OUT_ARGS	LV1_6_IN_ARGS, LV1_1_OUT_ARGS
#define LV1_7_IN_1_OUT_ARGS	LV1_7_IN_ARGS, LV1_1_OUT_ARGS
#define LV1_8_IN_1_OUT_ARGS	LV1_8_IN_ARGS, LV1_1_OUT_ARGS

#define LV1_0_IN_2_OUT_ARGS	               LV1_2_OUT_ARGS
#define LV1_1_IN_2_OUT_ARGS	LV1_1_IN_ARGS, LV1_2_OUT_ARGS
#define LV1_2_IN_2_OUT_ARGS	LV1_2_IN_ARGS, LV1_2_OUT_ARGS
#define LV1_3_IN_2_OUT_ARGS	LV1_3_IN_ARGS, LV1_2_OUT_ARGS
#define LV1_4_IN_2_OUT_ARGS	LV1_4_IN_ARGS, LV1_2_OUT_ARGS
#define LV1_5_IN_2_OUT_ARGS	LV1_5_IN_ARGS, LV1_2_OUT_ARGS
#define LV1_6_IN_2_OUT_ARGS	LV1_6_IN_ARGS, LV1_2_OUT_ARGS
#define LV1_7_IN_2_OUT_ARGS	LV1_7_IN_ARGS, LV1_2_OUT_ARGS

#define LV1_0_IN_3_OUT_ARGS	               LV1_3_OUT_ARGS
#define LV1_1_IN_3_OUT_ARGS	LV1_1_IN_ARGS, LV1_3_OUT_ARGS
#define LV1_2_IN_3_OUT_ARGS	LV1_2_IN_ARGS, LV1_3_OUT_ARGS
#define LV1_3_IN_3_OUT_ARGS	LV1_3_IN_ARGS, LV1_3_OUT_ARGS
#define LV1_4_IN_3_OUT_ARGS	LV1_4_IN_ARGS, LV1_3_OUT_ARGS
#define LV1_5_IN_3_OUT_ARGS	LV1_5_IN_ARGS, LV1_3_OUT_ARGS
#define LV1_6_IN_3_OUT_ARGS	LV1_6_IN_ARGS, LV1_3_OUT_ARGS
#define LV1_7_IN_3_OUT_ARGS	LV1_7_IN_ARGS, LV1_3_OUT_ARGS

#define LV1_0_IN_4_OUT_ARGS	               LV1_4_OUT_ARGS
#define LV1_1_IN_4_OUT_ARGS	LV1_1_IN_ARGS, LV1_4_OUT_ARGS
#define LV1_2_IN_4_OUT_ARGS	LV1_2_IN_ARGS, LV1_4_OUT_ARGS
#define LV1_3_IN_4_OUT_ARGS	LV1_3_IN_ARGS, LV1_4_OUT_ARGS
#define LV1_4_IN_4_OUT_ARGS	LV1_4_IN_ARGS, LV1_4_OUT_ARGS
#define LV1_5_IN_4_OUT_ARGS	LV1_5_IN_ARGS, LV1_4_OUT_ARGS
#define LV1_6_IN_4_OUT_ARGS	LV1_6_IN_ARGS, LV1_4_OUT_ARGS
#define LV1_7_IN_4_OUT_ARGS	LV1_7_IN_ARGS, LV1_4_OUT_ARGS

#define LV1_0_IN_5_OUT_ARGS	               LV1_5_OUT_ARGS
#define LV1_1_IN_5_OUT_ARGS	LV1_1_IN_ARGS, LV1_5_OUT_ARGS
#define LV1_2_IN_5_OUT_ARGS	LV1_2_IN_ARGS, LV1_5_OUT_ARGS
#define LV1_3_IN_5_OUT_ARGS	LV1_3_IN_ARGS, LV1_5_OUT_ARGS
#define LV1_4_IN_5_OUT_ARGS	LV1_4_IN_ARGS, LV1_5_OUT_ARGS
#define LV1_5_IN_5_OUT_ARGS	LV1_5_IN_ARGS, LV1_5_OUT_ARGS
#define LV1_6_IN_5_OUT_ARGS	LV1_6_IN_ARGS, LV1_5_OUT_ARGS
#define LV1_7_IN_5_OUT_ARGS	LV1_7_IN_ARGS, LV1_5_OUT_ARGS

#define LV1_0_IN_6_OUT_ARGS                    LV1_6_OUT_ARGS
#define LV1_1_IN_6_OUT_ARGS	LV1_1_IN_ARGS, LV1_6_OUT_ARGS
#define LV1_2_IN_6_OUT_ARGS	LV1_2_IN_ARGS, LV1_6_OUT_ARGS
#define LV1_3_IN_6_OUT_ARGS	LV1_3_IN_ARGS, LV1_6_OUT_ARGS
#define LV1_4_IN_6_OUT_ARGS	LV1_4_IN_ARGS, LV1_6_OUT_ARGS
#define LV1_5_IN_6_OUT_ARGS	LV1_5_IN_ARGS, LV1_6_OUT_ARGS
#define LV1_6_IN_6_OUT_ARGS	LV1_6_IN_ARGS, LV1_6_OUT_ARGS
#define LV1_7_IN_6_OUT_ARGS	LV1_7_IN_ARGS, LV1_6_OUT_ARGS

#define LV1_0_IN_7_OUT_ARGS	               LV1_7_OUT_ARGS
#define LV1_1_IN_7_OUT_ARGS	LV1_1_IN_ARGS, LV1_7_OUT_ARGS
#define LV1_2_IN_7_OUT_ARGS	LV1_2_IN_ARGS, LV1_7_OUT_ARGS
#define LV1_3_IN_7_OUT_ARGS	LV1_3_IN_ARGS, LV1_7_OUT_ARGS
#define LV1_4_IN_7_OUT_ARGS	LV1_4_IN_ARGS, LV1_7_OUT_ARGS
#define LV1_5_IN_7_OUT_ARGS	LV1_5_IN_ARGS, LV1_7_OUT_ARGS
#define LV1_6_IN_7_OUT_ARGS	LV1_6_IN_ARGS, LV1_7_OUT_ARGS
#define LV1_7_IN_7_OUT_ARGS	LV1_7_IN_ARGS, LV1_7_OUT_ARGS
