#!/usr/bin/python

import sqlite

def import_table(file_name, table_name, num_fields):

    f_in = open(file_name, 'r')

    if f_in == None:
        return

    rowcount = 0

    while 1:

        # Read the next line
        line = f_in.readline()

        # Check for empty lines
        if len(line) == 0:
            break

        # Remove trailing whitespace, incl. line feed
        line = line.strip()

        # Split the record using | as delimiter
        fields = line.split("|")

        params = ",".join(["%s"] * num_fields)

        SQL = "insert into %s values %s" % (table_name, params)

        cursor.execute(SQL, tuple(fields[:-1]))
        print cursor.sql(), "--", rowcount

        #if rowcount == 2:
        #    break

        rowcount += 1

    f_in.close()
    conn.commit()

conn = sqlite.connect(db="db", mode=077)
cursor = conn.cursor()

#import_table('kingd00104.unl', 'kingdoms',          3)
#import_table('taxon00105.unl', 'taxon_unit_types',  6)
#import_table('geogr00106.unl', 'geographic_div',    3)
#import_table('juris00107.unl', 'jurisdiction',      4)
#import_table('nodc_00108.unl', 'nodc_ids',          3)
#import_table('taxon00109.unl', 'taxon_authors_lkp', 4)
#import_table('verna00110.unl', 'vernaculars',       5)
#import_table('synon00111.unl', 'synonym_links',     3)
#import_table('refer00112.unl', 'reference_links',   8)
#import_table('exper00113.unl', 'experts',           5)
#import_table('other00114.unl', 'other_sources',     8)
#import_table('publi00115.unl', 'publications',     14)
#import_table('tu_co00117.unl', 'tu_comments_links', 3)
#import_table('sub_t00118.unl', 'sub_tracking_hist', 8)
#import_table('sub_t00119.unl', 'sub_tracking',      8)
#import_table('taxon00120.unl', 'taxonomic_units ', 23)
#import_table('comme00121.unl',  'comments',          5)

conn.close()
