/****************************************************************************
**
** Copyright (C) 2012 Nokia Corporation and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/
**
** This file is part of the documentation of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

//! [0]
beginInsertRows(parent, 2, 4);
//! [0]


//! [1]
beginInsertRows(parent, 4, 5);
//! [1]


//! [2]
beginRemoveRows(parent, 2, 3);
//! [2]


//! [3]
beginInsertColumns(parent, 4, 6);
//! [3]


//! [4]
beginInsertColumns(parent, 6, 8);
//! [4]


//! [5]
beginRemoveColumns(parent, 4, 6);
//! [5]


//! [6]
beginMoveRows(sourceParent, 2, 4, destinationParent, 2);
//! [6]


//! [7]
beginMoveRows(sourceParent, 2, 4, destinationParent, 6);
//! [7]


//! [8]
beginMoveRows(parent, 2, 2, parent, 0);
//! [8]


//! [9]
beginMoveRows(parent, 2, 2, parent, 4);
//! [9]


//! [10]
class CustomDataProxy : public QSortFilterProxyModel
{
    Q_OBJECT
public:
    CustomDataProxy(QObject *parent)
      : QSortFilterProxyModel(parent)
    {
    }

    ...

    QVariant data(const QModelIndex &index, int role)
    {
        if (role != Qt::BackgroundRole)
            return QSortFilterProxyModel::data(index, role);

        if (m_customData.contains(index.row()))
            return m_customData.value(index.row());
        return QSortFilterProxyModel::data(index, role);
    }

private slots:
    void resetInternalData()
    {
        m_customData.clear();
    }

private:
  QHash<int, QVariant> m_customData;
};
//! [10]

