/****************************************************************************
**
** Copyright (C) 2012 Nokia Corporation and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/
**
** This file is part of the QtXmlPatterns module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser General Public
** License version 2.1 as published by the Free Software Foundation and
** appearing in the file LICENSE.LGPL included in the packaging of this
** file. Please review the following information to ensure the GNU Lesser
** General Public License version 2.1 requirements will be met:
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU General
** Public License version 3.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of this
** file. Please review the following information to ensure the GNU General
** Public License version 3.0 requirements will be met:
** http://www.gnu.org/copyleft/gpl.html.
**
** Other Usage
** Alternatively, this file may be used in accordance with the terms and
** conditions contained in a signed written agreement between you and Nokia.
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.

#ifndef Patternist_ValidationError_H
#define Patternist_ValidationError_H

#include "qitem_p.h"
#include "qreportcontext_p.h"

QT_BEGIN_HEADER

QT_BEGIN_NAMESPACE

namespace QPatternist
{
    /**
     * @short Used for signalling casting errors.
     *
     * @author Frans Englich <frans.englich@nokia.com>
     * @ingroup Patternist_xdm
     */
    class ValidationError : public AtomicValue
    {
    public:
        typedef QExplicitlySharedDataPointer<ValidationError> Ptr;

        /**
         * Creates a ValidationError instance that represents a type error.
         *
         * @param description A detailed description of what that made the cast fail,
         * if any. If @c null, which QString() creates, a generic message
         * will be used.
         */
        static AtomicValue::Ptr createError(const QString &description = QString(),
                                            const ReportContext::ErrorCode = ReportContext::FORG0001);

        /**
         * A human readable, translated message describing the error.
         */
        QString message() const;

        /**
         * @returns always @c true
         */
        virtual bool hasError() const;

        /**
         * Always results in an assert crash.
         */
        virtual ItemType::Ptr type() const;

        /**
         * Always results in an assert crash.
         */
        virtual QString stringValue() const;

        /**
         * @returns the error code this ValidationError represents. Typically, this
         * is ReportContext::FORG0001.
         */
        ReportContext::ErrorCode errorCode() const;

    protected:
        ValidationError(const QString &msg, const ReportContext::ErrorCode code);

        const QString                   m_message;
        const ReportContext::ErrorCode  m_code;
    };
}

QT_END_NAMESPACE

QT_END_HEADER

#endif
