root_dir=$(pwd)

for f in $(find -name '*.re'); do
    echo $f
    cd $(dirname $f)

    cfile="$(basename ${f%.re}.c)"
    ctest="example.c"

    cat "$cfile" \
        | egrep -v 'warning: rule .*matches empty string \[-Wmatch-empty-string\]' \
        | egrep -v 'warning: tag .* degree of nondeterminism \[-Wnondeterministic-tags\]' \
        > "$ctest"

    # If the autogenerated message appears more than once in the file, then
    # it must have autogenerated header appended at the end. Cut it off.
    msg='Generated by re2c'
    if [ $(grep -c "$msg" "$ctest") -gt 1 ]; then
        # Get the line of the second message occurrence.
        l=$(grep -n "$msg" "$ctest" | tail -n +2 | cut -d : -f 1)
        # Cut off everything past that line.
        head -n $l "$ctest" > "$ctest".mod && mv "$ctest".mod "$ctest"
    fi

    g++ "$ctest" -Wall -oexample && ./example 2>/dev/null || { echo "*** error ***"; exit 1; }

    rm -f "$ctest" example
    cd $root_dir
done

echo "All good."
