#!/bin/sh
#

VERSION_FILE=$1
OUTPUT_FILE=$2

if test -z "$VERSION_FILE";then
	VERSION_FILE="VERSION"
fi

if test -z "$OUTPUT_FILE";then
	OUTPUT_FILE="include/version.h"
fi

SOURCE_DIR=$3

SAMBA_VERSION_MAJOR=`sed -n 's/^SAMBA_VERSION_MAJOR=//p' $SOURCE_DIR$VERSION_FILE`
SAMBA_VERSION_MINOR=`sed -n 's/^SAMBA_VERSION_MINOR=//p' $SOURCE_DIR$VERSION_FILE`
SAMBA_VERSION_RELEASE=`sed -n 's/^SAMBA_VERSION_RELEASE=//p' $SOURCE_DIR$VERSION_FILE`

SAMBA_VERSION_PRE_RELEASE=`sed -n 's/^SAMBA_VERSION_PRE_RELEASE=//p' $SOURCE_DIR$VERSION_FILE`

SAMBA_VERSION_RC_RELEASE=`sed -n 's/^SAMBA_VERSION_RC_RELEASE=//p' $SOURCE_DIR$VERSION_FILE`

SAMBA_VERSION_IS_SVN_SNAPSHOT=`sed -n 's/^SAMBA_VERSION_IS_SVN_SNAPSHOT=//p' $SOURCE_DIR$VERSION_FILE`

SAMBA_VERSION_VENDOR_SUFFIX=`sed -n 's/^SAMBA_VERSION_VENDOR_SUFFIX=//p' $SOURCE_DIR$VERSION_FILE`

echo "/* Autogenerated by script/mkversion.sh */" > $OUTPUT_FILE

echo "#define SAMBA_VERSION_MAJOR ${SAMBA_VERSION_MAJOR}" >> $OUTPUT_FILE
echo "#define SAMBA_VERSION_MINOR ${SAMBA_VERSION_MINOR}" >> $OUTPUT_FILE
echo "#define SAMBA_VERSION_RELEASE ${SAMBA_VERSION_RELEASE}" >> $OUTPUT_FILE


SAMBA_VERSION_STRING="${SAMBA_VERSION_MAJOR}.${SAMBA_VERSION_MINOR}.${SAMBA_VERSION_RELEASE}"


if test -n "${SAMBA_VERSION_PRE_RELEASE}";then
    SAMBA_VERSION_STRING="${SAMBA_VERSION_STRING}pre${SAMBA_VERSION_PRE_RELEASE}"
    echo "#define SAMBA_VERSION_PRE_RELEASE ${SAMBA_VERSION_PRE_RELEASE}" >> $OUTPUT_FILE
elif test -n "${SAMBA_VERSION_RC_RELEASE}";then
    SAMBA_VERSION_STRING="${SAMBA_VERSION_STRING}rc${SAMBA_VERSION_RC_RELEASE}"
    echo "#define SAMBA_VERSION_RC_RELEASE ${SAMBA_VERSION_RC_RELEASE}" >> $OUTPUT_FILE
fi


if test x"${SAMBA_VERSION_IS_SVN_SNAPSHOT}" = x"yes";then
    HAVESVN=no
    svn info ${SOURCE_DIR} >/dev/null 2>&1 && HAVESVN=yes
    TMP_REVISION=`(svn info ${SOURCE_DIR} 2>/dev/null || svk info ${SOURCE_DIR} 2>/dev/null) |grep 'Last Changed Rev.*:' |sed -e 's/Last Changed Rev.*: \([0-9]*\).*/\1/'`
    if test x"${HAVESVN}" = x"no";then
	HAVESVK=no
	svk info ${SOURCE_DIR} >/dev/null 2>&1 && HAVESVK=yes
	TMP_SVK_REVISION_STR="${TMP_REVISION}-${USER}@${HOSTNAME}"
    fi

    if test x"${HAVESVN}" = x"yes";then
	    SAMBA_VERSION_STRING="${SAMBA_VERSION_STRING}-SVN-build-${TMP_REVISION}"
	    echo "#define SAMBA_VERSION_SVN_REVISION ${TMP_REVISION}" >> $OUTPUT_FILE
    elif test x"${HAVESVK}" = x"yes";then
	    SAMBA_VERSION_STRING="${SAMBA_VERSION_STRING}-SVK-build-${TMP_SVK_REVISION_STR}"
    else
	    SAMBA_VERSION_STRING="${SAMBA_VERSION_STRING}-SVN-build-UNKNOWN"
    fi
fi

if test -n "${SAMBA_VERSION_VENDOR_SUFFIX}";then
    echo "#define SAMBA_VERSION_VENDOR_SUFFIX ${SAMBA_VERSION_VENDOR_SUFFIX}" >> $OUTPUT_FILE
fi

echo "#define SAMBA_VERSION_OFFICIAL_STRING \"${SAMBA_VERSION_STRING}\"" >> $OUTPUT_FILE

echo "#define SAMBA_VERSION_STRING samba_version_string()" >> $OUTPUT_FILE

echo "$0: 'include/version.h' created for Samba(\"${SAMBA_VERSION_STRING}\")"

if test -n "${SAMBA_VERSION_VENDOR_SUFFIX}";then
    echo "$0: with VENDOR_SUFFIX = ${SAMBA_VERSION_VENDOR_SUFFIX}"
fi

exit 0
