/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_efs
#define _PIDL_HEADER_efs

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/security.h"
#ifndef _HEADER_efs
#define _HEADER_efs

struct EFS_HASH_BLOB {
	uint32_t cbData;
	uint8_t *pbData;/* [unique,size_is(cbData)] */
};

struct ENCRYPTION_CERTIFICATE_HASH {
	uint32_t cbTotalLength;
	struct dom_sid *pUserSid;/* [unique] */
	struct EFS_HASH_BLOB *pHash;/* [unique] */
	const char *lpDisplayInformation;/* [unique,charset(UTF16)] */
};

struct ENCRYPTION_CERTIFICATE_HASH_LIST {
	uint32_t nCert_Hash;
	struct ENCRYPTION_CERTIFICATE_HASH **pUsers;/* [unique,size_is(nCert_Hash)] */
};

struct EFS_CERTIFICATE_BLOB {
	uint32_t dwCertEncodingType;
	uint32_t cbData;
	uint8_t *pbData;/* [unique,size_is(cbData)] */
};

struct ENCRYPTION_CERTIFICATE {
	uint32_t TotalLength;
	struct dom_sid *pUserSid;/* [unique] */
	struct EFS_CERTIFICATE_BLOB *pCertBlob;/* [unique] */
};


struct EfsRpcOpenFileRaw {
	struct {
		const char *FileName;/* [charset(UTF16)] */
		uint32_t Flags;
	} in;

	struct {
		struct policy_handle *pvContext;/* [ref] */
		WERROR result;
	} out;

};


struct EfsRpcReadFileRaw {
	struct {
		struct policy_handle *pvContext;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct EfsRpcWriteFileRaw {
	struct {
		struct policy_handle *pvContext;/* [ref] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct EfsRpcCloseRaw {
	struct {
		struct policy_handle *pvContext;/* [ref] */
	} in;

	struct {
		struct policy_handle *pvContext;/* [ref] */
	} out;

};


struct EfsRpcEncryptFileSrv {
	struct {
		const char *Filename;/* [charset(UTF16)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct EfsRpcDecryptFileSrv {
	struct {
		const char *FileName;/* [charset(UTF16)] */
		uint32_t Reserved;
	} in;

	struct {
		WERROR result;
	} out;

};


struct EfsRpcQueryUsersOnFile {
	struct {
		const char *FileName;/* [charset(UTF16)] */
	} in;

	struct {
		struct ENCRYPTION_CERTIFICATE_HASH_LIST **pUsers;/* [unique,ref] */
		WERROR result;
	} out;

};


struct EfsRpcQueryRecoveryAgents {
	struct {
		const char *FileName;/* [charset(UTF16)] */
	} in;

	struct {
		struct ENCRYPTION_CERTIFICATE_HASH_LIST **pRecoveryAgents;/* [unique,ref] */
		WERROR result;
	} out;

};


struct EfsRpcRemoveUsersFromFile {
	struct {
		const char *FileName;/* [charset(UTF16)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct EfsRpcAddUsersToFile {
	struct {
		const char *FileName;/* [charset(UTF16)] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct EfsRpcSetFileEncryptionKey {
	struct {
		struct ENCRYPTION_CERTIFICATE *pEncryptionCertificate;/* [unique] */
	} in;

	struct {
		WERROR result;
	} out;

};


struct EfsRpcNotSupported {
	struct {
		WERROR result;
	} out;

};


struct EfsRpcFileKeyInfo {
	struct {
		WERROR result;
	} out;

};


struct EfsRpcDuplicateEncryptionInfoFile {
	struct {
		WERROR result;
	} out;

};

#endif /* _HEADER_efs */
#endif /* _PIDL_HEADER_efs */
