
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "librpc/gen_ndr/ndr_eventlog6.h"
#include "librpc/gen_ndr/ndr_eventlog6_c.h"

#include "librpc/gen_ndr/misc.h"
staticforward PyTypeObject eventlog6_RpcInfo_Type;
staticforward PyTypeObject eventlog6_boolean8Array_Type;
staticforward PyTypeObject eventlog6_UInt32Array_Type;
staticforward PyTypeObject eventlog6_UInt64Array_Type;
staticforward PyTypeObject eventlog6_StringArray_Type;
staticforward PyTypeObject eventlog6_GuidArray_Type;
staticforward PyTypeObject eventlog6_EvtRpcVariant_Type;
staticforward PyTypeObject eventlog6_EvtRpcVariantList_Type;
staticforward PyTypeObject eventlog6_EvtRpcQueryChannelInfo_Type;
staticforward PyTypeObject eventlog6_InterfaceType;

void initeventlog6(void);static PyTypeObject *Object_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *policy_handle_Type;

static PyObject *py_eventlog6_RpcInfo_get_error(PyObject *obj, void *closure)
{
	struct eventlog6_RpcInfo *object = (struct eventlog6_RpcInfo *)py_talloc_get_ptr(obj);
	PyObject *py_error;
	py_error = PyInt_FromLong(object->error);
	return py_error;
}

static int py_eventlog6_RpcInfo_set_error(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_RpcInfo *object = (struct eventlog6_RpcInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->error = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog6_RpcInfo_get_sub_err(PyObject *obj, void *closure)
{
	struct eventlog6_RpcInfo *object = (struct eventlog6_RpcInfo *)py_talloc_get_ptr(obj);
	PyObject *py_sub_err;
	py_sub_err = PyInt_FromLong(object->sub_err);
	return py_sub_err;
}

static int py_eventlog6_RpcInfo_set_sub_err(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_RpcInfo *object = (struct eventlog6_RpcInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sub_err = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog6_RpcInfo_get_sub_err_param(PyObject *obj, void *closure)
{
	struct eventlog6_RpcInfo *object = (struct eventlog6_RpcInfo *)py_talloc_get_ptr(obj);
	PyObject *py_sub_err_param;
	py_sub_err_param = PyInt_FromLong(object->sub_err_param);
	return py_sub_err_param;
}

static int py_eventlog6_RpcInfo_set_sub_err_param(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_RpcInfo *object = (struct eventlog6_RpcInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sub_err_param = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_eventlog6_RpcInfo_getsetters[] = {
	{ discard_const_p(char, "error"), py_eventlog6_RpcInfo_get_error, py_eventlog6_RpcInfo_set_error },
	{ discard_const_p(char, "sub_err"), py_eventlog6_RpcInfo_get_sub_err, py_eventlog6_RpcInfo_set_sub_err },
	{ discard_const_p(char, "sub_err_param"), py_eventlog6_RpcInfo_get_sub_err_param, py_eventlog6_RpcInfo_set_sub_err_param },
	{ NULL }
};

static PyObject *py_eventlog6_RpcInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct eventlog6_RpcInfo, type);
}


static PyTypeObject eventlog6_RpcInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog6.RpcInfo",
	.tp_getset = py_eventlog6_RpcInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_eventlog6_RpcInfo_new,
};


static PyObject *py_eventlog6_boolean8Array_get_count(PyObject *obj, void *closure)
{
	struct eventlog6_boolean8Array *object = (struct eventlog6_boolean8Array *)py_talloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_eventlog6_boolean8Array_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_boolean8Array *object = (struct eventlog6_boolean8Array *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog6_boolean8Array_get_ptr(PyObject *obj, void *closure)
{
	struct eventlog6_boolean8Array *object = (struct eventlog6_boolean8Array *)py_talloc_get_ptr(obj);
	PyObject *py_ptr;
	if (object->ptr == NULL) {
		py_ptr = Py_None;
		Py_INCREF(py_ptr);
	} else {
		py_ptr = PyList_New(object->count);
		if (py_ptr == NULL) {
			return NULL;
		}
		{
			int ptr_cntr_1;
			for (ptr_cntr_1 = 0; ptr_cntr_1 < object->count; ptr_cntr_1++) {
				PyObject *py_ptr_1;
				py_ptr_1 = PyInt_FromLong(object->ptr[ptr_cntr_1]);
				PyList_SetItem(py_ptr, ptr_cntr_1, py_ptr_1);
			}
		}
	}
	return py_ptr;
}

static int py_eventlog6_boolean8Array_set_ptr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_boolean8Array *object = (struct eventlog6_boolean8Array *)py_talloc_get_ptr(py_obj);
	talloc_unlink(py_talloc_get_mem_ctx(py_obj), object->ptr);
	if (value == Py_None) {
		object->ptr = NULL;
	} else {
		object->ptr = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int ptr_cntr_1;
			object->ptr = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->ptr, PyList_GET_SIZE(value));
			if (!object->ptr) { return -1;; }
			talloc_set_name_const(object->ptr, "ARRAY: object->ptr");
			for (ptr_cntr_1 = 0; ptr_cntr_1 < PyList_GET_SIZE(value); ptr_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, ptr_cntr_1), return -1;);
				object->ptr[ptr_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, ptr_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_eventlog6_boolean8Array_getsetters[] = {
	{ discard_const_p(char, "count"), py_eventlog6_boolean8Array_get_count, py_eventlog6_boolean8Array_set_count },
	{ discard_const_p(char, "ptr"), py_eventlog6_boolean8Array_get_ptr, py_eventlog6_boolean8Array_set_ptr },
	{ NULL }
};

static PyObject *py_eventlog6_boolean8Array_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct eventlog6_boolean8Array, type);
}


static PyTypeObject eventlog6_boolean8Array_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog6.boolean8Array",
	.tp_getset = py_eventlog6_boolean8Array_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_eventlog6_boolean8Array_new,
};


static PyObject *py_eventlog6_UInt32Array_get_count(PyObject *obj, void *closure)
{
	struct eventlog6_UInt32Array *object = (struct eventlog6_UInt32Array *)py_talloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_eventlog6_UInt32Array_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_UInt32Array *object = (struct eventlog6_UInt32Array *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog6_UInt32Array_get_ptr(PyObject *obj, void *closure)
{
	struct eventlog6_UInt32Array *object = (struct eventlog6_UInt32Array *)py_talloc_get_ptr(obj);
	PyObject *py_ptr;
	if (object->ptr == NULL) {
		py_ptr = Py_None;
		Py_INCREF(py_ptr);
	} else {
		py_ptr = PyList_New(object->count);
		if (py_ptr == NULL) {
			return NULL;
		}
		{
			int ptr_cntr_1;
			for (ptr_cntr_1 = 0; ptr_cntr_1 < object->count; ptr_cntr_1++) {
				PyObject *py_ptr_1;
				py_ptr_1 = PyInt_FromLong(object->ptr[ptr_cntr_1]);
				PyList_SetItem(py_ptr, ptr_cntr_1, py_ptr_1);
			}
		}
	}
	return py_ptr;
}

static int py_eventlog6_UInt32Array_set_ptr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_UInt32Array *object = (struct eventlog6_UInt32Array *)py_talloc_get_ptr(py_obj);
	talloc_unlink(py_talloc_get_mem_ctx(py_obj), object->ptr);
	if (value == Py_None) {
		object->ptr = NULL;
	} else {
		object->ptr = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int ptr_cntr_1;
			object->ptr = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->ptr, PyList_GET_SIZE(value));
			if (!object->ptr) { return -1;; }
			talloc_set_name_const(object->ptr, "ARRAY: object->ptr");
			for (ptr_cntr_1 = 0; ptr_cntr_1 < PyList_GET_SIZE(value); ptr_cntr_1++) {
				PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, ptr_cntr_1), return -1;);
				object->ptr[ptr_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, ptr_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_eventlog6_UInt32Array_getsetters[] = {
	{ discard_const_p(char, "count"), py_eventlog6_UInt32Array_get_count, py_eventlog6_UInt32Array_set_count },
	{ discard_const_p(char, "ptr"), py_eventlog6_UInt32Array_get_ptr, py_eventlog6_UInt32Array_set_ptr },
	{ NULL }
};

static PyObject *py_eventlog6_UInt32Array_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct eventlog6_UInt32Array, type);
}


static PyTypeObject eventlog6_UInt32Array_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog6.UInt32Array",
	.tp_getset = py_eventlog6_UInt32Array_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_eventlog6_UInt32Array_new,
};


static PyObject *py_eventlog6_UInt64Array_get_count(PyObject *obj, void *closure)
{
	struct eventlog6_UInt64Array *object = (struct eventlog6_UInt64Array *)py_talloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_eventlog6_UInt64Array_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_UInt64Array *object = (struct eventlog6_UInt64Array *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog6_UInt64Array_get_ptr(PyObject *obj, void *closure)
{
	struct eventlog6_UInt64Array *object = (struct eventlog6_UInt64Array *)py_talloc_get_ptr(obj);
	PyObject *py_ptr;
	if (object->ptr == NULL) {
		py_ptr = Py_None;
		Py_INCREF(py_ptr);
	} else {
		py_ptr = PyList_New(object->count);
		if (py_ptr == NULL) {
			return NULL;
		}
		{
			int ptr_cntr_1;
			for (ptr_cntr_1 = 0; ptr_cntr_1 < object->count; ptr_cntr_1++) {
				PyObject *py_ptr_1;
				py_ptr_1 = PyLong_FromLongLong(object->ptr[ptr_cntr_1]);
				PyList_SetItem(py_ptr, ptr_cntr_1, py_ptr_1);
			}
		}
	}
	return py_ptr;
}

static int py_eventlog6_UInt64Array_set_ptr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_UInt64Array *object = (struct eventlog6_UInt64Array *)py_talloc_get_ptr(py_obj);
	talloc_unlink(py_talloc_get_mem_ctx(py_obj), object->ptr);
	if (value == Py_None) {
		object->ptr = NULL;
	} else {
		object->ptr = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int ptr_cntr_1;
			object->ptr = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->ptr, PyList_GET_SIZE(value));
			if (!object->ptr) { return -1;; }
			talloc_set_name_const(object->ptr, "ARRAY: object->ptr");
			for (ptr_cntr_1 = 0; ptr_cntr_1 < PyList_GET_SIZE(value); ptr_cntr_1++) {
				if (PyLong_Check(PyList_GET_ITEM(value, ptr_cntr_1))) {
					object->ptr[ptr_cntr_1] = PyLong_AsLongLong(PyList_GET_ITEM(value, ptr_cntr_1));
				} else if (PyInt_Check(PyList_GET_ITEM(value, ptr_cntr_1))) {
					object->ptr[ptr_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(value, ptr_cntr_1));
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
					  PyInt_Type.tp_name, PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_eventlog6_UInt64Array_getsetters[] = {
	{ discard_const_p(char, "count"), py_eventlog6_UInt64Array_get_count, py_eventlog6_UInt64Array_set_count },
	{ discard_const_p(char, "ptr"), py_eventlog6_UInt64Array_get_ptr, py_eventlog6_UInt64Array_set_ptr },
	{ NULL }
};

static PyObject *py_eventlog6_UInt64Array_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct eventlog6_UInt64Array, type);
}


static PyTypeObject eventlog6_UInt64Array_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog6.UInt64Array",
	.tp_getset = py_eventlog6_UInt64Array_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_eventlog6_UInt64Array_new,
};


static PyObject *py_eventlog6_StringArray_get_count(PyObject *obj, void *closure)
{
	struct eventlog6_StringArray *object = (struct eventlog6_StringArray *)py_talloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_eventlog6_StringArray_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_StringArray *object = (struct eventlog6_StringArray *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog6_StringArray_get_ptr(PyObject *obj, void *closure)
{
	struct eventlog6_StringArray *object = (struct eventlog6_StringArray *)py_talloc_get_ptr(obj);
	PyObject *py_ptr;
	if (object->ptr == NULL) {
		py_ptr = Py_None;
		Py_INCREF(py_ptr);
	} else {
		if (object->ptr == NULL) {
			py_ptr = Py_None;
			Py_INCREF(py_ptr);
		} else {
			py_ptr = PyUnicode_Decode(object->ptr, strlen(object->ptr), "utf-8", "ignore");
		}
	}
	return py_ptr;
}

static int py_eventlog6_StringArray_set_ptr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_StringArray *object = (struct eventlog6_StringArray *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->ptr = NULL;
	} else {
		object->ptr = NULL;
		if (PyUnicode_Check(value)) {
			object->ptr = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->ptr = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_eventlog6_StringArray_getsetters[] = {
	{ discard_const_p(char, "count"), py_eventlog6_StringArray_get_count, py_eventlog6_StringArray_set_count },
	{ discard_const_p(char, "ptr"), py_eventlog6_StringArray_get_ptr, py_eventlog6_StringArray_set_ptr },
	{ NULL }
};

static PyObject *py_eventlog6_StringArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct eventlog6_StringArray, type);
}


static PyTypeObject eventlog6_StringArray_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog6.StringArray",
	.tp_getset = py_eventlog6_StringArray_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_eventlog6_StringArray_new,
};


static PyObject *py_eventlog6_GuidArray_get_count(PyObject *obj, void *closure)
{
	struct eventlog6_GuidArray *object = (struct eventlog6_GuidArray *)py_talloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_eventlog6_GuidArray_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_GuidArray *object = (struct eventlog6_GuidArray *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog6_GuidArray_get_ptr(PyObject *obj, void *closure)
{
	struct eventlog6_GuidArray *object = (struct eventlog6_GuidArray *)py_talloc_get_ptr(obj);
	PyObject *py_ptr;
	if (object->ptr == NULL) {
		py_ptr = Py_None;
		Py_INCREF(py_ptr);
	} else {
		py_ptr = PyList_New(object->count);
		if (py_ptr == NULL) {
			return NULL;
		}
		{
			int ptr_cntr_1;
			for (ptr_cntr_1 = 0; ptr_cntr_1 < object->count; ptr_cntr_1++) {
				PyObject *py_ptr_1;
				py_ptr_1 = py_talloc_reference_ex(GUID_Type, object->ptr, &object->ptr[ptr_cntr_1]);
				PyList_SetItem(py_ptr, ptr_cntr_1, py_ptr_1);
			}
		}
	}
	return py_ptr;
}

static int py_eventlog6_GuidArray_set_ptr(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_GuidArray *object = (struct eventlog6_GuidArray *)py_talloc_get_ptr(py_obj);
	talloc_unlink(py_talloc_get_mem_ctx(py_obj), object->ptr);
	if (value == Py_None) {
		object->ptr = NULL;
	} else {
		object->ptr = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int ptr_cntr_1;
			object->ptr = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->ptr, PyList_GET_SIZE(value));
			if (!object->ptr) { return -1;; }
			talloc_set_name_const(object->ptr, "ARRAY: object->ptr");
			for (ptr_cntr_1 = 0; ptr_cntr_1 < PyList_GET_SIZE(value); ptr_cntr_1++) {
				PY_CHECK_TYPE(GUID_Type, PyList_GET_ITEM(value, ptr_cntr_1), return -1;);
				if (talloc_reference(object->ptr, py_talloc_get_mem_ctx(PyList_GET_ITEM(value, ptr_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->ptr[ptr_cntr_1] = *(struct GUID *)py_talloc_get_ptr(PyList_GET_ITEM(value, ptr_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_eventlog6_GuidArray_getsetters[] = {
	{ discard_const_p(char, "count"), py_eventlog6_GuidArray_get_count, py_eventlog6_GuidArray_set_count },
	{ discard_const_p(char, "ptr"), py_eventlog6_GuidArray_get_ptr, py_eventlog6_GuidArray_set_ptr },
	{ NULL }
};

static PyObject *py_eventlog6_GuidArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct eventlog6_GuidArray, type);
}


static PyTypeObject eventlog6_GuidArray_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog6.GuidArray",
	.tp_getset = py_eventlog6_GuidArray_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_eventlog6_GuidArray_new,
};

PyObject *py_import_eventlog6_EvtRpcVariantUnion(TALLOC_CTX *mem_ctx, int level, union eventlog6_EvtRpcVariantUnion *in)
{
	PyObject *ret;

	switch (level) {
		case EvtRpcVarTypeNull:
			ret = PyInt_FromLong(in->nullVal);
			return ret;

		case EvtRpcVarTypeboolean8:
			ret = PyInt_FromLong(in->boolean8Val);
			return ret;

		case EvtRpcVarTypeUInt32:
			ret = PyInt_FromLong(in->uint32Val);
			return ret;

		case EvtRpcVarTypeUInt64:
			ret = PyLong_FromLongLong(in->uint64Val);
			return ret;

		case EvtRpcVarTypeString:
			if (in->stringVal == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				if (in->stringVal == NULL) {
					ret = Py_None;
					Py_INCREF(ret);
				} else {
					ret = PyUnicode_Decode(in->stringVal, strlen(in->stringVal), "utf-8", "ignore");
				}
			}
			return ret;

		case EvtRpcVarTypeGuid:
			if (in->guidVal == NULL) {
				ret = Py_None;
				Py_INCREF(ret);
			} else {
				ret = py_talloc_reference_ex(GUID_Type, in->guidVal, in->guidVal);
			}
			return ret;

		case EvtRpcVarTypeboolean8Array:
			ret = py_talloc_reference_ex(&eventlog6_boolean8Array_Type, mem_ctx, &in->boolean8Array);
			return ret;

		case EvtRpcVarTypeUInt32Array:
			ret = py_talloc_reference_ex(&eventlog6_UInt32Array_Type, mem_ctx, &in->uint32Array);
			return ret;

		case EvtRpcVarTypeUInt64Array:
			ret = py_talloc_reference_ex(&eventlog6_UInt64Array_Type, mem_ctx, &in->uint64Array);
			return ret;

		case EvtRpcVarTypeStringArray:
			ret = py_talloc_reference_ex(&eventlog6_StringArray_Type, mem_ctx, &in->stringArray);
			return ret;

		case EvtRpcVarTypeGuidArray:
			ret = py_talloc_reference_ex(&eventlog6_GuidArray_Type, mem_ctx, &in->guidArray);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union eventlog6_EvtRpcVariantUnion *py_export_eventlog6_EvtRpcVariantUnion(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union eventlog6_EvtRpcVariantUnion *ret = talloc_zero(mem_ctx, union eventlog6_EvtRpcVariantUnion);
	switch (level) {
		case EvtRpcVarTypeNull:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->nullVal = PyInt_AsLong(in);
			break;

		case EvtRpcVarTypeboolean8:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->boolean8Val = PyInt_AsLong(in);
			break;

		case EvtRpcVarTypeUInt32:
			PY_CHECK_TYPE(&PyInt_Type, in, talloc_free(ret); return NULL;);
			ret->uint32Val = PyInt_AsLong(in);
			break;

		case EvtRpcVarTypeUInt64:
			if (PyLong_Check(in)) {
				ret->uint64Val = PyLong_AsLongLong(in);
			} else if (PyInt_Check(in)) {
				ret->uint64Val = PyInt_AsLong(in);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
				  PyInt_Type.tp_name, PyLong_Type.tp_name);
				talloc_free(ret); return NULL;
			}
			break;

		case EvtRpcVarTypeString:
			if (in == Py_None) {
				ret->stringVal = NULL;
			} else {
				ret->stringVal = NULL;
				if (PyUnicode_Check(in)) {
					ret->stringVal = PyString_AS_STRING(PyUnicode_AsEncodedString(in, "utf-8", "ignore"));
				} else if (PyString_Check(in)) {
					ret->stringVal = PyString_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case EvtRpcVarTypeGuid:
			if (in == Py_None) {
				ret->guidVal = NULL;
			} else {
				ret->guidVal = NULL;
				PY_CHECK_TYPE(GUID_Type, in, talloc_free(ret); return NULL;);
				if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->guidVal = (struct GUID *)py_talloc_get_ptr(in);
			}
			break;

		case EvtRpcVarTypeboolean8Array:
			PY_CHECK_TYPE(&eventlog6_boolean8Array_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->boolean8Array = *(struct eventlog6_boolean8Array *)py_talloc_get_ptr(in);
			break;

		case EvtRpcVarTypeUInt32Array:
			PY_CHECK_TYPE(&eventlog6_UInt32Array_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->uint32Array = *(struct eventlog6_UInt32Array *)py_talloc_get_ptr(in);
			break;

		case EvtRpcVarTypeUInt64Array:
			PY_CHECK_TYPE(&eventlog6_UInt64Array_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->uint64Array = *(struct eventlog6_UInt64Array *)py_talloc_get_ptr(in);
			break;

		case EvtRpcVarTypeStringArray:
			PY_CHECK_TYPE(&eventlog6_StringArray_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->stringArray = *(struct eventlog6_StringArray *)py_talloc_get_ptr(in);
			break;

		case EvtRpcVarTypeGuidArray:
			PY_CHECK_TYPE(&eventlog6_GuidArray_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->guidArray = *(struct eventlog6_GuidArray *)py_talloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_eventlog6_EvtRpcVariant_get_type(PyObject *obj, void *closure)
{
	struct eventlog6_EvtRpcVariant *object = (struct eventlog6_EvtRpcVariant *)py_talloc_get_ptr(obj);
	PyObject *py_type;
	py_type = PyInt_FromLong(object->type);
	return py_type;
}

static int py_eventlog6_EvtRpcVariant_set_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_EvtRpcVariant *object = (struct eventlog6_EvtRpcVariant *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_eventlog6_EvtRpcVariant_get_flags(PyObject *obj, void *closure)
{
	struct eventlog6_EvtRpcVariant *object = (struct eventlog6_EvtRpcVariant *)py_talloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_eventlog6_EvtRpcVariant_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_EvtRpcVariant *object = (struct eventlog6_EvtRpcVariant *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog6_EvtRpcVariant_get_var(PyObject *obj, void *closure)
{
	struct eventlog6_EvtRpcVariant *object = (struct eventlog6_EvtRpcVariant *)py_talloc_get_ptr(obj);
	PyObject *py_var;
	py_var = py_import_eventlog6_EvtRpcVariantUnion(object->var, object->type, object->var);
	if (py_var == NULL) {
		return NULL;
	}
	return py_var;
}

static int py_eventlog6_EvtRpcVariant_set_var(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_EvtRpcVariant *object = (struct eventlog6_EvtRpcVariant *)py_talloc_get_ptr(py_obj);
	talloc_unlink(py_talloc_get_mem_ctx(py_obj), object->var);
	object->var = talloc_ptrtype(py_talloc_get_mem_ctx(py_obj), object->var);
	{
		union eventlog6_EvtRpcVariantUnion *var_switch_1;
		var_switch_1 = py_export_eventlog6_EvtRpcVariantUnion(py_talloc_get_mem_ctx(py_obj), object->type, value);
		if (var_switch_1 == NULL) {
			return -1;
		}
		object->var = var_switch_1;
	}
	return 0;
}

static PyGetSetDef py_eventlog6_EvtRpcVariant_getsetters[] = {
	{ discard_const_p(char, "type"), py_eventlog6_EvtRpcVariant_get_type, py_eventlog6_EvtRpcVariant_set_type },
	{ discard_const_p(char, "flags"), py_eventlog6_EvtRpcVariant_get_flags, py_eventlog6_EvtRpcVariant_set_flags },
	{ discard_const_p(char, "var"), py_eventlog6_EvtRpcVariant_get_var, py_eventlog6_EvtRpcVariant_set_var },
	{ NULL }
};

static PyObject *py_eventlog6_EvtRpcVariant_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct eventlog6_EvtRpcVariant, type);
}


static PyTypeObject eventlog6_EvtRpcVariant_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog6.EvtRpcVariant",
	.tp_getset = py_eventlog6_EvtRpcVariant_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_eventlog6_EvtRpcVariant_new,
};


static PyObject *py_eventlog6_EvtRpcVariantList_get_count(PyObject *obj, void *closure)
{
	struct eventlog6_EvtRpcVariantList *object = (struct eventlog6_EvtRpcVariantList *)py_talloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyInt_FromLong(object->count);
	return py_count;
}

static int py_eventlog6_EvtRpcVariantList_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_EvtRpcVariantList *object = (struct eventlog6_EvtRpcVariantList *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_eventlog6_EvtRpcVariantList_get_props(PyObject *obj, void *closure)
{
	struct eventlog6_EvtRpcVariantList *object = (struct eventlog6_EvtRpcVariantList *)py_talloc_get_ptr(obj);
	PyObject *py_props;
	if (object->props == NULL) {
		py_props = Py_None;
		Py_INCREF(py_props);
	} else {
		py_props = PyList_New(object->count);
		if (py_props == NULL) {
			return NULL;
		}
		{
			int props_cntr_1;
			for (props_cntr_1 = 0; props_cntr_1 < object->count; props_cntr_1++) {
				PyObject *py_props_1;
				py_props_1 = py_talloc_reference_ex(&eventlog6_EvtRpcVariant_Type, object->props, &object->props[props_cntr_1]);
				PyList_SetItem(py_props, props_cntr_1, py_props_1);
			}
		}
	}
	return py_props;
}

static int py_eventlog6_EvtRpcVariantList_set_props(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_EvtRpcVariantList *object = (struct eventlog6_EvtRpcVariantList *)py_talloc_get_ptr(py_obj);
	talloc_unlink(py_talloc_get_mem_ctx(py_obj), object->props);
	if (value == Py_None) {
		object->props = NULL;
	} else {
		object->props = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int props_cntr_1;
			object->props = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->props, PyList_GET_SIZE(value));
			if (!object->props) { return -1;; }
			talloc_set_name_const(object->props, "ARRAY: object->props");
			for (props_cntr_1 = 0; props_cntr_1 < PyList_GET_SIZE(value); props_cntr_1++) {
				PY_CHECK_TYPE(&eventlog6_EvtRpcVariant_Type, PyList_GET_ITEM(value, props_cntr_1), return -1;);
				if (talloc_reference(object->props, py_talloc_get_mem_ctx(PyList_GET_ITEM(value, props_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->props[props_cntr_1] = *(struct eventlog6_EvtRpcVariant *)py_talloc_get_ptr(PyList_GET_ITEM(value, props_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_eventlog6_EvtRpcVariantList_getsetters[] = {
	{ discard_const_p(char, "count"), py_eventlog6_EvtRpcVariantList_get_count, py_eventlog6_EvtRpcVariantList_set_count },
	{ discard_const_p(char, "props"), py_eventlog6_EvtRpcVariantList_get_props, py_eventlog6_EvtRpcVariantList_set_props },
	{ NULL }
};

static PyObject *py_eventlog6_EvtRpcVariantList_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct eventlog6_EvtRpcVariantList, type);
}


static PyTypeObject eventlog6_EvtRpcVariantList_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog6.EvtRpcVariantList",
	.tp_getset = py_eventlog6_EvtRpcVariantList_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_eventlog6_EvtRpcVariantList_new,
};


static PyObject *py_eventlog6_EvtRpcQueryChannelInfo_get_name(PyObject *obj, void *closure)
{
	struct eventlog6_EvtRpcQueryChannelInfo *object = (struct eventlog6_EvtRpcQueryChannelInfo *)py_talloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		if (object->name == NULL) {
			py_name = Py_None;
			Py_INCREF(py_name);
		} else {
			py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
		}
	}
	return py_name;
}

static int py_eventlog6_EvtRpcQueryChannelInfo_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_EvtRpcQueryChannelInfo *object = (struct eventlog6_EvtRpcQueryChannelInfo *)py_talloc_get_ptr(py_obj);
	if (value == Py_None) {
		object->name = NULL;
	} else {
		object->name = NULL;
		if (PyUnicode_Check(value)) {
			object->name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
		} else if (PyString_Check(value)) {
			object->name = PyString_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_eventlog6_EvtRpcQueryChannelInfo_get_status(PyObject *obj, void *closure)
{
	struct eventlog6_EvtRpcQueryChannelInfo *object = (struct eventlog6_EvtRpcQueryChannelInfo *)py_talloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyInt_FromLong(object->status);
	return py_status;
}

static int py_eventlog6_EvtRpcQueryChannelInfo_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct eventlog6_EvtRpcQueryChannelInfo *object = (struct eventlog6_EvtRpcQueryChannelInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->status = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_eventlog6_EvtRpcQueryChannelInfo_getsetters[] = {
	{ discard_const_p(char, "name"), py_eventlog6_EvtRpcQueryChannelInfo_get_name, py_eventlog6_EvtRpcQueryChannelInfo_set_name },
	{ discard_const_p(char, "status"), py_eventlog6_EvtRpcQueryChannelInfo_get_status, py_eventlog6_EvtRpcQueryChannelInfo_set_status },
	{ NULL }
};

static PyObject *py_eventlog6_EvtRpcQueryChannelInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct eventlog6_EvtRpcQueryChannelInfo, type);
}


static PyTypeObject eventlog6_EvtRpcQueryChannelInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog6.EvtRpcQueryChannelInfo",
	.tp_getset = py_eventlog6_EvtRpcQueryChannelInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_eventlog6_EvtRpcQueryChannelInfo_new,
};


static bool pack_py_eventlog6_EvtRpcRegisterRemoteSubscription_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcRegisterRemoteSubscription *r)
{
	PyObject *py_channelPath;
	PyObject *py_query;
	PyObject *py_bookmarkXml;
	PyObject *py_flags;
	const char *kwnames[] = {
		"channelPath", "query", "bookmarkXml", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:eventlog6_EvtRpcRegisterRemoteSubscription", discard_const_p(char *, kwnames), &py_channelPath, &py_query, &py_bookmarkXml, &py_flags)) {
		return false;
	}

	if (py_channelPath == Py_None) {
		r->in.channelPath = NULL;
	} else {
		r->in.channelPath = NULL;
		if (PyUnicode_Check(py_channelPath)) {
			r->in.channelPath = PyString_AS_STRING(PyUnicode_AsEncodedString(py_channelPath, "utf-8", "ignore"));
		} else if (PyString_Check(py_channelPath)) {
			r->in.channelPath = PyString_AS_STRING(py_channelPath);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_channelPath)->tp_name);
			return false;
		}
	}
	r->in.query = talloc_ptrtype(r, r->in.query);
	if (PyUnicode_Check(py_query)) {
		r->in.query = PyString_AS_STRING(PyUnicode_AsEncodedString(py_query, "utf-8", "ignore"));
	} else if (PyString_Check(py_query)) {
		r->in.query = PyString_AS_STRING(py_query);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_query)->tp_name);
		return false;
	}
	if (py_bookmarkXml == Py_None) {
		r->in.bookmarkXml = NULL;
	} else {
		r->in.bookmarkXml = NULL;
		if (PyUnicode_Check(py_bookmarkXml)) {
			r->in.bookmarkXml = PyString_AS_STRING(PyUnicode_AsEncodedString(py_bookmarkXml, "utf-8", "ignore"));
		} else if (PyString_Check(py_bookmarkXml)) {
			r->in.bookmarkXml = PyString_AS_STRING(py_bookmarkXml);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_bookmarkXml)->tp_name);
			return false;
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcRegisterRemoteSubscription_args_out(struct eventlog6_EvtRpcRegisterRemoteSubscription *r)
{
	PyObject *result;
	PyObject *py_handle;
	PyObject *py_control;
	PyObject *py_queryChannelInfoSize;
	PyObject *py_queryChannelInfo;
	PyObject *py_error;
	result = PyTuple_New(5);
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	PyTuple_SetItem(result, 0, py_handle);
	py_control = py_talloc_reference_ex(policy_handle_Type, r->out.control, r->out.control);
	PyTuple_SetItem(result, 1, py_control);
	py_queryChannelInfoSize = PyInt_FromLong(*r->out.queryChannelInfoSize);
	PyTuple_SetItem(result, 2, py_queryChannelInfoSize);
	if (*r->out.queryChannelInfo == NULL) {
		py_queryChannelInfo = Py_None;
		Py_INCREF(py_queryChannelInfo);
	} else {
		py_queryChannelInfo = PyList_New(*r->out.queryChannelInfoSize);
		if (py_queryChannelInfo == NULL) {
			return NULL;
		}
		{
			int queryChannelInfo_cntr_2;
			for (queryChannelInfo_cntr_2 = 0; queryChannelInfo_cntr_2 < *r->out.queryChannelInfoSize; queryChannelInfo_cntr_2++) {
				PyObject *py_queryChannelInfo_2;
				py_queryChannelInfo_2 = py_talloc_reference_ex(&eventlog6_EvtRpcQueryChannelInfo_Type, *r->out.queryChannelInfo, r->out.queryChannelInfo[queryChannelInfo_cntr_2]);
				PyList_SetItem(py_queryChannelInfo, queryChannelInfo_cntr_2, py_queryChannelInfo_2);
			}
		}
	}
	PyTuple_SetItem(result, 3, py_queryChannelInfo);
	py_error = py_talloc_reference_ex(&eventlog6_RpcInfo_Type, r->out.error, r->out.error);
	PyTuple_SetItem(result, 4, py_error);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcRemoteSubscriptionNextAsync_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcRemoteSubscriptionNextAsync *r)
{
	PyObject *py_handle;
	PyObject *py_numRequestedRecords;
	PyObject *py_flags;
	const char *kwnames[] = {
		"handle", "numRequestedRecords", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:eventlog6_EvtRpcRemoteSubscriptionNextAsync", discard_const_p(char *, kwnames), &py_handle, &py_numRequestedRecords, &py_flags)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_numRequestedRecords, return false;);
	r->in.numRequestedRecords = PyInt_AsLong(py_numRequestedRecords);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcRemoteSubscriptionNextAsync_args_out(struct eventlog6_EvtRpcRemoteSubscriptionNextAsync *r)
{
	PyObject *result;
	PyObject *py_numActualRecords;
	PyObject *py_eventDataIndices;
	PyObject *py_eventDataSizes;
	PyObject *py_resultBufferSize;
	PyObject *py_resultBuffer;
	result = PyTuple_New(5);
	py_numActualRecords = PyInt_FromLong(*r->out.numActualRecords);
	PyTuple_SetItem(result, 0, py_numActualRecords);
	if (*r->out.eventDataIndices == NULL) {
		py_eventDataIndices = Py_None;
		Py_INCREF(py_eventDataIndices);
	} else {
		py_eventDataIndices = PyList_New(*r->out.numActualRecords);
		if (py_eventDataIndices == NULL) {
			return NULL;
		}
		{
			int eventDataIndices_cntr_2;
			for (eventDataIndices_cntr_2 = 0; eventDataIndices_cntr_2 < *r->out.numActualRecords; eventDataIndices_cntr_2++) {
				PyObject *py_eventDataIndices_2;
				py_eventDataIndices_2 = PyInt_FromLong(*r->out.eventDataIndices[eventDataIndices_cntr_2]);
				PyList_SetItem(py_eventDataIndices, eventDataIndices_cntr_2, py_eventDataIndices_2);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_eventDataIndices);
	if (*r->out.eventDataSizes == NULL) {
		py_eventDataSizes = Py_None;
		Py_INCREF(py_eventDataSizes);
	} else {
		py_eventDataSizes = PyList_New(*r->out.numActualRecords);
		if (py_eventDataSizes == NULL) {
			return NULL;
		}
		{
			int eventDataSizes_cntr_2;
			for (eventDataSizes_cntr_2 = 0; eventDataSizes_cntr_2 < *r->out.numActualRecords; eventDataSizes_cntr_2++) {
				PyObject *py_eventDataSizes_2;
				py_eventDataSizes_2 = PyInt_FromLong(*r->out.eventDataSizes[eventDataSizes_cntr_2]);
				PyList_SetItem(py_eventDataSizes, eventDataSizes_cntr_2, py_eventDataSizes_2);
			}
		}
	}
	PyTuple_SetItem(result, 2, py_eventDataSizes);
	py_resultBufferSize = PyInt_FromLong(*r->out.resultBufferSize);
	PyTuple_SetItem(result, 3, py_resultBufferSize);
	if (*r->out.resultBuffer == NULL) {
		py_resultBuffer = Py_None;
		Py_INCREF(py_resultBuffer);
	} else {
		py_resultBuffer = PyList_New(*r->out.resultBufferSize);
		if (py_resultBuffer == NULL) {
			return NULL;
		}
		{
			int resultBuffer_cntr_2;
			for (resultBuffer_cntr_2 = 0; resultBuffer_cntr_2 < *r->out.resultBufferSize; resultBuffer_cntr_2++) {
				PyObject *py_resultBuffer_2;
				py_resultBuffer_2 = PyInt_FromLong(*r->out.resultBuffer[resultBuffer_cntr_2]);
				PyList_SetItem(py_resultBuffer, resultBuffer_cntr_2, py_resultBuffer_2);
			}
		}
	}
	PyTuple_SetItem(result, 4, py_resultBuffer);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcRemoteSubscriptionNext_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcRemoteSubscriptionNext *r)
{
	PyObject *py_handle;
	PyObject *py_numRequestedRecords;
	PyObject *py_timeOut;
	PyObject *py_flags;
	const char *kwnames[] = {
		"handle", "numRequestedRecords", "timeOut", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:eventlog6_EvtRpcRemoteSubscriptionNext", discard_const_p(char *, kwnames), &py_handle, &py_numRequestedRecords, &py_timeOut, &py_flags)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_numRequestedRecords, return false;);
	r->in.numRequestedRecords = PyInt_AsLong(py_numRequestedRecords);
	PY_CHECK_TYPE(&PyInt_Type, py_timeOut, return false;);
	r->in.timeOut = PyInt_AsLong(py_timeOut);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcRemoteSubscriptionNext_args_out(struct eventlog6_EvtRpcRemoteSubscriptionNext *r)
{
	PyObject *result;
	PyObject *py_numActualRecords;
	PyObject *py_eventDataIndices;
	PyObject *py_eventDataSizes;
	PyObject *py_resultBufferSize;
	PyObject *py_resultBuffer;
	result = PyTuple_New(5);
	py_numActualRecords = PyInt_FromLong(*r->out.numActualRecords);
	PyTuple_SetItem(result, 0, py_numActualRecords);
	if (*r->out.eventDataIndices == NULL) {
		py_eventDataIndices = Py_None;
		Py_INCREF(py_eventDataIndices);
	} else {
		py_eventDataIndices = PyList_New(*r->out.numActualRecords);
		if (py_eventDataIndices == NULL) {
			return NULL;
		}
		{
			int eventDataIndices_cntr_2;
			for (eventDataIndices_cntr_2 = 0; eventDataIndices_cntr_2 < *r->out.numActualRecords; eventDataIndices_cntr_2++) {
				PyObject *py_eventDataIndices_2;
				py_eventDataIndices_2 = PyInt_FromLong(*r->out.eventDataIndices[eventDataIndices_cntr_2]);
				PyList_SetItem(py_eventDataIndices, eventDataIndices_cntr_2, py_eventDataIndices_2);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_eventDataIndices);
	if (*r->out.eventDataSizes == NULL) {
		py_eventDataSizes = Py_None;
		Py_INCREF(py_eventDataSizes);
	} else {
		py_eventDataSizes = PyList_New(*r->out.numActualRecords);
		if (py_eventDataSizes == NULL) {
			return NULL;
		}
		{
			int eventDataSizes_cntr_2;
			for (eventDataSizes_cntr_2 = 0; eventDataSizes_cntr_2 < *r->out.numActualRecords; eventDataSizes_cntr_2++) {
				PyObject *py_eventDataSizes_2;
				py_eventDataSizes_2 = PyInt_FromLong(*r->out.eventDataSizes[eventDataSizes_cntr_2]);
				PyList_SetItem(py_eventDataSizes, eventDataSizes_cntr_2, py_eventDataSizes_2);
			}
		}
	}
	PyTuple_SetItem(result, 2, py_eventDataSizes);
	py_resultBufferSize = PyInt_FromLong(*r->out.resultBufferSize);
	PyTuple_SetItem(result, 3, py_resultBufferSize);
	if (*r->out.resultBuffer == NULL) {
		py_resultBuffer = Py_None;
		Py_INCREF(py_resultBuffer);
	} else {
		py_resultBuffer = PyList_New(*r->out.resultBufferSize);
		if (py_resultBuffer == NULL) {
			return NULL;
		}
		{
			int resultBuffer_cntr_2;
			for (resultBuffer_cntr_2 = 0; resultBuffer_cntr_2 < *r->out.resultBufferSize; resultBuffer_cntr_2++) {
				PyObject *py_resultBuffer_2;
				py_resultBuffer_2 = PyInt_FromLong(*r->out.resultBuffer[resultBuffer_cntr_2]);
				PyList_SetItem(py_resultBuffer, resultBuffer_cntr_2, py_resultBuffer_2);
			}
		}
	}
	PyTuple_SetItem(result, 4, py_resultBuffer);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:eventlog6_EvtRpcRemoteSubscriptionWaitAsync", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_args_out(struct eventlog6_EvtRpcRemoteSubscriptionWaitAsync *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcRegisterControllableOperation_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcRegisterControllableOperation *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":eventlog6_EvtRpcRegisterControllableOperation", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcRegisterControllableOperation_args_out(struct eventlog6_EvtRpcRegisterControllableOperation *r)
{
	PyObject *result;
	PyObject *py_handle;
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcRegisterLogQuery_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcRegisterLogQuery *r)
{
	PyObject *py_path;
	PyObject *py_query;
	PyObject *py_flags;
	const char *kwnames[] = {
		"path", "query", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:eventlog6_EvtRpcRegisterLogQuery", discard_const_p(char *, kwnames), &py_path, &py_query, &py_flags)) {
		return false;
	}

	if (py_path == Py_None) {
		r->in.path = NULL;
	} else {
		r->in.path = NULL;
		if (PyUnicode_Check(py_path)) {
			r->in.path = PyString_AS_STRING(PyUnicode_AsEncodedString(py_path, "utf-8", "ignore"));
		} else if (PyString_Check(py_path)) {
			r->in.path = PyString_AS_STRING(py_path);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_path)->tp_name);
			return false;
		}
	}
	r->in.query = talloc_ptrtype(r, r->in.query);
	if (PyUnicode_Check(py_query)) {
		r->in.query = PyString_AS_STRING(PyUnicode_AsEncodedString(py_query, "utf-8", "ignore"));
	} else if (PyString_Check(py_query)) {
		r->in.query = PyString_AS_STRING(py_query);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_query)->tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcRegisterLogQuery_args_out(struct eventlog6_EvtRpcRegisterLogQuery *r)
{
	PyObject *result;
	PyObject *py_handle;
	PyObject *py_opControl;
	PyObject *py_queryChannelInfoSize;
	PyObject *py_queryChannelInfo;
	PyObject *py_error;
	result = PyTuple_New(5);
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	PyTuple_SetItem(result, 0, py_handle);
	py_opControl = py_talloc_reference_ex(policy_handle_Type, r->out.opControl, r->out.opControl);
	PyTuple_SetItem(result, 1, py_opControl);
	py_queryChannelInfoSize = PyInt_FromLong(*r->out.queryChannelInfoSize);
	PyTuple_SetItem(result, 2, py_queryChannelInfoSize);
	if (*r->out.queryChannelInfo == NULL) {
		py_queryChannelInfo = Py_None;
		Py_INCREF(py_queryChannelInfo);
	} else {
		py_queryChannelInfo = PyList_New(*r->out.queryChannelInfoSize);
		if (py_queryChannelInfo == NULL) {
			return NULL;
		}
		{
			int queryChannelInfo_cntr_2;
			for (queryChannelInfo_cntr_2 = 0; queryChannelInfo_cntr_2 < *r->out.queryChannelInfoSize; queryChannelInfo_cntr_2++) {
				PyObject *py_queryChannelInfo_2;
				py_queryChannelInfo_2 = py_talloc_reference_ex(&eventlog6_EvtRpcQueryChannelInfo_Type, *r->out.queryChannelInfo, r->out.queryChannelInfo[queryChannelInfo_cntr_2]);
				PyList_SetItem(py_queryChannelInfo, queryChannelInfo_cntr_2, py_queryChannelInfo_2);
			}
		}
	}
	PyTuple_SetItem(result, 3, py_queryChannelInfo);
	py_error = py_talloc_reference_ex(&eventlog6_RpcInfo_Type, r->out.error, r->out.error);
	PyTuple_SetItem(result, 4, py_error);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcClearLog_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcClearLog *r)
{
	PyObject *py_control;
	PyObject *py_channelPath;
	PyObject *py_backupPath;
	PyObject *py_flags;
	const char *kwnames[] = {
		"control", "channelPath", "backupPath", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:eventlog6_EvtRpcClearLog", discard_const_p(char *, kwnames), &py_control, &py_channelPath, &py_backupPath, &py_flags)) {
		return false;
	}

	r->in.control = talloc_ptrtype(r, r->in.control);
	PY_CHECK_TYPE(policy_handle_Type, py_control, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_control)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.control = (struct policy_handle *)py_talloc_get_ptr(py_control);
	r->in.channelPath = talloc_ptrtype(r, r->in.channelPath);
	if (PyUnicode_Check(py_channelPath)) {
		r->in.channelPath = PyString_AS_STRING(PyUnicode_AsEncodedString(py_channelPath, "utf-8", "ignore"));
	} else if (PyString_Check(py_channelPath)) {
		r->in.channelPath = PyString_AS_STRING(py_channelPath);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_channelPath)->tp_name);
		return false;
	}
	if (py_backupPath == Py_None) {
		r->in.backupPath = NULL;
	} else {
		r->in.backupPath = NULL;
		if (PyUnicode_Check(py_backupPath)) {
			r->in.backupPath = PyString_AS_STRING(PyUnicode_AsEncodedString(py_backupPath, "utf-8", "ignore"));
		} else if (PyString_Check(py_backupPath)) {
			r->in.backupPath = PyString_AS_STRING(py_backupPath);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_backupPath)->tp_name);
			return false;
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcClearLog_args_out(struct eventlog6_EvtRpcClearLog *r)
{
	PyObject *result;
	PyObject *py_error;
	py_error = py_talloc_reference_ex(&eventlog6_RpcInfo_Type, r->out.error, r->out.error);
	result = py_error;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcExportLog_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcExportLog *r)
{
	PyObject *py_control;
	PyObject *py_channelPath;
	PyObject *py_query;
	PyObject *py_backupPath;
	PyObject *py_flags;
	const char *kwnames[] = {
		"control", "channelPath", "query", "backupPath", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:eventlog6_EvtRpcExportLog", discard_const_p(char *, kwnames), &py_control, &py_channelPath, &py_query, &py_backupPath, &py_flags)) {
		return false;
	}

	r->in.control = talloc_ptrtype(r, r->in.control);
	PY_CHECK_TYPE(policy_handle_Type, py_control, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_control)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.control = (struct policy_handle *)py_talloc_get_ptr(py_control);
	if (py_channelPath == Py_None) {
		r->in.channelPath = NULL;
	} else {
		r->in.channelPath = NULL;
		if (PyUnicode_Check(py_channelPath)) {
			r->in.channelPath = PyString_AS_STRING(PyUnicode_AsEncodedString(py_channelPath, "utf-8", "ignore"));
		} else if (PyString_Check(py_channelPath)) {
			r->in.channelPath = PyString_AS_STRING(py_channelPath);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_channelPath)->tp_name);
			return false;
		}
	}
	r->in.query = talloc_ptrtype(r, r->in.query);
	if (PyUnicode_Check(py_query)) {
		r->in.query = PyString_AS_STRING(PyUnicode_AsEncodedString(py_query, "utf-8", "ignore"));
	} else if (PyString_Check(py_query)) {
		r->in.query = PyString_AS_STRING(py_query);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_query)->tp_name);
		return false;
	}
	r->in.backupPath = talloc_ptrtype(r, r->in.backupPath);
	if (PyUnicode_Check(py_backupPath)) {
		r->in.backupPath = PyString_AS_STRING(PyUnicode_AsEncodedString(py_backupPath, "utf-8", "ignore"));
	} else if (PyString_Check(py_backupPath)) {
		r->in.backupPath = PyString_AS_STRING(py_backupPath);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_backupPath)->tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcExportLog_args_out(struct eventlog6_EvtRpcExportLog *r)
{
	PyObject *result;
	PyObject *py_error;
	py_error = py_talloc_reference_ex(&eventlog6_RpcInfo_Type, r->out.error, r->out.error);
	result = py_error;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcLocalizeExportLog_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcLocalizeExportLog *r)
{
	PyObject *py_control;
	PyObject *py_logFilePath;
	PyObject *py_locale;
	PyObject *py_flags;
	const char *kwnames[] = {
		"control", "logFilePath", "locale", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:eventlog6_EvtRpcLocalizeExportLog", discard_const_p(char *, kwnames), &py_control, &py_logFilePath, &py_locale, &py_flags)) {
		return false;
	}

	r->in.control = talloc_ptrtype(r, r->in.control);
	PY_CHECK_TYPE(policy_handle_Type, py_control, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_control)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.control = (struct policy_handle *)py_talloc_get_ptr(py_control);
	r->in.logFilePath = talloc_ptrtype(r, r->in.logFilePath);
	if (PyUnicode_Check(py_logFilePath)) {
		r->in.logFilePath = PyString_AS_STRING(PyUnicode_AsEncodedString(py_logFilePath, "utf-8", "ignore"));
	} else if (PyString_Check(py_logFilePath)) {
		r->in.logFilePath = PyString_AS_STRING(py_logFilePath);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_logFilePath)->tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_locale, return false;);
	r->in.locale = PyInt_AsLong(py_locale);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcLocalizeExportLog_args_out(struct eventlog6_EvtRpcLocalizeExportLog *r)
{
	PyObject *result;
	PyObject *py_error;
	py_error = py_talloc_reference_ex(&eventlog6_RpcInfo_Type, r->out.error, r->out.error);
	result = py_error;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcMessageRender_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcMessageRender *r)
{
	PyObject *py_pubCfgObj;
	PyObject *py_eventId;
	PyObject *py_messageId;
	PyObject *py_values;
	PyObject *py_flags;
	PyObject *py_maxSizeString;
	const char *kwnames[] = {
		"pubCfgObj", "eventId", "messageId", "values", "flags", "maxSizeString", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:eventlog6_EvtRpcMessageRender", discard_const_p(char *, kwnames), &py_pubCfgObj, &py_eventId, &py_messageId, &py_values, &py_flags, &py_maxSizeString)) {
		return false;
	}

	r->in.pubCfgObj = talloc_ptrtype(r, r->in.pubCfgObj);
	PY_CHECK_TYPE(policy_handle_Type, py_pubCfgObj, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_pubCfgObj)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pubCfgObj = (struct policy_handle *)py_talloc_get_ptr(py_pubCfgObj);
	PY_CHECK_TYPE(&PyList_Type, py_eventId, return false;);
	r->in.sizeEventId = PyList_GET_SIZE(py_eventId);
	r->in.eventId = talloc_ptrtype(r, r->in.eventId);
	PY_CHECK_TYPE(&PyList_Type, py_eventId, return false;);
	{
		int eventId_cntr_1;
		r->in.eventId = talloc_array_ptrtype(r, r->in.eventId, PyList_GET_SIZE(py_eventId));
		if (!r->in.eventId) { return false;; }
		talloc_set_name_const(r->in.eventId, "ARRAY: r->in.eventId");
		for (eventId_cntr_1 = 0; eventId_cntr_1 < PyList_GET_SIZE(py_eventId); eventId_cntr_1++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(py_eventId, eventId_cntr_1), return false;);
			r->in.eventId[eventId_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(py_eventId, eventId_cntr_1));
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_messageId, return false;);
	r->in.messageId = PyInt_AsLong(py_messageId);
	r->in.values = talloc_ptrtype(r, r->in.values);
	PY_CHECK_TYPE(&eventlog6_EvtRpcVariantList_Type, py_values, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_values)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.values = (struct eventlog6_EvtRpcVariantList *)py_talloc_get_ptr(py_values);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	PY_CHECK_TYPE(&PyInt_Type, py_maxSizeString, return false;);
	r->in.maxSizeString = PyInt_AsLong(py_maxSizeString);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcMessageRender_args_out(struct eventlog6_EvtRpcMessageRender *r)
{
	PyObject *result;
	PyObject *py_actualSizeString;
	PyObject *py_neededSizeString;
	PyObject *py_string;
	PyObject *py_error;
	result = PyTuple_New(4);
	py_actualSizeString = PyInt_FromLong(*r->out.actualSizeString);
	PyTuple_SetItem(result, 0, py_actualSizeString);
	py_neededSizeString = PyInt_FromLong(*r->out.neededSizeString);
	PyTuple_SetItem(result, 1, py_neededSizeString);
	if (*r->out.string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		py_string = PyList_New(*r->out.actualSizeString);
		if (py_string == NULL) {
			return NULL;
		}
		{
			int string_cntr_2;
			for (string_cntr_2 = 0; string_cntr_2 < *r->out.actualSizeString; string_cntr_2++) {
				PyObject *py_string_2;
				py_string_2 = PyInt_FromLong(*r->out.string[string_cntr_2]);
				PyList_SetItem(py_string, string_cntr_2, py_string_2);
			}
		}
	}
	PyTuple_SetItem(result, 2, py_string);
	py_error = py_talloc_reference_ex(&eventlog6_RpcInfo_Type, r->out.error, r->out.error);
	PyTuple_SetItem(result, 3, py_error);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcMessageRenderDefault_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcMessageRenderDefault *r)
{
	PyObject *py_eventId;
	PyObject *py_messageId;
	PyObject *py_values;
	PyObject *py_flags;
	PyObject *py_maxSizeString;
	const char *kwnames[] = {
		"eventId", "messageId", "values", "flags", "maxSizeString", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:eventlog6_EvtRpcMessageRenderDefault", discard_const_p(char *, kwnames), &py_eventId, &py_messageId, &py_values, &py_flags, &py_maxSizeString)) {
		return false;
	}

	PY_CHECK_TYPE(&PyList_Type, py_eventId, return false;);
	r->in.sizeEventId = PyList_GET_SIZE(py_eventId);
	r->in.eventId = talloc_ptrtype(r, r->in.eventId);
	PY_CHECK_TYPE(&PyList_Type, py_eventId, return false;);
	{
		int eventId_cntr_1;
		r->in.eventId = talloc_array_ptrtype(r, r->in.eventId, PyList_GET_SIZE(py_eventId));
		if (!r->in.eventId) { return false;; }
		talloc_set_name_const(r->in.eventId, "ARRAY: r->in.eventId");
		for (eventId_cntr_1 = 0; eventId_cntr_1 < PyList_GET_SIZE(py_eventId); eventId_cntr_1++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(py_eventId, eventId_cntr_1), return false;);
			r->in.eventId[eventId_cntr_1] = PyInt_AsLong(PyList_GET_ITEM(py_eventId, eventId_cntr_1));
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_messageId, return false;);
	r->in.messageId = PyInt_AsLong(py_messageId);
	r->in.values = talloc_ptrtype(r, r->in.values);
	PY_CHECK_TYPE(&eventlog6_EvtRpcVariantList_Type, py_values, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_values)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.values = (struct eventlog6_EvtRpcVariantList *)py_talloc_get_ptr(py_values);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	PY_CHECK_TYPE(&PyInt_Type, py_maxSizeString, return false;);
	r->in.maxSizeString = PyInt_AsLong(py_maxSizeString);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcMessageRenderDefault_args_out(struct eventlog6_EvtRpcMessageRenderDefault *r)
{
	PyObject *result;
	PyObject *py_actualSizeString;
	PyObject *py_neededSizeString;
	PyObject *py_string;
	PyObject *py_error;
	result = PyTuple_New(4);
	py_actualSizeString = PyInt_FromLong(*r->out.actualSizeString);
	PyTuple_SetItem(result, 0, py_actualSizeString);
	py_neededSizeString = PyInt_FromLong(*r->out.neededSizeString);
	PyTuple_SetItem(result, 1, py_neededSizeString);
	if (*r->out.string == NULL) {
		py_string = Py_None;
		Py_INCREF(py_string);
	} else {
		py_string = PyList_New(*r->out.actualSizeString);
		if (py_string == NULL) {
			return NULL;
		}
		{
			int string_cntr_2;
			for (string_cntr_2 = 0; string_cntr_2 < *r->out.actualSizeString; string_cntr_2++) {
				PyObject *py_string_2;
				py_string_2 = PyInt_FromLong(*r->out.string[string_cntr_2]);
				PyList_SetItem(py_string, string_cntr_2, py_string_2);
			}
		}
	}
	PyTuple_SetItem(result, 2, py_string);
	py_error = py_talloc_reference_ex(&eventlog6_RpcInfo_Type, r->out.error, r->out.error);
	PyTuple_SetItem(result, 3, py_error);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcQueryNext_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcQueryNext *r)
{
	PyObject *py_logQuery;
	PyObject *py_numRequestedRecords;
	PyObject *py_timeOutEnd;
	PyObject *py_flags;
	const char *kwnames[] = {
		"logQuery", "numRequestedRecords", "timeOutEnd", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:eventlog6_EvtRpcQueryNext", discard_const_p(char *, kwnames), &py_logQuery, &py_numRequestedRecords, &py_timeOutEnd, &py_flags)) {
		return false;
	}

	r->in.logQuery = talloc_ptrtype(r, r->in.logQuery);
	PY_CHECK_TYPE(policy_handle_Type, py_logQuery, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_logQuery)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.logQuery = (struct policy_handle *)py_talloc_get_ptr(py_logQuery);
	PY_CHECK_TYPE(&PyInt_Type, py_numRequestedRecords, return false;);
	r->in.numRequestedRecords = PyInt_AsLong(py_numRequestedRecords);
	PY_CHECK_TYPE(&PyInt_Type, py_timeOutEnd, return false;);
	r->in.timeOutEnd = PyInt_AsLong(py_timeOutEnd);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcQueryNext_args_out(struct eventlog6_EvtRpcQueryNext *r)
{
	PyObject *result;
	PyObject *py_numActualRecords;
	PyObject *py_eventDataIndices;
	PyObject *py_eventDataSizes;
	PyObject *py_resultBufferSize;
	PyObject *py_resultBuffer;
	result = PyTuple_New(5);
	py_numActualRecords = PyInt_FromLong(*r->out.numActualRecords);
	PyTuple_SetItem(result, 0, py_numActualRecords);
	if (*r->out.eventDataIndices == NULL) {
		py_eventDataIndices = Py_None;
		Py_INCREF(py_eventDataIndices);
	} else {
		py_eventDataIndices = PyList_New(*r->out.numActualRecords);
		if (py_eventDataIndices == NULL) {
			return NULL;
		}
		{
			int eventDataIndices_cntr_2;
			for (eventDataIndices_cntr_2 = 0; eventDataIndices_cntr_2 < *r->out.numActualRecords; eventDataIndices_cntr_2++) {
				PyObject *py_eventDataIndices_2;
				py_eventDataIndices_2 = PyInt_FromLong(*r->out.eventDataIndices[eventDataIndices_cntr_2]);
				PyList_SetItem(py_eventDataIndices, eventDataIndices_cntr_2, py_eventDataIndices_2);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_eventDataIndices);
	if (*r->out.eventDataSizes == NULL) {
		py_eventDataSizes = Py_None;
		Py_INCREF(py_eventDataSizes);
	} else {
		py_eventDataSizes = PyList_New(*r->out.numActualRecords);
		if (py_eventDataSizes == NULL) {
			return NULL;
		}
		{
			int eventDataSizes_cntr_2;
			for (eventDataSizes_cntr_2 = 0; eventDataSizes_cntr_2 < *r->out.numActualRecords; eventDataSizes_cntr_2++) {
				PyObject *py_eventDataSizes_2;
				py_eventDataSizes_2 = PyInt_FromLong(*r->out.eventDataSizes[eventDataSizes_cntr_2]);
				PyList_SetItem(py_eventDataSizes, eventDataSizes_cntr_2, py_eventDataSizes_2);
			}
		}
	}
	PyTuple_SetItem(result, 2, py_eventDataSizes);
	py_resultBufferSize = PyInt_FromLong(*r->out.resultBufferSize);
	PyTuple_SetItem(result, 3, py_resultBufferSize);
	if (*r->out.resultBuffer == NULL) {
		py_resultBuffer = Py_None;
		Py_INCREF(py_resultBuffer);
	} else {
		py_resultBuffer = PyList_New(*r->out.resultBufferSize);
		if (py_resultBuffer == NULL) {
			return NULL;
		}
		{
			int resultBuffer_cntr_2;
			for (resultBuffer_cntr_2 = 0; resultBuffer_cntr_2 < *r->out.resultBufferSize; resultBuffer_cntr_2++) {
				PyObject *py_resultBuffer_2;
				py_resultBuffer_2 = PyInt_FromLong(*r->out.resultBuffer[resultBuffer_cntr_2]);
				PyList_SetItem(py_resultBuffer, resultBuffer_cntr_2, py_resultBuffer_2);
			}
		}
	}
	PyTuple_SetItem(result, 4, py_resultBuffer);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcQuerySeek_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcQuerySeek *r)
{
	PyObject *py_logQuery;
	PyObject *py_pos;
	PyObject *py_bookmarkXml;
	PyObject *py_timeOut;
	PyObject *py_flags;
	const char *kwnames[] = {
		"logQuery", "pos", "bookmarkXml", "timeOut", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:eventlog6_EvtRpcQuerySeek", discard_const_p(char *, kwnames), &py_logQuery, &py_pos, &py_bookmarkXml, &py_timeOut, &py_flags)) {
		return false;
	}

	r->in.logQuery = talloc_ptrtype(r, r->in.logQuery);
	PY_CHECK_TYPE(policy_handle_Type, py_logQuery, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_logQuery)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.logQuery = (struct policy_handle *)py_talloc_get_ptr(py_logQuery);
	if (PyLong_Check(py_pos)) {
		r->in.pos = PyLong_AsLongLong(py_pos);
	} else if (PyInt_Check(py_pos)) {
		r->in.pos = PyInt_AsLong(py_pos);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (py_bookmarkXml == Py_None) {
		r->in.bookmarkXml = NULL;
	} else {
		r->in.bookmarkXml = NULL;
		if (PyUnicode_Check(py_bookmarkXml)) {
			r->in.bookmarkXml = PyString_AS_STRING(PyUnicode_AsEncodedString(py_bookmarkXml, "utf-8", "ignore"));
		} else if (PyString_Check(py_bookmarkXml)) {
			r->in.bookmarkXml = PyString_AS_STRING(py_bookmarkXml);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_bookmarkXml)->tp_name);
			return false;
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_timeOut, return false;);
	r->in.timeOut = PyInt_AsLong(py_timeOut);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcQuerySeek_args_out(struct eventlog6_EvtRpcQuerySeek *r)
{
	PyObject *result;
	PyObject *py_error;
	py_error = py_talloc_reference_ex(&eventlog6_RpcInfo_Type, r->out.error, r->out.error);
	result = py_error;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcClose_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcClose *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:eventlog6_EvtRpcClose", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (py_handle == Py_None) {
		*r->in.handle = NULL;
	} else {
		*r->in.handle = NULL;
		PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
		if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
			PyErr_NoMemory();
			return false;
		}
		*r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	}
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcClose_args_out(struct eventlog6_EvtRpcClose *r)
{
	PyObject *result;
	PyObject *py_handle;
	if (*r->out.handle == NULL) {
		py_handle = Py_None;
		Py_INCREF(py_handle);
	} else {
		py_handle = py_talloc_reference_ex(policy_handle_Type, *r->out.handle, *r->out.handle);
	}
	result = py_handle;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcCancel_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcCancel *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:eventlog6_EvtRpcCancel", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcCancel_args_out(struct eventlog6_EvtRpcCancel *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcAssertConfig_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcAssertConfig *r)
{
	PyObject *py_path;
	PyObject *py_flags;
	const char *kwnames[] = {
		"path", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:eventlog6_EvtRpcAssertConfig", discard_const_p(char *, kwnames), &py_path, &py_flags)) {
		return false;
	}

	r->in.path = talloc_ptrtype(r, r->in.path);
	if (PyUnicode_Check(py_path)) {
		r->in.path = PyString_AS_STRING(PyUnicode_AsEncodedString(py_path, "utf-8", "ignore"));
	} else if (PyString_Check(py_path)) {
		r->in.path = PyString_AS_STRING(py_path);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_path)->tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcAssertConfig_args_out(struct eventlog6_EvtRpcAssertConfig *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcRetractConfig_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcRetractConfig *r)
{
	PyObject *py_path;
	PyObject *py_flags;
	const char *kwnames[] = {
		"path", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:eventlog6_EvtRpcRetractConfig", discard_const_p(char *, kwnames), &py_path, &py_flags)) {
		return false;
	}

	r->in.path = talloc_ptrtype(r, r->in.path);
	if (PyUnicode_Check(py_path)) {
		r->in.path = PyString_AS_STRING(PyUnicode_AsEncodedString(py_path, "utf-8", "ignore"));
	} else if (PyString_Check(py_path)) {
		r->in.path = PyString_AS_STRING(py_path);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_path)->tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcRetractConfig_args_out(struct eventlog6_EvtRpcRetractConfig *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcOpenLogHandle_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcOpenLogHandle *r)
{
	PyObject *py_channel;
	PyObject *py_flags;
	const char *kwnames[] = {
		"channel", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:eventlog6_EvtRpcOpenLogHandle", discard_const_p(char *, kwnames), &py_channel, &py_flags)) {
		return false;
	}

	r->in.channel = talloc_ptrtype(r, r->in.channel);
	if (PyUnicode_Check(py_channel)) {
		r->in.channel = PyString_AS_STRING(PyUnicode_AsEncodedString(py_channel, "utf-8", "ignore"));
	} else if (PyString_Check(py_channel)) {
		r->in.channel = PyString_AS_STRING(py_channel);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_channel)->tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcOpenLogHandle_args_out(struct eventlog6_EvtRpcOpenLogHandle *r)
{
	PyObject *result;
	PyObject *py_handle;
	PyObject *py_error;
	result = PyTuple_New(2);
	py_handle = py_talloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	PyTuple_SetItem(result, 0, py_handle);
	py_error = py_talloc_reference_ex(&eventlog6_RpcInfo_Type, r->out.error, r->out.error);
	PyTuple_SetItem(result, 1, py_error);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcGetLogFileInfo_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcGetLogFileInfo *r)
{
	PyObject *py_logHandle;
	PyObject *py_propertyId;
	PyObject *py_propertyValueBufferSize;
	const char *kwnames[] = {
		"logHandle", "propertyId", "propertyValueBufferSize", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:eventlog6_EvtRpcGetLogFileInfo", discard_const_p(char *, kwnames), &py_logHandle, &py_propertyId, &py_propertyValueBufferSize)) {
		return false;
	}

	r->in.logHandle = talloc_ptrtype(r, r->in.logHandle);
	PY_CHECK_TYPE(policy_handle_Type, py_logHandle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_logHandle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.logHandle = (struct policy_handle *)py_talloc_get_ptr(py_logHandle);
	PY_CHECK_TYPE(&PyInt_Type, py_propertyId, return false;);
	r->in.propertyId = PyInt_AsLong(py_propertyId);
	PY_CHECK_TYPE(&PyInt_Type, py_propertyValueBufferSize, return false;);
	r->in.propertyValueBufferSize = PyInt_AsLong(py_propertyValueBufferSize);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcGetLogFileInfo_args_out(struct eventlog6_EvtRpcGetLogFileInfo *r)
{
	PyObject *result;
	PyObject *py_propertyValueBuffer;
	PyObject *py_propertyValueBufferLength;
	result = PyTuple_New(2);
	py_propertyValueBuffer = PyList_New(r->in.propertyValueBufferSize);
	if (py_propertyValueBuffer == NULL) {
		return NULL;
	}
	{
		int propertyValueBuffer_cntr_1;
		for (propertyValueBuffer_cntr_1 = 0; propertyValueBuffer_cntr_1 < r->in.propertyValueBufferSize; propertyValueBuffer_cntr_1++) {
			PyObject *py_propertyValueBuffer_1;
			py_propertyValueBuffer_1 = PyInt_FromLong(r->out.propertyValueBuffer[propertyValueBuffer_cntr_1]);
			PyList_SetItem(py_propertyValueBuffer, propertyValueBuffer_cntr_1, py_propertyValueBuffer_1);
		}
	}
	PyTuple_SetItem(result, 0, py_propertyValueBuffer);
	py_propertyValueBufferLength = PyInt_FromLong(*r->out.propertyValueBufferLength);
	PyTuple_SetItem(result, 1, py_propertyValueBufferLength);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcGetChannelList_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcGetChannelList *r)
{
	PyObject *py_flags;
	const char *kwnames[] = {
		"flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:eventlog6_EvtRpcGetChannelList", discard_const_p(char *, kwnames), &py_flags)) {
		return false;
	}

	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcGetChannelList_args_out(struct eventlog6_EvtRpcGetChannelList *r)
{
	PyObject *result;
	PyObject *py_numChannelPaths;
	PyObject *py_channelPaths;
	result = PyTuple_New(2);
	py_numChannelPaths = PyInt_FromLong(*r->out.numChannelPaths);
	PyTuple_SetItem(result, 0, py_numChannelPaths);
	if (*r->out.channelPaths == NULL) {
		py_channelPaths = Py_None;
		Py_INCREF(py_channelPaths);
	} else {
		py_channelPaths = PyList_New(*r->out.numChannelPaths);
		if (py_channelPaths == NULL) {
			return NULL;
		}
		{
			int channelPaths_cntr_2;
			for (channelPaths_cntr_2 = 0; channelPaths_cntr_2 < *r->out.numChannelPaths; channelPaths_cntr_2++) {
				PyObject *py_channelPaths_2;
				if (*r->out.channelPaths[channelPaths_cntr_2] == NULL) {
					py_channelPaths_2 = Py_None;
					Py_INCREF(py_channelPaths_2);
				} else {
					if (*r->out.channelPaths[channelPaths_cntr_2] == NULL) {
						py_channelPaths_2 = Py_None;
						Py_INCREF(py_channelPaths_2);
					} else {
						py_channelPaths_2 = PyUnicode_Decode(*r->out.channelPaths[channelPaths_cntr_2], strlen(*r->out.channelPaths[channelPaths_cntr_2]), "utf-8", "ignore");
					}
				}
				PyList_SetItem(py_channelPaths, channelPaths_cntr_2, py_channelPaths_2);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_channelPaths);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcGetChannelConfig_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcGetChannelConfig *r)
{
	PyObject *py_channelPath;
	PyObject *py_flags;
	const char *kwnames[] = {
		"channelPath", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:eventlog6_EvtRpcGetChannelConfig", discard_const_p(char *, kwnames), &py_channelPath, &py_flags)) {
		return false;
	}

	r->in.channelPath = talloc_ptrtype(r, r->in.channelPath);
	if (PyUnicode_Check(py_channelPath)) {
		r->in.channelPath = PyString_AS_STRING(PyUnicode_AsEncodedString(py_channelPath, "utf-8", "ignore"));
	} else if (PyString_Check(py_channelPath)) {
		r->in.channelPath = PyString_AS_STRING(py_channelPath);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_channelPath)->tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcGetChannelConfig_args_out(struct eventlog6_EvtRpcGetChannelConfig *r)
{
	PyObject *result;
	PyObject *py_props;
	py_props = py_talloc_reference_ex(&eventlog6_EvtRpcVariantList_Type, r->out.props, r->out.props);
	result = py_props;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcPutChannelConfig_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcPutChannelConfig *r)
{
	PyObject *py_channelPath;
	PyObject *py_flags;
	PyObject *py_props;
	const char *kwnames[] = {
		"channelPath", "flags", "props", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:eventlog6_EvtRpcPutChannelConfig", discard_const_p(char *, kwnames), &py_channelPath, &py_flags, &py_props)) {
		return false;
	}

	r->in.channelPath = talloc_ptrtype(r, r->in.channelPath);
	if (PyUnicode_Check(py_channelPath)) {
		r->in.channelPath = PyString_AS_STRING(PyUnicode_AsEncodedString(py_channelPath, "utf-8", "ignore"));
	} else if (PyString_Check(py_channelPath)) {
		r->in.channelPath = PyString_AS_STRING(py_channelPath);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_channelPath)->tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	r->in.props = talloc_ptrtype(r, r->in.props);
	PY_CHECK_TYPE(&eventlog6_EvtRpcVariantList_Type, py_props, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_props)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.props = (struct eventlog6_EvtRpcVariantList *)py_talloc_get_ptr(py_props);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcPutChannelConfig_args_out(struct eventlog6_EvtRpcPutChannelConfig *r)
{
	PyObject *result;
	PyObject *py_error;
	py_error = py_talloc_reference_ex(&eventlog6_RpcInfo_Type, r->out.error, r->out.error);
	result = py_error;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcGetPublisherList_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcGetPublisherList *r)
{
	PyObject *py_flags;
	const char *kwnames[] = {
		"flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:eventlog6_EvtRpcGetPublisherList", discard_const_p(char *, kwnames), &py_flags)) {
		return false;
	}

	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcGetPublisherList_args_out(struct eventlog6_EvtRpcGetPublisherList *r)
{
	PyObject *result;
	PyObject *py_numPublisherIds;
	PyObject *py_publisherIds;
	result = PyTuple_New(2);
	py_numPublisherIds = PyInt_FromLong(*r->out.numPublisherIds);
	PyTuple_SetItem(result, 0, py_numPublisherIds);
	if (*r->out.publisherIds == NULL) {
		py_publisherIds = Py_None;
		Py_INCREF(py_publisherIds);
	} else {
		py_publisherIds = PyList_New(*r->out.numPublisherIds);
		if (py_publisherIds == NULL) {
			return NULL;
		}
		{
			int publisherIds_cntr_2;
			for (publisherIds_cntr_2 = 0; publisherIds_cntr_2 < *r->out.numPublisherIds; publisherIds_cntr_2++) {
				PyObject *py_publisherIds_2;
				if (*r->out.publisherIds[publisherIds_cntr_2] == NULL) {
					py_publisherIds_2 = Py_None;
					Py_INCREF(py_publisherIds_2);
				} else {
					if (*r->out.publisherIds[publisherIds_cntr_2] == NULL) {
						py_publisherIds_2 = Py_None;
						Py_INCREF(py_publisherIds_2);
					} else {
						py_publisherIds_2 = PyUnicode_Decode(*r->out.publisherIds[publisherIds_cntr_2], strlen(*r->out.publisherIds[publisherIds_cntr_2]), "utf-8", "ignore");
					}
				}
				PyList_SetItem(py_publisherIds, publisherIds_cntr_2, py_publisherIds_2);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_publisherIds);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcGetPublisherListForChannel_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcGetPublisherListForChannel *r)
{
	PyObject *py_channelName;
	PyObject *py_flags;
	const char *kwnames[] = {
		"channelName", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:eventlog6_EvtRpcGetPublisherListForChannel", discard_const_p(char *, kwnames), &py_channelName, &py_flags)) {
		return false;
	}

	r->in.channelName = talloc_ptrtype(r, r->in.channelName);
	PY_CHECK_TYPE(&PyInt_Type, py_channelName, return false;);
	*r->in.channelName = PyInt_AsLong(py_channelName);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcGetPublisherListForChannel_args_out(struct eventlog6_EvtRpcGetPublisherListForChannel *r)
{
	PyObject *result;
	PyObject *py_numPublisherIds;
	PyObject *py_publisherIds;
	result = PyTuple_New(2);
	py_numPublisherIds = PyInt_FromLong(*r->out.numPublisherIds);
	PyTuple_SetItem(result, 0, py_numPublisherIds);
	if (*r->out.publisherIds == NULL) {
		py_publisherIds = Py_None;
		Py_INCREF(py_publisherIds);
	} else {
		py_publisherIds = PyList_New(*r->out.numPublisherIds);
		if (py_publisherIds == NULL) {
			return NULL;
		}
		{
			int publisherIds_cntr_2;
			for (publisherIds_cntr_2 = 0; publisherIds_cntr_2 < *r->out.numPublisherIds; publisherIds_cntr_2++) {
				PyObject *py_publisherIds_2;
				if (*r->out.publisherIds[publisherIds_cntr_2] == NULL) {
					py_publisherIds_2 = Py_None;
					Py_INCREF(py_publisherIds_2);
				} else {
					if (*r->out.publisherIds[publisherIds_cntr_2] == NULL) {
						py_publisherIds_2 = Py_None;
						Py_INCREF(py_publisherIds_2);
					} else {
						py_publisherIds_2 = PyUnicode_Decode(*r->out.publisherIds[publisherIds_cntr_2], strlen(*r->out.publisherIds[publisherIds_cntr_2]), "utf-8", "ignore");
					}
				}
				PyList_SetItem(py_publisherIds, publisherIds_cntr_2, py_publisherIds_2);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_publisherIds);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcGetPublisherMetadata_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcGetPublisherMetadata *r)
{
	PyObject *py_publisherId;
	PyObject *py_logFilePath;
	PyObject *py_locale;
	PyObject *py_flags;
	const char *kwnames[] = {
		"publisherId", "logFilePath", "locale", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:eventlog6_EvtRpcGetPublisherMetadata", discard_const_p(char *, kwnames), &py_publisherId, &py_logFilePath, &py_locale, &py_flags)) {
		return false;
	}

	if (py_publisherId == Py_None) {
		r->in.publisherId = NULL;
	} else {
		r->in.publisherId = NULL;
		if (PyUnicode_Check(py_publisherId)) {
			r->in.publisherId = PyString_AS_STRING(PyUnicode_AsEncodedString(py_publisherId, "utf-8", "ignore"));
		} else if (PyString_Check(py_publisherId)) {
			r->in.publisherId = PyString_AS_STRING(py_publisherId);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_publisherId)->tp_name);
			return false;
		}
	}
	if (py_logFilePath == Py_None) {
		r->in.logFilePath = NULL;
	} else {
		r->in.logFilePath = NULL;
		if (PyUnicode_Check(py_logFilePath)) {
			r->in.logFilePath = PyString_AS_STRING(PyUnicode_AsEncodedString(py_logFilePath, "utf-8", "ignore"));
		} else if (PyString_Check(py_logFilePath)) {
			r->in.logFilePath = PyString_AS_STRING(py_logFilePath);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_logFilePath)->tp_name);
			return false;
		}
	}
	PY_CHECK_TYPE(&PyInt_Type, py_locale, return false;);
	r->in.locale = PyInt_AsLong(py_locale);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcGetPublisherMetadata_args_out(struct eventlog6_EvtRpcGetPublisherMetadata *r)
{
	PyObject *result;
	PyObject *py_pubMetadataProps;
	PyObject *py_pubMetadata;
	result = PyTuple_New(2);
	py_pubMetadataProps = py_talloc_reference_ex(&eventlog6_EvtRpcVariantList_Type, r->out.pubMetadataProps, r->out.pubMetadataProps);
	PyTuple_SetItem(result, 0, py_pubMetadataProps);
	py_pubMetadata = py_talloc_reference_ex(policy_handle_Type, r->out.pubMetadata, r->out.pubMetadata);
	PyTuple_SetItem(result, 1, py_pubMetadata);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcGetPublisherResourceMetadata_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcGetPublisherResourceMetadata *r)
{
	PyObject *py_handle;
	PyObject *py_propertyId;
	PyObject *py_flags;
	const char *kwnames[] = {
		"handle", "propertyId", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:eventlog6_EvtRpcGetPublisherResourceMetadata", discard_const_p(char *, kwnames), &py_handle, &py_propertyId, &py_flags)) {
		return false;
	}

	r->in.handle = talloc_ptrtype(r, r->in.handle);
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)py_talloc_get_ptr(py_handle);
	PY_CHECK_TYPE(&PyInt_Type, py_propertyId, return false;);
	r->in.propertyId = PyInt_AsLong(py_propertyId);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcGetPublisherResourceMetadata_args_out(struct eventlog6_EvtRpcGetPublisherResourceMetadata *r)
{
	PyObject *result;
	PyObject *py_pubMetadataProps;
	py_pubMetadataProps = py_talloc_reference_ex(&eventlog6_EvtRpcVariantList_Type, r->out.pubMetadataProps, r->out.pubMetadataProps);
	result = py_pubMetadataProps;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcGetEventMetadataEnum_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcGetEventMetadataEnum *r)
{
	PyObject *py_pubMetadata;
	PyObject *py_flags;
	PyObject *py_reservedForFilter;
	const char *kwnames[] = {
		"pubMetadata", "flags", "reservedForFilter", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:eventlog6_EvtRpcGetEventMetadataEnum", discard_const_p(char *, kwnames), &py_pubMetadata, &py_flags, &py_reservedForFilter)) {
		return false;
	}

	r->in.pubMetadata = talloc_ptrtype(r, r->in.pubMetadata);
	PY_CHECK_TYPE(policy_handle_Type, py_pubMetadata, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_pubMetadata)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.pubMetadata = (struct policy_handle *)py_talloc_get_ptr(py_pubMetadata);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	if (py_reservedForFilter == Py_None) {
		r->in.reservedForFilter = NULL;
	} else {
		r->in.reservedForFilter = NULL;
		if (PyUnicode_Check(py_reservedForFilter)) {
			r->in.reservedForFilter = PyString_AS_STRING(PyUnicode_AsEncodedString(py_reservedForFilter, "utf-8", "ignore"));
		} else if (PyString_Check(py_reservedForFilter)) {
			r->in.reservedForFilter = PyString_AS_STRING(py_reservedForFilter);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_reservedForFilter)->tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcGetEventMetadataEnum_args_out(struct eventlog6_EvtRpcGetEventMetadataEnum *r)
{
	PyObject *result;
	PyObject *py_eventMetaDataEnum;
	py_eventMetaDataEnum = py_talloc_reference_ex(policy_handle_Type, r->out.eventMetaDataEnum, r->out.eventMetaDataEnum);
	result = py_eventMetaDataEnum;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcGetNextEventMetadata_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcGetNextEventMetadata *r)
{
	PyObject *py_eventMetaDataEnum;
	PyObject *py_flags;
	PyObject *py_numRequested;
	const char *kwnames[] = {
		"eventMetaDataEnum", "flags", "numRequested", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:eventlog6_EvtRpcGetNextEventMetadata", discard_const_p(char *, kwnames), &py_eventMetaDataEnum, &py_flags, &py_numRequested)) {
		return false;
	}

	r->in.eventMetaDataEnum = talloc_ptrtype(r, r->in.eventMetaDataEnum);
	PY_CHECK_TYPE(policy_handle_Type, py_eventMetaDataEnum, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_eventMetaDataEnum)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.eventMetaDataEnum = (struct policy_handle *)py_talloc_get_ptr(py_eventMetaDataEnum);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	PY_CHECK_TYPE(&PyInt_Type, py_numRequested, return false;);
	r->in.numRequested = PyInt_AsLong(py_numRequested);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcGetNextEventMetadata_args_out(struct eventlog6_EvtRpcGetNextEventMetadata *r)
{
	PyObject *result;
	PyObject *py_numReturned;
	PyObject *py_eventMetadataInstances;
	result = PyTuple_New(2);
	py_numReturned = PyInt_FromLong(*r->out.numReturned);
	PyTuple_SetItem(result, 0, py_numReturned);
	if (*r->out.eventMetadataInstances == NULL) {
		py_eventMetadataInstances = Py_None;
		Py_INCREF(py_eventMetadataInstances);
	} else {
		py_eventMetadataInstances = PyList_New(*r->out.numReturned);
		if (py_eventMetadataInstances == NULL) {
			return NULL;
		}
		{
			int eventMetadataInstances_cntr_2;
			for (eventMetadataInstances_cntr_2 = 0; eventMetadataInstances_cntr_2 < *r->out.numReturned; eventMetadataInstances_cntr_2++) {
				PyObject *py_eventMetadataInstances_2;
				py_eventMetadataInstances_2 = py_talloc_reference_ex(&eventlog6_EvtRpcVariantList_Type, *r->out.eventMetadataInstances, r->out.eventMetadataInstances[eventMetadataInstances_cntr_2]);
				PyList_SetItem(py_eventMetadataInstances, eventMetadataInstances_cntr_2, py_eventMetadataInstances_2);
			}
		}
	}
	PyTuple_SetItem(result, 1, py_eventMetadataInstances);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_eventlog6_EvtRpcGetClassicLogDisplayName_args_in(PyObject *args, PyObject *kwargs, struct eventlog6_EvtRpcGetClassicLogDisplayName *r)
{
	PyObject *py_logName;
	PyObject *py_locale;
	PyObject *py_flags;
	const char *kwnames[] = {
		"logName", "locale", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:eventlog6_EvtRpcGetClassicLogDisplayName", discard_const_p(char *, kwnames), &py_logName, &py_locale, &py_flags)) {
		return false;
	}

	r->in.logName = talloc_ptrtype(r, r->in.logName);
	if (PyUnicode_Check(py_logName)) {
		r->in.logName = PyString_AS_STRING(PyUnicode_AsEncodedString(py_logName, "utf-8", "ignore"));
	} else if (PyString_Check(py_logName)) {
		r->in.logName = PyString_AS_STRING(py_logName);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(py_logName)->tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_locale, return false;);
	r->in.locale = PyInt_AsLong(py_locale);
	PY_CHECK_TYPE(&PyInt_Type, py_flags, return false;);
	r->in.flags = PyInt_AsLong(py_flags);
	return true;
}

static PyObject *unpack_py_eventlog6_EvtRpcGetClassicLogDisplayName_args_out(struct eventlog6_EvtRpcGetClassicLogDisplayName *r)
{
	PyObject *result;
	PyObject *py_displayName;
	if (*r->out.displayName == NULL) {
		py_displayName = Py_None;
		Py_INCREF(py_displayName);
	} else {
		py_displayName = PyInt_FromLong(**r->out.displayName);
	}
	result = py_displayName;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_eventlog6_methods[] = {
	{ "EvtRpcRegisterRemoteSubscription", "S.EvtRpcRegisterRemoteSubscription(channelPath, query, bookmarkXml, flags) -> (handle, control, queryChannelInfoSize, queryChannelInfo, error)", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcRegisterRemoteSubscription_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcRegisterRemoteSubscription_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcRegisterRemoteSubscription_args_out, 0, &ndr_table_eventlog6 },
	{ "EvtRpcRemoteSubscriptionNextAsync", "S.EvtRpcRemoteSubscriptionNextAsync(handle, numRequestedRecords, flags) -> (numActualRecords, eventDataIndices, eventDataSizes, resultBufferSize, resultBuffer)", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcRemoteSubscriptionNextAsync_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcRemoteSubscriptionNextAsync_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcRemoteSubscriptionNextAsync_args_out, 1, &ndr_table_eventlog6 },
	{ "EvtRpcRemoteSubscriptionNext", "S.EvtRpcRemoteSubscriptionNext(handle, numRequestedRecords, timeOut, flags) -> (numActualRecords, eventDataIndices, eventDataSizes, resultBufferSize, resultBuffer)", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcRemoteSubscriptionNext_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcRemoteSubscriptionNext_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcRemoteSubscriptionNext_args_out, 2, &ndr_table_eventlog6 },
	{ "EvtRpcRemoteSubscriptionWaitAsync", "S.EvtRpcRemoteSubscriptionWaitAsync(handle) -> None", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcRemoteSubscriptionWaitAsync_args_out, 3, &ndr_table_eventlog6 },
	{ "EvtRpcRegisterControllableOperation", "S.EvtRpcRegisterControllableOperation() -> handle", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcRegisterControllableOperation_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcRegisterControllableOperation_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcRegisterControllableOperation_args_out, 4, &ndr_table_eventlog6 },
	{ "EvtRpcRegisterLogQuery", "S.EvtRpcRegisterLogQuery(path, query, flags) -> (handle, opControl, queryChannelInfoSize, queryChannelInfo, error)", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcRegisterLogQuery_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcRegisterLogQuery_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcRegisterLogQuery_args_out, 5, &ndr_table_eventlog6 },
	{ "EvtRpcClearLog", "S.EvtRpcClearLog(control, channelPath, backupPath, flags) -> error", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcClearLog_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcClearLog_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcClearLog_args_out, 6, &ndr_table_eventlog6 },
	{ "EvtRpcExportLog", "S.EvtRpcExportLog(control, channelPath, query, backupPath, flags) -> error", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcExportLog_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcExportLog_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcExportLog_args_out, 7, &ndr_table_eventlog6 },
	{ "EvtRpcLocalizeExportLog", "S.EvtRpcLocalizeExportLog(control, logFilePath, locale, flags) -> error", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcLocalizeExportLog_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcLocalizeExportLog_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcLocalizeExportLog_args_out, 8, &ndr_table_eventlog6 },
	{ "EvtRpcMessageRender", "S.EvtRpcMessageRender(pubCfgObj, eventId, messageId, values, flags, maxSizeString) -> (actualSizeString, neededSizeString, string, error)", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcMessageRender_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcMessageRender_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcMessageRender_args_out, 9, &ndr_table_eventlog6 },
	{ "EvtRpcMessageRenderDefault", "S.EvtRpcMessageRenderDefault(eventId, messageId, values, flags, maxSizeString) -> (actualSizeString, neededSizeString, string, error)", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcMessageRenderDefault_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcMessageRenderDefault_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcMessageRenderDefault_args_out, 10, &ndr_table_eventlog6 },
	{ "EvtRpcQueryNext", "S.EvtRpcQueryNext(logQuery, numRequestedRecords, timeOutEnd, flags) -> (numActualRecords, eventDataIndices, eventDataSizes, resultBufferSize, resultBuffer)", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcQueryNext_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcQueryNext_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcQueryNext_args_out, 11, &ndr_table_eventlog6 },
	{ "EvtRpcQuerySeek", "S.EvtRpcQuerySeek(logQuery, pos, bookmarkXml, timeOut, flags) -> error", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcQuerySeek_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcQuerySeek_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcQuerySeek_args_out, 12, &ndr_table_eventlog6 },
	{ "EvtRpcClose", "S.EvtRpcClose(handle) -> handle", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcClose_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcClose_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcClose_args_out, 13, &ndr_table_eventlog6 },
	{ "EvtRpcCancel", "S.EvtRpcCancel(handle) -> None", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcCancel_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcCancel_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcCancel_args_out, 14, &ndr_table_eventlog6 },
	{ "EvtRpcAssertConfig", "S.EvtRpcAssertConfig(path, flags) -> None", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcAssertConfig_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcAssertConfig_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcAssertConfig_args_out, 15, &ndr_table_eventlog6 },
	{ "EvtRpcRetractConfig", "S.EvtRpcRetractConfig(path, flags) -> None", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcRetractConfig_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcRetractConfig_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcRetractConfig_args_out, 16, &ndr_table_eventlog6 },
	{ "EvtRpcOpenLogHandle", "S.EvtRpcOpenLogHandle(channel, flags) -> (handle, error)", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcOpenLogHandle_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcOpenLogHandle_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcOpenLogHandle_args_out, 17, &ndr_table_eventlog6 },
	{ "EvtRpcGetLogFileInfo", "S.EvtRpcGetLogFileInfo(logHandle, propertyId, propertyValueBufferSize) -> (propertyValueBuffer, propertyValueBufferLength)", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcGetLogFileInfo_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcGetLogFileInfo_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcGetLogFileInfo_args_out, 18, &ndr_table_eventlog6 },
	{ "EvtRpcGetChannelList", "S.EvtRpcGetChannelList(flags) -> (numChannelPaths, channelPaths)", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcGetChannelList_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcGetChannelList_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcGetChannelList_args_out, 19, &ndr_table_eventlog6 },
	{ "EvtRpcGetChannelConfig", "S.EvtRpcGetChannelConfig(channelPath, flags) -> props", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcGetChannelConfig_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcGetChannelConfig_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcGetChannelConfig_args_out, 20, &ndr_table_eventlog6 },
	{ "EvtRpcPutChannelConfig", "S.EvtRpcPutChannelConfig(channelPath, flags, props) -> error", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcPutChannelConfig_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcPutChannelConfig_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcPutChannelConfig_args_out, 21, &ndr_table_eventlog6 },
	{ "EvtRpcGetPublisherList", "S.EvtRpcGetPublisherList(flags) -> (numPublisherIds, publisherIds)", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcGetPublisherList_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcGetPublisherList_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcGetPublisherList_args_out, 22, &ndr_table_eventlog6 },
	{ "EvtRpcGetPublisherListForChannel", "S.EvtRpcGetPublisherListForChannel(channelName, flags) -> (numPublisherIds, publisherIds)", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcGetPublisherListForChannel_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcGetPublisherListForChannel_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcGetPublisherListForChannel_args_out, 23, &ndr_table_eventlog6 },
	{ "EvtRpcGetPublisherMetadata", "S.EvtRpcGetPublisherMetadata(publisherId, logFilePath, locale, flags) -> (pubMetadataProps, pubMetadata)", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcGetPublisherMetadata_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcGetPublisherMetadata_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcGetPublisherMetadata_args_out, 24, &ndr_table_eventlog6 },
	{ "EvtRpcGetPublisherResourceMetadata", "S.EvtRpcGetPublisherResourceMetadata(handle, propertyId, flags) -> pubMetadataProps", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcGetPublisherResourceMetadata_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcGetPublisherResourceMetadata_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcGetPublisherResourceMetadata_args_out, 25, &ndr_table_eventlog6 },
	{ "EvtRpcGetEventMetadataEnum", "S.EvtRpcGetEventMetadataEnum(pubMetadata, flags, reservedForFilter) -> eventMetaDataEnum", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcGetEventMetadataEnum_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcGetEventMetadataEnum_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcGetEventMetadataEnum_args_out, 26, &ndr_table_eventlog6 },
	{ "EvtRpcGetNextEventMetadata", "S.EvtRpcGetNextEventMetadata(eventMetaDataEnum, flags, numRequested) -> (numReturned, eventMetadataInstances)", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcGetNextEventMetadata_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcGetNextEventMetadata_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcGetNextEventMetadata_args_out, 27, &ndr_table_eventlog6 },
	{ "EvtRpcGetClassicLogDisplayName", "S.EvtRpcGetClassicLogDisplayName(logName, locale, flags) -> displayName", (py_dcerpc_call_fn)dcerpc_eventlog6_EvtRpcGetClassicLogDisplayName_r, (py_data_pack_fn)pack_py_eventlog6_EvtRpcGetClassicLogDisplayName_args_in, (py_data_unpack_fn)unpack_py_eventlog6_EvtRpcGetClassicLogDisplayName_args_out, 28, &ndr_table_eventlog6 },
	{ NULL }
};

static PyObject *interface_eventlog6_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_eventlog6);
}

#define PY_DOC_EVENTLOG6 "Eventlog6"
static PyTypeObject eventlog6_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "eventlog6.eventlog6",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "eventlog6(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_EVENTLOG6,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_eventlog6_new,
};

static PyMethodDef eventlog6_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initeventlog6(void)
{
	PyObject *m;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_misc;
	PyObject *dep_samba_dcerpc_base;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	policy_handle_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "policy_handle");
	if (policy_handle_Type == NULL)
		return;

	eventlog6_RpcInfo_Type.tp_base = Object_Type;

	eventlog6_boolean8Array_Type.tp_base = Object_Type;

	eventlog6_UInt32Array_Type.tp_base = Object_Type;

	eventlog6_UInt64Array_Type.tp_base = Object_Type;

	eventlog6_StringArray_Type.tp_base = Object_Type;

	eventlog6_GuidArray_Type.tp_base = Object_Type;

	eventlog6_EvtRpcVariant_Type.tp_base = Object_Type;

	eventlog6_EvtRpcVariantList_Type.tp_base = Object_Type;

	eventlog6_EvtRpcQueryChannelInfo_Type.tp_base = Object_Type;

	eventlog6_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&eventlog6_RpcInfo_Type) < 0)
		return;
	if (PyType_Ready(&eventlog6_boolean8Array_Type) < 0)
		return;
	if (PyType_Ready(&eventlog6_UInt32Array_Type) < 0)
		return;
	if (PyType_Ready(&eventlog6_UInt64Array_Type) < 0)
		return;
	if (PyType_Ready(&eventlog6_StringArray_Type) < 0)
		return;
	if (PyType_Ready(&eventlog6_GuidArray_Type) < 0)
		return;
	if (PyType_Ready(&eventlog6_EvtRpcVariant_Type) < 0)
		return;
	if (PyType_Ready(&eventlog6_EvtRpcVariantList_Type) < 0)
		return;
	if (PyType_Ready(&eventlog6_EvtRpcQueryChannelInfo_Type) < 0)
		return;
	if (PyType_Ready(&eventlog6_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&eventlog6_InterfaceType, py_ndr_eventlog6_methods))
		return;

#ifdef PY_RPCINFO_PATCH
	PY_RPCINFO_PATCH(&eventlog6_RpcInfo_Type);
#endif
#ifdef PY_BOOLEAN8ARRAY_PATCH
	PY_BOOLEAN8ARRAY_PATCH(&eventlog6_boolean8Array_Type);
#endif
#ifdef PY_UINT32ARRAY_PATCH
	PY_UINT32ARRAY_PATCH(&eventlog6_UInt32Array_Type);
#endif
#ifdef PY_UINT64ARRAY_PATCH
	PY_UINT64ARRAY_PATCH(&eventlog6_UInt64Array_Type);
#endif
#ifdef PY_STRINGARRAY_PATCH
	PY_STRINGARRAY_PATCH(&eventlog6_StringArray_Type);
#endif
#ifdef PY_GUIDARRAY_PATCH
	PY_GUIDARRAY_PATCH(&eventlog6_GuidArray_Type);
#endif
#ifdef PY_EVTRPCVARIANT_PATCH
	PY_EVTRPCVARIANT_PATCH(&eventlog6_EvtRpcVariant_Type);
#endif
#ifdef PY_EVTRPCVARIANTLIST_PATCH
	PY_EVTRPCVARIANTLIST_PATCH(&eventlog6_EvtRpcVariantList_Type);
#endif
#ifdef PY_EVTRPCQUERYCHANNELINFO_PATCH
	PY_EVTRPCQUERYCHANNELINFO_PATCH(&eventlog6_EvtRpcQueryChannelInfo_Type);
#endif
#ifdef PY_EVENTLOG6_PATCH
	PY_EVENTLOG6_PATCH(&eventlog6_InterfaceType);
#endif

	m = Py_InitModule3("eventlog6", eventlog6_methods, "eventlog6 DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "EvtRpcVarTypeStringArray", PyInt_FromLong(EvtRpcVarTypeStringArray));
	PyModule_AddObject(m, "MAX_RPC_PROPERTY_BUFFER_SIZE", PyInt_FromLong(MAX_PAYLOAD));
	PyModule_AddObject(m, "EvtRpcVarTypeboolean8Array", PyInt_FromLong(EvtRpcVarTypeboolean8Array));
	PyModule_AddObject(m, "MAX_RPC_FILE_PATH_LENGTH", PyInt_FromLong(32768));
	PyModule_AddObject(m, "MAX_RPC_CHANNEL_NAME_LENGTH", PyInt_FromLong(512));
	PyModule_AddObject(m, "EvtRpcVarTypeUInt64", PyInt_FromLong(EvtRpcVarTypeUInt64));
	PyModule_AddObject(m, "EvtRpcVarTypeNull", PyInt_FromLong(EvtRpcVarTypeNull));
	PyModule_AddObject(m, "EvtRpcVarTypeboolean8", PyInt_FromLong(EvtRpcVarTypeboolean8));
	PyModule_AddObject(m, "MAX_RPC_FILTER_LENGTH", PyInt_FromLong(MAX_RPC_QUERY_LENGTH));
	PyModule_AddObject(m, "MAX_RPC_RENDERED_STRING_SIZE", PyInt_FromLong(MAX_PAYLOAD));
	PyModule_AddObject(m, "MAX_RPC_PUBLISHER_COUNT", PyInt_FromLong(8192));
	PyModule_AddObject(m, "MAX_RPC_QUERY_LENGTH", PyInt_FromLong(MAX_PAYLOAD/sizeof(uint16_t)));
	PyModule_AddObject(m, "MAX_RPC_VARIANT_LIST_COUNT", PyInt_FromLong(256));
	PyModule_AddObject(m, "MAX_RPC_STRING_LENGTH", PyInt_FromLong(MAX_PAYLOAD/sizeof(uint16_t)));
	PyModule_AddObject(m, "MAX_PAYLOAD", PyInt_FromLong(2*1024*1024));
	PyModule_AddObject(m, "EvtRpcVarTypeGuidArray", PyInt_FromLong(EvtRpcVarTypeGuidArray));
	PyModule_AddObject(m, "MAX_RPC_CHANNEL_COUNT", PyInt_FromLong(8192));
	PyModule_AddObject(m, "MAX_RPC_BOOLEAN8_ARRAY_COUNT", PyInt_FromLong(MAX_PAYLOAD/sizeof(uint8_t)));
	PyModule_AddObject(m, "MAX_RPC_EVENT_ID_SIZE", PyInt_FromLong(256));
	PyModule_AddObject(m, "MAX_RPC_UINT32_ARRAY_COUNT", PyInt_FromLong(MAX_PAYLOAD/sizeof(uint32_t)));
	PyModule_AddObject(m, "MAX_RPC_BOOKMARK_LENGTH", PyInt_FromLong(MAX_PAYLOAD/sizeof(uint16_t)));
	PyModule_AddObject(m, "MAX_RPC_EVENT_SIZE", PyInt_FromLong(MAX_PAYLOAD));
	PyModule_AddObject(m, "MAX_RPC_CHANNEL_PATH_LENGTH", PyInt_FromLong(32768));
	PyModule_AddObject(m, "MAX_RPC_UINT64_ARRAY_COUNT", PyInt_FromLong(MAX_PAYLOAD/sizeof(uint64_t)));
	PyModule_AddObject(m, "EvtRpcVarTypeUInt64Array", PyInt_FromLong(EvtRpcVarTypeUInt64Array));
	PyModule_AddObject(m, "EvtRpcChannelPath", PyInt_FromLong(EvtRpcChannelPath));
	PyModule_AddObject(m, "EvtRpcVarTypeUInt32Array", PyInt_FromLong(EvtRpcVarTypeUInt32Array));
	PyModule_AddObject(m, "MAX_RPC_BATCH_SIZE", PyInt_FromLong(MAX_PAYLOAD));
	PyModule_AddObject(m, "MAX_RPC_QUERY_CHANNEL_SIZE", PyInt_FromLong(512));
	PyModule_AddObject(m, "EvtRpcVarTypeString", PyInt_FromLong(EvtRpcVarTypeString));
	PyModule_AddObject(m, "EvtRpcVarTypeGuid", PyInt_FromLong(EvtRpcVarTypeGuid));
	PyModule_AddObject(m, "MAX_RPC_PUBLISHER_ID_LENGTH", PyInt_FromLong(2048));
	PyModule_AddObject(m, "EvtRpcVarTypeUInt32", PyInt_FromLong(EvtRpcVarTypeUInt32));
	PyModule_AddObject(m, "MAX_RPC_RECORD_COUNT", PyInt_FromLong(1024));
	PyModule_AddObject(m, "MAX_RPC_EVENT_METADATA_COUNT", PyInt_FromLong(256));
	PyModule_AddObject(m, "EvtRpcPublisherName", PyInt_FromLong(EvtRpcPublisherName));
	PyModule_AddObject(m, "MAX_RPC_STRING_ARRAY_COUNT", PyInt_FromLong(MAX_PAYLOAD/512));
	Py_INCREF((PyObject *)(void *)&eventlog6_RpcInfo_Type);
	PyModule_AddObject(m, "RpcInfo", (PyObject *)(void *)&eventlog6_RpcInfo_Type);
	Py_INCREF((PyObject *)(void *)&eventlog6_boolean8Array_Type);
	PyModule_AddObject(m, "boolean8Array", (PyObject *)(void *)&eventlog6_boolean8Array_Type);
	Py_INCREF((PyObject *)(void *)&eventlog6_UInt32Array_Type);
	PyModule_AddObject(m, "UInt32Array", (PyObject *)(void *)&eventlog6_UInt32Array_Type);
	Py_INCREF((PyObject *)(void *)&eventlog6_UInt64Array_Type);
	PyModule_AddObject(m, "UInt64Array", (PyObject *)(void *)&eventlog6_UInt64Array_Type);
	Py_INCREF((PyObject *)(void *)&eventlog6_StringArray_Type);
	PyModule_AddObject(m, "StringArray", (PyObject *)(void *)&eventlog6_StringArray_Type);
	Py_INCREF((PyObject *)(void *)&eventlog6_GuidArray_Type);
	PyModule_AddObject(m, "GuidArray", (PyObject *)(void *)&eventlog6_GuidArray_Type);
	Py_INCREF((PyObject *)(void *)&eventlog6_EvtRpcVariant_Type);
	PyModule_AddObject(m, "EvtRpcVariant", (PyObject *)(void *)&eventlog6_EvtRpcVariant_Type);
	Py_INCREF((PyObject *)(void *)&eventlog6_EvtRpcVariantList_Type);
	PyModule_AddObject(m, "EvtRpcVariantList", (PyObject *)(void *)&eventlog6_EvtRpcVariantList_Type);
	Py_INCREF((PyObject *)(void *)&eventlog6_EvtRpcQueryChannelInfo_Type);
	PyModule_AddObject(m, "EvtRpcQueryChannelInfo", (PyObject *)(void *)&eventlog6_EvtRpcQueryChannelInfo_Type);
	Py_INCREF((PyObject *)(void *)&eventlog6_InterfaceType);
	PyModule_AddObject(m, "eventlog6", (PyObject *)(void *)&eventlog6_InterfaceType);
#ifdef PY_MOD_EVENTLOG6_PATCH
	PY_MOD_EVENTLOG6_PATCH(m);
#endif

}
