#ifndef FILEOPS_H
#define FILEOPS_H

#include <libgnomevfs/gnome-vfs-types.h>
#include <libgnomevfs/gnome-vfs-file-info.h>

gboolean copy_file( const gchar *source, const gchar *dest );
gboolean copy_dir( const char *source, const gchar *dest, gboolean move );
gboolean move_file( const gchar *source, const gchar *dest );
gboolean delete_file( const gchar *file );
gboolean delete_dir( const gchar *path );
gboolean mkdir_recursive( const gchar *path, GnomeVFSFilePermissions perms );

gchar *relative_path( const gchar *text, const gchar *root );
gchar *relative_to_full( const gchar *relPath, const gchar *base_uri );

gboolean overwrite( const gchar *filename );
gboolean uri_exists( const gchar *filename, GnomeVFSResult *result );

gchar* paths_match( const gchar *base_uri,
		    const gchar *path1, const gchar *path2 );

GString *load_file( const gchar *path );
gboolean save_file( const gchar *path, const gchar *data,
		    GnomeVFSFilePermissions perms );

gboolean screem_uri_is_dir( const gchar *uri );

gchar *screem_create_tmp_file( const gchar *base, const gchar *ext, gboolean tmpdir );
gchar *screem_get_dot_dir( void );

GSList *screem_vfs_scandir( const gchar *dir, 
		     gint (*filter)( const GnomeVFSFileInfo *info ),
		     GCompareFunc compare,
		     gboolean recurse );

#endif
