#ifndef SCREEM_VIEW_H
#define SCREEM_VIEW_H

#include <gtk/gtkbin.h>

#define SCREEM_TYPE_VIEW  (screem_view_get_type())
#define SCREEM_VIEW(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ),   \
                                                SCREEM_TYPE_VIEW, \
                                                ScreemView ) )
#define SCREEM_IS_VIEW(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), \
                                               SCREEM_TYPE_VIEW ) )

#ifndef SCREEM_WINDOW_DEFINED
#define SCREEM_WINDOW_DEFINED
typedef struct ScreemWindow ScreemWindow;
#endif

typedef struct ScreemViewPrivate ScreemViewPrivate;

typedef struct ScreemView ScreemView;

struct ScreemView {
	GtkBin parent;

	void (*window_set)( ScreemView *view );

	void (*display)( ScreemView *view );
	void (*print)( ScreemView *view, gboolean preview );

	void (*undo)( ScreemView *view );
	void (*redo)( ScreemView *view );

	ScreemViewPrivate *private;
};

typedef struct {
	GtkBinClass parent_class;

} ScreemViewClass;


GType screem_view_get_type( void );

void screem_view_display( ScreemView *view );
void screem_view_print( ScreemView *view, gboolean preview );

void screem_view_undo( ScreemView *view );
void screem_view_redo( ScreemView *view );

#endif
