/*  Screem:  screem-main.c
 *
 *  initialisation code, shouldn't do much as most of the init stuff
 *  belongs in screem-application.c
 *
 *  Copyright (C) 2001 David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#include <config.h>
#include <gmodule.h>

#include <libgnome/gnome-i18n.h>
#include <libgnomeui/gnome-ui-init.h>
#include <libgnomeui/gnome-window-icon.h>

#include <gtk/gtkmain.h>

#include <unistd.h>
#include <errno.h>

#include <glade/glade-init.h>
#include <glade/glade.h>

#include <gconf/gconf.h>

#include <libgnomevfs/gnome-vfs.h>

#include "screem-application.h"
#include "screem-session.h"

ScreemApplication *app;

static gchar *session_filename = SESSION_LAST;

/* passed parameters stuff */
static const struct poptOption options[] = {
	{ "load-session", 'l', POPT_ARG_STRING, &session_filename, 0,
	  N_("Load the given session file"),
	  N_("FILE") },
	{ NULL, '\0', 0, NULL, 0, NULL, NULL }
};

static gboolean screem_main_start_app( const gchar **start_files );
static const gchar** parse_args( poptContext ctx, int argc, char *argv[] );

int main( int argc, char *argv[] )
{
	GnomeProgram *program;
	poptContext ctx;
	const gchar** start_files;
	gchar *icon;
	
#ifdef ENABLE_NLS
	/* initialise i18n stuff */
        bindtextdomain( GETTEXT_PACKAGE, GNOMELOCALEDIR );
	bind_textdomain_codeset( GETTEXT_PACKAGE, "UTF-8" );
        textdomain( GETTEXT_PACKAGE );
#endif	

	program = gnome_program_init( PACKAGE, VERSION, LIBGNOMEUI_MODULE,
				      argc, argv,
				      GNOME_PROGRAM_STANDARD_PROPERTIES,
				      GNOME_PARAM_POPT_TABLE, options,
				      GNOME_PARAM_APP_DATADIR, DATADIR,
				      LIBGNOMEUI_PARAM_DEFAULT_ICON,
				      DATADIR"/pixmaps/screem.png",
				      GNOME_PARAM_HUMAN_READABLE_NAME,
				      _( "Site CReation and Editing EnvironMent" ),
				      NULL );

	gdk_threads_init();

	icon = gnome_program_locate_file( NULL, GNOME_FILE_DOMAIN_APP_PIXMAP,
					  "screem.png", TRUE, NULL );
        gnome_window_icon_set_default_from_file( icon );
	g_free( icon );

	app = screem_application_new();
	
	/* parse arguments */
	g_object_get( G_OBJECT( program ), GNOME_PARAM_POPT_CONTEXT, &ctx,
		      NULL );
	start_files = parse_args( ctx, argc, argv );

        gnome_vfs_init();

	glade_require( "gnome" );

	g_idle_add( (GSourceFunc)screem_main_start_app, start_files );

gdk_threads_enter();
	gtk_main();
	gdk_threads_leave();

	poptFreeContext( ctx );	
	
	screem_application_close( app );
	g_object_unref( app );

	gnome_vfs_shutdown();

	g_object_unref( program );
	
	return 0;
}

static gboolean screem_main_start_app( const gchar **start_files )
{
	screem_application_startup( app, session_filename, start_files );

	return FALSE;
}

static const gchar **parse_args( poptContext ctx, int argc, char *argv[] )
{
	const gchar** start_files;

        /* passed arguements */
        start_files = poptGetArgs( ctx );

	return start_files;
}

