#ifndef SCREEM_SITE_VIEW_H
#define SCREEM_SITE_VIEW_H

#include <gtk/gtk.h>

#include "screem-site.h"
#include "screem-window.h"

#define SCREEM_TYPE_SITE_VIEW            (screem_site_view_get_type ())
#define SCREEM_SITE_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_SITE_VIEW, ScreemSiteView))
#define SCREEM_SITE_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_SITE_VIEW, ScreemSiteViewClass))
#define SCREEM_IS_SITE_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_SITE_VIEW))

typedef struct ScreemSiteViewPrivate ScreemSiteViewPrivate;

typedef struct ScreemSiteView ScreemSiteView;

struct ScreemSiteView {
        GtkBin parent;
	
	ScreemSiteViewPrivate *priv;
};

typedef struct {
        GtkBinClass parent_class;

} ScreemSiteViewClass;

GType       screem_site_view_get_type(void);
ScreemSiteView* screem_site_view_new( void );

ScreemWindow *screem_site_view_get_window( ScreemSiteView *view );
void screem_site_view_set_window( ScreemSiteView *view,
		ScreemWindow *window );

ScreemSite *screem_site_view_get_site( ScreemSiteView *view );
void screem_site_view_set_site( ScreemSiteView *view, ScreemSite *site );

#endif
