#!/bin/sh
#
# /etc/rc.d/rc.firewall:  Shoreline Firewall (Shorewall) initialization script.
#
# This script starts both the IPv4 and IPv6 shorewall rules if the respective
# scripts (rc.shorewall and rc.shorewall6) are present and executable

start() {
	if [ -x /etc/rc.d/rc.shorewall ]; then
		/etc/rc.d/rc.shorewall start
	fi
	if [ -x /etc/rc.d/rc.shorewall6 ]; then
		/etc/rc.d/rc.shorewall6 start
	fi
}

stop() {
	if [ -x /etc/rc.d/rc.shorewall ]; then
		/etc/rc.d/rc.shorewall stop
	fi
	if [ -x /etc/rc.d/rc.shorewall6 ]; then
		/etc/rc.d/rc.shorewall6 stop
	fi
}

restart() {
	if [ -x /etc/rc.d/rc.shorewall ]; then
		/etc/rc.d/rc.shorewall restart
	fi
	if [ -x /etc/rc.d/rc.shorewall6 ]; then
		/etc/rc.d/rc.shorewall6 restart
	fi
}

status() {
	if [ -x /etc/rc.d/rc.shorewall ]; then
		/etc/rc.d/rc.shorewall status
	fi
	if [ -x /etc/rc.d/rc.shorewall6 ]; then
		/etc/rc.d/rc.shorewall6 status
	fi
}

case $1 in 
	'start')
		start
	;;
	'stop')
		stop
	;;
	'restart')
		restart
	;;
	'status')
		status
	;;
	*)
		echo "Usage: $0 {start|stop|restart|status}"
		exit 1
	;;
esac

exit 0

