/* CustomComponents.c generated by valac 0.34.7, the Vala compiler
 * generated from CustomComponents.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_THEME_LOADER (theme_loader_get_type ())
#define THEME_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_LOADER, ThemeLoader))
#define THEME_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_LOADER, ThemeLoaderClass))
#define IS_THEME_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_LOADER))
#define IS_THEME_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_LOADER))
#define THEME_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_LOADER, ThemeLoaderClass))

typedef struct _ThemeLoader ThemeLoader;
typedef struct _ThemeLoaderClass ThemeLoaderClass;
typedef struct _ThemeLoaderPrivate ThemeLoaderPrivate;

#define THEME_LOADER_TYPE_LIGHTWEIGHT_COLOR (theme_loader_lightweight_color_get_type ())
typedef struct _ThemeLoaderLightweightColor ThemeLoaderLightweightColor;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define TYPE_RGB_ANALYTIC_PIXEL (rgb_analytic_pixel_get_type ())
typedef struct _RGBAnalyticPixel RGBAnalyticPixel;

#define TYPE_HSV_ANALYTIC_PIXEL (hsv_analytic_pixel_get_type ())
typedef struct _HSVAnalyticPixel HSVAnalyticPixel;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rgb_analytic_pixel_free0(var) ((var == NULL) ? NULL : (var = (rgb_analytic_pixel_free (var), NULL)))
typedef struct _ParamSpecThemeLoader ParamSpecThemeLoader;

#define TYPE_RGB_HISTOGRAM_MANIPULATOR (rgb_histogram_manipulator_get_type ())
#define RGB_HISTOGRAM_MANIPULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulator))
#define RGB_HISTOGRAM_MANIPULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulatorClass))
#define IS_RGB_HISTOGRAM_MANIPULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RGB_HISTOGRAM_MANIPULATOR))
#define IS_RGB_HISTOGRAM_MANIPULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RGB_HISTOGRAM_MANIPULATOR))
#define RGB_HISTOGRAM_MANIPULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulatorClass))

typedef struct _RGBHistogramManipulator RGBHistogramManipulator;
typedef struct _RGBHistogramManipulatorClass RGBHistogramManipulatorClass;
typedef struct _RGBHistogramManipulatorPrivate RGBHistogramManipulatorPrivate;

#define TYPE_RGB_HISTOGRAM (rgb_histogram_get_type ())
#define RGB_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RGB_HISTOGRAM, RGBHistogram))
#define RGB_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RGB_HISTOGRAM, RGBHistogramClass))
#define IS_RGB_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RGB_HISTOGRAM))
#define IS_RGB_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RGB_HISTOGRAM))
#define RGB_HISTOGRAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RGB_HISTOGRAM, RGBHistogramClass))

typedef struct _RGBHistogram RGBHistogram;
typedef struct _RGBHistogramClass RGBHistogramClass;

#define RGB_HISTOGRAM_MANIPULATOR_TYPE_LOCATION_CODE (rgb_histogram_manipulator_location_code_get_type ())
#define _rgb_histogram_unref0(var) ((var == NULL) ? NULL : (var = (rgb_histogram_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ThemeLoader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ThemeLoaderPrivate * priv;
};

struct _ThemeLoaderClass {
	GTypeClass parent_class;
	void (*finalize) (ThemeLoader *self);
};

struct _ThemeLoaderLightweightColor {
	guchar red;
	guchar green;
	guchar blue;
};

struct _RGBAnalyticPixel {
	gfloat red;
	gfloat green;
	gfloat blue;
};

struct _HSVAnalyticPixel {
	gfloat hue;
	gfloat saturation;
	gfloat light_value;
};

struct _ParamSpecThemeLoader {
	GParamSpec parent_instance;
};

struct _RGBHistogramManipulator {
	GtkDrawingArea parent_instance;
	RGBHistogramManipulatorPrivate * priv;
};

struct _RGBHistogramManipulatorClass {
	GtkDrawingAreaClass parent_class;
};

struct _RGBHistogramManipulatorPrivate {
	gint left_nub_max;
	gint right_nub_min;
	RGBHistogram* histogram;
	gint left_nub_position;
	gint right_nub_position;
	GdkPixbuf* nub_pixbuf;
	gboolean is_left_nub_tracking;
	gboolean is_right_nub_tracking;
	gint track_start_x;
	gint track_nub_start_position;
};

typedef enum  {
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA
} RGBHistogramManipulatorLocationCode;


static gpointer theme_loader_parent_class = NULL;
static ThemeLoaderLightweightColor* theme_loader_theme_colors;
static gint theme_loader_theme_colors_length1;
static ThemeLoaderLightweightColor* theme_loader_theme_colors = NULL;
static gint theme_loader_theme_colors_length1 = 0;
static gint _theme_loader_theme_colors_size_ = 0;
static gpointer rgb_histogram_manipulator_parent_class = NULL;
static GtkWidget* rgb_histogram_manipulator_dummy_slider;
static GtkWidget* rgb_histogram_manipulator_dummy_slider = NULL;
static GtkWidget* rgb_histogram_manipulator_dummy_frame;
static GtkWidget* rgb_histogram_manipulator_dummy_frame = NULL;
static GtkWidgetPath* rgb_histogram_manipulator_slider_draw_path;
static GtkWidgetPath* rgb_histogram_manipulator_slider_draw_path = NULL;
static GtkWidgetPath* rgb_histogram_manipulator_frame_draw_path;
static GtkWidgetPath* rgb_histogram_manipulator_frame_draw_path = NULL;
static gboolean rgb_histogram_manipulator_paths_setup;
static gboolean rgb_histogram_manipulator_paths_setup = FALSE;

void qsort (void* p, gsize num, gsize size, GCompareFunc func);
gpointer theme_loader_ref (gpointer instance);
void theme_loader_unref (gpointer instance);
GParamSpec* param_spec_theme_loader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_theme_loader (GValue* value, gpointer v_object);
void value_take_theme_loader (GValue* value, gpointer v_object);
gpointer value_get_theme_loader (const GValue* value);
GType theme_loader_get_type (void) G_GNUC_CONST;
enum  {
	THEME_LOADER_DUMMY_PROPERTY
};
static GType theme_loader_lightweight_color_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ThemeLoaderLightweightColor* theme_loader_lightweight_color_dup (const ThemeLoaderLightweightColor* self);
static void theme_loader_lightweight_color_free (ThemeLoaderLightweightColor* self);
#define THEME_LOADER_NUM_SUPPORTED_INTENSITIES 6
#define THEME_LOADER_THEME_OUTLINE_COLOR 0
#define THEME_LOADER_THEME_BEVEL_DARKER_COLOR 1
#define THEME_LOADER_THEME_BEVEL_DARK_COLOR 2
#define THEME_LOADER_THEME_BASE_COLOR 3
#define THEME_LOADER_THEME_BEVEL_LIGHT_COLOR 4
#define THEME_LOADER_THEME_BEVEL_LIGHTER_COLOR 5
static void theme_loader_populate_theme_params (void);
static GdkColor* _gdk_color_dup (GdkColor* self);
GType rgb_analytic_pixel_get_type (void) G_GNUC_CONST;
RGBAnalyticPixel* rgb_analytic_pixel_dup (const RGBAnalyticPixel* self);
void rgb_analytic_pixel_free (RGBAnalyticPixel* self);
void rgb_analytic_pixel_init_from_quantized_components (RGBAnalyticPixel *self, guchar red_quantized, guchar green_quantized, guchar blue_quantized);
GType hsv_analytic_pixel_get_type (void) G_GNUC_CONST;
HSVAnalyticPixel* hsv_analytic_pixel_dup (const HSVAnalyticPixel* self);
void hsv_analytic_pixel_free (HSVAnalyticPixel* self);
void hsv_analytic_pixel_init_from_rgb (HSVAnalyticPixel *self, RGBAnalyticPixel* p);
void hsv_analytic_pixel_to_rgb (HSVAnalyticPixel *self, RGBAnalyticPixel* result);
static void theme_loader_populate_one_theme_param (RGBAnalyticPixel* from, ThemeLoaderLightweightColor* result);
static void theme_loader_lightweight_color_init (ThemeLoaderLightweightColor *self);
GdkPixbuf* theme_loader_load_icon (const gchar* source_basename);
GdkPixbuf* resources_get_icon (const gchar* name, gint scale);
static guint theme_loader_rgb_pixel_hash_func (RGBAnalyticPixel* pixel_val);
static guint _theme_loader_rgb_pixel_hash_func_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean theme_loader_rgb_pixel_equal_func (RGBAnalyticPixel* p1, RGBAnalyticPixel* p2);
static gboolean _theme_loader_rgb_pixel_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint theme_loader_hsv_pixel_compare_func (void* pixval1, void* pixval2);
static gint _theme_loader_hsv_pixel_compare_func_gcompare_func (gconstpointer a, gconstpointer b);
gboolean rgb_analytic_pixel_equals (RGBAnalyticPixel *self, RGBAnalyticPixel* rhs);
guint rgb_analytic_pixel_hash_code (RGBAnalyticPixel *self);
ThemeLoader* theme_loader_new (void);
ThemeLoader* theme_loader_construct (GType object_type);
static void theme_loader_finalize (ThemeLoader* obj);
GType rgb_histogram_manipulator_get_type (void) G_GNUC_CONST;
gpointer rgb_histogram_ref (gpointer instance);
void rgb_histogram_unref (gpointer instance);
GParamSpec* param_spec_rgb_histogram (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_rgb_histogram (GValue* value, gpointer v_object);
void value_take_rgb_histogram (GValue* value, gpointer v_object);
gpointer value_get_rgb_histogram (const GValue* value);
GType rgb_histogram_get_type (void) G_GNUC_CONST;
#define RGB_HISTOGRAM_MANIPULATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulatorPrivate))
enum  {
	RGB_HISTOGRAM_MANIPULATOR_DUMMY_PROPERTY
};
static GType rgb_histogram_manipulator_location_code_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE 13
#define RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH (RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE / 2)
#define RGB_HISTOGRAM_MANIPULATOR_NUB_V_NUDGE 4
#define RGB_HISTOGRAM_MANIPULATOR_TROUGH_WIDTH (256 + (2 * RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH))
#define RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT 4
#define RGB_HISTOGRAM_MANIPULATOR_TROUGH_BOTTOM_OFFSET 1
#define RGB_HISTOGRAM_MANIPULATOR_CONTROL_WIDTH (RGB_HISTOGRAM_MANIPULATOR_TROUGH_WIDTH + 2)
#define RGB_HISTOGRAM_MANIPULATOR_CONTROL_HEIGHT 118
#define RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION (((((RGB_HISTOGRAM_MANIPULATOR_CONTROL_HEIGHT - RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT) - RGB_HISTOGRAM_MANIPULATOR_TROUGH_BOTTOM_OFFSET) - ((RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE - RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT) / 2)) - RGB_HISTOGRAM_MANIPULATOR_NUB_V_NUDGE) - 2)
RGBHistogramManipulator* rgb_histogram_manipulator_new (void);
RGBHistogramManipulator* rgb_histogram_manipulator_construct (GType object_type);
static gboolean rgb_histogram_manipulator_on_button_press (RGBHistogramManipulator* self, GdkEventButton* event_record);
static gboolean _rgb_histogram_manipulator_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean rgb_histogram_manipulator_on_button_release (RGBHistogramManipulator* self, GdkEventButton* event_record);
static gboolean _rgb_histogram_manipulator_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean rgb_histogram_manipulator_on_button_motion (RGBHistogramManipulator* self, GdkEventMotion* event_record);
static gboolean _rgb_histogram_manipulator_on_button_motion_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static RGBHistogramManipulatorLocationCode rgb_histogram_manipulator_hit_test_point (RGBHistogramManipulator* self, gint x, gint y);
static void rgb_histogram_manipulator_force_update (RGBHistogramManipulator* self);
static void rgb_histogram_manipulator_update_nub_extrema (RGBHistogramManipulator* self);
static gboolean rgb_histogram_manipulator_real_draw (GtkWidget* base, cairo_t* ctx);
#define RGB_HISTOGRAM_GRAPHIC_WIDTH 256
#define RGB_HISTOGRAM_GRAPHIC_HEIGHT 100
static void rgb_histogram_manipulator_draw_histogram_frame (RGBHistogramManipulator* self, cairo_t* ctx, GdkRectangle* area);
static void rgb_histogram_manipulator_draw_histogram (RGBHistogramManipulator* self, cairo_t* ctx, GdkRectangle* area);
static void rgb_histogram_manipulator_draw_trough (RGBHistogramManipulator* self, cairo_t* ctx, GdkRectangle* area);
static void rgb_histogram_manipulator_draw_nub (RGBHistogramManipulator* self, cairo_t* ctx, GdkRectangle* area, gint position);
GdkPixbuf* rgb_histogram_get_graphic (RGBHistogram* self);
void rgb_histogram_manipulator_update_histogram (RGBHistogramManipulator* self, GdkPixbuf* source_pixbuf);
RGBHistogram* rgb_histogram_new (GdkPixbuf* pixbuf);
RGBHistogram* rgb_histogram_construct (GType object_type, GdkPixbuf* pixbuf);
gint rgb_histogram_manipulator_get_left_nub_position (RGBHistogramManipulator* self);
gint rgb_histogram_manipulator_get_right_nub_position (RGBHistogramManipulator* self);
void rgb_histogram_manipulator_set_left_nub_position (RGBHistogramManipulator* self, gint user_nub_pos);
void rgb_histogram_manipulator_set_right_nub_position (RGBHistogramManipulator* self, gint user_nub_pos);
static void rgb_histogram_manipulator_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
#line 36 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return self ? g_object_ref (self) : NULL;
#line 261 "CustomComponents.c"
}


static GdkColor* _gdk_color_dup (GdkColor* self) {
	GdkColor* dup;
#line 38 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	dup = g_new0 (GdkColor, 1);
#line 38 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	memcpy (dup, self, sizeof (GdkColor));
#line 38 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return dup;
#line 273 "CustomComponents.c"
}


static gpointer __gdk_color_dup0 (gpointer self) {
#line 38 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return self ? _gdk_color_dup (self) : NULL;
#line 280 "CustomComponents.c"
}


static void theme_loader_populate_theme_params (void) {
	ThemeLoaderLightweightColor* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	ThemeLoaderLightweightColor* _tmp1_ = NULL;
	GtkSettings* settings = NULL;
	GtkSettings* _tmp2_ = NULL;
	GtkSettings* _tmp3_ = NULL;
	GHashTable* color_table = NULL;
	GtkSettings* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GHashTable* _tmp6_ = NULL;
	GdkColor* base_color = NULL;
	GHashTable* _tmp7_ = NULL;
	gconstpointer _tmp8_ = NULL;
	GdkColor* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GdkColor* _tmp11_ = NULL;
	RGBAnalyticPixel base_color_analytic_rgb = {0};
	GdkColor* _tmp16_ = NULL;
	guint16 _tmp17_ = 0U;
	GdkColor* _tmp18_ = NULL;
	guint16 _tmp19_ = 0U;
	GdkColor* _tmp20_ = NULL;
	guint16 _tmp21_ = 0U;
	HSVAnalyticPixel base_color_analytic_hsv = {0};
	RGBAnalyticPixel _tmp22_ = {0};
	HSVAnalyticPixel bevel_light_analytic_hsv = {0};
	HSVAnalyticPixel _tmp23_ = {0};
	gfloat _tmp24_ = 0.0F;
	HSVAnalyticPixel _tmp25_ = {0};
	gfloat _tmp26_ = 0.0F;
	gfloat _tmp27_ = 0.0F;
	HSVAnalyticPixel bevel_lighter_analytic_hsv = {0};
	HSVAnalyticPixel _tmp28_ = {0};
	gfloat _tmp29_ = 0.0F;
	HSVAnalyticPixel _tmp30_ = {0};
	gfloat _tmp31_ = 0.0F;
	gfloat _tmp32_ = 0.0F;
	HSVAnalyticPixel bevel_dark_analytic_hsv = {0};
	HSVAnalyticPixel _tmp33_ = {0};
	gfloat _tmp34_ = 0.0F;
	HSVAnalyticPixel _tmp35_ = {0};
	gfloat _tmp36_ = 0.0F;
	gfloat _tmp37_ = 0.0F;
	HSVAnalyticPixel bevel_darker_analytic_hsv = {0};
	HSVAnalyticPixel _tmp38_ = {0};
	gfloat _tmp39_ = 0.0F;
	HSVAnalyticPixel _tmp40_ = {0};
	gfloat _tmp41_ = 0.0F;
	gfloat _tmp42_ = 0.0F;
	HSVAnalyticPixel outline_analytic_hsv = {0};
	HSVAnalyticPixel _tmp43_ = {0};
	gfloat _tmp44_ = 0.0F;
	HSVAnalyticPixel _tmp45_ = {0};
	gfloat _tmp46_ = 0.0F;
	gfloat _tmp47_ = 0.0F;
	RGBAnalyticPixel outline_analytic_rgb = {0};
	RGBAnalyticPixel _tmp48_ = {0};
	ThemeLoaderLightweightColor* _tmp49_ = NULL;
	gint _tmp49__length1 = 0;
	RGBAnalyticPixel _tmp50_ = {0};
	ThemeLoaderLightweightColor _tmp51_ = {0};
	ThemeLoaderLightweightColor _tmp52_ = {0};
	RGBAnalyticPixel bevel_darker_analytic_rgb = {0};
	RGBAnalyticPixel _tmp53_ = {0};
	ThemeLoaderLightweightColor* _tmp54_ = NULL;
	gint _tmp54__length1 = 0;
	RGBAnalyticPixel _tmp55_ = {0};
	ThemeLoaderLightweightColor _tmp56_ = {0};
	ThemeLoaderLightweightColor _tmp57_ = {0};
	RGBAnalyticPixel bevel_dark_analytic_rgb = {0};
	RGBAnalyticPixel _tmp58_ = {0};
	ThemeLoaderLightweightColor* _tmp59_ = NULL;
	gint _tmp59__length1 = 0;
	RGBAnalyticPixel _tmp60_ = {0};
	ThemeLoaderLightweightColor _tmp61_ = {0};
	ThemeLoaderLightweightColor _tmp62_ = {0};
	ThemeLoaderLightweightColor* _tmp63_ = NULL;
	gint _tmp63__length1 = 0;
	RGBAnalyticPixel _tmp64_ = {0};
	ThemeLoaderLightweightColor _tmp65_ = {0};
	ThemeLoaderLightweightColor _tmp66_ = {0};
	RGBAnalyticPixel bevel_light_analytic_rgb = {0};
	RGBAnalyticPixel _tmp67_ = {0};
	ThemeLoaderLightweightColor* _tmp68_ = NULL;
	gint _tmp68__length1 = 0;
	RGBAnalyticPixel _tmp69_ = {0};
	ThemeLoaderLightweightColor _tmp70_ = {0};
	ThemeLoaderLightweightColor _tmp71_ = {0};
	RGBAnalyticPixel bevel_lighter_analytic_rgb = {0};
	RGBAnalyticPixel _tmp72_ = {0};
	ThemeLoaderLightweightColor* _tmp73_ = NULL;
	gint _tmp73__length1 = 0;
	RGBAnalyticPixel _tmp74_ = {0};
	ThemeLoaderLightweightColor _tmp75_ = {0};
	ThemeLoaderLightweightColor _tmp76_ = {0};
#line 31 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = theme_loader_theme_colors;
#line 31 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0__length1 = theme_loader_theme_colors_length1;
#line 31 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp0_ != NULL) {
#line 32 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		return;
#line 388 "CustomComponents.c"
	}
#line 34 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = g_new0 (ThemeLoaderLightweightColor, THEME_LOADER_NUM_SUPPORTED_INTENSITIES);
#line 34 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	theme_loader_theme_colors = (g_free (theme_loader_theme_colors), NULL);
#line 34 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	theme_loader_theme_colors = _tmp1_;
#line 34 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	theme_loader_theme_colors_length1 = THEME_LOADER_NUM_SUPPORTED_INTENSITIES;
#line 34 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_theme_loader_theme_colors_size_ = theme_loader_theme_colors_length1;
#line 36 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp2_ = gtk_settings_get_default ();
#line 36 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 36 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	settings = _tmp3_;
#line 37 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp4_ = settings;
#line 37 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_object_get (_tmp4_, "color-hash", &_tmp5_, NULL);
#line 37 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp6_ = _tmp5_;
#line 37 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	color_table = _tmp6_;
#line 38 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp7_ = color_table;
#line 38 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp8_ = g_hash_table_lookup (_tmp7_, "bg_color");
#line 38 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp9_ = __gdk_color_dup0 ((GdkColor*) _tmp8_);
#line 38 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	base_color = _tmp9_;
#line 39 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp11_ = base_color;
#line 39 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp11_ == NULL) {
#line 426 "CustomComponents.c"
		GdkColor _tmp12_ = {0};
		gboolean _tmp13_ = FALSE;
		GdkColor _tmp14_ = {0};
		GdkColor* _tmp15_ = NULL;
#line 39 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp13_ = gdk_color_parse ("#fff", &_tmp12_);
#line 39 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_g_free0 (base_color);
#line 39 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp14_ = _tmp12_;
#line 39 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp15_ = __gdk_color_dup0 (&_tmp14_);
#line 39 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		base_color = _tmp15_;
#line 39 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp10_ = !_tmp13_;
#line 443 "CustomComponents.c"
	} else {
#line 39 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp10_ = FALSE;
#line 447 "CustomComponents.c"
	}
#line 39 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp10_) {
#line 40 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		g_error ("CustomComponents.vala:40: can't parse color");
#line 453 "CustomComponents.c"
	}
#line 42 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp16_ = base_color;
#line 42 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp17_ = (*_tmp16_).red;
#line 42 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp18_ = base_color;
#line 42 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp19_ = (*_tmp18_).green;
#line 42 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp20_ = base_color;
#line 42 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp21_ = (*_tmp20_).blue;
#line 42 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	rgb_analytic_pixel_init_from_quantized_components (&base_color_analytic_rgb, (guchar) (_tmp17_ >> 8), (guchar) (_tmp19_ >> 8), (guchar) (_tmp21_ >> 8));
#line 45 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp22_ = base_color_analytic_rgb;
#line 45 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	hsv_analytic_pixel_init_from_rgb (&base_color_analytic_hsv, &_tmp22_);
#line 48 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp23_ = base_color_analytic_hsv;
#line 48 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_light_analytic_hsv = _tmp23_;
#line 49 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp24_ = bevel_light_analytic_hsv.light_value;
#line 49 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_light_analytic_hsv.light_value = _tmp24_ * 1.15f;
#line 50 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp25_ = bevel_light_analytic_hsv;
#line 50 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp26_ = _tmp25_.light_value;
#line 50 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp27_ = CLAMP (_tmp26_, 0.0f, 1.0f);
#line 50 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_light_analytic_hsv.light_value = _tmp27_;
#line 53 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp28_ = bevel_light_analytic_hsv;
#line 53 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_lighter_analytic_hsv = _tmp28_;
#line 54 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp29_ = bevel_lighter_analytic_hsv.light_value;
#line 54 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_lighter_analytic_hsv.light_value = _tmp29_ * 1.15f;
#line 55 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp30_ = bevel_lighter_analytic_hsv;
#line 55 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp31_ = _tmp30_.light_value;
#line 55 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp32_ = CLAMP (_tmp31_, 0.0f, 1.0f);
#line 55 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_lighter_analytic_hsv.light_value = _tmp32_;
#line 58 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp33_ = base_color_analytic_hsv;
#line 58 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_dark_analytic_hsv = _tmp33_;
#line 59 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp34_ = bevel_dark_analytic_hsv.light_value;
#line 59 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_dark_analytic_hsv.light_value = _tmp34_ * 0.85f;
#line 60 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp35_ = bevel_dark_analytic_hsv;
#line 60 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp36_ = _tmp35_.light_value;
#line 60 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp37_ = CLAMP (_tmp36_, 0.0f, 1.0f);
#line 60 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_dark_analytic_hsv.light_value = _tmp37_;
#line 63 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp38_ = bevel_dark_analytic_hsv;
#line 63 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_darker_analytic_hsv = _tmp38_;
#line 64 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp39_ = bevel_darker_analytic_hsv.light_value;
#line 64 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_darker_analytic_hsv.light_value = _tmp39_ * 0.85f;
#line 65 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp40_ = bevel_darker_analytic_hsv;
#line 65 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp41_ = _tmp40_.light_value;
#line 65 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp42_ = CLAMP (_tmp41_, 0.0f, 1.0f);
#line 65 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_darker_analytic_hsv.light_value = _tmp42_;
#line 68 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp43_ = bevel_darker_analytic_hsv;
#line 68 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	outline_analytic_hsv = _tmp43_;
#line 69 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp44_ = outline_analytic_hsv.light_value;
#line 69 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	outline_analytic_hsv.light_value = _tmp44_ * 0.66f;
#line 70 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp45_ = outline_analytic_hsv;
#line 70 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp46_ = _tmp45_.light_value;
#line 70 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp47_ = CLAMP (_tmp46_, 0.0f, 1.0f);
#line 70 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	outline_analytic_hsv.light_value = _tmp47_;
#line 73 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	hsv_analytic_pixel_to_rgb (&outline_analytic_hsv, &_tmp48_);
#line 73 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	outline_analytic_rgb = _tmp48_;
#line 74 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp49_ = theme_loader_theme_colors;
#line 74 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp49__length1 = theme_loader_theme_colors_length1;
#line 74 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp50_ = outline_analytic_rgb;
#line 74 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	theme_loader_populate_one_theme_param (&_tmp50_, &_tmp51_);
#line 74 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp49_[THEME_LOADER_THEME_OUTLINE_COLOR] = _tmp51_;
#line 74 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp52_ = _tmp49_[THEME_LOADER_THEME_OUTLINE_COLOR];
#line 77 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	hsv_analytic_pixel_to_rgb (&bevel_darker_analytic_hsv, &_tmp53_);
#line 77 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_darker_analytic_rgb = _tmp53_;
#line 78 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp54_ = theme_loader_theme_colors;
#line 78 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp54__length1 = theme_loader_theme_colors_length1;
#line 78 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp55_ = bevel_darker_analytic_rgb;
#line 78 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	theme_loader_populate_one_theme_param (&_tmp55_, &_tmp56_);
#line 78 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp54_[THEME_LOADER_THEME_BEVEL_DARKER_COLOR] = _tmp56_;
#line 78 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp57_ = _tmp54_[THEME_LOADER_THEME_BEVEL_DARKER_COLOR];
#line 81 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	hsv_analytic_pixel_to_rgb (&bevel_dark_analytic_hsv, &_tmp58_);
#line 81 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_dark_analytic_rgb = _tmp58_;
#line 82 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp59_ = theme_loader_theme_colors;
#line 82 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp59__length1 = theme_loader_theme_colors_length1;
#line 82 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp60_ = bevel_dark_analytic_rgb;
#line 82 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	theme_loader_populate_one_theme_param (&_tmp60_, &_tmp61_);
#line 82 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp59_[THEME_LOADER_THEME_BEVEL_DARK_COLOR] = _tmp61_;
#line 82 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp62_ = _tmp59_[THEME_LOADER_THEME_BEVEL_DARK_COLOR];
#line 85 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp63_ = theme_loader_theme_colors;
#line 85 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp63__length1 = theme_loader_theme_colors_length1;
#line 85 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp64_ = base_color_analytic_rgb;
#line 85 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	theme_loader_populate_one_theme_param (&_tmp64_, &_tmp65_);
#line 85 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp63_[THEME_LOADER_THEME_BASE_COLOR] = _tmp65_;
#line 85 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp66_ = _tmp63_[THEME_LOADER_THEME_BASE_COLOR];
#line 88 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	hsv_analytic_pixel_to_rgb (&bevel_light_analytic_hsv, &_tmp67_);
#line 88 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_light_analytic_rgb = _tmp67_;
#line 89 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp68_ = theme_loader_theme_colors;
#line 89 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp68__length1 = theme_loader_theme_colors_length1;
#line 89 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp69_ = bevel_light_analytic_rgb;
#line 89 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	theme_loader_populate_one_theme_param (&_tmp69_, &_tmp70_);
#line 89 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp68_[THEME_LOADER_THEME_BEVEL_LIGHT_COLOR] = _tmp70_;
#line 89 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp71_ = _tmp68_[THEME_LOADER_THEME_BEVEL_LIGHT_COLOR];
#line 92 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	hsv_analytic_pixel_to_rgb (&bevel_light_analytic_hsv, &_tmp72_);
#line 92 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	bevel_lighter_analytic_rgb = _tmp72_;
#line 93 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp73_ = theme_loader_theme_colors;
#line 93 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp73__length1 = theme_loader_theme_colors_length1;
#line 93 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp74_ = bevel_lighter_analytic_rgb;
#line 93 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	theme_loader_populate_one_theme_param (&_tmp74_, &_tmp75_);
#line 93 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp73_[THEME_LOADER_THEME_BEVEL_LIGHTER_COLOR] = _tmp75_;
#line 93 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp76_ = _tmp73_[THEME_LOADER_THEME_BEVEL_LIGHTER_COLOR];
#line 30 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_g_free0 (base_color);
#line 30 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_g_hash_table_unref0 (color_table);
#line 30 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_g_object_unref0 (settings);
#line 651 "CustomComponents.c"
}


static void theme_loader_populate_one_theme_param (RGBAnalyticPixel* from, ThemeLoaderLightweightColor* result) {
	ThemeLoaderLightweightColor into = {0};
	RGBAnalyticPixel _tmp0_ = {0};
	gfloat _tmp1_ = 0.0F;
	RGBAnalyticPixel _tmp2_ = {0};
	gfloat _tmp3_ = 0.0F;
	RGBAnalyticPixel _tmp4_ = {0};
	gfloat _tmp5_ = 0.0F;
#line 97 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (from != NULL);
#line 98 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	theme_loader_lightweight_color_init (&into);
#line 100 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = *from;
#line 100 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = _tmp0_.red;
#line 100 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	into.red = (guchar) (_tmp1_ * 255.0f);
#line 101 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp2_ = *from;
#line 101 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp3_ = _tmp2_.green;
#line 101 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	into.green = (guchar) (_tmp3_ * 255.0f);
#line 102 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp4_ = *from;
#line 102 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp5_ = _tmp4_.blue;
#line 102 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	into.blue = (guchar) (_tmp5_ * 255.0f);
#line 104 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	*result = into;
#line 104 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return;
#line 689 "CustomComponents.c"
}


static guint _theme_loader_rgb_pixel_hash_func_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = theme_loader_rgb_pixel_hash_func ((RGBAnalyticPixel*) v);
#line 114 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 698 "CustomComponents.c"
}


static gboolean _theme_loader_rgb_pixel_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = theme_loader_rgb_pixel_equal_func ((RGBAnalyticPixel*) a, (RGBAnalyticPixel*) b);
#line 114 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 707 "CustomComponents.c"
}


static gint _theme_loader_hsv_pixel_compare_func_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = theme_loader_hsv_pixel_compare_func (a, b);
#line 142 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 716 "CustomComponents.c"
}


GdkPixbuf* theme_loader_load_icon (const gchar* source_basename) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* loaded_pixbuf = NULL;
	const gchar* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GeeHashSet* colors = NULL;
	GeeHashSet* _tmp5_ = NULL;
	guchar* pixel_data = NULL;
	GdkPixbuf* _tmp6_ = NULL;
	guint8* _tmp7_ = NULL;
	gint pixel_data_length1 = 0;
	gint _pixel_data_size_ = 0;
	GeeHashSet* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	HSVAnalyticPixel* hsv_pixels = NULL;
	HSVAnalyticPixel* _tmp42_ = NULL;
	gint hsv_pixels_length1 = 0;
	gint _hsv_pixels_size_ = 0;
	gint pixel_ticker = 0;
	HSVAnalyticPixel* _tmp56_ = NULL;
	gint _tmp56__length1 = 0;
	HSVAnalyticPixel* _tmp57_ = NULL;
	gint _tmp57__length1 = 0;
#line 107 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_val_if_fail (source_basename != NULL, NULL);
#line 108 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	theme_loader_populate_theme_params ();
#line 110 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = source_basename;
#line 110 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = resources_get_icon (_tmp0_, 0);
#line 110 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp2_ = _tmp1_;
#line 110 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp3_ = gdk_pixbuf_copy (_tmp2_);
#line 110 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp4_ = _tmp3_;
#line 110 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_g_object_unref0 (_tmp2_);
#line 110 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	loaded_pixbuf = _tmp4_;
#line 114 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp5_ = gee_hash_set_new (TYPE_RGB_ANALYTIC_PIXEL, (GBoxedCopyFunc) rgb_analytic_pixel_dup, (GDestroyNotify) rgb_analytic_pixel_free, _theme_loader_rgb_pixel_hash_func_gee_hash_data_func, NULL, NULL, _theme_loader_rgb_pixel_equal_func_gee_equal_data_func, NULL, NULL);
#line 114 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	colors = _tmp5_;
#line 117 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp6_ = loaded_pixbuf;
#line 117 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp7_ = gdk_pixbuf_get_pixels (_tmp6_);
#line 117 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	pixel_data = _tmp7_;
#line 117 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	pixel_data_length1 = -1;
#line 117 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_pixel_data_size_ = pixel_data_length1;
#line 779 "CustomComponents.c"
	{
		gint j = 0;
#line 118 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		j = 0;
#line 784 "CustomComponents.c"
		{
			gboolean _tmp8_ = FALSE;
#line 118 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp8_ = TRUE;
#line 118 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			while (TRUE) {
#line 791 "CustomComponents.c"
				gint _tmp10_ = 0;
				GdkPixbuf* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
#line 118 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				if (!_tmp8_) {
#line 798 "CustomComponents.c"
					gint _tmp9_ = 0;
#line 118 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp9_ = j;
#line 118 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					j = _tmp9_ + 1;
#line 804 "CustomComponents.c"
				}
#line 118 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				_tmp8_ = FALSE;
#line 118 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				_tmp10_ = j;
#line 118 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				_tmp11_ = loaded_pixbuf;
#line 118 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				_tmp12_ = gdk_pixbuf_get_height (_tmp11_);
#line 118 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				_tmp13_ = _tmp12_;
#line 118 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				if (!(_tmp10_ < _tmp13_)) {
#line 118 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					break;
#line 820 "CustomComponents.c"
				}
				{
					gint i = 0;
#line 119 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					i = 0;
#line 826 "CustomComponents.c"
					{
						gboolean _tmp14_ = FALSE;
#line 119 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp14_ = TRUE;
#line 119 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						while (TRUE) {
#line 833 "CustomComponents.c"
							gint _tmp16_ = 0;
							GdkPixbuf* _tmp17_ = NULL;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint pixel_index = 0;
							gint _tmp20_ = 0;
							GdkPixbuf* _tmp21_ = NULL;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							GdkPixbuf* _tmp25_ = NULL;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							RGBAnalyticPixel pixel_color = {0};
							guchar* _tmp28_ = NULL;
							gint _tmp28__length1 = 0;
							gint _tmp29_ = 0;
							guchar _tmp30_ = '\0';
							guchar* _tmp31_ = NULL;
							gint _tmp31__length1 = 0;
							gint _tmp32_ = 0;
							guchar _tmp33_ = '\0';
							guchar* _tmp34_ = NULL;
							gint _tmp34__length1 = 0;
							gint _tmp35_ = 0;
							guchar _tmp36_ = '\0';
							GeeHashSet* _tmp37_ = NULL;
							RGBAnalyticPixel _tmp38_ = {0};
#line 119 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							if (!_tmp14_) {
#line 864 "CustomComponents.c"
								gint _tmp15_ = 0;
#line 119 "/home/jens/Source/shotwell/src/CustomComponents.vala"
								_tmp15_ = i;
#line 119 "/home/jens/Source/shotwell/src/CustomComponents.vala"
								i = _tmp15_ + 1;
#line 870 "CustomComponents.c"
							}
#line 119 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp14_ = FALSE;
#line 119 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp16_ = i;
#line 119 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp17_ = loaded_pixbuf;
#line 119 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp18_ = gdk_pixbuf_get_width (_tmp17_);
#line 119 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp19_ = _tmp18_;
#line 119 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							if (!(_tmp16_ < _tmp19_)) {
#line 119 "/home/jens/Source/shotwell/src/CustomComponents.vala"
								break;
#line 886 "CustomComponents.c"
							}
#line 120 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp20_ = j;
#line 120 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp21_ = loaded_pixbuf;
#line 120 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp22_ = gdk_pixbuf_get_rowstride (_tmp21_);
#line 120 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp23_ = _tmp22_;
#line 120 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp24_ = i;
#line 120 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp25_ = loaded_pixbuf;
#line 120 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp26_ = gdk_pixbuf_get_n_channels (_tmp25_);
#line 120 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp27_ = _tmp26_;
#line 120 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							pixel_index = (_tmp20_ * _tmp23_) + (_tmp24_ * _tmp27_);
#line 122 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp28_ = pixel_data;
#line 122 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp28__length1 = pixel_data_length1;
#line 122 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp29_ = pixel_index;
#line 122 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp30_ = _tmp28_[_tmp29_];
#line 122 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp31_ = pixel_data;
#line 122 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp31__length1 = pixel_data_length1;
#line 122 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp32_ = pixel_index;
#line 122 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp33_ = _tmp31_[_tmp32_ + 1];
#line 122 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp34_ = pixel_data;
#line 122 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp34__length1 = pixel_data_length1;
#line 122 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp35_ = pixel_index;
#line 122 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp36_ = _tmp34_[_tmp35_ + 2];
#line 122 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							rgb_analytic_pixel_init_from_quantized_components (&pixel_color, _tmp30_, _tmp33_, _tmp36_);
#line 125 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp37_ = colors;
#line 125 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp38_ = pixel_color;
#line 125 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp38_);
#line 938 "CustomComponents.c"
						}
					}
				}
			}
		}
	}
#line 132 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp39_ = colors;
#line 132 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp40_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 132 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp41_ = _tmp40_;
#line 132 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp41_ != THEME_LOADER_NUM_SUPPORTED_INTENSITIES) {
#line 133 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		g_error ("CustomComponents.vala:133: %s", "ThemeLoader: load_icon: pixbuf does not contain the correct number " "of unique colors");
#line 955 "CustomComponents.c"
	}
#line 138 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp42_ = g_new0 (HSVAnalyticPixel, 6);
#line 138 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	hsv_pixels = _tmp42_;
#line 138 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	hsv_pixels_length1 = 6;
#line 138 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_hsv_pixels_size_ = hsv_pixels_length1;
#line 139 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	pixel_ticker = 0;
#line 967 "CustomComponents.c"
	{
		GeeIterator* _rgb_pixel_it = NULL;
		GeeHashSet* _tmp43_ = NULL;
		GeeIterator* _tmp44_ = NULL;
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp43_ = colors;
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp44_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_rgb_pixel_it = _tmp44_;
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		while (TRUE) {
#line 980 "CustomComponents.c"
			GeeIterator* _tmp45_ = NULL;
			gboolean _tmp46_ = FALSE;
			RGBAnalyticPixel rgb_pixel = {0};
			GeeIterator* _tmp47_ = NULL;
			gpointer _tmp48_ = NULL;
			RGBAnalyticPixel* _tmp49_ = NULL;
			RGBAnalyticPixel _tmp50_ = {0};
			HSVAnalyticPixel* _tmp51_ = NULL;
			gint _tmp51__length1 = 0;
			gint _tmp52_ = 0;
			RGBAnalyticPixel _tmp53_ = {0};
			HSVAnalyticPixel _tmp54_ = {0};
			HSVAnalyticPixel _tmp55_ = {0};
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp45_ = _rgb_pixel_it;
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp46_ = gee_iterator_next (_tmp45_);
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			if (!_tmp46_) {
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				break;
#line 1002 "CustomComponents.c"
			}
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp47_ = _rgb_pixel_it;
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp48_ = gee_iterator_get (_tmp47_);
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp49_ = (RGBAnalyticPixel*) _tmp48_;
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp50_ = *_tmp49_;
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_rgb_analytic_pixel_free0 (_tmp49_);
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			rgb_pixel = _tmp50_;
#line 141 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp51_ = hsv_pixels;
#line 141 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp51__length1 = hsv_pixels_length1;
#line 141 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp52_ = pixel_ticker;
#line 141 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			pixel_ticker = _tmp52_ + 1;
#line 141 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp53_ = rgb_pixel;
#line 141 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			hsv_analytic_pixel_init_from_rgb (&_tmp54_, &_tmp53_);
#line 141 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp51_[_tmp52_] = _tmp54_;
#line 141 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp55_ = _tmp51_[_tmp52_];
#line 1032 "CustomComponents.c"
		}
#line 140 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_g_object_unref0 (_rgb_pixel_it);
#line 1036 "CustomComponents.c"
	}
#line 142 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp56_ = hsv_pixels;
#line 142 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp56__length1 = hsv_pixels_length1;
#line 142 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp57_ = hsv_pixels;
#line 142 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp57__length1 = hsv_pixels_length1;
#line 142 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	qsort (_tmp56_, (gsize) _tmp57__length1, (gsize) sizeof (HSVAnalyticPixel), _theme_loader_hsv_pixel_compare_func_gcompare_func);
#line 1048 "CustomComponents.c"
	{
		gint j = 0;
#line 146 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		j = 0;
#line 1053 "CustomComponents.c"
		{
			gboolean _tmp58_ = FALSE;
#line 146 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp58_ = TRUE;
#line 146 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			while (TRUE) {
#line 1060 "CustomComponents.c"
				gint _tmp60_ = 0;
				GdkPixbuf* _tmp61_ = NULL;
				gint _tmp62_ = 0;
				gint _tmp63_ = 0;
#line 146 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				if (!_tmp58_) {
#line 1067 "CustomComponents.c"
					gint _tmp59_ = 0;
#line 146 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp59_ = j;
#line 146 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					j = _tmp59_ + 1;
#line 1073 "CustomComponents.c"
				}
#line 146 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				_tmp58_ = FALSE;
#line 146 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				_tmp60_ = j;
#line 146 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				_tmp61_ = loaded_pixbuf;
#line 146 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				_tmp62_ = gdk_pixbuf_get_height (_tmp61_);
#line 146 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				_tmp63_ = _tmp62_;
#line 146 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				if (!(_tmp60_ < _tmp63_)) {
#line 146 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					break;
#line 1089 "CustomComponents.c"
				}
				{
					gint i = 0;
#line 147 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					i = 0;
#line 1095 "CustomComponents.c"
					{
						gboolean _tmp64_ = FALSE;
#line 147 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp64_ = TRUE;
#line 147 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						while (TRUE) {
#line 1102 "CustomComponents.c"
							gint _tmp66_ = 0;
							GdkPixbuf* _tmp67_ = NULL;
							gint _tmp68_ = 0;
							gint _tmp69_ = 0;
							gint pixel_index = 0;
							gint _tmp70_ = 0;
							GdkPixbuf* _tmp71_ = NULL;
							gint _tmp72_ = 0;
							gint _tmp73_ = 0;
							gint _tmp74_ = 0;
							GdkPixbuf* _tmp75_ = NULL;
							gint _tmp76_ = 0;
							gint _tmp77_ = 0;
							RGBAnalyticPixel pixel_color = {0};
							guchar* _tmp78_ = NULL;
							gint _tmp78__length1 = 0;
							gint _tmp79_ = 0;
							guchar _tmp80_ = '\0';
							guchar* _tmp81_ = NULL;
							gint _tmp81__length1 = 0;
							gint _tmp82_ = 0;
							guchar _tmp83_ = '\0';
							guchar* _tmp84_ = NULL;
							gint _tmp84__length1 = 0;
							gint _tmp85_ = 0;
							guchar _tmp86_ = '\0';
							HSVAnalyticPixel pixel_color_hsv = {0};
							RGBAnalyticPixel _tmp87_ = {0};
							gint this_intensity = 0;
							guchar* _tmp98_ = NULL;
							gint _tmp98__length1 = 0;
							gint _tmp99_ = 0;
							ThemeLoaderLightweightColor* _tmp100_ = NULL;
							gint _tmp100__length1 = 0;
							gint _tmp101_ = 0;
							ThemeLoaderLightweightColor _tmp102_ = {0};
							guchar _tmp103_ = '\0';
							guchar _tmp104_ = '\0';
							guchar* _tmp105_ = NULL;
							gint _tmp105__length1 = 0;
							gint _tmp106_ = 0;
							ThemeLoaderLightweightColor* _tmp107_ = NULL;
							gint _tmp107__length1 = 0;
							gint _tmp108_ = 0;
							ThemeLoaderLightweightColor _tmp109_ = {0};
							guchar _tmp110_ = '\0';
							guchar _tmp111_ = '\0';
							guchar* _tmp112_ = NULL;
							gint _tmp112__length1 = 0;
							gint _tmp113_ = 0;
							ThemeLoaderLightweightColor* _tmp114_ = NULL;
							gint _tmp114__length1 = 0;
							gint _tmp115_ = 0;
							ThemeLoaderLightweightColor _tmp116_ = {0};
							guchar _tmp117_ = '\0';
							guchar _tmp118_ = '\0';
#line 147 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							if (!_tmp64_) {
#line 1161 "CustomComponents.c"
								gint _tmp65_ = 0;
#line 147 "/home/jens/Source/shotwell/src/CustomComponents.vala"
								_tmp65_ = i;
#line 147 "/home/jens/Source/shotwell/src/CustomComponents.vala"
								i = _tmp65_ + 1;
#line 1167 "CustomComponents.c"
							}
#line 147 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp64_ = FALSE;
#line 147 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp66_ = i;
#line 147 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp67_ = loaded_pixbuf;
#line 147 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp68_ = gdk_pixbuf_get_width (_tmp67_);
#line 147 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp69_ = _tmp68_;
#line 147 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							if (!(_tmp66_ < _tmp69_)) {
#line 147 "/home/jens/Source/shotwell/src/CustomComponents.vala"
								break;
#line 1183 "CustomComponents.c"
							}
#line 148 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp70_ = j;
#line 148 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp71_ = loaded_pixbuf;
#line 148 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp72_ = gdk_pixbuf_get_rowstride (_tmp71_);
#line 148 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp73_ = _tmp72_;
#line 148 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp74_ = i;
#line 148 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp75_ = loaded_pixbuf;
#line 148 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp76_ = gdk_pixbuf_get_n_channels (_tmp75_);
#line 148 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp77_ = _tmp76_;
#line 148 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							pixel_index = (_tmp70_ * _tmp73_) + (_tmp74_ * _tmp77_);
#line 149 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp78_ = pixel_data;
#line 149 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp78__length1 = pixel_data_length1;
#line 149 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp79_ = pixel_index;
#line 149 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp80_ = _tmp78_[_tmp79_];
#line 149 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp81_ = pixel_data;
#line 149 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp81__length1 = pixel_data_length1;
#line 149 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp82_ = pixel_index;
#line 149 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp83_ = _tmp81_[_tmp82_ + 1];
#line 149 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp84_ = pixel_data;
#line 149 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp84__length1 = pixel_data_length1;
#line 149 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp85_ = pixel_index;
#line 149 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp86_ = _tmp84_[_tmp85_ + 2];
#line 149 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							rgb_analytic_pixel_init_from_quantized_components (&pixel_color, _tmp80_, _tmp83_, _tmp86_);
#line 152 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp87_ = pixel_color;
#line 152 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							hsv_analytic_pixel_init_from_rgb (&pixel_color_hsv, &_tmp87_);
#line 153 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							this_intensity = 0;
#line 1235 "CustomComponents.c"
							{
								gint k = 0;
#line 154 "/home/jens/Source/shotwell/src/CustomComponents.vala"
								k = 0;
#line 1240 "CustomComponents.c"
								{
									gboolean _tmp88_ = FALSE;
#line 154 "/home/jens/Source/shotwell/src/CustomComponents.vala"
									_tmp88_ = TRUE;
#line 154 "/home/jens/Source/shotwell/src/CustomComponents.vala"
									while (TRUE) {
#line 1247 "CustomComponents.c"
										gint _tmp90_ = 0;
										HSVAnalyticPixel* _tmp91_ = NULL;
										gint _tmp91__length1 = 0;
										gint _tmp92_ = 0;
										HSVAnalyticPixel _tmp93_ = {0};
										gfloat _tmp94_ = 0.0F;
										HSVAnalyticPixel _tmp95_ = {0};
										gfloat _tmp96_ = 0.0F;
#line 154 "/home/jens/Source/shotwell/src/CustomComponents.vala"
										if (!_tmp88_) {
#line 1258 "CustomComponents.c"
											gint _tmp89_ = 0;
#line 154 "/home/jens/Source/shotwell/src/CustomComponents.vala"
											_tmp89_ = k;
#line 154 "/home/jens/Source/shotwell/src/CustomComponents.vala"
											k = _tmp89_ + 1;
#line 1264 "CustomComponents.c"
										}
#line 154 "/home/jens/Source/shotwell/src/CustomComponents.vala"
										_tmp88_ = FALSE;
#line 154 "/home/jens/Source/shotwell/src/CustomComponents.vala"
										_tmp90_ = k;
#line 154 "/home/jens/Source/shotwell/src/CustomComponents.vala"
										if (!(_tmp90_ < THEME_LOADER_NUM_SUPPORTED_INTENSITIES)) {
#line 154 "/home/jens/Source/shotwell/src/CustomComponents.vala"
											break;
#line 1274 "CustomComponents.c"
										}
#line 155 "/home/jens/Source/shotwell/src/CustomComponents.vala"
										_tmp91_ = hsv_pixels;
#line 155 "/home/jens/Source/shotwell/src/CustomComponents.vala"
										_tmp91__length1 = hsv_pixels_length1;
#line 155 "/home/jens/Source/shotwell/src/CustomComponents.vala"
										_tmp92_ = k;
#line 155 "/home/jens/Source/shotwell/src/CustomComponents.vala"
										_tmp93_ = _tmp91_[_tmp92_];
#line 155 "/home/jens/Source/shotwell/src/CustomComponents.vala"
										_tmp94_ = _tmp93_.light_value;
#line 155 "/home/jens/Source/shotwell/src/CustomComponents.vala"
										_tmp95_ = pixel_color_hsv;
#line 155 "/home/jens/Source/shotwell/src/CustomComponents.vala"
										_tmp96_ = _tmp95_.light_value;
#line 155 "/home/jens/Source/shotwell/src/CustomComponents.vala"
										if (_tmp94_ == _tmp96_) {
#line 1292 "CustomComponents.c"
											gint _tmp97_ = 0;
#line 156 "/home/jens/Source/shotwell/src/CustomComponents.vala"
											_tmp97_ = k;
#line 156 "/home/jens/Source/shotwell/src/CustomComponents.vala"
											this_intensity = _tmp97_;
#line 157 "/home/jens/Source/shotwell/src/CustomComponents.vala"
											break;
#line 1300 "CustomComponents.c"
										}
									}
								}
							}
#line 160 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp98_ = pixel_data;
#line 160 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp98__length1 = pixel_data_length1;
#line 160 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp99_ = pixel_index;
#line 160 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp100_ = theme_loader_theme_colors;
#line 160 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp100__length1 = theme_loader_theme_colors_length1;
#line 160 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp101_ = this_intensity;
#line 160 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp102_ = _tmp100_[_tmp101_];
#line 160 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp103_ = _tmp102_.red;
#line 160 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp98_[_tmp99_] = _tmp103_;
#line 160 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp104_ = _tmp98_[_tmp99_];
#line 161 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp105_ = pixel_data;
#line 161 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp105__length1 = pixel_data_length1;
#line 161 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp106_ = pixel_index;
#line 161 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp107_ = theme_loader_theme_colors;
#line 161 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp107__length1 = theme_loader_theme_colors_length1;
#line 161 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp108_ = this_intensity;
#line 161 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp109_ = _tmp107_[_tmp108_];
#line 161 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp110_ = _tmp109_.green;
#line 161 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp105_[_tmp106_ + 1] = _tmp110_;
#line 161 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp111_ = _tmp105_[_tmp106_ + 1];
#line 162 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp112_ = pixel_data;
#line 162 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp112__length1 = pixel_data_length1;
#line 162 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp113_ = pixel_index;
#line 162 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp114_ = theme_loader_theme_colors;
#line 162 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp114__length1 = theme_loader_theme_colors_length1;
#line 162 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp115_ = this_intensity;
#line 162 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp116_ = _tmp114_[_tmp115_];
#line 162 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp117_ = _tmp116_.blue;
#line 162 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp112_[_tmp113_ + 2] = _tmp117_;
#line 162 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							_tmp118_ = _tmp112_[_tmp113_ + 2];
#line 1365 "CustomComponents.c"
						}
					}
				}
			}
		}
	}
#line 166 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	result = loaded_pixbuf;
#line 166 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	hsv_pixels = (g_free (hsv_pixels), NULL);
#line 166 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_g_object_unref0 (colors);
#line 166 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 1380 "CustomComponents.c"
}


static gint theme_loader_hsv_pixel_compare_func (void* pixval1, void* pixval2) {
	gint result = 0;
	HSVAnalyticPixel pixel_val_1 = {0};
	void* _tmp0_ = NULL;
	HSVAnalyticPixel pixel_val_2 = {0};
	void* _tmp1_ = NULL;
	HSVAnalyticPixel _tmp2_ = {0};
	gfloat _tmp3_ = 0.0F;
	HSVAnalyticPixel _tmp4_ = {0};
	gfloat _tmp5_ = 0.0F;
#line 170 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = pixval1;
#line 170 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	pixel_val_1 = *((HSVAnalyticPixel*) _tmp0_);
#line 171 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = pixval2;
#line 171 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	pixel_val_2 = *((HSVAnalyticPixel*) _tmp1_);
#line 173 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp2_ = pixel_val_1;
#line 173 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp3_ = _tmp2_.light_value;
#line 173 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp4_ = pixel_val_2;
#line 173 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp5_ = _tmp4_.light_value;
#line 173 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	result = (gint) (255.0f * (_tmp3_ - _tmp5_));
#line 173 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 1414 "CustomComponents.c"
}


static gboolean theme_loader_rgb_pixel_equal_func (RGBAnalyticPixel* p1, RGBAnalyticPixel* p2) {
	gboolean result = FALSE;
	RGBAnalyticPixel* _tmp0_ = NULL;
	RGBAnalyticPixel* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 177 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = p1;
#line 177 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = p2;
#line 177 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp2_ = rgb_analytic_pixel_equals (_tmp0_, _tmp1_);
#line 177 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	result = _tmp2_;
#line 177 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 1433 "CustomComponents.c"
}


static guint theme_loader_rgb_pixel_hash_func (RGBAnalyticPixel* pixel_val) {
	guint result = 0U;
	RGBAnalyticPixel* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 181 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = pixel_val;
#line 181 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = rgb_analytic_pixel_hash_code (_tmp0_);
#line 181 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	result = _tmp1_;
#line 181 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 1449 "CustomComponents.c"
}


ThemeLoader* theme_loader_construct (GType object_type) {
	ThemeLoader* self = NULL;
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self = (ThemeLoader*) g_type_create_instance (object_type);
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return self;
#line 1459 "CustomComponents.c"
}


ThemeLoader* theme_loader_new (void) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return theme_loader_construct (TYPE_THEME_LOADER);
#line 1466 "CustomComponents.c"
}


static void theme_loader_lightweight_color_init (ThemeLoaderLightweightColor *self) {
	guchar _tmp0_ = '\0';
	guchar _tmp1_ = '\0';
#line 15 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	memset (self, 0, sizeof (ThemeLoaderLightweightColor));
#line 16 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	(*self).blue = (guchar) 0;
#line 16 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = (*self).blue;
#line 16 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	(*self).green = _tmp0_;
#line 16 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = (*self).green;
#line 16 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	(*self).red = _tmp1_;
#line 1485 "CustomComponents.c"
}


static ThemeLoaderLightweightColor* theme_loader_lightweight_color_dup (const ThemeLoaderLightweightColor* self) {
	ThemeLoaderLightweightColor* dup;
#line 10 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	dup = g_new0 (ThemeLoaderLightweightColor, 1);
#line 10 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	memcpy (dup, self, sizeof (ThemeLoaderLightweightColor));
#line 10 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return dup;
#line 1497 "CustomComponents.c"
}


static void theme_loader_lightweight_color_free (ThemeLoaderLightweightColor* self) {
#line 10 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_free (self);
#line 1504 "CustomComponents.c"
}


static GType theme_loader_lightweight_color_get_type (void) {
	static volatile gsize theme_loader_lightweight_color_type_id__volatile = 0;
	if (g_once_init_enter (&theme_loader_lightweight_color_type_id__volatile)) {
		GType theme_loader_lightweight_color_type_id;
		theme_loader_lightweight_color_type_id = g_boxed_type_register_static ("ThemeLoaderLightweightColor", (GBoxedCopyFunc) theme_loader_lightweight_color_dup, (GBoxedFreeFunc) theme_loader_lightweight_color_free);
		g_once_init_leave (&theme_loader_lightweight_color_type_id__volatile, theme_loader_lightweight_color_type_id);
	}
	return theme_loader_lightweight_color_type_id__volatile;
}


static void value_theme_loader_init (GValue* value) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	value->data[0].v_pointer = NULL;
#line 1522 "CustomComponents.c"
}


static void value_theme_loader_free_value (GValue* value) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (value->data[0].v_pointer) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		theme_loader_unref (value->data[0].v_pointer);
#line 1531 "CustomComponents.c"
	}
}


static void value_theme_loader_copy_value (const GValue* src_value, GValue* dest_value) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (src_value->data[0].v_pointer) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		dest_value->data[0].v_pointer = theme_loader_ref (src_value->data[0].v_pointer);
#line 1541 "CustomComponents.c"
	} else {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1545 "CustomComponents.c"
	}
}


static gpointer value_theme_loader_peek_pointer (const GValue* value) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return value->data[0].v_pointer;
#line 1553 "CustomComponents.c"
}


static gchar* value_theme_loader_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (collect_values[0].v_pointer) {
#line 1560 "CustomComponents.c"
		ThemeLoader* object;
		object = collect_values[0].v_pointer;
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		if (object->parent_instance.g_class == NULL) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1567 "CustomComponents.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1571 "CustomComponents.c"
		}
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		value->data[0].v_pointer = theme_loader_ref (object);
#line 1575 "CustomComponents.c"
	} else {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		value->data[0].v_pointer = NULL;
#line 1579 "CustomComponents.c"
	}
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return NULL;
#line 1583 "CustomComponents.c"
}


static gchar* value_theme_loader_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ThemeLoader** object_p;
	object_p = collect_values[0].v_pointer;
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (!object_p) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1594 "CustomComponents.c"
	}
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (!value->data[0].v_pointer) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		*object_p = NULL;
#line 1600 "CustomComponents.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		*object_p = value->data[0].v_pointer;
#line 1604 "CustomComponents.c"
	} else {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		*object_p = theme_loader_ref (value->data[0].v_pointer);
#line 1608 "CustomComponents.c"
	}
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return NULL;
#line 1612 "CustomComponents.c"
}


GParamSpec* param_spec_theme_loader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecThemeLoader* spec;
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_THEME_LOADER), NULL);
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return G_PARAM_SPEC (spec);
#line 1626 "CustomComponents.c"
}


gpointer value_get_theme_loader (const GValue* value) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEME_LOADER), NULL);
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return value->data[0].v_pointer;
#line 1635 "CustomComponents.c"
}


void value_set_theme_loader (GValue* value, gpointer v_object) {
	ThemeLoader* old;
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEME_LOADER));
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	old = value->data[0].v_pointer;
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (v_object) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THEME_LOADER));
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		value->data[0].v_pointer = v_object;
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		theme_loader_ref (value->data[0].v_pointer);
#line 1655 "CustomComponents.c"
	} else {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		value->data[0].v_pointer = NULL;
#line 1659 "CustomComponents.c"
	}
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (old) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		theme_loader_unref (old);
#line 1665 "CustomComponents.c"
	}
}


void value_take_theme_loader (GValue* value, gpointer v_object) {
	ThemeLoader* old;
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEME_LOADER));
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	old = value->data[0].v_pointer;
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (v_object) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THEME_LOADER));
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		value->data[0].v_pointer = v_object;
#line 1684 "CustomComponents.c"
	} else {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		value->data[0].v_pointer = NULL;
#line 1688 "CustomComponents.c"
	}
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (old) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		theme_loader_unref (old);
#line 1694 "CustomComponents.c"
	}
}


static void theme_loader_class_init (ThemeLoaderClass * klass) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	theme_loader_parent_class = g_type_class_peek_parent (klass);
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	((ThemeLoaderClass *) klass)->finalize = theme_loader_finalize;
#line 1704 "CustomComponents.c"
}


static void theme_loader_instance_init (ThemeLoader * self) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->ref_count = 1;
#line 1711 "CustomComponents.c"
}


static void theme_loader_finalize (ThemeLoader* obj) {
	ThemeLoader * self;
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEME_LOADER, ThemeLoader);
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_signal_handlers_destroy (self);
#line 1721 "CustomComponents.c"
}


GType theme_loader_get_type (void) {
	static volatile gsize theme_loader_type_id__volatile = 0;
	if (g_once_init_enter (&theme_loader_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_theme_loader_init, value_theme_loader_free_value, value_theme_loader_copy_value, value_theme_loader_peek_pointer, "p", value_theme_loader_collect_value, "p", value_theme_loader_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ThemeLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) theme_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThemeLoader), 0, (GInstanceInitFunc) theme_loader_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType theme_loader_type_id;
		theme_loader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ThemeLoader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&theme_loader_type_id__volatile, theme_loader_type_id);
	}
	return theme_loader_type_id__volatile;
}


gpointer theme_loader_ref (gpointer instance) {
	ThemeLoader* self;
	self = instance;
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_atomic_int_inc (&self->ref_count);
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return instance;
#line 1746 "CustomComponents.c"
}


void theme_loader_unref (gpointer instance) {
	ThemeLoader* self;
	self = instance;
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		THEME_LOADER_GET_CLASS (self)->finalize (self);
#line 9 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1759 "CustomComponents.c"
	}
}


static GType rgb_histogram_manipulator_location_code_get_type (void) {
	static volatile gsize rgb_histogram_manipulator_location_code_type_id__volatile = 0;
	if (g_once_init_enter (&rgb_histogram_manipulator_location_code_type_id__volatile)) {
		static const GEnumValue values[] = {{RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB", "left-nub"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB", "right-nub"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH", "left-trough"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH", "right-trough"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA", "insensitive-area"}, {0, NULL, NULL}};
		GType rgb_histogram_manipulator_location_code_type_id;
		rgb_histogram_manipulator_location_code_type_id = g_enum_register_static ("RGBHistogramManipulatorLocationCode", values);
		g_once_init_leave (&rgb_histogram_manipulator_location_code_type_id__volatile, rgb_histogram_manipulator_location_code_type_id);
	}
	return rgb_histogram_manipulator_location_code_type_id__volatile;
}


static gboolean _rgb_histogram_manipulator_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = rgb_histogram_manipulator_on_button_press ((RGBHistogramManipulator*) self, event);
#line 240 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 1781 "CustomComponents.c"
}


static gboolean _rgb_histogram_manipulator_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = rgb_histogram_manipulator_on_button_release ((RGBHistogramManipulator*) self, event);
#line 241 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 1790 "CustomComponents.c"
}


static gboolean _rgb_histogram_manipulator_on_button_motion_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = rgb_histogram_manipulator_on_button_motion ((RGBHistogramManipulator*) self, event);
#line 242 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 1799 "CustomComponents.c"
}


RGBHistogramManipulator* rgb_histogram_manipulator_construct (GType object_type) {
	RGBHistogramManipulator * self = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 216 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self = (RGBHistogramManipulator*) g_object_new (object_type, NULL);
#line 217 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), RGB_HISTOGRAM_MANIPULATOR_CONTROL_WIDTH, RGB_HISTOGRAM_MANIPULATOR_CONTROL_HEIGHT);
#line 219 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = rgb_histogram_manipulator_dummy_slider;
#line 219 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp0_ == NULL) {
#line 1816 "CustomComponents.c"
		GtkScale* _tmp1_ = NULL;
#line 220 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp1_ = (GtkScale*) gtk_scale_new (GTK_ORIENTATION_HORIZONTAL, NULL);
#line 220 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		g_object_ref_sink (_tmp1_);
#line 220 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_g_object_unref0 (rgb_histogram_manipulator_dummy_slider);
#line 220 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		rgb_histogram_manipulator_dummy_slider = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget);
#line 1826 "CustomComponents.c"
	}
#line 222 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp2_ = rgb_histogram_manipulator_dummy_frame;
#line 222 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp2_ == NULL) {
#line 1832 "CustomComponents.c"
		GtkFrame* _tmp3_ = NULL;
#line 223 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp3_ = (GtkFrame*) gtk_frame_new (NULL);
#line 223 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		g_object_ref_sink (_tmp3_);
#line 223 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_g_object_unref0 (rgb_histogram_manipulator_dummy_frame);
#line 223 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		rgb_histogram_manipulator_dummy_frame = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget);
#line 1842 "CustomComponents.c"
	}
#line 225 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp4_ = rgb_histogram_manipulator_paths_setup;
#line 225 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (!_tmp4_) {
#line 1848 "CustomComponents.c"
		GtkWidgetPath* _tmp5_ = NULL;
		GtkWidgetPath* _tmp6_ = NULL;
		GtkWidgetPath* _tmp7_ = NULL;
		GtkWidgetPath* _tmp8_ = NULL;
		GtkWidgetPath* _tmp9_ = NULL;
#line 226 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp5_ = rgb_histogram_manipulator_slider_draw_path;
#line 226 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		gtk_widget_path_append_type (_tmp5_, gtk_scale_get_type ());
#line 227 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp6_ = rgb_histogram_manipulator_slider_draw_path;
#line 227 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		gtk_widget_path_iter_add_class (_tmp6_, 0, "scale");
#line 228 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp7_ = rgb_histogram_manipulator_slider_draw_path;
#line 228 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		gtk_widget_path_iter_add_class (_tmp7_, 0, "range");
#line 230 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp8_ = rgb_histogram_manipulator_frame_draw_path;
#line 230 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		gtk_widget_path_append_type (_tmp8_, gtk_frame_get_type ());
#line 231 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp9_ = rgb_histogram_manipulator_frame_draw_path;
#line 231 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		gtk_widget_path_iter_add_class (_tmp9_, 0, "default");
#line 233 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		rgb_histogram_manipulator_paths_setup = TRUE;
#line 1876 "CustomComponents.c"
	}
#line 236 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) GDK_BUTTON_PRESS_MASK);
#line 237 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) GDK_BUTTON_RELEASE_MASK);
#line 238 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) GDK_BUTTON_MOTION_MASK);
#line 240 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "button-press-event", (GCallback) _rgb_histogram_manipulator_on_button_press_gtk_widget_button_press_event, self, 0);
#line 241 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "button-release-event", (GCallback) _rgb_histogram_manipulator_on_button_release_gtk_widget_button_release_event, self, 0);
#line 242 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "motion-notify-event", (GCallback) _rgb_histogram_manipulator_on_button_motion_gtk_widget_motion_notify_event, self, 0);
#line 216 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return self;
#line 1892 "CustomComponents.c"
}


RGBHistogramManipulator* rgb_histogram_manipulator_new (void) {
#line 216 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return rgb_histogram_manipulator_construct (TYPE_RGB_HISTOGRAM_MANIPULATOR);
#line 1899 "CustomComponents.c"
}


static RGBHistogramManipulatorLocationCode rgb_histogram_manipulator_hit_test_point (RGBHistogramManipulator* self, gint x, gint y) {
	RGBHistogramManipulatorLocationCode result = 0;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
#line 245 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), 0);
#line 246 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = y;
#line 246 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp0_ < RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION) {
#line 247 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA;
#line 247 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		return result;
#line 1931 "CustomComponents.c"
	}
#line 249 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp2_ = x;
#line 249 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp3_ = self->priv->left_nub_position;
#line 249 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp2_ > _tmp3_) {
#line 1939 "CustomComponents.c"
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 249 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp4_ = x;
#line 249 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp5_ = self->priv->left_nub_position;
#line 249 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp1_ = _tmp4_ < (_tmp5_ + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE);
#line 1948 "CustomComponents.c"
	} else {
#line 249 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp1_ = FALSE;
#line 1952 "CustomComponents.c"
	}
#line 249 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp1_) {
#line 250 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB;
#line 250 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		return result;
#line 1960 "CustomComponents.c"
	}
#line 252 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp7_ = x;
#line 252 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp8_ = self->priv->right_nub_position;
#line 252 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp7_ > _tmp8_) {
#line 1968 "CustomComponents.c"
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 252 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp9_ = x;
#line 252 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp10_ = self->priv->right_nub_position;
#line 252 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp6_ = _tmp9_ < (_tmp10_ + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE);
#line 1977 "CustomComponents.c"
	} else {
#line 252 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp6_ = FALSE;
#line 1981 "CustomComponents.c"
	}
#line 252 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp6_) {
#line 253 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB;
#line 253 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		return result;
#line 1989 "CustomComponents.c"
	}
#line 255 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp11_ = y;
#line 255 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp11_ < ((RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION + RGB_HISTOGRAM_MANIPULATOR_NUB_V_NUDGE) + 1)) {
#line 256 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA;
#line 256 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		return result;
#line 1999 "CustomComponents.c"
	}
#line 258 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp12_ = x;
#line 258 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp13_ = self->priv->left_nub_position;
#line 258 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp14_ = x;
#line 258 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp15_ = self->priv->left_nub_position;
#line 258 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp16_ = x;
#line 258 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp17_ = self->priv->right_nub_position;
#line 258 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp18_ = x;
#line 258 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp19_ = self->priv->right_nub_position;
#line 258 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (((_tmp12_ - _tmp13_) * (_tmp14_ - _tmp15_)) < ((_tmp16_ - _tmp17_) * (_tmp18_ - _tmp19_))) {
#line 260 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH;
#line 260 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		return result;
#line 2023 "CustomComponents.c"
	} else {
#line 262 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH;
#line 262 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		return result;
#line 2029 "CustomComponents.c"
	}
}


static gboolean rgb_histogram_manipulator_on_button_press (RGBHistogramManipulator* self, GdkEventButton* event_record) {
	gboolean result = FALSE;
	RGBHistogramManipulatorLocationCode loc = 0;
	GdkEventButton* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GdkEventButton* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	RGBHistogramManipulatorLocationCode _tmp4_ = 0;
	RGBHistogramManipulatorLocationCode _tmp5_ = 0;
#line 265 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), FALSE);
#line 265 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_val_if_fail (event_record != NULL, FALSE);
#line 266 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = event_record;
#line 266 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = _tmp0_->x;
#line 266 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp2_ = event_record;
#line 266 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp3_ = _tmp2_->y;
#line 266 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp4_ = rgb_histogram_manipulator_hit_test_point (self, (gint) _tmp1_, (gint) _tmp3_);
#line 266 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	loc = _tmp4_;
#line 268 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp5_ = loc;
#line 268 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	switch (_tmp5_) {
#line 268 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB:
#line 2065 "CustomComponents.c"
		{
			GdkEventButton* _tmp6_ = NULL;
			gdouble _tmp7_ = 0.0;
			gint _tmp8_ = 0;
#line 270 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp6_ = event_record;
#line 270 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp7_ = _tmp6_->x;
#line 270 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			self->priv->track_start_x = (gint) _tmp7_;
#line 271 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp8_ = self->priv->left_nub_position;
#line 271 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			self->priv->track_nub_start_position = _tmp8_;
#line 272 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			self->priv->is_left_nub_tracking = TRUE;
#line 273 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			result = TRUE;
#line 273 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			return result;
#line 2086 "CustomComponents.c"
		}
#line 268 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB:
#line 2090 "CustomComponents.c"
		{
			GdkEventButton* _tmp9_ = NULL;
			gdouble _tmp10_ = 0.0;
			gint _tmp11_ = 0;
#line 276 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp9_ = event_record;
#line 276 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp10_ = _tmp9_->x;
#line 276 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			self->priv->track_start_x = (gint) _tmp10_;
#line 277 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp11_ = self->priv->right_nub_position;
#line 277 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			self->priv->track_nub_start_position = _tmp11_;
#line 278 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			self->priv->is_right_nub_tracking = TRUE;
#line 279 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			result = TRUE;
#line 279 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			return result;
#line 2111 "CustomComponents.c"
		}
#line 268 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH:
#line 2115 "CustomComponents.c"
		{
			GdkEventButton* _tmp12_ = NULL;
			gdouble _tmp13_ = 0.0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
#line 282 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp12_ = event_record;
#line 282 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp13_ = _tmp12_->x;
#line 282 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			self->priv->left_nub_position = ((gint) _tmp13_) - RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH;
#line 283 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp14_ = self->priv->left_nub_position;
#line 283 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp15_ = self->priv->left_nub_max;
#line 283 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp16_ = CLAMP (_tmp14_, 0, _tmp15_);
#line 283 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			self->priv->left_nub_position = _tmp16_;
#line 284 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			rgb_histogram_manipulator_force_update (self);
#line 285 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			g_signal_emit_by_name (self, "nub-position-changed");
#line 286 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			rgb_histogram_manipulator_update_nub_extrema (self);
#line 287 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			result = TRUE;
#line 287 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			return result;
#line 2146 "CustomComponents.c"
		}
#line 268 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH:
#line 2150 "CustomComponents.c"
		{
			GdkEventButton* _tmp17_ = NULL;
			gdouble _tmp18_ = 0.0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
#line 290 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp17_ = event_record;
#line 290 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp18_ = _tmp17_->x;
#line 290 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			self->priv->right_nub_position = ((gint) _tmp18_) - RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH;
#line 291 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp19_ = self->priv->right_nub_position;
#line 291 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp20_ = self->priv->right_nub_min;
#line 291 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			_tmp21_ = CLAMP (_tmp19_, _tmp20_, 255);
#line 291 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			self->priv->right_nub_position = _tmp21_;
#line 292 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			rgb_histogram_manipulator_force_update (self);
#line 293 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			g_signal_emit_by_name (self, "nub-position-changed");
#line 294 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			rgb_histogram_manipulator_update_nub_extrema (self);
#line 295 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			result = TRUE;
#line 295 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			return result;
#line 2181 "CustomComponents.c"
		}
		default:
		{
#line 298 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			result = FALSE;
#line 298 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			return result;
#line 2189 "CustomComponents.c"
		}
	}
}


static gboolean rgb_histogram_manipulator_on_button_release (RGBHistogramManipulator* self, GdkEventButton* event_record) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 302 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), FALSE);
#line 302 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_val_if_fail (event_record != NULL, FALSE);
#line 303 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = self->priv->is_left_nub_tracking;
#line 303 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp1_) {
#line 303 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp0_ = TRUE;
#line 2209 "CustomComponents.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 303 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp2_ = self->priv->is_right_nub_tracking;
#line 303 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp0_ = _tmp2_;
#line 2216 "CustomComponents.c"
	}
#line 303 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp0_) {
#line 304 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		g_signal_emit_by_name (self, "nub-position-changed");
#line 305 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		rgb_histogram_manipulator_update_nub_extrema (self);
#line 2224 "CustomComponents.c"
	}
#line 308 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->is_left_nub_tracking = FALSE;
#line 309 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->is_right_nub_tracking = FALSE;
#line 311 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	result = FALSE;
#line 311 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 2234 "CustomComponents.c"
}


static gboolean rgb_histogram_manipulator_on_button_motion (RGBHistogramManipulator* self, GdkEventMotion* event_record) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 314 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), FALSE);
#line 314 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_val_if_fail (event_record != NULL, FALSE);
#line 315 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = self->priv->is_left_nub_tracking;
#line 315 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (!_tmp1_) {
#line 2251 "CustomComponents.c"
		gboolean _tmp2_ = FALSE;
#line 315 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp2_ = self->priv->is_right_nub_tracking;
#line 315 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp0_ = !_tmp2_;
#line 2257 "CustomComponents.c"
	} else {
#line 315 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp0_ = FALSE;
#line 2261 "CustomComponents.c"
	}
#line 315 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp0_) {
#line 316 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		result = FALSE;
#line 316 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		return result;
#line 2269 "CustomComponents.c"
	}
#line 318 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp3_ = self->priv->is_left_nub_tracking;
#line 318 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp3_) {
#line 2275 "CustomComponents.c"
		gint track_x_delta = 0;
		GdkEventMotion* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 319 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp4_ = event_record;
#line 319 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp5_ = _tmp4_->x;
#line 319 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp6_ = self->priv->track_start_x;
#line 319 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		track_x_delta = ((gint) _tmp5_) - _tmp6_;
#line 320 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp7_ = self->priv->track_nub_start_position;
#line 320 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp8_ = track_x_delta;
#line 320 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		self->priv->left_nub_position = _tmp7_ + _tmp8_;
#line 321 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp9_ = self->priv->left_nub_position;
#line 321 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp10_ = self->priv->left_nub_max;
#line 321 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp11_ = CLAMP (_tmp9_, 0, _tmp10_);
#line 321 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		self->priv->left_nub_position = _tmp11_;
#line 2307 "CustomComponents.c"
	} else {
		gint track_x_delta = 0;
		GdkEventMotion* _tmp12_ = NULL;
		gdouble _tmp13_ = 0.0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
#line 323 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp12_ = event_record;
#line 323 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp13_ = _tmp12_->x;
#line 323 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp14_ = self->priv->track_start_x;
#line 323 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		track_x_delta = ((gint) _tmp13_) - _tmp14_;
#line 324 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp15_ = self->priv->track_nub_start_position;
#line 324 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp16_ = track_x_delta;
#line 324 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		self->priv->right_nub_position = _tmp15_ + _tmp16_;
#line 325 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp17_ = self->priv->right_nub_position;
#line 325 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp18_ = self->priv->right_nub_min;
#line 325 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp19_ = CLAMP (_tmp17_, _tmp18_, 255);
#line 325 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		self->priv->right_nub_position = _tmp19_;
#line 2340 "CustomComponents.c"
	}
#line 328 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	rgb_histogram_manipulator_force_update (self);
#line 329 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	result = TRUE;
#line 329 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 2348 "CustomComponents.c"
}


static gboolean rgb_histogram_manipulator_real_draw (GtkWidget* base, cairo_t* ctx) {
	RGBHistogramManipulator * self;
	gboolean result = FALSE;
	GtkBorder padding = {0};
	GtkStyleContext* _tmp0_ = NULL;
	GtkBorder _tmp1_ = {0};
	GdkRectangle area = {0};
	GtkBorder _tmp2_ = {0};
	gint16 _tmp3_ = 0;
	GtkBorder _tmp4_ = {0};
	gint16 _tmp5_ = 0;
	GtkBorder _tmp6_ = {0};
	gint16 _tmp7_ = 0;
	GtkBorder _tmp8_ = {0};
	gint16 _tmp9_ = 0;
	cairo_t* _tmp10_ = NULL;
	GdkRectangle _tmp11_ = {0};
	cairo_t* _tmp12_ = NULL;
	GdkRectangle _tmp13_ = {0};
	cairo_t* _tmp14_ = NULL;
	GdkRectangle _tmp15_ = {0};
	cairo_t* _tmp16_ = NULL;
	GdkRectangle _tmp17_ = {0};
	gint _tmp18_ = 0;
	cairo_t* _tmp19_ = NULL;
	GdkRectangle _tmp20_ = {0};
	gint _tmp21_ = 0;
#line 332 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulator);
#line 332 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_val_if_fail (ctx != NULL, FALSE);
#line 333 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 333 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_style_context_get_padding (_tmp0_, GTK_STATE_FLAG_NORMAL, &_tmp1_);
#line 333 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	padding = _tmp1_;
#line 335 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	memset (&area, 0, sizeof (GdkRectangle));
#line 336 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp2_ = padding;
#line 336 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp3_ = _tmp2_.left;
#line 336 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	area.x = (gint) _tmp3_;
#line 337 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp4_ = padding;
#line 337 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp5_ = _tmp4_.top;
#line 337 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	area.y = (gint) _tmp5_;
#line 338 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp6_ = padding;
#line 338 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp7_ = _tmp6_.right;
#line 338 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	area.width = RGB_HISTOGRAM_GRAPHIC_WIDTH + _tmp7_;
#line 339 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp8_ = padding;
#line 339 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp9_ = _tmp8_.bottom;
#line 339 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	area.height = RGB_HISTOGRAM_GRAPHIC_HEIGHT + _tmp9_;
#line 341 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp10_ = ctx;
#line 341 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp11_ = area;
#line 341 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	rgb_histogram_manipulator_draw_histogram_frame (self, _tmp10_, &_tmp11_);
#line 342 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp12_ = ctx;
#line 342 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp13_ = area;
#line 342 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	rgb_histogram_manipulator_draw_histogram (self, _tmp12_, &_tmp13_);
#line 343 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp14_ = ctx;
#line 343 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp15_ = area;
#line 343 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	rgb_histogram_manipulator_draw_trough (self, _tmp14_, &_tmp15_);
#line 344 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp16_ = ctx;
#line 344 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp17_ = area;
#line 344 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp18_ = self->priv->left_nub_position;
#line 344 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	rgb_histogram_manipulator_draw_nub (self, _tmp16_, &_tmp17_, _tmp18_);
#line 345 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp19_ = ctx;
#line 345 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp20_ = area;
#line 345 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp21_ = self->priv->right_nub_position;
#line 345 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	rgb_histogram_manipulator_draw_nub (self, _tmp19_, &_tmp20_, _tmp21_);
#line 347 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	result = TRUE;
#line 347 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 2453 "CustomComponents.c"
}


static void rgb_histogram_manipulator_draw_histogram_frame (RGBHistogramManipulator* self, cairo_t* ctx, GdkRectangle* area) {
	GdkRectangle framed_area = {0};
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkStyleContext* stylectx = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	GtkStyleContext* _tmp7_ = NULL;
	GtkWidgetPath* _tmp8_ = NULL;
	GtkWidgetPath* _tmp9_ = NULL;
	cairo_t* _tmp10_ = NULL;
	GdkRectangle _tmp11_ = {0};
	gint _tmp12_ = 0;
	GdkRectangle _tmp13_ = {0};
	gint _tmp14_ = 0;
	GdkRectangle _tmp15_ = {0};
	gint _tmp16_ = 0;
	GdkRectangle _tmp17_ = {0};
	gint _tmp18_ = 0;
#line 350 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 350 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (ctx != NULL);
#line 350 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (area != NULL);
#line 353 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = *area;
#line 353 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	framed_area = _tmp0_;
#line 354 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = framed_area.x;
#line 354 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	framed_area.x = _tmp1_ + 5;
#line 355 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp2_ = framed_area.y;
#line 355 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	framed_area.y = _tmp2_ + 1;
#line 356 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp3_ = framed_area.width;
#line 356 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	framed_area.width = _tmp3_ - 8;
#line 357 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp4_ = framed_area.height;
#line 357 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	framed_area.height = _tmp4_ - 12;
#line 359 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp5_ = rgb_histogram_manipulator_dummy_frame;
#line 359 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp6_ = gtk_widget_get_style_context (_tmp5_);
#line 359 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 359 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	stylectx = _tmp7_;
#line 360 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_style_context_save (stylectx);
#line 362 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp8_ = gtk_style_context_get_path (stylectx);
#line 362 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_widget_path_append_type (_tmp8_, gtk_frame_get_type ());
#line 363 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp9_ = gtk_style_context_get_path (stylectx);
#line 363 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_widget_path_iter_add_class (_tmp9_, 0, "default");
#line 364 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_style_context_add_class (stylectx, GTK_STYLE_CLASS_TROUGH);
#line 365 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_style_context_set_junction_sides (stylectx, ((GTK_JUNCTION_TOP | GTK_JUNCTION_BOTTOM) | GTK_JUNCTION_LEFT) | GTK_JUNCTION_RIGHT);
#line 368 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp10_ = ctx;
#line 368 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp11_ = framed_area;
#line 368 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp12_ = _tmp11_.x;
#line 368 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp13_ = framed_area;
#line 368 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp14_ = _tmp13_.y;
#line 368 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp15_ = framed_area;
#line 368 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp16_ = _tmp15_.width;
#line 368 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp17_ = framed_area;
#line 368 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp18_ = _tmp17_.height;
#line 368 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_render_frame (stylectx, _tmp10_, (gdouble) _tmp12_, (gdouble) _tmp14_, (gdouble) _tmp16_, (gdouble) _tmp18_);
#line 371 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_style_context_restore (stylectx);
#line 350 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_g_object_unref0 (stylectx);
#line 2551 "CustomComponents.c"
}


static void rgb_histogram_manipulator_draw_histogram (RGBHistogramManipulator* self, cairo_t* ctx, GdkRectangle* area) {
	RGBHistogram* _tmp0_ = NULL;
	GdkPixbuf* histogram_graphic = NULL;
	RGBHistogram* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	guchar* pixel_data = NULL;
	GdkPixbuf* _tmp6_ = NULL;
	guint8* _tmp7_ = NULL;
	gint pixel_data_length1 = 0;
	gint _pixel_data_size_ = 0;
	gint edge_blend_red = 0;
	gint edge_blend_green = 0;
	gint edge_blend_blue = 0;
	gint body_blend_red = 0;
	gint body_blend_green = 0;
	gint body_blend_blue = 0;
	gint _tmp8_ = 0;
	gint _tmp80_ = 0;
	cairo_t* _tmp158_ = NULL;
	GdkPixbuf* _tmp159_ = NULL;
	GdkRectangle _tmp160_ = {0};
	gint _tmp161_ = 0;
	GdkRectangle _tmp162_ = {0};
	gint _tmp163_ = 0;
	cairo_t* _tmp164_ = NULL;
#line 374 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 374 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (ctx != NULL);
#line 374 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (area != NULL);
#line 375 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = self->priv->histogram;
#line 375 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp0_ == NULL) {
#line 376 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		return;
#line 2595 "CustomComponents.c"
	}
#line 378 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = self->priv->histogram;
#line 378 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp2_ = rgb_histogram_get_graphic (_tmp1_);
#line 378 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp3_ = _tmp2_;
#line 378 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp4_ = gdk_pixbuf_copy (_tmp3_);
#line 378 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp5_ = _tmp4_;
#line 378 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_g_object_unref0 (_tmp3_);
#line 378 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	histogram_graphic = _tmp5_;
#line 379 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp6_ = histogram_graphic;
#line 379 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp7_ = gdk_pixbuf_get_pixels (_tmp6_);
#line 379 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	pixel_data = _tmp7_;
#line 379 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	pixel_data_length1 = -1;
#line 379 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_pixel_data_size_ = pixel_data_length1;
#line 381 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	edge_blend_red = 0;
#line 382 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	edge_blend_green = 0;
#line 383 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	edge_blend_blue = 0;
#line 384 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	body_blend_red = 20;
#line 385 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	body_blend_green = 20;
#line 386 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	body_blend_blue = 20;
#line 388 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp8_ = self->priv->left_nub_position;
#line 388 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp8_ > 0) {
#line 2637 "CustomComponents.c"
		gint edge_pixel_index = 0;
		GdkPixbuf* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 389 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp9_ = histogram_graphic;
#line 389 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp10_ = gdk_pixbuf_get_n_channels (_tmp9_);
#line 389 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp11_ = _tmp10_;
#line 389 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp12_ = self->priv->left_nub_position;
#line 389 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		edge_pixel_index = _tmp11_ * _tmp12_;
#line 2653 "CustomComponents.c"
		{
			gint i = 0;
#line 390 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			i = 0;
#line 2658 "CustomComponents.c"
			{
				gboolean _tmp13_ = FALSE;
#line 390 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				_tmp13_ = TRUE;
#line 390 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				while (TRUE) {
#line 2665 "CustomComponents.c"
					gint _tmp15_ = 0;
					GdkPixbuf* _tmp16_ = NULL;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					gint body_pixel_index = 0;
					gint _tmp19_ = 0;
					GdkPixbuf* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					gint _tmp22_ = 0;
					gint row_last_pixel = 0;
					gint _tmp23_ = 0;
					GdkPixbuf* _tmp24_ = NULL;
					gint _tmp25_ = 0;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					guchar* _tmp55_ = NULL;
					gint _tmp55__length1 = 0;
					gint _tmp56_ = 0;
					guchar* _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					guchar _tmp59_ = '\0';
					gint _tmp60_ = 0;
					guchar _tmp61_ = '\0';
					guchar* _tmp62_ = NULL;
					gint _tmp62__length1 = 0;
					gint _tmp63_ = 0;
					guchar* _tmp64_ = NULL;
					gint _tmp64__length1 = 0;
					gint _tmp65_ = 0;
					guchar _tmp66_ = '\0';
					gint _tmp67_ = 0;
					guchar _tmp68_ = '\0';
					guchar* _tmp69_ = NULL;
					gint _tmp69__length1 = 0;
					gint _tmp70_ = 0;
					guchar* _tmp71_ = NULL;
					gint _tmp71__length1 = 0;
					gint _tmp72_ = 0;
					guchar _tmp73_ = '\0';
					gint _tmp74_ = 0;
					guchar _tmp75_ = '\0';
					gint _tmp76_ = 0;
					GdkPixbuf* _tmp77_ = NULL;
					gint _tmp78_ = 0;
					gint _tmp79_ = 0;
#line 390 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					if (!_tmp13_) {
#line 2714 "CustomComponents.c"
						gint _tmp14_ = 0;
#line 390 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp14_ = i;
#line 390 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						i = _tmp14_ + 1;
#line 2720 "CustomComponents.c"
					}
#line 390 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp13_ = FALSE;
#line 390 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp15_ = i;
#line 390 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp16_ = histogram_graphic;
#line 390 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp17_ = gdk_pixbuf_get_height (_tmp16_);
#line 390 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp18_ = _tmp17_;
#line 390 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					if (!(_tmp15_ < _tmp18_)) {
#line 390 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						break;
#line 2736 "CustomComponents.c"
					}
#line 391 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp19_ = i;
#line 391 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp20_ = histogram_graphic;
#line 391 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp21_ = gdk_pixbuf_get_rowstride (_tmp20_);
#line 391 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp22_ = _tmp21_;
#line 391 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					body_pixel_index = _tmp19_ * _tmp22_;
#line 392 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp23_ = body_pixel_index;
#line 392 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp24_ = histogram_graphic;
#line 392 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp25_ = gdk_pixbuf_get_n_channels (_tmp24_);
#line 392 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp26_ = _tmp25_;
#line 392 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp27_ = self->priv->left_nub_position;
#line 392 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					row_last_pixel = _tmp23_ + (_tmp26_ * _tmp27_);
#line 394 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					while (TRUE) {
#line 2762 "CustomComponents.c"
						gint _tmp28_ = 0;
						gint _tmp29_ = 0;
						guchar* _tmp30_ = NULL;
						gint _tmp30__length1 = 0;
						gint _tmp31_ = 0;
						guchar* _tmp32_ = NULL;
						gint _tmp32__length1 = 0;
						gint _tmp33_ = 0;
						guchar _tmp34_ = '\0';
						gint _tmp35_ = 0;
						guchar _tmp36_ = '\0';
						guchar* _tmp37_ = NULL;
						gint _tmp37__length1 = 0;
						gint _tmp38_ = 0;
						guchar* _tmp39_ = NULL;
						gint _tmp39__length1 = 0;
						gint _tmp40_ = 0;
						guchar _tmp41_ = '\0';
						gint _tmp42_ = 0;
						guchar _tmp43_ = '\0';
						guchar* _tmp44_ = NULL;
						gint _tmp44__length1 = 0;
						gint _tmp45_ = 0;
						guchar* _tmp46_ = NULL;
						gint _tmp46__length1 = 0;
						gint _tmp47_ = 0;
						guchar _tmp48_ = '\0';
						gint _tmp49_ = 0;
						guchar _tmp50_ = '\0';
						gint _tmp51_ = 0;
						GdkPixbuf* _tmp52_ = NULL;
						gint _tmp53_ = 0;
						gint _tmp54_ = 0;
#line 394 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp28_ = body_pixel_index;
#line 394 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp29_ = row_last_pixel;
#line 394 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						if (!(_tmp28_ < _tmp29_)) {
#line 394 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							break;
#line 2804 "CustomComponents.c"
						}
#line 395 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp30_ = pixel_data;
#line 395 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp30__length1 = pixel_data_length1;
#line 395 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp31_ = body_pixel_index;
#line 395 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp32_ = pixel_data;
#line 395 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp32__length1 = pixel_data_length1;
#line 395 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp33_ = body_pixel_index;
#line 395 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp34_ = _tmp32_[_tmp33_];
#line 395 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp35_ = body_blend_red;
#line 395 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp30_[_tmp31_] = (guchar) ((_tmp34_ + _tmp35_) / 2);
#line 395 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp36_ = _tmp30_[_tmp31_];
#line 397 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp37_ = pixel_data;
#line 397 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp37__length1 = pixel_data_length1;
#line 397 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp38_ = body_pixel_index;
#line 397 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp39_ = pixel_data;
#line 397 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp39__length1 = pixel_data_length1;
#line 397 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp40_ = body_pixel_index;
#line 397 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp41_ = _tmp39_[_tmp40_ + 1];
#line 397 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp42_ = body_blend_green;
#line 397 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp37_[_tmp38_ + 1] = (guchar) ((_tmp41_ + _tmp42_) / 2);
#line 397 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp43_ = _tmp37_[_tmp38_ + 1];
#line 399 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp44_ = pixel_data;
#line 399 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp44__length1 = pixel_data_length1;
#line 399 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp45_ = body_pixel_index;
#line 399 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp46_ = pixel_data;
#line 399 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp46__length1 = pixel_data_length1;
#line 399 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp47_ = body_pixel_index;
#line 399 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp48_ = _tmp46_[_tmp47_ + 2];
#line 399 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp49_ = body_blend_blue;
#line 399 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp44_[_tmp45_ + 2] = (guchar) ((_tmp48_ + _tmp49_) / 2);
#line 399 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp50_ = _tmp44_[_tmp45_ + 2];
#line 402 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp51_ = body_pixel_index;
#line 402 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp52_ = histogram_graphic;
#line 402 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp53_ = gdk_pixbuf_get_n_channels (_tmp52_);
#line 402 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp54_ = _tmp53_;
#line 402 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						body_pixel_index = _tmp51_ + _tmp54_;
#line 2876 "CustomComponents.c"
					}
#line 405 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp55_ = pixel_data;
#line 405 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp55__length1 = pixel_data_length1;
#line 405 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp56_ = edge_pixel_index;
#line 405 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp57_ = pixel_data;
#line 405 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp57__length1 = pixel_data_length1;
#line 405 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp58_ = edge_pixel_index;
#line 405 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp59_ = _tmp57_[_tmp58_];
#line 405 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp60_ = edge_blend_red;
#line 405 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp55_[_tmp56_] = (guchar) ((_tmp59_ + _tmp60_) / 2);
#line 405 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp61_ = _tmp55_[_tmp56_];
#line 407 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp62_ = pixel_data;
#line 407 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp62__length1 = pixel_data_length1;
#line 407 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp63_ = edge_pixel_index;
#line 407 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp64_ = pixel_data;
#line 407 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp64__length1 = pixel_data_length1;
#line 407 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp65_ = edge_pixel_index;
#line 407 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp66_ = _tmp64_[_tmp65_ + 1];
#line 407 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp67_ = edge_blend_green;
#line 407 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp62_[_tmp63_ + 1] = (guchar) ((_tmp66_ + _tmp67_) / 2);
#line 407 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp68_ = _tmp62_[_tmp63_ + 1];
#line 409 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp69_ = pixel_data;
#line 409 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp69__length1 = pixel_data_length1;
#line 409 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp70_ = edge_pixel_index;
#line 409 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp71_ = pixel_data;
#line 409 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp71__length1 = pixel_data_length1;
#line 409 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp72_ = edge_pixel_index;
#line 409 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp73_ = _tmp71_[_tmp72_ + 2];
#line 409 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp74_ = edge_blend_blue;
#line 409 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp69_[_tmp70_ + 2] = (guchar) ((_tmp73_ + _tmp74_) / 2);
#line 409 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp75_ = _tmp69_[_tmp70_ + 2];
#line 412 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp76_ = edge_pixel_index;
#line 412 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp77_ = histogram_graphic;
#line 412 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp78_ = gdk_pixbuf_get_rowstride (_tmp77_);
#line 412 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp79_ = _tmp78_;
#line 412 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					edge_pixel_index = _tmp76_ + _tmp79_;
#line 2948 "CustomComponents.c"
				}
			}
		}
	}
#line 416 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	edge_blend_red = 250;
#line 417 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	edge_blend_green = 250;
#line 418 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	edge_blend_blue = 250;
#line 419 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	body_blend_red = 200;
#line 420 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	body_blend_green = 200;
#line 421 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	body_blend_blue = 200;
#line 423 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp80_ = self->priv->right_nub_position;
#line 423 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp80_ < 255) {
#line 2969 "CustomComponents.c"
		gint edge_pixel_index = 0;
		GdkPixbuf* _tmp81_ = NULL;
		gint _tmp82_ = 0;
		gint _tmp83_ = 0;
		gint _tmp84_ = 0;
#line 424 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp81_ = histogram_graphic;
#line 424 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp82_ = gdk_pixbuf_get_n_channels (_tmp81_);
#line 424 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp83_ = _tmp82_;
#line 424 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp84_ = self->priv->right_nub_position;
#line 424 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		edge_pixel_index = _tmp83_ * _tmp84_;
#line 2985 "CustomComponents.c"
		{
			gint i = 0;
#line 425 "/home/jens/Source/shotwell/src/CustomComponents.vala"
			i = 0;
#line 2990 "CustomComponents.c"
			{
				gboolean _tmp85_ = FALSE;
#line 425 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				_tmp85_ = TRUE;
#line 425 "/home/jens/Source/shotwell/src/CustomComponents.vala"
				while (TRUE) {
#line 2997 "CustomComponents.c"
					gint _tmp87_ = 0;
					GdkPixbuf* _tmp88_ = NULL;
					gint _tmp89_ = 0;
					gint _tmp90_ = 0;
					gint body_pixel_index = 0;
					gint _tmp91_ = 0;
					GdkPixbuf* _tmp92_ = NULL;
					gint _tmp93_ = 0;
					gint _tmp94_ = 0;
					GdkPixbuf* _tmp95_ = NULL;
					gint _tmp96_ = 0;
					gint _tmp97_ = 0;
					gint row_last_pixel = 0;
					gint _tmp98_ = 0;
					GdkPixbuf* _tmp99_ = NULL;
					gint _tmp100_ = 0;
					gint _tmp101_ = 0;
					GdkPixbuf* _tmp102_ = NULL;
					gint _tmp103_ = 0;
					gint _tmp104_ = 0;
					gint _tmp105_ = 0;
					guchar* _tmp133_ = NULL;
					gint _tmp133__length1 = 0;
					gint _tmp134_ = 0;
					guchar* _tmp135_ = NULL;
					gint _tmp135__length1 = 0;
					gint _tmp136_ = 0;
					guchar _tmp137_ = '\0';
					gint _tmp138_ = 0;
					guchar _tmp139_ = '\0';
					guchar* _tmp140_ = NULL;
					gint _tmp140__length1 = 0;
					gint _tmp141_ = 0;
					guchar* _tmp142_ = NULL;
					gint _tmp142__length1 = 0;
					gint _tmp143_ = 0;
					guchar _tmp144_ = '\0';
					gint _tmp145_ = 0;
					guchar _tmp146_ = '\0';
					guchar* _tmp147_ = NULL;
					gint _tmp147__length1 = 0;
					gint _tmp148_ = 0;
					guchar* _tmp149_ = NULL;
					gint _tmp149__length1 = 0;
					gint _tmp150_ = 0;
					guchar _tmp151_ = '\0';
					gint _tmp152_ = 0;
					guchar _tmp153_ = '\0';
					gint _tmp154_ = 0;
					GdkPixbuf* _tmp155_ = NULL;
					gint _tmp156_ = 0;
					gint _tmp157_ = 0;
#line 425 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					if (!_tmp85_) {
#line 3052 "CustomComponents.c"
						gint _tmp86_ = 0;
#line 425 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp86_ = i;
#line 425 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						i = _tmp86_ + 1;
#line 3058 "CustomComponents.c"
					}
#line 425 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp85_ = FALSE;
#line 425 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp87_ = i;
#line 425 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp88_ = histogram_graphic;
#line 425 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp89_ = gdk_pixbuf_get_height (_tmp88_);
#line 425 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp90_ = _tmp89_;
#line 425 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					if (!(_tmp87_ < _tmp90_)) {
#line 425 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						break;
#line 3074 "CustomComponents.c"
					}
#line 426 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp91_ = i;
#line 426 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp92_ = histogram_graphic;
#line 426 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp93_ = gdk_pixbuf_get_rowstride (_tmp92_);
#line 426 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp94_ = _tmp93_;
#line 426 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp95_ = histogram_graphic;
#line 426 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp96_ = gdk_pixbuf_get_n_channels (_tmp95_);
#line 426 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp97_ = _tmp96_;
#line 426 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					body_pixel_index = (_tmp91_ * _tmp94_) + (_tmp97_ * 255);
#line 428 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp98_ = i;
#line 428 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp99_ = histogram_graphic;
#line 428 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp100_ = gdk_pixbuf_get_rowstride (_tmp99_);
#line 428 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp101_ = _tmp100_;
#line 428 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp102_ = histogram_graphic;
#line 428 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp103_ = gdk_pixbuf_get_n_channels (_tmp102_);
#line 428 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp104_ = _tmp103_;
#line 428 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp105_ = self->priv->right_nub_position;
#line 428 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					row_last_pixel = (_tmp98_ * _tmp101_) + (_tmp104_ * _tmp105_);
#line 430 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					while (TRUE) {
#line 3112 "CustomComponents.c"
						gint _tmp106_ = 0;
						gint _tmp107_ = 0;
						guchar* _tmp108_ = NULL;
						gint _tmp108__length1 = 0;
						gint _tmp109_ = 0;
						guchar* _tmp110_ = NULL;
						gint _tmp110__length1 = 0;
						gint _tmp111_ = 0;
						guchar _tmp112_ = '\0';
						gint _tmp113_ = 0;
						guchar _tmp114_ = '\0';
						guchar* _tmp115_ = NULL;
						gint _tmp115__length1 = 0;
						gint _tmp116_ = 0;
						guchar* _tmp117_ = NULL;
						gint _tmp117__length1 = 0;
						gint _tmp118_ = 0;
						guchar _tmp119_ = '\0';
						gint _tmp120_ = 0;
						guchar _tmp121_ = '\0';
						guchar* _tmp122_ = NULL;
						gint _tmp122__length1 = 0;
						gint _tmp123_ = 0;
						guchar* _tmp124_ = NULL;
						gint _tmp124__length1 = 0;
						gint _tmp125_ = 0;
						guchar _tmp126_ = '\0';
						gint _tmp127_ = 0;
						guchar _tmp128_ = '\0';
						gint _tmp129_ = 0;
						GdkPixbuf* _tmp130_ = NULL;
						gint _tmp131_ = 0;
						gint _tmp132_ = 0;
#line 430 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp106_ = body_pixel_index;
#line 430 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp107_ = row_last_pixel;
#line 430 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						if (!(_tmp106_ > _tmp107_)) {
#line 430 "/home/jens/Source/shotwell/src/CustomComponents.vala"
							break;
#line 3154 "CustomComponents.c"
						}
#line 431 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp108_ = pixel_data;
#line 431 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp108__length1 = pixel_data_length1;
#line 431 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp109_ = body_pixel_index;
#line 431 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp110_ = pixel_data;
#line 431 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp110__length1 = pixel_data_length1;
#line 431 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp111_ = body_pixel_index;
#line 431 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp112_ = _tmp110_[_tmp111_];
#line 431 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp113_ = body_blend_red;
#line 431 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp108_[_tmp109_] = (guchar) ((_tmp112_ + _tmp113_) / 2);
#line 431 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp114_ = _tmp108_[_tmp109_];
#line 433 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp115_ = pixel_data;
#line 433 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp115__length1 = pixel_data_length1;
#line 433 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp116_ = body_pixel_index;
#line 433 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp117_ = pixel_data;
#line 433 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp117__length1 = pixel_data_length1;
#line 433 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp118_ = body_pixel_index;
#line 433 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp119_ = _tmp117_[_tmp118_ + 1];
#line 433 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp120_ = body_blend_green;
#line 433 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp115_[_tmp116_ + 1] = (guchar) ((_tmp119_ + _tmp120_) / 2);
#line 433 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp121_ = _tmp115_[_tmp116_ + 1];
#line 435 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp122_ = pixel_data;
#line 435 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp122__length1 = pixel_data_length1;
#line 435 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp123_ = body_pixel_index;
#line 435 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp124_ = pixel_data;
#line 435 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp124__length1 = pixel_data_length1;
#line 435 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp125_ = body_pixel_index;
#line 435 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp126_ = _tmp124_[_tmp125_ + 2];
#line 435 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp127_ = body_blend_blue;
#line 435 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp122_[_tmp123_ + 2] = (guchar) ((_tmp126_ + _tmp127_) / 2);
#line 435 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp128_ = _tmp122_[_tmp123_ + 2];
#line 438 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp129_ = body_pixel_index;
#line 438 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp130_ = histogram_graphic;
#line 438 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp131_ = gdk_pixbuf_get_n_channels (_tmp130_);
#line 438 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						_tmp132_ = _tmp131_;
#line 438 "/home/jens/Source/shotwell/src/CustomComponents.vala"
						body_pixel_index = _tmp129_ - _tmp132_;
#line 3226 "CustomComponents.c"
					}
#line 440 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp133_ = pixel_data;
#line 440 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp133__length1 = pixel_data_length1;
#line 440 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp134_ = edge_pixel_index;
#line 440 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp135_ = pixel_data;
#line 440 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp135__length1 = pixel_data_length1;
#line 440 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp136_ = edge_pixel_index;
#line 440 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp137_ = _tmp135_[_tmp136_];
#line 440 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp138_ = edge_blend_red;
#line 440 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp133_[_tmp134_] = (guchar) ((_tmp137_ + _tmp138_) / 2);
#line 440 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp139_ = _tmp133_[_tmp134_];
#line 442 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp140_ = pixel_data;
#line 442 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp140__length1 = pixel_data_length1;
#line 442 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp141_ = edge_pixel_index;
#line 442 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp142_ = pixel_data;
#line 442 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp142__length1 = pixel_data_length1;
#line 442 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp143_ = edge_pixel_index;
#line 442 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp144_ = _tmp142_[_tmp143_ + 1];
#line 442 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp145_ = edge_blend_green;
#line 442 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp140_[_tmp141_ + 1] = (guchar) ((_tmp144_ + _tmp145_) / 2);
#line 442 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp146_ = _tmp140_[_tmp141_ + 1];
#line 444 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp147_ = pixel_data;
#line 444 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp147__length1 = pixel_data_length1;
#line 444 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp148_ = edge_pixel_index;
#line 444 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp149_ = pixel_data;
#line 444 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp149__length1 = pixel_data_length1;
#line 444 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp150_ = edge_pixel_index;
#line 444 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp151_ = _tmp149_[_tmp150_ + 2];
#line 444 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp152_ = edge_blend_blue;
#line 444 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp147_[_tmp148_ + 2] = (guchar) ((_tmp151_ + _tmp152_) / 2);
#line 444 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp153_ = _tmp147_[_tmp148_ + 2];
#line 447 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp154_ = edge_pixel_index;
#line 447 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp155_ = histogram_graphic;
#line 447 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp156_ = gdk_pixbuf_get_rowstride (_tmp155_);
#line 447 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					_tmp157_ = _tmp156_;
#line 447 "/home/jens/Source/shotwell/src/CustomComponents.vala"
					edge_pixel_index = _tmp154_ + _tmp157_;
#line 3298 "CustomComponents.c"
				}
			}
		}
	}
#line 451 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp158_ = ctx;
#line 451 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp159_ = histogram_graphic;
#line 451 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp160_ = *area;
#line 451 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp161_ = _tmp160_.x;
#line 451 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp162_ = *area;
#line 451 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp163_ = _tmp162_.y;
#line 451 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gdk_cairo_set_source_pixbuf (_tmp158_, _tmp159_, (gdouble) (_tmp161_ + RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH), (gdouble) (_tmp163_ + 2));
#line 452 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp164_ = ctx;
#line 452 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	cairo_paint (_tmp164_);
#line 374 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_g_object_unref0 (histogram_graphic);
#line 3323 "CustomComponents.c"
}


static void rgb_histogram_manipulator_draw_trough (RGBHistogramManipulator* self, cairo_t* ctx, GdkRectangle* area) {
	gint trough_x = 0;
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint trough_y = 0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	GtkStyleContext* stylectx = NULL;
	GtkWidget* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	GtkWidgetPath* _tmp7_ = NULL;
	GtkWidgetPath* _tmp8_ = NULL;
	cairo_t* _tmp9_ = NULL;
#line 455 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 455 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (ctx != NULL);
#line 455 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (area != NULL);
#line 456 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = *area;
#line 456 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = _tmp0_.x;
#line 456 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	trough_x = _tmp1_;
#line 457 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp2_ = *area;
#line 457 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp3_ = _tmp2_.y;
#line 457 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	trough_y = _tmp3_ + (((RGB_HISTOGRAM_MANIPULATOR_CONTROL_HEIGHT - RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT) - RGB_HISTOGRAM_MANIPULATOR_TROUGH_BOTTOM_OFFSET) - 3);
#line 459 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp4_ = rgb_histogram_manipulator_dummy_slider;
#line 459 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp5_ = gtk_widget_get_style_context (_tmp4_);
#line 459 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 459 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	stylectx = _tmp6_;
#line 460 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_style_context_save (stylectx);
#line 462 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp7_ = gtk_style_context_get_path (stylectx);
#line 462 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_widget_path_append_type (_tmp7_, gtk_scale_get_type ());
#line 463 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp8_ = gtk_style_context_get_path (stylectx);
#line 463 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_widget_path_iter_add_class (_tmp8_, 0, "scale");
#line 464 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_style_context_add_class (stylectx, GTK_STYLE_CLASS_TROUGH);
#line 466 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp9_ = ctx;
#line 466 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_render_activity (stylectx, _tmp9_, (gdouble) trough_x, (gdouble) trough_y, (gdouble) RGB_HISTOGRAM_MANIPULATOR_TROUGH_WIDTH, (gdouble) RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT);
#line 468 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gtk_style_context_restore (stylectx);
#line 455 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_g_object_unref0 (stylectx);
#line 3387 "CustomComponents.c"
}


static void rgb_histogram_manipulator_draw_nub (RGBHistogramManipulator* self, cairo_t* ctx, GdkRectangle* area, gint position) {
	cairo_t* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GdkRectangle _tmp5_ = {0};
	gint _tmp6_ = 0;
	cairo_t* _tmp7_ = NULL;
#line 471 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 471 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (ctx != NULL);
#line 471 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (area != NULL);
#line 472 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = ctx;
#line 472 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = self->priv->nub_pixbuf;
#line 472 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp2_ = *area;
#line 472 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp3_ = _tmp2_.x;
#line 472 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp4_ = position;
#line 472 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp5_ = *area;
#line 472 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp6_ = _tmp5_.y;
#line 472 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gdk_cairo_set_source_pixbuf (_tmp0_, _tmp1_, (gdouble) (_tmp3_ + _tmp4_), (gdouble) (_tmp6_ + RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION));
#line 473 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp7_ = ctx;
#line 473 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	cairo_paint (_tmp7_);
#line 3426 "CustomComponents.c"
}


static void rgb_histogram_manipulator_force_update (RGBHistogramManipulator* self) {
	GdkWindow* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
#line 476 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 477 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 477 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gdk_window_invalidate_rect (_tmp0_, NULL, TRUE);
#line 478 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 478 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	gdk_window_process_updates (_tmp1_, TRUE);
#line 3443 "CustomComponents.c"
}


static void rgb_histogram_manipulator_update_nub_extrema (RGBHistogramManipulator* self) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 481 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 482 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = self->priv->left_nub_position;
#line 482 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->right_nub_min = (_tmp0_ + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE) + 1;
#line 483 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = self->priv->right_nub_position;
#line 483 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->left_nub_max = (_tmp1_ - RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE) - 1;
#line 3460 "CustomComponents.c"
}


void rgb_histogram_manipulator_update_histogram (RGBHistogramManipulator* self, GdkPixbuf* source_pixbuf) {
	GdkPixbuf* _tmp0_ = NULL;
	RGBHistogram* _tmp1_ = NULL;
#line 488 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 488 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (GDK_IS_PIXBUF (source_pixbuf));
#line 489 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = source_pixbuf;
#line 489 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = rgb_histogram_new (_tmp0_);
#line 489 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_rgb_histogram_unref0 (self->priv->histogram);
#line 489 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->histogram = _tmp1_;
#line 490 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	rgb_histogram_manipulator_force_update (self);
#line 3481 "CustomComponents.c"
}


gint rgb_histogram_manipulator_get_left_nub_position (RGBHistogramManipulator* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 493 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), 0);
#line 494 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = self->priv->left_nub_position;
#line 494 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	result = _tmp0_;
#line 494 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 3496 "CustomComponents.c"
}


gint rgb_histogram_manipulator_get_right_nub_position (RGBHistogramManipulator* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 497 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), 0);
#line 498 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = self->priv->right_nub_position;
#line 498 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	result = _tmp0_;
#line 498 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	return result;
#line 3511 "CustomComponents.c"
}


void rgb_histogram_manipulator_set_left_nub_position (RGBHistogramManipulator* self, gint user_nub_pos) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 501 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 502 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = user_nub_pos;
#line 502 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp1_ >= 0) {
#line 3527 "CustomComponents.c"
		gint _tmp2_ = 0;
#line 502 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp2_ = user_nub_pos;
#line 502 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp0_ = _tmp2_ <= 255;
#line 3533 "CustomComponents.c"
	} else {
#line 502 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp0_ = FALSE;
#line 3537 "CustomComponents.c"
	}
#line 502 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_vala_assert (_tmp0_, "(user_nub_pos >= 0) && (user_nub_pos <= 255)");
#line 503 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp3_ = user_nub_pos;
#line 503 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp4_ = self->priv->left_nub_max;
#line 503 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp5_ = CLAMP (_tmp3_, 0, _tmp4_);
#line 503 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->left_nub_position = _tmp5_;
#line 504 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	rgb_histogram_manipulator_update_nub_extrema (self);
#line 3551 "CustomComponents.c"
}


void rgb_histogram_manipulator_set_right_nub_position (RGBHistogramManipulator* self, gint user_nub_pos) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 507 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 508 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = user_nub_pos;
#line 508 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	if (_tmp1_ >= 0) {
#line 3567 "CustomComponents.c"
		gint _tmp2_ = 0;
#line 508 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp2_ = user_nub_pos;
#line 508 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp0_ = _tmp2_ <= 255;
#line 3573 "CustomComponents.c"
	} else {
#line 508 "/home/jens/Source/shotwell/src/CustomComponents.vala"
		_tmp0_ = FALSE;
#line 3577 "CustomComponents.c"
	}
#line 508 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_vala_assert (_tmp0_, "(user_nub_pos >= 0) && (user_nub_pos <= 255)");
#line 509 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp3_ = user_nub_pos;
#line 509 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp4_ = self->priv->right_nub_min;
#line 509 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp5_ = CLAMP (_tmp3_, _tmp4_, 255);
#line 509 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->right_nub_position = _tmp5_;
#line 510 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	rgb_histogram_manipulator_update_nub_extrema (self);
#line 3591 "CustomComponents.c"
}


static void rgb_histogram_manipulator_class_init (RGBHistogramManipulatorClass * klass) {
	GtkWidgetPath* _tmp0_ = NULL;
	GtkWidgetPath* _tmp1_ = NULL;
#line 185 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	rgb_histogram_manipulator_parent_class = g_type_class_peek_parent (klass);
#line 185 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_type_class_add_private (klass, sizeof (RGBHistogramManipulatorPrivate));
#line 185 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*)(GtkWidget*, cairo_t*)) rgb_histogram_manipulator_real_draw;
#line 185 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	G_OBJECT_CLASS (klass)->finalize = rgb_histogram_manipulator_finalize;
#line 185 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	g_signal_new ("nub_position_changed", TYPE_RGB_HISTOGRAM_MANIPULATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 203 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = gtk_widget_path_new ();
#line 203 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	rgb_histogram_manipulator_slider_draw_path = _tmp0_;
#line 204 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp1_ = gtk_widget_path_new ();
#line 204 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	rgb_histogram_manipulator_frame_draw_path = _tmp1_;
#line 3616 "CustomComponents.c"
}


static void rgb_histogram_manipulator_instance_init (RGBHistogramManipulator * self) {
	GdkPixbuf* _tmp0_ = NULL;
#line 185 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv = RGB_HISTOGRAM_MANIPULATOR_GET_PRIVATE (self);
#line 198 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->left_nub_max = (255 - RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE) - 1;
#line 199 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->right_nub_min = RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE + 1;
#line 207 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->histogram = NULL;
#line 208 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->left_nub_position = 0;
#line 209 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->right_nub_position = 255;
#line 210 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_tmp0_ = theme_loader_load_icon ("drag_nub.png");
#line 210 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->nub_pixbuf = _tmp0_;
#line 211 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->is_left_nub_tracking = FALSE;
#line 212 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->is_right_nub_tracking = FALSE;
#line 213 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->track_start_x = 0;
#line 214 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self->priv->track_nub_start_position = 0;
#line 3646 "CustomComponents.c"
}


static void rgb_histogram_manipulator_finalize (GObject* obj) {
	RGBHistogramManipulator * self;
#line 185 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulator);
#line 207 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_rgb_histogram_unref0 (self->priv->histogram);
#line 210 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	_g_object_unref0 (self->priv->nub_pixbuf);
#line 185 "/home/jens/Source/shotwell/src/CustomComponents.vala"
	G_OBJECT_CLASS (rgb_histogram_manipulator_parent_class)->finalize (obj);
#line 3660 "CustomComponents.c"
}


GType rgb_histogram_manipulator_get_type (void) {
	static volatile gsize rgb_histogram_manipulator_type_id__volatile = 0;
	if (g_once_init_enter (&rgb_histogram_manipulator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RGBHistogramManipulatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rgb_histogram_manipulator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RGBHistogramManipulator), 0, (GInstanceInitFunc) rgb_histogram_manipulator_instance_init, NULL };
		GType rgb_histogram_manipulator_type_id;
		rgb_histogram_manipulator_type_id = g_type_register_static (gtk_drawing_area_get_type (), "RGBHistogramManipulator", &g_define_type_info, 0);
		g_once_init_leave (&rgb_histogram_manipulator_type_id__volatile, rgb_histogram_manipulator_type_id);
	}
	return rgb_histogram_manipulator_type_id__volatile;
}



