/* Printing.c generated by valac 0.34.7, the Vala compiler
 * generated from Printing.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <langinfo.h>
#include <gee.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CONTENT_LAYOUT (content_layout_get_type ())

#define TYPE_PRINT_SETTINGS (print_settings_get_type ())
#define PRINT_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_SETTINGS, PrintSettings))
#define PRINT_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_SETTINGS, PrintSettingsClass))
#define IS_PRINT_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_SETTINGS))
#define IS_PRINT_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_SETTINGS))
#define PRINT_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_SETTINGS, PrintSettingsClass))

typedef struct _PrintSettings PrintSettings;
typedef struct _PrintSettingsClass PrintSettingsClass;
typedef struct _PrintSettingsPrivate PrintSettingsPrivate;

#define TYPE_MEASUREMENT (measurement_get_type ())

#define TYPE_MEASUREMENT_UNIT (measurement_unit_get_type ())
typedef struct _Measurement Measurement;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PRINT_MANAGER (print_manager_get_type ())
#define PRINT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_MANAGER, PrintManager))
#define PRINT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_MANAGER, PrintManagerClass))
#define IS_PRINT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_MANAGER))
#define IS_PRINT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_MANAGER))
#define PRINT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_MANAGER, PrintManagerClass))

typedef struct _PrintManager PrintManager;
typedef struct _PrintManagerClass PrintManagerClass;

#define TYPE_STANDARD_PRINT_SIZE (standard_print_size_get_type ())
#define STANDARD_PRINT_SIZE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STANDARD_PRINT_SIZE, StandardPrintSize))
#define STANDARD_PRINT_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STANDARD_PRINT_SIZE, StandardPrintSizeClass))
#define IS_STANDARD_PRINT_SIZE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STANDARD_PRINT_SIZE))
#define IS_STANDARD_PRINT_SIZE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STANDARD_PRINT_SIZE))
#define STANDARD_PRINT_SIZE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STANDARD_PRINT_SIZE, StandardPrintSizeClass))

typedef struct _StandardPrintSize StandardPrintSize;
typedef struct _StandardPrintSizeClass StandardPrintSizeClass;
typedef struct _StandardPrintSizePrivate StandardPrintSizePrivate;
#define _print_manager_unref0(var) ((var == NULL) ? NULL : (var = (print_manager_unref (var), NULL)))
typedef struct _ParamSpecPrintSettings ParamSpecPrintSettings;

#define TYPE_PRINT_LAYOUT (print_layout_get_type ())

#define TYPE_CUSTOM_PRINT_TAB (custom_print_tab_get_type ())
#define CUSTOM_PRINT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_PRINT_TAB, CustomPrintTab))
#define CUSTOM_PRINT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_PRINT_TAB, CustomPrintTabClass))
#define IS_CUSTOM_PRINT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_PRINT_TAB))
#define IS_CUSTOM_PRINT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_PRINT_TAB))
#define CUSTOM_PRINT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_PRINT_TAB, CustomPrintTabClass))

typedef struct _CustomPrintTab CustomPrintTab;
typedef struct _CustomPrintTabClass CustomPrintTabClass;
typedef struct _CustomPrintTabPrivate CustomPrintTabPrivate;

#define TYPE_PRINT_JOB (print_job_get_type ())
#define PRINT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_JOB, PrintJob))
#define PRINT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_JOB, PrintJobClass))
#define IS_PRINT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_JOB))
#define IS_PRINT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_JOB))
#define PRINT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_JOB, PrintJobClass))

typedef struct _PrintJob PrintJob;
typedef struct _PrintJobClass PrintJobClass;
#define _standard_print_size_unref0(var) ((var == NULL) ? NULL : (var = (standard_print_size_unref (var), NULL)))

#define RESOURCES_TYPE_UNIT_SYSTEM (resources_unit_system_get_type ())
#define _print_settings_unref0(var) ((var == NULL) ? NULL : (var = (print_settings_unref (var), NULL)))
typedef struct _PrintJobPrivate PrintJobPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef struct _ParamSpecStandardPrintSize ParamSpecStandardPrintSize;
typedef struct _PrintManagerPrivate PrintManagerPrivate;

#define TYPE_PROGRESS_DIALOG (progress_dialog_get_type ())
#define PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_DIALOG, ProgressDialog))
#define PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_DIALOG, ProgressDialogClass))
#define IS_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_DIALOG))
#define IS_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_DIALOG))
#define PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_DIALOG, ProgressDialogClass))

typedef struct _ProgressDialog ProgressDialog;
typedef struct _ProgressDialogClass ProgressDialogClass;

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _ParamSpecPrintManager ParamSpecPrintManager;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	CONTENT_LAYOUT_STANDARD_SIZE,
	CONTENT_LAYOUT_CUSTOM_SIZE,
	CONTENT_LAYOUT_IMAGE_PER_PAGE
} ContentLayout;

struct _PrintSettings {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PrintSettingsPrivate * priv;
};

struct _PrintSettingsClass {
	GTypeClass parent_class;
	void (*finalize) (PrintSettings *self);
};

typedef enum  {
	MEASUREMENT_UNIT_INCHES,
	MEASUREMENT_UNIT_CENTIMETERS
} MeasurementUnit;

struct _Measurement {
	gdouble value;
	MeasurementUnit unit;
};

struct _PrintSettingsPrivate {
	ContentLayout content_layout;
	Measurement content_width;
	Measurement content_height;
	gint content_ppi;
	gint image_per_page_selection;
	gint size_selection;
	gboolean match_aspect_ratio;
	gboolean print_titles;
	gchar* print_titles_font;
};

struct _StandardPrintSize {
	GTypeInstance parent_instance;
	volatile int ref_count;
	StandardPrintSizePrivate * priv;
	gchar* name;
	Measurement width;
	Measurement height;
};

struct _StandardPrintSizeClass {
	GTypeClass parent_class;
	void (*finalize) (StandardPrintSize *self);
};

struct _ParamSpecPrintSettings {
	GParamSpec parent_instance;
};

typedef enum  {
	PRINT_LAYOUT_ENTIRE_PAGE,
	PRINT_LAYOUT_TWO_PER_PAGE,
	PRINT_LAYOUT_FOUR_PER_PAGE,
	PRINT_LAYOUT_SIX_PER_PAGE,
	PRINT_LAYOUT_EIGHT_PER_PAGE,
	PRINT_LAYOUT_SIXTEEN_PER_PAGE,
	PRINT_LAYOUT_THIRTY_TWO_PER_PAGE
} PrintLayout;

struct _CustomPrintTab {
	GtkBox parent_instance;
	CustomPrintTabPrivate * priv;
};

struct _CustomPrintTabClass {
	GtkBoxClass parent_class;
};

struct _CustomPrintTabPrivate {
	GtkRadioButton* standard_size_radio;
	GtkRadioButton* custom_size_radio;
	GtkRadioButton* image_per_page_radio;
	GtkComboBoxText* image_per_page_combo;
	GtkComboBoxText* standard_sizes_combo;
	GtkComboBoxText* units_combo;
	GtkEntry* custom_width_entry;
	GtkEntry* custom_height_entry;
	GtkEntry* ppi_entry;
	GtkCheckButton* aspect_ratio_check;
	GtkCheckButton* title_print_check;
	GtkFontButton* title_print_font;
	Measurement local_content_width;
	Measurement local_content_height;
	gint local_content_ppi;
	gboolean is_text_insertion_in_progress;
	PrintJob* source_job;
};

typedef enum  {
	RESOURCES_UNIT_SYSTEM_IMPERIAL,
	RESOURCES_UNIT_SYSTEM_METRIC,
	RESOURCES_UNIT_SYSTEM_UNKNOWN
} ResourcesUnitSystem;

struct _PrintJob {
	GtkPrintOperation parent_instance;
	PrintJobPrivate * priv;
};

struct _PrintJobClass {
	GtkPrintOperationClass parent_class;
};

struct _PrintJobPrivate {
	PrintSettings* settings;
	GeeArrayList* photos;
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

struct _Dimensions {
	gint width;
	gint height;
};

struct _ParamSpecStandardPrintSize {
	GParamSpec parent_instance;
};

struct _PrintManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PrintManagerPrivate * priv;
};

struct _PrintManagerClass {
	GTypeClass parent_class;
	void (*finalize) (PrintManager *self);
};

struct _PrintManagerPrivate {
	PrintSettings* settings;
	GtkPageSetup* user_page_setup;
	CustomPrintTab* custom_tab;
	ProgressDialog* progress_dialog;
	GCancellable* cancellable;
	StandardPrintSize** standard_sizes;
	gint standard_sizes_length1;
	gint _standard_sizes_size_;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _ParamSpecPrintManager {
	GParamSpec parent_instance;
};


static gpointer print_settings_parent_class = NULL;
static gpointer custom_print_tab_parent_class = NULL;
static gpointer print_job_parent_class = NULL;
static gpointer standard_print_size_parent_class = NULL;
static gpointer print_manager_parent_class = NULL;
static PrintManager* print_manager_instance;
static PrintManager* print_manager_instance = NULL;

GType content_layout_get_type (void) G_GNUC_CONST;
gpointer print_settings_ref (gpointer instance);
void print_settings_unref (gpointer instance);
GParamSpec* param_spec_print_settings (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_print_settings (GValue* value, gpointer v_object);
void value_take_print_settings (GValue* value, gpointer v_object);
gpointer value_get_print_settings (const GValue* value);
GType print_settings_get_type (void) G_GNUC_CONST;
GType measurement_get_type (void) G_GNUC_CONST;
GType measurement_unit_get_type (void) G_GNUC_CONST;
Measurement* measurement_dup (const Measurement* self);
void measurement_free (Measurement* self);
#define PRINT_SETTINGS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRINT_SETTINGS, PrintSettingsPrivate))
enum  {
	PRINT_SETTINGS_DUMMY_PROPERTY
};
#define PRINT_SETTINGS_MIN_CONTENT_PPI 72
#define PRINT_SETTINGS_MAX_CONTENT_PPI 1200
PrintSettings* print_settings_new (void);
PrintSettings* print_settings_construct (GType object_type);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gint configuration_facade_get_printing_content_units (ConfigurationFacade* self);
gdouble configuration_facade_get_printing_content_width (ConfigurationFacade* self);
void measurement_init (Measurement *self, gdouble value, MeasurementUnit unit);
gdouble configuration_facade_get_printing_content_height (ConfigurationFacade* self);
gint configuration_facade_get_printing_size_selection (ConfigurationFacade* self);
gint configuration_facade_get_printing_content_layout (ConfigurationFacade* self);
gboolean configuration_facade_get_printing_match_aspect_ratio (ConfigurationFacade* self);
gboolean configuration_facade_get_printing_print_titles (ConfigurationFacade* self);
gchar* configuration_facade_get_printing_titles_font (ConfigurationFacade* self);
gint configuration_facade_get_printing_images_per_page (ConfigurationFacade* self);
gint configuration_facade_get_printing_content_ppi (ConfigurationFacade* self);
void print_settings_save (PrintSettings* self);
void configuration_facade_set_printing_content_units (ConfigurationFacade* self, gint units_code);
void configuration_facade_set_printing_content_width (ConfigurationFacade* self, gdouble content_width);
void configuration_facade_set_printing_content_height (ConfigurationFacade* self, gdouble content_height);
void configuration_facade_set_printing_size_selection (ConfigurationFacade* self, gint size_code);
void configuration_facade_set_printing_content_layout (ConfigurationFacade* self, gint layout_code);
void configuration_facade_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio);
void configuration_facade_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles);
void configuration_facade_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name);
void configuration_facade_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code);
void configuration_facade_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi);
void print_settings_get_content_width (PrintSettings* self, Measurement* result);
ContentLayout print_settings_get_content_layout (PrintSettings* self);
gpointer print_manager_ref (gpointer instance);
void print_manager_unref (gpointer instance);
GParamSpec* param_spec_print_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_print_manager (GValue* value, gpointer v_object);
void value_take_print_manager (GValue* value, gpointer v_object);
gpointer value_get_print_manager (const GValue* value);
GType print_manager_get_type (void) G_GNUC_CONST;
PrintManager* print_manager_get_instance (void);
gpointer standard_print_size_ref (gpointer instance);
void standard_print_size_unref (gpointer instance);
GParamSpec* param_spec_standard_print_size (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_standard_print_size (GValue* value, gpointer v_object);
void value_take_standard_print_size (GValue* value, gpointer v_object);
gpointer value_get_standard_print_size (const GValue* value);
GType standard_print_size_get_type (void) G_GNUC_CONST;
StandardPrintSize** print_manager_get_standard_sizes (PrintManager* self, int* result_length1);
gint print_settings_get_size_selection (PrintSettings* self);
void print_settings_get_content_height (PrintSettings* self, Measurement* result);
void print_settings_get_minimum_content_dimension (PrintSettings* self, Measurement* result);
void print_settings_get_maximum_content_dimension (PrintSettings* self, Measurement* result);
gboolean print_settings_is_match_aspect_ratio_enabled (PrintSettings* self);
gboolean print_settings_is_print_titles_enabled (PrintSettings* self);
gint print_settings_get_content_ppi (PrintSettings* self);
gint print_settings_get_image_per_page_selection (PrintSettings* self);
void print_settings_set_content_layout (PrintSettings* self, ContentLayout content_layout);
void print_settings_set_content_width (PrintSettings* self, Measurement* content_width);
void print_settings_set_content_height (PrintSettings* self, Measurement* content_height);
void print_settings_set_content_ppi (PrintSettings* self, gint content_ppi);
void print_settings_set_image_per_page_selection (PrintSettings* self, gint image_per_page_selection);
void print_settings_set_size_selection (PrintSettings* self, gint size_selection);
void print_settings_set_match_aspect_ratio_enabled (PrintSettings* self, gboolean enable_state);
void print_settings_set_print_titles_enabled (PrintSettings* self, gboolean print_titles);
void print_settings_set_print_titles_font (PrintSettings* self, const gchar* fontname);
gchar* print_settings_get_print_titles_font (PrintSettings* self);
static void print_settings_finalize (PrintSettings* obj);
#define MEASUREMENT_CENTIMETERS_PER_INCH 2.54
#define MEASUREMENT_INCHES_PER_CENTIMETER (1.0 / 2.54)
void measurement_convert_to (Measurement *self, MeasurementUnit to_unit, Measurement* result);
gboolean measurement_is_less_than (Measurement *self, Measurement* rhs);
gboolean measurement_is_greater_than (Measurement *self, Measurement* rhs);
GType print_layout_get_type (void) G_GNUC_CONST;
PrintLayout* print_layout_get_all (int* result_length1);
gint print_layout_get_per_page (PrintLayout self);
gint print_layout_get_x (PrintLayout self);
gint print_layout_get_y (PrintLayout self);
gchar* print_layout_to_string (PrintLayout self);
GType custom_print_tab_get_type (void) G_GNUC_CONST;
GType print_job_get_type (void) G_GNUC_CONST;
#define CUSTOM_PRINT_TAB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CUSTOM_PRINT_TAB, CustomPrintTabPrivate))
enum  {
	CUSTOM_PRINT_TAB_DUMMY_PROPERTY
};
#define CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE 0
#define CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE 1
CustomPrintTab* custom_print_tab_new (PrintJob* source_job);
CustomPrintTab* custom_print_tab_construct (GType object_type, PrintJob* source_job);
static void custom_print_tab_on_radio_group_click (CustomPrintTab* self, GtkButton* b);
static void _custom_print_tab_on_radio_group_click_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean custom_print_tab_standard_sizes_combo_separator_func (GtkTreeModel* model, GtkTreeIter* iter);
static gboolean _custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
GType resources_unit_system_get_type (void) G_GNUC_CONST;
ResourcesUnitSystem resources_get_default_measurement_unit (void);
static void custom_print_tab_on_entry_insert_text (CustomPrintTab* self, GtkEditable* editable, const gchar* text, gint length, gint* position);
static void _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender, const gchar* new_text, gint new_text_length, gint* position, gpointer self);
static gboolean custom_print_tab_on_width_entry_focus_out (CustomPrintTab* self, GdkEventFocus* event);
static gboolean _custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean custom_print_tab_on_height_entry_focus_out (CustomPrintTab* self, GdkEventFocus* event);
static gboolean _custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void custom_print_tab_on_units_combo_changed (CustomPrintTab* self);
static void _custom_print_tab_on_units_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void custom_print_tab_on_ppi_entry_insert_text (CustomPrintTab* self, GtkEditable* editable, const gchar* text, gint length, gint* position);
static void _custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender, const gchar* new_text, gint new_text_length, gint* position, gpointer self);
static gboolean custom_print_tab_on_ppi_entry_focus_out (CustomPrintTab* self, GdkEventFocus* event);
static gboolean _custom_print_tab_on_ppi_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void custom_print_tab_sync_state_from_job (CustomPrintTab* self, PrintJob* job);
static void custom_print_tab_on_aspect_ratio_check_clicked (CustomPrintTab* self);
static void _custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
gdouble print_job_get_source_aspect_ratio (PrintJob* self);
static gchar* custom_print_tab_format_measurement (CustomPrintTab* self, Measurement* measurement);
static gchar* custom_print_tab_format_measurement_as (CustomPrintTab* self, Measurement* measurement, MeasurementUnit to_unit);
static MeasurementUnit custom_print_tab_get_user_unit_choice (CustomPrintTab* self);
static void custom_print_tab_get_width_entry_value (CustomPrintTab* self, Measurement* result);
PrintSettings* print_job_get_local_settings (PrintJob* self);
static gboolean custom_print_tab_is_match_aspect_ratio_enabled (CustomPrintTab* self);
static void custom_print_tab_set_content_ppi (CustomPrintTab* self, gint content_ppi);
static void custom_print_tab_get_height_entry_value (CustomPrintTab* self, Measurement* result);
static void custom_print_tab_set_user_unit_choice (CustomPrintTab* self, MeasurementUnit unit);
static void custom_print_tab_set_content_width (CustomPrintTab* self, Measurement* content_width);
static void custom_print_tab_set_content_height (CustomPrintTab* self, Measurement* content_height);
static void custom_print_tab_set_content_layout (CustomPrintTab* self, ContentLayout content_layout);
static void custom_print_tab_set_image_per_page_selection (CustomPrintTab* self, gint image_per_page);
static void custom_print_tab_set_size_selection (CustomPrintTab* self, gint size_selection);
static void custom_print_tab_set_match_aspect_ratio_enabled (CustomPrintTab* self, gboolean enable_state);
static void custom_print_tab_set_print_titles_enabled (CustomPrintTab* self, gboolean print_titles);
static void custom_print_tab_set_print_titles_font (CustomPrintTab* self, const gchar* fontname);
static void custom_print_tab_set_content_layout_control_state (CustomPrintTab* self, ContentLayout layout);
static ContentLayout custom_print_tab_get_content_layout (CustomPrintTab* self);
static void custom_print_tab_get_content_width (CustomPrintTab* self, Measurement* result);
static void custom_print_tab_get_content_height (CustomPrintTab* self, Measurement* result);
static gint custom_print_tab_get_content_ppi (CustomPrintTab* self);
static gint custom_print_tab_get_image_per_page_selection (CustomPrintTab* self);
static gint custom_print_tab_get_size_selection (CustomPrintTab* self);
static gboolean custom_print_tab_is_print_titles_enabled (CustomPrintTab* self);
static gchar* custom_print_tab_get_print_titles_font (CustomPrintTab* self);
PrintJob* custom_print_tab_get_source_job (CustomPrintTab* self);
PrintSettings* custom_print_tab_get_local_settings (CustomPrintTab* self);
static void custom_print_tab_finalize (GObject* obj);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
#define PRINT_JOB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRINT_JOB, PrintJobPrivate))
enum  {
	PRINT_JOB_DUMMY_PROPERTY
};
PrintJob* print_job_new (GeeCollection* to_print);
PrintJob* print_job_construct (GType object_type, GeeCollection* to_print);
PrintSettings* print_manager_get_global_settings (PrintManager* self);
GType photo_exception_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
void media_source_get_dimensions (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
gdouble dimensions_get_aspect_ratio (Dimensions *self);
GeeList* print_job_get_photos (PrintJob* self);
Photo* print_job_get_source_photo (PrintJob* self);
void print_job_set_local_settings (PrintJob* self, PrintSettings* settings);
static void print_job_finalize (GObject* obj);
enum  {
	STANDARD_PRINT_SIZE_DUMMY_PROPERTY
};
StandardPrintSize* standard_print_size_new (const gchar* name, Measurement* width, Measurement* height);
StandardPrintSize* standard_print_size_construct (GType object_type, const gchar* name, Measurement* width, Measurement* height);
static void standard_print_size_finalize (StandardPrintSize* obj);
GType progress_dialog_get_type (void) G_GNUC_CONST;
#define PRINT_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRINT_MANAGER, PrintManagerPrivate))
enum  {
	PRINT_MANAGER_DUMMY_PROPERTY
};
#define PRINT_MANAGER_IMAGE_DISTANCE 0.24
static PrintManager* print_manager_new (void);
static PrintManager* print_manager_construct (GType object_type);
static void _vala_array_add112 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add113 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add114 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add115 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add116 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add117 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add118 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add119 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add120 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add121 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add122 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add123 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add124 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add125 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
static void _vala_array_add126 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value);
void print_manager_spool_photo (PrintManager* self, GeeCollection* to_print);
gchar* data_object_get_name (DataObject* self);
static void print_manager_on_begin_print (PrintManager* self, GtkPrintOperation* emitting_object, GtkPrintContext* job_context);
static void _print_manager_on_begin_print_gtk_print_operation_begin_print (GtkPrintOperation* _sender, GtkPrintContext* context, gpointer self);
static void print_manager_on_draw_page (PrintManager* self, GtkPrintOperation* emitting_object, GtkPrintContext* job_context, gint page_num);
static void _print_manager_on_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
static GObject* print_manager_on_create_custom_widget (PrintManager* self, GtkPrintOperation* emitting_object);
static GObject* _print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget (GtkPrintOperation* _sender, gpointer self);
static void print_manager_on_status_changed (PrintManager* self, GtkPrintOperation* job);
static void _print_manager_on_status_changed_gtk_print_operation_status_changed (GtkPrintOperation* _sender, gpointer self);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
void page_window_set_busy_cursor (PageWindow* self);
ProgressDialog* progress_dialog_new (GtkWindow* owner, const gchar* text, GCancellable* cancellable);
ProgressDialog* progress_dialog_construct (GType object_type, GtkWindow* owner, const gchar* text, GCancellable* cancellable);
void progress_dialog_close (ProgressDialog* self);
void page_window_set_normal_cursor (PageWindow* self);
void app_window_error_message (const gchar* message, GtkWindow* parent);
void spin_event_loop (void);
void progress_dialog_set_status (ProgressDialog* self, const gchar* text);
static void print_manager_fit_image_to_canvas (PrintManager* self, Photo* photo, gdouble x, gdouble y, gdouble canvas_width, gdouble canvas_height, gboolean crop, PrintJob* job, GtkPrintContext* job_context);
static void print_manager_add_title_to_canvas (PrintManager* self, gdouble x, gdouble y, const gchar* title, PrintJob* job, GtkPrintContext* job_context);
gboolean progress_dialog_monitor (ProgressDialog* self, guint64 count, guint64 total, gboolean do_event_loop);
static void print_manager_on_custom_widget_apply (PrintManager* self, GtkWidget* custom_widget);
static void _print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply (GtkPrintOperation* _sender, GtkWidget* widget, gpointer self);
void print_manager_set_global_settings (PrintManager* self, PrintSettings* settings);
void dimensions_init (Dimensions *self, gint width, gint height);
static gboolean print_manager_are_approximately_equal (PrintManager* self, gdouble val1, gdouble val2);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
void scaling_to_fill_viewport (Dimensions* viewport, Scaling* result);
GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self, Scaling* scaling, GError** error);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result);
GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self, GdkPixbuf* pixbuf, GdkInterpType interp, gboolean scale_up);
void scaling_for_viewport (Dimensions* viewport, gboolean scale_up, Scaling* result);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void print_manager_finalize (PrintManager* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType content_layout_get_type (void) {
	static volatile gsize content_layout_type_id__volatile = 0;
	if (g_once_init_enter (&content_layout_type_id__volatile)) {
		static const GEnumValue values[] = {{CONTENT_LAYOUT_STANDARD_SIZE, "CONTENT_LAYOUT_STANDARD_SIZE", "standard-size"}, {CONTENT_LAYOUT_CUSTOM_SIZE, "CONTENT_LAYOUT_CUSTOM_SIZE", "custom-size"}, {CONTENT_LAYOUT_IMAGE_PER_PAGE, "CONTENT_LAYOUT_IMAGE_PER_PAGE", "image-per-page"}, {0, NULL, NULL}};
		GType content_layout_type_id;
		content_layout_type_id = g_enum_register_static ("ContentLayout", values);
		g_once_init_leave (&content_layout_type_id__volatile, content_layout_type_id);
	}
	return content_layout_type_id__volatile;
}


PrintSettings* print_settings_construct (GType object_type) {
	PrintSettings* self = NULL;
	ConfigFacade* config = NULL;
	ConfigFacade* _tmp0_ = NULL;
	MeasurementUnit units = 0;
	gint _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
#line 30 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (PrintSettings*) g_type_create_instance (object_type);
#line 31 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = config_facade_get_instance ();
#line 31 "/home/jens/Source/shotwell/src/Printing.vala"
	config = _tmp0_;
#line 33 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = configuration_facade_get_printing_content_units (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 33 "/home/jens/Source/shotwell/src/Printing.vala"
	units = (MeasurementUnit) _tmp1_;
#line 35 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = configuration_facade_get_printing_content_width (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 35 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&self->priv->content_width, _tmp2_, units);
#line 36 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = configuration_facade_get_printing_content_height (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 36 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&self->priv->content_height, _tmp3_, units);
#line 37 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = configuration_facade_get_printing_size_selection (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 37 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->size_selection = _tmp4_;
#line 38 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = configuration_facade_get_printing_content_layout (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 38 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_layout = (ContentLayout) _tmp5_;
#line 39 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = configuration_facade_get_printing_match_aspect_ratio (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 39 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->match_aspect_ratio = _tmp6_;
#line 40 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = configuration_facade_get_printing_print_titles (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 40 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->print_titles = _tmp7_;
#line 41 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = configuration_facade_get_printing_titles_font (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 41 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->priv->print_titles_font);
#line 41 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->print_titles_font = _tmp8_;
#line 42 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = configuration_facade_get_printing_images_per_page (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 42 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->image_per_page_selection = _tmp9_;
#line 43 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = configuration_facade_get_printing_content_ppi (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 43 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_ppi = _tmp10_;
#line 30 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (config);
#line 30 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 745 "Printing.c"
}


PrintSettings* print_settings_new (void) {
#line 30 "/home/jens/Source/shotwell/src/Printing.vala"
	return print_settings_construct (TYPE_PRINT_SETTINGS);
#line 752 "Printing.c"
}


void print_settings_save (PrintSettings* self) {
	ConfigFacade* config = NULL;
	ConfigFacade* _tmp0_ = NULL;
	Measurement _tmp1_ = {0};
	MeasurementUnit _tmp2_ = 0;
	Measurement _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	Measurement _tmp5_ = {0};
	gdouble _tmp6_ = 0.0;
	gint _tmp7_ = 0;
	ContentLayout _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 46 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 47 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = config_facade_get_instance ();
#line 47 "/home/jens/Source/shotwell/src/Printing.vala"
	config = _tmp0_;
#line 49 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = self->priv->content_width;
#line 49 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _tmp1_.unit;
#line 49 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_units (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), (gint) _tmp2_);
#line 50 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->content_width;
#line 50 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_.value;
#line 50 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_width (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp4_);
#line 51 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = self->priv->content_height;
#line 51 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = _tmp5_.value;
#line 51 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_height (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp6_);
#line 52 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = self->priv->size_selection;
#line 52 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_size_selection (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp7_);
#line 53 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = self->priv->content_layout;
#line 53 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_layout (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), (gint) _tmp8_);
#line 54 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = self->priv->match_aspect_ratio;
#line 54 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_match_aspect_ratio (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp9_);
#line 55 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = self->priv->print_titles;
#line 55 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_print_titles (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp10_);
#line 56 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = self->priv->print_titles_font;
#line 56 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_titles_font (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp11_);
#line 57 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = self->priv->image_per_page_selection;
#line 57 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_images_per_page (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp12_);
#line 58 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = self->priv->content_ppi;
#line 58 "/home/jens/Source/shotwell/src/Printing.vala"
	configuration_facade_set_printing_content_ppi (G_TYPE_CHECK_INSTANCE_CAST (config, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp13_);
#line 46 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (config);
#line 826 "Printing.c"
}


void print_settings_get_content_width (PrintSettings* self, Measurement* result) {
	ContentLayout _tmp0_ = 0;
#line 62 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 63 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_settings_get_content_layout (self);
#line 63 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (_tmp0_) {
#line 63 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 63 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 842 "Printing.c"
		{
			PrintManager* _tmp1_ = NULL;
			PrintManager* _tmp2_ = NULL;
			gint _tmp3_ = 0;
			StandardPrintSize** _tmp4_ = NULL;
			gint _tmp5_ = 0;
			StandardPrintSize* _tmp6_ = NULL;
			Measurement _tmp7_ = {0};
			Measurement _tmp8_ = {0};
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp1_ = print_manager_get_instance ();
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp2_ = _tmp1_;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp4_ = print_manager_get_standard_sizes (_tmp2_, &_tmp3_);
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp5_ = print_settings_get_size_selection (self);
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp6_ = _tmp4_[_tmp5_];
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp7_ = _tmp6_->width;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp8_ = _tmp7_;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			_print_manager_unref0 (_tmp2_);
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp8_;
#line 66 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 872 "Printing.c"
		}
#line 63 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 876 "Printing.c"
		{
			Measurement _tmp9_ = {0};
#line 70 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp9_ = self->priv->content_width;
#line 70 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp9_;
#line 70 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 885 "Printing.c"
		}
		default:
		{
#line 73 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:73: unknown ContentLayout enumeration value");
#line 891 "Printing.c"
		}
	}
}


void print_settings_get_content_height (PrintSettings* self, Measurement* result) {
	ContentLayout _tmp0_ = 0;
#line 77 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 78 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_settings_get_content_layout (self);
#line 78 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (_tmp0_) {
#line 78 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 78 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 909 "Printing.c"
		{
			PrintManager* _tmp1_ = NULL;
			PrintManager* _tmp2_ = NULL;
			gint _tmp3_ = 0;
			StandardPrintSize** _tmp4_ = NULL;
			gint _tmp5_ = 0;
			StandardPrintSize* _tmp6_ = NULL;
			Measurement _tmp7_ = {0};
			Measurement _tmp8_ = {0};
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp1_ = print_manager_get_instance ();
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp2_ = _tmp1_;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp4_ = print_manager_get_standard_sizes (_tmp2_, &_tmp3_);
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp5_ = print_settings_get_size_selection (self);
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp6_ = _tmp4_[_tmp5_];
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp7_ = _tmp6_->height;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp8_ = _tmp7_;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			_print_manager_unref0 (_tmp2_);
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp8_;
#line 81 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 939 "Printing.c"
		}
#line 78 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 943 "Printing.c"
		{
			Measurement _tmp9_ = {0};
#line 85 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp9_ = self->priv->content_height;
#line 85 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp9_;
#line 85 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 952 "Printing.c"
		}
		default:
		{
#line 88 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:88: unknown ContentLayout enumeration value");
#line 958 "Printing.c"
		}
	}
}


void print_settings_get_minimum_content_dimension (PrintSettings* self, Measurement* result) {
	Measurement _tmp0_ = {0};
#line 92 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 93 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp0_, 0.5, MEASUREMENT_UNIT_INCHES);
#line 93 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp0_;
#line 93 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 974 "Printing.c"
}


void print_settings_get_maximum_content_dimension (PrintSettings* self, Measurement* result) {
	Measurement _tmp0_ = {0};
#line 96 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 97 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp0_, (gdouble) 30, MEASUREMENT_UNIT_INCHES);
#line 97 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp0_;
#line 97 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 988 "Printing.c"
}


gboolean print_settings_is_match_aspect_ratio_enabled (PrintSettings* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 100 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), FALSE);
#line 101 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->match_aspect_ratio;
#line 101 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 101 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1003 "Printing.c"
}


gboolean print_settings_is_print_titles_enabled (PrintSettings* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 104 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), FALSE);
#line 105 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->print_titles;
#line 105 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 105 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1018 "Printing.c"
}


gint print_settings_get_content_ppi (PrintSettings* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 108 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
#line 109 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->content_ppi;
#line 109 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 109 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1033 "Printing.c"
}


gint print_settings_get_image_per_page_selection (PrintSettings* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 112 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
#line 113 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->image_per_page_selection;
#line 113 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 113 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1048 "Printing.c"
}


gint print_settings_get_size_selection (PrintSettings* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 116 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
#line 117 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->size_selection;
#line 117 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 117 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1063 "Printing.c"
}


ContentLayout print_settings_get_content_layout (PrintSettings* self) {
	ContentLayout result = 0;
	ContentLayout _tmp0_ = 0;
#line 120 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), 0);
#line 121 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->content_layout;
#line 121 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 121 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1078 "Printing.c"
}


void print_settings_set_content_layout (PrintSettings* self, ContentLayout content_layout) {
	ContentLayout _tmp0_ = 0;
#line 124 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 125 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = content_layout;
#line 125 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_layout = _tmp0_;
#line 1090 "Printing.c"
}


void print_settings_set_content_width (PrintSettings* self, Measurement* content_width) {
	Measurement _tmp0_ = {0};
#line 128 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 128 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (content_width != NULL);
#line 129 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *content_width;
#line 129 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_width = _tmp0_;
#line 1104 "Printing.c"
}


void print_settings_set_content_height (PrintSettings* self, Measurement* content_height) {
	Measurement _tmp0_ = {0};
#line 132 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 132 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (content_height != NULL);
#line 133 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *content_height;
#line 133 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_height = _tmp0_;
#line 1118 "Printing.c"
}


void print_settings_set_content_ppi (PrintSettings* self, gint content_ppi) {
	gint _tmp0_ = 0;
#line 136 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 137 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = content_ppi;
#line 137 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->content_ppi = _tmp0_;
#line 1130 "Printing.c"
}


void print_settings_set_image_per_page_selection (PrintSettings* self, gint image_per_page_selection) {
	gint _tmp0_ = 0;
#line 140 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 141 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = image_per_page_selection;
#line 141 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->image_per_page_selection = _tmp0_;
#line 1142 "Printing.c"
}


void print_settings_set_size_selection (PrintSettings* self, gint size_selection) {
	gint _tmp0_ = 0;
#line 144 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 145 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = size_selection;
#line 145 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->size_selection = _tmp0_;
#line 1154 "Printing.c"
}


void print_settings_set_match_aspect_ratio_enabled (PrintSettings* self, gboolean enable_state) {
	gboolean _tmp0_ = FALSE;
#line 148 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 149 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = enable_state;
#line 149 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->match_aspect_ratio = _tmp0_;
#line 1166 "Printing.c"
}


void print_settings_set_print_titles_enabled (PrintSettings* self, gboolean print_titles) {
	gboolean _tmp0_ = FALSE;
#line 152 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 153 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_titles;
#line 153 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->print_titles = _tmp0_;
#line 1178 "Printing.c"
}


void print_settings_set_print_titles_font (PrintSettings* self, const gchar* fontname) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 156 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (self));
#line 156 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (fontname != NULL);
#line 157 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = fontname;
#line 157 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 157 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->priv->print_titles_font);
#line 157 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->print_titles_font = _tmp1_;
#line 1197 "Printing.c"
}


gchar* print_settings_get_print_titles_font (PrintSettings* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 160 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_SETTINGS (self), NULL);
#line 161 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->print_titles_font;
#line 161 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 161 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 161 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1215 "Printing.c"
}


static void value_print_settings_init (GValue* value) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	value->data[0].v_pointer = NULL;
#line 1222 "Printing.c"
}


static void value_print_settings_free_value (GValue* value) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (value->data[0].v_pointer) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_unref (value->data[0].v_pointer);
#line 1231 "Printing.c"
	}
}


static void value_print_settings_copy_value (const GValue* src_value, GValue* dest_value) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (src_value->data[0].v_pointer) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = print_settings_ref (src_value->data[0].v_pointer);
#line 1241 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1245 "Printing.c"
	}
}


static gpointer value_print_settings_peek_pointer (const GValue* value) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 1253 "Printing.c"
}


static gchar* value_print_settings_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (collect_values[0].v_pointer) {
#line 1260 "Printing.c"
		PrintSettings* object;
		object = collect_values[0].v_pointer;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		if (object->parent_instance.g_class == NULL) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1267 "Printing.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1271 "Printing.c"
		}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = print_settings_ref (object);
#line 1275 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 1279 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 1283 "Printing.c"
}


static gchar* value_print_settings_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PrintSettings** object_p;
	object_p = collect_values[0].v_pointer;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!object_p) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1294 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!value->data[0].v_pointer) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = NULL;
#line 1300 "Printing.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = value->data[0].v_pointer;
#line 1304 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = print_settings_ref (value->data[0].v_pointer);
#line 1308 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 1312 "Printing.c"
}


GParamSpec* param_spec_print_settings (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPrintSettings* spec;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PRINT_SETTINGS), NULL);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return G_PARAM_SPEC (spec);
#line 1326 "Printing.c"
}


gpointer value_get_print_settings (const GValue* value) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS), NULL);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 1335 "Printing.c"
}


void value_set_print_settings (GValue* value, gpointer v_object) {
	PrintSettings* old;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_SETTINGS));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_ref (value->data[0].v_pointer);
#line 1355 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 1359 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_unref (old);
#line 1365 "Printing.c"
	}
}


void value_take_print_settings (GValue* value, gpointer v_object) {
	PrintSettings* old;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_SETTINGS));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 1384 "Printing.c"
	} else {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 1388 "Printing.c"
	}
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_unref (old);
#line 1394 "Printing.c"
	}
}


static void print_settings_class_init (PrintSettingsClass * klass) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	((PrintSettingsClass *) klass)->finalize = print_settings_finalize;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_type_class_add_private (klass, sizeof (PrintSettingsPrivate));
#line 1406 "Printing.c"
}


static void print_settings_instance_init (PrintSettings * self) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv = PRINT_SETTINGS_GET_PRIVATE (self);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	self->ref_count = 1;
#line 1415 "Printing.c"
}


static void print_settings_finalize (PrintSettings* obj) {
	PrintSettings * self;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_SETTINGS, PrintSettings);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_handlers_destroy (self);
#line 28 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->priv->print_titles_font);
#line 1427 "Printing.c"
}


GType print_settings_get_type (void) {
	static volatile gsize print_settings_type_id__volatile = 0;
	if (g_once_init_enter (&print_settings_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_print_settings_init, value_print_settings_free_value, value_print_settings_copy_value, value_print_settings_peek_pointer, "p", value_print_settings_collect_value, "p", value_print_settings_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PrintSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintSettings), 0, (GInstanceInitFunc) print_settings_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType print_settings_type_id;
		print_settings_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PrintSettings", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&print_settings_type_id__volatile, print_settings_type_id);
	}
	return print_settings_type_id__volatile;
}


gpointer print_settings_ref (gpointer instance) {
	PrintSettings* self;
	self = instance;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	g_atomic_int_inc (&self->ref_count);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	return instance;
#line 1452 "Printing.c"
}


void print_settings_unref (gpointer instance) {
	PrintSettings* self;
	self = instance;
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		PRINT_SETTINGS_GET_CLASS (self)->finalize (self);
#line 13 "/home/jens/Source/shotwell/src/Printing.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1465 "Printing.c"
	}
}


GType measurement_unit_get_type (void) {
	static volatile gsize measurement_unit_type_id__volatile = 0;
	if (g_once_init_enter (&measurement_unit_type_id__volatile)) {
		static const GEnumValue values[] = {{MEASUREMENT_UNIT_INCHES, "MEASUREMENT_UNIT_INCHES", "inches"}, {MEASUREMENT_UNIT_CENTIMETERS, "MEASUREMENT_UNIT_CENTIMETERS", "centimeters"}, {0, NULL, NULL}};
		GType measurement_unit_type_id;
		measurement_unit_type_id = g_enum_register_static ("MeasurementUnit", values);
		g_once_init_leave (&measurement_unit_type_id__volatile, measurement_unit_type_id);
	}
	return measurement_unit_type_id__volatile;
}


void measurement_init (Measurement *self, gdouble value, MeasurementUnit unit) {
	gdouble _tmp0_ = 0.0;
	MeasurementUnit _tmp1_ = 0;
#line 185 "/home/jens/Source/shotwell/src/Printing.vala"
	memset (self, 0, sizeof (Measurement));
#line 186 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = value;
#line 186 "/home/jens/Source/shotwell/src/Printing.vala"
	(*self).value = _tmp0_;
#line 187 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = unit;
#line 187 "/home/jens/Source/shotwell/src/Printing.vala"
	(*self).unit = _tmp1_;
#line 1495 "Printing.c"
}


void measurement_convert_to (Measurement *self, MeasurementUnit to_unit, Measurement* result) {
	MeasurementUnit _tmp0_ = 0;
	MeasurementUnit _tmp1_ = 0;
	MeasurementUnit _tmp2_ = 0;
#line 191 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = (*self).unit;
#line 191 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = to_unit;
#line 191 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp0_ == _tmp1_) {
#line 192 "/home/jens/Source/shotwell/src/Printing.vala"
		*result = (*self);
#line 192 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 1513 "Printing.c"
	}
#line 194 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = to_unit;
#line 194 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_ == MEASUREMENT_UNIT_INCHES) {
#line 1519 "Printing.c"
		gdouble _tmp3_ = 0.0;
		Measurement _tmp4_ = {0};
#line 195 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = (*self).value;
#line 195 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp4_, _tmp3_ * MEASUREMENT_INCHES_PER_CENTIMETER, MEASUREMENT_UNIT_INCHES);
#line 195 "/home/jens/Source/shotwell/src/Printing.vala"
		*result = _tmp4_;
#line 195 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 1530 "Printing.c"
	} else {
		MeasurementUnit _tmp5_ = 0;
#line 196 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = to_unit;
#line 196 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp5_ == MEASUREMENT_UNIT_CENTIMETERS) {
#line 1537 "Printing.c"
			gdouble _tmp6_ = 0.0;
			Measurement _tmp7_ = {0};
#line 197 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp6_ = (*self).value;
#line 197 "/home/jens/Source/shotwell/src/Printing.vala"
			measurement_init (&_tmp7_, _tmp6_ * MEASUREMENT_CENTIMETERS_PER_INCH, MEASUREMENT_UNIT_CENTIMETERS);
#line 197 "/home/jens/Source/shotwell/src/Printing.vala"
			*result = _tmp7_;
#line 197 "/home/jens/Source/shotwell/src/Printing.vala"
			return;
#line 1548 "Printing.c"
		} else {
#line 199 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:199: unrecognized unit");
#line 1552 "Printing.c"
		}
	}
}


gboolean measurement_is_less_than (Measurement *self, Measurement* rhs) {
	gboolean result = FALSE;
	Measurement _tmp0_ = {0};
	MeasurementUnit _tmp1_ = 0;
	Measurement _tmp2_ = {0};
	MeasurementUnit _tmp3_ = 0;
	Measurement converted_rhs = {0};
	gdouble _tmp7_ = 0.0;
	Measurement _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
#line 203 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (rhs != NULL, FALSE);
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = (*self).unit;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = *rhs;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_.unit;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ == _tmp3_) {
#line 1578 "Printing.c"
		Measurement _tmp4_ = {0};
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = *rhs;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp4_;
#line 1584 "Printing.c"
	} else {
		MeasurementUnit _tmp5_ = 0;
		Measurement _tmp6_ = {0};
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = (*self).unit;
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (rhs, _tmp5_, &_tmp6_);
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp6_;
#line 1594 "Printing.c"
	}
#line 204 "/home/jens/Source/shotwell/src/Printing.vala"
	converted_rhs = _tmp0_;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = (*self).value;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = converted_rhs;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_.value;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp7_ < _tmp9_;
#line 205 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1608 "Printing.c"
}


gboolean measurement_is_greater_than (Measurement *self, Measurement* rhs) {
	gboolean result = FALSE;
	Measurement _tmp0_ = {0};
	MeasurementUnit _tmp1_ = 0;
	Measurement _tmp2_ = {0};
	MeasurementUnit _tmp3_ = 0;
	Measurement converted_rhs = {0};
	gdouble _tmp7_ = 0.0;
	Measurement _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
#line 208 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (rhs != NULL, FALSE);
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = (*self).unit;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = *rhs;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_.unit;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ == _tmp3_) {
#line 1632 "Printing.c"
		Measurement _tmp4_ = {0};
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = *rhs;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp4_;
#line 1638 "Printing.c"
	} else {
		MeasurementUnit _tmp5_ = 0;
		Measurement _tmp6_ = {0};
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = (*self).unit;
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (rhs, _tmp5_, &_tmp6_);
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp6_;
#line 1648 "Printing.c"
	}
#line 209 "/home/jens/Source/shotwell/src/Printing.vala"
	converted_rhs = _tmp0_;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = (*self).value;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = converted_rhs;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_.value;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp7_ > _tmp9_;
#line 210 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1662 "Printing.c"
}


Measurement* measurement_dup (const Measurement* self) {
	Measurement* dup;
#line 178 "/home/jens/Source/shotwell/src/Printing.vala"
	dup = g_new0 (Measurement, 1);
#line 178 "/home/jens/Source/shotwell/src/Printing.vala"
	memcpy (dup, self, sizeof (Measurement));
#line 178 "/home/jens/Source/shotwell/src/Printing.vala"
	return dup;
#line 1674 "Printing.c"
}


void measurement_free (Measurement* self) {
#line 178 "/home/jens/Source/shotwell/src/Printing.vala"
	g_free (self);
#line 1681 "Printing.c"
}


GType measurement_get_type (void) {
	static volatile gsize measurement_type_id__volatile = 0;
	if (g_once_init_enter (&measurement_type_id__volatile)) {
		GType measurement_type_id;
		measurement_type_id = g_boxed_type_register_static ("Measurement", (GBoxedCopyFunc) measurement_dup, (GBoxedFreeFunc) measurement_free);
		g_once_init_leave (&measurement_type_id__volatile, measurement_type_id);
	}
	return measurement_type_id__volatile;
}


PrintLayout* print_layout_get_all (int* result_length1) {
	PrintLayout* result = NULL;
	PrintLayout* _tmp0_ = NULL;
	PrintLayout* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_new0 (PrintLayout, 7);
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[0] = PRINT_LAYOUT_ENTIRE_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[1] = PRINT_LAYOUT_TWO_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[2] = PRINT_LAYOUT_FOUR_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[3] = PRINT_LAYOUT_SIX_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[4] = PRINT_LAYOUT_EIGHT_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[5] = PRINT_LAYOUT_SIXTEEN_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[6] = PRINT_LAYOUT_THIRTY_TWO_PER_PAGE;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1__length1 = 7;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	if (result_length1) {
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
		*result_length1 = _tmp1__length1;
#line 1725 "Printing.c"
	}
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 224 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1731 "Printing.c"
}


gint print_layout_get_per_page (PrintLayout self) {
	gint result = 0;
	gint* per_page = NULL;
	gint* _tmp0_ = NULL;
	gint per_page_length1 = 0;
	gint _per_page_size_ = 0;
	gint _tmp1_ = 0;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_new0 (gint, 7);
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[0] = 1;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[1] = 2;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[2] = 4;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[3] = 6;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[4] = 8;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[5] = 16;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[6] = 32;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	per_page = _tmp0_;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	per_page_length1 = 7;
#line 236 "/home/jens/Source/shotwell/src/Printing.vala"
	_per_page_size_ = per_page_length1;
#line 238 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = per_page[self];
#line 238 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 238 "/home/jens/Source/shotwell/src/Printing.vala"
	per_page = (g_free (per_page), NULL);
#line 238 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1772 "Printing.c"
}


gint print_layout_get_x (PrintLayout self) {
	gint result = 0;
	gint* x = NULL;
	gint* _tmp0_ = NULL;
	gint x_length1 = 0;
	gint _x_size_ = 0;
	gint _tmp1_ = 0;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_new0 (gint, 7);
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[0] = 1;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[1] = 1;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[2] = 2;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[3] = 2;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[4] = 2;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[5] = 4;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[6] = 4;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	x = _tmp0_;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	x_length1 = 7;
#line 242 "/home/jens/Source/shotwell/src/Printing.vala"
	_x_size_ = x_length1;
#line 244 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = x[self];
#line 244 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 244 "/home/jens/Source/shotwell/src/Printing.vala"
	x = (g_free (x), NULL);
#line 244 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1813 "Printing.c"
}


gint print_layout_get_y (PrintLayout self) {
	gint result = 0;
	gint* y = NULL;
	gint* _tmp0_ = NULL;
	gint y_length1 = 0;
	gint _y_size_ = 0;
	gint _tmp1_ = 0;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = g_new0 (gint, 7);
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[0] = 1;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[1] = 2;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[2] = 2;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[3] = 3;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[4] = 4;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[5] = 4;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_[6] = 8;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	y = _tmp0_;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	y_length1 = 7;
#line 248 "/home/jens/Source/shotwell/src/Printing.vala"
	_y_size_ = y_length1;
#line 250 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = y[self];
#line 250 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 250 "/home/jens/Source/shotwell/src/Printing.vala"
	y = (g_free (y), NULL);
#line 250 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1854 "Printing.c"
}


gchar* print_layout_to_string (PrintLayout self) {
	gchar* result = NULL;
	gchar** labels = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint labels_length1 = 0;
	gint _labels_size_ = 0;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = _ ("Fill the entire page");
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _ ("2 images per page");
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _ ("4 images per page");
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = _ ("6 images per page");
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = _ ("8 images per page");
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _ ("16 images per page");
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _ ("32 images per page");
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = g_strdup (_tmp12_);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = g_new0 (gchar*, 7 + 1);
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_[0] = _tmp1_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_[1] = _tmp3_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_[2] = _tmp5_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_[3] = _tmp7_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_[4] = _tmp9_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_[5] = _tmp11_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_[6] = _tmp13_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	labels = _tmp14_;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	labels_length1 = 7;
#line 254 "/home/jens/Source/shotwell/src/Printing.vala"
	_labels_size_ = labels_length1;
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = labels[self];
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp16_;
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	labels = (_vala_array_free (labels, labels_length1, (GDestroyNotify) g_free), NULL);
#line 264 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1940 "Printing.c"
}


GType print_layout_get_type (void) {
	static volatile gsize print_layout_type_id__volatile = 0;
	if (g_once_init_enter (&print_layout_type_id__volatile)) {
		static const GEnumValue values[] = {{PRINT_LAYOUT_ENTIRE_PAGE, "PRINT_LAYOUT_ENTIRE_PAGE", "entire-page"}, {PRINT_LAYOUT_TWO_PER_PAGE, "PRINT_LAYOUT_TWO_PER_PAGE", "two-per-page"}, {PRINT_LAYOUT_FOUR_PER_PAGE, "PRINT_LAYOUT_FOUR_PER_PAGE", "four-per-page"}, {PRINT_LAYOUT_SIX_PER_PAGE, "PRINT_LAYOUT_SIX_PER_PAGE", "six-per-page"}, {PRINT_LAYOUT_EIGHT_PER_PAGE, "PRINT_LAYOUT_EIGHT_PER_PAGE", "eight-per-page"}, {PRINT_LAYOUT_SIXTEEN_PER_PAGE, "PRINT_LAYOUT_SIXTEEN_PER_PAGE", "sixteen-per-page"}, {PRINT_LAYOUT_THIRTY_TWO_PER_PAGE, "PRINT_LAYOUT_THIRTY_TWO_PER_PAGE", "thirty-two-per-page"}, {0, NULL, NULL}};
		GType print_layout_type_id;
		print_layout_type_id = g_enum_register_static ("PrintLayout", values);
		g_once_init_leave (&print_layout_type_id__volatile, print_layout_type_id);
	}
	return print_layout_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 305 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? g_object_ref (self) : NULL;
#line 1959 "Printing.c"
}


static void _custom_print_tab_on_radio_group_click_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 307 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_radio_group_click ((CustomPrintTab*) self, _sender);
#line 1966 "Printing.c"
}


static gboolean _custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = custom_print_tab_standard_sizes_combo_separator_func (model, iter);
#line 316 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1975 "Printing.c"
}


static gpointer _standard_print_size_ref0 (gpointer self) {
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? standard_print_size_ref (self) : NULL;
#line 1982 "Printing.c"
}


static void _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender, const gchar* new_text, gint new_text_length, gint* position, gpointer self) {
#line 323 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_entry_insert_text ((CustomPrintTab*) self, _sender, new_text, new_text_length, position);
#line 1989 "Printing.c"
}


static gboolean _custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = custom_print_tab_on_width_entry_focus_out ((CustomPrintTab*) self, event);
#line 324 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 1998 "Printing.c"
}


static gboolean _custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = custom_print_tab_on_height_entry_focus_out ((CustomPrintTab*) self, event);
#line 327 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2007 "Printing.c"
}


static void _custom_print_tab_on_units_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 329 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_units_combo_changed ((CustomPrintTab*) self);
#line 2014 "Printing.c"
}


static void _custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender, const gchar* new_text, gint new_text_length, gint* position, gpointer self) {
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_ppi_entry_insert_text ((CustomPrintTab*) self, _sender, new_text, new_text_length, position);
#line 2021 "Printing.c"
}


static gboolean _custom_print_tab_on_ppi_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = custom_print_tab_on_ppi_entry_focus_out ((CustomPrintTab*) self, event);
#line 333 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2030 "Printing.c"
}


static void _custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 340 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_on_aspect_ratio_check_clicked ((CustomPrintTab*) self);
#line 2037 "Printing.c"
}


CustomPrintTab* custom_print_tab_construct (GType object_type, PrintJob* source_job) {
	CustomPrintTab * self = NULL;
	PrintJob* _tmp0_ = NULL;
	PrintJob* _tmp1_ = NULL;
	GtkRadioButton* _tmp2_ = NULL;
	GtkRadioButton* _tmp3_ = NULL;
	GtkRadioButton* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	PrintLayout* _tmp6_ = NULL;
	StandardPrintSize** standard_sizes = NULL;
	PrintManager* _tmp11_ = NULL;
	PrintManager* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	StandardPrintSize** _tmp14_ = NULL;
	StandardPrintSize** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gint standard_sizes_length1 = 0;
	gint _standard_sizes_size_ = 0;
	GtkComboBoxText* _tmp16_ = NULL;
	StandardPrintSize** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	GtkComboBoxText* _tmp22_ = NULL;
	ResourcesUnitSystem _tmp23_ = 0;
	GtkEntry* _tmp24_ = NULL;
	GtkEntry* _tmp25_ = NULL;
	GtkEntry* _tmp26_ = NULL;
	GtkEntry* _tmp27_ = NULL;
	GtkComboBoxText* _tmp28_ = NULL;
	GtkComboBoxText* _tmp29_ = NULL;
	ResourcesUnitSystem _tmp30_ = 0;
	GtkEntry* _tmp31_ = NULL;
	GtkEntry* _tmp32_ = NULL;
	PrintJob* _tmp33_ = NULL;
	GtkCheckButton* _tmp34_ = NULL;
#line 304 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (source_job), NULL);
#line 304 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (CustomPrintTab*) g_object_new (object_type, NULL);
#line 305 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = source_job;
#line 305 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 305 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->source_job);
#line 305 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->source_job = _tmp1_;
#line 307 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->standard_size_radio;
#line 307 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
#line 308 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->custom_size_radio;
#line 308 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
#line 309 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = self->priv->image_per_page_radio;
#line 309 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = print_layout_get_all (&_tmp5_);
#line 2101 "Printing.c"
	{
		PrintLayout* layout_collection = NULL;
		gint layout_collection_length1 = 0;
		gint _layout_collection_size_ = 0;
		gint layout_it = 0;
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
		layout_collection = _tmp6_;
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
		layout_collection_length1 = _tmp5_;
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
		for (layout_it = 0; layout_it < _tmp5_; layout_it = layout_it + 1) {
#line 2113 "Printing.c"
			PrintLayout layout = 0;
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
			layout = layout_collection[layout_it];
#line 2117 "Printing.c"
			{
				GtkComboBoxText* _tmp7_ = NULL;
				PrintLayout _tmp8_ = 0;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
#line 312 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp7_ = self->priv->image_per_page_combo;
#line 312 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp8_ = layout;
#line 312 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp9_ = print_layout_to_string (_tmp8_);
#line 312 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp10_ = _tmp9_;
#line 312 "/home/jens/Source/shotwell/src/Printing.vala"
				gtk_combo_box_text_append_text (_tmp7_, _tmp10_);
#line 312 "/home/jens/Source/shotwell/src/Printing.vala"
				_g_free0 (_tmp10_);
#line 2135 "Printing.c"
			}
		}
#line 311 "/home/jens/Source/shotwell/src/Printing.vala"
		layout_collection = (g_free (layout_collection), NULL);
#line 2140 "Printing.c"
	}
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = print_manager_get_instance ();
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _tmp11_;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = print_manager_get_standard_sizes (_tmp12_, &_tmp13_);
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = _tmp14_;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15__length1 = _tmp13_;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_manager_unref0 (_tmp12_);
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	standard_sizes = _tmp15_;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	standard_sizes_length1 = _tmp15__length1;
#line 315 "/home/jens/Source/shotwell/src/Printing.vala"
	_standard_sizes_size_ = standard_sizes_length1;
#line 316 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = self->priv->standard_sizes_combo;
#line 316 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_row_separator_func (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_combo_box_get_type (), GtkComboBox), _custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func, NULL, NULL);
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = standard_sizes;
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17__length1 = standard_sizes_length1;
#line 2168 "Printing.c"
	{
		StandardPrintSize** size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
		size_collection = _tmp17_;
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
		size_collection_length1 = _tmp17__length1;
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
		for (size_it = 0; size_it < _tmp17__length1; size_it = size_it + 1) {
#line 2180 "Printing.c"
			StandardPrintSize* _tmp18_ = NULL;
			StandardPrintSize* size = NULL;
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp18_ = _standard_print_size_ref0 (size_collection[size_it]);
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
			size = _tmp18_;
#line 2187 "Printing.c"
			{
				GtkComboBoxText* _tmp19_ = NULL;
				StandardPrintSize* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp19_ = self->priv->standard_sizes_combo;
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp20_ = size;
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp21_ = _tmp20_->name;
#line 318 "/home/jens/Source/shotwell/src/Printing.vala"
				gtk_combo_box_text_append_text (_tmp19_, _tmp21_);
#line 317 "/home/jens/Source/shotwell/src/Printing.vala"
				_standard_print_size_unref0 (size);
#line 2202 "Printing.c"
			}
		}
	}
#line 321 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp22_ = self->priv->standard_sizes_combo;
#line 321 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp23_ = resources_get_default_measurement_unit ();
#line 321 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_combo_box_get_type (), GtkComboBox), 9 * _tmp23_);
#line 323 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp24_ = self->priv->custom_width_entry;
#line 323 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GTK_TYPE_EDITABLE, GtkEditable), "insert-text", (GCallback) _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text, self, 0);
#line 324 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp25_ = self->priv->custom_width_entry;
#line 324 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event, self, 0);
#line 326 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp26_ = self->priv->custom_height_entry;
#line 326 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GTK_TYPE_EDITABLE, GtkEditable), "insert-text", (GCallback) _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text, self, 0);
#line 327 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp27_ = self->priv->custom_height_entry;
#line 327 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event, self, 0);
#line 329 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp28_ = self->priv->units_combo;
#line 329 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_combo_box_get_type (), GtkComboBox), "changed", (GCallback) _custom_print_tab_on_units_combo_changed_gtk_combo_box_changed, self, 0);
#line 330 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp29_ = self->priv->units_combo;
#line 330 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp30_ = resources_get_default_measurement_unit ();
#line 330 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_combo_box_get_type (), GtkComboBox), (gint) _tmp30_);
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp31_ = self->priv->ppi_entry;
#line 332 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GTK_TYPE_EDITABLE, GtkEditable), "insert-text", (GCallback) _custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text, self, 0);
#line 333 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp32_ = self->priv->ppi_entry;
#line 333 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _custom_print_tab_on_ppi_entry_focus_out_gtk_widget_focus_out_event, self, 0);
#line 335 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp33_ = source_job;
#line 335 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_sync_state_from_job (self, _tmp33_);
#line 337 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 340 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp34_ = self->priv->aspect_ratio_check;
#line 340 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked, self, 0);
#line 304 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 2258 "Printing.c"
}


CustomPrintTab* custom_print_tab_new (PrintJob* source_job) {
#line 304 "/home/jens/Source/shotwell/src/Printing.vala"
	return custom_print_tab_construct (TYPE_CUSTOM_PRINT_TAB, source_job);
#line 2265 "Printing.c"
}


static void custom_print_tab_on_aspect_ratio_check_clicked (CustomPrintTab* self) {
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 343 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 344 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->aspect_ratio_check;
#line 344 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 344 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_) {
#line 2280 "Printing.c"
		Measurement _tmp2_ = {0};
		gdouble _tmp3_ = 0.0;
		PrintJob* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		Measurement _tmp6_ = {0};
		MeasurementUnit _tmp7_ = 0;
		GtkEntry* _tmp8_ = NULL;
		Measurement _tmp9_ = {0};
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = self->priv->local_content_height;
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = _tmp2_.value;
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = self->priv->source_job;
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = print_job_get_source_aspect_ratio (_tmp4_);
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = self->priv->local_content_height;
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp7_ = _tmp6_.unit;
#line 345 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&self->priv->local_content_width, _tmp3_ * _tmp5_, _tmp7_);
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp8_ = self->priv->custom_width_entry;
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp9_ = self->priv->local_content_width;
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp10_ = custom_print_tab_format_measurement (self, &_tmp9_);
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp11_ = _tmp10_;
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp8_, _tmp11_);
#line 348 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp11_);
#line 2317 "Printing.c"
	}
}


static gboolean custom_print_tab_on_width_entry_focus_out (CustomPrintTab* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Measurement _tmp2_ = {0};
	MeasurementUnit _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	Measurement new_width = {0};
	Measurement _tmp7_ = {0};
	Measurement min_width = {0};
	PrintJob* _tmp8_ = NULL;
	PrintSettings* _tmp9_ = NULL;
	PrintSettings* _tmp10_ = NULL;
	Measurement _tmp11_ = {0};
	Measurement _tmp12_ = {0};
	Measurement max_width = {0};
	PrintJob* _tmp13_ = NULL;
	PrintSettings* _tmp14_ = NULL;
	PrintSettings* _tmp15_ = NULL;
	Measurement _tmp16_ = {0};
	Measurement _tmp17_ = {0};
	gboolean _tmp18_ = FALSE;
	Measurement _tmp19_ = {0};
	gboolean _tmp20_ = FALSE;
	gboolean _tmp27_ = FALSE;
	Measurement _tmp39_ = {0};
	GtkEntry* _tmp40_ = NULL;
	Measurement _tmp41_ = {0};
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
#line 352 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 352 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_width_entry;
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->local_content_width;
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_get_user_unit_choice (self);
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = custom_print_tab_format_measurement_as (self, &_tmp2_, _tmp3_);
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = _tmp4_;
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = g_strcmp0 (_tmp1_, _tmp5_) == 0;
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp5_);
#line 353 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp6_) {
#line 355 "/home/jens/Source/shotwell/src/Printing.vala"
		result = FALSE;
#line 355 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 2380 "Printing.c"
	}
#line 357 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_get_width_entry_value (self, &_tmp7_);
#line 357 "/home/jens/Source/shotwell/src/Printing.vala"
	new_width = _tmp7_;
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = self->priv->source_job;
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = print_job_get_local_settings (_tmp8_);
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _tmp9_;
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_minimum_content_dimension (_tmp10_, &_tmp11_);
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _tmp11_;
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp10_);
#line 358 "/home/jens/Source/shotwell/src/Printing.vala"
	min_width = _tmp12_;
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = self->priv->source_job;
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = print_job_get_local_settings (_tmp13_);
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = _tmp14_;
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_maximum_content_dimension (_tmp15_, &_tmp16_);
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _tmp16_;
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp15_);
#line 359 "/home/jens/Source/shotwell/src/Printing.vala"
	max_width = _tmp17_;
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp19_ = min_width;
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp20_ = measurement_is_less_than (&new_width, &_tmp19_);
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp20_) {
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = TRUE;
#line 2422 "Printing.c"
	} else {
		Measurement _tmp21_ = {0};
		gboolean _tmp22_ = FALSE;
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp21_ = max_width;
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = measurement_is_greater_than (&new_width, &_tmp21_);
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = _tmp22_;
#line 2432 "Printing.c"
	}
#line 361 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp18_) {
#line 2436 "Printing.c"
		GtkEntry* _tmp23_ = NULL;
		Measurement _tmp24_ = {0};
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
#line 362 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp23_ = self->priv->custom_width_entry;
#line 362 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp24_ = self->priv->local_content_width;
#line 362 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp25_ = custom_print_tab_format_measurement (self, &_tmp24_);
#line 362 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = _tmp25_;
#line 362 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp23_, _tmp26_);
#line 362 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp26_);
#line 363 "/home/jens/Source/shotwell/src/Printing.vala"
		result = FALSE;
#line 363 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 2457 "Printing.c"
	}
#line 366 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp27_ = custom_print_tab_is_match_aspect_ratio_enabled (self);
#line 366 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp27_) {
#line 2463 "Printing.c"
		Measurement new_height = {0};
		Measurement _tmp28_ = {0};
		gdouble _tmp29_ = 0.0;
		PrintJob* _tmp30_ = NULL;
		gdouble _tmp31_ = 0.0;
		Measurement _tmp32_ = {0};
		MeasurementUnit _tmp33_ = 0;
		Measurement _tmp34_ = {0};
		GtkEntry* _tmp35_ = NULL;
		Measurement _tmp36_ = {0};
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
#line 367 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp28_ = new_width;
#line 367 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = _tmp28_.value;
#line 367 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp30_ = self->priv->source_job;
#line 367 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp31_ = print_job_get_source_aspect_ratio (_tmp30_);
#line 367 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp32_ = new_width;
#line 367 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp33_ = _tmp32_.unit;
#line 367 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&new_height, _tmp29_ / _tmp31_, _tmp33_);
#line 370 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp34_ = new_height;
#line 370 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->local_content_height = _tmp34_;
#line 371 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp35_ = self->priv->custom_height_entry;
#line 371 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp36_ = new_height;
#line 371 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp37_ = custom_print_tab_format_measurement (self, &_tmp36_);
#line 371 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp38_ = _tmp37_;
#line 371 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp35_, _tmp38_);
#line 371 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp38_);
#line 2506 "Printing.c"
	}
#line 374 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp39_ = new_width;
#line 374 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_width = _tmp39_;
#line 375 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp40_ = self->priv->custom_width_entry;
#line 375 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp41_ = new_width;
#line 375 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp42_ = custom_print_tab_format_measurement (self, &_tmp41_);
#line 375 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp43_ = _tmp42_;
#line 375 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp40_, _tmp43_);
#line 375 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp43_);
#line 376 "/home/jens/Source/shotwell/src/Printing.vala"
	result = FALSE;
#line 376 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2528 "Printing.c"
}


static gchar* custom_print_tab_format_measurement (CustomPrintTab* self, Measurement* measurement) {
	gchar* result = NULL;
	Measurement _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	gchar* _tmp2_ = NULL;
#line 379 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 379 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (measurement != NULL, NULL);
#line 380 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *measurement;
#line 380 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_.value;
#line 380 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = g_strdup_printf ("%.2f", _tmp1_);
#line 380 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp2_;
#line 380 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2551 "Printing.c"
}


static gchar* custom_print_tab_format_measurement_as (CustomPrintTab* self, Measurement* measurement, MeasurementUnit to_unit) {
	gchar* result = NULL;
	Measurement _tmp0_ = {0};
	Measurement _tmp1_ = {0};
	MeasurementUnit _tmp2_ = 0;
	MeasurementUnit _tmp3_ = 0;
	Measurement converted_measurement = {0};
	Measurement _tmp7_ = {0};
	gchar* _tmp8_ = NULL;
#line 383 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 383 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (measurement != NULL, NULL);
#line 384 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = *measurement;
#line 384 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _tmp1_.unit;
#line 384 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = to_unit;
#line 384 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_ == _tmp3_) {
#line 2576 "Printing.c"
		Measurement _tmp4_ = {0};
#line 384 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = *measurement;
#line 384 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp4_;
#line 2582 "Printing.c"
	} else {
		MeasurementUnit _tmp5_ = 0;
		Measurement _tmp6_ = {0};
#line 385 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = to_unit;
#line 385 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (measurement, _tmp5_, &_tmp6_);
#line 385 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp0_ = _tmp6_;
#line 2592 "Printing.c"
	}
#line 384 "/home/jens/Source/shotwell/src/Printing.vala"
	converted_measurement = _tmp0_;
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = converted_measurement;
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = custom_print_tab_format_measurement (self, &_tmp7_);
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp8_;
#line 386 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2604 "Printing.c"
}


static gboolean custom_print_tab_on_ppi_entry_focus_out (CustomPrintTab* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 389 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 389 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 390 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->ppi_entry;
#line 390 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 390 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = atoi (_tmp1_);
#line 390 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_ppi (self, _tmp2_);
#line 391 "/home/jens/Source/shotwell/src/Printing.vala"
	result = FALSE;
#line 391 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 2629 "Printing.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 1086 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 2647 "Printing.c"
}


static void custom_print_tab_on_ppi_entry_insert_text (CustomPrintTab* self, GtkEditable* editable, const gchar* text, gint length, gint* position) {
	GtkEntry* sender = NULL;
	GtkEditable* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gchar* new_text = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GtkEntry* _tmp31_ = NULL;
#line 394 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 394 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_EDITABLE (editable));
#line 394 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (text != NULL);
#line 396 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = editable;
#line 396 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_entry_get_type (), GtkEntry));
#line 396 "/home/jens/Source/shotwell/src/Printing.vala"
	sender = _tmp1_;
#line 398 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->is_text_insertion_in_progress;
#line 398 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_) {
#line 399 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (sender);
#line 399 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 2683 "Printing.c"
	}
#line 401 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = TRUE;
#line 403 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = length;
#line 403 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp3_ == -1) {
#line 2691 "Printing.c"
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 404 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = text;
#line 404 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = strlen (_tmp4_);
#line 404 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = _tmp5_;
#line 404 "/home/jens/Source/shotwell/src/Printing.vala"
		length = (gint) _tmp6_;
#line 2703 "Printing.c"
	}
#line 406 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = g_strdup ("");
#line 406 "/home/jens/Source/shotwell/src/Printing.vala"
	new_text = _tmp7_;
#line 2709 "Printing.c"
	{
		gint ctr = 0;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
		ctr = 0;
#line 2714 "Printing.c"
		{
			gboolean _tmp8_ = FALSE;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp8_ = TRUE;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
			while (TRUE) {
#line 2721 "Printing.c"
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				const gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gchar _tmp14_ = '\0';
				gboolean _tmp15_ = FALSE;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
				if (!_tmp8_) {
#line 2730 "Printing.c"
					gint _tmp9_ = 0;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp9_ = ctr;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
					ctr = _tmp9_ + 1;
#line 2736 "Printing.c"
				}
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp8_ = FALSE;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp10_ = ctr;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp11_ = length;
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
				if (!(_tmp10_ < _tmp11_)) {
#line 407 "/home/jens/Source/shotwell/src/Printing.vala"
					break;
#line 2748 "Printing.c"
				}
#line 408 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp12_ = text;
#line 408 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp13_ = ctr;
#line 408 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
#line 408 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp15_ = g_ascii_isdigit (_tmp14_);
#line 408 "/home/jens/Source/shotwell/src/Printing.vala"
				if (_tmp15_) {
#line 2760 "Printing.c"
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					gint _tmp18_ = 0;
					gchar _tmp19_ = '\0';
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					gchar* _tmp22_ = NULL;
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp16_ = new_text;
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp17_ = text;
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp18_ = ctr;
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp19_ = string_get (_tmp17_, (glong) _tmp18_);
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp20_ = g_strdup_printf ("%c", (gchar) _tmp19_);
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp21_ = _tmp20_;
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp22_ = g_strconcat (_tmp16_, _tmp21_, NULL);
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (new_text);
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					new_text = _tmp22_;
#line 409 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (_tmp21_);
#line 2788 "Printing.c"
				}
			}
		}
	}
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp23_ = new_text;
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp24_ = strlen (_tmp23_);
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp25_ = _tmp24_;
#line 412 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp25_ > 0) {
#line 2801 "Printing.c"
		GtkEntry* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = sender;
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp27_ = new_text;
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp28_ = new_text;
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = strlen (_tmp28_);
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp30_ = _tmp29_;
#line 413 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_editable_insert_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GTK_TYPE_EDITABLE, GtkEditable), _tmp27_, (gint) _tmp30_, position);
#line 2819 "Printing.c"
	}
#line 415 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp31_ = sender;
#line 415 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_stop_emission_by_name (_tmp31_, "insert-text");
#line 417 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = FALSE;
#line 394 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (new_text);
#line 394 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (sender);
#line 2831 "Printing.c"
}


static gboolean custom_print_tab_on_height_entry_focus_out (CustomPrintTab* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Measurement _tmp2_ = {0};
	MeasurementUnit _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	Measurement new_height = {0};
	Measurement _tmp7_ = {0};
	Measurement min_height = {0};
	PrintJob* _tmp8_ = NULL;
	PrintSettings* _tmp9_ = NULL;
	PrintSettings* _tmp10_ = NULL;
	Measurement _tmp11_ = {0};
	Measurement _tmp12_ = {0};
	Measurement max_height = {0};
	PrintJob* _tmp13_ = NULL;
	PrintSettings* _tmp14_ = NULL;
	PrintSettings* _tmp15_ = NULL;
	Measurement _tmp16_ = {0};
	Measurement _tmp17_ = {0};
	gboolean _tmp18_ = FALSE;
	Measurement _tmp19_ = {0};
	gboolean _tmp20_ = FALSE;
	gboolean _tmp27_ = FALSE;
	Measurement _tmp39_ = {0};
	GtkEntry* _tmp40_ = NULL;
	Measurement _tmp41_ = {0};
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
#line 420 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 420 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_height_entry;
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->local_content_height;
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_get_user_unit_choice (self);
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = custom_print_tab_format_measurement_as (self, &_tmp2_, _tmp3_);
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = _tmp4_;
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = g_strcmp0 (_tmp1_, _tmp5_) == 0;
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp5_);
#line 421 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp6_) {
#line 423 "/home/jens/Source/shotwell/src/Printing.vala"
		result = FALSE;
#line 423 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 2893 "Printing.c"
	}
#line 425 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_get_height_entry_value (self, &_tmp7_);
#line 425 "/home/jens/Source/shotwell/src/Printing.vala"
	new_height = _tmp7_;
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = self->priv->source_job;
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = print_job_get_local_settings (_tmp8_);
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _tmp9_;
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_minimum_content_dimension (_tmp10_, &_tmp11_);
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _tmp11_;
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp10_);
#line 426 "/home/jens/Source/shotwell/src/Printing.vala"
	min_height = _tmp12_;
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = self->priv->source_job;
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = print_job_get_local_settings (_tmp13_);
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = _tmp14_;
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_maximum_content_dimension (_tmp15_, &_tmp16_);
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _tmp16_;
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp15_);
#line 427 "/home/jens/Source/shotwell/src/Printing.vala"
	max_height = _tmp17_;
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp19_ = min_height;
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp20_ = measurement_is_less_than (&new_height, &_tmp19_);
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp20_) {
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = TRUE;
#line 2935 "Printing.c"
	} else {
		Measurement _tmp21_ = {0};
		gboolean _tmp22_ = FALSE;
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp21_ = max_height;
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = measurement_is_greater_than (&new_height, &_tmp21_);
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = _tmp22_;
#line 2945 "Printing.c"
	}
#line 429 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp18_) {
#line 2949 "Printing.c"
		GtkEntry* _tmp23_ = NULL;
		Measurement _tmp24_ = {0};
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
#line 430 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp23_ = self->priv->custom_height_entry;
#line 430 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp24_ = self->priv->local_content_height;
#line 430 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp25_ = custom_print_tab_format_measurement (self, &_tmp24_);
#line 430 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = _tmp25_;
#line 430 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp23_, _tmp26_);
#line 430 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp26_);
#line 431 "/home/jens/Source/shotwell/src/Printing.vala"
		result = FALSE;
#line 431 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 2970 "Printing.c"
	}
#line 434 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp27_ = custom_print_tab_is_match_aspect_ratio_enabled (self);
#line 434 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp27_) {
#line 2976 "Printing.c"
		Measurement new_width = {0};
		Measurement _tmp28_ = {0};
		gdouble _tmp29_ = 0.0;
		PrintJob* _tmp30_ = NULL;
		gdouble _tmp31_ = 0.0;
		Measurement _tmp32_ = {0};
		MeasurementUnit _tmp33_ = 0;
		Measurement _tmp34_ = {0};
		GtkEntry* _tmp35_ = NULL;
		Measurement _tmp36_ = {0};
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp28_ = new_height;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = _tmp28_.value;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp30_ = self->priv->source_job;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp31_ = print_job_get_source_aspect_ratio (_tmp30_);
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp32_ = new_height;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp33_ = _tmp32_.unit;
#line 435 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&new_width, _tmp29_ * _tmp31_, _tmp33_);
#line 438 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp34_ = new_width;
#line 438 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->local_content_width = _tmp34_;
#line 439 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp35_ = self->priv->custom_width_entry;
#line 439 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp36_ = new_width;
#line 439 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp37_ = custom_print_tab_format_measurement (self, &_tmp36_);
#line 439 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp38_ = _tmp37_;
#line 439 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp35_, _tmp38_);
#line 439 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp38_);
#line 3019 "Printing.c"
	}
#line 442 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp39_ = new_height;
#line 442 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_height = _tmp39_;
#line 443 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp40_ = self->priv->custom_height_entry;
#line 443 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp41_ = new_height;
#line 443 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp42_ = custom_print_tab_format_measurement (self, &_tmp41_);
#line 443 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp43_ = _tmp42_;
#line 443 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp40_, _tmp43_);
#line 443 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp43_);
#line 444 "/home/jens/Source/shotwell/src/Printing.vala"
	result = FALSE;
#line 444 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 3041 "Printing.c"
}


static MeasurementUnit custom_print_tab_get_user_unit_choice (CustomPrintTab* self) {
	MeasurementUnit result = 0;
	GtkComboBoxText* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 447 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 448 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->units_combo;
#line 448 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox));
#line 448 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ == CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE) {
#line 449 "/home/jens/Source/shotwell/src/Printing.vala"
		result = MEASUREMENT_UNIT_INCHES;
#line 449 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 3061 "Printing.c"
	} else {
		GtkComboBoxText* _tmp2_ = NULL;
		gint _tmp3_ = 0;
#line 450 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = self->priv->units_combo;
#line 450 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_combo_box_get_type (), GtkComboBox));
#line 450 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp3_ == CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE) {
#line 451 "/home/jens/Source/shotwell/src/Printing.vala"
			result = MEASUREMENT_UNIT_CENTIMETERS;
#line 451 "/home/jens/Source/shotwell/src/Printing.vala"
			return result;
#line 3075 "Printing.c"
		} else {
#line 453 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:453: unknown unit combo box choice");
#line 3079 "Printing.c"
		}
	}
}


static void custom_print_tab_set_user_unit_choice (CustomPrintTab* self, MeasurementUnit unit) {
	MeasurementUnit _tmp0_ = 0;
#line 457 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 458 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = unit;
#line 458 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp0_ == MEASUREMENT_UNIT_INCHES) {
#line 3093 "Printing.c"
		GtkComboBoxText* _tmp1_ = NULL;
#line 459 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp1_ = self->priv->units_combo;
#line 459 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_combo_box_get_type (), GtkComboBox), CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE);
#line 3099 "Printing.c"
	} else {
		MeasurementUnit _tmp2_ = 0;
#line 460 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = unit;
#line 460 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp2_ == MEASUREMENT_UNIT_CENTIMETERS) {
#line 3106 "Printing.c"
			GtkComboBoxText* _tmp3_ = NULL;
#line 461 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp3_ = self->priv->units_combo;
#line 461 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_combo_box_get_type (), GtkComboBox), CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE);
#line 3112 "Printing.c"
		} else {
#line 463 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:463: unknown MeasurementUnit enumeration");
#line 3116 "Printing.c"
		}
	}
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 869 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0.0);
#line 870 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 870 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
#line 870 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 870 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 3136 "Printing.c"
}


static void custom_print_tab_get_width_entry_value (CustomPrintTab* self, Measurement* result) {
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	MeasurementUnit _tmp3_ = 0;
	Measurement _tmp4_ = {0};
#line 467 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 468 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_width_entry;
#line 468 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 468 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = double_parse (_tmp1_);
#line 468 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_get_user_unit_choice (self);
#line 468 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp4_, _tmp2_, _tmp3_);
#line 468 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp4_;
#line 468 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 3162 "Printing.c"
}


static void custom_print_tab_get_height_entry_value (CustomPrintTab* self, Measurement* result) {
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	MeasurementUnit _tmp3_ = 0;
	Measurement _tmp4_ = {0};
#line 471 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 472 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_height_entry;
#line 472 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 472 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = double_parse (_tmp1_);
#line 472 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_get_user_unit_choice (self);
#line 472 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&_tmp4_, _tmp2_, _tmp3_);
#line 472 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp4_;
#line 472 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 3188 "Printing.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 3208 "Printing.c"
}


static void custom_print_tab_on_entry_insert_text (CustomPrintTab* self, GtkEditable* editable, const gchar* text, gint length, gint* position) {
	GtkEntry* sender = NULL;
	GtkEditable* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	const gchar* decimal_point = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean contains_decimal_point = FALSE;
	GtkEntry* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gchar* new_text = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	GtkEntry* _tmp50_ = NULL;
#line 475 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 475 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_EDITABLE (editable));
#line 475 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (text != NULL);
#line 478 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = editable;
#line 478 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_entry_get_type (), GtkEntry));
#line 478 "/home/jens/Source/shotwell/src/Printing.vala"
	sender = _tmp1_;
#line 480 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->is_text_insertion_in_progress;
#line 480 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_) {
#line 481 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (sender);
#line 481 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 3251 "Printing.c"
	}
#line 483 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = TRUE;
#line 485 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = length;
#line 485 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp3_ == -1) {
#line 3259 "Printing.c"
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 486 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = text;
#line 486 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = strlen (_tmp4_);
#line 486 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = _tmp5_;
#line 486 "/home/jens/Source/shotwell/src/Printing.vala"
		length = (gint) _tmp6_;
#line 3271 "Printing.c"
	}
#line 488 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = nl_langinfo (RADIXCHAR);
#line 488 "/home/jens/Source/shotwell/src/Printing.vala"
	decimal_point = _tmp7_;
#line 490 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = sender;
#line 490 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = gtk_entry_get_text (_tmp8_);
#line 490 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = decimal_point;
#line 490 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = string_contains (_tmp9_, _tmp10_);
#line 490 "/home/jens/Source/shotwell/src/Printing.vala"
	contains_decimal_point = _tmp11_;
#line 492 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = g_strdup ("");
#line 492 "/home/jens/Source/shotwell/src/Printing.vala"
	new_text = _tmp12_;
#line 3291 "Printing.c"
	{
		gint ctr = 0;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
		ctr = 0;
#line 3296 "Printing.c"
		{
			gboolean _tmp13_ = FALSE;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp13_ = TRUE;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
			while (TRUE) {
#line 3303 "Printing.c"
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				const gchar* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gchar _tmp19_ = '\0';
				gboolean _tmp20_ = FALSE;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
				if (!_tmp13_) {
#line 3312 "Printing.c"
					gint _tmp14_ = 0;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp14_ = ctr;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
					ctr = _tmp14_ + 1;
#line 3318 "Printing.c"
				}
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp13_ = FALSE;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp15_ = ctr;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp16_ = length;
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
				if (!(_tmp15_ < _tmp16_)) {
#line 493 "/home/jens/Source/shotwell/src/Printing.vala"
					break;
#line 3330 "Printing.c"
				}
#line 494 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp17_ = text;
#line 494 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp18_ = ctr;
#line 494 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp19_ = string_get (_tmp17_, (glong) _tmp18_);
#line 494 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp20_ = g_ascii_isdigit (_tmp19_);
#line 494 "/home/jens/Source/shotwell/src/Printing.vala"
				if (_tmp20_) {
#line 3342 "Printing.c"
					const gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					gint _tmp23_ = 0;
					gchar _tmp24_ = '\0';
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp21_ = new_text;
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp22_ = text;
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp23_ = ctr;
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp24_ = string_get (_tmp22_, (glong) _tmp23_);
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp25_ = g_strdup_printf ("%c", (gchar) _tmp24_);
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp26_ = _tmp25_;
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp27_ = g_strconcat (_tmp21_, _tmp26_, NULL);
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (new_text);
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					new_text = _tmp27_;
#line 495 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (_tmp26_);
#line 3370 "Printing.c"
				} else {
					gboolean _tmp28_ = FALSE;
					gboolean _tmp29_ = FALSE;
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp29_ = contains_decimal_point;
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
					if (!_tmp29_) {
#line 3378 "Printing.c"
						const gchar* _tmp30_ = NULL;
						gint _tmp31_ = 0;
						gchar _tmp32_ = '\0';
						const gchar* _tmp33_ = NULL;
						gchar _tmp34_ = '\0';
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp30_ = text;
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp31_ = ctr;
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp32_ = string_get (_tmp30_, (glong) _tmp31_);
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp33_ = decimal_point;
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp34_ = string_get (_tmp33_, (glong) 0);
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp28_ = _tmp32_ == _tmp34_;
#line 3396 "Printing.c"
					} else {
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp28_ = FALSE;
#line 3400 "Printing.c"
					}
#line 496 "/home/jens/Source/shotwell/src/Printing.vala"
					if (_tmp28_) {
#line 3404 "Printing.c"
						const gchar* _tmp35_ = NULL;
						const gchar* _tmp36_ = NULL;
						gint _tmp37_ = 0;
						gchar _tmp38_ = '\0';
						gchar* _tmp39_ = NULL;
						gchar* _tmp40_ = NULL;
						gchar* _tmp41_ = NULL;
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp35_ = new_text;
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp36_ = text;
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp37_ = ctr;
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp38_ = string_get (_tmp36_, (glong) _tmp37_);
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp39_ = g_strdup_printf ("%c", (gchar) _tmp38_);
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp40_ = _tmp39_;
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp41_ = g_strconcat (_tmp35_, _tmp40_, NULL);
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_g_free0 (new_text);
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						new_text = _tmp41_;
#line 497 "/home/jens/Source/shotwell/src/Printing.vala"
						_g_free0 (_tmp40_);
#line 3432 "Printing.c"
					}
				}
			}
		}
	}
#line 501 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp42_ = new_text;
#line 501 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp43_ = strlen (_tmp42_);
#line 501 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp44_ = _tmp43_;
#line 501 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp44_ > 0) {
#line 3446 "Printing.c"
		GtkEntry* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
#line 502 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp45_ = sender;
#line 502 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp46_ = new_text;
#line 502 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp47_ = new_text;
#line 502 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp48_ = strlen (_tmp47_);
#line 502 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp49_ = _tmp48_;
#line 502 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_editable_insert_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GTK_TYPE_EDITABLE, GtkEditable), _tmp46_, (gint) _tmp49_, position);
#line 3464 "Printing.c"
	}
#line 504 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp50_ = sender;
#line 504 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_stop_emission_by_name (_tmp50_, "insert-text");
#line 506 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = FALSE;
#line 475 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (new_text);
#line 475 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (sender);
#line 3476 "Printing.c"
}


static void custom_print_tab_sync_state_from_job (CustomPrintTab* self, PrintJob* job) {
	PrintJob* _tmp0_ = NULL;
	PrintSettings* _tmp1_ = NULL;
	PrintSettings* _tmp2_ = NULL;
	Measurement _tmp3_ = {0};
	MeasurementUnit _tmp4_ = 0;
	PrintJob* _tmp5_ = NULL;
	PrintSettings* _tmp6_ = NULL;
	PrintSettings* _tmp7_ = NULL;
	Measurement _tmp8_ = {0};
	MeasurementUnit _tmp9_ = 0;
	Measurement constrained_width = {0};
	PrintJob* _tmp10_ = NULL;
	PrintSettings* _tmp11_ = NULL;
	PrintSettings* _tmp12_ = NULL;
	Measurement _tmp13_ = {0};
	Measurement _tmp14_ = {0};
	PrintJob* _tmp15_ = NULL;
	PrintSettings* _tmp16_ = NULL;
	PrintSettings* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	Measurement _tmp32_ = {0};
	PrintJob* _tmp33_ = NULL;
	PrintSettings* _tmp34_ = NULL;
	PrintSettings* _tmp35_ = NULL;
	Measurement _tmp36_ = {0};
	PrintJob* _tmp37_ = NULL;
	PrintSettings* _tmp38_ = NULL;
	PrintSettings* _tmp39_ = NULL;
	ContentLayout _tmp40_ = 0;
	PrintJob* _tmp41_ = NULL;
	PrintSettings* _tmp42_ = NULL;
	PrintSettings* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	PrintJob* _tmp45_ = NULL;
	PrintSettings* _tmp46_ = NULL;
	PrintSettings* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	PrintJob* _tmp49_ = NULL;
	PrintSettings* _tmp50_ = NULL;
	PrintSettings* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	PrintJob* _tmp53_ = NULL;
	PrintSettings* _tmp54_ = NULL;
	PrintSettings* _tmp55_ = NULL;
	gboolean _tmp56_ = FALSE;
	PrintJob* _tmp57_ = NULL;
	PrintSettings* _tmp58_ = NULL;
	PrintSettings* _tmp59_ = NULL;
	gboolean _tmp60_ = FALSE;
	PrintJob* _tmp61_ = NULL;
	PrintSettings* _tmp62_ = NULL;
	PrintSettings* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
#line 509 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 509 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_JOB (job));
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = job;
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = print_job_get_local_settings (_tmp0_);
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _tmp1_;
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_content_width (_tmp2_, &_tmp3_);
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_.unit;
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = job;
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = print_job_get_local_settings (_tmp5_);
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = _tmp6_;
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_content_height (_tmp7_, &_tmp8_);
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_.unit;
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_vala_assert (_tmp4_ == _tmp9_, "job.get_local_settings().get_content_width().unit ==             job.get_local_settings().get_content_height().unit");
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp7_);
#line 510 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp2_);
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = job;
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = print_job_get_local_settings (_tmp10_);
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _tmp11_;
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_content_width (_tmp12_, &_tmp13_);
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = _tmp13_;
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp12_);
#line 513 "/home/jens/Source/shotwell/src/Printing.vala"
	constrained_width = _tmp14_;
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = job;
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = print_job_get_local_settings (_tmp15_);
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _tmp16_;
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp18_ = print_settings_is_match_aspect_ratio_enabled (_tmp17_);
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp19_ = _tmp18_;
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp17_);
#line 514 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp19_) {
#line 3594 "Printing.c"
		PrintJob* _tmp20_ = NULL;
		PrintSettings* _tmp21_ = NULL;
		PrintSettings* _tmp22_ = NULL;
		Measurement _tmp23_ = {0};
		gdouble _tmp24_ = 0.0;
		PrintJob* _tmp25_ = NULL;
		gdouble _tmp26_ = 0.0;
		PrintJob* _tmp27_ = NULL;
		PrintSettings* _tmp28_ = NULL;
		PrintSettings* _tmp29_ = NULL;
		Measurement _tmp30_ = {0};
		MeasurementUnit _tmp31_ = 0;
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp20_ = job;
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp21_ = print_job_get_local_settings (_tmp20_);
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = _tmp21_;
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_get_content_height (_tmp22_, &_tmp23_);
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp24_ = _tmp23_.value;
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp25_ = job;
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = print_job_get_source_aspect_ratio (_tmp25_);
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp27_ = job;
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp28_ = print_job_get_local_settings (_tmp27_);
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = _tmp28_;
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		print_settings_get_content_height (_tmp29_, &_tmp30_);
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp31_ = _tmp30_.unit;
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&constrained_width, _tmp24_ * _tmp26_, _tmp31_);
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_print_settings_unref0 (_tmp29_);
#line 515 "/home/jens/Source/shotwell/src/Printing.vala"
		_print_settings_unref0 (_tmp22_);
#line 3637 "Printing.c"
	}
#line 517 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp32_ = constrained_width;
#line 517 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_width (self, &_tmp32_);
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp33_ = job;
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp34_ = print_job_get_local_settings (_tmp33_);
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp35_ = _tmp34_;
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_get_content_height (_tmp35_, &_tmp36_);
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_height (self, &_tmp36_);
#line 518 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp35_);
#line 519 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp37_ = job;
#line 519 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp38_ = print_job_get_local_settings (_tmp37_);
#line 519 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp39_ = _tmp38_;
#line 519 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp40_ = print_settings_get_content_layout (_tmp39_);
#line 519 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_layout (self, _tmp40_);
#line 519 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp39_);
#line 520 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp41_ = job;
#line 520 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp42_ = print_job_get_local_settings (_tmp41_);
#line 520 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp43_ = _tmp42_;
#line 520 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp44_ = print_settings_get_content_ppi (_tmp43_);
#line 520 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_ppi (self, _tmp44_);
#line 520 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp43_);
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp45_ = job;
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp46_ = print_job_get_local_settings (_tmp45_);
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp47_ = _tmp46_;
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp48_ = print_settings_get_image_per_page_selection (_tmp47_);
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_image_per_page_selection (self, _tmp48_);
#line 521 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp47_);
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp49_ = job;
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp50_ = print_job_get_local_settings (_tmp49_);
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp51_ = _tmp50_;
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp52_ = print_settings_get_size_selection (_tmp51_);
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_size_selection (self, _tmp52_);
#line 522 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp51_);
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp53_ = job;
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp54_ = print_job_get_local_settings (_tmp53_);
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp55_ = _tmp54_;
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp56_ = print_settings_is_match_aspect_ratio_enabled (_tmp55_);
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_match_aspect_ratio_enabled (self, _tmp56_);
#line 523 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp55_);
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp57_ = job;
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp58_ = print_job_get_local_settings (_tmp57_);
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp59_ = _tmp58_;
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp60_ = print_settings_is_print_titles_enabled (_tmp59_);
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_print_titles_enabled (self, _tmp60_);
#line 524 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp59_);
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp61_ = job;
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp62_ = print_job_get_local_settings (_tmp61_);
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp63_ = _tmp62_;
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp64_ = print_settings_get_print_titles_font (_tmp63_);
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp65_ = _tmp64_;
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_print_titles_font (self, _tmp65_);
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp65_);
#line 525 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp63_);
#line 3743 "Printing.c"
}


static void custom_print_tab_on_radio_group_click (CustomPrintTab* self, GtkButton* b) {
	GtkRadioButton* sender = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkRadioButton* _tmp1_ = NULL;
	GtkRadioButton* _tmp2_ = NULL;
	GtkRadioButton* _tmp3_ = NULL;
#line 528 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 528 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_BUTTON (b));
#line 529 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = b;
#line 529 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton));
#line 529 "/home/jens/Source/shotwell/src/Printing.vala"
	sender = _tmp1_;
#line 531 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = sender;
#line 531 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->standard_size_radio;
#line 531 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_ == _tmp3_) {
#line 3769 "Printing.c"
		GtkComboBoxText* _tmp4_ = NULL;
#line 532 "/home/jens/Source/shotwell/src/Printing.vala"
		custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_STANDARD_SIZE);
#line 533 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = self->priv->standard_sizes_combo;
#line 533 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
#line 3777 "Printing.c"
	} else {
		GtkRadioButton* _tmp5_ = NULL;
		GtkRadioButton* _tmp6_ = NULL;
#line 534 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = sender;
#line 534 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = self->priv->custom_size_radio;
#line 534 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp5_ == _tmp6_) {
#line 3787 "Printing.c"
			GtkEntry* _tmp7_ = NULL;
#line 535 "/home/jens/Source/shotwell/src/Printing.vala"
			custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_CUSTOM_SIZE);
#line 536 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp7_ = self->priv->custom_height_entry;
#line 536 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
#line 3795 "Printing.c"
		} else {
			GtkRadioButton* _tmp8_ = NULL;
			GtkRadioButton* _tmp9_ = NULL;
#line 537 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp8_ = sender;
#line 537 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp9_ = self->priv->image_per_page_radio;
#line 537 "/home/jens/Source/shotwell/src/Printing.vala"
			if (_tmp8_ == _tmp9_) {
#line 538 "/home/jens/Source/shotwell/src/Printing.vala"
				custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_IMAGE_PER_PAGE);
#line 3807 "Printing.c"
			}
		}
	}
#line 528 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (sender);
#line 3813 "Printing.c"
}


static void custom_print_tab_on_units_combo_changed (CustomPrintTab* self) {
	GtkEntry* _tmp0_ = NULL;
	Measurement _tmp1_ = {0};
	MeasurementUnit _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GtkEntry* _tmp5_ = NULL;
	Measurement _tmp6_ = {0};
	MeasurementUnit _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
#line 542 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->custom_height_entry;
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = self->priv->local_content_height;
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = custom_print_tab_get_user_unit_choice (self);
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_format_measurement_as (self, &_tmp1_, _tmp2_);
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_;
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp0_, _tmp4_);
#line 543 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp4_);
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = self->priv->custom_width_entry;
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = self->priv->local_content_width;
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = custom_print_tab_get_user_unit_choice (self);
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = custom_print_tab_format_measurement_as (self, &_tmp6_, _tmp7_);
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_;
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp5_, _tmp9_);
#line 545 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp9_);
#line 3858 "Printing.c"
}


static void custom_print_tab_set_content_layout_control_state (CustomPrintTab* self, ContentLayout layout) {
	ContentLayout _tmp0_ = 0;
#line 549 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = layout;
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (_tmp0_) {
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 3872 "Printing.c"
		{
			GtkComboBoxText* _tmp1_ = NULL;
			GtkComboBoxText* _tmp2_ = NULL;
			GtkEntry* _tmp3_ = NULL;
			GtkEntry* _tmp4_ = NULL;
			GtkCheckButton* _tmp5_ = NULL;
			GtkComboBoxText* _tmp6_ = NULL;
#line 552 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp1_ = self->priv->standard_sizes_combo;
#line 552 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 553 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp2_ = self->priv->units_combo;
#line 553 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 554 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp3_ = self->priv->custom_width_entry;
#line 554 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 555 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp4_ = self->priv->custom_height_entry;
#line 555 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 556 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp5_ = self->priv->aspect_ratio_check;
#line 556 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 557 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp6_ = self->priv->image_per_page_combo;
#line 557 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 558 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 3906 "Printing.c"
		}
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 3910 "Printing.c"
		{
			GtkComboBoxText* _tmp7_ = NULL;
			GtkComboBoxText* _tmp8_ = NULL;
			GtkEntry* _tmp9_ = NULL;
			GtkEntry* _tmp10_ = NULL;
			GtkCheckButton* _tmp11_ = NULL;
			GtkComboBoxText* _tmp12_ = NULL;
#line 561 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp7_ = self->priv->standard_sizes_combo;
#line 561 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 562 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp8_ = self->priv->units_combo;
#line 562 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 563 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp9_ = self->priv->custom_width_entry;
#line 563 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 564 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp10_ = self->priv->custom_height_entry;
#line 564 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 565 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp11_ = self->priv->aspect_ratio_check;
#line 565 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 566 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp12_ = self->priv->image_per_page_combo;
#line 566 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 567 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 3944 "Printing.c"
		}
#line 550 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 3948 "Printing.c"
		{
			GtkComboBoxText* _tmp13_ = NULL;
			GtkComboBoxText* _tmp14_ = NULL;
			GtkEntry* _tmp15_ = NULL;
			GtkEntry* _tmp16_ = NULL;
			GtkCheckButton* _tmp17_ = NULL;
			GtkComboBoxText* _tmp18_ = NULL;
#line 570 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp13_ = self->priv->standard_sizes_combo;
#line 570 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 571 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp14_ = self->priv->units_combo;
#line 571 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 572 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp15_ = self->priv->custom_width_entry;
#line 572 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 573 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp16_ = self->priv->custom_height_entry;
#line 573 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 574 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp17_ = self->priv->aspect_ratio_check;
#line 574 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 575 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp18_ = self->priv->image_per_page_combo;
#line 575 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 576 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 3982 "Printing.c"
		}
		default:
		{
#line 579 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:579: unknown ContentLayout enumeration value");
#line 3988 "Printing.c"
		}
	}
}


static gboolean custom_print_tab_standard_sizes_combo_separator_func (GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	GValue val = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GValue _tmp2_ = {0};
	const gchar* _tmp3_ = NULL;
#line 583 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (GTK_IS_TREE_MODEL (model), FALSE);
#line 583 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 586 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = model;
#line 586 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = *iter;
#line 586 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_tree_model_get_value (_tmp0_, &_tmp1_, 0, &_tmp2_);
#line 586 "/home/jens/Source/shotwell/src/Printing.vala"
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
#line 586 "/home/jens/Source/shotwell/src/Printing.vala"
	val = _tmp2_;
#line 588 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = g_value_get_string (&val);
#line 588 "/home/jens/Source/shotwell/src/Printing.vala"
	result = g_strcmp0 (_tmp3_, "-") == 0;
#line 588 "/home/jens/Source/shotwell/src/Printing.vala"
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
#line 588 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4023 "Printing.c"
}


static void custom_print_tab_set_content_layout (CustomPrintTab* self, ContentLayout content_layout) {
	ContentLayout _tmp0_ = 0;
	ContentLayout _tmp1_ = 0;
#line 591 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 592 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = content_layout;
#line 592 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_set_content_layout_control_state (self, _tmp0_);
#line 593 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = content_layout;
#line 593 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (_tmp1_) {
#line 593 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 4042 "Printing.c"
		{
			GtkRadioButton* _tmp2_ = NULL;
#line 595 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp2_ = self->priv->standard_size_radio;
#line 595 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 596 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4051 "Printing.c"
		}
#line 593 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 4055 "Printing.c"
		{
			GtkRadioButton* _tmp3_ = NULL;
#line 599 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp3_ = self->priv->custom_size_radio;
#line 599 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 600 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4064 "Printing.c"
		}
#line 593 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 4068 "Printing.c"
		{
			GtkRadioButton* _tmp4_ = NULL;
#line 603 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp4_ = self->priv->image_per_page_radio;
#line 603 "/home/jens/Source/shotwell/src/Printing.vala"
			gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
#line 604 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 4077 "Printing.c"
		}
		default:
		{
#line 607 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:607: unknown ContentLayout enumeration value");
#line 4083 "Printing.c"
		}
	}
}


static ContentLayout custom_print_tab_get_content_layout (CustomPrintTab* self) {
	ContentLayout result = 0;
	GtkRadioButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkRadioButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GtkRadioButton* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 611 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 612 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->standard_size_radio;
#line 612 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 612 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_) {
#line 613 "/home/jens/Source/shotwell/src/Printing.vala"
		result = CONTENT_LAYOUT_STANDARD_SIZE;
#line 613 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 4109 "Printing.c"
	}
#line 614 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->custom_size_radio;
#line 614 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 614 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp3_) {
#line 615 "/home/jens/Source/shotwell/src/Printing.vala"
		result = CONTENT_LAYOUT_CUSTOM_SIZE;
#line 615 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 4121 "Printing.c"
	}
#line 616 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = self->priv->image_per_page_radio;
#line 616 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 616 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp5_) {
#line 617 "/home/jens/Source/shotwell/src/Printing.vala"
		result = CONTENT_LAYOUT_IMAGE_PER_PAGE;
#line 617 "/home/jens/Source/shotwell/src/Printing.vala"
		return result;
#line 4133 "Printing.c"
	}
#line 619 "/home/jens/Source/shotwell/src/Printing.vala"
	g_error ("Printing.vala:619: inconsistent content layout radio button group stat" \
"e");
#line 4137 "Printing.c"
}


static void custom_print_tab_set_content_width (CustomPrintTab* self, Measurement* content_width) {
	Measurement _tmp0_ = {0};
	MeasurementUnit _tmp1_ = 0;
	Measurement _tmp2_ = {0};
	MeasurementUnit _tmp3_ = 0;
	Measurement _tmp13_ = {0};
	GtkEntry* _tmp14_ = NULL;
	Measurement _tmp15_ = {0};
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
#line 622 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 622 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (content_width != NULL);
#line 623 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *content_width;
#line 623 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_.unit;
#line 623 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->local_content_height;
#line 623 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_.unit;
#line 623 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ != _tmp3_) {
#line 4165 "Printing.c"
		Measurement _tmp4_ = {0};
		MeasurementUnit _tmp5_ = 0;
		Measurement _tmp6_ = {0};
		MeasurementUnit _tmp7_ = 0;
		Measurement _tmp8_ = {0};
		GtkEntry* _tmp9_ = NULL;
		Measurement _tmp10_ = {0};
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 624 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = *content_width;
#line 624 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = _tmp4_.unit;
#line 624 "/home/jens/Source/shotwell/src/Printing.vala"
		custom_print_tab_set_user_unit_choice (self, _tmp5_);
#line 625 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = *content_width;
#line 625 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp7_ = _tmp6_.unit;
#line 625 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (&self->priv->local_content_height, _tmp7_, &_tmp8_);
#line 625 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->local_content_height = _tmp8_;
#line 626 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp9_ = self->priv->custom_height_entry;
#line 626 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp10_ = self->priv->local_content_height;
#line 626 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp11_ = custom_print_tab_format_measurement (self, &_tmp10_);
#line 626 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp12_ = _tmp11_;
#line 626 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp9_, _tmp12_);
#line 626 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp12_);
#line 4201 "Printing.c"
	}
#line 628 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = *content_width;
#line 628 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_width = _tmp13_;
#line 629 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = self->priv->custom_width_entry;
#line 629 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = *content_width;
#line 629 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = custom_print_tab_format_measurement (self, &_tmp15_);
#line 629 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _tmp16_;
#line 629 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp14_, _tmp17_);
#line 629 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp17_);
#line 4219 "Printing.c"
}


static void custom_print_tab_get_content_width (CustomPrintTab* self, Measurement* result) {
	Measurement _tmp0_ = {0};
#line 632 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 633 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->local_content_width;
#line 633 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp0_;
#line 633 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 4233 "Printing.c"
}


static void custom_print_tab_set_content_height (CustomPrintTab* self, Measurement* content_height) {
	Measurement _tmp0_ = {0};
	MeasurementUnit _tmp1_ = 0;
	Measurement _tmp2_ = {0};
	MeasurementUnit _tmp3_ = 0;
	Measurement _tmp13_ = {0};
	GtkEntry* _tmp14_ = NULL;
	Measurement _tmp15_ = {0};
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
#line 636 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 636 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (content_height != NULL);
#line 637 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = *content_height;
#line 637 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_.unit;
#line 637 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->local_content_width;
#line 637 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_.unit;
#line 637 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp1_ != _tmp3_) {
#line 4261 "Printing.c"
		Measurement _tmp4_ = {0};
		MeasurementUnit _tmp5_ = 0;
		Measurement _tmp6_ = {0};
		MeasurementUnit _tmp7_ = 0;
		Measurement _tmp8_ = {0};
		GtkEntry* _tmp9_ = NULL;
		Measurement _tmp10_ = {0};
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 638 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = *content_height;
#line 638 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = _tmp4_.unit;
#line 638 "/home/jens/Source/shotwell/src/Printing.vala"
		custom_print_tab_set_user_unit_choice (self, _tmp5_);
#line 639 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = *content_height;
#line 639 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp7_ = _tmp6_.unit;
#line 639 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_convert_to (&self->priv->local_content_width, _tmp7_, &_tmp8_);
#line 639 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->local_content_width = _tmp8_;
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp9_ = self->priv->custom_width_entry;
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp10_ = self->priv->local_content_width;
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp11_ = custom_print_tab_format_measurement (self, &_tmp10_);
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp12_ = _tmp11_;
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_entry_set_text (_tmp9_, _tmp12_);
#line 640 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp12_);
#line 4297 "Printing.c"
	}
#line 642 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = *content_height;
#line 642 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_height = _tmp13_;
#line 643 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = self->priv->custom_height_entry;
#line 643 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = *content_height;
#line 643 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = custom_print_tab_format_measurement (self, &_tmp15_);
#line 643 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _tmp16_;
#line 643 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp14_, _tmp17_);
#line 643 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp17_);
#line 4315 "Printing.c"
}


static void custom_print_tab_get_content_height (CustomPrintTab* self, Measurement* result) {
	Measurement _tmp0_ = {0};
#line 646 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 647 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->local_content_height;
#line 647 "/home/jens/Source/shotwell/src/Printing.vala"
	*result = _tmp0_;
#line 647 "/home/jens/Source/shotwell/src/Printing.vala"
	return;
#line 4329 "Printing.c"
}


static void custom_print_tab_set_content_ppi (CustomPrintTab* self, gint content_ppi) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkEntry* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 650 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 651 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = content_ppi;
#line 651 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = CLAMP (_tmp0_, PRINT_SETTINGS_MIN_CONTENT_PPI, PRINT_SETTINGS_MAX_CONTENT_PPI);
#line 651 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->local_content_ppi = _tmp1_;
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->ppi_entry;
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->local_content_ppi;
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = g_strdup_printf ("%d", _tmp3_);
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = _tmp4_;
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_entry_set_text (_tmp2_, _tmp5_);
#line 654 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp5_);
#line 4360 "Printing.c"
}


static gint custom_print_tab_get_content_ppi (CustomPrintTab* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 657 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 658 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->local_content_ppi;
#line 658 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp0_;
#line 658 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4375 "Printing.c"
}


static void custom_print_tab_set_image_per_page_selection (CustomPrintTab* self, gint image_per_page) {
	GtkComboBoxText* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 661 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 662 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->image_per_page_combo;
#line 662 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = image_per_page;
#line 662 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox), _tmp1_);
#line 4390 "Printing.c"
}


static gint custom_print_tab_get_image_per_page_selection (CustomPrintTab* self) {
	gint result = 0;
	GtkComboBoxText* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 665 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 666 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->image_per_page_combo;
#line 666 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox));
#line 666 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 666 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4408 "Printing.c"
}


static void custom_print_tab_set_size_selection (CustomPrintTab* self, gint size_selection) {
	GtkComboBoxText* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 669 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 670 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->standard_sizes_combo;
#line 670 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = size_selection;
#line 670 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox), _tmp1_);
#line 4423 "Printing.c"
}


static gint custom_print_tab_get_size_selection (CustomPrintTab* self) {
	gint result = 0;
	GtkComboBoxText* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 673 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), 0);
#line 674 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->standard_sizes_combo;
#line 674 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox));
#line 674 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 674 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4441 "Printing.c"
}


static void custom_print_tab_set_match_aspect_ratio_enabled (CustomPrintTab* self, gboolean enable_state) {
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 677 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 678 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->aspect_ratio_check;
#line 678 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = enable_state;
#line 678 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp1_);
#line 4456 "Printing.c"
}


static void custom_print_tab_set_print_titles_enabled (CustomPrintTab* self, gboolean print_titles) {
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 681 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 682 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->title_print_check;
#line 682 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = print_titles;
#line 682 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp1_);
#line 4471 "Printing.c"
}


static void custom_print_tab_set_print_titles_font (CustomPrintTab* self, const gchar* fontname) {
	GtkFontButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 685 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_CUSTOM_PRINT_TAB (self));
#line 685 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (fontname != NULL);
#line 686 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->title_print_font;
#line 686 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = fontname;
#line 686 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_font_button_set_font_name (_tmp0_, _tmp1_);
#line 4488 "Printing.c"
}


static gboolean custom_print_tab_is_match_aspect_ratio_enabled (CustomPrintTab* self) {
	gboolean result = FALSE;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 690 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 691 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->aspect_ratio_check;
#line 691 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 691 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 691 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4506 "Printing.c"
}


static gboolean custom_print_tab_is_print_titles_enabled (CustomPrintTab* self) {
	gboolean result = FALSE;
	GtkCheckButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 694 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), FALSE);
#line 695 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->title_print_check;
#line 695 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 695 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 695 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4524 "Printing.c"
}


static gchar* custom_print_tab_get_print_titles_font (CustomPrintTab* self) {
	gchar* result = NULL;
	GtkFontButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 698 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 699 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->title_print_font;
#line 699 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_font_button_get_font_name (_tmp0_);
#line 699 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 699 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp2_;
#line 699 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4545 "Printing.c"
}


PrintJob* custom_print_tab_get_source_job (CustomPrintTab* self) {
	PrintJob* result = NULL;
	PrintJob* _tmp0_ = NULL;
	PrintJob* _tmp1_ = NULL;
#line 702 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 703 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->source_job;
#line 703 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 703 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 703 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4563 "Printing.c"
}


PrintSettings* custom_print_tab_get_local_settings (CustomPrintTab* self) {
	PrintSettings* result = NULL;
	PrintSettings* _result_ = NULL;
	PrintSettings* _tmp0_ = NULL;
	Measurement _tmp1_ = {0};
	Measurement _tmp2_ = {0};
	ContentLayout _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
#line 706 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_CUSTOM_PRINT_TAB (self), NULL);
#line 707 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_settings_new ();
#line 707 "/home/jens/Source/shotwell/src/Printing.vala"
	_result_ = _tmp0_;
#line 709 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_get_content_width (self, &_tmp1_);
#line 709 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_content_width (_result_, &_tmp1_);
#line 710 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_get_content_height (self, &_tmp2_);
#line 710 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_content_height (_result_, &_tmp2_);
#line 711 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = custom_print_tab_get_content_layout (self);
#line 711 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_content_layout (_result_, _tmp3_);
#line 712 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = custom_print_tab_get_content_ppi (self);
#line 712 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_content_ppi (_result_, _tmp4_);
#line 713 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = custom_print_tab_get_image_per_page_selection (self);
#line 713 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_image_per_page_selection (_result_, _tmp5_);
#line 714 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = custom_print_tab_get_size_selection (self);
#line 714 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_size_selection (_result_, _tmp6_);
#line 715 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = custom_print_tab_is_match_aspect_ratio_enabled (self);
#line 715 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_match_aspect_ratio_enabled (_result_, _tmp7_);
#line 716 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = custom_print_tab_is_print_titles_enabled (self);
#line 716 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_print_titles_enabled (_result_, _tmp8_);
#line 717 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = custom_print_tab_get_print_titles_font (self);
#line 717 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _tmp9_;
#line 717 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_set_print_titles_font (_result_, _tmp10_);
#line 717 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp10_);
#line 719 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _result_;
#line 719 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4631 "Printing.c"
}


static void custom_print_tab_class_init (CustomPrintTabClass * klass) {
	gint CustomPrintTab_private_offset;
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	custom_print_tab_parent_class = g_type_class_peek_parent (klass);
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	g_type_class_add_private (klass, sizeof (CustomPrintTabPrivate));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	G_OBJECT_CLASS (klass)->finalize = custom_print_tab_finalize;
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	CustomPrintTab_private_offset = g_type_class_get_instance_private_offset (klass);
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Shotwell/ui/printing_widget.ui");
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "standard_size_radio", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, standard_size_radio));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_size_radio", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, custom_size_radio));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_per_page_radio", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, image_per_page_radio));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_per_page_combo", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, image_per_page_combo));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "standard_sizes_combo", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, standard_sizes_combo));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "units_combo", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, units_combo));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_width_entry", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, custom_width_entry));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_height_entry", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, custom_height_entry));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "ppi_entry", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, ppi_entry));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "aspect_ratio_check", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, aspect_ratio_check));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_print_check", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, title_print_check));
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_print_font", FALSE, CustomPrintTab_private_offset + G_STRUCT_OFFSET (CustomPrintTabPrivate, title_print_font));
#line 4671 "Printing.c"
}


static void custom_print_tab_instance_init (CustomPrintTab * self) {
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv = CUSTOM_PRINT_TAB_GET_PRIVATE (self);
#line 298 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&self->priv->local_content_width, 5.0, MEASUREMENT_UNIT_INCHES);
#line 299 "/home/jens/Source/shotwell/src/Printing.vala"
	measurement_init (&self->priv->local_content_height, 5.0, MEASUREMENT_UNIT_INCHES);
#line 301 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->is_text_insertion_in_progress = FALSE;
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 4686 "Printing.c"
}


static void custom_print_tab_finalize (GObject* obj) {
	CustomPrintTab * self;
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CUSTOM_PRINT_TAB, CustomPrintTab);
#line 274 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->standard_size_radio);
#line 276 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_size_radio);
#line 278 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->image_per_page_radio);
#line 280 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->image_per_page_combo);
#line 282 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->standard_sizes_combo);
#line 284 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->units_combo);
#line 286 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_width_entry);
#line 288 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_height_entry);
#line 290 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->ppi_entry);
#line 292 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->aspect_ratio_check);
#line 294 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->title_print_check);
#line 296 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->title_print_font);
#line 302 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->source_job);
#line 269 "/home/jens/Source/shotwell/src/Printing.vala"
	G_OBJECT_CLASS (custom_print_tab_parent_class)->finalize (obj);
#line 4722 "Printing.c"
}


GType custom_print_tab_get_type (void) {
	static volatile gsize custom_print_tab_type_id__volatile = 0;
	if (g_once_init_enter (&custom_print_tab_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CustomPrintTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) custom_print_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CustomPrintTab), 0, (GInstanceInitFunc) custom_print_tab_instance_init, NULL };
		GType custom_print_tab_type_id;
		custom_print_tab_type_id = g_type_register_static (gtk_box_get_type (), "CustomPrintTab", &g_define_type_info, 0);
		g_once_init_leave (&custom_print_tab_type_id__volatile, custom_print_tab_type_id);
	}
	return custom_print_tab_type_id__volatile;
}


PrintJob* print_job_construct (GType object_type, GeeCollection* to_print) {
	PrintJob * self = NULL;
	PrintManager* _tmp0_ = NULL;
	PrintManager* _tmp1_ = NULL;
	PrintSettings* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeCollection* _tmp4_ = NULL;
	gdouble photo_aspect_ratio = 0.0;
	GeeArrayList* _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	Photo* _tmp7_ = NULL;
	Dimensions _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
#line 727 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (to_print), NULL);
#line 727 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (PrintJob*) g_object_new (object_type, NULL);
#line 728 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_manager_get_instance ();
#line 728 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _tmp0_;
#line 728 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = print_manager_get_global_settings (_tmp1_);
#line 728 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 728 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->settings = _tmp2_;
#line 728 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_manager_unref0 (_tmp1_);
#line 729 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->photos;
#line 729 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = to_print;
#line 729 "/home/jens/Source/shotwell/src/Printing.vala"
	gee_array_list_add_all (_tmp3_, _tmp4_);
#line 731 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_embed_page_setup (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_print_operation_get_type (), GtkPrintOperation), TRUE);
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = self->priv->photos;
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = (Photo*) _tmp6_;
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp8_);
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = dimensions_get_aspect_ratio (&_tmp8_);
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _tmp9_;
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp7_);
#line 732 "/home/jens/Source/shotwell/src/Printing.vala"
	photo_aspect_ratio = _tmp10_;
#line 733 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = photo_aspect_ratio;
#line 733 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp11_ < 1.0) {
#line 4797 "Printing.c"
		gdouble _tmp12_ = 0.0;
#line 734 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp12_ = photo_aspect_ratio;
#line 734 "/home/jens/Source/shotwell/src/Printing.vala"
		photo_aspect_ratio = 1.0 / _tmp12_;
#line 4803 "Printing.c"
	}
#line 727 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 4807 "Printing.c"
}


PrintJob* print_job_new (GeeCollection* to_print) {
#line 727 "/home/jens/Source/shotwell/src/Printing.vala"
	return print_job_construct (TYPE_PRINT_JOB, to_print);
#line 4814 "Printing.c"
}


GeeList* print_job_get_photos (PrintJob* self) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
#line 737 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (self), NULL);
#line 738 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->photos;
#line 738 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList));
#line 738 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 738 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4832 "Printing.c"
}


Photo* print_job_get_source_photo (PrintJob* self) {
	Photo* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
#line 741 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (self), NULL);
#line 742 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->photos;
#line 742 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 742 "/home/jens/Source/shotwell/src/Printing.vala"
	result = (Photo*) _tmp1_;
#line 742 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4850 "Printing.c"
}


gdouble print_job_get_source_aspect_ratio (PrintJob* self) {
	gdouble result = 0.0;
	gdouble aspect_ratio = 0.0;
	GeeArrayList* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	Photo* _tmp2_ = NULL;
	Dimensions _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
#line 745 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (self), 0.0);
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->photos;
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = (Photo*) _tmp1_;
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp3_);
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = dimensions_get_aspect_ratio (&_tmp3_);
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = _tmp4_;
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp2_);
#line 746 "/home/jens/Source/shotwell/src/Printing.vala"
	aspect_ratio = _tmp5_;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = aspect_ratio;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp7_ < 1.0) {
#line 4887 "Printing.c"
		gdouble _tmp8_ = 0.0;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp8_ = aspect_ratio;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = 1.0 / _tmp8_;
#line 4893 "Printing.c"
	} else {
		gdouble _tmp9_ = 0.0;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp9_ = aspect_ratio;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = _tmp9_;
#line 4900 "Printing.c"
	}
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp6_;
#line 747 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4906 "Printing.c"
}


static gpointer _print_settings_ref0 (gpointer self) {
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? print_settings_ref (self) : NULL;
#line 4913 "Printing.c"
}


PrintSettings* print_job_get_local_settings (PrintJob* self) {
	PrintSettings* result = NULL;
	PrintSettings* _tmp0_ = NULL;
	PrintSettings* _tmp1_ = NULL;
#line 750 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_JOB (self), NULL);
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->settings;
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _print_settings_ref0 (_tmp0_);
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 751 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 4931 "Printing.c"
}


void print_job_set_local_settings (PrintJob* self, PrintSettings* settings) {
	PrintSettings* _tmp0_ = NULL;
	PrintSettings* _tmp1_ = NULL;
#line 754 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_JOB (self));
#line 754 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (settings));
#line 755 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = settings;
#line 755 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _print_settings_ref0 (_tmp0_);
#line 755 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 755 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->settings = _tmp1_;
#line 4950 "Printing.c"
}


static void print_job_class_init (PrintJobClass * klass) {
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	print_job_parent_class = g_type_class_peek_parent (klass);
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	g_type_class_add_private (klass, sizeof (PrintJobPrivate));
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	G_OBJECT_CLASS (klass)->finalize = print_job_finalize;
#line 4961 "Printing.c"
}


static void print_job_instance_init (PrintJob * self) {
	GeeArrayList* _tmp0_ = NULL;
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv = PRINT_JOB_GET_PRIVATE (self);
#line 725 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = gee_array_list_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 725 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->photos = _tmp0_;
#line 4973 "Printing.c"
}


static void print_job_finalize (GObject* obj) {
	PrintJob * self;
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_JOB, PrintJob);
#line 724 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 725 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->photos);
#line 723 "/home/jens/Source/shotwell/src/Printing.vala"
	G_OBJECT_CLASS (print_job_parent_class)->finalize (obj);
#line 4987 "Printing.c"
}


GType print_job_get_type (void) {
	static volatile gsize print_job_type_id__volatile = 0;
	if (g_once_init_enter (&print_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PrintJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintJob), 0, (GInstanceInitFunc) print_job_instance_init, NULL };
		GType print_job_type_id;
		print_job_type_id = g_type_register_static (gtk_print_operation_get_type (), "PrintJob", &g_define_type_info, 0);
		g_once_init_leave (&print_job_type_id__volatile, print_job_type_id);
	}
	return print_job_type_id__volatile;
}


StandardPrintSize* standard_print_size_construct (GType object_type, const gchar* name, Measurement* width, Measurement* height) {
	StandardPrintSize* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Measurement _tmp2_ = {0};
	Measurement _tmp3_ = {0};
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (width != NULL, NULL);
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (height != NULL, NULL);
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (StandardPrintSize*) g_type_create_instance (object_type);
#line 761 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = name;
#line 761 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 761 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->name);
#line 761 "/home/jens/Source/shotwell/src/Printing.vala"
	self->name = _tmp1_;
#line 762 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = *width;
#line 762 "/home/jens/Source/shotwell/src/Printing.vala"
	self->width = _tmp2_;
#line 763 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = *height;
#line 763 "/home/jens/Source/shotwell/src/Printing.vala"
	self->height = _tmp3_;
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 5035 "Printing.c"
}


StandardPrintSize* standard_print_size_new (const gchar* name, Measurement* width, Measurement* height) {
#line 760 "/home/jens/Source/shotwell/src/Printing.vala"
	return standard_print_size_construct (TYPE_STANDARD_PRINT_SIZE, name, width, height);
#line 5042 "Printing.c"
}


static void value_standard_print_size_init (GValue* value) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	value->data[0].v_pointer = NULL;
#line 5049 "Printing.c"
}


static void value_standard_print_size_free_value (GValue* value) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (value->data[0].v_pointer) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		standard_print_size_unref (value->data[0].v_pointer);
#line 5058 "Printing.c"
	}
}


static void value_standard_print_size_copy_value (const GValue* src_value, GValue* dest_value) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (src_value->data[0].v_pointer) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = standard_print_size_ref (src_value->data[0].v_pointer);
#line 5068 "Printing.c"
	} else {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5072 "Printing.c"
	}
}


static gpointer value_standard_print_size_peek_pointer (const GValue* value) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 5080 "Printing.c"
}


static gchar* value_standard_print_size_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (collect_values[0].v_pointer) {
#line 5087 "Printing.c"
		StandardPrintSize* object;
		object = collect_values[0].v_pointer;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		if (object->parent_instance.g_class == NULL) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5094 "Printing.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5098 "Printing.c"
		}
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = standard_print_size_ref (object);
#line 5102 "Printing.c"
	} else {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 5106 "Printing.c"
	}
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 5110 "Printing.c"
}


static gchar* value_standard_print_size_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	StandardPrintSize** object_p;
	object_p = collect_values[0].v_pointer;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!object_p) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5121 "Printing.c"
	}
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!value->data[0].v_pointer) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = NULL;
#line 5127 "Printing.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = value->data[0].v_pointer;
#line 5131 "Printing.c"
	} else {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = standard_print_size_ref (value->data[0].v_pointer);
#line 5135 "Printing.c"
	}
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 5139 "Printing.c"
}


GParamSpec* param_spec_standard_print_size (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecStandardPrintSize* spec;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_STANDARD_PRINT_SIZE), NULL);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	return G_PARAM_SPEC (spec);
#line 5153 "Printing.c"
}


gpointer value_get_standard_print_size (const GValue* value) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE), NULL);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 5162 "Printing.c"
}


void value_set_standard_print_size (GValue* value, gpointer v_object) {
	StandardPrintSize* old;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE));
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STANDARD_PRINT_SIZE));
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		standard_print_size_ref (value->data[0].v_pointer);
#line 5182 "Printing.c"
	} else {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 5186 "Printing.c"
	}
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		standard_print_size_unref (old);
#line 5192 "Printing.c"
	}
}


void value_take_standard_print_size (GValue* value, gpointer v_object) {
	StandardPrintSize* old;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE));
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STANDARD_PRINT_SIZE));
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 5211 "Printing.c"
	} else {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 5215 "Printing.c"
	}
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		standard_print_size_unref (old);
#line 5221 "Printing.c"
	}
}


static void standard_print_size_class_init (StandardPrintSizeClass * klass) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	standard_print_size_parent_class = g_type_class_peek_parent (klass);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	((StandardPrintSizeClass *) klass)->finalize = standard_print_size_finalize;
#line 5231 "Printing.c"
}


static void standard_print_size_instance_init (StandardPrintSize * self) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	self->ref_count = 1;
#line 5238 "Printing.c"
}


static void standard_print_size_finalize (StandardPrintSize* obj) {
	StandardPrintSize * self;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STANDARD_PRINT_SIZE, StandardPrintSize);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_handlers_destroy (self);
#line 766 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (self->name);
#line 5250 "Printing.c"
}


GType standard_print_size_get_type (void) {
	static volatile gsize standard_print_size_type_id__volatile = 0;
	if (g_once_init_enter (&standard_print_size_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_standard_print_size_init, value_standard_print_size_free_value, value_standard_print_size_copy_value, value_standard_print_size_peek_pointer, "p", value_standard_print_size_collect_value, "p", value_standard_print_size_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (StandardPrintSizeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) standard_print_size_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StandardPrintSize), 0, (GInstanceInitFunc) standard_print_size_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType standard_print_size_type_id;
		standard_print_size_type_id = g_type_register_fundamental (g_type_fundamental_next (), "StandardPrintSize", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&standard_print_size_type_id__volatile, standard_print_size_type_id);
	}
	return standard_print_size_type_id__volatile;
}


gpointer standard_print_size_ref (gpointer instance) {
	StandardPrintSize* self;
	self = instance;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	g_atomic_int_inc (&self->ref_count);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	return instance;
#line 5275 "Printing.c"
}


void standard_print_size_unref (gpointer instance) {
	StandardPrintSize* self;
	self = instance;
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		STANDARD_PRINT_SIZE_GET_CLASS (self)->finalize (self);
#line 759 "/home/jens/Source/shotwell/src/Printing.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5288 "Printing.c"
	}
}


static PrintManager* print_manager_construct (GType object_type) {
	PrintManager* self = NULL;
	GtkPageSetup* _tmp0_ = NULL;
	PrintSettings* _tmp1_ = NULL;
#line 783 "/home/jens/Source/shotwell/src/Printing.vala"
	self = (PrintManager*) g_type_create_instance (object_type);
#line 784 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = gtk_page_setup_new ();
#line 784 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->user_page_setup);
#line 784 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->user_page_setup = _tmp0_;
#line 785 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = print_settings_new ();
#line 785 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 785 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->settings = _tmp1_;
#line 783 "/home/jens/Source/shotwell/src/Printing.vala"
	return self;
#line 5313 "Printing.c"
}


static PrintManager* print_manager_new (void) {
#line 783 "/home/jens/Source/shotwell/src/Printing.vala"
	return print_manager_construct (TYPE_PRINT_MANAGER);
#line 5320 "Printing.c"
}


static void _vala_array_add112 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5331 "Printing.c"
	}
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5337 "Printing.c"
}


static void _vala_array_add113 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5348 "Printing.c"
	}
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5354 "Printing.c"
}


static void _vala_array_add114 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5365 "Printing.c"
	}
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5371 "Printing.c"
}


static void _vala_array_add115 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5382 "Printing.c"
	}
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5388 "Printing.c"
}


static void _vala_array_add116 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5399 "Printing.c"
	}
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5405 "Printing.c"
}


static void _vala_array_add117 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5416 "Printing.c"
	}
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5422 "Printing.c"
}


static void _vala_array_add118 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5433 "Printing.c"
	}
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5439 "Printing.c"
}


static void _vala_array_add119 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5450 "Printing.c"
	}
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5456 "Printing.c"
}


static void _vala_array_add120 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5467 "Printing.c"
	}
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5473 "Printing.c"
}


static void _vala_array_add121 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5484 "Printing.c"
	}
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5490 "Printing.c"
}


static void _vala_array_add122 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5501 "Printing.c"
	}
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5507 "Printing.c"
}


static void _vala_array_add123 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5518 "Printing.c"
	}
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5524 "Printing.c"
}


static void _vala_array_add124 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5535 "Printing.c"
	}
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5541 "Printing.c"
}


static void _vala_array_add125 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5552 "Printing.c"
	}
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5558 "Printing.c"
}


static void _vala_array_add126 (StandardPrintSize*** array, int* length, int* size, StandardPrintSize* value) {
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
	if ((*length) == (*size)) {
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
#line 5569 "Printing.c"
	}
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[(*length)++] = value;
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
	(*array)[*length] = NULL;
#line 5575 "Printing.c"
}


StandardPrintSize** print_manager_get_standard_sizes (PrintManager* self, int* result_length1) {
	StandardPrintSize** result = NULL;
	StandardPrintSize** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	StandardPrintSize** _tmp76_ = NULL;
	gint _tmp76__length1 = 0;
	StandardPrintSize** _tmp77_ = NULL;
	gint _tmp77__length1 = 0;
#line 788 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_MANAGER (self), NULL);
#line 789 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->standard_sizes;
#line 789 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0__length1 = self->priv->standard_sizes_length1;
#line 789 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp0_ == NULL) {
#line 5595 "Printing.c"
		StandardPrintSize** _tmp1_ = NULL;
		StandardPrintSize** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		const gchar* _tmp3_ = NULL;
		Measurement _tmp4_ = {0};
		Measurement _tmp5_ = {0};
		StandardPrintSize* _tmp6_ = NULL;
		StandardPrintSize** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
		Measurement _tmp9_ = {0};
		Measurement _tmp10_ = {0};
		StandardPrintSize* _tmp11_ = NULL;
		StandardPrintSize** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		const gchar* _tmp13_ = NULL;
		Measurement _tmp14_ = {0};
		Measurement _tmp15_ = {0};
		StandardPrintSize* _tmp16_ = NULL;
		StandardPrintSize** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		const gchar* _tmp18_ = NULL;
		Measurement _tmp19_ = {0};
		Measurement _tmp20_ = {0};
		StandardPrintSize* _tmp21_ = NULL;
		StandardPrintSize** _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
		const gchar* _tmp23_ = NULL;
		Measurement _tmp24_ = {0};
		Measurement _tmp25_ = {0};
		StandardPrintSize* _tmp26_ = NULL;
		StandardPrintSize** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		const gchar* _tmp28_ = NULL;
		Measurement _tmp29_ = {0};
		Measurement _tmp30_ = {0};
		StandardPrintSize* _tmp31_ = NULL;
		StandardPrintSize** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		const gchar* _tmp33_ = NULL;
		Measurement _tmp34_ = {0};
		Measurement _tmp35_ = {0};
		StandardPrintSize* _tmp36_ = NULL;
		StandardPrintSize** _tmp37_ = NULL;
		gint _tmp37__length1 = 0;
		Measurement _tmp38_ = {0};
		Measurement _tmp39_ = {0};
		StandardPrintSize* _tmp40_ = NULL;
		StandardPrintSize** _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		const gchar* _tmp42_ = NULL;
		Measurement _tmp43_ = {0};
		Measurement _tmp44_ = {0};
		StandardPrintSize* _tmp45_ = NULL;
		StandardPrintSize** _tmp46_ = NULL;
		gint _tmp46__length1 = 0;
		const gchar* _tmp47_ = NULL;
		Measurement _tmp48_ = {0};
		Measurement _tmp49_ = {0};
		StandardPrintSize* _tmp50_ = NULL;
		StandardPrintSize** _tmp51_ = NULL;
		gint _tmp51__length1 = 0;
		const gchar* _tmp52_ = NULL;
		Measurement _tmp53_ = {0};
		Measurement _tmp54_ = {0};
		StandardPrintSize* _tmp55_ = NULL;
		StandardPrintSize** _tmp56_ = NULL;
		gint _tmp56__length1 = 0;
		const gchar* _tmp57_ = NULL;
		Measurement _tmp58_ = {0};
		Measurement _tmp59_ = {0};
		StandardPrintSize* _tmp60_ = NULL;
		StandardPrintSize** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		const gchar* _tmp62_ = NULL;
		Measurement _tmp63_ = {0};
		Measurement _tmp64_ = {0};
		StandardPrintSize* _tmp65_ = NULL;
		StandardPrintSize** _tmp66_ = NULL;
		gint _tmp66__length1 = 0;
		const gchar* _tmp67_ = NULL;
		Measurement _tmp68_ = {0};
		Measurement _tmp69_ = {0};
		StandardPrintSize* _tmp70_ = NULL;
		StandardPrintSize** _tmp71_ = NULL;
		gint _tmp71__length1 = 0;
		const gchar* _tmp72_ = NULL;
		Measurement _tmp73_ = {0};
		Measurement _tmp74_ = {0};
		StandardPrintSize* _tmp75_ = NULL;
#line 790 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp1_ = g_new0 (StandardPrintSize*, 0 + 1);
#line 790 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->standard_sizes = (_vala_array_free (self->priv->standard_sizes, self->priv->standard_sizes_length1, (GDestroyNotify) standard_print_size_unref), NULL);
#line 790 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->standard_sizes = _tmp1_;
#line 790 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->standard_sizes_length1 = 0;
#line 790 "/home/jens/Source/shotwell/src/Printing.vala"
		self->priv->_standard_sizes_size_ = self->priv->standard_sizes_length1;
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = self->priv->standard_sizes;
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2__length1 = self->priv->standard_sizes_length1;
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = _ ("Wallet (2 × 3 in.)");
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp4_, (gdouble) 3, MEASUREMENT_UNIT_INCHES);
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp5_, (gdouble) 2, MEASUREMENT_UNIT_INCHES);
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = standard_print_size_new (_tmp3_, &_tmp4_, &_tmp5_);
#line 792 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add112 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp6_);
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp7_ = self->priv->standard_sizes;
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp7__length1 = self->priv->standard_sizes_length1;
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp8_ = _ ("Notecard (3 × 5 in.)");
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp9_, (gdouble) 5, MEASUREMENT_UNIT_INCHES);
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp10_, (gdouble) 3, MEASUREMENT_UNIT_INCHES);
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp11_ = standard_print_size_new (_tmp8_, &_tmp9_, &_tmp10_);
#line 795 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add113 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp11_);
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp12_ = self->priv->standard_sizes;
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp12__length1 = self->priv->standard_sizes_length1;
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp13_ = _ ("4 × 6 in.");
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp14_, (gdouble) 6, MEASUREMENT_UNIT_INCHES);
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp15_, (gdouble) 4, MEASUREMENT_UNIT_INCHES);
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp16_ = standard_print_size_new (_tmp13_, &_tmp14_, &_tmp15_);
#line 798 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add114 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp16_);
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp17_ = self->priv->standard_sizes;
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp17__length1 = self->priv->standard_sizes_length1;
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = _ ("5 × 7 in.");
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp19_, (gdouble) 7, MEASUREMENT_UNIT_INCHES);
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp20_, (gdouble) 5, MEASUREMENT_UNIT_INCHES);
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp21_ = standard_print_size_new (_tmp18_, &_tmp19_, &_tmp20_);
#line 801 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add115 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp21_);
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = self->priv->standard_sizes;
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22__length1 = self->priv->standard_sizes_length1;
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp23_ = _ ("8 × 10 in.");
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp24_, (gdouble) 10, MEASUREMENT_UNIT_INCHES);
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp25_, (gdouble) 8, MEASUREMENT_UNIT_INCHES);
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = standard_print_size_new (_tmp23_, &_tmp24_, &_tmp25_);
#line 804 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add116 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp26_);
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp27_ = self->priv->standard_sizes;
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp27__length1 = self->priv->standard_sizes_length1;
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp28_ = _ ("11 × 14 in.");
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp29_, (gdouble) 14, MEASUREMENT_UNIT_INCHES);
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp30_, (gdouble) 11, MEASUREMENT_UNIT_INCHES);
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp31_ = standard_print_size_new (_tmp28_, &_tmp29_, &_tmp30_);
#line 807 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add117 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp31_);
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp32_ = self->priv->standard_sizes;
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp32__length1 = self->priv->standard_sizes_length1;
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp33_ = _ ("16 × 20 in.");
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp34_, (gdouble) 20, MEASUREMENT_UNIT_INCHES);
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp35_, (gdouble) 16, MEASUREMENT_UNIT_INCHES);
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp36_ = standard_print_size_new (_tmp33_, &_tmp34_, &_tmp35_);
#line 810 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add118 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp36_);
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp37_ = self->priv->standard_sizes;
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp37__length1 = self->priv->standard_sizes_length1;
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp38_, (gdouble) 0, MEASUREMENT_UNIT_INCHES);
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp39_, (gdouble) 0, MEASUREMENT_UNIT_INCHES);
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp40_ = standard_print_size_new ("-", &_tmp38_, &_tmp39_);
#line 813 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add119 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp40_);
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp41_ = self->priv->standard_sizes;
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp41__length1 = self->priv->standard_sizes_length1;
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp42_ = _ ("Metric Wallet (9 × 13 cm)");
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp43_, (gdouble) 13, MEASUREMENT_UNIT_CENTIMETERS);
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp44_, (gdouble) 9, MEASUREMENT_UNIT_CENTIMETERS);
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp45_ = standard_print_size_new (_tmp42_, &_tmp43_, &_tmp44_);
#line 816 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add120 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp45_);
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp46_ = self->priv->standard_sizes;
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp46__length1 = self->priv->standard_sizes_length1;
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp47_ = _ ("Postcard (10 × 15 cm)");
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp48_, (gdouble) 15, MEASUREMENT_UNIT_CENTIMETERS);
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp49_, (gdouble) 10, MEASUREMENT_UNIT_CENTIMETERS);
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp50_ = standard_print_size_new (_tmp47_, &_tmp48_, &_tmp49_);
#line 819 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add121 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp50_);
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp51_ = self->priv->standard_sizes;
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp51__length1 = self->priv->standard_sizes_length1;
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp52_ = _ ("13 × 18 cm");
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp53_, (gdouble) 18, MEASUREMENT_UNIT_CENTIMETERS);
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp54_, (gdouble) 13, MEASUREMENT_UNIT_CENTIMETERS);
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp55_ = standard_print_size_new (_tmp52_, &_tmp53_, &_tmp54_);
#line 822 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add122 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp55_);
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp56_ = self->priv->standard_sizes;
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp56__length1 = self->priv->standard_sizes_length1;
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp57_ = _ ("18 × 24 cm");
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp58_, (gdouble) 24, MEASUREMENT_UNIT_CENTIMETERS);
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp59_, (gdouble) 18, MEASUREMENT_UNIT_CENTIMETERS);
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp60_ = standard_print_size_new (_tmp57_, &_tmp58_, &_tmp59_);
#line 825 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add123 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp60_);
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp61_ = self->priv->standard_sizes;
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp61__length1 = self->priv->standard_sizes_length1;
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp62_ = _ ("20 × 30 cm");
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp63_, (gdouble) 30, MEASUREMENT_UNIT_CENTIMETERS);
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp64_, (gdouble) 20, MEASUREMENT_UNIT_CENTIMETERS);
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp65_ = standard_print_size_new (_tmp62_, &_tmp63_, &_tmp64_);
#line 828 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add124 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp65_);
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp66_ = self->priv->standard_sizes;
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp66__length1 = self->priv->standard_sizes_length1;
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp67_ = _ ("24 × 40 cm");
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp68_, (gdouble) 40, MEASUREMENT_UNIT_CENTIMETERS);
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp69_, (gdouble) 24, MEASUREMENT_UNIT_CENTIMETERS);
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp70_ = standard_print_size_new (_tmp67_, &_tmp68_, &_tmp69_);
#line 831 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add125 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp70_);
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp71_ = self->priv->standard_sizes;
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp71__length1 = self->priv->standard_sizes_length1;
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp72_ = _ ("30 × 40 cm");
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp73_, (gdouble) 40, MEASUREMENT_UNIT_CENTIMETERS);
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		measurement_init (&_tmp74_, (gdouble) 30, MEASUREMENT_UNIT_CENTIMETERS);
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp75_ = standard_print_size_new (_tmp72_, &_tmp73_, &_tmp74_);
#line 834 "/home/jens/Source/shotwell/src/Printing.vala"
		_vala_array_add126 (&self->priv->standard_sizes, &self->priv->standard_sizes_length1, &self->priv->_standard_sizes_size_, _tmp75_);
#line 5904 "Printing.c"
	}
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp76_ = self->priv->standard_sizes;
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp76__length1 = self->priv->standard_sizes_length1;
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp77_ = _tmp76_;
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp77__length1 = _tmp76__length1;
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	if (result_length1) {
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
		*result_length1 = _tmp77__length1;
#line 5918 "Printing.c"
	}
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp77_;
#line 839 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 5924 "Printing.c"
}


static gpointer _print_manager_ref0 (gpointer self) {
#line 846 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? print_manager_ref (self) : NULL;
#line 5931 "Printing.c"
}


PrintManager* print_manager_get_instance (void) {
	PrintManager* result = NULL;
	PrintManager* _tmp0_ = NULL;
	PrintManager* _tmp2_ = NULL;
	PrintManager* _tmp3_ = NULL;
#line 843 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = print_manager_instance;
#line 843 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp0_ == NULL) {
#line 5944 "Printing.c"
		PrintManager* _tmp1_ = NULL;
#line 844 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp1_ = print_manager_new ();
#line 844 "/home/jens/Source/shotwell/src/Printing.vala"
		_print_manager_unref0 (print_manager_instance);
#line 844 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_instance = _tmp1_;
#line 5952 "Printing.c"
	}
#line 846 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = print_manager_instance;
#line 846 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _print_manager_ref0 (_tmp2_);
#line 846 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp3_;
#line 846 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 5962 "Printing.c"
}


static void _print_manager_on_begin_print_gtk_print_operation_begin_print (GtkPrintOperation* _sender, GtkPrintContext* context, gpointer self) {
#line 856 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_on_begin_print ((PrintManager*) self, _sender, context);
#line 5969 "Printing.c"
}


static void _print_manager_on_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_on_draw_page ((PrintManager*) self, _sender, context, page_nr);
#line 5976 "Printing.c"
}


static GObject* _print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget (GtkPrintOperation* _sender, gpointer self) {
	GObject* result;
	result = print_manager_on_create_custom_widget ((PrintManager*) self, _sender);
#line 858 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 5985 "Printing.c"
}


static void _print_manager_on_status_changed_gtk_print_operation_status_changed (GtkPrintOperation* _sender, gpointer self) {
#line 859 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_on_status_changed ((PrintManager*) self, _sender);
#line 5992 "Printing.c"
}


void print_manager_spool_photo (PrintManager* self, GeeCollection* to_print) {
	PrintJob* job = NULL;
	GeeCollection* _tmp0_ = NULL;
	PrintJob* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	Photo* _tmp3_ = NULL;
	Photo* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GtkPageSetup* _tmp7_ = NULL;
	AppWindow* _tmp8_ = NULL;
	AppWindow* _tmp9_ = NULL;
	GCancellable* _tmp10_ = NULL;
	AppWindow* _tmp11_ = NULL;
	AppWindow* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GCancellable* _tmp14_ = NULL;
	ProgressDialog* _tmp15_ = NULL;
	gchar* err_msg = NULL;
	ProgressDialog* _tmp25_ = NULL;
	AppWindow* _tmp26_ = NULL;
	AppWindow* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
#line 849 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 849 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GEE_IS_COLLECTION (to_print));
#line 850 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = to_print;
#line 850 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = print_job_new (_tmp0_);
#line 850 "/home/jens/Source/shotwell/src/Printing.vala"
	job = _tmp1_;
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _ ("Image Settings");
#line 851 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_custom_tab_label (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), _tmp2_);
#line 852 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_unit (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), GTK_UNIT_INCH);
#line 853 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_n_pages (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), 1);
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = print_job_get_source_photo (job);
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = _tmp3_;
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject));
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = _tmp5_;
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_job_name (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), _tmp6_);
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp6_);
#line 854 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp4_);
#line 855 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = self->priv->user_page_setup;
#line 855 "/home/jens/Source/shotwell/src/Printing.vala"
	gtk_print_operation_set_default_page_setup (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), _tmp7_);
#line 856 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "begin-print", (GCallback) _print_manager_on_begin_print_gtk_print_operation_begin_print, self);
#line 857 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "draw-page", (GCallback) _print_manager_on_draw_page_gtk_print_operation_draw_page, self);
#line 858 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "create-custom-widget", (GCallback) _print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget, self);
#line 859 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), "status-changed", (GCallback) _print_manager_on_status_changed_gtk_print_operation_status_changed, self);
#line 861 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = app_window_get_instance ();
#line 861 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _tmp8_;
#line 861 "/home/jens/Source/shotwell/src/Printing.vala"
	page_window_set_busy_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_PAGE_WINDOW, PageWindow));
#line 861 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp9_);
#line 863 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = g_cancellable_new ();
#line 863 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 863 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->cancellable = _tmp10_;
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = app_window_get_instance ();
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _tmp11_;
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = _ ("Printing…");
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = self->priv->cancellable;
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = progress_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_window_get_type (), GtkWindow), _tmp13_, _tmp14_);
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	g_object_ref_sink (_tmp15_);
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->progress_dialog = _tmp15_;
#line 864 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp12_);
#line 866 "/home/jens/Source/shotwell/src/Printing.vala"
	err_msg = NULL;
#line 6098 "Printing.c"
	{
		GtkPrintOperationResult _result_ = 0;
		AppWindow* _tmp16_ = NULL;
		AppWindow* _tmp17_ = NULL;
		GtkPrintOperationResult _tmp18_ = 0;
		GtkPrintOperationResult _tmp19_ = 0;
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp16_ = app_window_get_instance ();
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp17_ = _tmp16_;
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = gtk_print_operation_run (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation), GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_window_get_type (), GtkWindow), &_inner_error_);
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp19_ = _tmp18_;
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (_tmp17_);
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
		_result_ = _tmp19_;
#line 868 "/home/jens/Source/shotwell/src/Printing.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6119 "Printing.c"
			goto __catch468_g_error;
		}
#line 870 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_result_ == GTK_PRINT_OPERATION_RESULT_APPLY) {
#line 6124 "Printing.c"
			GtkPageSetup* _tmp20_ = NULL;
			GtkPageSetup* _tmp21_ = NULL;
#line 871 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp20_ = gtk_print_operation_get_default_page_setup (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation));
#line 871 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp21_ = _g_object_ref0 (_tmp20_);
#line 871 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (self->priv->user_page_setup);
#line 871 "/home/jens/Source/shotwell/src/Printing.vala"
			self->priv->user_page_setup = _tmp21_;
#line 6135 "Printing.c"
		}
	}
	goto __finally468;
	__catch468_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		e = _inner_error_;
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		_inner_error_ = NULL;
#line 873 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (job, gtk_print_operation_get_type (), GtkPrintOperation));
#line 874 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = e;
#line 874 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp23_ = _tmp22_->message;
#line 874 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp24_ = g_strdup (_tmp23_);
#line 874 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (err_msg);
#line 874 "/home/jens/Source/shotwell/src/Printing.vala"
		err_msg = _tmp24_;
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_error_free0 (e);
#line 6163 "Printing.c"
	}
	__finally468:
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (err_msg);
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (job);
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		g_clear_error (&_inner_error_);
#line 867 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 6178 "Printing.c"
	}
#line 877 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp25_ = self->priv->progress_dialog;
#line 877 "/home/jens/Source/shotwell/src/Printing.vala"
	progress_dialog_close (_tmp25_);
#line 878 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 878 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->progress_dialog = NULL;
#line 879 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 879 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->cancellable = NULL;
#line 881 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp26_ = app_window_get_instance ();
#line 881 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp27_ = _tmp26_;
#line 881 "/home/jens/Source/shotwell/src/Printing.vala"
	page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_PAGE_WINDOW, PageWindow));
#line 881 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp27_);
#line 883 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp28_ = err_msg;
#line 883 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp28_ != NULL) {
#line 6204 "Printing.c"
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
#line 884 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = _ ("Unable to print photo:\n\n%s");
#line 884 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp30_ = err_msg;
#line 884 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp31_ = g_strdup_printf (_tmp29_, _tmp30_);
#line 884 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp32_ = _tmp31_;
#line 884 "/home/jens/Source/shotwell/src/Printing.vala"
		app_window_error_message (_tmp32_, NULL);
#line 884 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp32_);
#line 6221 "Printing.c"
	}
#line 849 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (err_msg);
#line 849 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (job);
#line 6227 "Printing.c"
}


static void print_manager_on_begin_print (PrintManager* self, GtkPrintOperation* emitting_object, GtkPrintContext* job_context) {
	PrintJob* job = NULL;
	GtkPrintOperation* _tmp0_ = NULL;
	PrintJob* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GCancellable* _tmp3_ = NULL;
	GeeList* photos = NULL;
	PrintJob* _tmp7_ = NULL;
	GeeList* _tmp8_ = NULL;
	PrintJob* _tmp9_ = NULL;
	PrintSettings* _tmp10_ = NULL;
	PrintSettings* _tmp11_ = NULL;
	ContentLayout _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
#line 887 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 887 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_OPERATION (emitting_object));
#line 887 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_CONTEXT (job_context));
#line 888 "/home/jens/Source/shotwell/src/Printing.vala"
	g_debug ("Printing.vala:888: on_begin_print");
#line 890 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = emitting_object;
#line 890 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PRINT_JOB, PrintJob));
#line 890 "/home/jens/Source/shotwell/src/Printing.vala"
	job = _tmp1_;
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->cancellable;
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp3_ != NULL) {
#line 6263 "Printing.c"
		GCancellable* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = self->priv->cancellable;
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = g_cancellable_is_cancelled (_tmp4_);
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = _tmp5_;
#line 6272 "Printing.c"
	} else {
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = FALSE;
#line 6276 "Printing.c"
	}
#line 893 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_) {
#line 6280 "Printing.c"
		PrintJob* _tmp6_ = NULL;
#line 894 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = job;
#line 894 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_print_operation_get_type (), GtkPrintOperation));
#line 896 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (job);
#line 896 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 6290 "Printing.c"
	}
#line 899 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = job;
#line 899 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = print_job_get_photos (_tmp7_);
#line 899 "/home/jens/Source/shotwell/src/Printing.vala"
	photos = _tmp8_;
#line 900 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = job;
#line 900 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = print_job_get_local_settings (_tmp9_);
#line 900 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = _tmp10_;
#line 900 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = print_settings_get_content_layout (_tmp11_);
#line 900 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = _tmp12_ == CONTENT_LAYOUT_IMAGE_PER_PAGE;
#line 900 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp11_);
#line 900 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp13_) {
#line 6312 "Printing.c"
		PrintLayout layout = 0;
		PrintJob* _tmp14_ = NULL;
		PrintSettings* _tmp15_ = NULL;
		PrintSettings* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		PrintLayout _tmp18_ = 0;
		PrintJob* _tmp19_ = NULL;
		GeeList* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		PrintLayout _tmp23_ = 0;
		gint _tmp24_ = 0;
		gdouble _tmp25_ = 0.0;
#line 901 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp14_ = job;
#line 901 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp15_ = print_job_get_local_settings (_tmp14_);
#line 901 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp16_ = _tmp15_;
#line 901 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp17_ = print_settings_get_image_per_page_selection (_tmp16_);
#line 901 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp18_ = (PrintLayout) _tmp17_;
#line 901 "/home/jens/Source/shotwell/src/Printing.vala"
		_print_settings_unref0 (_tmp16_);
#line 901 "/home/jens/Source/shotwell/src/Printing.vala"
		layout = _tmp18_;
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp19_ = job;
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp20_ = photos;
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp21_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = _tmp21_;
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp23_ = layout;
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp24_ = print_layout_get_per_page (_tmp23_);
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp25_ = ceil (((gdouble) _tmp22_) / ((gdouble) _tmp24_));
#line 902 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_set_n_pages (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_print_operation_get_type (), GtkPrintOperation), (gint) _tmp25_);
#line 6356 "Printing.c"
	} else {
		PrintJob* _tmp26_ = NULL;
		GeeList* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
#line 904 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = job;
#line 904 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp27_ = photos;
#line 904 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp28_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_COLLECTION, GeeCollection));
#line 904 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp29_ = _tmp28_;
#line 904 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_set_n_pages (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_print_operation_get_type (), GtkPrintOperation), _tmp29_);
#line 6372 "Printing.c"
	}
#line 907 "/home/jens/Source/shotwell/src/Printing.vala"
	spin_event_loop ();
#line 887 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (photos);
#line 887 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (job);
#line 6380 "Printing.c"
}


static void print_manager_on_status_changed (PrintManager* self, GtkPrintOperation* job) {
	GtkPrintOperation* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ProgressDialog* _tmp2_ = NULL;
#line 910 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 910 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_OPERATION (job));
#line 911 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = job;
#line 911 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_print_operation_get_status_string (_tmp0_);
#line 911 "/home/jens/Source/shotwell/src/Printing.vala"
	g_debug ("Printing.vala:911: on_status_changed: %s", _tmp1_);
#line 913 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = self->priv->progress_dialog;
#line 913 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_ != NULL) {
#line 6402 "Printing.c"
		ProgressDialog* _tmp3_ = NULL;
		GtkPrintOperation* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 914 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp3_ = self->priv->progress_dialog;
#line 914 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = job;
#line 914 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = gtk_print_operation_get_status_string (_tmp4_);
#line 914 "/home/jens/Source/shotwell/src/Printing.vala"
		progress_dialog_set_status (_tmp3_, _tmp5_);
#line 915 "/home/jens/Source/shotwell/src/Printing.vala"
		spin_event_loop ();
#line 6416 "Printing.c"
	}
}


static gpointer _cairo_reference0 (gpointer self) {
#line 940 "/home/jens/Source/shotwell/src/Printing.vala"
	return self ? cairo_reference (self) : NULL;
#line 6424 "Printing.c"
}


static void print_manager_on_draw_page (PrintManager* self, GtkPrintOperation* emitting_object, GtkPrintContext* job_context, gint page_num) {
	PrintJob* job = NULL;
	GtkPrintOperation* _tmp0_ = NULL;
	PrintJob* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GCancellable* _tmp3_ = NULL;
	GtkPageSetup* page_setup = NULL;
	GtkPrintContext* _tmp7_ = NULL;
	GtkPageSetup* _tmp8_ = NULL;
	GtkPageSetup* _tmp9_ = NULL;
	gdouble page_width = 0.0;
	GtkPageSetup* _tmp10_ = NULL;
	gdouble _tmp11_ = 0.0;
	gdouble page_height = 0.0;
	GtkPageSetup* _tmp12_ = NULL;
	gdouble _tmp13_ = 0.0;
	gdouble dpi = 0.0;
	PrintJob* _tmp14_ = NULL;
	PrintSettings* _tmp15_ = NULL;
	PrintSettings* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gdouble _tmp18_ = 0.0;
	gdouble inv_dpi = 0.0;
	gdouble _tmp19_ = 0.0;
	cairo_t* dc = NULL;
	GtkPrintContext* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
	cairo_t* _tmp22_ = NULL;
	cairo_t* _tmp23_ = NULL;
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	GeeList* photos = NULL;
	PrintJob* _tmp26_ = NULL;
	GeeList* _tmp27_ = NULL;
	ContentLayout content_layout = 0;
	PrintJob* _tmp28_ = NULL;
	PrintSettings* _tmp29_ = NULL;
	PrintSettings* _tmp30_ = NULL;
	ContentLayout _tmp31_ = 0;
	ContentLayout _tmp32_ = 0;
	ContentLayout _tmp33_ = 0;
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_OPERATION (emitting_object));
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_CONTEXT (job_context));
#line 921 "/home/jens/Source/shotwell/src/Printing.vala"
	g_debug ("Printing.vala:921: on_draw_page");
#line 923 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = emitting_object;
#line 923 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PRINT_JOB, PrintJob));
#line 923 "/home/jens/Source/shotwell/src/Printing.vala"
	job = _tmp1_;
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->cancellable;
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp3_ != NULL) {
#line 6487 "Printing.c"
		GCancellable* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp4_ = self->priv->cancellable;
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp5_ = g_cancellable_is_cancelled (_tmp4_);
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = _tmp5_;
#line 6496 "Printing.c"
	} else {
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp2_ = FALSE;
#line 6500 "Printing.c"
	}
#line 926 "/home/jens/Source/shotwell/src/Printing.vala"
	if (_tmp2_) {
#line 6504 "Printing.c"
		PrintJob* _tmp6_ = NULL;
#line 927 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp6_ = job;
#line 927 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_print_operation_get_type (), GtkPrintOperation));
#line 929 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_object_unref0 (job);
#line 929 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 6514 "Printing.c"
	}
#line 932 "/home/jens/Source/shotwell/src/Printing.vala"
	spin_event_loop ();
#line 934 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = job_context;
#line 934 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = gtk_print_context_get_page_setup (_tmp7_);
#line 934 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 934 "/home/jens/Source/shotwell/src/Printing.vala"
	page_setup = _tmp9_;
#line 935 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = page_setup;
#line 935 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = gtk_page_setup_get_page_width (_tmp10_, GTK_UNIT_INCH);
#line 935 "/home/jens/Source/shotwell/src/Printing.vala"
	page_width = _tmp11_;
#line 936 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = page_setup;
#line 936 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = gtk_page_setup_get_page_height (_tmp12_, GTK_UNIT_INCH);
#line 936 "/home/jens/Source/shotwell/src/Printing.vala"
	page_height = _tmp13_;
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = job;
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = print_job_get_local_settings (_tmp14_);
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = _tmp15_;
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = print_settings_get_content_ppi (_tmp16_);
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp18_ = (gdouble) _tmp17_;
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp16_);
#line 938 "/home/jens/Source/shotwell/src/Printing.vala"
	dpi = _tmp18_;
#line 939 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp19_ = dpi;
#line 939 "/home/jens/Source/shotwell/src/Printing.vala"
	inv_dpi = 1.0 / _tmp19_;
#line 940 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp20_ = job_context;
#line 940 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp21_ = gtk_print_context_get_cairo_context (_tmp20_);
#line 940 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp22_ = _cairo_reference0 (_tmp21_);
#line 940 "/home/jens/Source/shotwell/src/Printing.vala"
	dc = _tmp22_;
#line 941 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp23_ = dc;
#line 941 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp24_ = inv_dpi;
#line 941 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp25_ = inv_dpi;
#line 941 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_scale (_tmp23_, _tmp24_, _tmp25_);
#line 942 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp26_ = job;
#line 942 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp27_ = print_job_get_photos (_tmp26_);
#line 942 "/home/jens/Source/shotwell/src/Printing.vala"
	photos = _tmp27_;
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp28_ = job;
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp29_ = print_job_get_local_settings (_tmp28_);
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp30_ = _tmp29_;
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp31_ = print_settings_get_content_layout (_tmp30_);
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp32_ = _tmp31_;
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp30_);
#line 944 "/home/jens/Source/shotwell/src/Printing.vala"
	content_layout = _tmp32_;
#line 945 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp33_ = content_layout;
#line 945 "/home/jens/Source/shotwell/src/Printing.vala"
	switch (_tmp33_) {
#line 945 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_STANDARD_SIZE:
#line 945 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_CUSTOM_SIZE:
#line 6600 "Printing.c"
		{
			gdouble canvas_width = 0.0;
			gdouble canvas_height = 0.0;
			ContentLayout _tmp34_ = 0;
			gint _tmp66_ = 0;
			GeeList* _tmp67_ = NULL;
			gint _tmp68_ = 0;
			gint _tmp69_ = 0;
			ProgressDialog* _tmp115_ = NULL;
#line 949 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp34_ = content_layout;
#line 949 "/home/jens/Source/shotwell/src/Printing.vala"
			if (_tmp34_ == CONTENT_LAYOUT_STANDARD_SIZE) {
#line 6614 "Printing.c"
				gint _tmp35_ = 0;
				StandardPrintSize** _tmp36_ = NULL;
				PrintJob* _tmp37_ = NULL;
				PrintSettings* _tmp38_ = NULL;
				PrintSettings* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				StandardPrintSize* _tmp41_ = NULL;
				Measurement _tmp42_ = {0};
				gdouble _tmp43_ = 0.0;
				gint _tmp44_ = 0;
				StandardPrintSize** _tmp45_ = NULL;
				PrintJob* _tmp46_ = NULL;
				PrintSettings* _tmp47_ = NULL;
				PrintSettings* _tmp48_ = NULL;
				gint _tmp49_ = 0;
				StandardPrintSize* _tmp50_ = NULL;
				Measurement _tmp51_ = {0};
				gdouble _tmp52_ = 0.0;
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp36_ = print_manager_get_standard_sizes (self, &_tmp35_);
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp37_ = job;
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp38_ = print_job_get_local_settings (_tmp37_);
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp39_ = _tmp38_;
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp40_ = print_settings_get_size_selection (_tmp39_);
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp41_ = _tmp36_[_tmp40_];
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				measurement_convert_to (&_tmp41_->width, MEASUREMENT_UNIT_INCHES, &_tmp42_);
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp43_ = _tmp42_.value;
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_width = _tmp43_;
#line 950 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp39_);
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp45_ = print_manager_get_standard_sizes (self, &_tmp44_);
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp46_ = job;
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp47_ = print_job_get_local_settings (_tmp46_);
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp48_ = _tmp47_;
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp49_ = print_settings_get_size_selection (_tmp48_);
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp50_ = _tmp45_[_tmp49_];
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				measurement_convert_to (&_tmp50_->height, MEASUREMENT_UNIT_INCHES, &_tmp51_);
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp52_ = _tmp51_.value;
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_height = _tmp52_;
#line 952 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp48_);
#line 6673 "Printing.c"
			} else {
				ContentLayout _tmp53_ = 0;
				PrintJob* _tmp54_ = NULL;
				PrintSettings* _tmp55_ = NULL;
				PrintSettings* _tmp56_ = NULL;
				Measurement _tmp57_ = {0};
				Measurement _tmp58_ = {0};
				gdouble _tmp59_ = 0.0;
				PrintJob* _tmp60_ = NULL;
				PrintSettings* _tmp61_ = NULL;
				PrintSettings* _tmp62_ = NULL;
				Measurement _tmp63_ = {0};
				Measurement _tmp64_ = {0};
				gdouble _tmp65_ = 0.0;
#line 955 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp53_ = content_layout;
#line 955 "/home/jens/Source/shotwell/src/Printing.vala"
				_vala_assert (_tmp53_ == CONTENT_LAYOUT_CUSTOM_SIZE, "content_layout == ContentLayout.CUSTOM_SIZE");
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp54_ = job;
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp55_ = print_job_get_local_settings (_tmp54_);
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp56_ = _tmp55_;
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				print_settings_get_content_width (_tmp56_, &_tmp57_);
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				measurement_convert_to (&_tmp57_, MEASUREMENT_UNIT_INCHES, &_tmp58_);
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp59_ = _tmp58_.value;
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_width = _tmp59_;
#line 956 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp56_);
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp60_ = job;
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp61_ = print_job_get_local_settings (_tmp60_);
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp62_ = _tmp61_;
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				print_settings_get_content_height (_tmp62_, &_tmp63_);
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				measurement_convert_to (&_tmp63_, MEASUREMENT_UNIT_INCHES, &_tmp64_);
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp65_ = _tmp64_.value;
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_height = _tmp65_;
#line 958 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp62_);
#line 6724 "Printing.c"
			}
#line 962 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp66_ = page_num;
#line 962 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp67_ = photos;
#line 962 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp68_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, GEE_TYPE_COLLECTION, GeeCollection));
#line 962 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp69_ = _tmp68_;
#line 962 "/home/jens/Source/shotwell/src/Printing.vala"
			if (_tmp66_ < _tmp69_) {
#line 6736 "Printing.c"
				Dimensions photo_dimensions = {0};
				GeeList* _tmp70_ = NULL;
				gint _tmp71_ = 0;
				gpointer _tmp72_ = NULL;
				Photo* _tmp73_ = NULL;
				Dimensions _tmp74_ = {0};
				Dimensions _tmp75_ = {0};
				gdouble photo_aspect_ratio = 0.0;
				gdouble _tmp76_ = 0.0;
				gdouble canvas_aspect_ratio = 0.0;
				gdouble _tmp77_ = 0.0;
				gdouble _tmp78_ = 0.0;
				gdouble _tmp79_ = 0.0;
				gdouble _tmp80_ = 0.0;
				gdouble _tmp81_ = 0.0;
				gdouble _tmp82_ = 0.0;
				gdouble dx = 0.0;
				gdouble _tmp86_ = 0.0;
				gdouble _tmp87_ = 0.0;
				gdouble dy = 0.0;
				gdouble _tmp88_ = 0.0;
				gdouble _tmp89_ = 0.0;
				GeeList* _tmp90_ = NULL;
				gint _tmp91_ = 0;
				gpointer _tmp92_ = NULL;
				Photo* _tmp93_ = NULL;
				gdouble _tmp94_ = 0.0;
				gdouble _tmp95_ = 0.0;
				gdouble _tmp96_ = 0.0;
				gdouble _tmp97_ = 0.0;
				PrintJob* _tmp98_ = NULL;
				GtkPrintContext* _tmp99_ = NULL;
				PrintJob* _tmp100_ = NULL;
				PrintSettings* _tmp101_ = NULL;
				PrintSettings* _tmp102_ = NULL;
				gboolean _tmp103_ = FALSE;
				gboolean _tmp104_ = FALSE;
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp70_ = photos;
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp71_ = page_num;
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp72_ = gee_list_get (_tmp70_, _tmp71_);
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp73_ = (Photo*) _tmp72_;
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp74_);
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp75_ = _tmp74_;
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				_g_object_unref0 (_tmp73_);
#line 963 "/home/jens/Source/shotwell/src/Printing.vala"
				photo_dimensions = _tmp75_;
#line 964 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp76_ = dimensions_get_aspect_ratio (&photo_dimensions);
#line 964 "/home/jens/Source/shotwell/src/Printing.vala"
				photo_aspect_ratio = _tmp76_;
#line 965 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp77_ = canvas_width;
#line 965 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp78_ = canvas_height;
#line 965 "/home/jens/Source/shotwell/src/Printing.vala"
				canvas_aspect_ratio = ((gdouble) _tmp77_) / _tmp78_;
#line 966 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp79_ = canvas_aspect_ratio;
#line 966 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp80_ = floor (_tmp79_);
#line 966 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp81_ = photo_aspect_ratio;
#line 966 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp82_ = floor (_tmp81_);
#line 966 "/home/jens/Source/shotwell/src/Printing.vala"
				if (_tmp80_ != _tmp82_) {
#line 6810 "Printing.c"
					gdouble canvas_tmp = 0.0;
					gdouble _tmp83_ = 0.0;
					gdouble _tmp84_ = 0.0;
					gdouble _tmp85_ = 0.0;
#line 967 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp83_ = canvas_width;
#line 967 "/home/jens/Source/shotwell/src/Printing.vala"
					canvas_tmp = _tmp83_;
#line 968 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp84_ = canvas_height;
#line 968 "/home/jens/Source/shotwell/src/Printing.vala"
					canvas_width = _tmp84_;
#line 969 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp85_ = canvas_tmp;
#line 969 "/home/jens/Source/shotwell/src/Printing.vala"
					canvas_height = _tmp85_;
#line 6827 "Printing.c"
				}
#line 972 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp86_ = page_width;
#line 972 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp87_ = canvas_width;
#line 972 "/home/jens/Source/shotwell/src/Printing.vala"
				dx = (_tmp86_ - _tmp87_) / 2.0;
#line 973 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp88_ = page_height;
#line 973 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp89_ = canvas_height;
#line 973 "/home/jens/Source/shotwell/src/Printing.vala"
				dy = (_tmp88_ - _tmp89_) / 2.0;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp90_ = photos;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp91_ = page_num;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp92_ = gee_list_get (_tmp90_, _tmp91_);
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp93_ = (Photo*) _tmp92_;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp94_ = dx;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp95_ = dy;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp96_ = canvas_width;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp97_ = canvas_height;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp98_ = job;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp99_ = job_context;
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				print_manager_fit_image_to_canvas (self, _tmp93_, _tmp94_, _tmp95_, _tmp96_, _tmp97_, TRUE, _tmp98_, _tmp99_);
#line 974 "/home/jens/Source/shotwell/src/Printing.vala"
				_g_object_unref0 (_tmp93_);
#line 976 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp100_ = job;
#line 976 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp101_ = print_job_get_local_settings (_tmp100_);
#line 976 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp102_ = _tmp101_;
#line 976 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp103_ = print_settings_is_print_titles_enabled (_tmp102_);
#line 976 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp104_ = _tmp103_;
#line 976 "/home/jens/Source/shotwell/src/Printing.vala"
				_print_settings_unref0 (_tmp102_);
#line 976 "/home/jens/Source/shotwell/src/Printing.vala"
				if (_tmp104_) {
#line 6879 "Printing.c"
					gdouble _tmp105_ = 0.0;
					gdouble _tmp106_ = 0.0;
					GeeList* _tmp107_ = NULL;
					gint _tmp108_ = 0;
					gpointer _tmp109_ = NULL;
					Photo* _tmp110_ = NULL;
					gchar* _tmp111_ = NULL;
					gchar* _tmp112_ = NULL;
					PrintJob* _tmp113_ = NULL;
					GtkPrintContext* _tmp114_ = NULL;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp105_ = page_width;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp106_ = page_height;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp107_ = photos;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp108_ = page_num;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp109_ = gee_list_get (_tmp107_, _tmp108_);
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp110_ = (Photo*) _tmp109_;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp111_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, TYPE_DATA_OBJECT, DataObject));
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp112_ = _tmp111_;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp113_ = job;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp114_ = job_context;
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					print_manager_add_title_to_canvas (self, _tmp105_ / 2, _tmp106_, _tmp112_, _tmp113_, _tmp114_);
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_free0 (_tmp112_);
#line 977 "/home/jens/Source/shotwell/src/Printing.vala"
					_g_object_unref0 (_tmp110_);
#line 6916 "Printing.c"
				}
			}
#line 982 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp115_ = self->priv->progress_dialog;
#line 982 "/home/jens/Source/shotwell/src/Printing.vala"
			if (_tmp115_ != NULL) {
#line 6923 "Printing.c"
				ProgressDialog* _tmp116_ = NULL;
				gint _tmp117_ = 0;
				GeeList* _tmp118_ = NULL;
				gint _tmp119_ = 0;
				gint _tmp120_ = 0;
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp116_ = self->priv->progress_dialog;
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp117_ = page_num;
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp118_ = photos;
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp119_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, GEE_TYPE_COLLECTION, GeeCollection));
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp120_ = _tmp119_;
#line 983 "/home/jens/Source/shotwell/src/Printing.vala"
				progress_dialog_monitor (_tmp116_, (guint64) _tmp117_, (guint64) _tmp120_, TRUE);
#line 6941 "Printing.c"
			}
#line 984 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 6945 "Printing.c"
		}
#line 945 "/home/jens/Source/shotwell/src/Printing.vala"
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
#line 6949 "Printing.c"
		{
			PrintLayout layout = 0;
			PrintJob* _tmp121_ = NULL;
			PrintSettings* _tmp122_ = NULL;
			PrintSettings* _tmp123_ = NULL;
			gint _tmp124_ = 0;
			PrintLayout _tmp125_ = 0;
			gint nx = 0;
			PrintLayout _tmp126_ = 0;
			gint _tmp127_ = 0;
			gint ny = 0;
			PrintLayout _tmp128_ = 0;
			gint _tmp129_ = 0;
			gint start = 0;
			gint _tmp130_ = 0;
			PrintLayout _tmp131_ = 0;
			gint _tmp132_ = 0;
			gdouble canvas_width = 0.0;
			gdouble _tmp133_ = 0.0;
			gint _tmp134_ = 0;
			gint _tmp135_ = 0;
			gdouble canvas_height = 0.0;
			gdouble _tmp136_ = 0.0;
			gint _tmp137_ = 0;
			gint _tmp138_ = 0;
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp121_ = job;
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp122_ = print_job_get_local_settings (_tmp121_);
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp123_ = _tmp122_;
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp124_ = print_settings_get_image_per_page_selection (_tmp123_);
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp125_ = (PrintLayout) _tmp124_;
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			_print_settings_unref0 (_tmp123_);
#line 987 "/home/jens/Source/shotwell/src/Printing.vala"
			layout = _tmp125_;
#line 988 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp126_ = layout;
#line 988 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp127_ = print_layout_get_x (_tmp126_);
#line 988 "/home/jens/Source/shotwell/src/Printing.vala"
			nx = _tmp127_;
#line 989 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp128_ = layout;
#line 989 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp129_ = print_layout_get_y (_tmp128_);
#line 989 "/home/jens/Source/shotwell/src/Printing.vala"
			ny = _tmp129_;
#line 990 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp130_ = page_num;
#line 990 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp131_ = layout;
#line 990 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp132_ = print_layout_get_per_page (_tmp131_);
#line 990 "/home/jens/Source/shotwell/src/Printing.vala"
			start = _tmp130_ * _tmp132_;
#line 991 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp133_ = page_width;
#line 991 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp134_ = nx;
#line 991 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp135_ = nx;
#line 991 "/home/jens/Source/shotwell/src/Printing.vala"
			canvas_width = ((gdouble) (_tmp133_ - (PRINT_MANAGER_IMAGE_DISTANCE * (_tmp134_ - 1)))) / _tmp135_;
#line 992 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp136_ = page_height;
#line 992 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp137_ = ny;
#line 992 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp138_ = ny;
#line 992 "/home/jens/Source/shotwell/src/Printing.vala"
			canvas_height = ((gdouble) (_tmp136_ - (PRINT_MANAGER_IMAGE_DISTANCE * (_tmp137_ - 1)))) / _tmp138_;
#line 7025 "Printing.c"
			{
				gint y = 0;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
				y = 0;
#line 7030 "Printing.c"
				{
					gboolean _tmp139_ = FALSE;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
					_tmp139_ = TRUE;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
					while (TRUE) {
#line 7037 "Printing.c"
						gint _tmp141_ = 0;
						gint _tmp142_ = 0;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
						if (!_tmp139_) {
#line 7042 "Printing.c"
							gint _tmp140_ = 0;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
							_tmp140_ = y;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
							y = _tmp140_ + 1;
#line 7048 "Printing.c"
						}
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp139_ = FALSE;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp141_ = y;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
						_tmp142_ = ny;
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
						if (!(_tmp141_ < _tmp142_)) {
#line 993 "/home/jens/Source/shotwell/src/Printing.vala"
							break;
#line 7060 "Printing.c"
						}
						{
							gint x = 0;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
							x = 0;
#line 7066 "Printing.c"
							{
								gboolean _tmp143_ = FALSE;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
								_tmp143_ = TRUE;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
								while (TRUE) {
#line 7073 "Printing.c"
									gint _tmp145_ = 0;
									gint _tmp146_ = 0;
									gint i = 0;
									gint _tmp147_ = 0;
									gint _tmp148_ = 0;
									gint _tmp149_ = 0;
									gint _tmp150_ = 0;
									gint _tmp151_ = 0;
									GeeList* _tmp152_ = NULL;
									gint _tmp153_ = 0;
									gint _tmp154_ = 0;
									ProgressDialog* _tmp188_ = NULL;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
									if (!_tmp143_) {
#line 7088 "Printing.c"
										gint _tmp144_ = 0;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp144_ = x;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
										x = _tmp144_ + 1;
#line 7094 "Printing.c"
									}
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp143_ = FALSE;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp145_ = x;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp146_ = nx;
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
									if (!(_tmp145_ < _tmp146_)) {
#line 994 "/home/jens/Source/shotwell/src/Printing.vala"
										break;
#line 7106 "Printing.c"
									}
#line 995 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp147_ = start;
#line 995 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp148_ = y;
#line 995 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp149_ = nx;
#line 995 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp150_ = x;
#line 995 "/home/jens/Source/shotwell/src/Printing.vala"
									i = (_tmp147_ + (_tmp148_ * _tmp149_)) + _tmp150_;
#line 996 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp151_ = i;
#line 996 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp152_ = photos;
#line 996 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp153_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp152_, GEE_TYPE_COLLECTION, GeeCollection));
#line 996 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp154_ = _tmp153_;
#line 996 "/home/jens/Source/shotwell/src/Printing.vala"
									if (_tmp151_ < _tmp154_) {
#line 7128 "Printing.c"
										gdouble dx = 0.0;
										gint _tmp155_ = 0;
										gdouble _tmp156_ = 0.0;
										gint _tmp157_ = 0;
										gdouble dy = 0.0;
										gint _tmp158_ = 0;
										gdouble _tmp159_ = 0.0;
										gint _tmp160_ = 0;
										GeeList* _tmp161_ = NULL;
										gint _tmp162_ = 0;
										gpointer _tmp163_ = NULL;
										Photo* _tmp164_ = NULL;
										gdouble _tmp165_ = 0.0;
										gdouble _tmp166_ = 0.0;
										gdouble _tmp167_ = 0.0;
										gdouble _tmp168_ = 0.0;
										PrintJob* _tmp169_ = NULL;
										GtkPrintContext* _tmp170_ = NULL;
										PrintJob* _tmp171_ = NULL;
										PrintSettings* _tmp172_ = NULL;
										PrintSettings* _tmp173_ = NULL;
										gboolean _tmp174_ = FALSE;
										gboolean _tmp175_ = FALSE;
#line 997 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp155_ = x;
#line 997 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp156_ = canvas_width;
#line 997 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp157_ = x;
#line 997 "/home/jens/Source/shotwell/src/Printing.vala"
										dx = (_tmp155_ * _tmp156_) + (_tmp157_ * PRINT_MANAGER_IMAGE_DISTANCE);
#line 998 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp158_ = y;
#line 998 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp159_ = canvas_height;
#line 998 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp160_ = y;
#line 998 "/home/jens/Source/shotwell/src/Printing.vala"
										dy = (_tmp158_ * _tmp159_) + (_tmp160_ * PRINT_MANAGER_IMAGE_DISTANCE);
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp161_ = photos;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp162_ = i;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp163_ = gee_list_get (_tmp161_, _tmp162_);
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp164_ = (Photo*) _tmp163_;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp165_ = dx;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp166_ = dy;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp167_ = canvas_width;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp168_ = canvas_height;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp169_ = job;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp170_ = job_context;
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										print_manager_fit_image_to_canvas (self, _tmp164_, _tmp165_, _tmp166_, _tmp167_, _tmp168_, FALSE, _tmp169_, _tmp170_);
#line 999 "/home/jens/Source/shotwell/src/Printing.vala"
										_g_object_unref0 (_tmp164_);
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp171_ = job;
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp172_ = print_job_get_local_settings (_tmp171_);
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp173_ = _tmp172_;
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp174_ = print_settings_is_print_titles_enabled (_tmp173_);
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp175_ = _tmp174_;
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
										_print_settings_unref0 (_tmp173_);
#line 1001 "/home/jens/Source/shotwell/src/Printing.vala"
										if (_tmp175_) {
#line 7206 "Printing.c"
											gdouble _tmp176_ = 0.0;
											gdouble _tmp177_ = 0.0;
											gdouble _tmp178_ = 0.0;
											gdouble _tmp179_ = 0.0;
											GeeList* _tmp180_ = NULL;
											gint _tmp181_ = 0;
											gpointer _tmp182_ = NULL;
											Photo* _tmp183_ = NULL;
											gchar* _tmp184_ = NULL;
											gchar* _tmp185_ = NULL;
											PrintJob* _tmp186_ = NULL;
											GtkPrintContext* _tmp187_ = NULL;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp176_ = dx;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp177_ = canvas_width;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp178_ = dy;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp179_ = canvas_height;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp180_ = photos;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp181_ = i;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp182_ = gee_list_get (_tmp180_, _tmp181_);
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp183_ = (Photo*) _tmp182_;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp184_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp183_, TYPE_DATA_OBJECT, DataObject));
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp185_ = _tmp184_;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp186_ = job;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_tmp187_ = job_context;
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											print_manager_add_title_to_canvas (self, _tmp176_ + (_tmp177_ / 2), _tmp178_ + _tmp179_, _tmp185_, _tmp186_, _tmp187_);
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_g_free0 (_tmp185_);
#line 1002 "/home/jens/Source/shotwell/src/Printing.vala"
											_g_object_unref0 (_tmp183_);
#line 7249 "Printing.c"
										}
									}
#line 1007 "/home/jens/Source/shotwell/src/Printing.vala"
									_tmp188_ = self->priv->progress_dialog;
#line 1007 "/home/jens/Source/shotwell/src/Printing.vala"
									if (_tmp188_ != NULL) {
#line 7256 "Printing.c"
										ProgressDialog* _tmp189_ = NULL;
										gint _tmp190_ = 0;
										GeeList* _tmp191_ = NULL;
										gint _tmp192_ = 0;
										gint _tmp193_ = 0;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp189_ = self->priv->progress_dialog;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp190_ = i;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp191_ = photos;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp192_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp191_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
										_tmp193_ = _tmp192_;
#line 1008 "/home/jens/Source/shotwell/src/Printing.vala"
										progress_dialog_monitor (_tmp189_, (guint64) _tmp190_, (guint64) _tmp193_, TRUE);
#line 7274 "Printing.c"
									}
								}
							}
						}
					}
				}
			}
#line 1011 "/home/jens/Source/shotwell/src/Printing.vala"
			break;
#line 7284 "Printing.c"
		}
		default:
		{
#line 1014 "/home/jens/Source/shotwell/src/Printing.vala"
			g_error ("Printing.vala:1014: unknown or unsupported layout mode");
#line 7290 "Printing.c"
		}
	}
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (photos);
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
	_cairo_destroy0 (dc);
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (page_setup);
#line 919 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (job);
#line 7301 "Printing.c"
}


static void _print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply (GtkPrintOperation* _sender, GtkWidget* widget, gpointer self) {
#line 1020 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_on_custom_widget_apply ((PrintManager*) self, widget);
#line 7308 "Printing.c"
}


static GObject* print_manager_on_create_custom_widget (PrintManager* self, GtkPrintOperation* emitting_object) {
	GObject* result = NULL;
	GtkPrintOperation* _tmp0_ = NULL;
	CustomPrintTab* _tmp1_ = NULL;
	GtkPrintOperation* _tmp2_ = NULL;
	CustomPrintTab* _tmp3_ = NULL;
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_MANAGER (self), NULL);
#line 1018 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (GTK_IS_PRINT_OPERATION (emitting_object), NULL);
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = emitting_object;
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = custom_print_tab_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PRINT_JOB, PrintJob));
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
	g_object_ref_sink (_tmp1_);
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_tab);
#line 1019 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->custom_tab = _tmp1_;
#line 1020 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = emitting_object;
#line 1020 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PRINT_JOB, PrintJob), gtk_print_operation_get_type (), GtkPrintOperation), "custom-widget-apply", (GCallback) _print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply, self);
#line 1021 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = self->priv->custom_tab;
#line 1021 "/home/jens/Source/shotwell/src/Printing.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject);
#line 1021 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 7342 "Printing.c"
}


static void print_manager_on_custom_widget_apply (PrintManager* self, GtkWidget* custom_widget) {
	CustomPrintTab* tab = NULL;
	GtkWidget* _tmp0_ = NULL;
	CustomPrintTab* _tmp1_ = NULL;
	PrintJob* _tmp2_ = NULL;
	PrintJob* _tmp3_ = NULL;
	PrintSettings* _tmp4_ = NULL;
	PrintSettings* _tmp5_ = NULL;
	PrintSettings* _tmp6_ = NULL;
	PrintSettings* _tmp7_ = NULL;
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_WIDGET (custom_widget));
#line 1025 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = custom_widget;
#line 1025 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_CUSTOM_PRINT_TAB, CustomPrintTab));
#line 1025 "/home/jens/Source/shotwell/src/Printing.vala"
	tab = _tmp1_;
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = custom_print_tab_get_source_job (tab);
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = _tmp2_;
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = custom_print_tab_get_local_settings (tab);
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = _tmp4_;
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
	print_job_set_local_settings (_tmp3_, _tmp5_);
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp5_);
#line 1026 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (_tmp3_);
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = custom_print_tab_get_local_settings (tab);
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = _tmp6_;
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_set_global_settings (self, _tmp7_);
#line 1027 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp7_);
#line 1024 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (tab);
#line 7390 "Printing.c"
}


static void print_manager_fit_image_to_canvas (PrintManager* self, Photo* photo, gdouble x, gdouble y, gdouble canvas_width, gdouble canvas_height, gboolean crop, PrintJob* job, GtkPrintContext* job_context) {
	cairo_t* dc = NULL;
	GtkPrintContext* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	Dimensions photo_dimensions = {0};
	Photo* _tmp3_ = NULL;
	Dimensions _tmp4_ = {0};
	gdouble photo_aspect_ratio = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble canvas_aspect_ratio = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble target_width = 0.0;
	gdouble target_height = 0.0;
	gdouble dpi = 0.0;
	PrintJob* _tmp8_ = NULL;
	PrintSettings* _tmp9_ = NULL;
	PrintSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gdouble _tmp12_ = 0.0;
	gboolean _tmp13_ = FALSE;
	gdouble x_offset = 0.0;
	gdouble _tmp28_ = 0.0;
	gdouble _tmp29_ = 0.0;
	gdouble y_offset = 0.0;
	gdouble _tmp30_ = 0.0;
	gdouble _tmp31_ = 0.0;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_ = 0.0;
	gint w = 0;
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	gint h = 0;
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	Dimensions viewport = {0};
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	cairo_t* _tmp96_ = NULL;
	GError * _inner_error_ = NULL;
#line 1030 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 1030 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PHOTO (photo));
#line 1030 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_JOB (job));
#line 1030 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_CONTEXT (job_context));
#line 1031 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = job_context;
#line 1031 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
#line 1031 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _cairo_reference0 (_tmp1_);
#line 1031 "/home/jens/Source/shotwell/src/Printing.vala"
	dc = _tmp2_;
#line 1032 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = photo;
#line 1032 "/home/jens/Source/shotwell/src/Printing.vala"
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp4_);
#line 1032 "/home/jens/Source/shotwell/src/Printing.vala"
	photo_dimensions = _tmp4_;
#line 1033 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = dimensions_get_aspect_ratio (&photo_dimensions);
#line 1033 "/home/jens/Source/shotwell/src/Printing.vala"
	photo_aspect_ratio = _tmp5_;
#line 1034 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = canvas_width;
#line 1034 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = canvas_height;
#line 1034 "/home/jens/Source/shotwell/src/Printing.vala"
	canvas_aspect_ratio = ((gdouble) _tmp6_) / _tmp7_;
#line 1036 "/home/jens/Source/shotwell/src/Printing.vala"
	target_width = 0.0;
#line 1037 "/home/jens/Source/shotwell/src/Printing.vala"
	target_height = 0.0;
#line 1038 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = job;
#line 1038 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = print_job_get_local_settings (_tmp8_);
#line 1038 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _tmp9_;
#line 1038 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = print_settings_get_content_ppi (_tmp10_);
#line 1038 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = (gdouble) _tmp11_;
#line 1038 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp10_);
#line 1038 "/home/jens/Source/shotwell/src/Printing.vala"
	dpi = _tmp12_;
#line 1040 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = crop;
#line 1040 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!_tmp13_) {
#line 7491 "Printing.c"
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
		gdouble _tmp22_ = 0.0;
		gdouble _tmp23_ = 0.0;
		gdouble _tmp24_ = 0.0;
		gdouble _tmp25_ = 0.0;
		gdouble _tmp26_ = 0.0;
		gdouble _tmp27_ = 0.0;
#line 1041 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp14_ = canvas_aspect_ratio;
#line 1041 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp15_ = photo_aspect_ratio;
#line 1041 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp14_ < _tmp15_) {
#line 7506 "Printing.c"
			gdouble _tmp16_ = 0.0;
			gdouble _tmp17_ = 0.0;
			gdouble _tmp18_ = 0.0;
#line 1042 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp16_ = canvas_width;
#line 1042 "/home/jens/Source/shotwell/src/Printing.vala"
			target_width = _tmp16_;
#line 1043 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp17_ = target_width;
#line 1043 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp18_ = photo_aspect_ratio;
#line 1043 "/home/jens/Source/shotwell/src/Printing.vala"
			target_height = _tmp17_ * (1.0 / _tmp18_);
#line 7520 "Printing.c"
		} else {
			gdouble _tmp19_ = 0.0;
			gdouble _tmp20_ = 0.0;
			gdouble _tmp21_ = 0.0;
#line 1045 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp19_ = canvas_height;
#line 1045 "/home/jens/Source/shotwell/src/Printing.vala"
			target_height = _tmp19_;
#line 1046 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp20_ = target_height;
#line 1046 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp21_ = photo_aspect_ratio;
#line 1046 "/home/jens/Source/shotwell/src/Printing.vala"
			target_width = _tmp20_ * _tmp21_;
#line 7535 "Printing.c"
		}
#line 1048 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp22_ = x;
#line 1048 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp23_ = canvas_width;
#line 1048 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp24_ = target_width;
#line 1048 "/home/jens/Source/shotwell/src/Printing.vala"
		x = _tmp22_ + ((_tmp23_ - _tmp24_) / 2.0);
#line 1049 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp25_ = y;
#line 1049 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp26_ = canvas_height;
#line 1049 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp27_ = target_height;
#line 1049 "/home/jens/Source/shotwell/src/Printing.vala"
		y = _tmp25_ + ((_tmp26_ - _tmp27_) / 2.0);
#line 7553 "Printing.c"
	}
#line 1052 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp28_ = dpi;
#line 1052 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp29_ = x;
#line 1052 "/home/jens/Source/shotwell/src/Printing.vala"
	x_offset = _tmp28_ * _tmp29_;
#line 1053 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp30_ = dpi;
#line 1053 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp31_ = y;
#line 1053 "/home/jens/Source/shotwell/src/Printing.vala"
	y_offset = _tmp30_ * _tmp31_;
#line 1054 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp32_ = dc;
#line 1054 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_save (_tmp32_);
#line 1055 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp33_ = dc;
#line 1055 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp34_ = x_offset;
#line 1055 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp35_ = y_offset;
#line 1055 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_translate (_tmp33_, _tmp34_, _tmp35_);
#line 1057 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp36_ = dpi;
#line 1057 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp37_ = canvas_width;
#line 1057 "/home/jens/Source/shotwell/src/Printing.vala"
	w = (gint) (_tmp36_ * _tmp37_);
#line 1058 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp38_ = dpi;
#line 1058 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp39_ = canvas_height;
#line 1058 "/home/jens/Source/shotwell/src/Printing.vala"
	h = (gint) (_tmp38_ * _tmp39_);
#line 1059 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp40_ = w;
#line 1059 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp41_ = h;
#line 1059 "/home/jens/Source/shotwell/src/Printing.vala"
	dimensions_init (&viewport, _tmp40_, _tmp41_);
#line 7597 "Printing.c"
	{
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_ = FALSE;
		cairo_t* _tmp89_ = NULL;
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp43_ = crop;
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp43_) {
#line 7606 "Printing.c"
			gdouble _tmp44_ = 0.0;
			gdouble _tmp45_ = 0.0;
			gboolean _tmp46_ = FALSE;
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp44_ = canvas_aspect_ratio;
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp45_ = photo_aspect_ratio;
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp46_ = print_manager_are_approximately_equal (self, _tmp44_, _tmp45_);
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp42_ = !_tmp46_;
#line 7618 "Printing.c"
		} else {
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp42_ = FALSE;
#line 7622 "Printing.c"
		}
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
		if (_tmp42_) {
#line 7626 "Printing.c"
			Scaling pixbuf_scaling = {0};
			Dimensions _tmp47_ = {0};
			Scaling _tmp48_ = {0};
			GdkPixbuf* photo_pixbuf = NULL;
			Photo* _tmp49_ = NULL;
			Scaling _tmp50_ = {0};
			GdkPixbuf* _tmp51_ = NULL;
			Dimensions scaled_photo_dimensions = {0};
			GdkPixbuf* _tmp52_ = NULL;
			Dimensions _tmp53_ = {0};
			gint shave_vertical = 0;
			gint shave_horizontal = 0;
			gdouble _tmp54_ = 0.0;
			gdouble _tmp55_ = 0.0;
			GdkPixbuf* shaved_pixbuf = NULL;
			GdkPixbuf* _tmp66_ = NULL;
			gint _tmp67_ = 0;
			gint _tmp68_ = 0;
			Dimensions _tmp69_ = {0};
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			Dimensions _tmp72_ = {0};
			gint _tmp73_ = 0;
			gint _tmp74_ = 0;
			GdkPixbuf* _tmp75_ = NULL;
			GdkPixbuf* _tmp76_ = NULL;
			GdkPixbuf* _tmp77_ = NULL;
			cairo_t* _tmp78_ = NULL;
			GdkPixbuf* _tmp79_ = NULL;
#line 1063 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp47_ = viewport;
#line 1063 "/home/jens/Source/shotwell/src/Printing.vala"
			scaling_to_fill_viewport (&_tmp47_, &_tmp48_);
#line 1063 "/home/jens/Source/shotwell/src/Printing.vala"
			pixbuf_scaling = _tmp48_;
#line 1064 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp49_ = photo;
#line 1064 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp50_ = pixbuf_scaling;
#line 1064 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp51_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp50_, &_inner_error_);
#line 1064 "/home/jens/Source/shotwell/src/Printing.vala"
			photo_pixbuf = _tmp51_;
#line 1064 "/home/jens/Source/shotwell/src/Printing.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7672 "Printing.c"
				goto __catch469_g_error;
			}
#line 1065 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp52_ = photo_pixbuf;
#line 1065 "/home/jens/Source/shotwell/src/Printing.vala"
			dimensions_for_pixbuf (_tmp52_, &_tmp53_);
#line 1065 "/home/jens/Source/shotwell/src/Printing.vala"
			scaled_photo_dimensions = _tmp53_;
#line 1066 "/home/jens/Source/shotwell/src/Printing.vala"
			shave_vertical = 0;
#line 1067 "/home/jens/Source/shotwell/src/Printing.vala"
			shave_horizontal = 0;
#line 1068 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp54_ = canvas_aspect_ratio;
#line 1068 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp55_ = photo_aspect_ratio;
#line 1068 "/home/jens/Source/shotwell/src/Printing.vala"
			if (_tmp54_ < _tmp55_) {
#line 7691 "Printing.c"
				Dimensions _tmp56_ = {0};
				gint _tmp57_ = 0;
				Dimensions _tmp58_ = {0};
				gint _tmp59_ = 0;
				gdouble _tmp60_ = 0.0;
#line 1069 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp56_ = scaled_photo_dimensions;
#line 1069 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp57_ = _tmp56_.width;
#line 1069 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp58_ = scaled_photo_dimensions;
#line 1069 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp59_ = _tmp58_.height;
#line 1069 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp60_ = canvas_aspect_ratio;
#line 1069 "/home/jens/Source/shotwell/src/Printing.vala"
				shave_vertical = (gint) ((_tmp57_ - (_tmp59_ * _tmp60_)) / 2.0);
#line 7709 "Printing.c"
			} else {
				Dimensions _tmp61_ = {0};
				gint _tmp62_ = 0;
				Dimensions _tmp63_ = {0};
				gint _tmp64_ = 0;
				gdouble _tmp65_ = 0.0;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp61_ = scaled_photo_dimensions;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp62_ = _tmp61_.height;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp63_ = scaled_photo_dimensions;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp64_ = _tmp63_.width;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
				_tmp65_ = canvas_aspect_ratio;
#line 1071 "/home/jens/Source/shotwell/src/Printing.vala"
				shave_horizontal = (gint) ((_tmp62_ - (_tmp64_ * (1.0 / _tmp65_))) / 2.0);
#line 7728 "Printing.c"
			}
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp66_ = photo_pixbuf;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp67_ = shave_vertical;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp68_ = shave_horizontal;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp69_ = scaled_photo_dimensions;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp70_ = _tmp69_.width;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp71_ = shave_vertical;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp72_ = scaled_photo_dimensions;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp73_ = _tmp72_.height;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp74_ = shave_horizontal;
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp75_ = gdk_pixbuf_new_subpixbuf (_tmp66_, _tmp67_, _tmp68_, _tmp70_ - (2 * _tmp71_), _tmp73_ - (2 * _tmp74_));
#line 1073 "/home/jens/Source/shotwell/src/Printing.vala"
			shaved_pixbuf = _tmp75_;
#line 1075 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp76_ = shaved_pixbuf;
#line 1075 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp77_ = scaling_perform_on_pixbuf (&pixbuf_scaling, _tmp76_, GDK_INTERP_HYPER, TRUE);
#line 1075 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (photo_pixbuf);
#line 1075 "/home/jens/Source/shotwell/src/Printing.vala"
			photo_pixbuf = _tmp77_;
#line 1076 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp78_ = dc;
#line 1076 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp79_ = photo_pixbuf;
#line 1076 "/home/jens/Source/shotwell/src/Printing.vala"
			gdk_cairo_set_source_pixbuf (_tmp78_, _tmp79_, 0.0, 0.0);
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (shaved_pixbuf);
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (photo_pixbuf);
#line 7770 "Printing.c"
		} else {
			Scaling pixbuf_scaling = {0};
			Dimensions _tmp80_ = {0};
			Scaling _tmp81_ = {0};
			GdkPixbuf* photo_pixbuf = NULL;
			Photo* _tmp82_ = NULL;
			Scaling _tmp83_ = {0};
			GdkPixbuf* _tmp84_ = NULL;
			GdkPixbuf* _tmp85_ = NULL;
			GdkPixbuf* _tmp86_ = NULL;
			cairo_t* _tmp87_ = NULL;
			GdkPixbuf* _tmp88_ = NULL;
#line 1078 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp80_ = viewport;
#line 1078 "/home/jens/Source/shotwell/src/Printing.vala"
			scaling_for_viewport (&_tmp80_, TRUE, &_tmp81_);
#line 1078 "/home/jens/Source/shotwell/src/Printing.vala"
			pixbuf_scaling = _tmp81_;
#line 1079 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp82_ = photo;
#line 1079 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp83_ = pixbuf_scaling;
#line 1079 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp84_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp83_, &_inner_error_);
#line 1079 "/home/jens/Source/shotwell/src/Printing.vala"
			photo_pixbuf = _tmp84_;
#line 1079 "/home/jens/Source/shotwell/src/Printing.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7799 "Printing.c"
				goto __catch469_g_error;
			}
#line 1080 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp85_ = photo_pixbuf;
#line 1080 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp86_ = scaling_perform_on_pixbuf (&pixbuf_scaling, _tmp85_, GDK_INTERP_HYPER, TRUE);
#line 1080 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (photo_pixbuf);
#line 1080 "/home/jens/Source/shotwell/src/Printing.vala"
			photo_pixbuf = _tmp86_;
#line 1081 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp87_ = dc;
#line 1081 "/home/jens/Source/shotwell/src/Printing.vala"
			_tmp88_ = photo_pixbuf;
#line 1081 "/home/jens/Source/shotwell/src/Printing.vala"
			gdk_cairo_set_source_pixbuf (_tmp87_, _tmp88_, 0.0, 0.0);
#line 1062 "/home/jens/Source/shotwell/src/Printing.vala"
			_g_object_unref0 (photo_pixbuf);
#line 7818 "Printing.c"
		}
#line 1083 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp89_ = dc;
#line 1083 "/home/jens/Source/shotwell/src/Printing.vala"
		cairo_paint (_tmp89_);
#line 7824 "Printing.c"
	}
	goto __finally469;
	__catch469_g_error:
	{
		GError* e = NULL;
		PrintJob* _tmp90_ = NULL;
		const gchar* _tmp91_ = NULL;
		GError* _tmp92_ = NULL;
		const gchar* _tmp93_ = NULL;
		gchar* _tmp94_ = NULL;
		gchar* _tmp95_ = NULL;
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
		e = _inner_error_;
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
		_inner_error_ = NULL;
#line 1086 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp90_ = job;
#line 1086 "/home/jens/Source/shotwell/src/Printing.vala"
		gtk_print_operation_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, gtk_print_operation_get_type (), GtkPrintOperation));
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp91_ = _ ("Unable to print photo:\n\n%s");
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp92_ = e;
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp93_ = _tmp92_->message;
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp94_ = g_strdup_printf (_tmp91_, _tmp93_);
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		_tmp95_ = _tmp94_;
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		app_window_error_message (_tmp95_, NULL);
#line 1087 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_free0 (_tmp95_);
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
		_g_error_free0 (e);
#line 7860 "Printing.c"
	}
	__finally469:
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
		_cairo_destroy0 (dc);
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
		g_clear_error (&_inner_error_);
#line 1061 "/home/jens/Source/shotwell/src/Printing.vala"
		return;
#line 7873 "Printing.c"
	}
#line 1089 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp96_ = dc;
#line 1089 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_restore (_tmp96_);
#line 1030 "/home/jens/Source/shotwell/src/Printing.vala"
	_cairo_destroy0 (dc);
#line 7881 "Printing.c"
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 7888 "Printing.c"
}


static void print_manager_add_title_to_canvas (PrintManager* self, gdouble x, gdouble y, const gchar* title, PrintJob* job, GtkPrintContext* job_context) {
	cairo_t* dc = NULL;
	GtkPrintContext* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	gdouble dpi = 0.0;
	PrintJob* _tmp3_ = NULL;
	PrintSettings* _tmp4_ = NULL;
	PrintSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	PangoFontDescription* title_font_description = NULL;
	PrintJob* _tmp8_ = NULL;
	PrintSettings* _tmp9_ = NULL;
	PrintSettings* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	PangoFontDescription* _tmp13_ = NULL;
	PangoFontDescription* _tmp14_ = NULL;
	PangoLayout* title_layout = NULL;
	PangoLayout* _tmp15_ = NULL;
	PangoContext* context = NULL;
	PangoContext* _tmp16_ = NULL;
	PangoContext* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gint title_width = 0;
	gint title_height = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gdouble tx = 0.0;
	gdouble _tmp21_ = 0.0;
	gdouble ty = 0.0;
	gdouble _tmp22_ = 0.0;
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (title != NULL);
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_JOB (job));
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (GTK_IS_PRINT_CONTEXT (job_context));
#line 1093 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = job_context;
#line 1093 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
#line 1093 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = _cairo_reference0 (_tmp1_);
#line 1093 "/home/jens/Source/shotwell/src/Printing.vala"
	dc = _tmp2_;
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp3_ = job;
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp4_ = print_job_get_local_settings (_tmp3_);
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp5_ = _tmp4_;
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp6_ = print_settings_get_content_ppi (_tmp5_);
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp7_ = (gdouble) _tmp6_;
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp5_);
#line 1094 "/home/jens/Source/shotwell/src/Printing.vala"
	dpi = _tmp7_;
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp8_ = job;
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp9_ = print_job_get_local_settings (_tmp8_);
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp10_ = _tmp9_;
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp11_ = print_settings_get_print_titles_font (_tmp10_);
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp12_ = _tmp11_;
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp13_ = pango_font_description_from_string (_tmp12_);
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp14_ = _tmp13_;
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_free0 (_tmp12_);
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (_tmp10_);
#line 1095 "/home/jens/Source/shotwell/src/Printing.vala"
	title_font_description = _tmp14_;
#line 1096 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp15_ = pango_cairo_create_layout (dc);
#line 1096 "/home/jens/Source/shotwell/src/Printing.vala"
	title_layout = _tmp15_;
#line 1097 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp16_ = pango_layout_get_context (title_layout);
#line 1097 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp17_ = _g_object_ref0 (_tmp16_);
#line 1097 "/home/jens/Source/shotwell/src/Printing.vala"
	context = _tmp17_;
#line 1098 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_cairo_context_set_resolution (context, dpi);
#line 1099 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_layout_set_font_description (title_layout, title_font_description);
#line 1100 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp18_ = title;
#line 1100 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_layout_set_text (title_layout, _tmp18_, -1);
#line 1102 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_layout_get_pixel_size (title_layout, &_tmp19_, &_tmp20_);
#line 1102 "/home/jens/Source/shotwell/src/Printing.vala"
	title_width = _tmp19_;
#line 1102 "/home/jens/Source/shotwell/src/Printing.vala"
	title_height = _tmp20_;
#line 1103 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp21_ = x;
#line 1103 "/home/jens/Source/shotwell/src/Printing.vala"
	tx = (dpi * _tmp21_) - (title_width / 2);
#line 1104 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp22_ = y;
#line 1104 "/home/jens/Source/shotwell/src/Printing.vala"
	ty = (dpi * _tmp22_) - title_height;
#line 1107 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_rectangle (dc, tx - 10, ty + 2, (gdouble) (title_width + 20), (gdouble) title_height);
#line 1108 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_set_source_rgba (dc, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
#line 1109 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_set_line_width (dc, (gdouble) 2);
#line 1110 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_stroke_preserve (dc);
#line 1111 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_set_source_rgba (dc, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.5);
#line 1112 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_fill (dc);
#line 1113 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_set_source_rgba (dc, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
#line 1115 "/home/jens/Source/shotwell/src/Printing.vala"
	cairo_move_to (dc, tx, ty + 2);
#line 1116 "/home/jens/Source/shotwell/src/Printing.vala"
	pango_cairo_show_layout (dc, title_layout);
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (context);
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (title_layout);
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	__vala_PangoFontDescription_free0 (title_font_description);
#line 1092 "/home/jens/Source/shotwell/src/Printing.vala"
	_cairo_destroy0 (dc);
#line 8033 "Printing.c"
}


static gboolean print_manager_are_approximately_equal (PrintManager* self, gdouble val1, gdouble val2) {
	gboolean result = FALSE;
	gdouble accept_err = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
#line 1119 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_MANAGER (self), FALSE);
#line 1120 "/home/jens/Source/shotwell/src/Printing.vala"
	accept_err = 0.005;
#line 1121 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = val1;
#line 1121 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = val2;
#line 1121 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = fabs (_tmp0_ - _tmp1_);
#line 1121 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp2_ <= accept_err;
#line 1121 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 8057 "Printing.c"
}


PrintSettings* print_manager_get_global_settings (PrintManager* self) {
	PrintSettings* result = NULL;
	PrintSettings* _tmp0_ = NULL;
	PrintSettings* _tmp1_ = NULL;
#line 1124 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (IS_PRINT_MANAGER (self), NULL);
#line 1125 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = self->priv->settings;
#line 1125 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _print_settings_ref0 (_tmp0_);
#line 1125 "/home/jens/Source/shotwell/src/Printing.vala"
	result = _tmp1_;
#line 1125 "/home/jens/Source/shotwell/src/Printing.vala"
	return result;
#line 8075 "Printing.c"
}


void print_manager_set_global_settings (PrintManager* self, PrintSettings* settings) {
	PrintSettings* _tmp0_ = NULL;
	PrintSettings* _tmp1_ = NULL;
	PrintSettings* _tmp2_ = NULL;
#line 1128 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_MANAGER (self));
#line 1128 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (IS_PRINT_SETTINGS (settings));
#line 1129 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp0_ = settings;
#line 1129 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp1_ = _print_settings_ref0 (_tmp0_);
#line 1129 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 1129 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->settings = _tmp1_;
#line 1130 "/home/jens/Source/shotwell/src/Printing.vala"
	_tmp2_ = settings;
#line 1130 "/home/jens/Source/shotwell/src/Printing.vala"
	print_settings_save (_tmp2_);
#line 8099 "Printing.c"
}


static void value_print_manager_init (GValue* value) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	value->data[0].v_pointer = NULL;
#line 8106 "Printing.c"
}


static void value_print_manager_free_value (GValue* value) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (value->data[0].v_pointer) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_unref (value->data[0].v_pointer);
#line 8115 "Printing.c"
	}
}


static void value_print_manager_copy_value (const GValue* src_value, GValue* dest_value) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (src_value->data[0].v_pointer) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = print_manager_ref (src_value->data[0].v_pointer);
#line 8125 "Printing.c"
	} else {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		dest_value->data[0].v_pointer = NULL;
#line 8129 "Printing.c"
	}
}


static gpointer value_print_manager_peek_pointer (const GValue* value) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 8137 "Printing.c"
}


static gchar* value_print_manager_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (collect_values[0].v_pointer) {
#line 8144 "Printing.c"
		PrintManager* object;
		object = collect_values[0].v_pointer;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		if (object->parent_instance.g_class == NULL) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8151 "Printing.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8155 "Printing.c"
		}
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = print_manager_ref (object);
#line 8159 "Printing.c"
	} else {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 8163 "Printing.c"
	}
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 8167 "Printing.c"
}


static gchar* value_print_manager_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PrintManager** object_p;
	object_p = collect_values[0].v_pointer;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!object_p) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 8178 "Printing.c"
	}
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (!value->data[0].v_pointer) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = NULL;
#line 8184 "Printing.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = value->data[0].v_pointer;
#line 8188 "Printing.c"
	} else {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		*object_p = print_manager_ref (value->data[0].v_pointer);
#line 8192 "Printing.c"
	}
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	return NULL;
#line 8196 "Printing.c"
}


GParamSpec* param_spec_print_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPrintManager* spec;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PRINT_MANAGER), NULL);
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	return G_PARAM_SPEC (spec);
#line 8210 "Printing.c"
}


gpointer value_get_print_manager (const GValue* value) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER), NULL);
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	return value->data[0].v_pointer;
#line 8219 "Printing.c"
}


void value_set_print_manager (GValue* value, gpointer v_object) {
	PrintManager* old;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER));
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_MANAGER));
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_ref (value->data[0].v_pointer);
#line 8239 "Printing.c"
	} else {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 8243 "Printing.c"
	}
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_unref (old);
#line 8249 "Printing.c"
	}
}


void value_take_print_manager (GValue* value, gpointer v_object) {
	PrintManager* old;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER));
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	old = value->data[0].v_pointer;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (v_object) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_MANAGER));
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = v_object;
#line 8268 "Printing.c"
	} else {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		value->data[0].v_pointer = NULL;
#line 8272 "Printing.c"
	}
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (old) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		print_manager_unref (old);
#line 8278 "Printing.c"
	}
}


static void print_manager_class_init (PrintManagerClass * klass) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	print_manager_parent_class = g_type_class_peek_parent (klass);
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	((PrintManagerClass *) klass)->finalize = print_manager_finalize;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	g_type_class_add_private (klass, sizeof (PrintManagerPrivate));
#line 8290 "Printing.c"
}


static void print_manager_instance_init (PrintManager * self) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv = PRINT_MANAGER_GET_PRIVATE (self);
#line 779 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->progress_dialog = NULL;
#line 780 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->cancellable = NULL;
#line 781 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->standard_sizes = NULL;
#line 781 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->standard_sizes_length1 = 0;
#line 781 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->_standard_sizes_size_ = self->priv->standard_sizes_length1;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	self->ref_count = 1;
#line 8309 "Printing.c"
}


static void print_manager_finalize (PrintManager* obj) {
	PrintManager * self;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_MANAGER, PrintManager);
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	g_signal_handlers_destroy (self);
#line 776 "/home/jens/Source/shotwell/src/Printing.vala"
	_print_settings_unref0 (self->priv->settings);
#line 777 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->user_page_setup);
#line 778 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->custom_tab);
#line 779 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 780 "/home/jens/Source/shotwell/src/Printing.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 781 "/home/jens/Source/shotwell/src/Printing.vala"
	self->priv->standard_sizes = (_vala_array_free (self->priv->standard_sizes, self->priv->standard_sizes_length1, (GDestroyNotify) standard_print_size_unref), NULL);
#line 8331 "Printing.c"
}


GType print_manager_get_type (void) {
	static volatile gsize print_manager_type_id__volatile = 0;
	if (g_once_init_enter (&print_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_print_manager_init, value_print_manager_free_value, value_print_manager_copy_value, value_print_manager_peek_pointer, "p", value_print_manager_collect_value, "p", value_print_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PrintManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintManager), 0, (GInstanceInitFunc) print_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType print_manager_type_id;
		print_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PrintManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&print_manager_type_id__volatile, print_manager_type_id);
	}
	return print_manager_type_id__volatile;
}


gpointer print_manager_ref (gpointer instance) {
	PrintManager* self;
	self = instance;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	g_atomic_int_inc (&self->ref_count);
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	return instance;
#line 8356 "Printing.c"
}


void print_manager_unref (gpointer instance) {
	PrintManager* self;
	self = instance;
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		PRINT_MANAGER_GET_CLASS (self)->finalize (self);
#line 771 "/home/jens/Source/shotwell/src/Printing.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8369 "Printing.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



