/* SourceCollection.c generated by valac 0.34.7, the Vala compiler
 * generated from SourceCollection.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define SOURCE_COLLECTION_TYPE_DESTROY_COUNTER (source_collection_destroy_counter_get_type ())
#define SOURCE_COLLECTION_DESTROY_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter))
#define SOURCE_COLLECTION_DESTROY_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounterClass))
#define SOURCE_COLLECTION_IS_DESTROY_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER))
#define SOURCE_COLLECTION_IS_DESTROY_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER))
#define SOURCE_COLLECTION_DESTROY_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounterClass))

typedef struct _SourceCollectionDestroyCounter SourceCollectionDestroyCounter;
typedef struct _SourceCollectionDestroyCounterClass SourceCollectionDestroyCounterClass;
typedef struct _SourceCollectionDestroyCounterPrivate SourceCollectionDestroyCounterPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _SourceCollectionPrivate {
	GeeMultiMap* backlinks;
};

typedef gboolean (*MarkedAction) (DataObject* object, GObject* user, void* user_data);
struct _SourceCollectionDestroyCounter {
	GObject parent_instance;
	SourceCollectionDestroyCounterPrivate * priv;
	Marker* remove_marker;
	GeeArrayList* notify_list;
	GeeArrayList* not_removed;
};

struct _SourceCollectionDestroyCounterClass {
	GObjectClass parent_class;
};


static gpointer source_collection_parent_class = NULL;
static gpointer source_collection_destroy_counter_parent_class = NULL;

gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
GType marker_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_backlink (GValue* value, gpointer v_object);
void value_take_source_backlink (GValue* value, gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
#define SOURCE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SOURCE_COLLECTION, SourceCollectionPrivate))
enum  {
	SOURCE_COLLECTION_DUMMY_PROPERTY
};
SourceCollection* source_collection_construct (GType object_type, const gchar* name);
DataCollection* data_collection_new (const gchar* name);
DataCollection* data_collection_construct (GType object_type, const gchar* name);
gboolean source_collection_holds_type_of_source (SourceCollection* self, DataSource* source);
static gboolean source_collection_real_holds_type_of_source (SourceCollection* self, DataSource* source);
void source_collection_notify_items_unlinking (SourceCollection* self, GeeCollection* unlinking);
static void source_collection_real_notify_items_unlinking (SourceCollection* self, GeeCollection* unlinking);
void source_collection_notify_items_relinked (SourceCollection* self, GeeCollection* relinked);
static void source_collection_real_notify_items_relinked (SourceCollection* self, GeeCollection* relinked);
void source_collection_notify_item_destroyed (SourceCollection* self, DataSource* source);
static void source_collection_real_notify_item_destroyed (SourceCollection* self, DataSource* source);
void source_collection_notify_items_destroyed (SourceCollection* self, GeeCollection* destroyed);
static void source_collection_real_notify_items_destroyed (SourceCollection* self, GeeCollection* destroyed);
void source_collection_notify_unlinked_destroyed (SourceCollection* self, DataSource* unlinked);
static void source_collection_real_notify_unlinked_destroyed (SourceCollection* self, DataSource* unlinked);
void source_collection_notify_backlink_removed (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
static void source_collection_real_notify_backlink_removed (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
static gboolean source_collection_real_valid_type (DataCollection* base, DataObject* object);
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
gint source_collection_destroy_marked (SourceCollection* self, Marker* marker, gboolean delete_backing, ProgressMonitor monitor, void* monitor_target, GeeList* not_removed);
static GType source_collection_destroy_counter_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
Marker* data_collection_start_marking (DataCollection* self);
static SourceCollectionDestroyCounter* source_collection_destroy_counter_new (Marker* remove_marker);
static SourceCollectionDestroyCounter* source_collection_destroy_counter_construct (GType object_type, Marker* remove_marker);
void data_collection_act_on_marked (DataCollection* self, Marker* m, MarkedAction action, void* action_target, ProgressMonitor monitor, void* monitor_target, GObject* user);
static gboolean source_collection_destroy_and_delete_source (SourceCollection* self, DataObject* object, GObject* user);
static gboolean _source_collection_destroy_and_delete_source_marked_action (DataObject* object, GObject* user, gpointer self);
static gboolean source_collection_destroy_source (SourceCollection* self, DataObject* object, GObject* user);
static gboolean _source_collection_destroy_source_marked_action (DataObject* object, GObject* user, gpointer self);
void data_collection_remove_marked (DataCollection* self, Marker* m);
gboolean data_source_internal_delete_backing (DataSource* self, GError** error);
void data_source_internal_mark_for_destroy (DataSource* self);
void data_source_destroy (DataSource* self);
void marker_mark (Marker* self, DataObject* object);
void source_collection_internal_backlink_set (SourceCollection* self, DataSource* source, SourceBacklink* backlink);
guint source_backlink_hash_func (SourceBacklink* backlink);
static guint _source_backlink_hash_func_gee_hash_data_func (gconstpointer v, gpointer self);
gboolean source_backlink_equal_func (SourceBacklink* alink, SourceBacklink* blink);
static gboolean _source_backlink_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
void source_collection_internal_backlink_removed (SourceCollection* self, DataSource* source, SourceBacklink* backlink);
gboolean source_collection_has_backlink (SourceCollection* self, SourceBacklink* backlink);
static gboolean source_collection_real_has_backlink (SourceCollection* self, SourceBacklink* backlink);
GeeCollection* source_collection_unlink_marked (SourceCollection* self, Marker* marker, ProgressMonitor monitor, void* monitor_target);
static gboolean source_collection_prepare_for_unlink (SourceCollection* self, DataObject* object, GObject* user);
static gboolean _source_collection_prepare_for_unlink_marked_action (DataObject* object, GObject* user, gpointer self);
Marker* data_collection_mark_many (DataCollection* self, GeeCollection* objects);
void data_source_notify_unlinking (DataSource* self, SourceCollection* collection);
void source_collection_relink (SourceCollection* self, DataSource* source);
void data_source_notify_relinking (DataSource* self, SourceCollection* collection);
gboolean data_collection_add (DataCollection* self, DataObject* object);
GeeCollection* data_collection_get_singleton (DataObject* object);
void data_source_notify_relinked (DataSource* self);
void source_collection_relink_many (SourceCollection* self, GeeCollection* relink);
GeeCollection* data_collection_add_many (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
void source_collection_remove_backlink (SourceCollection* self, SourceBacklink* backlink);
static void source_collection_real_remove_backlink (SourceCollection* self, SourceBacklink* backlink);
gboolean data_source_remove_backlink (DataSource* self, SourceBacklink* backlink);
static void source_collection_real_items_unlinking (SourceCollection* self, GeeCollection* unlinking);
static void source_collection_real_items_relinked (SourceCollection* self, GeeCollection* relinked);
static void source_collection_real_item_destroyed (SourceCollection* self, DataSource* source);
static void source_collection_real_items_destroyed (SourceCollection* self, GeeCollection* destroyed);
static void source_collection_real_unlinked_destroyed (SourceCollection* self, DataSource* source);
static void source_collection_real_backlink_removed (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
static void g_cclosure_user_marshal_VOID__SOURCE_BACKLINK_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
enum  {
	SOURCE_COLLECTION_DESTROY_COUNTER_DUMMY_PROPERTY
};
static void source_collection_destroy_counter_finalize (GObject* obj);
static void source_collection_finalize (DataCollection* obj);


SourceCollection* source_collection_construct (GType object_type, const gchar* name) {
	SourceCollection* self = NULL;
	const gchar* _tmp0_ = NULL;
#line 50 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 51 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = name;
#line 51 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self = (SourceCollection*) data_collection_construct (object_type, _tmp0_);
#line 50 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return self;
#line 340 "SourceCollection.c"
}


static gboolean source_collection_real_holds_type_of_source (SourceCollection* self, DataSource* source) {
	gboolean _tmp0_ = FALSE;
#line 54 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_critical ("Type `%s' does not implement abstract method `source_collection_holds_type_of_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 54 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return _tmp0_;
#line 350 "SourceCollection.c"
}


gboolean source_collection_holds_type_of_source (SourceCollection* self, DataSource* source) {
#line 54 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
#line 54 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return SOURCE_COLLECTION_GET_CLASS (self)->holds_type_of_source (self, source);
#line 359 "SourceCollection.c"
}


static void source_collection_real_notify_items_unlinking (SourceCollection* self, GeeCollection* unlinking) {
	GeeCollection* _tmp0_ = NULL;
#line 56 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (unlinking));
#line 57 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = unlinking;
#line 57 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_emit_by_name (self, "items-unlinking", _tmp0_);
#line 371 "SourceCollection.c"
}


void source_collection_notify_items_unlinking (SourceCollection* self, GeeCollection* unlinking) {
#line 56 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 56 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	SOURCE_COLLECTION_GET_CLASS (self)->notify_items_unlinking (self, unlinking);
#line 380 "SourceCollection.c"
}


static void source_collection_real_notify_items_relinked (SourceCollection* self, GeeCollection* relinked) {
	GeeCollection* _tmp0_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (relinked));
#line 61 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = relinked;
#line 61 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_emit_by_name (self, "items-relinked", _tmp0_);
#line 392 "SourceCollection.c"
}


void source_collection_notify_items_relinked (SourceCollection* self, GeeCollection* relinked) {
#line 60 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 60 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	SOURCE_COLLECTION_GET_CLASS (self)->notify_items_relinked (self, relinked);
#line 401 "SourceCollection.c"
}


static void source_collection_real_notify_item_destroyed (SourceCollection* self, DataSource* source) {
	DataSource* _tmp0_ = NULL;
#line 64 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 65 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = source;
#line 65 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_emit_by_name (self, "item-destroyed", _tmp0_);
#line 413 "SourceCollection.c"
}


void source_collection_notify_item_destroyed (SourceCollection* self, DataSource* source) {
#line 64 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 64 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	SOURCE_COLLECTION_GET_CLASS (self)->notify_item_destroyed (self, source);
#line 422 "SourceCollection.c"
}


static void source_collection_real_notify_items_destroyed (SourceCollection* self, GeeCollection* destroyed) {
	GeeCollection* _tmp0_ = NULL;
#line 68 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (destroyed));
#line 69 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = destroyed;
#line 69 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_emit_by_name (self, "items-destroyed", _tmp0_);
#line 434 "SourceCollection.c"
}


void source_collection_notify_items_destroyed (SourceCollection* self, GeeCollection* destroyed) {
#line 68 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 68 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	SOURCE_COLLECTION_GET_CLASS (self)->notify_items_destroyed (self, destroyed);
#line 443 "SourceCollection.c"
}


static void source_collection_real_notify_unlinked_destroyed (SourceCollection* self, DataSource* unlinked) {
	DataSource* _tmp0_ = NULL;
#line 73 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (unlinked));
#line 74 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = unlinked;
#line 74 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_emit_by_name (self, "unlinked-destroyed", _tmp0_);
#line 455 "SourceCollection.c"
}


void source_collection_notify_unlinked_destroyed (SourceCollection* self, DataSource* unlinked) {
#line 73 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 73 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	SOURCE_COLLECTION_GET_CLASS (self)->notify_unlinked_destroyed (self, unlinked);
#line 464 "SourceCollection.c"
}


static void source_collection_real_notify_backlink_removed (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources) {
	SourceBacklink* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
#line 77 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
#line 77 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 79 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = backlink;
#line 79 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = sources;
#line 79 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_emit_by_name (self, "backlink-removed", _tmp0_, _tmp1_);
#line 481 "SourceCollection.c"
}


void source_collection_notify_backlink_removed (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources) {
#line 77 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 77 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	SOURCE_COLLECTION_GET_CLASS (self)->notify_backlink_removed (self, backlink, sources);
#line 490 "SourceCollection.c"
}


static gboolean source_collection_real_valid_type (DataCollection* base, DataObject* object) {
	SourceCollection * self;
	gboolean result = FALSE;
	DataObject* _tmp0_ = NULL;
#line 82 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SOURCE_COLLECTION, SourceCollection);
#line 82 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 83 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = object;
#line 83 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_DATA_SOURCE);
#line 83 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 508 "SourceCollection.c"
}


static gboolean _source_collection_destroy_and_delete_source_marked_action (DataObject* object, GObject* user, gpointer self) {
	gboolean result;
	result = source_collection_destroy_and_delete_source ((SourceCollection*) self, object, user);
#line 93 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 517 "SourceCollection.c"
}


static gboolean _source_collection_destroy_source_marked_action (DataObject* object, GObject* user, gpointer self) {
	gboolean result;
	result = source_collection_destroy_source ((SourceCollection*) self, object, user);
#line 95 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 526 "SourceCollection.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return self ? g_object_ref (self) : NULL;
#line 533 "SourceCollection.c"
}


gint source_collection_destroy_marked (SourceCollection* self, Marker* marker, gboolean delete_backing, ProgressMonitor monitor, void* monitor_target, GeeList* not_removed) {
	gint result = 0;
	SourceCollectionDestroyCounter* counter = NULL;
	Marker* _tmp0_ = NULL;
	Marker* _tmp1_ = NULL;
	SourceCollectionDestroyCounter* _tmp2_ = NULL;
	SourceCollectionDestroyCounter* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	SourceCollectionDestroyCounter* _tmp24_ = NULL;
	GeeArrayList* _tmp25_ = NULL;
	SourceCollectionDestroyCounter* _tmp26_ = NULL;
	Marker* _tmp27_ = NULL;
	GeeList* _tmp28_ = NULL;
	SourceCollectionDestroyCounter* _tmp32_ = NULL;
	GeeArrayList* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
#line 88 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), 0);
#line 88 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_MARKER (marker), 0);
#line 88 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail ((not_removed == NULL) || GEE_IS_LIST (not_removed), 0);
#line 90 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 90 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = _tmp0_;
#line 90 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2_ = source_collection_destroy_counter_new (_tmp1_);
#line 90 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp3_ = _tmp2_;
#line 90 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (_tmp1_);
#line 90 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	counter = _tmp3_;
#line 92 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp4_ = delete_backing;
#line 92 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (_tmp4_) {
#line 576 "SourceCollection.c"
		Marker* _tmp5_ = NULL;
		ProgressMonitor _tmp6_ = NULL;
		void* _tmp6__target = NULL;
		SourceCollectionDestroyCounter* _tmp7_ = NULL;
#line 93 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp5_ = marker;
#line 93 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp6_ = monitor;
#line 93 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp6__target = monitor_target;
#line 93 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp7_ = counter;
#line 93 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp5_, _source_collection_destroy_and_delete_source_marked_action, self, _tmp6_, _tmp6__target, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, G_TYPE_OBJECT, GObject));
#line 591 "SourceCollection.c"
	} else {
		Marker* _tmp8_ = NULL;
		ProgressMonitor _tmp9_ = NULL;
		void* _tmp9__target = NULL;
		SourceCollectionDestroyCounter* _tmp10_ = NULL;
#line 95 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp8_ = marker;
#line 95 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp9_ = monitor;
#line 95 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp9__target = monitor_target;
#line 95 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp10_ = counter;
#line 95 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp8_, _source_collection_destroy_source_marked_action, self, _tmp9_, _tmp9__target, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_OBJECT, GObject));
#line 607 "SourceCollection.c"
	}
	{
		GeeArrayList* _source_list = NULL;
		SourceCollectionDestroyCounter* _tmp11_ = NULL;
		GeeArrayList* _tmp12_ = NULL;
		GeeArrayList* _tmp13_ = NULL;
		gint _source_size = 0;
		GeeArrayList* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _source_index = 0;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp11_ = counter;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp12_ = _tmp11_->notify_list;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_list = _tmp13_;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp14_ = _source_list;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp15_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp16_ = _tmp15_;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_size = _tmp16_;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_index = -1;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		while (TRUE) {
#line 639 "SourceCollection.c"
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			DataSource* source = NULL;
			GeeArrayList* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gpointer _tmp22_ = NULL;
			DataSource* _tmp23_ = NULL;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp17_ = _source_index;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_source_index = _tmp17_ + 1;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp18_ = _source_index;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp19_ = _source_size;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			if (!(_tmp18_ < _tmp19_)) {
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
				break;
#line 660 "SourceCollection.c"
			}
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp20_ = _source_list;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp21_ = _source_index;
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp22_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp21_);
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			source = (DataSource*) _tmp22_;
#line 99 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp23_ = source;
#line 99 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			source_collection_notify_item_destroyed (self, _tmp23_);
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_g_object_unref0 (source);
#line 676 "SourceCollection.c"
		}
#line 98 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_g_object_unref0 (_source_list);
#line 680 "SourceCollection.c"
	}
#line 100 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp24_ = counter;
#line 100 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp25_ = _tmp24_->notify_list;
#line 100 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_notify_items_destroyed (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection));
#line 103 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp26_ = counter;
#line 103 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp27_ = _tmp26_->remove_marker;
#line 103 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp27_);
#line 105 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp28_ = not_removed;
#line 105 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (NULL != _tmp28_) {
#line 698 "SourceCollection.c"
		GeeList* _tmp29_ = NULL;
		SourceCollectionDestroyCounter* _tmp30_ = NULL;
		GeeArrayList* _tmp31_ = NULL;
#line 106 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp29_ = not_removed;
#line 106 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp30_ = counter;
#line 106 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp31_ = _tmp30_->not_removed;
#line 106 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_COLLECTION, GeeCollection));
#line 710 "SourceCollection.c"
	}
#line 109 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp32_ = counter;
#line 109 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp33_ = _tmp32_->not_removed;
#line 109 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp34_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 109 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp35_ = _tmp34_;
#line 109 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	result = _tmp35_;
#line 109 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (counter);
#line 109 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 726 "SourceCollection.c"
}


static gboolean source_collection_destroy_and_delete_source (SourceCollection* self, DataObject* object, GObject* user) {
	gboolean result = FALSE;
	gboolean success = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp10_ = FALSE;
	DataObject* _tmp11_ = NULL;
	GObject* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GError * _inner_error_ = NULL;
#line 112 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
#line 112 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 112 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail ((user == NULL) || G_IS_OBJECT (user), FALSE);
#line 113 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	success = FALSE;
#line 748 "SourceCollection.c"
	{
		gboolean _tmp0_ = FALSE;
		DataObject* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 115 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp1_ = object;
#line 115 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp2_ = data_source_internal_delete_backing (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_SOURCE, DataSource), &_inner_error_);
#line 115 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp0_ = _tmp2_;
#line 115 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 761 "SourceCollection.c"
			goto __catch49_g_error;
		}
#line 115 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		success = _tmp0_;
#line 766 "SourceCollection.c"
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* err = NULL;
#line 114 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		err = _inner_error_;
#line 114 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_inner_error_ = NULL;
#line 117 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		success = FALSE;
#line 114 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_g_error_free0 (err);
#line 780 "SourceCollection.c"
	}
	__finally49:
#line 114 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 785 "SourceCollection.c"
		gboolean _tmp3_ = FALSE;
#line 114 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 114 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		g_clear_error (&_inner_error_);
#line 114 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		return _tmp3_;
#line 793 "SourceCollection.c"
	}
#line 120 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp5_ = success;
#line 120 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (!_tmp5_) {
#line 799 "SourceCollection.c"
		DataObject* _tmp6_ = NULL;
#line 120 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp6_ = object;
#line 120 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_MEDIA_SOURCE);
#line 805 "SourceCollection.c"
	} else {
#line 120 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp4_ = FALSE;
#line 809 "SourceCollection.c"
	}
#line 120 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (_tmp4_) {
#line 813 "SourceCollection.c"
		GObject* _tmp7_ = NULL;
		GeeArrayList* _tmp8_ = NULL;
		DataObject* _tmp9_ = NULL;
#line 121 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp7_ = user;
#line 121 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter)->not_removed;
#line 121 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp9_ = object;
#line 121 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_MEDIA_SOURCE, MediaSource));
#line 825 "SourceCollection.c"
	}
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp11_ = object;
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp12_ = user;
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp13_ = source_collection_destroy_source (self, _tmp11_, _tmp12_);
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (_tmp13_) {
#line 835 "SourceCollection.c"
		gboolean _tmp14_ = FALSE;
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp14_ = success;
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp10_ = _tmp14_;
#line 841 "SourceCollection.c"
	} else {
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp10_ = FALSE;
#line 845 "SourceCollection.c"
	}
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	result = _tmp10_;
#line 124 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 851 "SourceCollection.c"
}


static gboolean source_collection_destroy_source (SourceCollection* self, DataObject* object, GObject* user) {
	gboolean result = FALSE;
	DataSource* source = NULL;
	DataObject* _tmp0_ = NULL;
	DataSource* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	Marker* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
#line 127 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
#line 127 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 127 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail ((user == NULL) || G_IS_OBJECT (user), FALSE);
#line 128 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = object;
#line 128 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_SOURCE, DataSource));
#line 128 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source = _tmp1_;
#line 130 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_source_internal_mark_for_destroy (source);
#line 131 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_source_destroy (source);
#line 133 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2_ = user;
#line 133 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter)->remove_marker;
#line 133 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	marker_mark (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_OBJECT, DataObject));
#line 134 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp4_ = user;
#line 134 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter)->notify_list;
#line 134 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), source);
#line 136 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	result = TRUE;
#line 136 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (source);
#line 136 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 898 "SourceCollection.c"
}


static guint _source_backlink_hash_func_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = source_backlink_hash_func ((SourceBacklink*) v);
#line 142 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 907 "SourceCollection.c"
}


static gboolean _source_backlink_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = source_backlink_equal_func ((SourceBacklink*) a, (SourceBacklink*) b);
#line 142 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 916 "SourceCollection.c"
}


void source_collection_internal_backlink_set (SourceCollection* self, DataSource* source, SourceBacklink* backlink) {
	GeeMultiMap* _tmp0_ = NULL;
	GeeMultiMap* _tmp2_ = NULL;
	SourceBacklink* _tmp3_ = NULL;
	DataSource* _tmp4_ = NULL;
#line 140 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 140 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 140 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
#line 141 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = self->priv->backlinks;
#line 141 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (_tmp0_ == NULL) {
#line 935 "SourceCollection.c"
		GeeHashMultiMap* _tmp1_ = NULL;
#line 142 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp1_ = gee_hash_multi_map_new (TYPE_SOURCE_BACKLINK, (GBoxedCopyFunc) source_backlink_ref, (GDestroyNotify) source_backlink_unref, TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _source_backlink_hash_func_gee_hash_data_func, NULL, NULL, _source_backlink_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 142 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_g_object_unref0 (self->priv->backlinks);
#line 142 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		self->priv->backlinks = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
#line 943 "SourceCollection.c"
	}
#line 146 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2_ = self->priv->backlinks;
#line 146 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp3_ = backlink;
#line 146 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp4_ = source;
#line 146 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	gee_multi_map_set (_tmp2_, _tmp3_, _tmp4_);
#line 953 "SourceCollection.c"
}


void source_collection_internal_backlink_removed (SourceCollection* self, DataSource* source, SourceBacklink* backlink) {
	GeeMultiMap* _tmp0_ = NULL;
	gboolean removed = FALSE;
	GeeMultiMap* _tmp1_ = NULL;
	SourceBacklink* _tmp2_ = NULL;
	DataSource* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 150 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 150 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 150 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
#line 151 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = self->priv->backlinks;
#line 151 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_vala_assert (_tmp0_ != NULL, "backlinks != null");
#line 153 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = self->priv->backlinks;
#line 153 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2_ = backlink;
#line 153 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp3_ = source;
#line 153 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp4_ = gee_multi_map_remove (_tmp1_, _tmp2_, _tmp3_);
#line 153 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	removed = _tmp4_;
#line 154 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_vala_assert (removed, "removed");
#line 986 "SourceCollection.c"
}


static gboolean source_collection_real_has_backlink (SourceCollection* self, SourceBacklink* backlink) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GeeMultiMap* _tmp1_ = NULL;
#line 157 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_BACKLINK (backlink), FALSE);
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = self->priv->backlinks;
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (_tmp1_ != NULL) {
#line 1000 "SourceCollection.c"
		GeeMultiMap* _tmp2_ = NULL;
		SourceBacklink* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp2_ = self->priv->backlinks;
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp3_ = backlink;
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp4_ = gee_multi_map_contains (_tmp2_, _tmp3_);
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp0_ = _tmp4_;
#line 1012 "SourceCollection.c"
	} else {
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp0_ = FALSE;
#line 1016 "SourceCollection.c"
	}
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	result = _tmp0_;
#line 158 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 1022 "SourceCollection.c"
}


gboolean source_collection_has_backlink (SourceCollection* self, SourceBacklink* backlink) {
#line 157 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
#line 157 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return SOURCE_COLLECTION_GET_CLASS (self)->has_backlink (self, backlink);
#line 1031 "SourceCollection.c"
}


static gboolean _source_collection_prepare_for_unlink_marked_action (DataObject* object, GObject* user, gpointer self) {
	gboolean result;
	result = source_collection_prepare_for_unlink ((SourceCollection*) self, object, user);
#line 163 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 1040 "SourceCollection.c"
}


GeeCollection* source_collection_unlink_marked (SourceCollection* self, Marker* marker, ProgressMonitor monitor, void* monitor_target) {
	GeeCollection* result = NULL;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_ = NULL;
	Marker* _tmp1_ = NULL;
	ProgressMonitor _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GeeArrayList* _tmp7_ = NULL;
	GeeArrayList* _tmp8_ = NULL;
	Marker* _tmp9_ = NULL;
	Marker* _tmp10_ = NULL;
#line 161 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), NULL);
#line 161 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_MARKER (marker), NULL);
#line 162 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 162 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	list = _tmp0_;
#line 163 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = marker;
#line 163 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2_ = monitor;
#line 163 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2__target = monitor_target;
#line 163 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp3_ = list;
#line 163 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_collection_act_on_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp1_, _source_collection_prepare_for_unlink_marked_action, self, _tmp2_, _tmp2__target, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject));
#line 165 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp4_ = list;
#line 165 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp5_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 165 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp6_ = _tmp5_;
#line 165 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (_tmp6_ == 0) {
#line 166 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		result = NULL;
#line 166 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_g_object_unref0 (list);
#line 166 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		return result;
#line 1091 "SourceCollection.c"
	}
#line 168 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp7_ = list;
#line 168 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_notify_items_unlinking (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
#line 170 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp8_ = list;
#line 170 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp9_ = data_collection_mark_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
#line 170 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp10_ = _tmp9_;
#line 170 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp10_);
#line 170 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (_tmp10_);
#line 172 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_COLLECTION, GeeCollection);
#line 172 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 1111 "SourceCollection.c"
}


static gboolean source_collection_prepare_for_unlink (SourceCollection* self, DataObject* object, GObject* user) {
	gboolean result = FALSE;
	DataSource* source = NULL;
	DataObject* _tmp0_ = NULL;
	DataSource* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
#line 175 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_SOURCE_COLLECTION (self), FALSE);
#line 175 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 175 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail ((user == NULL) || G_IS_OBJECT (user), FALSE);
#line 176 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = object;
#line 176 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_SOURCE, DataSource));
#line 176 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source = _tmp1_;
#line 178 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_source_notify_unlinking (source, self);
#line 179 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2_ = user;
#line 179 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_LIST, GeeList), GEE_TYPE_COLLECTION, GeeCollection), source);
#line 181 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	result = TRUE;
#line 181 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (source);
#line 181 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return result;
#line 1145 "SourceCollection.c"
}


void source_collection_relink (SourceCollection* self, DataSource* source) {
	DataSource* _tmp0_ = NULL;
	DataSource* _tmp1_ = NULL;
	DataSource* _tmp2_ = NULL;
	GeeCollection* _tmp3_ = NULL;
	GeeCollection* _tmp4_ = NULL;
	DataSource* _tmp5_ = NULL;
#line 184 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 184 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 185 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = source;
#line 185 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_source_notify_relinking (_tmp0_, self);
#line 187 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = source;
#line 187 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_OBJECT, DataObject));
#line 188 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2_ = source;
#line 188 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp3_ = data_collection_get_singleton (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_OBJECT, DataObject));
#line 188 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
#line 188 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_notify_items_relinked (self, _tmp4_);
#line 188 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (_tmp4_);
#line 190 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp5_ = source;
#line 190 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	data_source_notify_relinked (_tmp5_);
#line 1182 "SourceCollection.c"
}


void source_collection_relink_many (SourceCollection* self, GeeCollection* relink) {
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeeCollection* _tmp10_ = NULL;
	GeeCollection* _tmp11_ = NULL;
	GeeCollection* _tmp12_ = NULL;
	GeeCollection* _tmp13_ = NULL;
#line 193 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 193 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (relink));
#line 194 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = relink;
#line 194 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 194 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2_ = _tmp1_;
#line 194 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (_tmp2_ == 0) {
#line 195 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		return;
#line 1208 "SourceCollection.c"
	}
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp3_ = relink;
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_it = _tmp4_;
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		while (TRUE) {
#line 1222 "SourceCollection.c"
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			DataSource* source = NULL;
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			DataSource* _tmp9_ = NULL;
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp5_ = _source_it;
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp6_ = gee_iterator_next (_tmp5_);
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			if (!_tmp6_) {
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
				break;
#line 1237 "SourceCollection.c"
			}
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp7_ = _source_it;
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			source = (DataSource*) _tmp8_;
#line 198 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp9_ = source;
#line 198 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			data_source_notify_relinking (_tmp9_, self);
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_g_object_unref0 (source);
#line 1251 "SourceCollection.c"
		}
#line 197 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_g_object_unref0 (_source_it);
#line 1255 "SourceCollection.c"
	}
#line 200 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp10_ = relink;
#line 200 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp11_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp10_, NULL, NULL);
#line 200 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp12_ = _tmp11_;
#line 200 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (_tmp12_);
#line 201 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp13_ = relink;
#line 201 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_notify_items_relinked (self, _tmp13_);
#line 1269 "SourceCollection.c"
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp14_ = NULL;
		GeeIterator* _tmp15_ = NULL;
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp14_ = relink;
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp15_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ITERABLE, GeeIterable));
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_it = _tmp15_;
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		while (TRUE) {
#line 1282 "SourceCollection.c"
			GeeIterator* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			DataSource* source = NULL;
			GeeIterator* _tmp18_ = NULL;
			gpointer _tmp19_ = NULL;
			DataSource* _tmp20_ = NULL;
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp16_ = _source_it;
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp17_ = gee_iterator_next (_tmp16_);
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			if (!_tmp17_) {
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
				break;
#line 1297 "SourceCollection.c"
			}
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp18_ = _source_it;
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp19_ = gee_iterator_get (_tmp18_);
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			source = (DataSource*) _tmp19_;
#line 204 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp20_ = source;
#line 204 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			data_source_notify_relinked (_tmp20_);
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_g_object_unref0 (source);
#line 1311 "SourceCollection.c"
		}
#line 203 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_g_object_unref0 (_source_it);
#line 1315 "SourceCollection.c"
	}
}


static void source_collection_real_remove_backlink (SourceCollection* self, SourceBacklink* backlink) {
	GeeMultiMap* _tmp0_ = NULL;
	GeeArrayList* sources = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeMultiMap* _tmp3_ = NULL;
	SourceBacklink* _tmp4_ = NULL;
	GeeCollection* _tmp5_ = NULL;
	GeeCollection* _tmp6_ = NULL;
	SourceBacklink* _tmp20_ = NULL;
	GeeArrayList* _tmp21_ = NULL;
#line 207 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
#line 208 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = self->priv->backlinks;
#line 208 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (_tmp0_ == NULL) {
#line 209 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		return;
#line 1339 "SourceCollection.c"
	}
#line 212 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 212 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	sources = _tmp1_;
#line 213 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp2_ = sources;
#line 213 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp3_ = self->priv->backlinks;
#line 213 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp4_ = backlink;
#line 213 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp5_ = gee_multi_map_get (_tmp3_, _tmp4_);
#line 213 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp6_ = _tmp5_;
#line 213 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	gee_array_list_add_all (_tmp2_, _tmp6_);
#line 213 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (_tmp6_);
#line 1359 "SourceCollection.c"
	{
		GeeArrayList* _source_list = NULL;
		GeeArrayList* _tmp7_ = NULL;
		GeeArrayList* _tmp8_ = NULL;
		gint _source_size = 0;
		GeeArrayList* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _source_index = 0;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp7_ = sources;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_list = _tmp8_;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp9_ = _source_list;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp10_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_tmp11_ = _tmp10_;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_size = _tmp11_;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_source_index = -1;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		while (TRUE) {
#line 1387 "SourceCollection.c"
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			DataSource* source = NULL;
			GeeArrayList* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gpointer _tmp17_ = NULL;
			DataSource* _tmp18_ = NULL;
			SourceBacklink* _tmp19_ = NULL;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp12_ = _source_index;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_source_index = _tmp12_ + 1;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp13_ = _source_index;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp14_ = _source_size;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			if (!(_tmp13_ < _tmp14_)) {
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
				break;
#line 1409 "SourceCollection.c"
			}
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp15_ = _source_list;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp16_ = _source_index;
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp17_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp16_);
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			source = (DataSource*) _tmp17_;
#line 216 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp18_ = source;
#line 216 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_tmp19_ = backlink;
#line 216 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			data_source_remove_backlink (_tmp18_, _tmp19_);
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
			_g_object_unref0 (source);
#line 1427 "SourceCollection.c"
		}
#line 215 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		_g_object_unref0 (_source_list);
#line 1431 "SourceCollection.c"
	}
#line 218 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp20_ = backlink;
#line 218 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp21_ = sources;
#line 218 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_notify_backlink_removed (self, _tmp20_, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
#line 207 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (sources);
#line 1441 "SourceCollection.c"
}


void source_collection_remove_backlink (SourceCollection* self, SourceBacklink* backlink) {
#line 207 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_COLLECTION (self));
#line 207 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	SOURCE_COLLECTION_GET_CLASS (self)->remove_backlink (self, backlink);
#line 1450 "SourceCollection.c"
}


static void source_collection_real_items_unlinking (SourceCollection* self, GeeCollection* unlinking) {
#line 20 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (unlinking));
#line 1457 "SourceCollection.c"
}


static void source_collection_real_items_relinked (SourceCollection* self, GeeCollection* relinked) {
#line 25 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (relinked));
#line 1464 "SourceCollection.c"
}


static void source_collection_real_item_destroyed (SourceCollection* self, DataSource* source) {
#line 30 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 1471 "SourceCollection.c"
}


static void source_collection_real_items_destroyed (SourceCollection* self, GeeCollection* destroyed) {
#line 35 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (destroyed));
#line 1478 "SourceCollection.c"
}


static void source_collection_real_unlinked_destroyed (SourceCollection* self, DataSource* source) {
#line 40 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 1485 "SourceCollection.c"
}


static void source_collection_real_backlink_removed (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources) {
#line 44 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
#line 44 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 1494 "SourceCollection.c"
}


static void g_cclosure_user_marshal_VOID__SOURCE_BACKLINK_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__SOURCE_BACKLINK_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__SOURCE_BACKLINK_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_if_fail (n_param_values == 3);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		data1 = closure->data;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		data2 = param_values->data[0].v_pointer;
#line 1513 "SourceCollection.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		data1 = param_values->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
		data2 = closure->data;
#line 1519 "SourceCollection.c"
	}
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	callback = (GMarshalFunc_VOID__SOURCE_BACKLINK_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	callback (data1, value_get_source_backlink (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 1525 "SourceCollection.c"
}


static SourceCollectionDestroyCounter* source_collection_destroy_counter_construct (GType object_type, Marker* remove_marker) {
	SourceCollectionDestroyCounter * self = NULL;
	Marker* _tmp0_ = NULL;
	Marker* _tmp1_ = NULL;
#line 13 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_return_val_if_fail (IS_MARKER (remove_marker), NULL);
#line 13 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self = (SourceCollectionDestroyCounter*) g_object_new (object_type, NULL);
#line 14 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = remove_marker;
#line 14 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 14 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (self->remove_marker);
#line 14 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self->remove_marker = _tmp1_;
#line 13 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return self;
#line 1547 "SourceCollection.c"
}


static SourceCollectionDestroyCounter* source_collection_destroy_counter_new (Marker* remove_marker) {
#line 13 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	return source_collection_destroy_counter_construct (SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, remove_marker);
#line 1554 "SourceCollection.c"
}


static void source_collection_destroy_counter_class_init (SourceCollectionDestroyCounterClass * klass) {
#line 8 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_destroy_counter_parent_class = g_type_class_peek_parent (klass);
#line 8 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	G_OBJECT_CLASS (klass)->finalize = source_collection_destroy_counter_finalize;
#line 1563 "SourceCollection.c"
}


static void source_collection_destroy_counter_instance_init (SourceCollectionDestroyCounter * self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
#line 10 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 10 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self->notify_list = _tmp0_;
#line 11 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_tmp1_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 11 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self->not_removed = _tmp1_;
#line 1578 "SourceCollection.c"
}


static void source_collection_destroy_counter_finalize (GObject* obj) {
	SourceCollectionDestroyCounter * self;
#line 8 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOURCE_COLLECTION_TYPE_DESTROY_COUNTER, SourceCollectionDestroyCounter);
#line 9 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (self->remove_marker);
#line 10 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (self->notify_list);
#line 11 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (self->not_removed);
#line 8 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	G_OBJECT_CLASS (source_collection_destroy_counter_parent_class)->finalize (obj);
#line 1594 "SourceCollection.c"
}


static GType source_collection_destroy_counter_get_type (void) {
	static volatile gsize source_collection_destroy_counter_type_id__volatile = 0;
	if (g_once_init_enter (&source_collection_destroy_counter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SourceCollectionDestroyCounterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_collection_destroy_counter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceCollectionDestroyCounter), 0, (GInstanceInitFunc) source_collection_destroy_counter_instance_init, NULL };
		GType source_collection_destroy_counter_type_id;
		source_collection_destroy_counter_type_id = g_type_register_static (G_TYPE_OBJECT, "SourceCollectionDestroyCounter", &g_define_type_info, 0);
		g_once_init_leave (&source_collection_destroy_counter_type_id__volatile, source_collection_destroy_counter_type_id);
	}
	return source_collection_destroy_counter_type_id__volatile;
}


static void source_collection_class_init (SourceCollectionClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	source_collection_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((DataCollectionClass *) klass)->finalize = source_collection_finalize;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_type_class_add_private (klass, sizeof (SourceCollectionPrivate));
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*)(SourceCollection*, DataSource*)) source_collection_real_holds_type_of_source;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->notify_items_unlinking = (void (*)(SourceCollection*, GeeCollection*)) source_collection_real_notify_items_unlinking;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->notify_items_relinked = (void (*)(SourceCollection*, GeeCollection*)) source_collection_real_notify_items_relinked;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->notify_item_destroyed = (void (*)(SourceCollection*, DataSource*)) source_collection_real_notify_item_destroyed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->notify_items_destroyed = (void (*)(SourceCollection*, GeeCollection*)) source_collection_real_notify_items_destroyed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->notify_unlinked_destroyed = (void (*)(SourceCollection*, DataSource*)) source_collection_real_notify_unlinked_destroyed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->notify_backlink_removed = (void (*)(SourceCollection*, SourceBacklink*, GeeCollection*)) source_collection_real_notify_backlink_removed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((DataCollectionClass *) klass)->valid_type = (gboolean (*)(DataCollection*, DataObject*)) source_collection_real_valid_type;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->has_backlink = (gboolean (*)(SourceCollection*, SourceBacklink*)) source_collection_real_has_backlink;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->remove_backlink = (void (*)(SourceCollection*, SourceBacklink*)) source_collection_real_remove_backlink;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->items_unlinking = source_collection_real_items_unlinking;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->items_relinked = source_collection_real_items_relinked;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->item_destroyed = source_collection_real_item_destroyed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->items_destroyed = source_collection_real_items_destroyed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->unlinked_destroyed = source_collection_real_unlinked_destroyed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	((SourceCollectionClass *) klass)->backlink_removed = source_collection_real_backlink_removed;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_new ("items_unlinking", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, items_unlinking), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_new ("items_relinked", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, items_relinked), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_new ("item_destroyed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, item_destroyed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_SOURCE);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_new ("items_destroyed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, items_destroyed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_new ("unlinked_destroyed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, unlinked_destroyed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_SOURCE);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	g_signal_new ("backlink_removed", TYPE_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SourceCollectionClass, backlink_removed), NULL, NULL, g_cclosure_user_marshal_VOID__SOURCE_BACKLINK_OBJECT, G_TYPE_NONE, 2, TYPE_SOURCE_BACKLINK, GEE_TYPE_COLLECTION);
#line 1661 "SourceCollection.c"
}


static void source_collection_instance_init (SourceCollection * self) {
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self->priv = SOURCE_COLLECTION_GET_PRIVATE (self);
#line 48 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self->priv->backlinks = NULL;
#line 1670 "SourceCollection.c"
}


static void source_collection_finalize (DataCollection* obj) {
	SourceCollection * self;
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOURCE_COLLECTION, SourceCollection);
#line 48 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	_g_object_unref0 (self->priv->backlinks);
#line 7 "/home/jens/Source/shotwell/src/core/SourceCollection.vala"
	DATA_COLLECTION_CLASS (source_collection_parent_class)->finalize (obj);
#line 1682 "SourceCollection.c"
}


GType source_collection_get_type (void) {
	static volatile gsize source_collection_type_id__volatile = 0;
	if (g_once_init_enter (&source_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SourceCollection), 0, (GInstanceInitFunc) source_collection_instance_init, NULL };
		GType source_collection_type_id;
		source_collection_type_id = g_type_register_static (TYPE_DATA_COLLECTION, "SourceCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&source_collection_type_id__volatile, source_collection_type_id);
	}
	return source_collection_type_id__volatile;
}



