#include <gtk/gtk.h>

static gboolean
wdg_find_forward_cursor_pos_func (const PangoLogAttr *attrs,
                              gint          offset,
                              gint          min_offset,
                              gint          len,
                              gint         *found_offset,
                              gboolean      already_moved_initially)
{
  if (!already_moved_initially)
    ++offset;

  while (offset < (min_offset + len) &&
         !attrs[offset].is_cursor_position)
    ++offset;

  *found_offset = offset;

  return offset < (min_offset + len);
}

typedef gboolean (* FindLogAttrFunc) (const PangoLogAttr *attrs,
                                      gint                offset,
                                      gint                min_offset,
                                      gint                len,
                                      gint               *found_offset,
                                      gboolean            already_moved_initially);


static gboolean
wdg_find_line_log_attrs (const GtkTextIter *iter,
                     FindLogAttrFunc    func,
                     gint              *found_offset,
                     gboolean           already_moved_initially)
{
  gint char_len;
  const PangoLogAttr *attrs;
  int offset;
  gboolean result = FALSE;

  g_return_val_if_fail (iter != NULL, FALSE);
  
  attrs = _gtk_text_buffer_get_line_log_attrs (gtk_text_iter_get_buffer (iter),
                                               iter, &char_len);      

  offset = gtk_text_iter_get_line_offset (iter);
  
  /* char_len may be 0 and attrs will be NULL if so, if
   * iter is the end iter and the last line is empty
   */
  
  if (attrs)
    result = (* func) (attrs, offset, 0, char_len, found_offset,
                       already_moved_initially);

  return result;
}

/* FIXME this function is very, very gratuitously slow */
static gboolean
wdg_find_by_log_attrs (GtkTextIter    *iter,
                   FindLogAttrFunc func,
                   gboolean        forward,
                   gboolean        already_moved_initially)
{
  GtkTextIter orig;
  gint offset = 0;
  gboolean found = FALSE;

  g_return_val_if_fail (iter != NULL, FALSE);

  orig = *iter;
  
  found = wdg_find_line_log_attrs (iter, func, &offset, already_moved_initially);
  
  if (!found)
    {
      if (forward)
        {
          if (gtk_text_iter_forward_line (iter))
            return wdg_find_by_log_attrs (iter, func, forward,
                                      TRUE);
          else
            return FALSE;
        }
      else
        {                    
          /* go to end of previous line. need to check that
           * line is > 0 because backward_line snaps to start of
           * line 0 if it's on line 0
           */
          if (gtk_text_iter_get_line (iter) > 0 && 
              gtk_text_iter_backward_line (iter))
            {
              if (!gtk_text_iter_ends_line (iter))
                gtk_text_iter_forward_to_line_end (iter);
              
              return wdg_find_by_log_attrs (iter, func, forward,
                                        TRUE);
            }
          else
            return FALSE;
        }
    }
  else
    {      
      gtk_text_iter_set_line_offset (iter, offset);

      return
        (already_moved_initially || !gtk_text_iter_equal (iter, &orig)) &&
        !gtk_text_iter_is_end (iter);
    }
}


gboolean
wdg_gtk_text_iter_forward_cursor_position (GtkTextIter *iter)
{
  return wdg_find_by_log_attrs (iter, wdg_find_forward_cursor_pos_func, TRUE, FALSE);
}



int
main (int argc, char** argv)
{

	gtk_init (&argc, &argv);
	gchar *text;
	gsize len;
	
	//if (!g_file_get_contents("burmese4.txt", &text, &len, NULL))
	if (!g_file_get_contents("burmese6.txt", &text, &len, NULL))
	{
		printf("failed to read burmese file\n");
		return -1;
	}

	GtkTextBuffer *buffer;
	GtkWidget *view;
	GtkTextIter iter;

	view = gtk_text_view_new ();

	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (view));
	
	if (!GTK_IS_TEXT_BUFFER (buffer)) {
		printf("failed to create text buffer\n");
		return -1;
	}
	gtk_text_buffer_set_text(buffer, text, len);
	
	gtk_text_buffer_get_start_iter(buffer, &iter);

	while (!gtk_text_iter_is_end (&iter))
	{
	
		//gchar *msg;
		guint /*row,*/ col/*, chars*/;
		GtkTextIter start;
		//guint tab_size;
	
		//gedit_debug (DEBUG_VIEW, "");
	  
		//if (view->priv->cursor_position_statusbar == NULL)
		//	return;
		
		/* clear any previous message, underflow is allowed */
		//gtk_statusbar_pop (GTK_STATUSBAR (view->priv->cursor_position_statusbar), 0); 
		
		//gtk_text_buffer_get_iter_at_mark (buffer,
		//				  &iter,
		//				  gtk_text_buffer_get_insert (buffer));
		
		//row = gtk_text_iter_get_line (&iter);
		
		/*
		chars = gtk_text_iter_get_line_offset (&iter);
		*/
		
		start = iter;
		gtk_text_iter_set_line_offset (&start, 0);
		col = 1;
	
		//tab_size = gtk_source_view_get_tabs_width (
		//				GTK_SOURCE_VIEW (view->priv->text_view));
	
		while (!gtk_text_iter_equal (&start, &iter))
		{
			//if (gtk_text_iter_get_char (&start) == '\t')
			//			
			//	col += (tab_size - (col  % tab_size));
			//else
				++col;
				printf("%d ", col);
	
			gtk_text_iter_forward_char (&start);
		}
		printf(": %d\n", col);
		
		/*
		if (col == chars)
			msg = g_strdup_printf (_("  Ln %d, Col %d"), row + 1, col + 1);
		else
			msg = g_strdup_printf (_("  Ln %d, Col %d-%d"), row + 1, chars + 1, col + 1);
		*/
	
		/* Translators: "Ln" is an abbreviation for "Line", Col is an abbreviation for "Column". Please,
		use abbreviations if possible to avoid space problems. */
		//msg = g_strdup_printf (_("  Ln %d, Col %d"), row + 1, col + 1);
		
		//gtk_statusbar_push (GTK_STATUSBAR (view->priv->cursor_position_statusbar), 
		//		    0, msg);
	
		//g_free (msg);
		wdg_gtk_text_iter_forward_cursor_position(&iter);
	}
	
	
	
	
	
	
	
	g_free(buffer);
	g_free(text);
	
  return 0;
}

