/* book-view.c generated by valac 0.22.1, the Vala compiler
 * generated from book-view.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* FIXME: When scrolling, copy existing render sideways?*/
/* FIXME: Only render pages that change and only the part that changed*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>


#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;
typedef struct _BookViewPrivate BookViewPrivate;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_PAGE_VIEW (page_view_get_type ())
#define PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_VIEW, PageView))
#define PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_VIEW, PageViewClass))
#define IS_PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_VIEW))
#define IS_PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_VIEW))
#define PAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_VIEW, PageViewClass))

typedef struct _PageView PageView;
typedef struct _PageViewClass PageViewClass;
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _page_view_unref0(var) ((var == NULL) ? NULL : (var = (page_view_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))

struct _BookView {
	GtkVBox parent_instance;
	BookViewPrivate * priv;
};

struct _BookViewClass {
	GtkVBoxClass parent_class;
};

struct _BookViewPrivate {
	Book* book;
	GHashTable* page_data;
	gboolean need_layout;
	gboolean laying_out;
	gboolean show_selected_page;
	PageView* selected_page;
	GtkWidget* drawing_area;
	GtkScrollbar* scroll;
	GtkAdjustment* adjustment;
	GdkCursorType cursor;
};


static gpointer book_view_parent_class = NULL;

GType book_view_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
gpointer page_view_ref (gpointer instance);
void page_view_unref (gpointer instance);
GParamSpec* param_spec_page_view (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page_view (GValue* value, gpointer v_object);
void value_take_page_view (GValue* value, gpointer v_object);
gpointer value_get_page_view (const GValue* value);
GType page_view_get_type (void) G_GNUC_CONST;
#define BOOK_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOK_VIEW, BookViewPrivate))
enum  {
	BOOK_VIEW_DUMMY_PROPERTY
};
static void book_view_add_cb (BookView* self, Book* book, Page* page);
static void _book_view_add_cb_book_page_added (Book* _sender, Page* page, gpointer self);
static void book_view_remove_cb (BookView* self, Book* book, Page* page);
static void _book_view_remove_cb_book_page_removed (Book* _sender, Page* page, gpointer self);
static void book_view_reorder_cb (BookView* self, Book* book);
static void _book_view_reorder_cb_book_reordered (Book* _sender, gpointer self);
static void book_view_clear_cb (BookView* self, Book* book);
static void _book_view_clear_cb_book_cleared (Book* _sender, gpointer self);
static gboolean book_view_configure_cb (BookView* self, GtkWidget* widget, GdkEventConfigure* event);
static gboolean _book_view_configure_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean book_view_draw_cb (BookView* self, GtkWidget* widget, cairo_t* context);
static gboolean _book_view_draw_cb_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static gboolean book_view_motion_cb (BookView* self, GtkWidget* widget, GdkEventMotion* event);
static gboolean _book_view_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static gboolean book_view_key_cb (BookView* self, GtkWidget* widget, GdkEventKey* event);
static gboolean _book_view_key_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean book_view_button_cb (BookView* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _book_view_button_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _book_view_button_cb_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean book_view_focus_cb (BookView* self, GtkWidget* widget, GdkEventFocus* event);
static gboolean _book_view_focus_cb_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean _book_view_focus_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void book_view_scroll_cb (BookView* self, GtkAdjustment* adjustment);
static void _book_view_scroll_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
BookView* book_view_new (Book* book);
BookView* book_view_construct (GType object_type, Book* book);
guint book_get_n_pages (Book* self);
Page* book_get_page (Book* self, gint page_number);
void book_view_select_page (BookView* self, Page* page);
static void _page_unref0_ (gpointer var);
static void _page_view_unref0_ (gpointer var);
static PageView* book_view_get_nth_page (BookView* self, gint n);
static PageView* book_view_get_next_page (BookView* self, PageView* page);
Page* page_view_get_page (PageView* self);
static PageView* book_view_get_prev_page (BookView* self, PageView* page);
static void book_view_page_view_changed_cb (BookView* self, PageView* page);
void book_view_redraw (BookView* self);
static void book_view_page_view_size_changed_cb (BookView* self, PageView* page);
PageView* page_view_new (Page* page);
PageView* page_view_construct (GType object_type, Page* page);
static void _book_view_page_view_changed_cb_page_view_changed (PageView* _sender, gpointer self);
static void _book_view_page_view_size_changed_cb_page_view_size_changed (PageView* _sender, gpointer self);
static void book_view_set_selected_page (BookView* self, PageView* page);
void page_view_set_selected (PageView* self, gboolean selected);
static void book_view_set_x_offset (BookView* self, gint offset);
static gint book_view_get_x_offset (BookView* self);
static void book_view_show_page_view (BookView* self, PageView* page);
gint page_view_get_x_offset (PageView* self);
gint page_view_get_width (PageView* self);
static void book_view_select_page_view (BookView* self, PageView* page);
Page* book_view_get_selected (BookView* self);
Book* book_view_get_book (BookView* self);
static void book_view_layout_into (BookView* self, gint width, gint height, gint* book_width, gint* book_height);
gint page_get_dpi (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
void page_view_set_width (PageView* self, gint width);
void page_view_set_height (PageView* self, gint height);
gint page_view_get_height (PageView* self);
void page_view_set_x_offset (PageView* self, gint offset);
void page_view_set_y_offset (PageView* self, gint offset);
static void book_view_layout (BookView* self);
void page_view_render (PageView* self, cairo_t* context);
gboolean page_view_get_selected (PageView* self);
gint page_view_get_y_offset (PageView* self);
static PageView* book_view_get_page_at (BookView* self, gint x, gint y, gint* x_, gint* y_);
void page_view_button_press (PageView* self, gint x, gint y);
void page_view_button_release (PageView* self, gint x, gint y);
static void book_view_set_cursor (BookView* self, GdkCursorType cursor);
void page_view_motion (PageView* self, gint x, gint y);
GdkCursorType page_view_get_cursor (PageView* self);
void book_view_select_next_page (BookView* self);
void book_view_select_prev_page (BookView* self);
static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void book_view_finalize (GObject* obj);


static void _book_view_add_cb_book_page_added (Book* _sender, Page* page, gpointer self) {
	book_view_add_cb (self, _sender, page);
}


static void _book_view_remove_cb_book_page_removed (Book* _sender, Page* page, gpointer self) {
	book_view_remove_cb (self, _sender, page);
}


static void _book_view_reorder_cb_book_reordered (Book* _sender, gpointer self) {
	book_view_reorder_cb (self, _sender);
}


static void _book_view_clear_cb_book_cleared (Book* _sender, gpointer self) {
	book_view_clear_cb (self, _sender);
}


static gboolean _book_view_configure_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = book_view_configure_cb (self, _sender, event);
	return result;
}


static gboolean _book_view_draw_cb_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = book_view_draw_cb (self, _sender, cr);
	return result;
}


static gboolean _book_view_motion_cb_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = book_view_motion_cb (self, _sender, event);
	return result;
}


static gboolean _book_view_key_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = book_view_key_cb (self, _sender, event);
	return result;
}


static gboolean _book_view_button_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = book_view_button_cb (self, _sender, event);
	return result;
}


static gboolean _book_view_button_cb_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = book_view_button_cb (self, _sender, event);
	return result;
}


static gboolean _book_view_focus_cb_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = book_view_focus_cb (self, _sender, event);
	return result;
}


static gboolean _book_view_focus_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = book_view_focus_cb (self, _sender, event);
	return result;
}


static void _book_view_scroll_cb_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
	book_view_scroll_cb (self, _sender);
}


static gpointer _book_ref0 (gpointer self) {
	return self ? book_ref (self) : NULL;
}


static void _page_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
}


static void _page_view_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (page_view_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BookView* book_view_construct (GType object_type, Book* book) {
	BookView * self = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	Book* _tmp13_ = NULL;
	Page* _tmp14_ = NULL;
	Page* _tmp15_ = NULL;
	Book* _tmp16_ = NULL;
	Book* _tmp17_ = NULL;
	Book* _tmp18_ = NULL;
	Book* _tmp19_ = NULL;
	GHashFunc _tmp20_ = NULL;
	GEqualFunc _tmp21_ = NULL;
	GHashTable* _tmp22_ = NULL;
	GtkDrawingArea* _tmp23_ = NULL;
	GtkWidget* _tmp24_ = NULL;
	GtkWidget* _tmp25_ = NULL;
	GtkWidget* _tmp26_ = NULL;
	GtkWidget* _tmp27_ = NULL;
	GtkScrollbar* _tmp28_ = NULL;
	GtkScrollbar* _tmp29_ = NULL;
	GtkAdjustment* _tmp30_ = NULL;
	GtkAdjustment* _tmp31_ = NULL;
	GtkScrollbar* _tmp32_ = NULL;
	GtkWidget* _tmp33_ = NULL;
	GtkWidget* _tmp34_ = NULL;
	GtkWidget* _tmp35_ = NULL;
	GtkWidget* _tmp36_ = NULL;
	GtkWidget* _tmp37_ = NULL;
	GtkWidget* _tmp38_ = NULL;
	GtkWidget* _tmp39_ = NULL;
	GtkWidget* _tmp40_ = NULL;
	GtkAdjustment* _tmp41_ = NULL;
	GtkWidget* _tmp42_ = NULL;
	g_return_val_if_fail (book != NULL, NULL);
	self = (BookView*) g_object_new (object_type, NULL);
	_tmp0_ = book;
	_tmp1_ = _book_ref0 (_tmp0_);
	_book_unref0 (self->priv->book);
	self->priv->book = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp5_ = 0;
				Book* _tmp6_ = NULL;
				guint _tmp7_ = 0U;
				Page* page = NULL;
				Book* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				Page* _tmp10_ = NULL;
				Book* _tmp11_ = NULL;
				Page* _tmp12_ = NULL;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = book;
				_tmp7_ = book_get_n_pages (_tmp6_);
				if (!(((guint) _tmp5_) < _tmp7_)) {
					break;
				}
				_tmp8_ = book;
				_tmp9_ = i;
				_tmp10_ = book_get_page (_tmp8_, _tmp9_);
				page = _tmp10_;
				_tmp11_ = book;
				_tmp12_ = page;
				book_view_add_cb (self, _tmp11_, _tmp12_);
				_page_unref0 (page);
			}
		}
	}
	_tmp13_ = book;
	_tmp14_ = book_get_page (_tmp13_, 0);
	_tmp15_ = _tmp14_;
	book_view_select_page (self, _tmp15_);
	_page_unref0 (_tmp15_);
	_tmp16_ = book;
	g_signal_connect_object (_tmp16_, "page-added", (GCallback) _book_view_add_cb_book_page_added, self, 0);
	_tmp17_ = book;
	g_signal_connect_object (_tmp17_, "page-removed", (GCallback) _book_view_remove_cb_book_page_removed, self, 0);
	_tmp18_ = book;
	g_signal_connect_object (_tmp18_, "reordered", (GCallback) _book_view_reorder_cb_book_reordered, self, 0);
	_tmp19_ = book;
	g_signal_connect_object (_tmp19_, "cleared", (GCallback) _book_view_clear_cb_book_cleared, self, 0);
	self->priv->need_layout = TRUE;
	_tmp20_ = g_direct_hash;
	_tmp21_ = g_direct_equal;
	_tmp22_ = g_hash_table_new_full (_tmp20_, _tmp21_, _page_unref0_, _page_view_unref0_);
	_g_hash_table_unref0 (self->priv->page_data);
	self->priv->page_data = _tmp22_;
	self->priv->cursor = GDK_ARROW;
	_tmp23_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->drawing_area);
	self->priv->drawing_area = (GtkWidget*) _tmp23_;
	_tmp24_ = self->priv->drawing_area;
	gtk_widget_set_size_request (_tmp24_, 200, 100);
	_tmp25_ = self->priv->drawing_area;
	gtk_widget_set_can_focus (_tmp25_, TRUE);
	_tmp26_ = self->priv->drawing_area;
	gtk_widget_set_events (_tmp26_, (gint) (((((GDK_POINTER_MOTION_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_FOCUS_CHANGE_MASK) | GDK_STRUCTURE_MASK) | GDK_SCROLL_MASK));
	_tmp27_ = self->priv->drawing_area;
	gtk_box_pack_start ((GtkBox*) self, _tmp27_, TRUE, TRUE, (guint) 0);
	_tmp28_ = (GtkScrollbar*) gtk_scrollbar_new (GTK_ORIENTATION_HORIZONTAL, NULL);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->scroll);
	self->priv->scroll = _tmp28_;
	_tmp29_ = self->priv->scroll;
	_tmp30_ = gtk_range_get_adjustment ((GtkRange*) _tmp29_);
	_tmp31_ = _g_object_ref0 (_tmp30_);
	_g_object_unref0 (self->priv->adjustment);
	self->priv->adjustment = _tmp31_;
	_tmp32_ = self->priv->scroll;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp32_, FALSE, TRUE, (guint) 0);
	_tmp33_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp33_, "configure-event", (GCallback) _book_view_configure_cb_gtk_widget_configure_event, self, 0);
	_tmp34_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp34_, "draw", (GCallback) _book_view_draw_cb_gtk_widget_draw, self, 0);
	_tmp35_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp35_, "motion-notify-event", (GCallback) _book_view_motion_cb_gtk_widget_motion_notify_event, self, 0);
	_tmp36_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp36_, "key-press-event", (GCallback) _book_view_key_cb_gtk_widget_key_press_event, self, 0);
	_tmp37_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp37_, "button-press-event", (GCallback) _book_view_button_cb_gtk_widget_button_press_event, self, 0);
	_tmp38_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp38_, "button-release-event", (GCallback) _book_view_button_cb_gtk_widget_button_release_event, self, 0);
	_tmp39_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp39_, "focus-in-event", (GCallback) _book_view_focus_cb_gtk_widget_focus_in_event, self, G_CONNECT_AFTER);
	_tmp40_ = self->priv->drawing_area;
	g_signal_connect_object (_tmp40_, "focus-out-event", (GCallback) _book_view_focus_cb_gtk_widget_focus_out_event, self, G_CONNECT_AFTER);
	_tmp41_ = self->priv->adjustment;
	g_signal_connect_object (_tmp41_, "value-changed", (GCallback) _book_view_scroll_cb_gtk_adjustment_value_changed, self, 0);
	_tmp42_ = self->priv->drawing_area;
	gtk_widget_show (_tmp42_);
	return self;
}


BookView* book_view_new (Book* book) {
	return book_view_construct (TYPE_BOOK_VIEW, book);
}


static gpointer _page_view_ref0 (gpointer self) {
	return self ? page_view_ref (self) : NULL;
}


static PageView* book_view_get_nth_page (BookView* self, gint n) {
	PageView* result = NULL;
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Page* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	PageView* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = n;
	_tmp2_ = book_get_page (_tmp0_, _tmp1_);
	page = _tmp2_;
	_tmp3_ = self->priv->page_data;
	_tmp4_ = g_hash_table_lookup (_tmp3_, page);
	_tmp5_ = _page_view_ref0 ((PageView*) _tmp4_);
	result = _tmp5_;
	_page_unref0 (page);
	return result;
}


static PageView* book_view_get_next_page (BookView* self, PageView* page) {
	PageView* result = NULL;
	PageView* _tmp20_ = NULL;
	PageView* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (page != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				Page* p = NULL;
				Book* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				Page* _tmp5_ = NULL;
				Page* _tmp6_ = NULL;
				Page* _tmp7_ = NULL;
				PageView* _tmp8_ = NULL;
				Page* _tmp9_ = NULL;
				Page* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = self->priv->book;
				_tmp4_ = i;
				_tmp5_ = book_get_page (_tmp3_, _tmp4_);
				p = _tmp5_;
				_tmp6_ = p;
				if (_tmp6_ == NULL) {
					_page_unref0 (p);
					break;
				}
				_tmp7_ = p;
				_tmp8_ = page;
				_tmp9_ = page_view_get_page (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = _tmp7_ == _tmp10_;
				_page_unref0 (_tmp10_);
				if (_tmp11_) {
					Book* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					Page* _tmp14_ = NULL;
					Page* _tmp15_ = NULL;
					_tmp12_ = self->priv->book;
					_tmp13_ = i;
					_tmp14_ = book_get_page (_tmp12_, _tmp13_ + 1);
					_page_unref0 (p);
					p = _tmp14_;
					_tmp15_ = p;
					if (_tmp15_ != NULL) {
						GHashTable* _tmp16_ = NULL;
						Page* _tmp17_ = NULL;
						gconstpointer _tmp18_ = NULL;
						PageView* _tmp19_ = NULL;
						_tmp16_ = self->priv->page_data;
						_tmp17_ = p;
						_tmp18_ = g_hash_table_lookup (_tmp16_, _tmp17_);
						_tmp19_ = _page_view_ref0 ((PageView*) _tmp18_);
						result = _tmp19_;
						_page_unref0 (p);
						return result;
					}
				}
				_page_unref0 (p);
			}
		}
	}
	_tmp20_ = page;
	_tmp21_ = _page_view_ref0 (_tmp20_);
	result = _tmp21_;
	return result;
}


static PageView* book_view_get_prev_page (BookView* self, PageView* page) {
	PageView* result = NULL;
	PageView* prev_page = NULL;
	PageView* _tmp0_ = NULL;
	PageView* _tmp1_ = NULL;
	PageView* _tmp18_ = NULL;
	PageView* _tmp19_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (page != NULL, NULL);
	_tmp0_ = page;
	_tmp1_ = _page_view_ref0 (_tmp0_);
	prev_page = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				Page* p = NULL;
				Book* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				Page* _tmp7_ = NULL;
				Page* _tmp8_ = NULL;
				Page* _tmp9_ = NULL;
				PageView* _tmp10_ = NULL;
				Page* _tmp11_ = NULL;
				Page* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				GHashTable* _tmp14_ = NULL;
				Page* _tmp15_ = NULL;
				gconstpointer _tmp16_ = NULL;
				PageView* _tmp17_ = NULL;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = self->priv->book;
				_tmp6_ = i;
				_tmp7_ = book_get_page (_tmp5_, _tmp6_);
				p = _tmp7_;
				_tmp8_ = p;
				if (_tmp8_ == NULL) {
					_page_unref0 (p);
					break;
				}
				_tmp9_ = p;
				_tmp10_ = page;
				_tmp11_ = page_view_get_page (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = _tmp9_ == _tmp12_;
				_page_unref0 (_tmp12_);
				if (_tmp13_) {
					result = prev_page;
					_page_unref0 (p);
					return result;
				}
				_tmp14_ = self->priv->page_data;
				_tmp15_ = p;
				_tmp16_ = g_hash_table_lookup (_tmp14_, _tmp15_);
				_tmp17_ = _page_view_ref0 ((PageView*) _tmp16_);
				_page_view_unref0 (prev_page);
				prev_page = _tmp17_;
				_page_unref0 (p);
			}
		}
	}
	_tmp18_ = page;
	_tmp19_ = _page_view_ref0 (_tmp18_);
	result = _tmp19_;
	_page_view_unref0 (prev_page);
	return result;
}


static void book_view_page_view_changed_cb (BookView* self, PageView* page) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	book_view_redraw (self);
}


static void book_view_page_view_size_changed_cb (BookView* self, PageView* page) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
}


static void _book_view_page_view_changed_cb_page_view_changed (PageView* _sender, gpointer self) {
	book_view_page_view_changed_cb (self, _sender);
}


static void _book_view_page_view_size_changed_cb_page_view_size_changed (PageView* _sender, gpointer self) {
	book_view_page_view_size_changed_cb (self, _sender);
}


static gpointer _page_ref0 (gpointer self) {
	return self ? page_ref (self) : NULL;
}


static void book_view_add_cb (BookView* self, Book* book, Page* page) {
	PageView* page_view = NULL;
	Page* _tmp0_ = NULL;
	PageView* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	PageView* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	_tmp1_ = page_view_new (_tmp0_);
	page_view = _tmp1_;
	g_signal_connect_object (page_view, "changed", (GCallback) _book_view_page_view_changed_cb_page_view_changed, self, 0);
	g_signal_connect_object (page_view, "size-changed", (GCallback) _book_view_page_view_size_changed_cb_page_view_size_changed, self, 0);
	_tmp2_ = self->priv->page_data;
	_tmp3_ = page;
	_tmp4_ = _page_ref0 (_tmp3_);
	_tmp5_ = _page_view_ref0 (page_view);
	g_hash_table_insert (_tmp2_, _tmp4_, _tmp5_);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
	_page_view_unref0 (page_view);
}


static void book_view_set_selected_page (BookView* self, PageView* page) {
	gboolean _tmp0_ = FALSE;
	PageView* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	PageView* _tmp6_ = NULL;
	PageView* _tmp7_ = NULL;
	PageView* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->selected_page;
	if (_tmp1_ != NULL) {
		PageView* _tmp2_ = NULL;
		PageView* _tmp3_ = NULL;
		_tmp2_ = page;
		_tmp3_ = self->priv->selected_page;
		_tmp0_ = _tmp2_ != _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		PageView* _tmp5_ = NULL;
		_tmp5_ = self->priv->selected_page;
		page_view_set_selected (_tmp5_, FALSE);
	}
	_tmp6_ = page;
	_tmp7_ = _page_view_ref0 (_tmp6_);
	_page_view_unref0 (self->priv->selected_page);
	self->priv->selected_page = _tmp7_;
	_tmp8_ = self->priv->selected_page;
	if (_tmp8_ == NULL) {
		return;
	}
	_tmp9_ = self->priv->drawing_area;
	g_object_get (_tmp9_, "has-focus", &_tmp10_, NULL);
	_tmp11_ = _tmp10_;
	if (!_tmp11_) {
		PageView* _tmp12_ = NULL;
		_tmp12_ = self->priv->selected_page;
		page_view_set_selected (_tmp12_, FALSE);
	} else {
		PageView* _tmp13_ = NULL;
		_tmp13_ = self->priv->selected_page;
		page_view_set_selected (_tmp13_, TRUE);
	}
}


static void book_view_set_x_offset (BookView* self, gint offset) {
	GtkAdjustment* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->adjustment;
	_tmp1_ = offset;
	gtk_adjustment_set_value (_tmp0_, (gdouble) _tmp1_);
}


static gint book_view_get_x_offset (BookView* self) {
	gint result = 0;
	GtkAdjustment* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->adjustment;
	_tmp1_ = gtk_adjustment_get_value (_tmp0_);
	result = (gint) _tmp1_;
	return result;
}


static void book_view_show_page_view (BookView* self, PageView* page) {
	gboolean _tmp0_ = FALSE;
	PageView* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkAllocation allocation = {0};
	GtkWidget* _tmp5_ = NULL;
	GtkAllocation _tmp6_ = {0};
	gint left_edge = 0;
	PageView* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint right_edge = 0;
	PageView* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	PageView* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = page;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkScrollbar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->scroll;
		_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
		_tmp0_ = !_tmp3_;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->drawing_area;
	gtk_widget_get_allocation (_tmp5_, &_tmp6_);
	allocation = _tmp6_;
	_tmp7_ = page;
	_tmp8_ = page_view_get_x_offset (_tmp7_);
	left_edge = _tmp8_;
	_tmp9_ = page;
	_tmp10_ = page_view_get_x_offset (_tmp9_);
	_tmp11_ = page;
	_tmp12_ = page_view_get_width (_tmp11_);
	right_edge = _tmp10_ + _tmp12_;
	_tmp13_ = left_edge;
	_tmp14_ = book_view_get_x_offset (self);
	if ((_tmp13_ - _tmp14_) < 0) {
		gint _tmp15_ = 0;
		_tmp15_ = left_edge;
		book_view_set_x_offset (self, _tmp15_);
	} else {
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		GtkAllocation _tmp18_ = {0};
		gint _tmp19_ = 0;
		_tmp16_ = right_edge;
		_tmp17_ = book_view_get_x_offset (self);
		_tmp18_ = allocation;
		_tmp19_ = _tmp18_.width;
		if ((_tmp16_ - _tmp17_) > _tmp19_) {
			gint _tmp20_ = 0;
			GtkAllocation _tmp21_ = {0};
			gint _tmp22_ = 0;
			_tmp20_ = right_edge;
			_tmp21_ = allocation;
			_tmp22_ = _tmp21_.width;
			book_view_set_x_offset (self, _tmp20_ - _tmp22_);
		}
	}
}


static void book_view_select_page_view (BookView* self, PageView* page) {
	Page* p = NULL;
	PageView* _tmp0_ = NULL;
	PageView* _tmp1_ = NULL;
	PageView* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	PageView* _tmp5_ = NULL;
	Page* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	p = NULL;
	_tmp0_ = self->priv->selected_page;
	_tmp1_ = page;
	if (_tmp0_ == _tmp1_) {
		_page_unref0 (p);
		return;
	}
	_tmp2_ = page;
	book_view_set_selected_page (self, _tmp2_);
	_tmp3_ = self->priv->need_layout;
	if (_tmp3_) {
		self->priv->show_selected_page = TRUE;
	} else {
		PageView* _tmp4_ = NULL;
		_tmp4_ = page;
		book_view_show_page_view (self, _tmp4_);
	}
	_tmp5_ = page;
	if (_tmp5_ != NULL) {
		PageView* _tmp6_ = NULL;
		Page* _tmp7_ = NULL;
		_tmp6_ = page;
		_tmp7_ = page_view_get_page (_tmp6_);
		_page_unref0 (p);
		p = _tmp7_;
	}
	_tmp8_ = p;
	g_signal_emit_by_name (self, "page-selected", _tmp8_);
	_page_unref0 (p);
}


static void book_view_remove_cb (BookView* self, Book* book, Page* page) {
	PageView* new_selection = NULL;
	PageView* _tmp0_ = NULL;
	PageView* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	PageView* page_view = NULL;
	GHashTable* _tmp12_ = NULL;
	Page* _tmp13_ = NULL;
	gconstpointer _tmp14_ = NULL;
	PageView* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	guint _tmp17_ = 0U;
	GHashTable* _tmp18_ = NULL;
	Page* _tmp19_ = NULL;
	PageView* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->selected_page;
	_tmp1_ = _page_view_ref0 (_tmp0_);
	new_selection = _tmp1_;
	_tmp2_ = page;
	_tmp3_ = book_view_get_selected (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp2_ == _tmp4_;
	_page_unref0 (_tmp4_);
	if (_tmp5_) {
		PageView* _tmp6_ = NULL;
		PageView* _tmp7_ = NULL;
		PageView* _tmp8_ = NULL;
		PageView* _tmp9_ = NULL;
		_tmp6_ = self->priv->selected_page;
		_tmp7_ = book_view_get_prev_page (self, _tmp6_);
		_page_view_unref0 (new_selection);
		new_selection = _tmp7_;
		_tmp8_ = new_selection;
		_tmp9_ = self->priv->selected_page;
		if (_tmp8_ == _tmp9_) {
			PageView* _tmp10_ = NULL;
			PageView* _tmp11_ = NULL;
			_tmp10_ = self->priv->selected_page;
			_tmp11_ = book_view_get_next_page (self, _tmp10_);
			_page_view_unref0 (new_selection);
			new_selection = _tmp11_;
		}
		_page_view_unref0 (self->priv->selected_page);
		self->priv->selected_page = NULL;
	}
	_tmp12_ = self->priv->page_data;
	_tmp13_ = page;
	_tmp14_ = g_hash_table_lookup (_tmp12_, _tmp13_);
	_tmp15_ = _page_view_ref0 ((PageView*) _tmp14_);
	page_view = _tmp15_;
	g_signal_parse_name ("changed", TYPE_PAGE_VIEW, &_tmp16_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (page_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _book_view_page_view_changed_cb_page_view_changed, self);
	g_signal_parse_name ("size-changed", TYPE_PAGE_VIEW, &_tmp17_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (page_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _book_view_page_view_size_changed_cb_page_view_size_changed, self);
	_tmp18_ = self->priv->page_data;
	_tmp19_ = page;
	g_hash_table_remove (_tmp18_, _tmp19_);
	_tmp20_ = new_selection;
	book_view_select_page_view (self, _tmp20_);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
	_page_view_unref0 (page_view);
	_page_view_unref0 (new_selection);
}


static void book_view_reorder_cb (BookView* self, Book* book) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
}


static void book_view_clear_cb (BookView* self, Book* book) {
	GHashTable* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	_tmp0_ = self->priv->page_data;
	g_hash_table_remove_all (_tmp0_);
	_page_view_unref0 (self->priv->selected_page);
	self->priv->selected_page = NULL;
	g_signal_emit_by_name (self, "page-selected", NULL);
	self->priv->need_layout = TRUE;
	book_view_redraw (self);
}


Book* book_view_get_book (BookView* self) {
	Book* result = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = _book_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean book_view_configure_cb (BookView* self, GtkWidget* widget, GdkEventConfigure* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->need_layout = TRUE;
	result = FALSE;
	return result;
}


static void book_view_layout_into (BookView* self, gint width, gint height, gint* book_width, gint* book_height) {
	gint _vala_book_width = 0;
	gint _vala_book_height = 0;
	gint max_dpi = 0;
	gint max_width = 0;
	gint max_height = 0;
	gdouble aspect = 0.0;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gdouble max_aspect = 0.0;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	gint spacing = 0;
	gint x_offset = 0;
	g_return_if_fail (self != NULL);
	max_dpi = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Book* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
				Page* page = NULL;
				Book* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				Page* _tmp8_ = NULL;
				Page* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->book;
				_tmp5_ = book_get_n_pages (_tmp4_);
				if (!(((guint) _tmp3_) < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->book;
				_tmp7_ = i;
				_tmp8_ = book_get_page (_tmp6_, _tmp7_);
				page = _tmp8_;
				_tmp9_ = page;
				_tmp10_ = page_get_dpi (_tmp9_);
				_tmp11_ = max_dpi;
				if (_tmp10_ > _tmp11_) {
					Page* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					_tmp12_ = page;
					_tmp13_ = page_get_dpi (_tmp12_);
					max_dpi = _tmp13_;
				}
				_page_unref0 (page);
			}
		}
	}
	max_width = 0;
	max_height = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				gboolean _tmp15_ = FALSE;
				gint _tmp17_ = 0;
				Book* _tmp18_ = NULL;
				guint _tmp19_ = 0U;
				Page* page = NULL;
				Book* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				Page* _tmp22_ = NULL;
				gint w = 0;
				Page* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gint h = 0;
				Page* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				gint _tmp28_ = 0;
				Page* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				Page* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				_tmp15_ = _tmp14_;
				if (!_tmp15_) {
					gint _tmp16_ = 0;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp17_ = i;
				_tmp18_ = self->priv->book;
				_tmp19_ = book_get_n_pages (_tmp18_);
				if (!(((guint) _tmp17_) < _tmp19_)) {
					break;
				}
				_tmp20_ = self->priv->book;
				_tmp21_ = i;
				_tmp22_ = book_get_page (_tmp20_, _tmp21_);
				page = _tmp22_;
				_tmp23_ = page;
				_tmp24_ = page_get_width (_tmp23_);
				w = _tmp24_;
				_tmp25_ = page;
				_tmp26_ = page_get_height (_tmp25_);
				h = _tmp26_;
				_tmp27_ = w;
				_tmp28_ = max_dpi;
				_tmp29_ = page;
				_tmp30_ = page_get_dpi (_tmp29_);
				w = (gint) (((((gdouble) _tmp27_) * _tmp28_) / _tmp30_) + 0.5);
				_tmp31_ = h;
				_tmp32_ = max_dpi;
				_tmp33_ = page;
				_tmp34_ = page_get_dpi (_tmp33_);
				h = (gint) (((((gdouble) _tmp31_) * _tmp32_) / _tmp34_) + 0.5);
				_tmp35_ = w;
				_tmp36_ = max_width;
				if (_tmp35_ > _tmp36_) {
					gint _tmp37_ = 0;
					_tmp37_ = w;
					max_width = _tmp37_;
				}
				_tmp38_ = h;
				_tmp39_ = max_height;
				if (_tmp38_ > _tmp39_) {
					gint _tmp40_ = 0;
					_tmp40_ = h;
					max_height = _tmp40_;
				}
				_page_unref0 (page);
			}
		}
	}
	_tmp41_ = width;
	_tmp42_ = height;
	aspect = ((gdouble) _tmp41_) / _tmp42_;
	_tmp43_ = max_width;
	_tmp44_ = max_height;
	max_aspect = ((gdouble) _tmp43_) / _tmp44_;
	spacing = 12;
	_vala_book_width = 0;
	_vala_book_height = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp45_ = FALSE;
			_tmp45_ = TRUE;
			while (TRUE) {
				gboolean _tmp46_ = FALSE;
				gint _tmp48_ = 0;
				Book* _tmp49_ = NULL;
				guint _tmp50_ = 0U;
				PageView* page = NULL;
				gint _tmp51_ = 0;
				PageView* _tmp52_ = NULL;
				Page* p = NULL;
				PageView* _tmp53_ = NULL;
				Page* _tmp54_ = NULL;
				gdouble _tmp55_ = 0.0;
				gdouble _tmp56_ = 0.0;
				gint h = 0;
				PageView* _tmp75_ = NULL;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				gint _tmp80_ = 0;
				PageView* _tmp81_ = NULL;
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				_tmp46_ = _tmp45_;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp45_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = self->priv->book;
				_tmp50_ = book_get_n_pages (_tmp49_);
				if (!(((guint) _tmp48_) < _tmp50_)) {
					break;
				}
				_tmp51_ = i;
				_tmp52_ = book_view_get_nth_page (self, _tmp51_);
				page = _tmp52_;
				_tmp53_ = page;
				_tmp54_ = page_view_get_page (_tmp53_);
				p = _tmp54_;
				_tmp55_ = max_aspect;
				_tmp56_ = aspect;
				if (_tmp55_ > _tmp56_) {
					gint w = 0;
					Page* _tmp57_ = NULL;
					gint _tmp58_ = 0;
					gint _tmp59_ = 0;
					gint _tmp60_ = 0;
					Page* _tmp61_ = NULL;
					gint _tmp62_ = 0;
					gint _tmp63_ = 0;
					PageView* _tmp64_ = NULL;
					gint _tmp65_ = 0;
					_tmp57_ = p;
					_tmp58_ = page_get_width (_tmp57_);
					_tmp59_ = max_dpi;
					_tmp60_ = width;
					_tmp61_ = p;
					_tmp62_ = page_get_dpi (_tmp61_);
					_tmp63_ = max_width;
					w = (gint) (((((gdouble) _tmp58_) * _tmp59_) * _tmp60_) / (_tmp62_ * _tmp63_));
					_tmp64_ = page;
					_tmp65_ = w;
					page_view_set_width (_tmp64_, _tmp65_);
				} else {
					gint h = 0;
					Page* _tmp66_ = NULL;
					gint _tmp67_ = 0;
					gint _tmp68_ = 0;
					gint _tmp69_ = 0;
					Page* _tmp70_ = NULL;
					gint _tmp71_ = 0;
					gint _tmp72_ = 0;
					PageView* _tmp73_ = NULL;
					gint _tmp74_ = 0;
					_tmp66_ = p;
					_tmp67_ = page_get_height (_tmp66_);
					_tmp68_ = max_dpi;
					_tmp69_ = height;
					_tmp70_ = p;
					_tmp71_ = page_get_dpi (_tmp70_);
					_tmp72_ = max_height;
					h = (gint) (((((gdouble) _tmp67_) * _tmp68_) * _tmp69_) / (_tmp71_ * _tmp72_));
					_tmp73_ = page;
					_tmp74_ = h;
					page_view_set_height (_tmp73_, _tmp74_);
				}
				_tmp75_ = page;
				_tmp76_ = page_view_get_height (_tmp75_);
				h = _tmp76_;
				_tmp77_ = h;
				_tmp78_ = _vala_book_height;
				if (_tmp77_ > _tmp78_) {
					gint _tmp79_ = 0;
					_tmp79_ = h;
					_vala_book_height = _tmp79_;
				}
				_tmp80_ = _vala_book_width;
				_tmp81_ = page;
				_tmp82_ = page_view_get_width (_tmp81_);
				_vala_book_width = _tmp80_ + _tmp82_;
				_tmp83_ = i;
				if (_tmp83_ != 0) {
					gint _tmp84_ = 0;
					gint _tmp85_ = 0;
					_tmp84_ = _vala_book_width;
					_tmp85_ = spacing;
					_vala_book_width = _tmp84_ + _tmp85_;
				}
				_page_unref0 (p);
				_page_view_unref0 (page);
			}
		}
	}
	x_offset = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp86_ = FALSE;
			_tmp86_ = TRUE;
			while (TRUE) {
				gboolean _tmp87_ = FALSE;
				gint _tmp89_ = 0;
				Book* _tmp90_ = NULL;
				guint _tmp91_ = 0U;
				PageView* page = NULL;
				gint _tmp92_ = 0;
				PageView* _tmp93_ = NULL;
				PageView* _tmp94_ = NULL;
				gint _tmp95_ = 0;
				gint _tmp96_ = 0;
				PageView* _tmp97_ = NULL;
				gint _tmp98_ = 0;
				gint _tmp99_ = 0;
				PageView* _tmp100_ = NULL;
				gint _tmp101_ = 0;
				PageView* _tmp102_ = NULL;
				gint _tmp103_ = 0;
				_tmp87_ = _tmp86_;
				if (!_tmp87_) {
					gint _tmp88_ = 0;
					_tmp88_ = i;
					i = _tmp88_ + 1;
				}
				_tmp86_ = FALSE;
				_tmp89_ = i;
				_tmp90_ = self->priv->book;
				_tmp91_ = book_get_n_pages (_tmp90_);
				if (!(((guint) _tmp89_) < _tmp91_)) {
					break;
				}
				_tmp92_ = i;
				_tmp93_ = book_view_get_nth_page (self, _tmp92_);
				page = _tmp93_;
				_tmp94_ = page;
				_tmp95_ = x_offset;
				page_view_set_x_offset (_tmp94_, _tmp95_);
				_tmp96_ = x_offset;
				_tmp97_ = page;
				_tmp98_ = page_view_get_width (_tmp97_);
				_tmp99_ = spacing;
				x_offset = _tmp96_ + (_tmp98_ + _tmp99_);
				_tmp100_ = page;
				_tmp101_ = height;
				_tmp102_ = page;
				_tmp103_ = page_view_get_height (_tmp102_);
				page_view_set_y_offset (_tmp100_, (_tmp101_ - _tmp103_) / 2);
				_page_view_unref0 (page);
			}
		}
	}
	if (book_width) {
		*book_width = _vala_book_width;
	}
	if (book_height) {
		*book_height = _vala_book_height;
	}
}


static void book_view_layout (BookView* self) {
	gboolean _tmp0_ = FALSE;
	GtkAllocation allocation = {0};
	GtkWidget* _tmp1_ = NULL;
	GtkAllocation _tmp2_ = {0};
	GtkAllocation box_allocation = {0};
	GtkAllocation _tmp3_ = {0};
	gboolean right_aligned = FALSE;
	GtkAdjustment* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	GtkAdjustment* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	GtkAdjustment* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	gint width = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	gint height = 0;
	GtkAllocation _tmp12_ = {0};
	gint _tmp13_ = 0;
	guint _tmp14_ = 0U;
	gint book_width = 0;
	gint book_height = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GtkAllocation _tmp20_ = {0};
	gint _tmp21_ = 0;
	gboolean _tmp54_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->need_layout;
	if (!_tmp0_) {
		return;
	}
	self->priv->laying_out = TRUE;
	_tmp1_ = self->priv->drawing_area;
	gtk_widget_get_allocation (_tmp1_, &_tmp2_);
	allocation = _tmp2_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp3_);
	box_allocation = _tmp3_;
	right_aligned = TRUE;
	_tmp4_ = self->priv->adjustment;
	_tmp5_ = gtk_adjustment_get_value (_tmp4_);
	_tmp6_ = self->priv->adjustment;
	_tmp7_ = gtk_adjustment_get_upper (_tmp6_);
	_tmp8_ = self->priv->adjustment;
	_tmp9_ = gtk_adjustment_get_page_size (_tmp8_);
	if (_tmp5_ < (_tmp7_ - _tmp9_)) {
		right_aligned = FALSE;
	}
	_tmp10_ = allocation;
	_tmp11_ = _tmp10_.width;
	width = (gint) _tmp11_;
	_tmp12_ = box_allocation;
	_tmp13_ = _tmp12_.height;
	_tmp14_ = gtk_container_get_border_width ((GtkContainer*) self);
	height = (gint) (_tmp13_ - (_tmp14_ * 2));
	_tmp15_ = width;
	_tmp16_ = height;
	book_view_layout_into (self, _tmp15_, _tmp16_, &_tmp17_, &_tmp18_);
	book_width = _tmp17_;
	book_height = _tmp18_;
	_tmp19_ = book_width;
	_tmp20_ = allocation;
	_tmp21_ = _tmp20_.width;
	if (_tmp19_ > _tmp21_) {
		GtkAllocation _tmp22_ = {0};
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		GtkAdjustment* _tmp28_ = NULL;
		GtkAdjustment* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		GtkAdjustment* _tmp31_ = NULL;
		GtkAllocation _tmp32_ = {0};
		gint _tmp33_ = 0;
		gint max_offset = 0;
		gint _tmp34_ = 0;
		GtkAllocation _tmp35_ = {0};
		gint _tmp36_ = 0;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp41_ = FALSE;
		GtkScrollbar* _tmp43_ = NULL;
		_tmp22_ = allocation;
		_tmp23_ = _tmp22_.height;
		height = _tmp23_;
		_tmp24_ = width;
		_tmp25_ = height;
		book_view_layout_into (self, _tmp24_, _tmp25_, &_tmp26_, &_tmp27_);
		book_width = _tmp26_;
		book_height = _tmp27_;
		_tmp28_ = self->priv->adjustment;
		gtk_adjustment_set_lower (_tmp28_, (gdouble) 0);
		_tmp29_ = self->priv->adjustment;
		_tmp30_ = book_width;
		gtk_adjustment_set_upper (_tmp29_, (gdouble) _tmp30_);
		_tmp31_ = self->priv->adjustment;
		_tmp32_ = allocation;
		_tmp33_ = _tmp32_.width;
		gtk_adjustment_set_page_size (_tmp31_, (gdouble) _tmp33_);
		_tmp34_ = book_width;
		_tmp35_ = allocation;
		_tmp36_ = _tmp35_.width;
		max_offset = _tmp34_ - _tmp36_;
		_tmp38_ = right_aligned;
		if (_tmp38_) {
			_tmp37_ = TRUE;
		} else {
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			_tmp39_ = book_view_get_x_offset (self);
			_tmp40_ = max_offset;
			_tmp37_ = _tmp39_ > _tmp40_;
		}
		_tmp41_ = _tmp37_;
		if (_tmp41_) {
			gint _tmp42_ = 0;
			_tmp42_ = max_offset;
			book_view_set_x_offset (self, _tmp42_);
		}
		_tmp43_ = self->priv->scroll;
		gtk_widget_show ((GtkWidget*) _tmp43_);
	} else {
		GtkScrollbar* _tmp44_ = NULL;
		gint offset = 0;
		gint _tmp45_ = 0;
		GtkAllocation _tmp46_ = {0};
		gint _tmp47_ = 0;
		GtkAdjustment* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		GtkAdjustment* _tmp50_ = NULL;
		gint _tmp51_ = 0;
		GtkAdjustment* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		_tmp44_ = self->priv->scroll;
		gtk_widget_hide ((GtkWidget*) _tmp44_);
		_tmp45_ = book_width;
		_tmp46_ = allocation;
		_tmp47_ = _tmp46_.width;
		offset = (_tmp45_ - _tmp47_) / 2;
		_tmp48_ = self->priv->adjustment;
		_tmp49_ = offset;
		gtk_adjustment_set_lower (_tmp48_, (gdouble) _tmp49_);
		_tmp50_ = self->priv->adjustment;
		_tmp51_ = offset;
		gtk_adjustment_set_upper (_tmp50_, (gdouble) _tmp51_);
		_tmp52_ = self->priv->adjustment;
		gtk_adjustment_set_page_size (_tmp52_, (gdouble) 0);
		_tmp53_ = offset;
		book_view_set_x_offset (self, _tmp53_);
	}
	_tmp54_ = self->priv->show_selected_page;
	if (_tmp54_) {
		PageView* _tmp55_ = NULL;
		_tmp55_ = self->priv->selected_page;
		book_view_show_page_view (self, _tmp55_);
	}
	self->priv->need_layout = FALSE;
	self->priv->show_selected_page = FALSE;
	self->priv->laying_out = FALSE;
}


static gboolean book_view_draw_cb (BookView* self, GtkWidget* widget, cairo_t* context) {
	gboolean result = FALSE;
	Book* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gdouble left = 0.0;
	gdouble top = 0.0;
	gdouble right = 0.0;
	gdouble bottom = 0.0;
	cairo_t* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = self->priv->book;
	_tmp1_ = book_get_n_pages (_tmp0_);
	if (_tmp1_ == ((guint) 0)) {
		result = FALSE;
		return result;
	}
	book_view_layout (self);
	_tmp2_ = context;
	cairo_clip_extents (_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	left = _tmp3_;
	top = _tmp4_;
	right = _tmp5_;
	bottom = _tmp6_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_ = FALSE;
				gint _tmp10_ = 0;
				Book* _tmp11_ = NULL;
				guint _tmp12_ = 0U;
				PageView* page = NULL;
				gint _tmp13_ = 0;
				PageView* _tmp14_ = NULL;
				gint left_edge = 0;
				PageView* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				gint right_edge = 0;
				PageView* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				PageView* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gboolean _tmp23_ = FALSE;
				gint _tmp24_ = 0;
				gdouble _tmp25_ = 0.0;
				gboolean _tmp28_ = FALSE;
				cairo_t* _tmp29_ = NULL;
				cairo_t* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				PageView* _tmp32_ = NULL;
				cairo_t* _tmp33_ = NULL;
				cairo_t* _tmp34_ = NULL;
				PageView* _tmp35_ = NULL;
				gboolean _tmp36_ = FALSE;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = self->priv->book;
				_tmp12_ = book_get_n_pages (_tmp11_);
				if (!(((guint) _tmp10_) < _tmp12_)) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = book_view_get_nth_page (self, _tmp13_);
				page = _tmp14_;
				_tmp15_ = page;
				_tmp16_ = page_view_get_x_offset (_tmp15_);
				_tmp17_ = book_view_get_x_offset (self);
				left_edge = _tmp16_ - _tmp17_;
				_tmp18_ = page;
				_tmp19_ = page_view_get_x_offset (_tmp18_);
				_tmp20_ = page;
				_tmp21_ = page_view_get_width (_tmp20_);
				_tmp22_ = book_view_get_x_offset (self);
				right_edge = (_tmp19_ + _tmp21_) - _tmp22_;
				_tmp24_ = right_edge;
				_tmp25_ = left;
				if (((gdouble) _tmp24_) < _tmp25_) {
					_tmp23_ = TRUE;
				} else {
					gint _tmp26_ = 0;
					gdouble _tmp27_ = 0.0;
					_tmp26_ = left_edge;
					_tmp27_ = right;
					_tmp23_ = ((gdouble) _tmp26_) > _tmp27_;
				}
				_tmp28_ = _tmp23_;
				if (_tmp28_) {
					_page_view_unref0 (page);
					continue;
				}
				_tmp29_ = context;
				cairo_save (_tmp29_);
				_tmp30_ = context;
				_tmp31_ = book_view_get_x_offset (self);
				cairo_translate (_tmp30_, (gdouble) (-_tmp31_), (gdouble) 0);
				_tmp32_ = page;
				_tmp33_ = context;
				page_view_render (_tmp32_, _tmp33_);
				_tmp34_ = context;
				cairo_restore (_tmp34_);
				_tmp35_ = page;
				_tmp36_ = page_view_get_selected (_tmp35_);
				if (_tmp36_) {
					GtkWidget* _tmp37_ = NULL;
					GtkStyleContext* _tmp38_ = NULL;
					cairo_t* _tmp39_ = NULL;
					PageView* _tmp40_ = NULL;
					gint _tmp41_ = 0;
					gint _tmp42_ = 0;
					PageView* _tmp43_ = NULL;
					gint _tmp44_ = 0;
					PageView* _tmp45_ = NULL;
					gint _tmp46_ = 0;
					PageView* _tmp47_ = NULL;
					gint _tmp48_ = 0;
					_tmp37_ = self->priv->drawing_area;
					_tmp38_ = gtk_widget_get_style_context (_tmp37_);
					_tmp39_ = context;
					_tmp40_ = page;
					_tmp41_ = page_view_get_x_offset (_tmp40_);
					_tmp42_ = book_view_get_x_offset (self);
					_tmp43_ = page;
					_tmp44_ = page_view_get_y_offset (_tmp43_);
					_tmp45_ = page;
					_tmp46_ = page_view_get_width (_tmp45_);
					_tmp47_ = page;
					_tmp48_ = page_view_get_height (_tmp47_);
					gtk_render_focus (_tmp38_, _tmp39_, (gdouble) (_tmp41_ - _tmp42_), (gdouble) _tmp44_, (gdouble) _tmp46_, (gdouble) _tmp48_);
				}
				_page_view_unref0 (page);
			}
		}
	}
	result = FALSE;
	return result;
}


static PageView* book_view_get_page_at (BookView* self, gint x, gint y, gint* x_, gint* y_) {
	gint _vala_x_ = 0;
	gint _vala_y_ = 0;
	PageView* result = NULL;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_y_ = 0;
	_tmp0_ = _vala_y_;
	_vala_x_ = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				gint _tmp4_ = 0;
				Book* _tmp5_ = NULL;
				guint _tmp6_ = 0U;
				PageView* page = NULL;
				gint _tmp7_ = 0;
				PageView* _tmp8_ = NULL;
				gint left = 0;
				PageView* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gint right = 0;
				gint _tmp11_ = 0;
				PageView* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gint top = 0;
				PageView* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint bottom = 0;
				gint _tmp16_ = 0;
				PageView* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gboolean _tmp26_ = FALSE;
				gboolean _tmp29_ = FALSE;
				gboolean _tmp32_ = FALSE;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->priv->book;
				_tmp6_ = book_get_n_pages (_tmp5_);
				if (!(((guint) _tmp4_) < _tmp6_)) {
					break;
				}
				_tmp7_ = i;
				_tmp8_ = book_view_get_nth_page (self, _tmp7_);
				page = _tmp8_;
				_tmp9_ = page;
				_tmp10_ = page_view_get_x_offset (_tmp9_);
				left = _tmp10_;
				_tmp11_ = left;
				_tmp12_ = page;
				_tmp13_ = page_view_get_width (_tmp12_);
				right = _tmp11_ + _tmp13_;
				_tmp14_ = page;
				_tmp15_ = page_view_get_y_offset (_tmp14_);
				top = _tmp15_;
				_tmp16_ = top;
				_tmp17_ = page;
				_tmp18_ = page_view_get_height (_tmp17_);
				bottom = _tmp16_ + _tmp18_;
				_tmp22_ = x;
				_tmp23_ = left;
				if (_tmp22_ >= _tmp23_) {
					gint _tmp24_ = 0;
					gint _tmp25_ = 0;
					_tmp24_ = x;
					_tmp25_ = right;
					_tmp21_ = _tmp24_ <= _tmp25_;
				} else {
					_tmp21_ = FALSE;
				}
				_tmp26_ = _tmp21_;
				if (_tmp26_) {
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
					_tmp27_ = y;
					_tmp28_ = top;
					_tmp20_ = _tmp27_ >= _tmp28_;
				} else {
					_tmp20_ = FALSE;
				}
				_tmp29_ = _tmp20_;
				if (_tmp29_) {
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
					_tmp30_ = y;
					_tmp31_ = bottom;
					_tmp19_ = _tmp30_ <= _tmp31_;
				} else {
					_tmp19_ = FALSE;
				}
				_tmp32_ = _tmp19_;
				if (_tmp32_) {
					gint _tmp33_ = 0;
					gint _tmp34_ = 0;
					gint _tmp35_ = 0;
					gint _tmp36_ = 0;
					_tmp33_ = x;
					_tmp34_ = left;
					_vala_x_ = _tmp33_ - _tmp34_;
					_tmp35_ = y;
					_tmp36_ = top;
					_vala_y_ = _tmp35_ - _tmp36_;
					result = page;
					if (x_) {
						*x_ = _vala_x_;
					}
					if (y_) {
						*y_ = _vala_y_;
					}
					return result;
				}
				_page_view_unref0 (page);
			}
		}
	}
	result = NULL;
	if (x_) {
		*x_ = _vala_x_;
	}
	if (y_) {
		*y_ = _vala_y_;
	}
	return result;
}


static gboolean book_view_button_cb (BookView* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	gint x = 0;
	gint y = 0;
	GdkEventButton _tmp1_ = {0};
	GdkEventType _tmp2_ = 0;
	PageView* _tmp12_ = NULL;
	GdkEventButton _tmp13_ = {0};
	guint _tmp14_ = 0U;
	GdkEventButton _tmp29_ = {0};
	guint _tmp30_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	book_view_layout (self);
	_tmp0_ = self->priv->drawing_area;
	gtk_widget_grab_focus (_tmp0_);
	x = 0;
	y = 0;
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.type;
	if (_tmp2_ == GDK_BUTTON_PRESS) {
		GdkEventButton _tmp3_ = {0};
		gdouble _tmp4_ = 0.0;
		gint _tmp5_ = 0;
		GdkEventButton _tmp6_ = {0};
		gdouble _tmp7_ = 0.0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		PageView* _tmp10_ = NULL;
		PageView* _tmp11_ = NULL;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.x;
		_tmp5_ = book_view_get_x_offset (self);
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.y;
		_tmp10_ = book_view_get_page_at (self, (gint) (_tmp4_ + _tmp5_), (gint) _tmp7_, &_tmp8_, &_tmp9_);
		x = _tmp8_;
		y = _tmp9_;
		_tmp11_ = _tmp10_;
		book_view_select_page_view (self, _tmp11_);
		_page_view_unref0 (_tmp11_);
	}
	_tmp12_ = self->priv->selected_page;
	if (_tmp12_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp13_ = *event;
	_tmp14_ = _tmp13_.button;
	if (_tmp14_ == ((guint) 1)) {
		GdkEventButton _tmp15_ = {0};
		GdkEventType _tmp16_ = 0;
		_tmp15_ = *event;
		_tmp16_ = _tmp15_.type;
		if (_tmp16_ == GDK_BUTTON_PRESS) {
			PageView* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			_tmp17_ = self->priv->selected_page;
			_tmp18_ = x;
			_tmp19_ = y;
			page_view_button_press (_tmp17_, _tmp18_, _tmp19_);
		} else {
			GdkEventButton _tmp20_ = {0};
			GdkEventType _tmp21_ = 0;
			_tmp20_ = *event;
			_tmp21_ = _tmp20_.type;
			if (_tmp21_ == GDK_BUTTON_RELEASE) {
				PageView* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				_tmp22_ = self->priv->selected_page;
				_tmp23_ = x;
				_tmp24_ = y;
				page_view_button_release (_tmp22_, _tmp23_, _tmp24_);
			} else {
				GdkEventButton _tmp25_ = {0};
				GdkEventType _tmp26_ = 0;
				_tmp25_ = *event;
				_tmp26_ = _tmp25_.type;
				if (_tmp26_ == GDK_2BUTTON_PRESS) {
					Page* _tmp27_ = NULL;
					Page* _tmp28_ = NULL;
					_tmp27_ = book_view_get_selected (self);
					_tmp28_ = _tmp27_;
					g_signal_emit_by_name (self, "show-page", _tmp28_);
					_page_unref0 (_tmp28_);
				}
			}
		}
	}
	_tmp29_ = *event;
	_tmp30_ = _tmp29_.button;
	if (_tmp30_ == ((guint) 3)) {
		g_signal_emit_by_name (self, "show-menu");
	}
	result = FALSE;
	return result;
}


static void book_view_set_cursor (BookView* self, GdkCursorType cursor) {
	GdkCursor* c = NULL;
	GdkCursorType _tmp0_ = 0;
	GdkCursorType _tmp1_ = 0;
	GdkCursorType _tmp2_ = 0;
	GdkCursorType _tmp3_ = 0;
	GdkCursor* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GdkWindow* _tmp6_ = NULL;
	GdkCursor* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cursor;
	_tmp1_ = cursor;
	if (_tmp0_ == _tmp1_) {
		_g_object_unref0 (c);
		return;
	}
	_tmp2_ = cursor;
	self->priv->cursor = _tmp2_;
	_tmp3_ = cursor;
	_tmp4_ = gdk_cursor_new (_tmp3_);
	_g_object_unref0 (c);
	c = _tmp4_;
	_tmp5_ = self->priv->drawing_area;
	_tmp6_ = gtk_widget_get_window (_tmp5_);
	_tmp7_ = c;
	gdk_window_set_cursor (_tmp6_, _tmp7_);
	_g_object_unref0 (c);
}


static gboolean book_view_motion_cb (BookView* self, GtkWidget* widget, GdkEventMotion* event) {
	gboolean result = FALSE;
	GdkCursorType cursor = 0;
	gboolean _tmp0_ = FALSE;
	PageView* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	GdkCursorType _tmp33_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	cursor = GDK_ARROW;
	_tmp1_ = self->priv->selected_page;
	if (_tmp1_ != NULL) {
		GdkEventMotion _tmp2_ = {0};
		GdkModifierType _tmp3_ = 0;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.state;
		_tmp0_ = (_tmp3_ & GDK_BUTTON1_MASK) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		gint x = 0;
		GdkEventMotion _tmp5_ = {0};
		gdouble _tmp6_ = 0.0;
		gint _tmp7_ = 0;
		PageView* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint y = 0;
		GdkEventMotion _tmp10_ = {0};
		gdouble _tmp11_ = 0.0;
		PageView* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		PageView* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		PageView* _tmp17_ = NULL;
		GdkCursorType _tmp18_ = 0;
		_tmp5_ = *event;
		_tmp6_ = _tmp5_.x;
		_tmp7_ = book_view_get_x_offset (self);
		_tmp8_ = self->priv->selected_page;
		_tmp9_ = page_view_get_x_offset (_tmp8_);
		x = (gint) ((_tmp6_ + _tmp7_) - _tmp9_);
		_tmp10_ = *event;
		_tmp11_ = _tmp10_.y;
		_tmp12_ = self->priv->selected_page;
		_tmp13_ = page_view_get_y_offset (_tmp12_);
		y = (gint) (_tmp11_ - _tmp13_);
		_tmp14_ = self->priv->selected_page;
		_tmp15_ = x;
		_tmp16_ = y;
		page_view_motion (_tmp14_, _tmp15_, _tmp16_);
		_tmp17_ = self->priv->selected_page;
		_tmp18_ = page_view_get_cursor (_tmp17_);
		cursor = _tmp18_;
	} else {
		gint x = 0;
		gint y = 0;
		PageView* over_page = NULL;
		GdkEventMotion _tmp19_ = {0};
		gdouble _tmp20_ = 0.0;
		gint _tmp21_ = 0;
		GdkEventMotion _tmp22_ = {0};
		gdouble _tmp23_ = 0.0;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		PageView* _tmp26_ = NULL;
		PageView* _tmp27_ = NULL;
		_tmp19_ = *event;
		_tmp20_ = _tmp19_.x;
		_tmp21_ = book_view_get_x_offset (self);
		_tmp22_ = *event;
		_tmp23_ = _tmp22_.y;
		_tmp26_ = book_view_get_page_at (self, (gint) (_tmp20_ + _tmp21_), (gint) _tmp23_, &_tmp24_, &_tmp25_);
		x = _tmp24_;
		y = _tmp25_;
		over_page = _tmp26_;
		_tmp27_ = over_page;
		if (_tmp27_ != NULL) {
			PageView* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			PageView* _tmp31_ = NULL;
			GdkCursorType _tmp32_ = 0;
			_tmp28_ = over_page;
			_tmp29_ = x;
			_tmp30_ = y;
			page_view_motion (_tmp28_, _tmp29_, _tmp30_);
			_tmp31_ = over_page;
			_tmp32_ = page_view_get_cursor (_tmp31_);
			cursor = _tmp32_;
		}
		_page_view_unref0 (over_page);
	}
	_tmp33_ = cursor;
	book_view_set_cursor (self, _tmp33_);
	result = FALSE;
	return result;
}


static gboolean book_view_key_cb (BookView* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey _tmp0_ = {0};
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.keyval;
	switch (_tmp1_) {
		case 0xff50:
		{
			Book* _tmp2_ = NULL;
			Page* _tmp3_ = NULL;
			Page* _tmp4_ = NULL;
			_tmp2_ = self->priv->book;
			_tmp3_ = book_get_page (_tmp2_, 0);
			_tmp4_ = _tmp3_;
			book_view_select_page (self, _tmp4_);
			_page_unref0 (_tmp4_);
			result = TRUE;
			return result;
		}
		case 0xff51:
		{
			PageView* _tmp5_ = NULL;
			PageView* _tmp6_ = NULL;
			PageView* _tmp7_ = NULL;
			_tmp5_ = self->priv->selected_page;
			_tmp6_ = book_view_get_prev_page (self, _tmp5_);
			_tmp7_ = _tmp6_;
			book_view_select_page_view (self, _tmp7_);
			_page_view_unref0 (_tmp7_);
			result = TRUE;
			return result;
		}
		case 0xff53:
		{
			PageView* _tmp8_ = NULL;
			PageView* _tmp9_ = NULL;
			PageView* _tmp10_ = NULL;
			_tmp8_ = self->priv->selected_page;
			_tmp9_ = book_view_get_next_page (self, _tmp8_);
			_tmp10_ = _tmp9_;
			book_view_select_page_view (self, _tmp10_);
			_page_view_unref0 (_tmp10_);
			result = TRUE;
			return result;
		}
		case 0xFF57:
		{
			Book* _tmp11_ = NULL;
			Book* _tmp12_ = NULL;
			guint _tmp13_ = 0U;
			Page* _tmp14_ = NULL;
			Page* _tmp15_ = NULL;
			_tmp11_ = self->priv->book;
			_tmp12_ = self->priv->book;
			_tmp13_ = book_get_n_pages (_tmp12_);
			_tmp14_ = book_get_page (_tmp11_, ((gint) _tmp13_) - 1);
			_tmp15_ = _tmp14_;
			book_view_select_page (self, _tmp15_);
			_page_unref0 (_tmp15_);
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gboolean book_view_focus_cb (BookView* self, GtkWidget* widget, GdkEventFocus* event) {
	gboolean result = FALSE;
	PageView* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->selected_page;
	book_view_set_selected_page (self, _tmp0_);
	result = FALSE;
	return result;
}


static void book_view_scroll_cb (BookView* self, GtkAdjustment* adjustment) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->laying_out;
	if (!_tmp0_) {
		book_view_redraw (self);
	}
}


void book_view_redraw (BookView* self) {
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->drawing_area;
	gtk_widget_queue_draw (_tmp0_);
}


void book_view_select_page (BookView* self, Page* page) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	Page* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = book_view_get_selected (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = page;
	_tmp3_ = _tmp1_ == _tmp2_;
	_page_unref0 (_tmp1_);
	if (_tmp3_) {
		return;
	}
	_tmp4_ = page;
	if (_tmp4_ != NULL) {
		GHashTable* _tmp5_ = NULL;
		Page* _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		_tmp5_ = self->priv->page_data;
		_tmp6_ = page;
		_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
		book_view_select_page_view (self, (PageView*) _tmp7_);
	} else {
		book_view_select_page_view (self, NULL);
	}
}


void book_view_select_next_page (BookView* self) {
	PageView* _tmp0_ = NULL;
	PageView* _tmp1_ = NULL;
	PageView* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_page;
	_tmp1_ = book_view_get_next_page (self, _tmp0_);
	_tmp2_ = _tmp1_;
	book_view_select_page_view (self, _tmp2_);
	_page_view_unref0 (_tmp2_);
}


void book_view_select_prev_page (BookView* self) {
	PageView* _tmp0_ = NULL;
	PageView* _tmp1_ = NULL;
	PageView* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_page;
	_tmp1_ = book_view_get_prev_page (self, _tmp0_);
	_tmp2_ = _tmp1_;
	book_view_select_page_view (self, _tmp2_);
	_page_view_unref0 (_tmp2_);
}


Page* book_view_get_selected (BookView* self) {
	Page* result = NULL;
	PageView* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->selected_page;
	if (_tmp0_ != NULL) {
		PageView* _tmp1_ = NULL;
		Page* _tmp2_ = NULL;
		_tmp1_ = self->priv->selected_page;
		_tmp2_ = page_view_get_page (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}


static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__PAGE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__PAGE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__PAGE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_page (param_values + 1), data2);
}


static void book_view_class_init (BookViewClass * klass) {
	book_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BookViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = book_view_finalize;
	g_signal_new ("page_selected", TYPE_BOOK_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
	g_signal_new ("show_page", TYPE_BOOK_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
	g_signal_new ("show_menu", TYPE_BOOK_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void book_view_instance_init (BookView * self) {
	self->priv = BOOK_VIEW_GET_PRIVATE (self);
	self->priv->selected_page = NULL;
}


static void book_view_finalize (GObject* obj) {
	BookView * self;
	Book* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Book* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Book* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	Book* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	GtkWidget* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	GtkWidget* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	GtkWidget* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	GtkWidget* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	GtkWidget* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	GtkWidget* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	GtkWidget* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	GtkWidget* _tmp22_ = NULL;
	guint _tmp23_ = 0U;
	GtkAdjustment* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK_VIEW, BookView);
	_tmp0_ = self->priv->book;
	g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_view_add_cb_book_page_added, self);
	_tmp2_ = self->priv->book;
	g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_view_remove_cb_book_page_removed, self);
	_tmp4_ = self->priv->book;
	g_signal_parse_name ("reordered", TYPE_BOOK, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_view_reorder_cb_book_reordered, self);
	_tmp6_ = self->priv->book;
	g_signal_parse_name ("cleared", TYPE_BOOK, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _book_view_clear_cb_book_cleared, self);
	_tmp8_ = self->priv->drawing_area;
	g_signal_parse_name ("configure-event", GTK_TYPE_WIDGET, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _book_view_configure_cb_gtk_widget_configure_event, self);
	_tmp10_ = self->priv->drawing_area;
	g_signal_parse_name ("draw", GTK_TYPE_WIDGET, &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _book_view_draw_cb_gtk_widget_draw, self);
	_tmp12_ = self->priv->drawing_area;
	g_signal_parse_name ("motion-notify-event", GTK_TYPE_WIDGET, &_tmp13_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _book_view_motion_cb_gtk_widget_motion_notify_event, self);
	_tmp14_ = self->priv->drawing_area;
	g_signal_parse_name ("key-press-event", GTK_TYPE_WIDGET, &_tmp15_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _book_view_key_cb_gtk_widget_key_press_event, self);
	_tmp16_ = self->priv->drawing_area;
	g_signal_parse_name ("button-press-event", GTK_TYPE_WIDGET, &_tmp17_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _book_view_button_cb_gtk_widget_button_press_event, self);
	_tmp18_ = self->priv->drawing_area;
	g_signal_parse_name ("button-release-event", GTK_TYPE_WIDGET, &_tmp19_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _book_view_button_cb_gtk_widget_button_release_event, self);
	_tmp20_ = self->priv->drawing_area;
	g_signal_parse_name ("focus-in-event", GTK_TYPE_WIDGET, &_tmp21_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp20_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp21_, 0, NULL, (GCallback) _book_view_focus_cb_gtk_widget_focus_in_event, self);
	_tmp22_ = self->priv->drawing_area;
	g_signal_parse_name ("focus-out-event", GTK_TYPE_WIDGET, &_tmp23_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _book_view_focus_cb_gtk_widget_focus_out_event, self);
	_tmp24_ = self->priv->adjustment;
	g_signal_parse_name ("value-changed", GTK_TYPE_ADJUSTMENT, &_tmp25_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp24_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp25_, 0, NULL, (GCallback) _book_view_scroll_cb_gtk_adjustment_value_changed, self);
	_book_unref0 (self->priv->book);
	_g_hash_table_unref0 (self->priv->page_data);
	_page_view_unref0 (self->priv->selected_page);
	_g_object_unref0 (self->priv->drawing_area);
	_g_object_unref0 (self->priv->scroll);
	_g_object_unref0 (self->priv->adjustment);
	G_OBJECT_CLASS (book_view_parent_class)->finalize (obj);
}


GType book_view_get_type (void) {
	static volatile gsize book_view_type_id__volatile = 0;
	if (g_once_init_enter (&book_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BookViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookView), 0, (GInstanceInitFunc) book_view_instance_init, NULL };
		GType book_view_type_id;
		book_view_type_id = g_type_register_static (GTK_TYPE_VBOX, "BookView", &g_define_type_info, 0);
		g_once_init_leave (&book_view_type_id__volatile, book_view_type_id);
	}
	return book_view_type_id__volatile;
}



