/*
 * Copyright (C) 2016 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package ifacestate

import (
	"errors"

	"gopkg.in/tomb.v2"

	"github.com/snapcore/snapd/overlord/state"
)

var (
	AddImplicitSlots = addImplicitSlots
)

func MockConflictPredicate(pred func(string) bool) (restore func()) {
	old := noConflictOnConnectTasks
	noConflictOnConnectTasks = pred
	return func() { noConflictOnConnectTasks = old }
}

// AddForeignTaskHandlers registers handlers for tasks handled outside of the
// InterfaceManager.
func (m *InterfaceManager) AddForeignTaskHandlers() {
	// Add handler to test full aborting of changes
	erroringHandler := func(task *state.Task, _ *tomb.Tomb) error {
		return errors.New("error out")
	}
	m.runner.AddHandler("error-trigger", erroringHandler, nil)
}
