/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.helpers;

import java.util.HashSet;
import java.util.Set;
import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.SailChangedEvent;
import org.openrdf.sail.SailChangedListener;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailBase;

public abstract class NotifyingSailBase
extends SailBase
implements NotifyingSail {
    private Set<SailChangedListener> sailChangedListeners = new HashSet<SailChangedListener>(0);

    public NotifyingSailConnection getConnection() throws SailException {
        return (NotifyingSailConnection)super.getConnection();
    }

    protected abstract NotifyingSailConnection getConnectionInternal() throws SailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSailChangedListener(SailChangedListener listener) {
        Set<SailChangedListener> set = this.sailChangedListeners;
        synchronized (set) {
            this.sailChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSailChangedListener(SailChangedListener listener) {
        Set<SailChangedListener> set = this.sailChangedListeners;
        synchronized (set) {
            this.sailChangedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySailChanged(SailChangedEvent event) {
        Set<SailChangedListener> set = this.sailChangedListeners;
        synchronized (set) {
            for (SailChangedListener l : this.sailChangedListeners) {
                l.sailChanged(event);
            }
        }
    }
}

