# ui_tests.py - unit tests for ui.py
# Copyright (C) 2008  Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import unittest

import cruftremover


class UserInterfaceTests(unittest.TestCase):

    def setUp(self):
        self.ui = cruftremover.UserInterface("app", "pm")
        
    def testReturnsCorrectApp(self):
        self.assertEqual(self.ui.app, "app")
    
    def testReturnsCorrectPluginManager(self):
        self.assertEqual(self.ui.pm, "pm")
    
    def testRunRaisesUnimplemented(self):
        self.assertRaises(cruftremover.UnimplementedMethod, 
                          self.ui.run, None, None)
