#ifndef TAGCOLL_TEXTFORMAT_H
#define TAGCOLL_TEXTFORMAT_H

/** \file
 * Serialize and deserialize a tagged collection to a text file
 */

/*
 * Copyright (C) 2003,2004,2005  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tagcoll/Consumer.h>
#include <tagcoll/Serializer.h>
#include <tagcoll/Exception.h>
#include <tagcoll/ParserBase.h>

#include <stdio.h>

//#define TRACE_PARSE

namespace Tagcoll
{
template<class ITEM, class TAG>
class PatchList;

/**
 * TagcollConsumer that serializes its input to an output stream
 *
 * The format of the output is:
 *   lines of "comma+space"-separated items, followed by "colon+space",
 *   followed by the corresponding "comma+space"-separated tags.
 * Examples:
 *   ITEM:
 *   ITEM: TAG
 *   ITEM: TAG1, TAG2, TAG3
 *   ITEM1, ITEM2, ITEM3:
 *   ITEM1, ITEM2, ITEM3: TAG1, TAG2, TAG3
 */
template<class ITEM, class TAG>
class TextFormat : public Consumer<ITEM, TAG>
{
protected:
	Converter<ITEM, std::string> itemconv;
	Converter<TAG, std::string> tagconv;
	FILE* out;

	virtual void consumeItemUntagged(const ITEM& item);
	virtual void consumeItem(const ITEM& item, const OpSet<TAG>& tags);
	virtual void consumeItemsUntagged(const OpSet<ITEM>& items);
	virtual void consumeItems(const OpSet<ITEM>& items, const OpSet<TAG>& tags);

public:
	TextFormat(
			const Converter<ITEM, std::string>& itemconv,
			const Converter<TAG, std::string>& tagconv,
			FILE* out) : itemconv(itemconv), tagconv(tagconv), out(out) {}
	virtual ~TextFormat() {}


	/**
	 * Serialize a patch
	 */
	static void outputPatch(
			Converter<ITEM, std::string>& itemconv,
			Converter<TAG, std::string>& tagconv,
			const PatchList<ITEM, TAG>& patch,
			FILE* out);

	/**
	 * Parse a tagged collection, sending the data to `consumer'
	 */
	static void parse(
			Converter<std::string, ITEM>& itemconv,
			Converter<std::string, TAG>& tagconv,
			ParserInput& in,
			Consumer<ITEM, TAG>& consumer);

	/**
	 * Parse a tagcoll patch
	 */
	static PatchList<ITEM, TAG> parsePatch(
			Converter<std::string, ITEM>& itemconv,
			Converter<std::string, TAG>& tagconv,
			ParserInput& in);
};

};

// vim:set ts=4 sw=4:
#endif
