/*
 * Filter interface for a stream of tagged items
 *
 * Copyright (C) 2003,2004,2005  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tagcoll/Filter.h>

#ifndef INSTANTIATING_TEMPLATES
#include <string>

namespace Tagcoll {
template class Filter<std::string, std::string>;
template class FilterChain<std::string, std::string>;
}
#endif


#ifdef COMPILE_TESTSUITE

#include <tests/test-utils.h>

#include <tagcoll/InputMerger.h>

#include <iostream>

namespace tut {
using namespace tut_tagcoll;

struct tagcoll_filter_shar {
};
TESTGRP(tagcoll_filter);

class TestFilter : public Tagcoll::Filter<std::string, std::string>
{
protected:
	std::string toadd;

	virtual void consumeItemUntagged(const std::string& item)
	{
//		fprintf(stderr, "Fancuno\n");
//		std::cerr << "adding untagged" << std::endl;
		OpSet<string> tags;
		tags += "untagged";
		consumer->consume(item, tags);
	}
	virtual void consumeItem(const std::string& item, const OpSet<std::string>& tags)
	{
//		fprintf(stderr, "Fancdue\n");
		OpSet<string> tags1;
		for (OpSet<string>::const_iterator i = tags.begin();
				i != tags.end(); i++)
			if (*i == "removeme")
//				std::cerr << "Removing removeme from " << item << std::endl;
				;
			else if (*i == "add")
			{
//				std::cerr << "Adding " << toadd << " to " << item << std::endl;
				tags1 += toadd;
				tags1 += *i;
			}
			else
			{
//				std::cerr << "Passing " << *i << " on for " << item << std::endl;
				tags1 += *i;
			}

		if (tags1.empty())
			consumer->consume(item);
		else
			consumer->consume(item, tags1);
	}

public:
	TestFilter(const std::string& toadd = "added")
		: Tagcoll::Filter<string, string>(), toadd(toadd) { /* cerr << "foo" << toadd << endl */; }
	TestFilter(Consumer<string, string>& consumer, const std::string& toadd = "added")
		: Tagcoll::Filter<string, string>(consumer), toadd(toadd) { /* cerr << "foo" << toadd << endl */; }
};


template<> template<>
void to::test<1>()
{
//	fprintf(stderr, "UGA UGA \n");

	std::string input_coll(
			"a: removeme\n"
			"b:\n"
			"c: foo, bar\n"
			"d: baz, removeme, add\n"
			);
	std::string output_coll(
			"a:\n"
			"b:\n"
			"c: foo, bar\n"
			"d: baz, add, added\n"
			);
	InputMerger<string, string> result;
	TestFilter filter(result);

	ensure(filter.isComplete());

	outputCollection(input_coll, filter); 

	InputMerger<string, string> reference;
	outputCollection(output_coll, reference); 

	ensure_coll_equal(reference, result);
}

template<> template<>
void to::test<2>()
{
	std::string input_coll(
			"a: removeme\n"
			"b:\n"
			"c: foo, bar\n"
			"d: baz, removeme, add\n"
			);
	std::string output_coll(
			"a:\n"
			"b:\n"
			"c: foo, bar\n"
			"d: baz, add, add2, added\n"
			);
	InputMerger<string, string> result;
	FilterChain<string, string> chain;

	TestFilter filter1;
	TestFilter filter2("add2");

	ensure(!filter1.isComplete());
	ensure(!filter2.isComplete());

	chain.appendFilter(filter1);
	chain.setConsumer(result);
	chain.appendFilter(filter2);

	ensure_equals(&(chain.getConsumer()), &filter1);
	ensure_equals(&(filter1.getConsumer()), &filter2);
	ensure_equals(&(filter2.getConsumer()), &result);

	outputCollection(input_coll, chain); 

	InputMerger<string, string> reference;
	outputCollection(output_coll, reference); 

	ensure_coll_equal(reference, result);
}

}

#endif

// vim:set ts=4 sw=4:
