/*
 * Generic std::string helpers
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#if __GNUC__ < 3
#define _GNU_SOURCE
#endif

#include <tagcoll/stringf.h>

#include <stdio.h>
#include <stdarg.h>

int stringf::addf(std::string& str, const char* fmt, ...) throw() ATTR_PRINTF(2, 3)
{
	char *buf;
	va_list ap;
	va_start(ap, fmt);
	int res = vasprintf(&buf, fmt, ap);
	va_end(ap);
	str += buf;
	free(buf);
	return res;
}

std::string stringf::fmt(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
	char *buf;
	va_list ap;
	va_start(ap, fmt);
	vasprintf(&buf, fmt, ap);
	va_end(ap);
	std::string res(buf);
	free(buf);
	return res;
}

std::string stringf::fmt(int val) throw() { return fmt("%i", val); }
std::string stringf::fmt(unsigned int val) throw() { return fmt("%u", val); }
std::string stringf::fmt(long int val) throw() { return fmt("%li", val); }
std::string stringf::fmt(long unsigned int val) throw() { return fmt("%lu", val); }

// vim:set ts=4 sw=4:
