#include <tagcoll/experiments.h>
#include <tagcoll/Serializer.h>
#include <tagcoll/TextFormat.h>
#include <tagcoll/StdioParserInput.h>

#include <stdarg.h>

using namespace std;
using namespace Tagcoll;

int main (int argc, char *argv[])
{
	try {
		// Install the handler for unexpected exceptions
		InstallUnexpected installUnexpected;
		Converter<string, string> conv;
		Normalizer<string, string> norm(1.0);
		StdioParserInput in(stdin, "(stdin)");

		Scores<string> scores(0.7);
		scores.add("culture::* || use::*", 1.1);
		scores.add("implemented-in::*", 0.3);
		scores.add("*::TODO", 0.1);

		TextFormat<string, string>::parse(conv, conv, in, norm);

		norm.buildGraph(scores);
		norm.normalize();

		TextFormat<string, string> writer(conv, conv, stdout);
		norm.output(writer);

		return 0;
	} catch (Exception& e) {
		fprintf(stderr, "%s: %.*s\n", e.type(), PFSTR(e.desc()));
	}
}

// vim:set ts=4 sw=4:
