#!/usr/bin/env perl
# Place ogjava.perl at: src/java/ogjava.perl
#
# Alternative 1
# -------------
#     perl nogjava.perl
#     cd work.dir
#     yourjavac *.java */*.java */*/*.java
#
# Alternative 2 (assumes javac for yourjavac)
# -------------
#     perl nogjava.perl -j
#
# Alternative 3 (assumes ecj for yourjavac)
# -------------
#     perl nogjava.perl -e
#
##########################################################
# nogjava.perl                          2007-01-30-10:56 #
# Copyright (C) 2007          Eitan M. Gurari            #
#                                                        #
# This work may be distributed and/or modified under the #
# conditions of the LaTeX Project Public License, either #
# version 1.3c of this license or (at your option) any   #
# later version. The latest version of this license is   #
# in                                                     #
#   http://www.latex-project.org/lppl.txt                #
# and version 1.3c or later is part of all distributions #
# of LaTeX version 2006/05/20 or later.                  #
#                                                        #
# This work has the LPPL maintenance status "maintained".#
#                                                        #
# The Current Maintainer of this work                    #
# is Eitan M. Gurari.                                    #
#                                                        #
# If you modify this program your changing its signature #
# within 'print "nogjava (2007-01-30-10:56)\n";' will be #
# appreciated.                                           #
#                                                        #
#                             gurari@cse.ohio-state.edu  #
#                 http://www.cse.ohio-state.edu/~gurari  #
##########################################################
print "nogjava (2007-01-30-10:56)\n";


use strict;
my $javac = "";
if( @ARGV[0] eq "-e" ){
  $javac = "ecj -1.5";
}
if( @ARGV[0] eq "-j" ){
  $javac = "javac -Xlint:unchecked";
}

sub deleteDirOrFile($) {
   my $dir = shift;
   local *DIR;
   opendir(DIR, $dir) || die "Can not open directory $dir: $!";
   while ($_ = readdir DIR) {
     next if /^\.{1,2}$/;        
       my $path = "$dir/$_";
         unlink $path if -f $path;
         deleteDirOrFile($path) if -d $path;
   }
   closedir DIR;
   rmdir($dir) || print "Can not remove directory $dir: $!";
}

sub copyDirOrFile($) {
  my($path) = @_;
  $path .= '/' if($path !~ /\/$/);      
  for my $name (glob($path.'*')) {
    if( -d $name) {
      if( $name !~ m|.*work\.dir.*| ){
  mkdir("./work.dir/$name", 0700)
        || die "Cannot make directory $name: $!";
  copyDirOrFile($name);
}

    } else {
      my $file = $name;
if( $file =~ m|.*work\.dir.*| ){}
elsif( $file =~ m|.*\.java$| ){
     open (infile, "$file")
           || die "Cannot open input java file $file";
     if( $file =~ m|\.\/.*$| ){
        $file = substr($file,2)
     }
     open(outfile, ">./work.dir/$file")
         || die "Cannot open target file ./work.dir/$file";
     while (<infile> ) {
        my $line = $_;
        $line =~ s /<XMLReader>/ /g;
$line =~ s /<Object\[\]>/ /g;
$line =~ s /<String,Object>/ /g;
$line =~ s /<String,String>/ /g;

my $test = $line;
$test =~ s /<[a-zA-Z,]*>/<>/;
if( $test eq $line ){}
else{
  print("--- Check --- $line\n");
}

        print outfile "$line";
     }
     close(infile);
     close(outfile);
}

} } }

sub cleanClass($) {
  my($path) = @_;
  $path .= '/' if($path !~ /\/$/);      
  for my $name (glob($path.'*')) {
    if( -d $name) {
       cleanClass($name);
    } elsif( $name !~ m|.*\.class$| ) {
       unlink( $name );
} } }

if (-d "./work.dir") {
    deleteDirOrFile("work.dir")
                    || die "Cannot delete work.dir: $!";
}
mkdir("work.dir", 0700)
      || die "Cannot make directory work.dir: $!";
copyDirOrFile(".");
my $rtrn;
if( $javac eq ""){}
else{
  my $command = "cd work.dir; "
              . $javac
              . " *.java"
              . " */*.java"
              . " */*/*.java";
print "$command\n";
if( $rtrn = system($command) ){
   print "--- error --- failed to execute command\n";
}

  cleanClass("work.dir");

}
exit( $rtrn );

