/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = [ "LibESourceGroup" ];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

Cu.import("resource://edsintegration/LibGLib.jsm");
Cu.import("resource://edsintegration/libedataserver-ctypes.jsm");
Cu.import("resource://edsintegration/LibESource.jsm");

XPCOMUtils.defineLazyGetter(this, "ESourceGroup", function() {
  return ctypes.StructType("ESourceGroup");
});

XPCOMUtils.defineLazyGetter(this, "e_source_group_add_source", function() {
  var e_source_group_add_source =
   libedataserver.declare("e_source_group_add_source",
                          ctypes.default_abi,
                          LibGLib.gboolean,
                          ESourceGroup.ptr,
                          LibESource.ESource.ptr,
                          LibGLib.gint);
  if (!e_source_group_add_source)
    throw "e_source_group_add_source is unavailable";

  return e_source_group_add_source;
});


XPCOMUtils.defineLazyGetter(this, "e_source_group_peek_sources", function() {
  var e_source_group_peek_sources =
   libedataserver.declare("e_source_group_peek_sources",
                          ctypes.default_abi,
                          LibGLib.GSList.ptr,
                          ESourceGroup.ptr);
  if (!e_source_group_peek_sources)
    throw "e_source_group_peek_sources is unavailable";

  return e_source_group_peek_sources;
});

XPCOMUtils.defineLazyGetter(this, "e_source_group_peek_name", function() {
  var e_source_group_peek_name =
    libedataserver.declare("e_source_group_peek_name",
                           ctypes.default_abi,
                           LibGLib.gchar.ptr,
                           ESourceGroup.ptr);
  if (!e_source_group_peek_name)
    throw "e_source_group_peek_name is unavailable";

  return e_source_group_peek_name;
});

XPCOMUtils.defineLazyGetter(this, "e_source_group_remove_source", function() {
  var e_source_group_remove_source =
   libedataserver.declare("e_source_group_remove_source",
                          ctypes.default_abi,
                          LibGLib.gboolean,
                          ESourceGroup.ptr,
                          LibESource.ESource.ptr);
  if (!e_source_group_remove_source)
    throw "e_source_group_remove_source is unavailable";

  return e_source_group_remove_source;
});


var LibESourceGroup = {
  ESourceGroup: ESourceGroup,

  addSource: function LESG_addSource(aESourceGroup, aESource, aPosition) {
    return e_source_group_add_source(aESourceGroup, aESource, aPosition)
           == LibGLib.TRUE;
  },

  peekSources: function(aESourceGroup) {
    return e_source_group_peek_sources(aESourceGroup);
  },

  peekName: function(aESourceGroup) {
    return e_source_group_peek_name(aESourceGroup);
  },

  removeSource: function(aESourceGroup, aESource) {
    return e_source_group_remove_source(aESourceGroup, aESource)
           == LibGLib.TRUE;
  },
}
