/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherRC4;
import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.ExportControl;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import com.sun.net.ssl.internal.ssl.HexDumpEncoder;
import com.sun.net.ssl.internal.ssl.InputRecord;
import com.sun.net.ssl.internal.ssl.OutputRecord;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLInputStream;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;

public abstract class Handshaker
extends CipherSpec
implements ExportControl {
    public SSLSocketImpl conn;
    public MessageDigest[] md5;
    public MessageDigest[] sha1;
    public HandshakeInStream input;
    public HandshakeOutStream output;
    public int state;
    public SSLContextImpl sslContext;
    public d clnt_random;
    public d svr_random;
    public SSLSessionImpl session;
    public boolean resumingSession;
    public boolean enableNewSession = true;
    public static final Debug debug = Debug.getInstance("ssl");

    public Handshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, boolean bl2) throws NoSuchAlgorithmException {
        this.conn = sSLSocketImpl;
        this.resumingSession = false;
        this.session = null;
        this.md5 = this.a("MD5", bl2);
        this.sha1 = this.a("SHA", bl2);
        this.output = new HandshakeOutStream(this.v_major, this.v_minor, sSLSocketImpl, this.md5, this.sha1);
        this.input = new HandshakeInStream();
        this.input.a(this.md5, this.sha1);
        ((SSLInputStream)sSLSocketImpl.getInputStream()).a(this.md5, this.sha1);
        this.sslContext = sSLContextImpl;
        this.state = -1;
    }

    public void calculateConnectionKeys(byte[] byArray) throws NoSuchAlgorithmException {
        block15: {
            MessageDigest messageDigest = null;
            MessageDigest messageDigest2 = null;
            int n2 = this.algMAC.MAClen();
            int n3 = this.algCipher.keyMaterialSize();
            int n4 = this.algCipher.initVectorSize();
            int n5 = n2 + n3 + (this.is_exportable ? 0 : n4);
            byte[] byArray2 = new byte[n5 *= 2];
            if (this.v_minor == 0) {
                messageDigest = MessageDigest.getInstance("MD5");
                messageDigest2 = MessageDigest.getInstance("SHA");
                int n6 = 0;
                int n7 = n5;
                while (n7 > 0) {
                    int n8 = 0;
                    while (n8 <= n6) {
                        messageDigest2.update((byte)(65 + n6));
                        ++n8;
                    }
                    messageDigest2.update(byArray);
                    messageDigest2.update(this.svr_random.a);
                    messageDigest2.update(this.clnt_random.a);
                    messageDigest.update(byArray);
                    messageDigest.update(messageDigest2.digest());
                    System.arraycopy(messageDigest.digest(), 0, byArray2, n6 * 16, Math.min(n7, 16));
                    messageDigest.reset();
                    messageDigest2.reset();
                    ++n6;
                    n7 -= 16;
                }
            } else {
                g.a(byArray, "key expansion", this.svr_random.a, this.clnt_random.a, byArray2);
            }
            this.clntMacSecret = new byte[n2];
            this.svrMacSecret = new byte[n2];
            System.arraycopy(byArray2, 0, this.clntMacSecret, 0, n2);
            System.arraycopy(byArray2, n2, this.svrMacSecret, 0, n2);
            this.clntWriteKey = new byte[n3];
            this.svrWriteKey = new byte[n3];
            System.arraycopy(byArray2, 2 * n2, this.clntWriteKey, 0, n3);
            System.arraycopy(byArray2, 2 * n2 + n3, this.svrWriteKey, 0, n3);
            if (n4 != 0) {
                this.clntWriteIV = new byte[n4];
                this.svrWriteIV = new byte[n4];
                if (!this.is_exportable) {
                    System.arraycopy(byArray2, 2 * (n2 + n3), this.clntWriteIV, 0, n4);
                    System.arraycopy(byArray2, 2 * (n2 + n3) + n4, this.svrWriteIV, 0, n4);
                }
            } else {
                this.clntWriteIV = null;
                this.svrWriteIV = null;
            }
            if (this.is_exportable) {
                if (this.v_minor == 0) {
                    n3 = this.algCipher.keySize();
                    messageDigest.reset();
                    messageDigest.update(this.clntWriteKey);
                    messageDigest.update(this.clnt_random.a);
                    messageDigest.update(this.svr_random.a);
                    this.clntWriteKey = new byte[n3];
                    System.arraycopy(messageDigest.digest(), 0, this.clntWriteKey, 0, n3);
                    messageDigest.reset();
                    messageDigest.update(this.svrWriteKey);
                    messageDigest.update(this.svr_random.a);
                    messageDigest.update(this.clnt_random.a);
                    this.svrWriteKey = new byte[n3];
                    System.arraycopy(messageDigest.digest(), 0, this.svrWriteKey, 0, n3);
                    if (n4 != 0) {
                        messageDigest.reset();
                        messageDigest.update(this.clnt_random.a);
                        messageDigest.update(this.svr_random.a);
                        System.arraycopy(messageDigest.digest(), 0, this.clntWriteIV, 0, n4);
                        messageDigest.reset();
                        messageDigest.update(this.svr_random.a);
                        messageDigest.update(this.clnt_random.a);
                        System.arraycopy(messageDigest.digest(), 0, this.svrWriteIV, 0, n4);
                    }
                } else {
                    n3 = this.algCipher.keySize();
                    byte[] byArray3 = new byte[n3];
                    g.a(this.clntWriteKey, "client write key", this.clnt_random.a, this.svr_random.a, byArray3);
                    this.clntWriteKey = byArray3;
                    byte[] byArray4 = new byte[n3];
                    g.a(this.svrWriteKey, "server write key", this.clnt_random.a, this.svr_random.a, byArray4);
                    this.svrWriteKey = byArray4;
                    if (n4 != 0) {
                        byte[] byArray5 = new byte[2 * n4];
                        g.a(null, "IV block", this.clnt_random.a, this.svr_random.a, byArray5);
                        System.arraycopy(byArray5, 0, this.clntWriteIV, 0, n4);
                        System.arraycopy(byArray5, n4, this.svrWriteIV, 0, n4);
                    }
                }
            }
            if (debug == null || !Debug.isOn("keygen")) break block15;
            try {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("CONNECTION KEYGEN:");
                System.out.println("Client Nonce:");
                hexDumpEncoder.encodeBuffer(this.clnt_random.a, (OutputStream)System.out);
                System.out.println("Server Nonce:");
                hexDumpEncoder.encodeBuffer(this.svr_random.a, (OutputStream)System.out);
                System.out.println("Master Secret:");
                hexDumpEncoder.encodeBuffer(byArray, (OutputStream)System.out);
                System.out.println("Client MAC write Secret:");
                hexDumpEncoder.encodeBuffer(this.clntMacSecret, (OutputStream)System.out);
                System.out.println("Server MAC write Secret:");
                hexDumpEncoder.encodeBuffer(this.svrMacSecret, (OutputStream)System.out);
                System.out.println("Client write key:");
                hexDumpEncoder.encodeBuffer(this.clntWriteKey, (OutputStream)System.out);
                System.out.println("Server write key:");
                hexDumpEncoder.encodeBuffer(this.svrWriteKey, (OutputStream)System.out);
                if (this.clntWriteIV != null) {
                    System.out.println("Client write IV:");
                    hexDumpEncoder.encodeBuffer(this.clntWriteIV, (OutputStream)System.out);
                    System.out.println("Server write IV:");
                    hexDumpEncoder.encodeBuffer(this.svrWriteIV, (OutputStream)System.out);
                    break block15;
                }
                System.out.println("... no IV for cipher");
            }
            catch (IOException iOException) {}
        }
    }

    public void calculateKeys(byte[] byArray) throws NoSuchAlgorithmException {
        byte[] byArray2 = this.a(byArray);
        this.session.a(byArray2);
        this.calculateConnectionKeys(byArray2);
    }

    private byte[] a(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        MessageDigest messageDigest2 = MessageDigest.getInstance("SHA");
        byte[] byArray2 = new byte[48];
        if (debug != null && Debug.isOn("keygen")) {
            try {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("SESSION KEYGEN:");
                System.out.println("PreMaster Secret:");
                hexDumpEncoder.encodeBuffer(byArray, (OutputStream)System.out);
            }
            catch (IOException iOException) {}
        }
        if (this.v_minor == 0) {
            int n2 = 0;
            while (n2 < 3) {
                if (n2 != 0) {
                    messageDigest.reset();
                    messageDigest2.reset();
                }
                int n3 = 0;
                while (n3 <= n2) {
                    messageDigest2.update((byte)(65 + n2));
                    ++n3;
                }
                messageDigest2.update(byArray);
                messageDigest2.update(this.clnt_random.a);
                messageDigest2.update(this.svr_random.a);
                messageDigest.update(byArray);
                messageDigest.update(messageDigest2.digest());
                System.arraycopy(messageDigest.digest(), 0, byArray2, 16 * n2, 16);
                ++n2;
            }
        } else {
            g.a(byArray, "master secret", this.clnt_random.a, this.svr_random.a, byArray2);
        }
        return byArray2;
    }

    public abstract boolean canExchange(int var1, boolean var2);

    public abstract boolean canUseCipherSuite(String var1);

    private MessageDigest[] a(String string, boolean bl2) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        try {
            messageDigest.clone();
            MessageDigest[] messageDigestArray = new MessageDigest[]{messageDigest};
            return messageDigestArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (!bl2) {
                MessageDigest[] messageDigestArray = new MessageDigest[]{messageDigest, MessageDigest.getInstance(string)};
                return messageDigestArray;
            }
            MessageDigest[] messageDigestArray = new MessageDigest[]{messageDigest, MessageDigest.getInstance(string), MessageDigest.getInstance(string)};
            return messageDigestArray;
        }
    }

    public abstract HandshakeMessage getKickstartMessage() throws SSLException;

    public SSLSessionImpl getSession() {
        return this.session;
    }

    public abstract void a(byte var1) throws SSLProtocolException;

    public boolean isDone() {
        return this.state == 20;
    }

    public void kickstart() throws IOException {
        if (this.state >= 0) {
            return;
        }
        HandshakeMessage handshakeMessage = this.getKickstartMessage();
        if (debug != null && Debug.isOn("handshake")) {
            handshakeMessage.a(System.out);
        }
        handshakeMessage.write(this.output);
        this.output.flush();
        this.state = handshakeMessage.messageType();
    }

    public boolean maybeSetCipherSuite(byte by2, byte by3) {
        this.cipherSuite_b1 = by2;
        this.cipherSuite_b2 = by3;
        try {
            if (by2 == 0) {
                switch (by3) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        if (!this.isEnabled("SSL_RSA_WITH_NULL_MD5")) {
                            return false;
                        }
                        if (!this.canExchange(1, false)) {
                            return false;
                        }
                        this.is_exportable = true;
                        this.key_exchange_algorithm = 1;
                        this.setCipherType(0);
                        this.setMAC(1);
                        return true;
                    }
                    case 2: {
                        if (!this.isEnabled("SSL_RSA_WITH_NULL_SHA")) {
                            return false;
                        }
                        if (!this.canExchange(1, false)) {
                            return false;
                        }
                        this.is_exportable = true;
                        this.key_exchange_algorithm = 1;
                        this.setCipherType(0);
                        this.setMAC(2);
                        return true;
                    }
                    case 3: {
                        if (!this.isEnabled("SSL_RSA_EXPORT_WITH_RC4_40_MD5")) {
                            return false;
                        }
                        if (!CipherRC4.hasRC4()) {
                            return false;
                        }
                        if (!this.canExchange(2, true)) {
                            return false;
                        }
                        this.is_exportable = true;
                        this.key_exchange_algorithm = 2;
                        this.setCipherType(1);
                        this.setMAC(1);
                        return true;
                    }
                    case 4: {
                        if (!this.isEnabled("SSL_RSA_WITH_RC4_128_MD5")) {
                            return false;
                        }
                        if (!CipherRC4.hasRC4()) {
                            return false;
                        }
                        if (!this.canExchange(1, false)) {
                            return false;
                        }
                        this.is_exportable = false;
                        this.key_exchange_algorithm = 1;
                        this.setCipherType(1);
                        this.setMAC(1);
                        return true;
                    }
                    case 5: {
                        if (!this.isEnabled("SSL_RSA_WITH_RC4_128_SHA")) {
                            return false;
                        }
                        if (!CipherRC4.hasRC4()) {
                            return false;
                        }
                        if (!this.canExchange(1, false)) {
                            return false;
                        }
                        this.is_exportable = false;
                        this.key_exchange_algorithm = 1;
                        this.setCipherType(1);
                        this.setMAC(2);
                        return true;
                    }
                    case 9: {
                        if (!this.isEnabled("SSL_RSA_WITH_DES_CBC_SHA")) {
                            return false;
                        }
                        if (!this.canExchange(1, false)) {
                            return false;
                        }
                        this.is_exportable = false;
                        this.key_exchange_algorithm = 1;
                        this.setCipherType(3);
                        this.setMAC(2);
                        return true;
                    }
                    case 10: {
                        if (!this.isEnabled("SSL_RSA_WITH_3DES_EDE_CBC_SHA")) {
                            return false;
                        }
                        if (!this.canExchange(1, false)) {
                            return false;
                        }
                        this.is_exportable = false;
                        this.key_exchange_algorithm = 1;
                        this.setCipherType(4);
                        this.setMAC(2);
                        return true;
                    }
                    case 17: {
                        if (!this.isEnabled("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA")) {
                            return false;
                        }
                        if (!this.canExchange(6, true)) {
                            return false;
                        }
                        this.is_exportable = true;
                        this.key_exchange_algorithm = 6;
                        this.setCipherType(5);
                        this.setMAC(2);
                        return true;
                    }
                    case 18: {
                        if (!this.isEnabled("SSL_DHE_DSS_WITH_DES_CBC_SHA")) {
                            return false;
                        }
                        if (!this.canExchange(6, false)) {
                            return false;
                        }
                        this.is_exportable = false;
                        this.key_exchange_algorithm = 6;
                        this.setCipherType(3);
                        this.setMAC(2);
                        return true;
                    }
                    case 19: {
                        if (!this.isEnabled("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA")) {
                            return false;
                        }
                        if (!this.canExchange(6, false)) {
                            return false;
                        }
                        this.is_exportable = false;
                        this.key_exchange_algorithm = 6;
                        this.setCipherType(4);
                        this.setMAC(2);
                        return true;
                    }
                    case 23: {
                        if (!this.isEnabled("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5")) {
                            return false;
                        }
                        if (!CipherRC4.hasRC4()) {
                            return false;
                        }
                        if (!this.canExchange(7, true)) {
                            return false;
                        }
                        this.is_exportable = true;
                        this.key_exchange_algorithm = 7;
                        this.setCipherType(1);
                        this.setMAC(1);
                        return true;
                    }
                    case 24: {
                        if (!this.isEnabled("SSL_DH_anon_WITH_RC4_128_MD5")) {
                            return false;
                        }
                        if (!CipherRC4.hasRC4()) {
                            return false;
                        }
                        if (!this.canExchange(7, false)) {
                            return false;
                        }
                        this.is_exportable = false;
                        this.key_exchange_algorithm = 7;
                        this.setCipherType(1);
                        this.setMAC(1);
                        return true;
                    }
                    case 25: {
                        if (!this.isEnabled("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA")) {
                            return false;
                        }
                        if (!this.canExchange(7, true)) {
                            return false;
                        }
                        this.is_exportable = true;
                        this.key_exchange_algorithm = 7;
                        this.setCipherType(5);
                        this.setMAC(2);
                        return true;
                    }
                    case 26: {
                        if (!this.isEnabled("SSL_DH_anon_WITH_DES_CBC_SHA")) {
                            return false;
                        }
                        if (!this.canExchange(7, false)) {
                            return false;
                        }
                        this.is_exportable = false;
                        this.key_exchange_algorithm = 7;
                        this.setCipherType(3);
                        this.setMAC(2);
                        return true;
                    }
                    case 27: {
                        if (!this.isEnabled("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA")) {
                            return false;
                        }
                        if (!this.canExchange(7, false)) {
                            return false;
                        }
                        this.is_exportable = false;
                        this.key_exchange_algorithm = 7;
                        this.setCipherType(4);
                        this.setMAC(2);
                        return true;
                    }
                }
                return false;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public abstract void processMessage(byte var1, int var2) throws IOException, NoSuchAlgorithmException;

    public void process_record(InputRecord inputRecord) throws IOException, NoSuchAlgorithmException {
        this.input.incomingRecord(inputRecord);
        while (this.input.available() > 0) {
            this.input.mark(4);
            byte by2 = this.input.g();
            int n2 = this.input.e();
            if (this.input.available() < n2) {
                this.input.reset();
                return;
            }
            if (by2 == 0) {
                this.input.reset();
                this.processMessage(by2, n2);
                this.input.a(4 + n2);
            } else {
                this.input.mark(n2);
                this.processMessage(by2, n2);
                this.input.digestNow();
            }
            if (by2 != 1) continue;
            this.input.reset();
            this.input.skip(n2);
        }
    }

    public void sendChangeCipherSpec(HandshakeMessage.Finished finished) throws IOException {
        this.output.flush();
        Object object = this.conn.s;
        synchronized (object) {
            OutputRecord outputRecord = new OutputRecord(this.v_major, this.v_minor, 20);
            outputRecord.write(1);
            this.conn.a(outputRecord);
            this.conn.a();
            if (debug != null && Debug.isOn("handshake")) {
                finished.a(System.out);
            }
            finished.write(this.output);
            this.output.flush();
        }
    }

    public boolean started() {
        return this.state >= 0;
    }
}

