/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.sql;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.sql.DataSource;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.sql.DataSourceWrapper;

public class DataSourceUtil {
    private static final String ESCAPE = "\\";
    private static final String TOKEN = ",";

    static DataSource getDataSource(Object object, PageContext pageContext) throws JspException {
        DataSource dataSource = null;
        if (object == null) {
            object = Config.find((PageContext)pageContext, (String)"javax.servlet.jsp.jstl.sql.dataSource");
        }
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            try {
                InitialContext initialContext = new InitialContext();
                Context context = (Context)initialContext.lookup("java:comp/env");
                dataSource = (DataSource)context.lookup((String)object);
            }
            catch (NamingException namingException) {
                dataSource = DataSourceUtil.getDataSource((String)object);
            }
        } else if (object instanceof DataSource) {
            dataSource = (DataSource)object;
        } else {
            throw new JspException(Resources.getMessage("SQL_DATASOURCE_INVALID_TYPE"));
        }
        return dataSource;
    }

    private static DataSource getDataSource(String string) throws JspException {
        DataSourceWrapper dataSourceWrapper = new DataSourceWrapper();
        String[] stringArray = new String[4];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (TOKEN.indexOf(c) != -1 && n == 0) {
                stringArray[n2] = string.substring(n3, i);
                n3 = i + 1;
                if (++n2 > 4) {
                    throw new JspTagException(Resources.getMessage("JDBC_PARAM_COUNT"));
                }
            }
            if (ESCAPE.indexOf(c) != -1) {
                ++n;
                continue;
            }
            n = 0;
        }
        stringArray[n2] = string.substring(n3);
        dataSourceWrapper.setJdbcURL(stringArray[0]);
        if (stringArray[1] != null) {
            try {
                dataSourceWrapper.setDriverClassName(stringArray[1]);
            }
            catch (Exception exception) {
                throw new JspTagException(Resources.getMessage("DRIVER_INVALID_CLASS", exception.toString()), (Throwable)exception);
            }
        }
        dataSourceWrapper.setUserName(stringArray[2]);
        dataSourceWrapper.setPassword(stringArray[3]);
        return dataSourceWrapper;
    }
}

