/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.core;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;

public class Config {
    public static final String FMT_LOCALE = "javax.servlet.jsp.jstl.fmt.locale";
    public static final String FMT_FALLBACK_LOCALE = "javax.servlet.jsp.jstl.fmt.fallbackLocale";
    public static final String FMT_LOCALIZATION_CONTEXT = "javax.servlet.jsp.jstl.fmt.localizationContext";
    public static final String FMT_TIME_ZONE = "javax.servlet.jsp.jstl.fmt.timeZone";
    public static final String SQL_DATA_SOURCE = "javax.servlet.jsp.jstl.sql.dataSource";
    public static final String SQL_MAX_ROWS = "javax.servlet.jsp.jstl.sql.maxRows";
    private static final String PAGE_SCOPE_SUFFIX = ".page";
    private static final String REQUEST_SCOPE_SUFFIX = ".request";
    private static final String SESSION_SCOPE_SUFFIX = ".session";
    private static final String APPLICATION_SCOPE_SUFFIX = ".application";

    public static Object get(PageContext pageContext, String string, int n) {
        switch (n) {
            case 1: {
                return pageContext.getAttribute(string + PAGE_SCOPE_SUFFIX, n);
            }
            case 2: {
                return pageContext.getAttribute(string + REQUEST_SCOPE_SUFFIX, n);
            }
            case 3: {
                return Config.get(pageContext.getSession(), string);
            }
            case 4: {
                return pageContext.getAttribute(string + APPLICATION_SCOPE_SUFFIX, n);
            }
        }
        throw new IllegalArgumentException("unknown scope");
    }

    public static Object get(ServletRequest servletRequest, String string) {
        return servletRequest.getAttribute(string + REQUEST_SCOPE_SUFFIX);
    }

    public static Object get(HttpSession httpSession, String string) {
        Object object = null;
        if (httpSession != null) {
            try {
                object = httpSession.getAttribute(string + SESSION_SCOPE_SUFFIX);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return object;
    }

    public static Object get(ServletContext servletContext, String string) {
        return servletContext.getAttribute(string + APPLICATION_SCOPE_SUFFIX);
    }

    public static void set(PageContext pageContext, String string, Object object, int n) {
        switch (n) {
            case 1: {
                pageContext.setAttribute(string + PAGE_SCOPE_SUFFIX, object, n);
                break;
            }
            case 2: {
                pageContext.setAttribute(string + REQUEST_SCOPE_SUFFIX, object, n);
                break;
            }
            case 3: {
                pageContext.setAttribute(string + SESSION_SCOPE_SUFFIX, object, n);
                break;
            }
            case 4: {
                pageContext.setAttribute(string + APPLICATION_SCOPE_SUFFIX, object, n);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown scope");
            }
        }
    }

    public static void set(ServletRequest servletRequest, String string, Object object) {
        servletRequest.setAttribute(string + REQUEST_SCOPE_SUFFIX, object);
    }

    public static void set(HttpSession httpSession, String string, Object object) {
        httpSession.setAttribute(string + SESSION_SCOPE_SUFFIX, object);
    }

    public static void set(ServletContext servletContext, String string, Object object) {
        servletContext.setAttribute(string + APPLICATION_SCOPE_SUFFIX, object);
    }

    public static void remove(PageContext pageContext, String string, int n) {
        switch (n) {
            case 1: {
                pageContext.removeAttribute(string + PAGE_SCOPE_SUFFIX, n);
                break;
            }
            case 2: {
                pageContext.removeAttribute(string + REQUEST_SCOPE_SUFFIX, n);
                break;
            }
            case 3: {
                pageContext.removeAttribute(string + SESSION_SCOPE_SUFFIX, n);
                break;
            }
            case 4: {
                pageContext.removeAttribute(string + APPLICATION_SCOPE_SUFFIX, n);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown scope");
            }
        }
    }

    public static void remove(ServletRequest servletRequest, String string) {
        servletRequest.removeAttribute(string + REQUEST_SCOPE_SUFFIX);
    }

    public static void remove(HttpSession httpSession, String string) {
        httpSession.removeAttribute(string + SESSION_SCOPE_SUFFIX);
    }

    public static void remove(ServletContext servletContext, String string) {
        servletContext.removeAttribute(string + APPLICATION_SCOPE_SUFFIX);
    }

    public static Object find(PageContext pageContext, String string) {
        Object object = Config.get(pageContext, string, 1);
        if (object == null && (object = Config.get(pageContext, string, 2)) == null) {
            if (pageContext.getSession() != null) {
                object = Config.get(pageContext, string, 3);
            }
            if (object == null && (object = Config.get(pageContext, string, 4)) == null) {
                object = pageContext.getServletContext().getInitParameter(string);
            }
        }
        return object;
    }
}

