arch_get_kernel_flavour () {
	VENDOR=`grep '^vendor_id' "$CPUINFO" | head -n1 | cut -d: -f2`
	case "$VENDOR" in
		" AuthenticAMD"*)	echo amd64-k8 ;;
		" GenuineIntel"*)	echo em64t-p4 ;;
		*)			echo amd64-generic ;;
	esac
	return 0
}

arch_check_usable_kernel () {
	# Generic and server kernels can be run on any machine.
	if expr "$1" : '.*-server.*' >/dev/null; then return 0; fi
	if expr "$1" : '.*-generic.*' >/dev/null; then return 0; fi
	if expr "$1" : '.*-virtual.*' >/dev/null; then return 0; fi
	if expr "$1" : '.*-xen.*' >/dev/null; then return 0; fi
	if expr "$1" : '.*-rt.*' >/dev/null; then return 0; fi

	return 1
}

arch_get_kernel () {
	echo "linux-generic"
	echo "linux-image-generic"

	echo "linux-server"
	echo "linux-image-server"

	echo "linux-virtual"
	echo "linux-image-virtual"

	echo "linux-xen"
	echo "linux-image-xen"

	echo "linux-rt"
	echo "linux-image-rt"
}
