<?
	/**
	 * Create the images for the Firefox extensions dialog in the specified
	 * directory.
	 */
	function createExtensions($dir) {
		renderExtensions($dir.'actionbuttons.png', 21);
		
		renderMisc($dir);
	}
	
	/**
	 * Render a complete toolbar image to a given file.
	 *
	 * The columns are:
	 * Delete, Update, Apply, Properties
	 *
	 * The rows are:
	 * Normal, Disabled
	 */
	function renderExtensions($filename, $size) {
		// define the icons to render
		$icons = array(
			array(ACTIONS, 'edit-delete'),
			array(ACTIONS, 'view-refresh'),
			array(ACTIONS, 'dialog-apply'),
			array(CATEGORIES, 'gnome-control-center')
		);
		
		// compose the first rows of the toolbar
		$firstrow = renderRow($icons, $size);
		$disabled = renderDisabled($firstrow);
		
		// create single PNG containing all states
		$states = array($firstrow, $disabled);
		$extensions =
			renderColumnFromPngs(
				$states, count($icons) * $size, $size);
		copy($extensions, $filename);
	}
	
	/**
	 * Render miscellaneous icons for extensions dialogs.
	 */
	function renderMisc($dir) {
		$themes =
			getPngFilenameFor(
				APPS, 'preferences-desktop-theme', 32);
		copy($themes, $dir.'themeGeneric.png');

		$small =
			getPngFilenameFor(ACTIONS, 'extension', 16);
		copy($small, $dir.'../update/update.png');
		
		$large =
			getPngFilenameFor(ACTIONS, 'extension', 32);
		copy($large,
			$dir.'../xpinstall/xpinstallItemGeneric.png');		
	}
	
?>