<?
	/**
	 * Create the images for the Firefox global icons in the specified
	 * directory.
	 */
	function createGlobalIcons($dir) {
		renderFolderItems($dir.'folder-item.png', 16);
		
		renderWarnings($dir);
		
		renderOrientations($dir);
	}
	
	/**
	 * Render the folder items to a given file.
	 *
	 * The columns are:
	 * File, Folder
	 *
	 * The rows are:
	 * Normal, Hover, Disabled
	 */
	function renderFolderItems($filename, $size) {
		// define the icons to render
		$icons = array(
			array(MIMETYPES, 'text-html'),
			array(PLACES, 'folder')
		);
		
		// compose the first and last row of the image
		$firstrow = renderRow($icons, $size);
		$thirdrow = renderSemiTransparent($firstrow);
		
		// second row only contains open folder
		$icons2 = array(
			null,
			getFolderOpen()
		);
		$secondrow = renderRow($icons2, $size);
		
		// create single PNG containing all states
		$states = array($firstrow, $secondrow, $thirdrow);
		$folderitems =
			renderColumnFromPngs(
				$states, count($icons) * $size, $size);
		copy($folderitems, $filename);
	}

	/**
	 * Render question, warning and error icons to a given directory.
	 */
	function renderWarnings($dir) {
		$question = getPngFilenameFor(APPS, 'help-browser', 32);
		copy($question, $dir.'Question.png');
	
		$notfound = getPngFilenameFor(STATUS, 'dialog-warning', 16);
		copy($notfound, $dir.'notfound.png');

		$warning = getPngFilenameFor(STATUS, 'dialog-warning', 32);
		copy($warning, $dir.'Warning.png');
		
		$warninglarge = getPngFilenameFor(STATUS, 'dialog-warning', 48);
		copy($warninglarge, $dir.'warning-large.png');

		$error = getPngFilenameFor(STATUS, 'dialog-error', 32);
		copy($error, $dir.'Error.png');
	}
	
	/**
	 * Get the image for the open folder.
	 * 
	 * TODO - symlink folder-open in human-icons package?
	 */
	function getFolderOpen() {
		return array(STATUS, 'folder-open');
	}
	
	/**
	 * Render the icons for landscape, portrait and
	 * combined page orientations.
	 */
	function renderOrientations($dir) {
		// copy custom icons (TODO)
		$landscape =
			getPngFilenameFor(STATUS, 'landscape', 24);
		$portrait =
			getPngFilenameFor(STATUS, 'portrait', 24);

		copy($landscape, $dir.'Landscape.png');
		copy($portrait, $dir.'Portrait.png');
		
		// create composition
		$icons = array(
			array(STATUS, 'portrait'),
			array(STATUS, 'landscape')
		);
		$printpreview = renderRow($icons, 24);
		
		copy($printpreview, $dir.'Print-preview.png');
	}
	
?>