<?
	/**
	 * Create the images for the Firefox toolbar in the specified
	 * directory.
	 */
	function createToolbars($dir) {
		renderToolbar($dir.'Toolbar.png', 24);
		renderToolbar($dir.'Toolbar-small.png', 16);
	}
	
	/**
	 * Render a complete toolbar image to a given file.
	 *
	 * The columns are:
	 * Back, Forward, Stop, Refresh, Home, Downloads, History, Bookmarks,
	 * Print, New Tab, New Window, Cut, Copy, Paste, Mail.
	 *
	 * The rows are:
	 * Normal, Hover, Disabled, "Open Bookmarks"
	 */
	function renderToolbar($filename, $size) {
		// define the icons to render
		$icons = array(
			array(ACTIONS, 'back'),
			array(ACTIONS, 'forward'),
			array(ACTIONS, 'stop'),
			array(ACTIONS, 'view-refresh'),
			array(ACTIONS, 'go-home'),
			array(MIMETYPES, 'package'),
			getHistoryIcon(),
			getBookmarkIcon(),
			array(ACTIONS, 'document-print'),
			array(ACTIONS, 'tab-new'),
			array(ACTIONS, 'window-new'),
			array(ACTIONS, 'edit-cut'),
			array(ACTIONS, 'edit-copy'),
			array(ACTIONS, 'edit-paste'),
			array(APPS, 'internet-mail')
		);
		
		// compose the first rows of the toolbar
		$firstrow = renderRow($icons, $size);
		$highlight = renderHighlight($firstrow);
		$disabled = renderDisabled($firstrow);
		
		// last row contains the "open bookmarks" icon
		$lasticons =
			array(
				null, null, null, null, null, null, null,
				getOpenBookmarkIcon(), null, null,
				null, null, null, null, null);
		$lastrow = renderRow($lasticons, $size);  
		
		// create single PNG containing all states
		$states = array($firstrow, $highlight, $disabled, $lastrow);
		$toolbar =
			renderColumnFromPngs(
				$states, count($icons) * $size, $size);
		copy($toolbar, $filename);
	}
	
	/**
	 * Get the icon for the standard bookmark function.
	 */
	function getBookmarkIcon() {
		// return a custom icon (TODO)
		return array(PLACES, 'bookmark');
	}
	
	/**
	 * Get the icon for the open bookmark function.
	 */
	function getOpenBookmarkIcon() {
		// return the normal bookmark icon (TODO)
		return getBookmarkIcon();
	}
	
	/**
	 * Get the icon for the history function.
	 */
	function getHistoryIcon() {
		// return a custom icon (TODO)
		return array(PLACES, 'history');
	}
	
?>